import { HttpRouteAuthorizerBindOptions, HttpRouteAuthorizerConfig, IHttpRouteAuthorizer } from '@aws-cdk/aws-apigatewayv2-alpha';
import { IUserPool, IUserPoolClient } from 'aws-cdk-lib/aws-cognito';
/**
 * (experimental) Properties to initialize UserPoolAuthorizer.
 *
 * @experimental
 */
export interface UserPoolAuthorizerProps {
    /**
     * (experimental) The user pool client that should be used to authorize requests with the user pool.
     *
     * @experimental
     */
    readonly userPoolClient: IUserPoolClient;
    /**
     * (experimental) The associated user pool.
     *
     * @experimental
     */
    readonly userPool: IUserPool;
    /**
     * (experimental) The AWS region in which the user pool is present.
     *
     * @default - same region as the Route the authorizer is attached to.
     * @experimental
     */
    readonly userPoolRegion?: string;
    /**
     * (experimental) The name of the authorizer.
     *
     * @default 'UserPoolAuthorizer'
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @default ['$request.header.Authorization']
     * @experimental
     */
    readonly identitySource?: string[];
}
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
export declare class HttpUserPoolAuthorizer implements IHttpRouteAuthorizer {
    private readonly props;
    private authorizer?;
    /**
     * @experimental
     */
    constructor(props: UserPoolAuthorizerProps);
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
