// -*- coding: utf-8 -*-
// Encrypted ODOO Module C++ Source
// Generated by ODOO Encryption Tool

#ifdef _MSC_VER
// MSVC编译器特定指令：指定源文件编码和禁用编码警告
#pragma execution_character_set("utf-8")
#pragma warning(disable: 4819)
#endif

#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
#include <pybind11/eval.h>

namespace py = pybind11;


// Encrypted code for models\fast_vendor.py
const char* encrypted_code_models_fast_vendor_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\n\nclass FastVendor(models.Model):\n    _name = 'fast.vendor'\n    _description = '外发加工厂'\n\n    name = fields.Char('VENDOR')\n    user_ids = fields.Many2many('res.users', string='绑定用户')\n\n    _sql_constraints = [\n        ('uniq_name', 'unique(name)', '加工厂不能重复')\n    ]";

void load_models_fast_vendor(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_fast_vendor_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\ir_actions_report.py
const char* encrypted_code_models_ir_actions_report_part0 = "from odoo import api\nfrom odoo.addons.base.models.ir_actions_report import IrActionsReport\n\nfrom odoo.tools import check_barcode_encoding, config, is_html_empty, parse_version\nfrom reportlab.graphics.barcode import createBarcodeDrawing\n\n@api.model\ndef re_barcode(self, barcode_type, value, **kwargs):\n    defaults = {\n        'width': (600, int),\n        'height': (100, int),\n        'humanreadable': (False, lambda x: bool(int(x))),\n        'quiet': (True, lambda x: bool(int(x))),\n        'mask': (None, lambda x: x),\n        'barBorder': (4, int),\n        # The QR code can have different layouts depending on the Error Correction Level\n        # See: https://en.wikipedia.org/wiki/QR_code#Error_correction\n\n        'barLevel': ('L', lambda x: x in ('L', 'M', 'Q', 'H') and x or 'L'),\n    }\n    kwargs = {k: validator(kwargs.get(k, v)) for k, (v, validator) in defaults.items()}\n    kwargs['humanReadable'] = kwargs.pop('humanreadable')\n\n    if barcode_type == 'UPCA' and len(value) in (11, 12, 13):\n        barcode_type = 'EAN13'\n        if len(value) in (11, 12):\n            value = '0%s' % value\n    elif barcode_type == 'C-UPCA' and len(value) in (11, 12, 13):\n        barcode_type = 'UPCA'\n    elif barcode_type == 'auto':\n        symbology_guess = {8: 'EAN8', 13: 'EAN13'}\n        barcode_type = symbology_guess.get(len(value), 'Code128')\n    elif barcode_type == 'DataMatrix':\n        # Prevent a crash due to a lib change from pylibdmtx to reportlab\n        barcode_type = 'ECC200DataMatrix'\n    elif barcode_type == 'QR':\n        # for `QR` type, `quiet` is not supported. And is simply ignored.\n        # But we can use `barBorder` to get a similar behaviour.\n        if kwargs['quiet']:\n            kwargs['barBorder'] = 0\n\n    if barcode_type in ('EAN8', 'EAN13') and not check_barcode_encoding(value, barcode_type):\n        # If the barcode does not respect the encoding specifications, convert its type into Code128.\n        # Otherwise, the report-lab method may return a barcode different from its value. For instance,\n        # if the barcode type is EAN-8 and the value 11111111, the report-lab method will take the first\n        # seven digits and will compute the check digit, which gives: 11111115 -> the barcode does not\n        # match the expected value.\n        barcode_type = 'Code128'\n\n    try:\n        barcode = createBarcodeDrawing(barcode_type, value=value, format='png', **kwargs)\n\n        # If a mask is asked and it is available, call its function to\n        # post-process the generated QR-code image\n        if kwargs['mask']:\n            available_masks = self.get_available_barcode_masks()\n            mask_to_apply = available_masks.get(kwargs['mask'])\n            if mask_to_apply:\n                mask_to_apply(kwargs['width'], kwargs['height'], barcode)\n\n        return barcode.asString('png')\n    except (ValueError, AttributeError):\n        if barcode_type == 'Code128':\n            raise ValueError(\"Cannot convert into barcode.\")\n        elif barcode_type == 'QR':\n            raise ValueError(\"Cannot convert into QR code.\")\n        else:\n            return self.barcode('Code128', value, **kwargs)\n\nIrActionsReport.barcode = re_barcode";

void load_models_ir_actions_report(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_ir_actions_report_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\maxima_certificate_conformity.py
const char* encrypted_code_models_maxima_certificate_conformity_part0 = "from odoo import models, fields, api, _\nfrom odoo.exceptions import UserError\n\nclass MaximaCertificateConformity(models.Model):\n    _name = 'maxima.certificate.conformity'\n    _description = '合格证'\n    _order = 'id desc'\n\n    brand = fields.Char('品牌')\n    name = fields.Char('品名')\n    style = fields.Char('款号')\n    color = fields.Char('颜色')\n    spec = fields.Char('规格')\n    ingredients = fields.Char('成分')\n    standard = fields.Char('执行标准')\n    technology = fields.Char('安全技术类别')\n    level = fields.Char('等级')\n    country = fields.Char('产地')\n    distributor = fields.Char('经销商')\n    address = fields.Char('地址')\n    manufacturer = fields.Char('生产商')\n    price = fields.Float('价格')\n    upc = fields.Char('UPC')\n    product_qty = fields.Integer('数量', default=1)\n\n    def action_upc_direct_print(self, type, qty=0):\n        print_data = ''\n        upc_tp = False\n        if type == 'single':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'hgz_single')], limit=1)\n        elif type == 'double':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'hgz_double')], limit=1)\n        else:\n            pass\n        if upc_tp:\n            print_data = upc_tp.header_content\n            for order in self:\n                range_qty = int(qty) if int(qty) > 0 else int(order.product_qty)\n                for x in range(range_qty):\n                    print_data += upc_tp.content.format(\n                        brand=order.brand,\n                        name=order.name,\n                        style=order.style,\n                        color=order.color,\n                        size=order.spec,\n                        spec=order.ingredients,\n                        biaozhun=order.standard,\n                        level=order.level,\n                        location=order.country,\n                        jxs=order.distributor,\n                        address=order.address,\n                        vendor=order.manufacturer,\n                        msrp=f'{float(order.price):.2f}',\n                        barcode=order.upc,\n                        technology=order.technology or '',\n                    )\n        return print_data\n\n    def btn_print_certificate_scan(self):\n        action = self.env.ref('leda_upc.action_reset_certificate_scan_client').sudo().read()[0]\n        action['context'] = self.env.context.copy()\n        return action\n\n";

void load_models_maxima_certificate_conformity(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_maxima_certificate_conformity_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\maxima_order_upc.py
const char* encrypted_code_models_maxima_order_upc_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\nimport re\n\nclass MaximaOrderUpc(models.Model):\n    _name = 'maxima.order.upc'\n    _description = 'PO UPC'\n    _order = 'id desc'\n\n    vendor = fields.Many2one('fast.vendor', string='VENDOR')\n    po_date = fields.Date('PO Date', required=1)\n    po = fields.Char('PO NUM', required=1)\n    smu = fields.Char('PO REF')\n    stock_to_make = fields.Char('STOCK NO', required=1)\n    size = fields.Char('SIZE', required=1)\n    pf_sku = fields.Char('SKU')\n    color = fields.Char('COLOR', required=1)\n    qty_ordered = fields.Integer('Qty_Ordered', required=1)\n    qty_received = fields.Integer('Qty_received')\n    upc = fields.Char('UPC', required=1)\n    msrp = fields.Float('MSRP', required=1)\n    line_memo = fields.Char('LINE MEMO')\n    po_memo = fields.Char('PO MEMO')\n    entity_id = fields.Many2one('upc.entity', string='Entity UPC')\n    entity = fields.Char(string='Entity', required=1)\n    ticketing = fields.Char('Ticketing')\n    price_to_print = fields.Char('Price to Print')\n    currency = fields.Char('Currency',  store=True)\n    currency_code = fields.Char('Currency Code',  store=True)\n    style_description = fields.Text('Style Description')\n    season = fields.Char('QTR-CAPSULE')\n    reminder = fields.Char('Label reminder')\n    custom_po = fields.Char('CUSTOM PO 1')\n    plm_msrp = fields.Char('PLM MSRP')\n\n    def name_get(self):\n        return [(x.id, f'{x.stock_to_make}-{x.size}') for x in self]\n\n    @api.model\n    def _name_search(self, name, args=None, operator='ilike', limit=100, name_get_uid=None):\n        args = args or []\n        if name:\n            args = [('stock_to_make', operator, name)] + args\n        return self._search(args, limit=limit, access_rights_uid=name_get_uid)\n\n    def btn_match_currency(self):\n        self.compute_currency_code()\n\n    @api.depends('entity')\n    def compute_currency_code(self):\n        # usa_entity = self.env.ref('leda_upc.entity_USA')\n        for order in self:\n            if order.entity:\n                entity = self.env['upc.entity'].search([('name', '=', order.entity)], limit=1)\n                if entity:\n                    order.currency_code = entity.currency_code\n                    order.currency = entity.currency\n                    order.reminder = entity.reminder\n                else:\n                    order.currency_code = 'USD'\n                    order.currency = '$'\n                    order.reminder = ''\n            else:\n                order.currency_code = ''\n                order.currency = ''\n                order.reminder = ''\n\n    def __get_smu(self, entity_id):\n        smu = ''\n\n        if self.smu:\n            if self.smu.isnumeric():\n                smu = 'PRO'\n            else:\n                smu = self.smu\n        else:\n            if self.entity == 'Hudson US' or self.entity.startswith('Hu'):\n                if self.stock_to_make.startswith('E'):\n                    smu = 'ET'\n                else:\n                    smu = 'HD'\n            elif self.entity == 'FreezeMax US' or self.entity.startswith('Free'):\n                smu = 'FM'\n            elif self.entity == 'Roku US' or self.entity.startswith('Roku'):\n                smu = 'RK'\n            elif self.entity == 'Wedding Cake US' or self.entity.startswith('Wed'):\n                smu = 'WC'\n            else:\n                smu = 'PRO'\n        return smu\n\n    def __get_currency_price(self, entity_id, smu):\n        entity_currency_show = entity_id.upc_display\n        currency = entity_currency_show\n        new_msrp = 0\n        if smu == 'FA' and entity_currency_show == '$':\n            msrp = ''\n        elif smu == 'AMA':\n            msrp = ''\n        else:\n            price_to_print = self.price_to_print or 0\n            if price_to_print:\n                price_to_print = f'{float(price_to_print):.2f}'\n            msrp = f'{entity_currency_show}{price_to_print}'\n            new_msrp = price_to_print\n        if not new_msrp:\n            msrp = ''\n        return currency, msrp ,new_msrp\n\n    def _get_size(self, entity_id):\n        if not entity_id or not len(entity_id.size_ids):\n            return self.size\n        else:\n            size_id = entity_id.size_ids.filtered(lambda x: x.name == self.size)\n            if len(size_id):\n                return size_id[0].upc_display_name\n            else:\n                return self.size\n\n    def _get_upc_init_data(self, type):\n        entity_id = self.env['upc.entity'].search([('name', '=', self.entity)])\n        if not entity_id:\n            raise UserError('Entity:[%s],在配置文件中没有找到，请联系管理员' % self.entity)\n        if len(entity_id) > 1:\n            raise UserError('Entity:[%s],在配置文件中找到多个，请联系管理员' % self.entity)\n\n        smu = self.__get_smu(entity_id)\n        po_date = self.po_date.strftime('%y%m')\n        upc_code = '{}{}{}'.format(self.po, smu, po_date)\n        color = self.color\n        if len(color) > 9:\n            color = self.stock_to_make.split('-')[-1]\n        currency, msrp, new_msrp = self.__get_currency_price(entity_id,smu)\n\n        barcode_cmd = ''\n\n        upc = self.upc.replace(' ', '')\n        if len(upc) == 12:\n            if type == 'single':\n                barcode_cmd = f\"\"\"\n^BY2,2,107^FT27,284^BUN,,Y,N,Y\n^FH\\^FD{upc}^FS\n                \"\"\"\n            elif type == 'double':\n                barcode_cmd = f\"\"\"\n^BY2,2,107^FT27,284^BUN,,Y,N,Y\n^FH\\^FD{upc}^FS\n^BY2,2,107^FT284,284^BUN,,Y,N,Y\n^FH\\^FD{upc}^FS\n                 \"\"\"\n            elif type == 'cycle':\n                barcode_cmd = f\"\"\"\n^BY2,2,100^FT87,237^BUN,,Y,N,Y\n^FH\\^FD{upc}^FS\n                \"\"\"\n            elif type == 'normal':\n                barcode_cmd = f\"\"\"\n^BY2,2,107^FT293,213^BUB,,Y,N,Y\n^FH\\^FD{upc}^FS\n                \"\"\"\n            else:\n                raise UserError(f'UPC[{upc}]位数只有{len(upc)},暂不支持该标签类型！' )\n\n        else:\n            if type == 'single':\n                barcode_cmd = f\"\"\"\n^BY1,1,120^FT30,300^BCN,,Y,N\n^FD{upc}^FS\n                \"\"\"\n            elif type == 'double':\n                barcode_cmd = f\"\"\"\n^BY1,1,120^FT30,300^BCN,,Y,N\n^FD{upc}^FS\n\n^BY1,1,120^FT287,300^BCN,,Y,N\n^FD{upc}^FS\n                 \"\"\"\n            elif type == 'cycle':\n                barcode_cmd = f\"\"\"\n^BY1,1,110^FT110,250^BCN,,Y,N\n^FD{upc}^FS\n                \"\"\"\n            else:\n                raise UserError(f'UPC[{upc}]位数只有{len(upc)},暂不支持该标签类型！' )\n        size = self._get_size(entity_id)\n        val = {\n            'stock_to_make': self.stock_to_make,\n            'upc_code': upc_code,\n            'color': color.upper(),\n            'size': size,\n            # 'barcode': self.upc,\n            'barcode_cmd': barcode_cmd,\n            'style_num': self.stock_to_make.split('-')[0],\n            'style_color': color.upper(),\n            'msrp': msrp,\n            'currency': currency,\n            'new_msrp': new_msrp,\n            'reminder': self.reminder or '',\n        }\n        return val\n\n    def _check_error_msg(self):\n        errors = self.filtered(lambda x: x.custom_po == 'Pending')\n        if len(errors):\n            raise UserError(f'你所选择的数据中存在{len(errors)}条：价格没有审批不能打印！')\n\n    def zpl_print_select_datas(self, type, qty=0):\n        self._check_error_msg()\n        upc_tp = False\n        print_data = ''\n        reminder_msg = ''\n        reminders = []\n        if type == 'normal':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_NORMAL')], limit=1)\n        elif type == 'single':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_Single')], limit=1)\n        elif type == 'cycle':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_CYCLE')], limit=1)\n        elif type == 'double':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_Double')], limit=1)\n        if upc_tp:\n            print_data = upc_tp.header_content\n            for order in self:\n                upc_data = order._get_upc_init_data(type)\n                reminders.append(upc_data.get('reminder', ''))\n\n                range_qty = int(qty) if int(qty) else int(order.qty_ordered)\n                msrp_cmd = self._get_msrp_cmd(upc_data.get('currency'), upc_data.get('new_msrp'),  upc_data.get('msrp', False), type)\n                for q in range(range_qty):\n                    if not msrp_cmd:\n                        print_data += upc_tp.content.format(\n                            stock_to_make=upc_data.get('stock_to_make'),\n                            upc_code=upc_data.get('upc_code'),\n                            color=upc_data.get('color'),\n                            size=upc_data.get('size'),\n                            # barcode=upc_data.get('barcode'),\n                            barcode_cmd=upc_data.get('barcode_cmd'),\n                            msrp=upc_data.get('msrp'),\n                            msrp_title='MSRP:' if upc_data.get('msrp', False) else '',\n                        )\n                    else:\n                        print_data += upc_tp.content.format(\n                            stock_to_make=upc_data.get('stock_to_make'),\n                            upc_code=upc_data.get('upc_code'),\n                            color=upc_data.get('color'),\n                            size=upc_data.get('size'),\n                            # barcode=upc_data.get('barcode'),\n                            barcode_cmd=upc_data.get('barcode_cmd'),\n                            msrp='',\n                            msrp_title='MSRP:' if upc_data.get('msrp', False) else '',\n                            msrp_cmd=msrp_cmd,\n                        )\n            reminders = list(set(reminders))\n            reminder_msg = ',\\r\\n'.join(reminders)\n        return {\n            'print_data': print_data,\n            'reminder_msg': reminder_msg\n        }\n\n    def _get_msrp_cmd(self, currency, new_msrp, msrp, type):\n        cmd = \"\"\"\"\"\"\n        if 'د.إ' in currency:\n            # 30 * 55\n            if type == 'single':\n                cmd = f\"\"\"\n^CI28\n^CWZ,E:TT0003M_.TTF\n^FT65,419^PA0,1,1,1^AZN,35,35^FD{currency}^FS\n^FT105,419^PA0,1,1,1^AZN,30,30^FD{new_msrp}^FS\n                \"\"\"\n            # 30 * 55 * 2\n            elif type == 'double':\n                cmd = f\"\"\"\n^CI28\n^CWZ,E:TT0003M_.TTF\n^FT65,419^PA0,1,1,1^AZN,35,35^FD{currency}^FS\n^FT105,419^PA0,1,1,1^AZN,30,30^FD{new_msrp}^FS\n\n^FT322,419^PA0,1,1,1^AZN,35,35^FD{currency}^FS\n^FT362,419^PA0,1,1,1^AZN,30,30^FD{new_msrp}^FS\n                \"\"\"\n        else:\n            if type == 'single':\n                cmd = f\"\"\"\n^FT73,419^A0N,28,25^FH\\^CI28^FD{msrp}^FS^CI27\n                \"\"\"\n            elif type == 'double':\n                cmd = f\"\"\"\n^FT73,419^A0N,28,25^FH\\^CI28^FD{msrp}^FS^CI27\n^FT330,419^A0N,28,25^FH\\^CI28^FD{msrp}^FS^CI27\n                \"\"\"\n        return cmd\n\n    def btn_print_upc_scan(self):\n        action = self.env.ref('leda_upc.action_reset_scan_client').sudo().read()[0]\n        context = self.env.context.copy()\n        context.update({\n            'close_footer': True\n        })\n        action['context'] = context\n        action['target'] = 'new'\n        return action\n\n    def open_custom_action(self):\n        action = self.env.ref('leda_upc.action_custom_print_upc').sudo().read()[0]\n        context = self.env.context.copy()\n        action['context'] = context\n        action['target'] = 'new'\n        return action\n\n    def __get_cpcl_data_barcode_cmd(self, upc, type):\n        barcode_cmd = ''\n\n        upc = upc.replace(' ', '')\n        if len(upc) == 12:\n            if type == 'single':\n                barcode_cmd = f\"\"\"\n        ^BY2,2,107^FT27,284^BUN,,Y,N,Y\n        ^FH\\^FD{upc}^FS\n                        \"\"\"\n            elif type == 'double':\n                barcode_cmd = f\"\"\"\n        ^BY2,2,107^FT27,284^BUN,,Y,N,Y\n        ^FH\\^FD{upc}^FS\n        ^BY2,2,107^FT284,284^BUN,,Y,N,Y\n        ^FH\\^FD{upc}^FS\n                         \"\"\"\n            elif type == 'cycle':\n                barcode_cmd = f\"\"\"\n        ^BY2,2,100^FT87,237^BUN,,Y,N,Y\n        ^FH\\^FD{upc}^FS\n                        \"\"\"\n            elif type == 'normal':\n                barcode_cmd = f\"\"\"\n        ^BY2,2,107^FT293,213^BUB,,Y,N,Y\n        ^FH\\^FD{upc}^FS\n                        \"\"\"\n            else:\n                raise UserError(f'UPC[{upc}]位数只有{len(upc)},暂不支持该标签类型！')\n\n        else:\n            if type == 'single':\n                barcode_cmd = f\"\"\"\n        ^BY1,1,120^FT30,300^BCN,,Y,N\n        ^FD{upc}^FS\n                        \"\"\"\n            elif type == 'double':\n                barcode_cmd = f\"\"\"\n        ^BY1,1,120^FT30,300^BCN,,Y,N\n        ^FD{upc}^FS\n\n        ^BY1,1,120^FT287,300^BCN,,Y,N\n        ^FD{upc}^FS\n                         \"\"\"\n            elif type == 'cycle':\n                barcode_cmd = f\"\"\"\n        ^BY1,1,110^FT110,250^BCN,,Y,N\n        ^FD{upc}^FS\n                        \"\"\"\n            else:\n                raise UserError(f'UPC[{upc}]位数只有{len(upc)},暂不支持该标签类型！')\n        return barcode_cmd\n\n    def custom_zpl_print_select_datas(self, data, type, qty=0):\n        upc_tp = False\n        print_data = ''\n        if type == 'single':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_Single')], limit=1)\n        elif type == 'cycle':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_CYCLE')], limit=1)\n        elif type == 'double':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_Double')], limit=1)\n        if upc_tp:\n            print_data = upc_tp.header_content\n            upc = data.get('upc', '')\n            barcode_cmd = self.__get_cpcl_data_barcode_cmd(upc, type)\n            range_qty = int(qty)\n            upc_code = '{}{}{}'.format(data.get('po'), data.get('smu'), data.get('po_date'))\n            color = data.get('color')\n            if len(color) > 9:\n                color = data.get('style').replace(' ', '').split('-')[-1]\n            for q in range(range_qty):\n                print_data += upc_tp.content.format(\n                    stock_to_make=data.get('style').replace(' ', ''),\n                    upc_code=upc_code.replace(' ', ''),\n                    color=color,\n                    size=data.get('size').replace(' ', ''),\n                    barcode_cmd=barcode_cmd,\n                    msrp=data.get('price', '').replace(' ', ''),\n                    msrp_title='MSRP:' if data.get('price', False) else '',\n                    msrp_cmd=self._get_msrp_cmd_new_(data.get('price', ''), type),\n                )\n        return print_data\n\n    def print_new_label_action(self):\n        action = self.env.ref('leda_upc.new_label_print_wizard_action').sudo().read()[0]\n        form_id = self.env.ref('leda_upc.new_label_print_wizard_form_view').id\n        views = [(form_id, 'form')]\n        action['views'] = views\n        return action\n\n    def _get_msrp_cmd_new_(self, price, type):\n        cmd = \"\"\"\"\"\"\n        if 'د.إ' in price:\n            # 30 * 55\n            # 30 * 55\n            price = price.replace('د.إ', '')\n            if type == 'single':\n                cmd = f\"\"\"\n            ^CI28\n            ^CWZ,E:TT0003M_.TTF\n            ^FT65,419^PA0,1,1,1^AZN,35,35^FDد.إ^FS\n            ^FT105,419^PA0,1,1,1^AZN,30,30^FD{price}^FS\n                            \"\"\"\n            # 30 * 55 * 2\n            elif type == 'double':\n                cmd = f\"\"\"\n            ^CI28\n            ^CWZ,E:TT0003M_.TTF\n            ^FT65,419^PA0,1,1,1^AZN,35,35^FDد.إ^FS\n            ^FT105,419^PA0,1,1,1^AZN,30,30^FD{price}^FS\n\n            ^FT322,419^PA0,1,1,1^AZN,35,35^FDد.إ^FS\n            ^FT362,419^PA0,1,1,1^AZN,30,30^FD{price}^FS\n                            \"\"\"\n        else:\n            if type == 'single':\n                cmd = f\"\"\"\n    ^FT73,419^A0N,28,25^FH\\^CI28^FD{price}^FS^CI27\n    ";
const char* encrypted_code_models_maxima_order_upc_part1 = "                \"\"\"\n            elif type == 'double':\n                cmd = f\"\"\"\n    ^FT73,419^A0N,28,25^FH\\^CI28^FD{price}^FS^CI27\n    ^FT330,419^A0N,28,25^FH\\^CI28^FD{price}^FS^CI27\n                    \"\"\"\n        return cmd\n\n    def zpl_print_preview_datas(self, type):\n        context = self.env.context.copy()\n        action = self.env.ref('leda_upc.action_review_upc').sudo().read()[0]\n        action['target'] = 'new'\n        action['context'] = {\n            'result_datas': {\n                'templateType': type,\n                'res_ids': self.ids,\n                'datas': self.get_upc_data_for_preview(qty=0)\n            },\n            'close_footer': True\n        }\n        return action\n\n    def btn_review_upc(self):\n        context = self.env.context.copy()\n        action = self.env.ref('leda_upc.action_review_upc').sudo().read()[0]\n        action['target'] = 'new'\n        action['context'] = {\n            'result_datas': {\n                'res_ids': self.ids,\n                'datas': self.get_upc_data_for_preview(qty=0)\n            },\n            'close_footer': True\n        }\n        return action\n\n    @api.model\n    def get_upc_data_for_preview(self, qty=0):\n        \"\"\"\n        获取UPC数据用于前端预览\n        :return: 包含UPC数据的列表\n        \"\"\"\n        result = []\n        for upc in self:\n            entity_id = self.env['upc.entity'].search([('name', '=', upc.entity)])\n            if not entity_id:\n                raise UserError('Entity:[%s],在配置文件中没有找到，请联系管理员' % upc.entity)\n            if len(entity_id) > 1:\n                raise UserError('Entity:[%s],在配置文件中找到多个，请联系管理员' % upc.entity)\n\n            smu = upc.__get_smu(entity_id)\n            po_date = upc.po_date.strftime('%y%m')\n            upc_code = '{}{}{}'.format(upc.po, smu, po_date)\n\n            currency, msrp, new_msrp = upc.__get_currency_price(entity_id, smu)\n\n            size = upc._get_size(entity_id)\n\n            range_qty = int(qty) if int(qty) else int(upc.qty_ordered)\n\n            barcode = upc.upc.replace(' ', '') if upc.upc else ''\n\n            color = upc.color\n            if len(color) > 9:\n                color = upc.stock_to_make.split('-')[-1]\n\n            upc_data = {\n                'id': upc.id,\n                'style': upc.stock_to_make,\n                'ttc': upc_code,\n                'color': color.upper(),\n                'size': size,\n                'currency': currency,\n                'msrp': msrp,\n                'new_msrp': new_msrp,\n                'printQuantity': range_qty,\n                'barcode': barcode,\n                'barcodeUrl': f'/report/barcode/\?barcode_type=C-UPCA&value={barcode}&width=1000&height=600&humanreadable=1'\n            }\n\n            result.append(upc_data)\n        return result\n";

void load_models_maxima_order_upc(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_maxima_order_upc_part0;
    full_code += encrypted_code_models_maxima_order_upc_part1;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\maxima_samp_order_upc.py
const char* encrypted_code_models_maxima_samp_order_upc_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\nimport re\n\nclass MaximaSampOrderUpc(models.Model):\n    _name = 'maxima.samp.order.upc'\n    _description = 'PO UPC'\n    _order = 'id desc'\n\n    style = fields.Char('Style Num Full', required=1)\n    size = fields.Char('SIZE', required=1)\n    by = fields.Char('Factory', required=1)\n    brand = fields.Char('Brand')\n    season = fields.Char('Season')\n    qty = fields.Integer('QTY')\n\n    def zpl_print_select_datas(self, type, qty=0):\n        upc_tp = False\n        print_data = ''\n        if type == 'normal':\n            raise UserError('暂不支持该纸张格式')\n            # upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'SAMP_NORMAL')], limit=1)\n        elif type == 'single':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'SAMP_SINGLE')], limit=1)\n        # elif type == 'cycle':\n        #     upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'UPC_SIZE_CYCLE')], limit=1)\n        elif type == 'double':\n            upc_tp = self.env['zebra.upc.template'].search([('code', '=', 'SAMP_DOUBLE')], limit=1)\n            pass\n        else:\n            raise UserError('暂不支持该标签类型！')\n        if upc_tp:\n            print_data = upc_tp.header_content\n            for order in self:\n                range_qty = int(qty) if int(qty) else int(order.qty)\n                factory = self.env['samp.factory'].search([('name', '=', order.by)], limit=1)\n                for q in range(range_qty):\n                    print_data += upc_tp.content.format(\n                        style=order.style,\n                        color=order.style.split('-')[-1],\n                        size=order.size,\n                        by=order.by if not factory else factory.alias_name,\n                        season=order.season,\n                        date=fields.Date.today().strftime('%Y.%m.%d'),\n                    )\n        return {\n            'print_data': print_data,\n        }\n\n    def btn_print_upc_scan(self):\n        action = self.env.ref('leda_upc.action_reset_scan_client').sudo().read()[0]\n        context = self.env.context.copy()\n        context.update({\n            'close_footer': True\n        })\n        action['context'] = context\n        action['target'] = 'new'\n        return action\n\n";

void load_models_maxima_samp_order_upc(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_maxima_samp_order_upc_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\printer_cpcl_template.py
const char* encrypted_code_models_printer_cpcl_template_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError,ValidationError\n\nclass PrinterCpclTemplate(models.Model):\n    _name = 'printer.cpcl.template'\n    _description = 'CPCL打印模板'\n\n    name = fields.Char('名称')\n    code = fields.Char('编码')\n    remark = fields.Char('备注')\n    content = fields.Text('标签内容')\n    active = fields.Boolean(default=True)\n\n    @api.constrains('code')\n    def _check_code(self):\n        count = self.search_count([('code', '=', self.code)])\n        if count > 1:\n            raise ValidationError('编码必须唯一！')";

void load_models_printer_cpcl_template(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_printer_cpcl_template_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\samp_factory.py
const char* encrypted_code_models_samp_factory_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\n\nclass SampFactory(models.Model):\n    _name = 'samp.factory'\n    _description = '样品工厂'\n\n    name = fields.Char('Factory', required=1)\n    alias_name = fields.Char('Factory Alias Name', required=1)";

void load_models_samp_factory(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_samp_factory_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\test.py
const char* encrypted_code_models_test_part0 = "import re\n\ndef extract_character_and_float(string):\n    pattern = r'([a-zA-Z]+)|(\\d+(\\.\\d+)\?)'\n    matches = re.findall(pattern, string)\n\n    characters = []\n    floats = []\n    for match in matches:\n        if match[0]:\n            characters.append(match[0])\n        elif match[1]:\n            floats.append(float(match[1]))\n\n    return characters, floats\n\nstring = \"ABCDDFD,DDFDD\"\ncharacter_list, float_list = extract_character_and_float(string)\nprint(character_list)\nprint(float_list)";

void load_models_test(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_test_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\upc_entity.py
const char* encrypted_code_models_upc_entity_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\n\nclass UpcEntity(models.Model):\n    _name = 'upc.entity'\n    _description = 'UPC Entity'\n\n    name = fields.Char('Entity Name')\n    currency_code = fields.Char('Currency Code')\n    currency = fields.Char('Currency Symbol')\n    upc_display = fields.Char('UPC Display')\n    reminder = fields.Char('Label reminder')\n    size_ids = fields.One2many('upc.size', 'entity_id', string='特殊尺码')\n\n    def btn_setting_size(self):\n        action = self.env.ref('leda_upc.upc_size_action').sudo().read()[0]\n        action['target'] = 'new'\n        action['domain'] = [('entity_id', '=', self.id)]\n        action['context'] = {\n            'default_entity_id': self.id\n        }\n        return action";

void load_models_upc_entity(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_upc_entity_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\upc_size.py
const char* encrypted_code_models_upc_size_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\n\nclass UpcSize(models.Model):\n    _name = 'upc.size'\n    _description = 'UPC Size'\n\n    entity_id = fields.Many2one('upc.entity', string='Entity Name', ondelete='cascade')\n    name = fields.Char('SIZE')\n    upc_display_name = fields.Char('UPC显示')\n";

void load_models_upc_size(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_upc_size_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for models\zebra_upc_template.py
const char* encrypted_code_models_zebra_upc_template_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError,ValidationError\n\nclass ZebrUpcTemplate(models.Model):\n    _name = 'zebra.upc.template'\n    _description = 'UPC模板'\n\n    name = fields.Char('名称')\n    code = fields.Char('编码')\n    remark = fields.Char('备注')\n    header_content = fields.Text('表头内容')\n    content = fields.Text('标签内容')\n    active = fields.Boolean(default=True)\n\n    @api.constrains('code')\n    def _check_code(self):\n        count = self.search_count([('code', '=', self.code)])\n        if count > 1:\n            raise ValidationError('编码必须唯一！')";

void load_models_zebra_upc_template(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_models_zebra_upc_template_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

// Encrypted code for wizard\new_label_print_wizard.py
const char* encrypted_code_wizard_new_label_print_wizard_part0 = "from odoo import models,fields,api,_\nfrom odoo.exceptions import UserError\n\nclass NewLabelPrintWizard(models.TransientModel):\n    _name = 'new.label.print.wizard'\n    _description = '新标签打印40*30'\n\n    upc_id = fields.Many2one('maxima.order.upc', string='选择款式')\n    sku = fields.Char('款号-颜色-尺码')\n    name = fields.Text(related='upc_id.style_description', store=True, string='球队+类型')\n    upc = fields.Char(related='upc_id.upc', store=True, string='UPC')\n    price = fields.Char(string='价格')\n    currency = fields.Char(string='货币符号')\n    production_date = fields.Date('生产日期')\n    season = fields.Selection([('P', '春季'), ('V', '夏季'), ('O', '秋季'), ('I', '冬季')], string='季度', required=1)\n    season1 = fields.Char(string='季度', required=1)\n    qty = fields.Integer(default=1, string='打印数量')\n    po_memo = fields.Char('PO NUM')\n\n    @api.onchange('po_memo')\n    def _onchange_po_memo(self):\n        for order in self:\n            if order.po_memo:\n                return {\n                    'domain':{\n                        'upc_id':[('po', '=', order.po_memo)]\n                    }\n                }\n            else:\n                return {\n                    'domain': {\n                        'upc_id': [(1, '=', 1)]\n                    }\n                }\n\n    @api.onchange('production_date')\n    def _onchange_production_date(self):\n        if self.production_date:\n            month = self.production_date.month\n            if 3 <= month <= 5:\n                self.season1 = \"P\"\n            elif 6 <= month <= 8:\n                self.season1 = \"V\"\n            elif 9 <= month <= 11:\n                self.season1 = \"O\"\n            else:\n                self.season1 = \"I\"\n        else:\n            self.season1 = ''\n\n    @api.onchange('upc_id')\n    def _onchange_upc_id(self):\n        self.sku = self.upc_id.display_name\n        if self.po_memo and self.upc_id:\n            self.currency = self.upc_id.currency\n            self.price = self.upc_id.price_to_print\n        else:\n            self.currency = ''\n            self.price = ''\n\n    def btn_confirm(self, style_description, style, season, production_date, currency, price, upc, qty=1):\n        print_data = ''\n        if not style_description:\n            raise UserError('球队+类型必填！')\n        if not style:\n            raise UserError('款号-颜色-尺码必填！')\n        if not production_date:\n            raise UserError('生产日期必填！')\n        if not season:\n            raise UserError('季度必填！')\n        if not currency:\n            raise UserError('货币符号必填！')\n        if not float(price):\n            raise UserError('价格必填！')\n        if not upc:\n            raise UserError('UPC必填！')\n        zpl_id = self.env.ref('leda_upc.zebra_upc_template_UPC_40_30')\n        print_data = zpl_id.header_content\n        format_date = fields.Date.to_date(production_date).strftime('%d%m%y')\n        size = style.split('-')[2]\n        stock = style.split('-')[0]\n        color = style.split('-')[1]\n        for x in range(qty):\n            print_data += zpl_id.content.format(\n                style_description=style_description,\n                brand='',\n                season=season,\n                style=f'{stock}-{color}',\n                size=size,\n                production_date=format_date,\n                currency=currency,\n                price=f'{float(price):.2f}',\n                upc=upc.replace(' ', ''),\n            )\n        return print_data\n";

void load_wizard_new_label_print_wizard(py::object locals_obj) {
    // 连接所有代码块
    std::string full_code;
    full_code += encrypted_code_wizard_new_label_print_wizard_part0;
    py::dict locals = locals_obj.cast<py::dict>();
    py::exec(full_code, py::globals(), locals);
}

PYBIND11_MODULE(leda_upc, m) {
    m.doc() = "Encrypted ODOO module (v1.0)";
    m.def("load_models_fast_vendor", &load_models_fast_vendor, "Load models_fast_vendor module");
    m.def("load_models_ir_actions_report", &load_models_ir_actions_report, "Load models_ir_actions_report module");
    m.def("load_models_maxima_certificate_conformity", &load_models_maxima_certificate_conformity, "Load models_maxima_certificate_conformity module");
    m.def("load_models_maxima_order_upc", &load_models_maxima_order_upc, "Load models_maxima_order_upc module");
    m.def("load_models_maxima_samp_order_upc", &load_models_maxima_samp_order_upc, "Load models_maxima_samp_order_upc module");
    m.def("load_models_printer_cpcl_template", &load_models_printer_cpcl_template, "Load models_printer_cpcl_template module");
    m.def("load_models_samp_factory", &load_models_samp_factory, "Load models_samp_factory module");
    m.def("load_models_test", &load_models_test, "Load models_test module");
    m.def("load_models_upc_entity", &load_models_upc_entity, "Load models_upc_entity module");
    m.def("load_models_upc_size", &load_models_upc_size, "Load models_upc_size module");
    m.def("load_models_zebra_upc_template", &load_models_zebra_upc_template, "Load models_zebra_upc_template module");
    m.def("load_wizard_new_label_print_wizard", &load_wizard_new_label_print_wizard, "Load wizard_new_label_print_wizard module");
}
