# mypy-boto3-mq

[![PyPI - mypy-boto3-mq](https://img.shields.io/pypi/v/mypy-boto3-mq.svg?color=blue)](https://pypi.org/project/mypy-boto3-mq)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mq.svg?color=blue)](https://pypi.org/project/mypy-boto3-mq)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MQ 1.15.18](https://boto3.amazonaws.com/v1/documentation/api/1.15.18/reference/services/mq.html#MQ) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-mq](#mypy-boto3-mq)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `MQ` service.

```bash
python -m pip install boto3-stubs[mq]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mq]` in your environment: `python -m pip install 'boto3-stubs[mq]'`

Both type checking and auto-complete should work for `MQ` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[mq]` in your environment: `python -m pip install 'boto3-stubs[mq]'`

Both type checking and auto-complete should work for `MQ` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mq]` in your environment: `python -m pip install 'boto3-stubs[mq]'`
- Run `mypy` as usual

Type checking should work for `MQ` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mq]` in your environment: `python -m pip install 'boto3-stubs[mq]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MQ` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`MQClient` provides annotations for `boto3.client("mq")`.

```python
import boto3

from mypy_boto3_mq import MQClient

client: MQClient = boto3.client("mq")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MQClient = session.client("mq")
```

### Paginators annotations

`mypy_boto3_mq.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_mq import MQClient
from mypy_boto3_mq.paginator import ListBrokersPaginator

client: MQClient = boto3.client("mq")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_brokers_paginator: ListBrokersPaginator = client.get_paginator("list_brokers")
```







### Typed dictionations

`mypy_boto3_mq.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_mq.type_defs import (
    AvailabilityZoneTypeDef,
    BrokerEngineTypeTypeDef,
    BrokerInstanceOptionTypeDef,
    BrokerInstanceTypeDef,
    BrokerSummaryTypeDef,
    ConfigurationIdTypeDef,
    ConfigurationRevisionTypeDef,
    ConfigurationsTypeDef,
    ConfigurationTypeDef,
    CreateBrokerResponseTypeDef,
    CreateConfigurationResponseTypeDef,
    DeleteBrokerResponseTypeDef,
    DescribeBrokerEngineTypesResponseTypeDef,
    DescribeBrokerInstanceOptionsResponseTypeDef,
    DescribeBrokerResponseTypeDef,
    DescribeConfigurationResponseTypeDef,
    DescribeConfigurationRevisionResponseTypeDef,
    DescribeUserResponseTypeDef,
    EncryptionOptionsTypeDef,
    EngineVersionTypeDef,
    LdapServerMetadataInputTypeDef,
    LdapServerMetadataOutputTypeDef,
    ListBrokersResponseTypeDef,
    ListConfigurationRevisionsResponseTypeDef,
    ListConfigurationsResponseTypeDef,
    ListTagsResponseTypeDef,
    ListUsersResponseTypeDef,
    LogsSummaryTypeDef,
    LogsTypeDef,
    PaginatorConfigTypeDef,
    PendingLogsTypeDef,
    ResponseMetadata,
    SanitizationWarningTypeDef,
    UpdateBrokerResponseTypeDef,
    UpdateConfigurationResponseTypeDef,
    UserPendingChangesTypeDef,
    UserSummaryTypeDef,
    UserTypeDef,
    WeeklyStartTimeTypeDef,
)

def get_structure() -> AvailabilityZoneTypeDef:
    return {
      ...
    }
```
