"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagRules = exports.NagRulePostValidationStates = exports.NagRuleCompliance = exports.NagMessageLevel = exports.VALIDATION_FAILURE_ID = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
exports.VALIDATION_FAILURE_ID = 'CdkNagValidationFailure';
/**
 * The severity level of the rule.
 */
var NagMessageLevel;
(function (NagMessageLevel) {
    NagMessageLevel["WARN"] = "Warning";
    NagMessageLevel["ERROR"] = "Error";
})(NagMessageLevel || (exports.NagMessageLevel = NagMessageLevel = {}));
/**
 * The compliance level of a resource in relation to a rule.
 */
var NagRuleCompliance;
(function (NagRuleCompliance) {
    NagRuleCompliance["COMPLIANT"] = "Compliant";
    NagRuleCompliance["NON_COMPLIANT"] = "Non-Compliant";
    NagRuleCompliance["NOT_APPLICABLE"] = "N/A";
})(NagRuleCompliance || (exports.NagRuleCompliance = NagRuleCompliance = {}));
/**
 * Additional states a rule can be in post compliance validation
 */
var NagRulePostValidationStates;
(function (NagRulePostValidationStates) {
    NagRulePostValidationStates["SUPPRESSED"] = "Suppressed";
    NagRulePostValidationStates["UNKNOWN"] = "UNKNOWN";
})(NagRulePostValidationStates || (exports.NagRulePostValidationStates = NagRulePostValidationStates = {}));
/**
 * Helper class with methods for rule creation
 */
class NagRules {
    /**
     * Use in cases where a primitive value must be known to pass a rule.
     * https://developer.mozilla.org/en-US/docs/Glossary/Primitive
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return a value if resolves to a primitive data type, otherwise throw an error.
     */
    static resolveIfPrimitive(node, parameter) {
        const resolvedValue = aws_cdk_lib_1.Stack.of(node).resolve(parameter);
        if (resolvedValue === Object(resolvedValue)) {
            throw Error(`The parameter resolved to to a non-primitive value "${JSON.stringify(resolvedValue)}", therefore the rule could not be validated.`);
        }
        else {
            return resolvedValue;
        }
    }
    /**
     * @deprecated
     * Use resolveResourceFromIntrinsic instead
     *
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     */
    static resolveResourceFromInstrinsic(node, parameter) {
        return this.resolveResourceFromIntrinsic(node, parameter);
    }
    /**
     *
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     */
    static resolveResourceFromIntrinsic(node, parameter) {
        const resolvedValue = aws_cdk_lib_1.Stack.of(node).resolve(parameter);
        const ref = resolvedValue?.Ref;
        const getAtt = resolvedValue?.['Fn::GetAtt'];
        if (ref != undefined) {
            return ref;
        }
        else if (Array.isArray(getAtt) && getAtt.length > 0) {
            return getAtt[0];
        }
        return resolvedValue;
    }
}
exports.NagRules = NagRules;
_a = JSII_RTTI_SYMBOL_1;
NagRules[_a] = { fqn: "cdk-nag.NagRules", version: "2.36.36" };
//# sourceMappingURL=data:application/json;base64,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