# This file was auto-generated by Fern from our API Definition.

from .....core.pydantic_utilities import UniversalBaseModel
import pydantic
from .public_key_algorithm import PublicKeyAlgorithm
from .signature_algorithm import SignatureAlgorithm
import datetime as dt
import typing
from .....core.pydantic_utilities import IS_PYDANTIC_V2


class Certificate(UniversalBaseModel):
    certificate: str
    serial_number: str = pydantic.Field(alias="serialNumber")
    signature: str
    public_key_algorithm: PublicKeyAlgorithm = pydantic.Field(alias="publicKeyAlgorithm")
    signature_algorithm: SignatureAlgorithm = pydantic.Field(alias="signatureAlgorithm")
    valid_from: dt.datetime = pydantic.Field(alias="validFrom")
    valid_to: dt.datetime = pydantic.Field(alias="validTo")
    version: int
    issuer_common_name: typing.Optional[str] = pydantic.Field(alias="issuerCommonName", default=None)
    subject_common_name: typing.Optional[str] = pydantic.Field(alias="subjectCommonName", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
