# -*- coding: utf-8 -*-
# Copyright (C) 2023-2024 TUD | ZIH
# ralf.klammer@tu-dresden.de

import logging

from .collection import CollectionModeler
from .util import RenderBase
from .yaml import MainConfig

log = logging.getLogger(__name__)


class Project(RenderBase):

    def __init__(self, projectpath, templates=None, *args, **kw):
        super().__init__(projectpath, templates=templates)
        self.templates = templates
        self.facets = {}
        self.collectors = []
        self._main_config = None
        self._avatar = None
        self._xslt = None

    @property
    def main_config(self):
        if self._main_config is None:
            self._main_config = MainConfig(self.projectpath)
        return self._main_config

    def render_project(self):

        for subproject in self.main_config.content["subprojects"]:
            collection = CollectionModeler(
                subproject, self.projectpath, templates=self.templates
            )
            collection.render_collection()
            self.add_facets(collection.facets)

        self.render_portalconfig()
        self.render_readme()
        self.render_other_files()

    def render_other_files(self):
        self.main_config.other_files.render_collection_base()
        self.main_config.other_files.render_collection_meta()

    def render_portalconfig(self):
        self.render(
            "%s/portalconfig.xml" % self.projectpath,
            {
                "facets": self.facets,
                "title": self.main_config.get("title", "project")
                or "Set title of your project",
                "description": self.main_config.get("description", "project")
                or "Set description of your project",
                "avatar": self.main_config.other_files.get_avatar(),
                "xslt": self.main_config.other_files.get_xslt(),
            },
            "portalconfig.xml",
        )

    def render_readme(self):
        self.render("%s/README.md" % self.projectpath, {}, "README.md")

    def add_facets(self, facets):
        for key in facets:
            if key in self.facets:
                self.facets[key] += facets[key]
            else:
                self.facets[key] = facets[key]
