# Copyright (c) 2024-2025 IQM Quantum Computers
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are permitted (subject to the
# limitations in the disclaimer below) provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this list of conditions and the following
#   disclaimer.
# * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
#   disclaimer in the documentation and/or other materials provided with the distribution.
# * Neither the name of IQM Quantum Computers nor the names of its contributors may be used to endorse or promote
#   products derived from this software without specific prior written permission.
#
# NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE. THIS SOFTWARE IS PROVIDED BY
# THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
import numpy as np

# Auto-generated from .pkl files

RESULTS_D19 = {
    0: {
        "betas": [
            [0.39269907320954184],
            [0.5016513513357462, 0.2707752776441655],
            [0.5559801453633539, 0.37529436073090283, 0.21222496823245204],
            [0.5766539378249033, 0.4269092058876546, 0.31072023351806793, 0.1744755735576467],
            [0.5952193920790512, 0.4581399520560679, 0.3655978174566507, 0.27282689780947394, 0.14995850313823714],
            [
                0.6051433977604678,
                0.4756761841165994,
                0.3976258734265323,
                0.3284310595288057,
                0.2407656097597678,
                0.13025914849004372,
            ],
        ],
        "gammas": [
            [0.4914950775731369],
            [0.375970011991499, 0.6601516019894548],
            [0.3251789259092855, 0.5665215491880707, 0.6405177904177346],
            [0.29069149297035324, 0.5126119331698825, 0.5613267366929829, 0.6453319487309697],
            [0.26679722589168164, 0.47839315830371576, 0.5094111780561673, 0.5692729020807826, 0.6447174852168012],
            [
                0.24924380420309988,
                0.45115628891142495,
                0.47664919635405073,
                0.5181081357760194,
                0.5724277198436364,
                0.6462332645014603,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.3926113330622512],
            [0.5010578948284667, 0.27041567583654935],
            [0.5550718159021588, 0.3745297573919595, 0.2121516908142008],
            [0.5751183758374174, 0.4252653163918176, 0.31036270590329224, 0.17448940648432928],
            [0.5933591971231095, 0.45587024339312027, 0.3649120773973035, 0.2728372373695351, 0.15004146911939464],
            [
                0.6032215795537103,
                0.4731859591465515,
                0.3968516889004193,
                0.3285155819802875,
                0.24096587081960846,
                0.13039385855677096,
            ],
        ],
        "gammas": [
            [0.4913606080742958],
            [0.3756491563168061, 0.659693619433721],
            [0.32452683042744906, 0.5655672612823557, 0.6396872478376041],
            [0.28974587096919646, 0.510877326653184, 0.5598226311170308, 0.6451016636211764],
            [0.26563252016456773, 0.47619130297151957, 0.507329082772322, 0.5687684057146127, 0.644716416446573],
            [
                0.24797855585054543,
                0.44870062407006117,
                0.47437231497371707,
                0.5175332714812364,
                0.5723430621181516,
                0.6462802362485485,
            ],
        ],
    },
    np.float64(1.5928571428571427): {
        "betas": [
            [0.3718917702181076],
            [0.43759225299728505, 0.2526835551767741],
            [0.48988054099342593, 0.35660311228642644, 0.2259347192285273],
            [0.5089941390542796, 0.4016644692657427, 0.3243565088276689, 0.18424592282712624],
            [0.5325000566661248, 0.43264441395637465, 0.3793417026324096, 0.28298254997090494, 0.1568441875079633],
            [
                0.54878525968206,
                0.4555513476233002,
                0.4134019848528835,
                0.33884339028509713,
                0.2490018047462237,
                0.13560832168062797,
            ],
        ],
        "gammas": [
            [0.4559608309923919],
            [0.3131562882234403, 0.5888851287542004],
            [0.24815228107659487, 0.48104816801812006, 0.6130388018162285],
            [0.22089833078870152, 0.42447044448191174, 0.5334278853900012, 0.6423362958400125],
            [0.2006797165236577, 0.3971606075703225, 0.4861650615281957, 0.5680103803586083, 0.6455822002641249],
            [
                0.18700722208217593,
                0.3771356559962516,
                0.45995891985865384,
                0.5192414948172392,
                0.5718638654231941,
                0.6435912632217744,
            ],
        ],
    },
    np.float64(3.0857142857142854): {
        "betas": [
            [0.336356910885576],
            [0.41293787253094133, 0.2729679519206899],
            [0.4800069377339397, 0.3797219325120022, 0.23358736581183798],
            [0.5062586235408733, 0.42748229734166077, 0.3308516647700864, 0.187313738781339],
            [0.5340716642878579, 0.45802593630969235, 0.38335206406700567, 0.282056973085482, 0.15777412984226935],
            [
                0.5544181943878326,
                0.4817821607983323,
                0.41682997370448455,
                0.33602083993557025,
                0.2480958697604047,
                0.13602503598726115,
            ],
        ],
        "gammas": [
            [0.36625109888164276],
            [0.23808694657338902, 0.5604059856422418],
            [0.19248030771778762, 0.46992250737696223, 0.6283438790319059],
            [0.17744391361084688, 0.4212560856269992, 0.5471612752171657, 0.6372552603637223],
            [0.16422139914948325, 0.39738416703441304, 0.5015351759351125, 0.5632407191317388, 0.645966639375396],
            [
                0.15520973427080081,
                0.37973333647107577,
                0.47594964613333074,
                0.5153920157711527,
                0.571781303941589,
                0.6414749476804934,
            ],
        ],
    },
    np.float64(4.578571428571427): {
        "betas": [
            [0.32564503952862295],
            [0.4277103955386665, 0.28643445150188745],
            [0.5018757378754791, 0.392416636010764, 0.23332796256886043],
            [0.527480514963866, 0.4400955005703246, 0.32802007245196146, 0.18638592609595736],
            [0.5542619423695545, 0.46954916167980354, 0.3769500981215521, 0.27573888488875103, 0.1562211452783751],
            [
                0.5745824401172364,
                0.4928364370508497,
                0.40882390612157654,
                0.32688561048043285,
                0.24345302391537738,
                0.13462843562425936,
            ],
        ],
        "gammas": [
            [0.2855739485809494],
            [0.19689010479462196, 0.577204577733132],
            [0.1661392737597864, 0.4881795997577376, 0.6390023655689318],
            [0.15680261568182136, 0.43815952215587645, 0.5551408843825735, 0.628999833369257],
            [0.14719151887997237, 0.41305099626675557, 0.5108228316997769, 0.5542689020557148, 0.6461701251473208],
            [
                0.14036035490963564,
                0.39422255310057686,
                0.48555671473705514,
                0.5063995244741679,
                0.571678431872615,
                0.6402939415939446,
            ],
        ],
    },
    np.float64(6.07142857142857): {
        "betas": [
            [0.3367274084593804],
            [0.45388477572052344, 0.2900625951428338],
            [0.530109839471044, 0.3958940793238048, 0.2295815656226827],
            [0.552409428225504, 0.44238862478374236, 0.32113868053722167, 0.18391336136162614],
            [0.5762855392387093, 0.47036164970561656, 0.36567000659308885, 0.2668015182175181, 0.15303558780758975],
            [
                0.5952698808434042,
                0.49229506227212133,
                0.39509908006469663,
                0.3148433686439972,
                0.23655458230104884,
                0.1322479977979591,
            ],
        ],
        "gammas": [
            [0.2366857060837851],
            [0.17471312341140477, 0.6047559007801397],
            [0.15185248835727927, 0.5129131698436048, 0.6477372729634268],
            [0.1454656161213762, 0.45920071728456835, 0.5611376419135737, 0.6186961055111068],
            [0.13787493779417856, 0.4321734327204439, 0.5184504691610872, 0.5432788322751473, 0.6463676789579397],
            [
                0.1323966315130429,
                0.41143341532826205,
                0.492750777185673,
                0.49461503613186963,
                0.5719877311793969,
                0.6415011359561589,
            ],
        ],
    },
    np.float64(7.564285714285713): {
        "betas": [
            [0.3581459342356468],
            [0.48205324182487097, 0.2873549922988897],
            [0.5583135115226886, 0.3928942024103141, 0.2230096038047205],
            [0.5772578537788491, 0.4376248837049519, 0.3121966202158731, 0.18085401678603327],
            [0.597602092189532, 0.4637706038460273, 0.352028327205805, 0.2569179609720457, 0.14833173476924594],
            [
                0.6156377074815721,
                0.4846769473336684,
                0.3797688449851932,
                0.3024177111222927,
                0.22700823240695311,
                0.12875309798772008,
            ],
        ],
        "gammas": [
            [0.20676340600896093],
            [0.16153241074894473, 0.6382255292436891],
            [0.14317153930451348, 0.5423115234146562, 0.6581725707599648],
            [0.1386890419114227, 0.484071320262715, 0.5676066098972578, 0.607765071905909],
            [0.1324844317575654, 0.4548583234332088, 0.5266771179605589, 0.5328885401648998, 0.6455749287563852],
            [
                0.12790918088914408,
                0.43233253706478375,
                0.5005345087392161,
                0.485845938513353,
                0.5727235454231836,
                0.6450668031846867,
            ],
        ],
    },
    np.float64(9.057142857142855): {
        "betas": [
            [0.38483996166526135],
            [0.5099270189646287, 0.27993959466153373],
            [0.5842111623003492, 0.3838022851970949, 0.21296520684091227],
            [0.6017242616542946, 0.4277370818293756, 0.30236617694621604, 0.17768452994481074],
            [0.618135811876387, 0.45169636539344615, 0.33700938818468273, 0.24691003077462187, 0.14206032795449652],
            [
                0.6355045938674311,
                0.47190384072892616,
                0.3630724242639045,
                0.2894539845355723,
                0.21440698648798595,
                0.12399638160064902,
            ],
        ],
        "gammas": [
            [0.18701193612849185],
            [0.15322140258274822, 0.6793172023292889],
            [0.1377823220594715, 0.5778749926802803, 0.6739960529665869],
            [0.1346429053576354, 0.5149460104139997, 0.5760118727760818, 0.5982339023042879],
            [0.12940825504828213, 0.4829059164978207, 0.5375609136321207, 0.5253868714497446, 0.6425479242154493],
            [
                0.12541663384300422,
                0.4587804610165886,
                0.5113755554801265,
                0.481316439320238,
                0.5723820460984136,
                0.6510142074056552,
            ],
        ],
    },
    np.float64(10.549999999999999): {
        "betas": [
            [0.4148373132171164],
            [0.537073935483639, 0.2684954243683727],
            [0.6062027666775434, 0.36718548720545835, 0.1980036519950243],
            [0.6261430602594968, 0.41402056672070486, 0.292065102799549, 0.17439895269666603],
            [0.63762124102358, 0.434561764387734, 0.3204874927544248, 0.23734603132543866, 0.13498336398287294],
            [
                0.6538310360533875,
                0.4536293322412071,
                0.3436400505889192,
                0.27537562337222943,
                0.19915239836502988,
                0.11769077795439456,
            ],
        ],
        "gammas": [
            [0.1731556484850526],
            [0.1479676384490668, 0.7319265431912093],
            [0.13472216329669448, 0.6222199036125942, 0.7002676923145836],
            [0.13248216225991108, 0.5553556913987158, 0.5877847251892954, 0.5920342903083893],
            [0.1279753396271276, 0.5185389622362597, 0.5528970285063913, 0.5208449757752152, 0.6347401693120809],
            [
                0.12439615081415634,
                0.4928282275963392,
                0.5274133529646522,
                0.4800077293120935,
                0.5685274639392907,
                0.6594577852650569,
            ],
        ],
    },
    np.float64(12.042857142857141): {
        "betas": [
            [0.44746047074641077],
            [0.5635816192819543, 0.25322314939766755],
            [0.6231254732565643, 0.34108019767048486, 0.17731469595146862],
            [0.6506569298877333, 0.39729203507022437, 0.2809509050900257, 0.17067455033830067],
            [0.6562022729405864, 0.41224296747768946, 0.30282281419680784, 0.22922326430145373, 0.12887999916208656],
            [
                0.6702856870708969,
                0.4292983390142873,
                0.3211891798912702,
                0.26057126121050744,
                0.18375656946980137,
                0.10936416809508497,
            ],
        ],
        "gammas": [
            [0.16305531006949261],
            [0.14491128864096747, 0.80253337594868],
            [0.13363716423643104, 0.6799313188166216, 0.7425618252867788],
            [0.13179114191121444, 0.610285738346136, 0.6054602457479575, 0.5911343705393958],
            [0.12793719701154985, 0.5654554132068643, 0.5747075999897985, 0.5197062074166773, 0.6215067633123833],
            [
                0.12463994854373776,
                0.5375057367507583,
                0.5513342422733453,
                0.48222283776979863,
                0.5598104658456812,
                0.6680436470723427,
            ],
        ],
    },
    np.float64(13.535714285714283): {
        "betas": [
            [0.4827007137322946],
            [0.5897065529554739, 0.23392985750134473],
            [0.6366847156067583, 0.30604413926392793, 0.15343830832466968],
            [0.6749678098809423, 0.3773961012479792, 0.26731110005645653, 0.1654276451896145],
            [0.6748834024391112, 0.3851429356229014, 0.28502196556197784, 0.22283723568224226, 0.125555972132031],
            [
                0.685377849851,
                0.3985420739073217,
                0.29572805374925903,
                0.2457794644132819,
                0.17246579502792278,
                0.09945936554661165,
            ],
        ],
        "gammas": [
            [0.15559002410050804],
            [0.14364300614731867, 0.90253337594868],
            [0.13420295935992857, 0.7581745037779405, 0.8043571427781707],
            [0.13238290410889594, 0.6869009517824478, 0.6344704008032703, 0.59861919140376],
            [0.12924946144909596, 0.6313702802538814, 0.6062884451077941, 0.5246035432473871, 0.6075799307728745],
            [
                0.12598939190199576,
                0.5970339951540915,
                0.587534190168236,
                0.4900395906854257,
                0.5470087198430984,
                0.6680999166143209,
            ],
        ],
    },
    np.float64(15.028571428571427): {
        "betas": [
            [0.5210407807451181],
            [0.6178779619411978, 0.21230108533439648],
            [0.6504782425266088, 0.26383566522265006, 0.13102609983142557],
            [0.6985567629658703, 0.35038218113493724, 0.24352487070200018, 0.15379877487974403],
            [0.6952993366667888, 0.35410915118411496, 0.2671463450425944, 0.21696130423935509, 0.12503773641337282],
            [
                0.7005887982739827,
                0.3606840913050635,
                0.2680589800545616,
                0.23240819003687524,
                0.16948320168943032,
                0.09307378383923777,
            ],
        ],
        "gammas": [
            [0.1501666311054718],
            [0.14253549058463966, 1.00253337594868],
            [0.13564819438738665, 0.8581745037779405, 0.8950660896592804],
            [0.1336470878647229, 0.7869009517824478, 0.6959695056860299, 0.6284996946703378],
            [0.13193141475944922, 0.7313060071675979, 0.655010901592926, 0.5415310798708487, 0.602702153358964],
            [
                0.1281778480241624,
                0.6758517697137304,
                0.6452727977600792,
                0.5091282121728145,
                0.5342275207949573,
                0.6488854603193533,
            ],
        ],
    },
    np.float64(16.521428571428572): {
        "betas": [
            [0.5635449717295881],
            [0.6435644375656402, 0.1816012306459228],
            [0.6630316015028921, 0.20350735414031818, 0.11264217428040317],
            [0.7985567629658703, 0.33880950180800135, 0.21442991626340796, 0.13355772019071044],
            [0.7952993366667888, 0.35857996039623574, 0.2580097967911531, 0.20387011234788774, 0.121107137460658],
            [
                0.790931912198713,
                0.3578503901421354,
                0.25633697635655905,
                0.22010063265749472,
                0.1673600785197558,
                0.09538229530747853,
            ],
        ],
        "gammas": [
            [0.14653494594291397],
            [0.14126268497198852, 1.1025333759486802],
            [0.13679389609939197, 0.9581745037779404, 0.9950660896592803],
            [0.12326449661768116, 0.6869009517824478, 0.7831162715242699, 0.7284996946703378],
            [0.12196338287445603, 0.6313060071675979, 0.6846899376963813, 0.6046952424884445, 0.6642817403751368],
            [
                0.11704274703569753,
                0.5758517697137304,
                0.6870418604845819,
                0.5746977220568568,
                0.5820011111916673,
                0.6761886747030196,
            ],
        ],
    },
    np.float64(18.014285714285712): {
        "betas": [
            [0.6123011489116849],
            [0.6435290551797436, 0.10800036043579574],
            [0.6659144666040164, 0.12355123412019171, 0.10177068738401106],
            [0.8721266443807965, 0.3280362770238149, 0.18536674062666553, 0.10914323809705677],
            [0.874183656086362, 0.34976876367535287, 0.2201926165720682, 0.15802732781114837, 0.09379280994310635],
            [
                0.8671030780559992,
                0.35254325315131396,
                0.2229310185648831,
                0.17113566650226428,
                0.1277503400971088,
                0.07818299027407209,
            ],
        ],
        "gammas": [
            [0.1447617715772501],
            [0.13544471914899694, 1.00253337594868],
            [0.13297750155188068, 0.8581745037779405, 1.0950660896592803],
            [0.11814688548749085, 0.5869009517824478, 0.7974472668617106, 0.8284996946703378],
            [0.11657608944867144, 0.5313060071675979, 0.6805228325627146, 0.6924561240560361, 0.7642817403751367],
            [
                0.11151677981759829,
                0.47585176971373044,
                0.6482919660292967,
                0.6496066915845501,
                0.6820011111916673,
                0.7708972755663572,
            ],
        ],
    },
    np.float64(19.507142857142856): {
        "betas": [
            [0.6713817136376371],
            [0.6805941132049667, 0.10480093686493822],
            [0.6786205993460066, 0.12117826524585301, 0.017723097554270956],
            [0.8241724761091342, 0.28205854955607096, 0.1330711831383147, 0.07379056454511496],
            [0.8493363468136572, 0.3046964165637816, 0.15869159769575694, 0.09534512683096559, 0.058870715265066764],
            [
                0.8468689626701099,
                0.2930271354328478,
                0.16428169736624745,
                0.10744352844725649,
                0.07505088020574885,
                0.049364170081152306,
            ],
        ],
        "gammas": [
            [0.1453600486668083],
            [0.1312112954974706, 0.9025333759486801],
            [0.12635050283009416, 0.7581745037779405, 1.1950660896592804],
            [0.11296463716669829, 0.48690095178244786, 0.8302847977657309, 0.9284996946703378],
            [0.10969051814665394, 0.4313060071675979, 0.6876330946693949, 0.792456124056036, 0.8642817403751367],
            [
                0.11450485658454704,
                0.447883144252963,
                0.6638056815711516,
                0.7496066915845501,
                0.7820011111916673,
                0.8708972755663572,
            ],
        ],
    },
    np.float64(21.0): {
        "betas": [
            [0.738203842694519],
            [0.7367657183653182, 0.17377595366480447],
            [0.7316576798175284, 0.19779295208449577, 0.07851998867966693],
            [0.7241724761091343, 0.2510736945957611, 0.07261456856592964, 0.07858667495387696],
            [0.7493363468136572, 0.3082530287960813, 0.1118817690984917, 0.0401088468659602, 0.07575343757719027],
            [
                0.7468689626701099,
                0.2853622046985899,
                0.09361256884426389,
                0.06559503438233831,
                0.010421876843007117,
                0.09007198290407437,
            ],
        ],
        "gammas": [
            [0.1477011965189134],
            [0.1240542973961817, 0.8025333759486801],
            [0.1177870491440931, 0.6581745037779405, 1.2950660896592805],
            [0.10134049709319873, 0.43557158635771537, 0.9302847977657309, 1.0284996946703377],
            [0.08628036812127123, 0.3331451953455175, 0.7876330946693949, 0.892456124056036, 0.9642817403751367],
            [
                0.09105158879968371,
                0.34788314425296296,
                0.7638056815711516,
                0.84960669158455,
                0.8820011111916672,
                0.9708972755663572,
            ],
        ],
    },
}

RESULTS_D2 = {
    0: {
        "betas": [
            [0.3926991252619918],
            [0.5549051237721601, 0.29237987239232804],
            [0.6089509424721529, 0.4595686196037259, 0.23567043431511944],
            [0.5995613734276268, 0.4343440409570392, 0.2967592718746953, 0.15903500318418676],
            [0.6316671597910121, 0.5225297905520666, 0.3901364693496912, 0.27599098626397284, 0.14929859281483934],
            [
                0.6358847270434436,
                0.5344277492684157,
                0.4633366359963968,
                0.3599963095313253,
                0.2585871210080726,
                0.13884498944129223,
            ],
        ],
        "gammas": [
            [0.43520988794416826],
            [0.3449528208134802, 0.634871609690328],
            [0.29830092858225005, 0.5645572412243385, 0.6625462677483983],
            [0.28903054212962653, 0.5519458695832113, 0.6986457212244963, 0.8180564932223263],
            [0.2540202421313629, 0.49928024486811584, 0.5813064354193587, 0.710078944846307, 0.815958735625709],
            [
                0.23430760776033022,
                0.4564825560168702,
                0.5173495212137066,
                0.5918090212670899,
                0.7142965610714378,
                0.7970631233879952,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.3926701655998029],
            [0.5544230709216382, 0.29211907663282943],
            [0.6086855954425913, 0.458724192596069, 0.23552526997593254],
            [0.6007992812235454, 0.4404814025581096, 0.30502628403165666, 0.15863050870574757],
            [0.6297969808057786, 0.5194810369492022, 0.39271471387243445, 0.28124280655407735, 0.14871583357005444],
            [
                0.6354640284579196,
                0.5333639355271388,
                0.4607251009175086,
                0.3628957964911142,
                0.26323211084923975,
                0.13719814394844487,
            ],
        ],
        "gammas": [
            [0.43413754447228836],
            [0.3440553970091063, 0.6347836401023162],
            [0.29750828850560496, 0.5636509421458753, 0.6610842299617966],
            [0.2888474199129471, 0.5518947160738285, 0.6891750101222709, 0.805134373236596],
            [0.25284015221771844, 0.4975574501552429, 0.5794763802988836, 0.7002009852076403, 0.803248797508854],
            [
                0.23291838084845715,
                0.45550742631701696,
                0.5165366801781672,
                0.5889217162070548,
                0.7037296395828364,
                0.7853863917126083,
            ],
        ],
    },
    np.float64(0.37857142857142856): {
        "betas": [
            [0.392432244486008],
            [0.5481701182201091, 0.28850365042537424],
            [0.6047619883263132, 0.4465736205083313, 0.23272880881771643],
            [0.6159592835823506, 0.4924321499964671, 0.3693669836283551, 0.17994966413036628],
            [0.6247393636234159, 0.5091377549204114, 0.4189757644224738, 0.31583217061397784, 0.15495163749290844],
            [
                0.6296787070672342,
                0.5235592189478699,
                0.4526362180376582,
                0.3892567194265722,
                0.2957938553616298,
                0.14189280906241833,
            ],
        ],
        "gammas": [
            [0.4202344121493067],
            [0.33365702435067335, 0.634471997851586],
            [0.28909536011043374, 0.5549244550315522, 0.6459503048575213],
            [0.27197706174443276, 0.5274046409399056, 0.6166939639574002, 0.705134373236596],
            [0.24583472957427635, 0.48467698680885835, 0.5541765969083274, 0.6326747041076464, 0.7212301815696581],
            [
                0.21816170311459265,
                0.43938873884761565,
                0.5004019417564308,
                0.5474037939846169,
                0.6233895420316522,
                0.6930009377258707,
            ],
        ],
    },
    np.float64(0.6571428571428571): {
        "betas": [
            [0.39316793233142094],
            [0.5360524241340382, 0.28036570041015596],
            [0.5959503081162909, 0.4192492705531684, 0.22489881899497643],
            [0.6170453664423524, 0.4979530278991807, 0.3700115860833035, 0.18982477934986652],
            [0.623112388572178, 0.4997918274377642, 0.4307477430265195, 0.3212380484901755, 0.15878173021008732],
            [
                0.6279633318568807,
                0.5158513278632031,
                0.4514029567210911,
                0.403269251372466,
                0.3001086327960566,
                0.1507879134429298,
            ],
        ],
        "gammas": [
            [0.3929813999381717],
            [0.31795132558310657, 0.6372394686194589],
            [0.2779900151564983, 0.54719724766994, 0.6282637018010498],
            [0.2531597669154762, 0.5082829157180891, 0.5850488945258606, 0.638192877891247],
            [0.23786453255248663, 0.47501213782344615, 0.5385545606225102, 0.5991985639928349, 0.6810100219527339],
            [
                0.2089766260774642,
                0.4291211306786446,
                0.4913891574634607,
                0.5205658290447469,
                0.5881220026522851,
                0.6492169888343744,
            ],
        ],
    },
    np.float64(0.9357142857142857): {
        "betas": [
            [0.39704790464113915],
            [0.5210487268891325, 0.26774905916600916],
            [0.5819688588497501, 0.37896575012486317, 0.21322940920010755],
            [0.607422272058488, 0.47660174847735265, 0.34676841739580855, 0.18616524152132852],
            [0.6189125271639513, 0.482897874551065, 0.42585205241947527, 0.3116230428688035, 0.15410354964372253],
            [
                0.633272347367378,
                0.5100992507120203,
                0.4519546903648071,
                0.41216525555399264,
                0.2900173518579751,
                0.15326278178061511,
            ],
        ],
        "gammas": [
            [0.3589670500917154],
            [0.30328507556598294, 0.6464247594885215],
            [0.2681273235289207, 0.5473330339214932, 0.6192521897568373],
            [0.2363854885269039, 0.4965151241781302, 0.5798547472081557, 0.6104855666995992],
            [0.22605771347512424, 0.46453611737118555, 0.5343536257789157, 0.5816019670812648, 0.6536700813850901],
            [
                0.20726048915682135,
                0.43289119271213783,
                0.4964697819735709,
                0.5184139250187345,
                0.5838407293528,
                0.6414863121460633,
            ],
        ],
    },
    np.float64(1.2142857142857144): {
        "betas": [
            [0.405745428703681],
            [0.5061286576392502, 0.2507726752573201],
            [0.5596886617598372, 0.32732418859208845, 0.2001825602890144],
            [0.5932900617304167, 0.4311171923822986, 0.30941623611541313, 0.17531432880739395],
            [0.6103129457727094, 0.45274869198639267, 0.40200291155241397, 0.2976290257271088, 0.14865711490774236],
            [
                0.6395504933542454,
                0.4964455289176609,
                0.45231874711163433,
                0.4127750123059961,
                0.27091201260664044,
                0.1508176650554506,
            ],
        ],
        "gammas": [
            [0.3256351571445877],
            [0.2911109021537111, 0.6635512207046375],
            [0.2607884705804105, 0.557356876361381, 0.6251167765649258],
            [0.2185076891955334, 0.48296689121857656, 0.5856042756548179, 0.5961095564971348],
            [0.20639112893649392, 0.43858610477489063, 0.5293258281100037, 0.569325287733219, 0.6113588173333779],
            [
                0.20509198612991833,
                0.4387241648266363,
                0.5036647902270008,
                0.5293194048644935,
                0.5901615465697952,
                0.6526976061551796,
            ],
        ],
    },
    np.float64(1.4928571428571429): {
        "betas": [
            [0.4195353145028524],
            [0.4934532344717927, 0.22882704327327272],
            [0.5238263556392014, 0.26295082909007794, 0.18768430465872374],
            [0.5690754060080112, 0.35017406645825216, 0.25200104342901186, 0.15065517766232647],
            [0.5994945496425119, 0.4107129461025098, 0.3625402867422581, 0.27537307059152355, 0.15102281419662866],
            [
                0.6417025857220878,
                0.46629734168305187,
                0.44455810718603944,
                0.3895450602755707,
                0.24466733304079746,
                0.1404555935838335,
            ],
        ],
        "gammas": [
            [0.2972131937761348],
            [0.27981592118835247, 0.6873927189200061],
            [0.25749034807366894, 0.5810708637110132, 0.6524000014595106],
            [0.19759030959922055, 0.46465991253048633, 0.6059193574080344, 0.5982706343239904],
            [0.18660170869103884, 0.3967947954467966, 0.5302546408996252, 0.5735740434838397, 0.5742565047915772],
            [
                0.19425744074675286,
                0.42773233620351886,
                0.5099459415519024,
                0.5469593729696391,
                0.5917679030279631,
                0.6681897494809415,
            ],
        ],
    },
    np.float64(1.7714285714285716): {
        "betas": [
            [0.4377647390607584],
            [0.4857572362303697, 0.20015795605470088],
            [0.4694148539299743, 0.1811563538174728, 0.18089628936924912],
            [0.5648664025959788, 0.26900096196140466, 0.19410394421048804, 0.1344025117030214],
            [0.5961280404380892, 0.3881582523538985, 0.30865230026080404, 0.24171564223460787, 0.15171166225571378],
            [
                0.6149231365566036,
                0.4112474006132996,
                0.38664160768428535,
                0.32596489498516723,
                0.2353487650278966,
                0.12806674849716,
            ],
        ],
        "gammas": [
            [0.2744978428485286],
            [0.26438290824847405, 0.695535829825034],
            [0.2557338134547499, 0.6220244456268191, 0.7017158116931029],
            [0.17756163935519645, 0.4538611638850092, 0.6561475261371412, 0.6150754641354125],
            [0.18562654357481084, 0.37930850970358526, 0.5667759169652774, 0.599456471127044, 0.5645670057880902],
            [
                0.16176974744366143,
                0.3617135943930599,
                0.48942886843093913,
                0.5677688658830402,
                0.5707290852428658,
                0.6134798856913207,
            ],
        ],
    },
    np.float64(2.0500000000000003): {
        "betas": [
            [0.4595826335285512],
            [0.49411880841554406, 0.17018854646231532],
            [0.44363587267024635, 0.124189544469609, 0.1643554684449556],
            [0.6648664025959787, 0.2880451815343235, 0.187810918250206, 0.19170340835125332],
            [0.5886653454712509, 0.42016938067318826, 0.24928042076157383, 0.21876818784106355, 0.18366897489633022],
            [
                0.5921006316870977,
                0.3567245688052866,
                0.34009904741807473,
                0.24988179635873178,
                0.20783887083168456,
                0.14883670816866165,
            ],
        ],
        "gammas": [
            [0.2567353368562536],
            [0.2324856236938237, 0.5955358298250341],
            [0.23238357776660926, 0.5940698132967732, 0.7255533769454603],
            [0.23471872917242498, 0.4685689538871054, 0.6859155691332415, 0.6391301209275866],
            [0.19649864782466364, 0.4793085097035853, 0.6377782521113503, 0.6309887186198371, 0.5823140721218744],
            [
                0.15326118131912939,
                0.34852637906686224,
                0.5003557154148061,
                0.6193136257826193,
                0.5954792553691428,
                0.5902133572424483,
            ],
        ],
    },
    np.float64(2.3285714285714287): {
        "betas": [
            [0.4842665506606194],
            [0.5148776836927461, 0.16096011848724745],
            [0.5040771282380931, 0.15000743928427138, 0.08828078529123971],
            [0.7648664025959787, 0.3717463423421117, 0.2163613180213081, 0.15611329594824047],
            [0.5738353159739057, 0.3459068352437052, 0.15805067865856579, 0.17462995321428645, 0.20411489359181462],
            [
                0.649992775527516,
                0.3056708196137008,
                0.3014942934925833,
                0.19175736288676376,
                0.16732144287096884,
                0.1637893459233222,
            ],
        ],
        "gammas": [
            [0.24287873492257628],
            [0.20421045115560907, 0.4955358298250341],
            [0.20059795934935834, 0.49406981329677324, 0.6557277838780845],
            [0.21902522769780505, 0.3685689538871054, 0.5859155691332415, 0.5627613822694646],
            [0.20408770321784178, 0.5793085097035853, 0.6005617413020332, 0.6750366857102313, 0.575818427093296],
            [
                0.1727865110251052,
                0.39386326430045615,
                0.600355715414806,
                0.6261756497508593,
                0.6398481880040628,
                0.5679548202141745,
            ],
        ],
    },
    np.float64(2.607142857142857): {
        "betas": [
            [0.511270078259478],
            [0.5365741821983838, 0.18438064238440188],
            [0.5427427599781622, 0.18787470861146863, 0.03762791955392023],
            [0.8648664025959787, 0.45804385502862377, 0.24213884196642252, 0.1148021536133567],
            [0.6738353159739057, 0.4459068352437052, 0.2580506786585658, 0.17011463475417007, 0.1332391458942093],
            [
                0.749992775527516,
                0.33350918645868766,
                0.296495395591798,
                0.13588435114830266,
                0.15608747637570228,
                0.1667942125355,
            ],
        ],
        "gammas": [
            [0.23202299951799496],
            [0.17544461869540168, 0.3955358298250341],
            [0.17257990156078717, 0.39406981329677326, 0.5557277838780845],
            [0.20577095341026314, 0.3095160156924707, 0.4859155691332415, 0.5847906908275322],
            [0.18848852261814777, 0.4793085097035853, 0.5005617413020332, 0.5750366857102314, 0.5087620083403932],
            [
                0.18531226740488474,
                0.3731455894348075,
                0.700355715414806,
                0.5261756497508593,
                0.6330367410751835,
                0.5400126093001865,
            ],
        ],
    },
    np.float64(2.8857142857142857): {
        "betas": [
            [0.5401609009532893],
            [0.570583346084033, 0.207638356342928],
            [0.5693615300220403, 0.2564982122893094, 0.06647672779942741],
            [0.9147380549146993, 0.4679298460294199, 0.21825122761888574, 0.09969583958335913],
            [0.7738353159739056, 0.5459068352437052, 0.31238204068091935, 0.15686905805798507, 0.12482395785378006],
            [
                0.849992775527516,
                0.39335827349554225,
                0.23199242347402405,
                0.09718251905167131,
                0.05608747637570227,
                0.1322937281437472,
            ],
        ],
        "gammas": [
            [0.22347329143045694],
            [0.1622141055636892, 0.37070661088914875],
            [0.13549046160349063, 0.2940698132967733, 0.45572778387808455],
            [0.1621532091855863, 0.2606620984260628, 0.3952017451090808, 0.49062686209342354],
            [0.18130022435423818, 0.3793085097035853, 0.41625695172610944, 0.4750366857102314, 0.44160782852601277],
            [
                0.21541217292925463,
                0.3210341153315869,
                0.600355715414806,
                0.5584298388464158,
                0.640250342982737,
                0.5624682289435312,
            ],
        ],
    },
    np.float64(3.1642857142857146): {
        "betas": [
            [0.5705189498275126],
            [0.6179847042712894, 0.23310625599149165],
            [0.6693615300220402, 0.3295423233908212, 0.11412866213444295],
            [0.8147380549146993, 0.5424308427871867, 0.2226962623747184, 0.07014447545914837],
            [0.6738353159739057, 0.4459068352437052, 0.21238204068091934, 0.06807002589601632, 0.07930558962008717],
            [
                0.749992775527516,
                0.3194052317896983,
                0.13199242347402404,
                0.07074169319908677,
                0.15608747637570228,
                0.05971303290679587,
            ],
        ],
        "gammas": [
            [0.21670217328769054],
            [0.15687867303215583, 0.374544724934134],
            [0.1416479247554239, 0.3182968968874934, 0.5557277838780845],
            [0.06215320918558628, 0.2096737532124733, 0.40222709119355876, 0.5906268620934235],
            [0.10065022155459874, 0.27930850970358534, 0.4727984607356946, 0.4857282615401863, 0.3416078285260128],
            [
                0.11541217292925463,
                0.28244068657899996,
                0.5003557154148061,
                0.6336941048887871,
                0.7313938284232813,
                0.6624682289435312,
            ],
        ],
    },
    np.float64(3.442857142857143): {
        "betas": [
            [0.6017930014696485],
            [0.6717527228345745, 0.2617364901307672],
            [0.653150304499253, 0.32528037217980293, 0.1836521813584651],
            [0.7147380549146993, 0.4424308427871867, 0.21128999942089066, 0.17014447545914838],
            [0.5972869175382518, 0.34590683524370525, 0.13293101912588678, 0.08612466512312922, 0.1793055896200872],
            [
                0.8046119328336667,
                0.2709472749260615,
                0.05980224943579973,
                0.03273254598236194,
                0.2560874763757023,
                0.1358364610125214,
            ],
        ],
        "gammas": [
            [0.21127861943063952],
            [0.15956475457037406, 0.397447837100533],
            [0.15884577772838265, 0.38133560826415275, 0.6557277838780845],
            [0.08327490478375435, 0.25871564877290687, 0.5022270911935588, 0.6906268620934235],
            [0.09886481318963694, 0.26197700978328786, 0.514888331842156, 0.5857282615401863, 0.44160782852601277],
            [
                0.09690790561924019,
                0.243087231111042,
                0.4868832660483401,
                0.6127579686532822,
                0.8313938284232812,
                0.5624682289435312,
            ],
        ],
    },
    np.float64(3.7214285714285715): {
        "betas": [
            [0.6331150867674918],
            [0.7098633779765833, 0.29178423903650663],
            [0.6447128253496395, 0.2862291667436841, 0.2305668370688258],
            [0.6147380549146994, 0.3424308427871867, 0.15608743256530597, 0.21106605517013352],
            [0.6796748822209244, 0.37435858706172814, 0.15777887378946373, 0.09251231252566582, 0.17866813097000012],
            [
                0.7596155405704268,
                0.36608380159133824,
                0.1530135667527609,
                0.08890255638851459,
                0.20838051762972978,
                0.03583646101252139,
            ],
        ],
        "gammas": [
            [0.20679283934119108],
            [0.166102716829004, 0.42993762111431716],
            [0.15325168444905912, 0.37777835844575247, 0.7557277838780845],
            [0.10691444049329392, 0.2533039059786499, 0.4873697572996404, 0.71733580211805],
            [0.09185136118497765, 0.2293531259903616, 0.414888331842156, 0.5495289933223769, 0.5416078285260127],
            [
                0.10466962275388567,
                0.22088853585615387,
                0.3868832660483401,
                0.5127579686532823,
                0.7313938284232813,
                0.46246822894353123,
            ],
        ],
    },
    np.float64(4.0): {
        "betas": [
            [0.6631441751966786],
            [0.7180147101812097, 0.3150042963997564],
            [0.6602429157905192, 0.3169271388029308, 0.2247707583191095],
            [0.6409630875218749, 0.36774615126907495, 0.17994940653068575, 0.18607677834200168],
            [0.7267559113310958, 0.4194950436541564, 0.2042388790146531, 0.1234605313489146, 0.18404713758765043],
            [
                0.7293851337000493,
                0.40486766868632834,
                0.1942251754397535,
                0.12428478860806508,
                0.20293116814840342,
                -0.013414371118933463,
            ],
        ],
        "gammas": [
            [0.20279518742787625],
            [0.16357863399455275, 0.441182468336225],
            [0.13402072352727673, 0.32276981239368885, 0.6694741639625843],
            [0.09720290461250626, 0.22088856314047345, 0.40268052849512426, 0.6253445866768815],
            [0.08556394207049917, 0.18587360068960887, 0.31488833184215603, 0.44952899332237695, 0.6330532218550254],
            [
                0.08682628383770245,
                0.18586159194233562,
                0.2993891728743395,
                0.425826715625715,
                0.6662555227312994,
                0.45559300071042724,
            ],
        ],
    },
}

RESULTS_D3 = {
    0: {
        "betas": [
            [0.3926990801685778],
            [0.5341143907365213, 0.28296192962248656],
            [0.5879397222715685, 0.42317243548258154, 0.22301986221380685],
            [0.6049850210641714, 0.4777930601890226, 0.36126679686371455, 0.1875197805918464],
            [0.6225451528064808, 0.5050746395078414, 0.4167360632919346, 0.32535665395308383, 0.16281526247793313],
            [
                0.6293430292234257,
                0.5231980200253777,
                0.45283945561496786,
                0.38835347438032364,
                0.29815836946971375,
                0.14596335718485912,
            ],
        ],
        "gammas": [
            [0.45344983951258905],
            [0.3531970329724108, 0.6406347351215561],
            [0.30701174938738357, 0.5641029337232988, 0.6532048060251348],
            [0.2728005050227052, 0.5088273810807932, 0.5830208229265289, 0.6678794373649496],
            [0.251927493240726, 0.4735058694195087, 0.5224927146586312, 0.5951185781456014, 0.6793493489575362],
            [
                0.23272459211892937,
                0.4440990195519296,
                0.48811109253575696,
                0.5318412063848126,
                0.6024716163793716,
                0.6812866687971141,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.39266587149671855],
            [0.533994543184008, 0.28294207511168334],
            [0.587794349020979, 0.4229269058881462, 0.22301384088082923],
            [0.6050080768788444, 0.4776812308901347, 0.3608769492728685, 0.18732643521799702],
            [0.622391664558163, 0.5048254859392581, 0.41644660904149067, 0.32489483916653855, 0.16267610994320153],
            [
                0.6293844834942891,
                0.523049671998241,
                0.4524020998047285,
                0.38800684097065985,
                0.2976421245894232,
                0.14571098487524178,
            ],
        ],
        "gammas": [
            [0.45267532563816365],
            [0.3525386800300351, 0.6406945232010645],
            [0.3063886660499473, 0.5637775149387525, 0.6526801028054016],
            [0.2725308472279935, 0.5090156773906876, 0.5830193605424739, 0.6674468737177824],
            [0.2515330132790935, 0.47346634564197004, 0.5225879284125933, 0.5946514589037095, 0.6788517090436258],
            [
                0.2324738415937587,
                0.4441933252734065,
                0.48827172694209015,
                0.5317610752346857,
                0.6023867379868124,
                0.6809635688968794,
            ],
        ],
    },
    np.float64(0.45000000000000007): {
        "betas": [
            [0.3919991572698686],
            [0.53187650540454, 0.28240288883224834],
            [0.5854680451591285, 0.4180916168087855, 0.222698700835872],
            [0.6052218331125941, 0.47523548653187714, 0.35394069435606773, 0.18412145467514715],
            [0.6200169554022503, 0.5002417199394785, 0.4117002098619608, 0.31689472721393647, 0.1601319973024404],
            [
                0.6296905539800263,
                0.5193785344853663,
                0.44388517210197836,
                0.3810484797199106,
                0.2879466666026531,
                0.1415977361236678,
            ],
        ],
        "gammas": [
            [0.4381727535887407],
            [0.3411184288091738, 0.6423171067022793],
            [0.29597172668282085, 0.5587146422867943, 0.6441911185476592],
            [0.2673899564470331, 0.5116207362998688, 0.5822115863731312, 0.6587318300640868],
            [0.24527979204681694, 0.47308424856016607, 0.5244766778238469, 0.5872693121376669, 0.6711112969389332],
            [
                0.22803960218287986,
                0.4457656281684282,
                0.49080073963166204,
                0.5298283532639655,
                0.6002394550795743,
                0.6745983967108327,
            ],
        ],
    },
    np.float64(0.8): {
        "betas": [
            [0.39182710624013917],
            [0.5282100024824087, 0.28022625642652116],
            [0.5820252362204792, 0.40639448649707843, 0.22041580676585626],
            [0.6057551304436264, 0.4697716311394929, 0.34209569654152266, 0.18027571371934376],
            [0.6177385143774395, 0.49112135557602404, 0.4029515379858193, 0.30228272208556045, 0.1543524207847499],
            [
                0.6277702559050875,
                0.5067871120078545,
                0.42591932681040356,
                0.3657461699633728,
                0.2668797813746209,
                0.13410065799501203,
            ],
        ],
        "gammas": [
            [0.4082932683032098],
            [0.32188541095386525, 0.6484110294805705],
            [0.27954126173731964, 0.5528963863384682, 0.6328354641316886],
            [0.2568310772924397, 0.5136645160992607, 0.5782928301911422, 0.6377428456021536],
            [0.23684197050955003, 0.4750269640054432, 0.5295470608999115, 0.5777589252519708, 0.6603497057732913],
            [
                0.22050285715557158,
                0.44795659252860626,
                0.4951324952527891,
                0.5273779117648928,
                0.5960656303184771,
                0.6641358413595153,
            ],
        ],
    },
    np.float64(1.1500000000000001): {
        "betas": [
            [0.3947225615754426],
            [0.5245949033350289, 0.2749284312132236],
            [0.5784583702518432, 0.38649347918132876, 0.21484614254914514],
            [0.6050698555744489, 0.4581699182666868, 0.32800195170729707, 0.17827096910421425],
            [0.6182492581787824, 0.47980953321511927, 0.3923823331539179, 0.28771485397941055, 0.1475058929486499],
            [
                0.6233580688147017,
                0.48489857985167223,
                0.405782261850426,
                0.34712102746463014,
                0.24074489279060834,
                0.1261287382808011,
            ],
        ],
        "gammas": [
            [0.37069613534283125],
            [0.3030254607434018, 0.6616588733327942],
            [0.2639481132534435, 0.5514111775329291, 0.6263674961173642],
            [0.24348471672923322, 0.511000679059383, 0.5728783335603567, 0.6095683399861423],
            [0.22853131759449916, 0.4786046224960265, 0.5352657555310363, 0.5674006417312285, 0.645065840552353],
            [
                0.21340540903536964,
                0.4502401309570509,
                0.5021418809171148,
                0.5286211739402964,
                0.5929084728125324,
                0.6588756311834676,
            ],
        ],
    },
    np.float64(1.5000000000000002): {
        "betas": [
            [0.402823758437259],
            [0.5214357925760958, 0.2651159453674046],
            [0.5738866055793703, 0.35772896404013355, 0.20678846748798263],
            [0.5996104767805012, 0.4321890883185474, 0.3081715343041295, 0.17437263495414482],
            [0.6191665894364787, 0.463208465879756, 0.3776253688113015, 0.2770540866036298, 0.1425533229557783],
            [
                0.6217126315779101,
                0.4623778830949061,
                0.39811747489445326,
                0.33961378833411193,
                0.22684678102960704,
                0.12283873701468456,
            ],
        ],
        "gammas": [
            [0.3341628302811785],
            [0.28773619164019937, 0.6827769357909025],
            [0.2512471520816955, 0.5553744694658983, 0.6294289399785205],
            [0.22998490703259566, 0.5033821191315325, 0.5727885081109002, 0.5883194952671387],
            [0.2171122904739703, 0.4753637489118472, 0.5371629249511326, 0.5546452799904844, 0.6148869407817994],
            [
                0.20390804858657235,
                0.4431669825214578,
                0.5070374420827554,
                0.5247928361662489,
                0.5759248413192236,
                0.6480090998317674,
            ],
        ],
    },
    np.float64(1.8500000000000003): {
        "betas": [
            [0.41654249362171186],
            [0.5182999783040397, 0.24952975903363553],
            [0.5669224190552224, 0.32065927918305254, 0.19799379684886498],
            [0.5842988531162884, 0.38225917868952974, 0.2778217102164339, 0.1630269651093467],
            [0.6160036474576568, 0.4328708463617019, 0.354235953669014, 0.26660328907616615, 0.14304258880386184],
            [
                0.6200802580444997,
                0.43572261332140083,
                0.3915042297420491,
                0.33128040841305767,
                0.22344311752685184,
                0.11827829573301926,
            ],
        ],
        "gammas": [
            [0.30349164362560793],
            [0.27538189688387554, 0.7105371104730968],
            [0.24168890529954015, 0.5653235228002123, 0.6480944801420321],
            [0.21487017073807052, 0.4844298927911811, 0.5814313097522666, 0.5832693078040049],
            [0.20055649162524322, 0.4558983909077215, 0.5381063780559427, 0.5483488135540914, 0.574645877345484],
            [
                0.18676205067893736,
                0.4143511082995352,
                0.5091308527632274,
                0.5236459795437137,
                0.5492578562006954,
                0.6256004970206268,
            ],
        ],
    },
    np.float64(2.2): {
        "betas": [
            [0.43512054109738046],
            [0.514956064985825, 0.22661595258099282],
            [0.5558304515664135, 0.2755005682736845, 0.18878520566841933],
            [0.5606045418286906, 0.3154764281826159, 0.23867111619060288, 0.14738564984018337],
            [0.6152570807372507, 0.391463083973037, 0.3190273897973686, 0.2451628548000837, 0.14302858298343737],
            [
                0.6125126245738026,
                0.4011469430701465,
                0.36824330922477294,
                0.30567639063250474,
                0.2239676658555302,
                0.11604705899753028,
            ],
        ],
        "gammas": [
            [0.2793537403794191],
            [0.26355712467098047, 0.7380063830349072],
            [0.23572609258624594, 0.5847199178249675, 0.6936342525074001],
            [0.20159709090996578, 0.4627789447124172, 0.6089983682573444, 0.598374719235841],
            [0.18559990847947166, 0.43365820317131587, 0.5517854484710332, 0.5610033012561376, 0.5532151785368656],
            [
                0.16593416334511904,
                0.36799053191154724,
                0.5083627487168254,
                0.5336917817830924,
                0.5287881269593867,
                0.5773566985504378,
            ],
        ],
    },
    np.float64(2.5500000000000003): {
        "betas": [
            [0.4575861939776255],
            [0.5123722491491788, 0.19450218851089698],
            [0.5357859396609429, 0.21709839198802314, 0.17737210151855362],
            [0.5314033058752087, 0.2443235628817871, 0.18961806289708888, 0.13413718858676102],
            [0.6325277197662951, 0.341558028758274, 0.2588972703742989, 0.2019016190385533, 0.12948227617613903],
            [
                0.618754844609764,
                0.38594329861779875,
                0.3292867484595256,
                0.2699633867695034,
                0.21462847030878637,
                0.11971993420617807,
            ],
        ],
        "gammas": [
            [0.2607164876961823],
            [0.244946829245379, 0.714156510994564],
            [0.23483303082581522, 0.6249875820160917, 0.7936342525074],
            [0.19530901348063812, 0.4631394991427349, 0.6788834271279534, 0.6332479816559193],
            [0.1683407285932991, 0.4017207035382263, 0.5762104674083075, 0.5976210343116576, 0.5626363302851245],
            [
                0.16228984864569906,
                0.3647363742618866,
                0.5371532172185531,
                0.5546250014385924,
                0.5285898160132468,
                0.546155139023471,
            ],
        ],
    },
    np.float64(2.9000000000000004): {
        "betas": [
            [0.48316201302463746],
            [0.5202472309746206, 0.16524349362506663],
            [0.49406244196678173, 0.13020389648573386, 0.1638704186248598],
            [0.4995394746766771, 0.18251875356629738, 0.12333531213143306, 0.12981334495359714],
            [0.7307258878340348, 0.35965661867215704, 0.21458013784798077, 0.17742819644989183, 0.12156465049053393],
            [
                0.6185232523510729,
                0.3857932156049034,
                0.26959252635844977,
                0.22402136968759953,
                0.19345696243249674,
                0.12818907848542135,
            ],
        ],
        "gammas": [
            [0.24632825768170688],
            [0.21867316359198455, 0.614156510994564],
            [0.238461762495575, 0.7249875820160917, 0.8936342525074],
            [0.17618503595064836, 0.4194956074585877, 0.7788834271279533, 0.6672341307301556],
            [0.15569414328421274, 0.33919047769635235, 0.5516435678595563, 0.6492035155120038, 0.5897789049185427],
            [
                0.17114508193340935,
                0.41455800323769065,
                0.5940359948478631,
                0.5890076334887002,
                0.5429716817615887,
                0.5366272394117462,
            ],
        ],
    },
    np.float64(3.2500000000000004): {
        "betas": [
            [0.511311861274651],
            [0.5396951908247744, 0.16132291803208978],
            [0.5246824919380874, 0.12393573635505267, 0.09665257277718949],
            [0.5995394746766771, 0.27901115078647265, 0.10635441181917735, 0.09418100263570107],
            [0.8307258878340348, 0.44319616296634046, 0.24055179174854016, 0.16224497863532802, 0.10345864569563656],
            [
                0.7185232523510728,
                0.4731130321850644,
                0.24425444880997768,
                0.18596947246818146,
                0.15083805409318243,
                0.12448992402307107,
            ],
        ],
        "gammas": [
            [0.23516860426764752],
            [0.19523475367336401, 0.514156510994564],
            [0.21033217832098092, 0.6249875820160917, 0.8605754125590105],
            [0.12993612598426713, 0.32459619905885434, 0.6788834271279534, 0.7672341307301556],
            [0.16624409289813052, 0.2936062160939556, 0.4862835558314948, 0.6087639639247613, 0.6485355441435261],
            [
                0.15965156526672483,
                0.4164316754131831,
                0.498329451881287,
                0.5565865364173966,
                0.6125725391475388,
                0.5339622482189618,
            ],
        ],
    },
    np.float64(3.6000000000000005): {
        "betas": [
            [0.5416611676562251],
            [0.5611410606403389, 0.19058011330226104],
            [0.5722177099328583, 0.15610667311306323, 0.015095995049437488],
            [0.6995394746766771, 0.37901115078647263, 0.20635441181917735, 0.1257256159360679],
            [0.8902774074965826, 0.4336743545493802, 0.22996907895715735, 0.14303818298476484, 0.08065228764631059],
            [
                0.8185232523510728,
                0.4621216584848451,
                0.24684607855621277,
                0.1494511625541553,
                0.10409389855734295,
                0.0750626264367618,
            ],
        ],
        "gammas": [
            [0.2264862095999208],
            [0.1698997087523841, 0.4141565109945641],
            [0.19014662962388257, 0.5249875820160917, 0.7605754125590105],
            [0.1939644754428886, 0.32615392728245396, 0.5788834271279534, 0.6672341307301556],
            [0.18747407237880453, 0.30701949156904856, 0.44121036887825, 0.5382701474320792, 0.5880865403731225],
            [
                0.19350032427511032,
                0.3469050137202732,
                0.42752920053999915,
                0.47472520339361696,
                0.5674590027473789,
                0.5809339669382048,
            ],
        ],
    },
    np.float64(3.9500000000000006): {
        "betas": [
            [0.5738698917257316],
            [0.5970033395823495, 0.2159216604888193],
            [0.6114602182411573, 0.21026166946774674, 0.02143377778445986],
            [0.7995394746766771, 0.4074929891984279, 0.1948904316352401, 0.07453822735373532],
            [0.8186819078166977, 0.442825049260122, 0.2293933852608835, 0.12566636971456727, 0.05266621199029958],
            [
                0.7759846999268273,
                0.4667481768055934,
                0.24644962122361302,
                0.15411702200129282,
                0.08916215823687042,
                0.049011213216028776,
            ],
        ],
        "gammas": [
            [0.21972842403494935],
            [0.1593173563865225, 0.39531620310505805],
            [0.16487160288122138, 0.42498758201609177, 0.6605754125590105],
            [0.15783675728698968, 0.29753467359155406, 0.4788834271279534, 0.5672341307301556],
            [0.1434338231113439, 0.24011836014671975, 0.35646903173044237, 0.44863570799002656, 0.5389348620167145],
            [
                0.15246535222271815,
                0.2568572174672484,
                0.337380982838378,
                0.38324430806318627,
                0.4834935605576775,
                0.5322116590220528,
            ],
        ],
    },
    np.float64(4.3): {
        "betas": [
            [0.6074308696565077],
            [0.6454900433524589, 0.2392359308800383],
            [0.6745218189007676, 0.31026166946774675, 0.12143377778445986],
            [0.6995394746766771, 0.3457578678941803, 0.13720919039553653, 0.07514234950986495],
            [0.7186819078166977, 0.4950418677414044, 0.22321560985120112, 0.11180044566336275, 0.13529425537696407],
            [
                0.6759846999268273,
                0.37929374015842554,
                0.14644962122361302,
                0.0728120115312079,
                0.07752155360984934,
                0.14901121321602878,
            ],
        ],
        "gammas": [
            [0.2144443096189185],
            [0.15789236110109367, 0.4124598308121416],
            [0.15730779228220623, 0.38974150023837406, 0.7605754125590105],
            [0.1370452826881235, 0.3550110026221604, 0.5788834271279534, 0.6672341307301556],
            [0.054048210942244275, 0.21444222759683143, 0.4564690317304424, 0.5486357079900266, 0.6389348620167145],
            [
                0.076909191567433,
                0.22853852082586426,
                0.437380982838378,
                0.4832443080631863,
                0.5834935605576775,
                0.6322116590220528,
            ],
        ],
    },
    np.float64(4.65): {
        "betas": [
            [0.6413466674605617],
            [0.6948366459366646, 0.26562942058489164],
            [0.6602413104310346, 0.29968899092031787, 0.1918348927356658],
            [0.6183161492003357, 0.28128429778169295, 0.12389370343687899, 0.17514234950986496],
            [0.6694540701582582, 0.3950418677414044, 0.15934112263644307, 0.09042025252910632, 0.1965779268177175],
            [
                0.744466184076062,
                0.3391433805912866,
                0.1350977986087704,
                0.07578592820763996,
                0.0493485775099912,
                0.23767336907190917,
            ],
        ],
        "gammas": [
            [0.21017115241300602],
            [0.16332698360813638, 0.45087915599676287],
            [0.15394828359171228, 0.4097555114984026, 0.8605754125590105],
            [0.13767327723728115, 0.32920940753034555, 0.6236680515197608, 0.7672341307301556],
            [0.07962989309670099, 0.2251610172248835, 0.4477289623860351, 0.6486357079900266, 0.7389348620167144],
            [
                0.1043440269519194,
                0.2162730454135609,
                0.372675831080358,
                0.5156511680016019,
                0.5773190474613931,
                0.7322116590220528,
            ],
        ],
    },
    np.float64(5.0): {
        "betas": [
            [0.6737698774271855],
            [0.7179639861485227, 0.2923399619117777],
            [0.6685462260685956, 0.312288583303265, 0.20723619629160653],
            [0.6582734718880421, 0.35025500080187283, 0.1607420173654891, 0.1566748448766928],
            [0.7150821121082179, 0.40080174364815313, 0.1961208220108223, 0.1217984375558954, 0.1671359154519609],
            [
                0.6959690396669974,
                0.4139227725499704,
                0.21144004554127785,
                0.12401419471958983,
                0.08025030639733646,
                0.1578397203800361,
            ],
        ],
        "gammas": [
            [0.20632302988661028],
            [0.16401830556293684, 0.4752326683929598],
            [0.1377798570795968, 0.3558387462830444, 0.799561264185486],
            [0.11048985027151413, 0.264535188781861, 0.5236680515197608, 0.7509590637390436],
            [0.09156527368328236, 0.20311675236491336, 0.3589484582636325, 0.5486357079900266, 0.7915064429068123],
            [
                0.08346867760262144,
                0.17269399036444535,
                0.2866521495524125,
                0.41565116800160196,
                0.49172293457959465,
                0.6322116590220528,
            ],
        ],
    },
}

RESULTS_D4 = {
    0: {
        "betas": [
            [0.39269907750573085],
            [0.5241040036790748, 0.2788336776217047],
            [0.5783427232909192, 0.4076428392117487, 0.21894154746760125],
            [0.5971120737635922, 0.46319030094932656, 0.34484331506736715, 0.18258260808517376],
            [0.6138381269630766, 0.49040629898477894, 0.4025437809475607, 0.3089191314139715, 0.1576564180120724],
            [
                0.6219781509936191,
                0.5075967881962965,
                0.4329423544999184,
                0.3694089818737324,
                0.276930833559371,
                0.13768448334084832,
            ],
        ],
        "gammas": [
            [0.46364760049592396],
            [0.3586854100545976, 0.6450128938061294],
            [0.31163874331013053, 0.5635115723273098, 0.6477139561922856],
            [0.27743840428323996, 0.509646483488641, 0.5768746834515932, 0.6612429130299491],
            [0.2555455782971925, 0.47380578642206184, 0.5187025097377738, 0.589673560800124, 0.6708652722265005],
            [
                0.23798804851461025,
                0.4476244110476078,
                0.4861562225149076,
                0.530827004844199,
                0.6019611682992134,
                0.6792682517383435,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.3926426515801604],
            [0.5240362516021264, 0.2788590100136629],
            [0.5782380151480206, 0.40754977276489995, 0.21896970186098683],
            [0.5971231092541165, 0.4631669181655057, 0.3447000669038274, 0.18252869479920508],
            [0.6138342407622935, 0.49044921243060874, 0.40241542300101146, 0.3087170541946767, 0.15763272209360618],
            [
                0.622005094050673,
                0.5076086779711029,
                0.4328109239957959,
                0.3691942407913063,
                0.2767347476972246,
                0.13763424407499622,
            ],
        ],
        "gammas": [
            [0.46304618041670814],
            [0.35811830285616675, 0.6450381072161656],
            [0.3110894335041484, 0.5633316155457818, 0.6474788386739072],
            [0.2771034768247522, 0.509680357904046, 0.5768255661785512, 0.6609123199748548],
            [0.2551882997825962, 0.47381189502429716, 0.5187806061699268, 0.5892611753403503, 0.6705038126484624],
            [
                0.2377334212553192,
                0.44765511413538916,
                0.48623551438728774,
                0.5306330635321496,
                0.601745191299607,
                0.6789701383205214,
            ],
        ],
    },
    np.float64(0.5214285714285715): {
        "betas": [
            [0.3913636437720932],
            [0.5225827770070415, 0.2793684888873428],
            [0.5760657946895122, 0.4051406358413894, 0.21929517666271958],
            [0.5974076087928232, 0.4626073819120294, 0.34109003768002016, 0.18120991239485443],
            [0.613783051692772, 0.49031176755175676, 0.39852699488064425, 0.3034555339598246, 0.15664306287694824],
            [
                0.6231600388359652,
                0.5078811517640318,
                0.4293840541654746,
                0.3643222360579627,
                0.27194380452281963,
                0.13650551951900888,
            ],
        ],
        "gammas": [
            [0.4476641343473599],
            [0.3445968598356838, 0.6461957458923755],
            [0.29851229147940034, 0.5596788639971049, 0.6425033625243453],
            [0.2691111271455543, 0.510678466743699, 0.575689978135923, 0.652632600661074],
            [0.24736633809442424, 0.4741666549222838, 0.5202786756315841, 0.5798880654580084, 0.662758375828041],
            [
                0.23139817626820366,
                0.44821537602413447,
                0.4879481177296529,
                0.5254261053691508,
                0.5954046099188811,
                0.6706087033097361,
            ],
        ],
    },
    np.float64(0.9428571428571428): {
        "betas": [
            [0.3898883525934656],
            [0.521197465274156, 0.27975244164876495],
            [0.573878054757286, 0.39907010784214914, 0.2182724521138881],
            [0.5993234853682554, 0.46059881505245676, 0.3333856159788194, 0.17915348742324866],
            [0.6152262375780653, 0.4877200385469798, 0.3904108360811518, 0.2927452418031204, 0.15324520761245308],
            [
                0.6256016701325156,
                0.5048120343309372,
                0.42012278776705764,
                0.35474868631688733,
                0.2609319156968544,
                0.1343323235470134,
            ],
        ],
        "gammas": [
            [0.4147765983233483],
            [0.3209599962736349, 0.6520295060078186],
            [0.27820312921019175, 0.556529949494551, 0.6365939074348865],
            [0.2553347501634616, 0.5134879697918246, 0.5737724781343807, 0.6344697482457308],
            [0.2360720875444095, 0.4775757411505838, 0.5244560326290929, 0.5662559338278852, 0.650723117360573],
            [
                0.2208251094458859,
                0.4496643073152325,
                0.49092852963015177,
                0.5155377221437673,
                0.582269106024815,
                0.6536832228995094,
            ],
        ],
    },
    np.float64(1.3642857142857143): {
        "betas": [
            [0.3914835917961293],
            [0.5222369372735536, 0.2781406082576519],
            [0.5738109240787013, 0.38743693737136864, 0.21410144681541582],
            [0.6033774077560715, 0.4553129539527131, 0.3231221028049419, 0.17779109665804985],
            [0.6193723860242232, 0.48110774812284746, 0.3794619433686153, 0.2802817088441193, 0.1476514765655311],
            [
                0.6285927827928035,
                0.49496777304014,
                0.40611099677767565,
                0.34225820069682683,
                0.24425717414588896,
                0.13065153431260465,
            ],
        ],
        "gammas": [
            [0.3733830915917459],
            [0.29819296385148003, 0.6662569112147844],
            [0.2597011636904972, 0.5584411775097156, 0.6345132032889901],
            [0.24142918617724332, 0.517529648900489, 0.5727748653853932, 0.611355772285299],
            [0.22647275752116564, 0.4849669224898938, 0.5308346295500618, 0.5543075012422807, 0.63639660269291],
            [
                0.21132368192103537,
                0.4531110119347095,
                0.4963438121180851,
                0.5071763512972176,
                0.568007082911204,
                0.6384096438183666,
            ],
        ],
    },
    np.float64(1.7857142857142858): {
        "betas": [
            [0.3989065541156079],
            [0.5256657831079486, 0.27272091737154563],
            [0.5749141656716551, 0.3681767300575324, 0.20693388013419875],
            [0.6076833750846227, 0.44284065041344506, 0.310050209833655, 0.17633853824943785],
            [0.6249139748825886, 0.4693448944243491, 0.3661879721947455, 0.2698990387264176, 0.14214472881771506],
            [
                0.6323214203897605,
                0.4790306054524934,
                0.3911624477573328,
                0.32880711098942333,
                0.22632741686701946,
                0.1250032151200888,
            ],
        ],
        "gammas": [
            [0.33387936179460537],
            [0.2807050316811636, 0.6900713532045695],
            [0.24538753231610574, 0.5652512666104478, 0.6382493872130183],
            [0.22953448294406223, 0.5217668113958505, 0.5760789475133726, 0.5916597480709386],
            [0.21759547689798014, 0.4917966733199733, 0.5369766744578964, 0.5434213181051062, 0.6142899958471439],
            [
                0.20393595120896882,
                0.4580528378632441,
                0.5060532616715286,
                0.5044342281213958,
                0.5561013249950176,
                0.6312025545592309,
            ],
        ],
    },
    np.float64(2.2071428571428573): {
        "betas": [
            [0.412613957609386],
            [0.529918749291725, 0.2621736729774975],
            [0.5752401463022396, 0.3403381268567117, 0.1984535834901111],
            [0.6075824158102621, 0.41547110185932074, 0.290558295632744, 0.17079837275616291],
            [0.6289251755180101, 0.4492595824871055, 0.350130116584607, 0.26318908209055125, 0.14049753157158795],
            [
                0.6354699339041082,
                0.45532040044479477,
                0.3764466611101748,
                0.315848604974252,
                0.21358654365476787,
                0.11777352744622582,
            ],
        ],
        "gammas": [
            [0.3014923575122277],
            [0.26790539653050693, 0.7232115627191459],
            [0.23434478886724464, 0.5749031266963528, 0.6513068304418199],
            [0.21826255240261788, 0.5215347835834692, 0.5869847489255514, 0.5834446838767982],
            [0.20654317490896185, 0.4891216167726905, 0.5426059425036531, 0.5354341031690429, 0.581482180345045],
            [
                0.1944711781751769,
                0.4540312155421758,
                0.516262760068382,
                0.5061285319710803,
                0.5410161233297773,
                0.6232561330288107,
            ],
        ],
    },
    np.float64(2.6285714285714286): {
        "betas": [
            [0.43161195218665066],
            [0.533352463195498, 0.24505653710833186],
            [0.5734148623929443, 0.30430720384881654, 0.19050272074044244],
            [0.5934700953530749, 0.3594093805336342, 0.2606674443002009, 0.15678763286744837],
            [0.6282742581513254, 0.4151501854205274, 0.33118697064936214, 0.25550319579082914, 0.14423953426018926],
            [
                0.6259418884578409,
                0.4102746856887293,
                0.36289687952334077,
                0.3025842007588156,
                0.21644409729350939,
                0.11429265804113395,
            ],
        ],
        "gammas": [
            [0.27651778796275095],
            [0.25777523791778634, 0.7639294838332094],
            [0.22545991610093027, 0.5855478176325432, 0.6817151940654848],
            [0.20207420977773496, 0.4949271812258864, 0.6057523537920328, 0.5956108015780678],
            [0.1909676268169441, 0.4659618750612211, 0.5539451086499869, 0.5428872092769221, 0.554662646331568],
            [
                0.17017983229826164,
                0.39718110266812534,
                0.512023420352403,
                0.5185793466650235,
                0.5195200419132807,
                0.5870034270140007,
            ],
        ],
    },
    np.float64(3.0500000000000003): {
        "betas": [
            [0.4547481719904531],
            [0.5345988921488624, 0.21893518878311602],
            [0.5688832478031765, 0.26163092248855996, 0.18264976326073606],
            [0.5743426738152702, 0.2974784716623069, 0.22746191754452905, 0.14288420983587768],
            [0.6251212969899044, 0.369816373882201, 0.3008243777923197, 0.2312266929472413, 0.14068006864084268],
            [
                0.6291780509668629,
                0.38155703452949563,
                0.3395417014704629,
                0.279547656100383,
                0.2153895046866852,
                0.11720676133026707,
            ],
        ],
        "gammas": [
            [0.2575225899059974],
            [0.2473446716594199, 0.7999069485687693],
            [0.21866443296960253, 0.5989832483098659, 0.7458106581427854],
            [0.18969795502828787, 0.467922589636488, 0.6496604209311214, 0.6301035948449438],
            [0.17140124128226833, 0.4234555562039168, 0.5818847874106906, 0.5801740883340885, 0.557912964762403],
            [
                0.15704331122337045,
                0.3673385668190634,
                0.5250912493829547,
                0.541212919333038,
                0.5166211056913477,
                0.5502886076316185,
            ],
        ],
    },
    np.float64(3.4714285714285715): {
        "betas": [
            [0.4811750531819176],
            [0.5315821215505275, 0.1803748261463964],
            [0.5603530948982046, 0.20953832319784713, 0.1697521550321235],
            [0.5529929330615516, 0.2345095779937975, 0.18162158549902185, 0.13049955202568006],
            [0.670918653653823, 0.35490363093193733, 0.24718903822065474, 0.19126843069905228, 0.12543574190203646],
            [
                0.6550802401081198,
                0.3735013280544817,
                0.3039699713125068,
                0.24791138078251285,
                0.20084365310215888,
                0.11690343618514513,
            ],
        ],
        "gammas": [
            [0.2430238889845069],
            [0.22218231294876603, 0.6999069485687693],
            [0.21665966355750635, 0.6334080078433705, 0.8458106581427853],
            [0.18792261253769982, 0.47990377286833635, 0.7496604209311214, 0.6878984063602167],
            [0.14475828114708575, 0.3758560079758672, 0.6141406487758081, 0.6428528208375699, 0.5987455073904766],
            [
                0.15180076464514403,
                0.3576054994735199,
                0.5558134721729036,
                0.5793639945896708,
                0.5396149191885803,
                0.5461516743101094,
            ],
        ],
    },
    np.float64(3.892857142857143): {
        "betas": [
            [0.5103694486486713],
            [0.5432548070844289, 0.1569097274404123],
            [0.5475297548785969, 0.15291246412514437, 0.14275896207242222],
            [0.5209792734426788, 0.16790727397209268, 0.10723346593828195, 0.12569875961767768],
            [0.770918653653823, 0.3807937685346011, 0.21089647695250882, 0.1656608524094514, 0.11756652119169374],
            [
                0.7550802401081198,
                0.47350132805448175,
                0.27065053264283734,
                0.19298167240687458,
                0.1490673200377888,
                0.09974062709666023,
            ],
        ],
        "gammas": [
            [0.23189424896301158],
            [0.2008624998601616, 0.5999069485687694],
            [0.21107220469821486, 0.6525915323217476, 0.9458106581427853],
            [0.17763006311647642, 0.448420341777651, 0.8496604209311214, 0.7732167733111962],
            [0.14020754345012543, 0.3303638064600659, 0.5831478458558984, 0.6958739622646966, 0.6571867966255459],
            [
                0.12188563855521337,
                0.2650570805932193,
                0.4794710134325478,
                0.6039449780019801,
                0.6298621300505379,
                0.6306980831189858,
            ],
        ],
    },
    np.float64(4.314285714285714): {
        "betas": [
            [0.5420276146239364],
            [0.5648014382949288, 0.16543771764881032],
            [0.5681649496351947, 0.15149059756477973, 0.06961893158421181],
            [0.6173930883871981, 0.2670157991905089, 0.08286631856454078, 0.07730653713308429],
            [0.8709186536538229, 0.40717412978592576, 0.21677138513614302, 0.14776192703029437, 0.095435940892453],
            [
                0.8237074702408199,
                0.5080691114726421,
                0.25119089767146713,
                0.15567121599875386,
                0.11674075275299604,
                0.10381360963663658,
            ],
        ],
        "gammas": [
            [0.22334323885660168],
            [0.18045534547204317, 0.4999069485687694],
            [0.18759961241939155, 0.5525915323217476, 0.9968450955447848],
            [0.1326274593966491, 0.3495741013084304, 0.7496604209311214, 0.7440871942288086],
            [0.1662704652580387, 0.33227622212689817, 0.5188734145537334, 0.6267311862455025, 0.665966249153271],
            [
                0.15249177545669662,
                0.3650570805932193,
                0.5132923527593424,
                0.581312295486562,
                0.6750204248219486,
                0.651680002928533,
            ],
        ],
    },
    np.float64(4.735714285714286): {
        "betas": [
            [0.575920171130954],
            [0.5876645658113149, 0.20483542123273543],
            [0.6002798406668288, 0.19339600246443026, 0.016854377651608996],
            [0.5707434494362522, 0.230786797420755, 0.055804209607489684, -0.021343466376990583],
            [0.8770258488137519, 0.4064549182835767, 0.21512364760446245, 0.12938187610133092, 0.07090217862860196],
            [
                0.8176399960901436,
                0.4242096383301765,
                0.23388657195009502,
                0.1404473342062971,
                0.09356573155610451,
                0.05475669272676072,
            ],
        ],
        "gammas": [
            [0.21681403711854041],
            [0.1583662809029522, 0.4096438541036328],
            [0.16563763938466577, 0.45259153232174765, 0.8968450955447849],
            [0.14365476330302515, 0.34000925247512054, 0.6496604209311214, 0.8440871942288086],
            [0.174431104867504, 0.32103069089533615, 0.4575321306909307, 0.5533643201152282, 0.6147635314532429],
            [
                0.18257392844097087,
                0.32695886714714867,
                0.43665541990471207,
                0.4955251669542247,
                0.5750204248219486,
                0.6178566791618535,
            ],
        ],
    },
    np.float64(5.157142857142857): {
        "betas": [
            [0.6116416607271298],
            [0.632403145405892, 0.22569622017941415],
            [0.6626159527219185, 0.2923523246674056, 0.07987979778722244],
            [0.62659800848669, 0.3036286112797404, 0.132110425458998, 0.07865653362300942],
            [0.7770258488137519, 0.4923071695957905, 0.22411207537782646, 0.10156708342699375, 0.07189013616432785],
            [
                0.7176399960901436,
                0.36174293664716695,
                0.133886571950095,
                0.08681493628790621,
                0.06270220287441448,
                0.13908237817612598,
            ],
        ],
        "gammas": [
            [0.2118610430387623],
            [0.15511251135456156, 0.42286546130376956],
            [0.1416773302390823, 0.3707918307903278, 0.7968450955447849],
            [0.1404312975250623, 0.3402625180337643, 0.6160644163910117, 0.9440871942288086],
            [0.07443110486750398, 0.24169217561259004, 0.46940745236432346, 0.6235331576265878, 0.7147635314532429],
            [
                0.08644438082998784,
                0.2610583806122798,
                0.5227090894924118,
                0.5955251669542247,
                0.6750204248219486,
                0.7178566791618535,
            ],
        ],
    },
    np.float64(5.578571428571428): {
        "betas": [
            [0.648118781887491],
            [0.6833330657609525, 0.24876502463103653],
            [0.6718351256310674, 0.30924897299601417, 0.15817542687436073],
            [0.6116972316033201, 0.26624521510665455, 0.1158849187117045, 0.17865653362300943],
            [0.6770258488137519, 0.39510657782295616, 0.14634617563720928, 0.08814137404613112, 0.17189013616432786],
            [
                0.7522872529222552,
                0.31310684016407864,
                0.111329514854223,
                0.0604901969363738,
                0.0400942427244102,
                0.239082378176126,
            ],
        ],
        "gammas": [
            [0.20799099892236883],
            [0.15872402963012375, 0.4627205489272034],
            [0.15020338328919894, 0.4179431405421557, 0.8968450955447849],
            [0.13829817454944587, 0.34711354413698, 0.7015678248357302, 1.0440871942288086],
            [0.08242858965280289, 0.24561430237786938, 0.5198947742934446, 0.7235331576265878, 0.8147635314532429],
            [
                0.10689952755567693,
                0.24619281627959808,
                0.46510312451026087,
                0.6468005406963158,
                0.6925600855912134,
                0.8178566791618535,
            ],
        ],
    },
    np.float64(6.0): {
        "betas": [
            [0.6829080837347207],
            [0.7169159501743622, 0.27595994534025176],
            [0.6749486454672814, 0.30733388646188164, 0.19248370526633757],
            [0.6731918893632938, 0.3464954323756122, 0.15773085695879968, 0.1454278211878432],
            [0.7218304459796278, 0.3862774364215068, 0.17958386518939398, 0.11004384367745307, 0.15603678550515557],
            [
                0.6865140485887709,
                0.4131068401640786,
                0.2020514580095825,
                0.11455078243759656,
                0.060361231990908544,
                0.13908237817612598,
            ],
        ],
        "gammas": [
            [0.20447095157498688],
            [0.1612189311846582, 0.49923239978480943],
            [0.13759148191819337, 0.3774366006358027, 0.8974614535118656],
            [0.11191670650039247, 0.28290324485119195, 0.6015678248357302, 0.9440871942288086],
            [0.09810386932855751, 0.2268211394237291, 0.4198947742934446, 0.6235331576265878, 0.9147635314532429],
            [
                0.09340912256646143,
                0.19960893973462165,
                0.36510312451026083,
                0.5468005406963158,
                0.5925600855912134,
                0.7178566791618535,
            ],
        ],
    },
}

RESULTS_D49 = {
    0: {
        "betas": [
            [0.3926990764713548],
            [0.49815702259031075, 0.26969410123982307],
            [0.552311267686988, 0.3704956782858376, 0.211383551985682],
            [0.5732023743455414, 0.4211677040901962, 0.30581035958253516, 0.17348700552456475],
            [0.5919827520689834, 0.4526603561713462, 0.35965204844730564, 0.2675347118687178, 0.14908552263905353],
            [
                0.6022631750374198,
                0.47041078233074324,
                0.39175118909581114,
                0.32175004960509523,
                0.23561143419523797,
                0.1294981477257401,
            ],
        ],
        "gammas": [
            [0.4966396879508445],
            [0.3794397932750067, 0.6633520168098206],
            [0.3278848745362801, 0.5678315499935259, 0.6404527713639474],
            [0.29325374094783585, 0.5136287997957195, 0.5595384483951907, 0.6437193886689425],
            [0.2690163389125687, 0.47954568136752046, 0.5081045742598467, 0.5663402951798617, 0.6414449814466446],
            [
                0.2514017195635333,
                0.45230545788613524,
                0.4755828333077452,
                0.5159295452749431,
                0.5677711819570054,
                0.6417983679927424,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.39262375965647095],
            [0.49681647193174894, 0.26869875918295993],
            [0.5479606314107556, 0.3652875720313855, 0.20889813204573557],
            [0.5630140373067973, 0.40669010535892336, 0.29698763669313966, 0.17032356139626562],
            [0.5740043556916181, 0.42520320719958504, 0.3386143371443602, 0.25767683639140165, 0.14690598841053606],
            [
                0.5812206014449907,
                0.4334273623284927,
                0.3590934529738283,
                0.3027312272224766,
                0.23142362753587675,
                0.1288757355673825,
            ],
        ],
        "gammas": [
            [0.4965981887468978],
            [0.3792080752936735, 0.6625980869265417],
            [0.3270637813588418, 0.5654378802891454, 0.6367710193750901],
            [0.29136937449574446, 0.5060224171435659, 0.54927290480173, 0.6372065895387229],
            [0.26531110876031416, 0.4653721841557501, 0.48655659490273206, 0.549912288481764, 0.6369092138747],
            [
                0.2473686505330281,
                0.4339450829608126,
                0.443465690665347,
                0.4869232780218155,
                0.5536365837821347,
                0.6410076588239895,
            ],
        ],
    },
    np.float64(3.7357142857142858): {
        "betas": [
            [0.3094436912030425],
            [0.39681647193174896, 0.1975646470200859],
            [0.4479606314107556, 0.27928443112806095, 0.2176487889790274],
            [0.46301403730679735, 0.3134206260071018, 0.2987007140268806, 0.1822453010171593],
            [0.47400435569161814, 0.3498887971539859, 0.33468834005108533, 0.2839223703450204, 0.15941831393922298],
            [
                0.4812206014449907,
                0.3782600214511854,
                0.3541118008378702,
                0.337219642365992,
                0.2514619389872506,
                0.13959727497504856,
            ],
        ],
        "gammas": [
            [0.4031630136885044],
            [0.27920807529367353, 0.5625980869265417],
            [0.22706378135884178, 0.46543788028914546, 0.5367710193750901],
            [0.19136937449574445, 0.4060224171435659, 0.44927290480173, 0.655563776279294],
            [0.16531110876031416, 0.3653721841557501, 0.3865565949027321, 0.5497495872498945, 0.6498554852821888],
            [
                0.14736865053302808,
                0.3339450829608126,
                0.36135977411070563,
                0.48548446497975956,
                0.567050870300865,
                0.6442534613175677,
            ],
        ],
    },
    np.float64(7.371428571428571): {
        "betas": [
            [0.2345420625199268],
            [0.30751463153965797, 0.29743766437077024],
            [0.36921715688996, 0.379284431128061, 0.24119947658194513],
            [0.388972755679394, 0.41342062600710183, 0.3366555296074467, 0.19519253189488053],
            [0.42361827382535067, 0.4466482327747395, 0.3868550564484312, 0.28946139333943827, 0.16383291298111874],
            [
                0.4429298012460496,
                0.4653497945266081,
                0.41960265326335583,
                0.3412176611222863,
                0.2528113500508472,
                0.14090094798306527,
            ],
        ],
        "gammas": [
            [0.3031630136885044],
            [0.17920807529367352, 0.47274178968872627],
            [0.14479080424881013, 0.38589031204136914, 0.6316718552095613],
            [0.14054777484721964, 0.32949333778813655, 0.5399292944484962, 0.6416916565943983],
            [0.12165984535244832, 0.31325519495236326, 0.48655659490273206, 0.5597936332813646, 0.6433509997206366],
            [
                0.11462625045469944,
                0.29652433149240015,
                0.4613597741107056,
                0.5119219810588517,
                0.5665433647459985,
                0.6409728658038598,
            ],
        ],
    },
    np.float64(11.007142857142856): {
        "betas": [
            [0.253815242526494],
            [0.3541166779423022, 0.31036495765888017],
            [0.4159849297072741, 0.3980345083126988, 0.24158967801415415],
            [0.4355335161240869, 0.44105078014499827, 0.3354504887616025, 0.19444234725170872],
            [0.46145555704891267, 0.46096382324084584, 0.3829872819204828, 0.28395957550295514, 0.16086729605430747],
            [
                0.4793904912849098,
                0.4744775501852517,
                0.4138514388666656,
                0.33602534586398963,
                0.24866782459231215,
                0.1392781741401728,
            ],
        ],
        "gammas": [
            [0.2031630136885044],
            [0.1352296298718659, 0.5177002047576665],
            [0.11631736008216553, 0.4218655058646094, 0.639233859020747],
            [0.11071091222237954, 0.36797810898643835, 0.5516857026638435, 0.6415744189093561],
            [0.10449856948339117, 0.34104136625620285, 0.4992574727099381, 0.5636432229962591, 0.6461996658186856],
            [
                0.10103244397411018,
                0.3193152449486668,
                0.46540936840048375,
                0.514835169497329,
                0.5674029710692203,
                0.6408364814512634,
            ],
        ],
    },
    np.float64(14.642857142857142): {
        "betas": [
            [0.2969001567459101],
            [0.3944108499286281, 0.3099550610154911],
            [0.4562104513588467, 0.39656114216242905, 0.23785017958975155],
            [0.47217508417092174, 0.43858197089036044, 0.32790500634237574, 0.1910378721015585],
            [0.49750576490268733, 0.4600269248811629, 0.37359875886056026, 0.2774865100151765, 0.15772575510840725],
            [
                0.514991017033182,
                0.473804893469603,
                0.404627219818067,
                0.32860384018370165,
                0.2430789580785121,
                0.13698823252145356,
            ],
        ],
        "gammas": [
            [0.15309264771804376],
            [0.11774518368535113, 0.5481305428249751],
            [0.1045306730371523, 0.44839854315693306, 0.6386297750837981],
            [0.10072963338756602, 0.391442484239943, 0.5533512715355238, 0.6420443815451747],
            [0.09578125471995363, 0.36347701905561614, 0.5019973059179874, 0.5657722177361061, 0.6503839632644],
            [
                0.0931148330945148,
                0.3402440514699689,
                0.467197089121516,
                0.5190925213659472,
                0.5691149083071998,
                0.6413472686060593,
            ],
        ],
    },
    np.float64(18.27857142857143): {
        "betas": [
            [0.3270075063044338],
            [0.4318003371092003, 0.30420866805136376],
            [0.49467217440134126, 0.390355879165498, 0.2329193226223129],
            [0.5068750565512659, 0.43022716979234515, 0.31791258168169867, 0.18585464811895394],
            [0.532039060050676, 0.45406690415291945, 0.36183068055039946, 0.2684758166712969, 0.15334653377671648],
            [
                0.5499384531265874,
                0.46883970064657343,
                0.3933840446722215,
                0.3190554533760096,
                0.23589082666955646,
                0.13365660134333968,
            ],
        ],
        "gammas": [
            [0.13499242671339262],
            [0.10735188910718532, 0.577981157364891],
            [0.09704999770829052, 0.4766290950762168, 0.6371409985753285],
            [0.0943367818625247, 0.41618672344462526, 0.5563318612413243, 0.6425457758091717],
            [0.0900192694087811, 0.3872329616655887, 0.5070122547873874, 0.5685391225996123, 0.6567787303512228],
            [
                0.08773587052251859,
                0.3631372779735633,
                0.4708957019381054,
                0.5262216158658855,
                0.5738319523094093,
                0.6428341663034632,
            ],
        ],
    },
    np.float64(21.914285714285715): {
        "betas": [
            [0.35918410414512114],
            [0.4668590379294735, 0.2944635286993309],
            [0.5321724035599164, 0.3814932383141464, 0.2272529215554231],
            [0.5399470671955671, 0.41746987838992844, 0.30583109450356905, 0.17923754305901596],
            [0.564338872006672, 0.443424314060783, 0.34622807778780407, 0.2558911418835883, 0.14739167665757283],
            [
                0.5845715242345167,
                0.4613502603544036,
                0.3800768372829676,
                0.3071074687500826,
                0.22745452410409422,
                0.12971481516891742,
            ],
        ],
        "gammas": [
            [0.12295466147915682],
            [0.10059468555113889, 0.6113371888365612],
            [0.09194874396844778, 0.5097486756917151, 0.6360195728576058],
            [0.09003049385026833, 0.44490872566813705, 0.5622708386487655, 0.6410925607628221],
            [0.08614772802098146, 0.41447837460299986, 0.5168784455639344, 0.5684051217919626, 0.6669925734254638],
            [
                0.08387663872748839,
                0.38935077268891516,
                0.4784430652927017,
                0.5349045730906705,
                0.5817536240433167,
                0.6450602703313011,
            ],
        ],
    },
    np.float64(25.55): {
        "betas": [
            [0.3928181407006811],
            [0.5002863680302283, 0.2811878105856832],
            [0.569045285575171, 0.37121518087003014, 0.2210684699200342],
            [0.57108687005554, 0.39988625452158616, 0.2920243019422644, 0.1715780356149722],
            [0.5922000945553562, 0.42632963176204286, 0.3262020856206402, 0.24039304780050855, 0.14055495516508631],
            [
                0.6179189704101161,
                0.4500310088531843,
                0.362276260319644,
                0.29071926134468234,
                0.21707201083589941,
                0.12474334898132763,
            ],
        ],
        "gammas": [
            [0.11436784091923216],
            [0.09605927047166084, 0.6519364468408931],
            [0.08841114653848477, 0.5503615181167164, 0.6376199425406053],
            [0.08731600166727785, 0.4803375266344688, 0.5721945932397264, 0.6370092970904864],
            [0.08389691608463386, 0.4472974811287771, 0.5336174863787765, 0.5597868523714814, 0.679995221072902],
            [
                0.08116386586231143,
                0.4202843915753677,
                0.4937764481676049,
                0.5388904612142288,
                0.5959067109862263,
                0.6534450565490817,
            ],
        ],
    },
    np.float64(29.185714285714287): {
        "betas": [
            [0.4279501223666534],
            [0.5326716884026039, 0.2644954991702704],
            [0.6050774110297245, 0.35966599286205314, 0.21371644410285726],
            [0.6001896587191806, 0.3775503125300296, 0.2774549363639781, 0.16401097541746137],
            [0.6165339154662377, 0.401601150498403, 0.30487696406044346, 0.22533972536829291, 0.13224647050368715],
            [
                0.6390987948228198,
                0.4240244271829206,
                0.33011905285033144,
                0.263211103278426,
                0.20008660009393098,
                0.11565055719578424,
            ],
        ],
        "gammas": [
            [0.10800802007038462],
            [0.09308145096455997, 0.7046801847766104],
            [0.08604634871312936, 0.6009570520298132, 0.6467547078510996],
            [0.08597966952364391, 0.5273478369127217, 0.5852781189703121, 0.6310254142370738],
            [0.08310699906622694, 0.48814094598032814, 0.5542441977455866, 0.5509711029653874, 0.6929012050674346],
            [
                0.08045786549090886,
                0.46012991521629204,
                0.5231654940937944,
                0.5166141708332752,
                0.6137494068410893,
                0.6826406118762381,
            ],
        ],
    },
    np.float64(32.82142857142857): {
        "betas": [
            [0.4649794619441002],
            [0.5645712845503453, 0.2442460950747097],
            [0.6389005805366633, 0.3445715737018586, 0.2023538148853676],
            [0.6319205601124482, 0.35340936585136273, 0.26359168122729476, 0.15682871656508368],
            [0.6406331742110476, 0.3722367026728358, 0.2832431463812486, 0.21233405518909584, 0.12233895230141947],
            [
                0.6582297127994033,
                0.3911448819267338,
                0.30120066006542545,
                0.24149351494525037,
                0.1805077972948908,
                0.10546091681339083,
            ],
        ],
        "gammas": [
            [0.10324428713457588],
            [0.091341830247996, 0.7776011370926142],
            [0.08474009420971193, 0.6651929807330004, 0.6738922018335824],
            [0.08532040605371288, 0.5935611305943065, 0.6021737636643951, 0.6325281255370698],
            [0.08315382164396894, 0.5450214180222107, 0.583070396595843, 0.5491572927894114, 0.6978720773641099],
            [
                0.08105464328905902,
                0.5151797385629743,
                0.5546726829194811,
                0.5117220690599297,
                0.623041266748493,
                0.7190704411993663,
            ],
        ],
    },
    np.float64(36.457142857142856): {
        "betas": [
            [0.504656185827625],
            [0.597276991919929, 0.22067131456677205],
            [0.665605159600433, 0.3175104531253681, 0.1784021402347381],
            [0.6631611326069026, 0.32812512031367275, 0.24992682294779908, 0.15029619179823625],
            [0.664435665600942, 0.3370608645344366, 0.2607183094657188, 0.2014411502179354, 0.11312548642419136],
            [
                0.6770971953461113,
                0.35300823290314215,
                0.2710330558091576,
                0.22257605837479905,
                0.16061979560058537,
                0.09437395652084396,
            ],
        ],
        "gammas": [
            [0.09975288201056],
            [0.09061857897516802, 0.8776011370926142],
            [0.08474537016333072, 0.7526804712796443, 0.7468942897463711],
            [0.08577751218737578, 0.6935611305943065, 0.6258805687464257, 0.6383692217671282],
            [0.08419603204505412, 0.6307412791958451, 0.6237300016279983, 0.5539551261378295, 0.6943696382473104],
            [
                0.08243477003849906,
                0.5962413675142929,
                0.6024235067847931,
                0.518216091267407,
                0.6187715454964122,
                0.7518696500689751,
            ],
        ],
    },
    np.float64(40.09285714285714): {
        "betas": [
            [0.5483001354421101],
            [0.6357803957481284, 0.19628517716829785],
            [0.6967645922420029, 0.2804485825336929, 0.14757994848087688],
            [0.7046510044289767, 0.3037325367156066, 0.2335980221661136, 0.14361997349973737],
            [0.6957717029967287, 0.2988539374293671, 0.23974000862001815, 0.19449194987752808, 0.10930072379068795],
            [
                0.7006622351653629,
                0.3084389634046678,
                0.23953115499659716,
                0.20708289734234986,
                0.1493343921001585,
                0.0834593376247092,
            ],
        ],
        "gammas": [
            [0.09741711439799053],
            [0.09020122106114896, 0.9776011370926142],
            [0.08560014466950928, 0.8526804712796443, 0.846894289746371],
            [0.08611449128634462, 0.7935611305943064, 0.6806285592129719, 0.6715615016875496],
            [0.08547882541775492, 0.7307412791958451, 0.6925440642606675, 0.5759853890765165, 0.6928946700820443],
            [
                0.08417537114563255,
                0.6962413675142929,
                0.6853486466050793,
                0.5421116990670519,
                0.6085275392246989,
                0.7696876472640561,
            ],
        ],
    },
    np.float64(43.72857142857143): {
        "betas": [
            [0.5985134308406971],
            [0.6797137610861959, 0.16652166386811534],
            [0.7074055906500789, 0.18044858253369292, 0.08251073882064293],
            [0.7729555408404971, 0.2809157931020884, 0.20528850706904098, 0.12696205529029528],
            [0.754726433932387, 0.26504275835844104, 0.21618896045111227, 0.18069983064766787, 0.10536944489057232],
            [
                0.7489407318304904,
                0.26111060045094536,
                0.20446131948969293,
                0.19200937101259563,
                0.14770903426520882,
                0.08081236587469061,
            ],
        ],
        "gammas": [
            [0.09635455950268464],
            [0.08999856635900023, 1.0776011370926142],
            [0.08739871026303732, 0.9526804712796443, 0.946894289746371],
            [0.08619440354485987, 0.8935611305943064, 0.7806285592129719, 0.7675166310940725],
            [0.08602930913398962, 0.8307412791958451, 0.7925440642606675, 0.6487280954057687, 0.7451740495491003],
            [
                0.08540383285848628,
                0.7962413675142929,
                0.7853486466050793,
                0.6015415269171374,
                0.6277017257789154,
                0.7826319673349974,
            ],
        ],
    },
    np.float64(47.364285714285714): {
        "betas": [
            [0.66204447359209],
            [0.6782190989047983, 0.08128889160457803],
            [0.7053941245568581, 0.08044858253369291, 0.07138344274573993],
            [0.8606811286870291, 0.2698092991208474, 0.16854094085764548, 0.09667096614101706],
            [0.854726433932387, 0.27148107824363715, 0.1975929732637601, 0.14326318518306758, 0.08157458477202126],
            [
                0.8474043939056409,
                0.2554695055078538,
                0.18799748672752456,
                0.15103047323636015,
                0.11056159931663573,
                0.06567240036376391,
            ],
        ],
        "gammas": [
            [0.09724362882525947],
            [0.08938015059535055, 0.9776011370926142],
            [0.09089467820597333, 1.0526804712796443, 1.046894289746371],
            [0.08669782482731601, 0.7935611305943064, 0.8398257429950978, 0.8675166310940725],
            [0.08661040475972057, 0.7307412791958451, 0.735972886829723, 0.7190220320225615, 0.8451740495491002],
            [
                0.08560536065294437,
                0.6962413675142929,
                0.7481009782033388,
                0.6826688740903735,
                0.7277017257789153,
                0.8826319673349974,
            ],
        ],
    },
    np.float64(51.0): {
        "betas": [
            [0.7615957588591049],
            [0.7372956341672576, 0.14056619991546138],
            [0.7493785007695168, 0.1185898528213525, 0.033756634813853936],
            [0.7606811286870291, 0.16980929912084738, 0.06854094085764548, 0.03230716313562204],
            [0.8576482508607987, 0.3193822064774544, 0.256320049296519, 0.21710511203180283, 0.12964752312750152],
            [
                0.8276146708267506,
                0.27324434043157403,
                0.2380307102273956,
                0.23095107827787675,
                0.17315743836848732,
                0.11154715445731705,
            ],
        ],
        "gammas": [
            [0.10288014677729927],
            [0.0862712410003861, 0.8876185622409551],
            [0.08832016027336712, 0.9526804712796443, 1.1468942897463712],
            [0.08121408178053725, 0.6935611305943065, 0.9398257429950978, 0.9675166310940725],
            [0.08483483440048796, 0.6307412791958451, 0.6404617023682281, 0.6190220320225616, 0.9451740495491002],
            [
                0.08570197128280689,
                0.5962413675142929,
                0.6696631782206758,
                0.5826688740903735,
                0.6277017257789154,
                0.9826319673349974,
            ],
        ],
    },
}

RESULTS_D5 = {
    0: {
        "betas": [
            [0.39269907601201026],
            [0.518244346572392, 0.27656001976269934],
            [0.5726638004390178, 0.3989289930596138, 0.21693551636006683],
            [0.5920548668218252, 0.4539118552187577, 0.33548315609842716, 0.1801065846710479],
            [0.6092149649284943, 0.48248419658159414, 0.39348046118534424, 0.2992536583003683, 0.15521320156796736],
            [
                0.6178929759570523,
                0.4995431457157127,
                0.4241448361585321,
                0.35986001702443005,
                0.26739155435306694,
                0.13536670168501888,
            ],
        ],
        "gammas": [
            [0.4701716676836981],
            [0.36246686500379666, 0.6481796835349062],
            [0.31464221742166243, 0.5635394741711119, 0.6449075956524598],
            [0.2804851149295616, 0.5100602412702533, 0.5725742936514321, 0.656647937260982],
            [0.25799932552036725, 0.47458825786742664, 0.5164630489077356, 0.5848922809071391, 0.6641523983254649],
            [
                0.24049793411858408,
                0.44788767396078866,
                0.48302265360308305,
                0.5279779207377213,
                0.595547656408815,
                0.6713391686313118,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.39263303672928845],
            [0.518162264288639, 0.27658201425276674],
            [0.5725472973868467, 0.3988829581153198, 0.2169779277168918],
            [0.5920296802927014, 0.45393745495342075, 0.3354481479174784, 0.18009881872635108],
            [0.609184607130627, 0.48253542850403763, 0.3933956735713304, 0.29913512458564767, 0.15520319193423204],
            [
                0.6178892973509503,
                0.4996135258360523,
                0.4240678894801116,
                0.35968183204374365,
                0.26726452960753183,
                0.1353360695644259,
            ],
        ],
        "gammas": [
            [0.4696807770303061],
            [0.3619514954897356, 0.6481493687125908],
            [0.3141217939563678, 0.5633636190056909, 0.6447563386740092],
            [0.2801110107585368, 0.5100147767517115, 0.5725380333627035, 0.6564298259372293],
            [0.2576501636078563, 0.47456201453269264, 0.5165128069310803, 0.5846047342605041, 0.6639546821852944],
            [
                0.24020370433232482,
                0.44788984966339296,
                0.4831453175647785,
                0.5278042082356966,
                0.5953998194911015,
                0.6711913336048052,
            ],
        ],
    },
    np.float64(0.5928571428571429): {
        "betas": [
            [0.39059870669697694],
            [0.5159184275740241, 0.27731769568243075],
            [0.5695011993036176, 0.39750559560726983, 0.2179199027458701],
            [0.5917684597591923, 0.45481502566858606, 0.3339180098763961, 0.17976381777235054],
            [0.6088922486300999, 0.48363816663274706, 0.39040965653088716, 0.29512090455890333, 0.15470438757424834],
            [
                0.618808295798221,
                0.5016414342198855,
                0.421252511470106,
                0.3546764399459487,
                0.2636261031098718,
                0.1345759787610402,
            ],
        ],
        "gammas": [
            [0.45327146205159224],
            [0.3459101018034969, 0.6478130502174662],
            [0.29868474260080835, 0.558905808359795, 0.6408763059286406],
            [0.26908262705411595, 0.5093820074790865, 0.5716444772623301, 0.6491155239015597],
            [0.24757174180722594, 0.47419592155225143, 0.5181071143150869, 0.5757525689319376, 0.6579021062150614],
            [
                0.23186799444615672,
                0.4485969445999856,
                0.48630964486867406,
                0.5219665442875395,
                0.5905102580692003,
                0.6655138931950203,
            ],
        ],
    },
    np.float64(1.0857142857142859): {
        "betas": [
            [0.3875317688104233],
            [0.5142129293688553, 0.27892559921115634],
            [0.5670896791410439, 0.39444184365595514, 0.21778529378995146],
            [0.5941974505737644, 0.4558878600628563, 0.3291785308941645, 0.178928154695132],
            [0.6112295015191901, 0.4840532913795502, 0.38341003033027043, 0.2867448866236735, 0.1525705637155108],
            [
                0.6229701255582848,
                0.5030619839379821,
                0.4138991553524368,
                0.3454692493271783,
                0.25498693528711336,
                0.13295588083218524,
            ],
        ],
        "gammas": [
            [0.41714563827022133],
            [0.31739835265523425, 0.6516087915939659],
            [0.2740493516636845, 0.5558774987166193, 0.6378656070167114],
            [0.25153637509854176, 0.5116483523510721, 0.5712343285050487, 0.6330051161641532],
            [0.23303641101792552, 0.47727875622499455, 0.522060142908384, 0.5610174369819181, 0.6472141188628624],
            [
                0.2194581100955552,
                0.45212064163756627,
                0.49162875811996204,
                0.5113284619358187,
                0.5797117287009085,
                0.6527113185135369,
            ],
        ],
    },
    np.float64(1.5785714285714287): {
        "betas": [
            [0.38763178536460136],
            [0.5170785604163534, 0.2794494455282478],
            [0.568960397023064, 0.3874840527657227, 0.21422234011255487],
            [0.6008030005362893, 0.4545703870580427, 0.32136216900923786, 0.17817301520009035],
            [0.6178499115046239, 0.4816317652343675, 0.373850848019851, 0.27659071136930136, 0.14829685552772387],
            [
                0.6298448940674469,
                0.49940582397778616,
                0.4019820690374608,
                0.3342292667458911,
                0.24145022137751726,
                0.13031854491086436,
            ],
        ],
        "gammas": [
            [0.37187764835065595],
            [0.2907935084735461, 0.665069314649736],
            [0.25301516005188474, 0.5601889581461525, 0.6392528121010196],
            [0.23619129215914006, 0.5186531746369828, 0.5725923265876443, 0.6125440008282326],
            [0.22166258075133718, 0.48621309414009983, 0.5286138082487201, 0.5477146832721319, 0.6344279959696504],
            [
                0.20926064747862969,
                0.45923016716354076,
                0.49812132702401796,
                0.5008051318071858,
                0.5656912958575598,
                0.6379426927038202,
            ],
        ],
    },
    np.float64(2.0714285714285716): {
        "betas": [
            [0.3943864036866586],
            [0.5242703639045568, 0.27663132400525564],
            [0.5737693505292433, 0.37402542162625557, 0.2072010366599688],
            [0.6098858139901107, 0.4483433987723915, 0.31124819899806927, 0.1775385118824629],
            [0.6269655960781333, 0.47474362431150974, 0.362113080702174, 0.26702461864181104, 0.14305347122977158],
            [
                0.6377077632684317,
                0.48927290499560055,
                0.3874546814260648,
                0.32200544086797867,
                0.22537429268119438,
                0.12600156960293954,
            ],
        ],
        "gammas": [
            [0.32968301101048686],
            [0.2713474708553374, 0.6895679765636686],
            [0.23797033533644105, 0.5710628571448206, 0.6451708977257324],
            [0.22482741214111804, 0.5294999433727293, 0.5775580754682786, 0.5938488241909232],
            [0.21322348921698617, 0.4985324899800393, 0.536688025199523, 0.5369886282089822, 0.6170438542157924],
            [
                0.2020530678515893,
                0.4693102001194439,
                0.5072680139787445,
                0.49432324464263316,
                0.5519827992955051,
                0.6281565934264496,
            ],
        ],
    },
    np.float64(2.5642857142857145): {
        "betas": [
            [0.40816835272904034],
            [0.5334880005540092, 0.2692274201666072],
            [0.5788566349580786, 0.35253122300774736, 0.19802096629607766],
            [0.6184745449534675, 0.4336668126032238, 0.2975688264929768, 0.17518761256115928],
            [0.6362320922227187, 0.4616527879021069, 0.3478614942937326, 0.25981476985486296, 0.13939465429732542],
            [
                0.6459349651074193,
                0.47280798021089393,
                0.3721722125648224,
                0.3099376472761471,
                0.21131222909928965,
                0.11966413946249708,
            ],
        ],
        "gammas": [
            [0.29602195897389966],
            [0.25800195273641013, 0.7249595377667543],
            [0.2271620447205718, 0.5857489006734667, 0.6572080776316614],
            [0.21619705922904595, 0.5424660914873192, 0.5891372090075813, 0.582773982814125],
            [0.20562029336869264, 0.5092801239982327, 0.5459129082348534, 0.5286610363541314, 0.5914806430116072],
            [
                0.19583283525549802,
                0.47869958747136454,
                0.519596113215819,
                0.4930166215042822,
                0.5386082730464592,
                0.6228594419663117,
            ],
        ],
    },
    np.float64(3.0571428571428574): {
        "betas": [
            [0.4276377486420875],
            [0.5425802841610907, 0.2562188571267284],
            [0.5820904820647772, 0.32211456471218003, 0.18881430506874852],
            [0.6205130566385878, 0.40076368548367347, 0.2747811283846854, 0.16605592047913187],
            [0.6437571841294524, 0.43942246247118777, 0.33142299609250825, 0.25484650472904374, 0.14047929889459607],
            [
                0.6512964291728032,
                0.44405519276563754,
                0.35557306928016846,
                0.2983508408374752,
                0.2054615233248239,
                0.11244680522233441,
            ],
        ],
        "gammas": [
            [0.2706122082804723],
            [0.24855728826224793, 0.7714556722057234],
            [0.21853457059707207, 0.6002659110277957, 0.6803728729804261],
            [0.20682378803837986, 0.5476950173378038, 0.6108095240366493, 0.5863417336561378],
            [0.19688238839960784, 0.5114279639631789, 0.5594966486178332, 0.5275868430797203, 0.5626035358423134],
            [
                0.1841273033329909,
                0.46660524104384127,
                0.530618127479893,
                0.49879758264242907,
                0.5205681152194983,
                0.6076814218083957,
            ],
        ],
    },
    np.float64(3.5500000000000003): {
        "betas": [
            [0.45143138631124385],
            [0.5497401116120283, 0.23583725404057598],
            [0.5822884513307184, 0.2831555385298308, 0.18161528773866642],
            [0.59847698661708, 0.3264726154421152, 0.24186537541099645, 0.14745967652687206],
            [0.6467820085176323, 0.4006672731380799, 0.31340321543477306, 0.2464226630311686, 0.14497671014287034],
            [
                0.6339140570623807,
                0.38729957390874487,
                0.3464392854526853,
                0.28606417600697903,
                0.21559710212469982,
                0.11692455495507703,
            ],
        ],
        "gammas": [
            [0.2515657140635522],
            [0.24088352881376443, 0.8273782985114136],
            [0.21051557145103647, 0.6089078793034417, 0.7271187355794823],
            [0.18575966626973153, 0.4882185230142608, 0.6391684815815137, 0.6226498629778102],
            [0.1816808512230432, 0.48249044036321664, 0.5838697599039199, 0.5501945431224357, 0.5492233873609695],
            [
                0.1526737198632571,
                0.3695585381178343,
                0.5245724122409282,
                0.5328313189269952,
                0.5117490621502616,
                0.5640673561967353,
            ],
        ],
    },
    np.float64(4.042857142857143): {
        "betas": [
            [0.478632875784162],
            [0.5527646707092708, 0.20409395951896597],
            [0.5800437643794372, 0.2394777700086994, 0.1742051878699459],
            [0.5832761744243525, 0.2720530395558207, 0.2100720075264991, 0.13498384843213376],
            [0.6363737236616113, 0.3443988664065451, 0.27454417905067263, 0.20808067140726255, 0.13099972158116266],
            [
                0.659632926833016,
                0.3770409822889319,
                0.3187541742345026,
                0.2611998647549812,
                0.207200852048467,
                0.11840313270330283,
            ],
        ],
        "gammas": [
            [0.23717755421536632],
            [0.23117988692175007, 0.8652209577909915],
            [0.20353816221341564, 0.6139561650912312, 0.8242102016970974],
            [0.17730116885011502, 0.46775178941111517, 0.7104376177308683, 0.6774048572823311],
            [0.15438183336495384, 0.3999770736064279, 0.6222370876336714, 0.6229063974969443, 0.5827084614702743],
            [
                0.1462880591500917,
                0.3665354446116037,
                0.5583444767016663,
                0.5649903230109372,
                0.5254605456675379,
                0.5492585338522794,
            ],
        ],
    },
    np.float64(4.535714285714286): {
        "betas": [
            [0.508738359905496],
            [0.5531352182472955, 0.1595319590557087],
            [0.576023973461928, 0.18742600866126197, 0.15645857828521517],
            [0.5649496179728372, 0.20775488693704125, 0.15583596780434653, 0.12613264745410147],
            [0.7363737236616112, 0.3899169664621952, 0.23369717331796733, 0.17908992217543485, 0.12096046716828483],
            [
                0.759632926833016,
                0.46421790566325916,
                0.29433168386995906,
                0.22094021809022601,
                0.17096801786239602,
                0.10757283062521412,
            ],
        ],
        "gammas": [
            [0.2262331787442753],
            [0.2107953158667322, 0.7652209577909915],
            [0.20209480849489178, 0.6493690613595894, 0.9242102016970973],
            [0.17898237777663936, 0.49120176602983495, 0.8104376177308683, 0.7774048572823311],
            [0.12326105674152744, 0.3314899267651193, 0.6141214817577693, 0.6979320414966381, 0.6573604764893228],
            [
                0.11122735178818556,
                0.2665354446116037,
                0.4902818733003116,
                0.6000785908361187,
                0.6051183426641945,
                0.6095359855218258,
            ],
        ],
    },
    np.float64(5.0285714285714285): {
        "betas": [
            [0.5415227588545874],
            [0.5701671823543419, 0.1379266244264784],
            [0.5756114520040168, 0.1653244830683921, 0.11036393734118298],
            [0.5542779869509319, 0.18455810032625505, 0.0834300676997149, 0.10506912235663945],
            [0.8363737236616112, 0.39506080364913926, 0.2084676959430538, 0.1519241040782405, 0.10590461827429362],
            [
                0.859632926833016,
                0.4515430171811043,
                0.2372191914571711,
                0.16038731184827534,
                0.12212121225664462,
                0.08211888535147281,
            ],
        ],
        "gammas": [
            [0.21791993342828492],
            [0.1943893585026298, 0.6652209577909916],
            [0.1818380720817078, 0.5493690613595894, 1.0242102016970973],
            [0.15762076403136907, 0.4125359507830449, 0.9104376177308683, 0.8774048572823311],
            [0.1422619813745871, 0.34030007401577184, 0.5848317784020349, 0.704828246814904, 0.7120454694449266],
            [
                0.13026720162459804,
                0.2915941311010174,
                0.5003092067791253,
                0.6180850293033948,
                0.6727240242077832,
                0.687702176647547,
            ],
        ],
    },
    np.float64(5.521428571428571): {
        "betas": [
            [0.5768885687253928],
            [0.5993222409785168, 0.15333601396130728],
            [0.596994964925996, 0.19282904624927535, 0.041255513894486215],
            [0.5921368263853183, 0.2449555425674781, 0.06188615910704695, 0.01683900499644361],
            [0.886847952790425, 0.38633380820874946, 0.20357553220264102, 0.1322098962328726, 0.08130646467860439],
            [
                0.8384109424189122,
                0.39481509885587945,
                0.21911990976934617,
                0.14168812867760025,
                0.09936143715431957,
                0.0610409185526074,
            ],
        ],
        "gammas": [
            [0.2116924628569528],
            [0.17784140556681222, 0.5652209577909916],
            [0.159560062422389, 0.44936906135958943, 0.9242102016970973],
            [0.1368646118438226, 0.35189973366596694, 0.8104376177308683, 0.7870282126721204],
            [0.1676057827841663, 0.36018613710118397, 0.5300602983678728, 0.6283980387921556, 0.6824336121015762],
            [
                0.17586693042525287,
                0.35063666881471145,
                0.49525263793921953,
                0.5712137475284362,
                0.635995132162807,
                0.6767507935786741,
            ],
        ],
    },
    np.float64(6.014285714285714): {
        "betas": [
            [0.6145879410748097],
            [0.6314085211003467, 0.20344915031588126],
            [0.6349614602741959, 0.26542466388976027, 0.058116610934743816],
            [0.6312409502900223, 0.2788164718623711, 0.07333789891363514, 0.0025944693360686446],
            [0.7868479527904251, 0.4010792590483891, 0.1685984147688299, 0.0827464326224242, 0.030214105637030208],
            [
                0.7384109424189123,
                0.37520457131907814,
                0.1543048610859814,
                0.07289451608104752,
                0.030521778242013468,
                -0.007943256577757834,
            ],
        ],
        "gammas": [
            [0.20713145830692165],
            [0.1577173398171884, 0.4652209577909916],
            [0.1363453229503327, 0.36728626656784674, 0.8242102016970974],
            [0.1295712756954563, 0.3375403961766846, 0.7104376177308683, 0.7859197956478379],
            [0.10968184613301611, 0.260186137101184, 0.43006029836787285, 0.5283980387921556, 0.5824336121015762],
            [
                0.10602863173288286,
                0.25063666881471147,
                0.4131116410832462,
                0.5250574634459227,
                0.5897073910290417,
                0.6710055305371372,
            ],
        ],
    },
    np.float64(6.507142857142857): {
        "betas": [
            [0.6535538975362495],
            [0.6757951307724154, 0.23679837949107863],
            [0.680043897612259, 0.3063632955161677, 0.13403715630154953],
            [0.6451382171373498, 0.28053648551633803, 0.12143738701982285, 0.10259446933606865],
            [0.6868479527904251, 0.30107925904838906, 0.12043044748818504, 0.07739686696704612, 0.10328862115619337],
            [
                0.6384109424189123,
                0.2756894678649423,
                0.10330699016657297,
                0.05725522201427248,
                0.08655491041628438,
                0.09205674342224217,
            ],
        ],
        "gammas": [
            [0.20373875976977768],
            [0.15405575489862613, 0.4711726212779864],
            [0.14632691651444205, 0.4201784823246429, 0.9242102016970973],
            [0.1397105023613423, 0.3836099748754472, 0.7948609864570327, 0.8859197956478378],
            [0.12217599648572262, 0.3371386882454232, 0.5300602983678728, 0.6283980387921556, 0.6824336121015762],
            [
                0.12167507208509337,
                0.3039840745939599,
                0.5131116410832463,
                0.6250574634459227,
                0.6897073910290417,
                0.7710055305371372,
            ],
        ],
    },
    np.float64(7.0): {
        "betas": [
            [0.6906867553441514],
            [0.7161261602119613, 0.26330456837662963],
            [0.6801193738492066, 0.30231497488833114, 0.18003920984968222],
            [0.6689451238912589, 0.3215057866381447, 0.1392760486780677, 0.12736918181520593],
            [0.6471448575915205, 0.34486611158711317, 0.1568224102469648, 0.08542278912322578, 0.12072893339602378],
            [
                0.7244650730482436,
                0.3756894678649423,
                0.17049820104971675,
                0.0997058353644032,
                0.043392536098622016,
                0.14183836694037275,
            ],
        ],
        "gammas": [
            [0.2006280768279463],
            [0.15746661147952684, 0.5182365050531812],
            [0.13587608346308055, 0.3931500652944915, 0.9752043467506528],
            [0.1191759829477913, 0.3142094720138524, 0.6948609864570328, 0.9521695259407456],
            [0.09942746580089713, 0.23747869728800564, 0.45471752024263373, 0.6558839281655322, 0.7070318029228189],
            [
                0.09846801094653576,
                0.22812714870324155,
                0.4131116410832463,
                0.5785874367922312,
                0.5913540052863394,
                0.678360672774506,
            ],
        ],
    },
}

RESULTS_D6 = {
    0: {
        "betas": [
            [0.39269907669003434],
            [0.5144023254787367, 0.27513132032475773],
            [0.5688913831456577, 0.39332729048124504, 0.21572754161455512],
            [0.5886259647039995, 0.44772410933075185, 0.32952119893146625, 0.17863811731645063],
            [0.6061284861641095, 0.4770944446228059, 0.38716533092631883, 0.2929468857303587, 0.1537884512623852],
            [
                0.6150393581280282,
                0.4941523806536362,
                0.4182358049929239,
                0.3528327212883684,
                0.26091628096375036,
                0.13389795030444426,
            ],
        ],
        "gammas": [
            [0.4747070391854442],
            [0.36520253161032923, 0.6505303976500896],
            [0.31678819044173795, 0.5638078018940827, 0.643367165059239],
            [0.28261631586255487, 0.5104134516805089, 0.5697233730683899, 0.6536536798052609],
            [0.2598090137622141, 0.4752793897171357, 0.5148551431998747, 0.5813219719997498, 0.6594236907577147],
            [
                0.2423230533356894,
                0.4483759705252871,
                0.48142845166237297,
                0.5260640501548943,
                0.5906664884601338,
                0.6656062994661209,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.3926260868439862],
            [0.5142859082388856, 0.2751324754469648],
            [0.5687442061428085, 0.39328973637824743, 0.21578382747810965],
            [0.5885433757372655, 0.44775922782226724, 0.329552623193202, 0.17865085020591454],
            [0.6060647736855962, 0.4771439869939071, 0.38714069498101755, 0.29287748179502443, 0.15378942765506443],
            [
                0.6150030408495246,
                0.49423215406399984,
                0.4182050921297395,
                0.35271524094306783,
                0.2608549244300178,
                0.13389229480511766,
            ],
        ],
        "gammas": [
            [0.4742929400480584],
            [0.3647237867651228, 0.6504465176672096],
            [0.3162749304406773, 0.5635952175674716, 0.643230518279531],
            [0.28220371388401283, 0.510272230679166, 0.5696489154869928, 0.6535086119412918],
            [0.2594366107657408, 0.4751906088205004, 0.5148898536874326, 0.5811237468174991, 0.6593027354238753],
            [
                0.24200363835810484,
                0.44832387751064795,
                0.48151844094828933,
                0.5259019331221169,
                0.5905833572554784,
                0.6655594150210727,
            ],
        ],
    },
    np.float64(0.6642857142857143): {
        "betas": [
            [0.3897301652948071],
            [0.5103113587966823, 0.27557603793792895],
            [0.5640073566145188, 0.39225556013366336, 0.21747675171586656],
            [0.5867770403538161, 0.449074356170858, 0.32955144350442694, 0.17902396397510145],
            [0.6045999945952236, 0.4788957204135925, 0.3854934148285593, 0.2899118040157254, 0.15375071337000967],
            [
                0.6150813493962878,
                0.4974604518084853,
                0.41643672255590847,
                0.3484595682304734,
                0.2586242356214867,
                0.1336973345724469,
            ],
        ],
        "gammas": [
            [0.4567658323507099],
            [0.34588293424674993, 0.6478797681156784],
            [0.2973712380283273, 0.5568722134785149, 0.6392413503947642],
            [0.2677197917850707, 0.5070291330421018, 0.5683742467073025, 0.6468995275560306],
            [0.2463277034270252, 0.47286284772966797, 0.516417984548723, 0.57309635749536, 0.6546888067823985],
            [
                0.23087015304128322,
                0.4476044632140489,
                0.4850172567909392,
                0.5195115168971257,
                0.586508283688885,
                0.6612588897729885,
            ],
        ],
    },
    np.float64(1.2285714285714286): {
        "betas": [
            [0.38484136509617906],
            [0.5068855856932241, 0.27779796185847505],
            [0.5605294033112524, 0.3912386420946348, 0.21827115931614038],
            [0.5886944162483408, 0.4522307454699675, 0.3269902782379522, 0.17907002873182626],
            [0.6065774395509316, 0.48111649827333125, 0.37972765282811083, 0.28306322877991635, 0.15241047706364064],
            [
                0.6195411599230269,
                0.5014909431342333,
                0.4105097955619422,
                0.340210925294173,
                0.25214607178192217,
                0.13272711437123969,
            ],
        ],
        "gammas": [
            [0.4172404791946082],
            [0.31229542376331276, 0.6485564286718783],
            [0.26814948478806605, 0.5523385822016996, 0.6378384625134474],
            [0.24616343694502213, 0.5075988878485161, 0.5687738419862635, 0.6321707308382405],
            [0.22825255229631916, 0.47448689574017094, 0.5203613760949406, 0.5583513200854355, 0.6458491349014472],
            [
                0.21569136272641662,
                0.4508685612346082,
                0.49120582821785486,
                0.5082784119579398,
                0.577921732675457,
                0.6516108769022501,
            ],
        ],
    },
    np.float64(1.792857142857143): {
        "betas": [
            [0.383344871920885],
            [0.5103639653737576, 0.2798179645245602],
            [0.5636731082071723, 0.3874366525009659, 0.21514914803840374],
            [0.5968131096341356, 0.45359321374919576, 0.32090470293961065, 0.1787875664442585],
            [0.6144665559581388, 0.48104957509347473, 0.37096603192879746, 0.2742249235701832, 0.14892456828001682],
            [
                0.6284622381980279,
                0.5014133339776163,
                0.4002777358810643,
                0.3299064186098226,
                0.2408085459569932,
                0.13060546808439746,
            ],
        ],
        "gammas": [
            [0.36810643437931045],
            [0.2821860602815201, 0.6605625664097688],
            [0.24490791146678859, 0.557916217098499, 0.6417182832110108],
            [0.22912813318018896, 0.5156609048688262, 0.5714372568326261, 0.6133805804492433],
            [0.2151723104107511, 0.483844892866023, 0.5269134964639598, 0.5444388303767875, 0.6349479938799322],
            [
                0.20445877930153758,
                0.45973586386667353,
                0.49862427864560543,
                0.4973616739796426,
                0.5663175746812733,
                0.639478933183619,
            ],
        ],
    },
    np.float64(2.357142857142857): {
        "betas": [
            [0.3895220802947378],
            [0.519954782986262, 0.278673463542145],
            [0.5712760112201304, 0.3777532889223852, 0.20818415600751233],
            [0.6086555409363941, 0.45063421042795293, 0.31247258467970673, 0.17849946901103458],
            [0.6256364117617474, 0.4767866817422448, 0.3600896019775963, 0.26523919884145725, 0.14399039413574005],
            [
                0.6388196295358399,
                0.49489102041495747,
                0.38669938660753367,
                0.31832208457909944,
                0.22598135859845841,
                0.12695888447925724,
            ],
        ],
        "gammas": [
            [0.323550404889716],
            [0.2611527548259482, 0.684897649853302],
            [0.22939146806011795, 0.5719167449398993, 0.6496749808030019],
            [0.21762512806715217, 0.5296874588323266, 0.5770662403823702, 0.595519907633431],
            [0.206508426129943, 0.49860657418824383, 0.5354222273453424, 0.5334738476494668, 0.6206011284589805],
            [
                0.19704212273999758,
                0.47268189915869857,
                0.5077911430264683,
                0.4894678065202201,
                0.5534260071035425,
                0.6297394121842484,
            ],
        ],
    },
    np.float64(2.9214285714285713): {
        "betas": [
            [0.4034915570616672],
            [0.5325163781358251, 0.2731485760828988],
            [0.5799478103468886, 0.3606895222687188, 0.1984362300922882],
            [0.6214948616730958, 0.44162116768976073, 0.30172173386514484, 0.17745853358101316],
            [0.6375720761845178, 0.4670884866035498, 0.3469298592999681, 0.2576785325608108, 0.139466705611412],
            [
                0.6494683561932676,
                0.48209776394631276,
                0.3712861615876528,
                0.30635096775408477,
                0.211188439832389,
                0.12132106414311333,
            ],
        ],
        "gammas": [
            [0.28901151633060723],
            [0.24731289649259772, 0.72086999750891],
            [0.2190403335265545, 0.5914496014887367, 0.662380568550363],
            [0.20992105946346865, 0.5485737191743005, 0.5879335161534383, 0.5830795562839782],
            [0.20009971827883835, 0.5154459156864876, 0.5457021009253759, 0.5250160119351653, 0.5998552925608533],
            [
                0.1919014623660445,
                0.4881706052410587,
                0.5200429709385315,
                0.48605713942693396,
                0.540671231063505,
                0.6247642988474047,
            ],
        ],
    },
    np.float64(3.4857142857142858): {
        "betas": [
            [0.4234806294360449],
            [0.5456212178475799, 0.26263019047898833],
            [0.5872823031035875, 0.3351655155421275, 0.18758805386137628],
            [0.6324271576051116, 0.42278599508778325, 0.2858542269652789, 0.17301274877948566],
            [0.6488987689682808, 0.4506719449867986, 0.3316602757245822, 0.25242830073952155, 0.1381185829867337],
            [
                0.6601047687460906,
                0.46262900672056323,
                0.35413308227263957,
                0.2943808053968009,
                0.20057438750871223,
                0.11372112083845869,
            ],
        ],
        "gammas": [
            [0.26346800067219545],
            [0.23810865944792858, 0.7692635942532913],
            [0.2114947136846551, 0.613231918928938, 0.6829055351719466],
            [0.2040366667340693, 0.5702997377581912, 0.6079931545601771, 0.580604466200515],
            [0.19442180543996965, 0.5307497461650754, 0.559815790940551, 0.5207727357707167, 0.5735430107652445],
            [
                0.1865423889514954,
                0.5004035750963364,
                0.5358410100593234,
                0.4876107244167838,
                0.5260505136630601,
                0.6181367901709977,
            ],
        ],
    },
    np.float64(4.05): {
        "betas": [
            [0.44791098116975264],
            [0.5575048082947427, 0.24600980973111447],
            [0.5915073480667921, 0.2999945938056557, 0.17832221314192273],
            [0.6324814808986327, 0.37774601206617214, 0.2551749667638793, 0.15714239222189477],
            [0.6594855094906857, 0.42546052524943423, 0.3152143556423941, 0.2481188419294603, 0.14139366682143192],
            [
                0.665231227844071,
                0.42283609412543105,
                0.33575316090730234,
                0.2838243573975259,
                0.20334233256760853,
                0.10952709415183468,
            ],
        ],
        "gammas": [
            [0.24456953167118564],
            [0.23157676588305082, 0.8317424754891982],
            [0.20461820475865863, 0.6298618857785349, 0.7193985124391653],
            [0.1948634608520977, 0.5737206418377766, 0.6437718529454827, 0.5997981697742403],
            [0.18773642812531005, 0.5379413813134634, 0.5837774811852464, 0.5284985813033801, 0.5522465184756509],
            [
                0.16947917049835687,
                0.46109840858956164,
                0.5472848304472188,
                0.5033052798145421,
                0.5062828983587301,
                0.5879607995562427,
            ],
        ],
    },
    np.float64(4.614285714285714): {
        "betas": [
            [0.4758094216341685],
            [0.5663014348391404, 0.22062561533210917],
            [0.5916614707398192, 0.2563074002568698, 0.17269974311489453],
            [0.6013542360839881, 0.2898229508755795, 0.22227929367910704, 0.13695297428880007],
            [0.6660873882188877, 0.376707755655093, 0.2963048936921738, 0.23300491470261084, 0.14329494043387023],
            [
                0.6594970311945013,
                0.3794469519193994,
                0.3275503751677521,
                0.2694363631311434,
                0.2104272473289179,
                0.1186267572818394,
            ],
        ],
        "gammas": [
            [0.23041764847510735],
            [0.22574193461363484, 0.9051863398421689],
            [0.19654191985202632, 0.6279036008756621, 0.7940828440972334],
            [0.17090956070630747, 0.4737206418377766, 0.6898541541834061, 0.6680234805100801],
            [0.16422561496765983, 0.46322073816767345, 0.6223736861393482, 0.5815969172401199, 0.5608576624130186],
            [
                0.14092516040966013,
                0.36289811857080395,
                0.5558355808532969,
                0.5557286652897178,
                0.5184166441391801,
                0.5574544793558328,
            ],
        ],
    },
    np.float64(5.178571428571428): {
        "betas": [
            [0.5066985456270366],
            [0.565178907382343, 0.17689721392530622],
            [0.5914434244525026, 0.20845891714169995, 0.16157192618889324],
            [0.5903068063364656, 0.2408120527721908, 0.1842681781025614, 0.12627067738250541],
            [0.7660873882188877, 0.41797535886549947, 0.2686591500057153, 0.20149952090442075, 0.1289074101778433],
            [
                0.7594970311945013,
                0.451968203110926,
                0.30538587338321377,
                0.23802077521755954,
                0.18482473546277955,
                0.1128589523574634,
            ],
        ],
        "gammas": [
            [0.21973379548000097],
            [0.20925379415886577, 0.8426076859799954],
            [0.1923762258569336, 0.6407067692257727, 0.8940828440972334],
            [0.16835595433720496, 0.47546020643956094, 0.7898541541834061, 0.7513269193009386],
            [0.1287981512667974, 0.3632207381676734, 0.6185880713240506, 0.6484743333671271, 0.6271010033713985],
            [
                0.11241739469092865,
                0.2918165082023464,
                0.5219862216352111,
                0.5925185412767386,
                0.5800999179256844,
                0.594981482481829,
            ],
        ],
    },
    np.float64(5.742857142857142): {
        "betas": [
            [0.540434189363429],
            [0.5736469975980654, 0.13723663623154142],
            [0.5898528990220246, 0.17009952459966066, 0.13182556686870817],
            [0.5731667809637929, 0.17338063381089347, 0.11296443498467051, 0.11675233058010118],
            [0.8660873882188876, 0.4328838399553337, 0.22789342573761698, 0.1621474923463875, 0.10982062833435682],
            [
                0.8594970311945013,
                0.45683170906434556,
                0.25089442561050324,
                0.17808507608057844,
                0.13721032352195484,
                0.09035504276053241,
            ],
        ],
        "gammas": [
            [0.21169735777908216],
            [0.19354108925497437, 0.7426076859799954],
            [0.18219031946103112, 0.601864054081539, 0.9940828440972334],
            [0.1713087214030862, 0.5083474585904258, 0.8898541541834061, 0.8513269193009386],
            [0.12107963771863027, 0.3250543697422245, 0.5825345397426708, 0.6970969988965708, 0.7164961137975441],
            [
                0.11451497824718697,
                0.28453020839644744,
                0.5036255334024965,
                0.621105494925424,
                0.6612774290347007,
                0.6712936160562847,
            ],
        ],
    },
    np.float64(6.307142857142857): {
        "betas": [
            [0.577060081111125],
            [0.5996671089254545, 0.13615791214547646],
            [0.6001141638941186, 0.17480613808162526, 0.06026788009532855],
            [0.6731667809637929, 0.2733806338108935, 0.1697932506507861, 0.14173841248499985],
            [0.8869719064938951, 0.3820121397285656, 0.19882869019053812, 0.13462908674422425, 0.08848426926521988],
            [
                0.8677847112234341,
                0.3836397675649423,
                0.20699694429922208,
                0.14220435254413208,
                0.10586638547173739,
                0.06785027027689111,
            ],
        ],
        "gammas": [
            [0.20578468049439458],
            [0.1797835306768345, 0.6426076859799954],
            [0.16273625998894717, 0.501864054081539, 1.0940828440972334],
            [0.1882449455370045, 0.4540887929479575, 0.8503847920028281, 0.9513269193009386],
            [0.15169036334782862, 0.37208469040400954, 0.5808181553441651, 0.6866287231601741, 0.7360228082997139],
            [
                0.15454540643207443,
                0.3481922240277815,
                0.5221312390467584,
                0.6151840171808179,
                0.6712615397974225,
                0.698174266774043,
            ],
        ],
    },
    np.float64(6.871428571428571): {
        "betas": [
            [0.6165292982835717],
            [0.6348044546610744, 0.17403018679784554],
            [0.6264985777458474, 0.2344295031639707, 0.03672155912769809],
            [0.7731667809637929, 0.3330496047990805, 0.16123325114388584, 0.05614353100169742],
            [0.8377815517648111, 0.3756600336372049, 0.19241262458377834, 0.10995134397901553, 0.05509023989308467],
            [
                0.805933349067837,
                0.3846233707063433,
                0.21129140932639326,
                0.13021367961060448,
                0.07958958526973985,
                0.04100689088233631,
            ],
        ],
        "gammas": [
            [0.20161755129356135],
            [0.16350916369897564, 0.5426076859799954],
            [0.14043462344923624, 0.401864054081539, 0.9940828440972335],
            [0.16316152650876756, 0.41283449745897177, 0.7503847920028281, 0.8513269193009386],
            [0.14555288727436735, 0.3179852176192639, 0.48081815534416517, 0.5867382184704882, 0.685285957780219],
            [
                0.15236104171032602,
                0.3061393313838044,
                0.43999683973660964,
                0.515184017180818,
                0.6083785563313661,
                0.6789798013606532,
            ],
        ],
    },
    np.float64(7.435714285714285): {
        "betas": [
            [0.6578799642611092],
            [0.670783820837396, 0.22753632170874308],
            [0.6856894411550789, 0.29590273279420365, 0.11539874273546413],
            [0.6731667809637929, 0.28604778850767515, 0.12284875165835774, 0.10325035680709346],
            [0.7377815517648111, 0.4355642025030027, 0.18768348094037476, 0.08549841027278184, 0.10074326726149527],
            [
                0.705933349067837,
                0.3610010878972373,
                0.122224810072196,
                0.07277001342197582,
                0.056532906541853334,
                0.1410068908823363,
            ],
        ],
        "gammas": [
            [0.19872037697393793],
            [0.14960472466366537, 0.47775261210005854],
            [0.14307986866695302, 0.42817309912418966, 0.9820702034293584],
            [0.135021146085432, 0.40183527839988725, 0.7955807502266375, 0.9513269193009386],
            [0.07984716234819306, 0.25576310193221363, 0.5808181553441651, 0.6867382184704882, 0.7852859577802189],
            [
                0.08863878295557767,
                0.2659570888774188,
                0.5399968397366096,
                0.6151840171808179,
                0.708378556331366,
                0.7789798013606531,
            ],
        ],
    },
    np.float64(8.0): {
        "betas": [
            [0.6973399933911107],
            [0.7157626194274759, 0.25305725540338014],
            [0.6843850868861585, 0.29744026650852284, 0.16955441565925697],
            [0.6650147375186527, 0.31619549560814886, 0.13672180348264074, 0.1313193990114933],
            [0.6666381788832177, 0.3616984527027581, 0.1609861183163818, 0.09379039802578408, 0.11612234444100031],
            [
                0.7257723365982313,
                0.3721868136497699,
                0.16515328097782636,
                0.0918129025415768,
                0.04820247907315057,
                0.13723195510856026,
            ],
        ],
        "gammas": [
            [0.19605709677711694],
            [0.15352247996546334, 0.5343584689382238],
            [0.13352206741039346, 0.40534057288394865, 1.0395940347930615],
            [0.11555575382340327, 0.3097756758628604, 0.6955807502266376, 1.0513018498075208],
            [0.09377670540646443, 0.2359657266379238, 0.48081815534416517, 0.7336551424429486, 0.8852859577802189],
            [
                0.09744903774083799,
                0.23406025988349066,
                0.43999683973660964,
                0.6039351009791605,
                0.6083785563313661,
                0.819785479982322,
            ],
        ],
    },
}

RESULTS_D7 = {
    0: {
        "betas": [
            [0.392699073016575],
            [0.5116901773420067, 0.2741567476665273],
            [0.5661985317903993, 0.3894233314332275, 0.2149224636382155],
            [0.5861698602555185, 0.4433310315931601, 0.3254115006899639, 0.17768618519952264],
            [0.6039121591315466, 0.47319677044649805, 0.3826165050156697, 0.288557486121458, 0.15286907532819657],
            [
                0.6129771905039619,
                0.49028341888091914,
                0.41395889994822016,
                0.34771020555966164,
                0.25644588236054744,
                0.1329871408924161,
            ],
        ],
        "gammas": [
            [0.47804375585153375],
            [0.3672651297083566, 0.6523291598556924],
            [0.3183973909729867, 0.5641377777782616, 0.6424520516170827],
            [0.2841887914755936, 0.5107125732730786, 0.5677423712293328, 0.6516272530636769],
            [0.26116578717777306, 0.47583321096744596, 0.5136612451507881, 0.5786838605584145, 0.6560582659352983],
            [
                0.24367142064975758,
                0.4487877576688949,
                0.48031119728948396,
                0.52449347830861,
                0.5868715760106895,
                0.6613463007073509,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.3926211192742189],
            [0.5115335703261478, 0.2741294469281515],
            [0.5660130336607149, 0.3893719887893359, 0.21498763665769996],
            [0.5860140655917865, 0.4433212805570672, 0.32546209615175936, 0.1776950307459997],
            [0.6037955471920089, 0.473223425997746, 0.38265188871331635, 0.28852512258255963, 0.15288191183784625],
            [
                0.612912980548805,
                0.4903702828939133,
                0.41396466247945407,
                0.34762190285667743,
                0.25641132718986315,
                0.1329742791803199,
            ],
        ],
        "gammas": [
            [0.47768597642923616],
            [0.3668143583190826, 0.6521994389087046],
            [0.31788469435049055, 0.5638730665687796, 0.6423013716807875],
            [0.28375022130592276, 0.5104880516681507, 0.5676389269519503, 0.6515317445661916],
            [0.2607654414652124, 0.4756655029435859, 0.5136869889523579, 0.5785716097245778, 0.6559898440600634],
            [
                0.24333484611298106,
                0.4487075370505288,
                0.4804131040556026,
                0.524380958859272,
                0.5868352372468482,
                0.6613405935808278,
            ],
        ],
    },
    np.float64(0.7357142857142858): {
        "betas": [
            [0.38876996940020825],
            [0.5050338127382978, 0.2738463072454647],
            [0.5588734444345902, 0.38819004532844165, 0.21755592495139897],
            [0.5817936535040475, 0.44424631398801334, 0.32677204121413345, 0.1786893025869822],
            [0.6002555822467955, 0.4749081772933226, 0.3824448084774269, 0.28648191384143007, 0.15328344003060398],
            [
                0.6112709241980666,
                0.4940175559426103,
                0.41353421758704595,
                0.34415435684660495,
                0.25527106380005476,
                0.1332148798717288,
            ],
        ],
        "gammas": [
            [0.4589762711921879],
            [0.3449650241365063, 0.6467256509278564],
            [0.2950290104712589, 0.5537899210886652, 0.6374795829907026],
            [0.26534743023561425, 0.5035485165814823, 0.565313630917762, 0.6454579557630976],
            [0.24404028156326857, 0.47022826544233676, 0.5147254515516636, 0.571470951855438, 0.6524995210555844],
            [
                0.22882310759061003,
                0.4453696144975069,
                0.4838341669505186,
                0.5180573357247854,
                0.5834564840930061,
                0.6580172967751129,
            ],
        ],
    },
    np.float64(1.3714285714285717): {
        "betas": [
            [0.3818696791997342],
            [0.4991883984912177, 0.2765067081933944],
            [0.5539215587850974, 0.3888645896026196, 0.21931883181853243],
            [0.5826097031081753, 0.4489079716363564, 0.3259119775917189, 0.1794188222214416],
            [0.6013575760077363, 0.4784973052299095, 0.3778841110007096, 0.28077496749199066, 0.15255870369295163],
            [
                0.6152074105709355,
                0.4996727538356513,
                0.40881279256012587,
                0.3368902249651567,
                0.25055006345848047,
                0.13280469404433873,
            ],
        ],
        "gammas": [
            [0.41592884662155377],
            [0.3062949042435273, 0.6436897080144918],
            [0.26129450379314967, 0.5469811005475648, 0.6371745452249338],
            [0.23988373331319052, 0.5018428568831067, 0.5661999543659275, 0.6317621550334094],
            [0.22247206651907575, 0.46989875816686133, 0.5187729626099246, 0.5570631176553354, 0.645333113347686],
            [
                0.21060194486240535,
                0.4472019773622814,
                0.49025579727024365,
                0.5064624238916714,
                0.5766750956763805,
                0.6506457317394063,
            ],
        ],
    },
    np.float64(2.0071428571428576): {
        "betas": [
            [0.3787564539885795],
            [0.5028745366605684, 0.27980650591862705],
            [0.5581820456432086, 0.38754926056868666, 0.21658562935208284],
            [0.5917478745260272, 0.45219465080516663, 0.3210033272894648, 0.17942938720389637],
            [0.6100263609594679, 0.47995234136805787, 0.36963146188771745, 0.2728092098949625, 0.14963424752686616],
            [
                0.6253324146126301,
                0.5017331722018492,
                0.3997232781378564,
                0.32739613364563225,
                0.24098817100969339,
                0.1310705155014196,
            ],
        ],
        "gammas": [
            [0.3630013144868587],
            [0.2731904224464827, 0.6541830871797967],
            [0.23630506534986304, 0.5533352016762645, 0.6429361688315605],
            [0.22136792429460536, 0.5102675115242925, 0.5697531433107789, 0.6142322838914626],
            [0.2079492550051434, 0.4791803297223217, 0.5252666639425961, 0.5428583629875322, 0.6361723301848484],
            [
                0.19825851103394856,
                0.45664142012836045,
                0.4980058640155399,
                0.49542910763280806,
                0.5674535664314082,
                0.640981766706587,
            ],
        ],
    },
    np.float64(2.6428571428571432): {
        "betas": [
            [0.38450417904809014],
            [0.5142675238468135, 0.27985657081039045],
            [0.5680896425506684, 0.3805143128186445, 0.2097098784399297],
            [0.605427928647695, 0.45108759337572396, 0.31355151292077854, 0.17922915497817657],
            [0.622554661497781, 0.4771121983335067, 0.3591951679287475, 0.2642040532594907, 0.14496637815933272],
            [
                0.6373593156218913,
                0.4973981625818948,
                0.3870157215184019,
                0.3163056828027267,
                0.22738170566184268,
                0.12787124219387175,
            ],
        ],
        "gammas": [
            [0.31644445693513157],
            [0.2510005097733683, 0.6781758787050138],
            [0.22050053140360915, 0.5695347944767896, 0.6524250740077217],
            [0.20957695044652497, 0.5258676019114786, 0.5756421813011171, 0.5971374207446625],
            [0.19893877121202982, 0.4950298602118569, 0.5337251155801653, 0.5316762658430858, 0.6241718046330378],
            [
                0.19053928660502348,
                0.4710202094583722,
                0.5070993028883894,
                0.48703768756909266,
                0.5562504304021915,
                0.6323160916244555,
            ],
        ],
    },
    np.float64(3.278571428571429): {
        "betas": [
            [0.3987808826366814],
            [0.5292596343339026, 0.27549320583396747],
            [0.5794907188540491, 0.36644978398275746, 0.19966606714786572],
            [0.6206591201762943, 0.4446434636174529, 0.3042605413925233, 0.1786194599401696],
            [0.6360808000824916, 0.4690558087311938, 0.3466040171337751, 0.2563695443791431, 0.14002343530712758],
            [
                0.6494895709734684,
                0.4865364755206978,
                0.3717330185367591,
                0.3043841300543537,
                0.21242434790815398,
                0.12279484677440301,
            ],
        ],
        "gammas": [
            [0.28137729770273606],
            [0.23681405724912633, 0.71405581303828],
            [0.21048564963891767, 0.592449507629969, 0.666037895540307],
            [0.20215812481485032, 0.5474282637267279, 0.5856306482876524, 0.5841547690823286],
            [0.19296010047623607, 0.514739645437618, 0.5441323117610963, 0.5231597460610166, 0.6068842921652398],
            [
                0.18566024943574394,
                0.489166909247433,
                0.5188051952586109,
                0.4823810359039031,
                0.5441919017618971,
                0.6275268262638543,
            ],
        ],
    },
    np.float64(3.914285714285715): {
        "betas": [
            [0.41932907889291765],
            [0.5451999279149219, 0.266432235706627],
            [0.5899092924442212, 0.34456056349776626, 0.18771342575245328],
            [0.6354661372699668, 0.4313531752889434, 0.29186051630055293, 0.1761738055137355],
            [0.6493005897116109, 0.4551018038468367, 0.3319670928968804, 0.2504459885203797, 0.13709311845324906],
            [
                0.6616237288537921,
                0.4697422872965773,
                0.354548595636143,
                0.292257296974523,
                0.19979685937809635,
                0.11557428596489652,
            ],
        ],
        "gammas": [
            [0.25592620236896463],
            [0.22768965395960422, 0.7626736861897483],
            [0.20379102422166304, 0.6199680283049996, 0.686046678433934],
            [0.19734658159300852, 0.5749312171053838, 0.6029998402436667, 0.5786905698721095],
            [0.1885387675594166, 0.536225049438819, 0.5580303828830349, 0.5178133314504545, 0.5836356646420021],
            [
                0.18198716501082607,
                0.5090798172825673,
                0.5346127291912353,
                0.482204068624149,
                0.5311710380162666,
                0.6240367306482286,
            ],
        ],
    },
    np.float64(4.55): {
        "betas": [
            [0.4443711526443308],
            [0.5604733366436823, 0.2520667516933035],
            [0.5977754849663245, 0.31361211357238333, 0.17597058114297323],
            [0.6466004191021553, 0.4055003528205549, 0.2709420135139071, 0.16762041007703662],
            [0.6621623518037261, 0.4344684809703837, 0.3161461106430465, 0.2463816646568765, 0.13826233967806803],
            [
                0.6735872768790423,
                0.4451994244152826,
                0.3344053272085859,
                0.2799841417575314,
                0.19394541691314915,
                0.10775897102047337,
            ],
        ],
        "gammas": [
            [0.2373058702694698],
            [0.22169006472864855, 0.826942202925263],
            [0.19850351827439724, 0.6474540545893024, 0.7176318718874023],
            [0.1931348496157523, 0.604580840553401, 0.6346348984064311, 0.5868888685506805],
            [0.18468159832847417, 0.5572392022284192, 0.579857622699227, 0.5200123939245131, 0.5608083942547331],
            [
                0.17656604422495087,
                0.5196126390615131,
                0.555430866828785,
                0.48802977072262926,
                0.5141979628999641,
                0.6090975583989243,
            ],
        ],
    },
    np.float64(5.185714285714286): {
        "betas": [
            [0.4728957048334198],
            [0.573562389654484, 0.23064652033885105],
            [0.6011738540708699, 0.2715532202912343, 0.1682398618316724],
            [0.6212754170931175, 0.30951030428656945, 0.22715035249691437, 0.13881087256160635],
            [0.6769824975985446, 0.40557634894946676, 0.2995325194764708, 0.2409966831444637, 0.14254815510586452],
            [
                0.6749621247945475,
                0.38903964745712677,
                0.32069955987924864,
                0.2713821052845479,
                0.20641266904221803,
                0.11307352279252508,
            ],
        ],
        "gammas": [
            [0.22346127363107288],
            [0.2173082757030393, 0.9100343057930843],
            [0.1919487818532646, 0.6570850611234479, 0.7762342758387858],
            [0.1688949121045924, 0.504580840553401, 0.6814104481551643, 0.6552421410052396],
            [0.17834878218836744, 0.5636889938809432, 0.6182384870610547, 0.5411679532347332, 0.5513040325776306],
            [
                0.1493818622538952,
                0.41961263906151314,
                0.5659280241216713,
                0.5300942695575741,
                0.5056101008644489,
                0.5676438363755224,
            ],
        ],
    },
    np.float64(5.821428571428572): {
        "betas": [
            [0.5044557762684774],
            [0.5818567218626494, 0.19736736026460266],
            [0.6010956353553872, 0.22258463950161403, 0.16249999007220164],
            [0.6037427373024689, 0.2585657896474245, 0.19987725349220808, 0.12679283024278126],
            [0.7769824975985445, 0.4249544982781685, 0.28766514098342394, 0.2224650607608999, 0.13722841851497214],
            [
                0.7749621247945475,
                0.45408335718873744,
                0.31291743708387637,
                0.2481200141827368,
                0.1914455485006604,
                0.11424824877440273,
            ],
        ],
        "gammas": [
            [0.21307139319325988],
            [0.21200234115956582, 0.9957734486831897],
            [0.18465331617550315, 0.6440134923518906, 0.8762342758387858],
            [0.15907484592399335, 0.4601495454760344, 0.7753156743727859, 0.7378776222890905],
            [0.14939723356460613, 0.4636889938809432, 0.6334041133062408, 0.593323818836684, 0.5940959029532944],
            [
                0.11477026847021325,
                0.31961263906151316,
                0.5475204880792091,
                0.5768739803968266,
                0.5618613999812927,
                0.5931494039266066,
            ],
        ],
    },
    np.float64(6.457142857142857): {
        "betas": [
            [0.5389881734097264],
            [0.5816584400921629, 0.14270833885176412],
            [0.6024144379124597, 0.1760267657689816, 0.1421990543884974],
            [0.5960206385018003, 0.19964523915773666, 0.14225198753121576, 0.11690696997454919],
            [0.8769824975985445, 0.44120128885957416, 0.24630910264686431, 0.17651228639580915, 0.11309106544786521],
            [
                0.8749621247945475,
                0.4732316084165319,
                0.2672593293463432,
                0.19420770742134605,
                0.14839504917177895,
                0.09579927751712512,
            ],
        ],
        "gammas": [
            [0.20531901880291642],
            [0.19637544046573094, 0.8957734486831898],
            [0.18077209675985237, 0.6519471487479327, 0.9762342758387857],
            [0.1638138661741776, 0.5038000935052642, 0.8753156743727859, 0.8378776222890905],
            [0.12662000881675498, 0.3636889938809432, 0.5979486123823761, 0.6594930141017035, 0.6843646839918658],
            [
                0.10817018688418513,
                0.28902035409565524,
                0.509509004220851,
                0.6094146801280327,
                0.64538591448597,
                0.6624381886955902,
            ],
        ],
    },
    np.float64(7.092857142857143): {
        "betas": [
            [0.5766770229557789],
            [0.601155204310547, 0.114867926264071],
            [0.6064356641853158, 0.16441225778669888, 0.08349389290603652],
            [0.5979519374321841, 0.20274006278691079, 0.07382052017843387, 0.08316824403668141],
            [0.8880469352376851, 0.39224968541536787, 0.20239722083090952, 0.138764660027629, 0.09323744524516549],
            [
                0.8847018984762306,
                0.3943883765276912,
                0.2063898949272845,
                0.14338752281712489,
                0.11024596055526706,
                0.07418843370959105,
            ],
        ],
        "gammas": [
            [0.19970767624297997],
            [0.1848665566606893, 0.7957734486831898],
            [0.16408906975186402, 0.5519471487479327, 1.0762342758387857],
            [0.14240825421797376, 0.41084048407371754, 0.9753156743727859, 0.9378776222890904],
            [0.13515320045398638, 0.3640598537434296, 0.6026604203413894, 0.717916968546138, 0.7672822685190879],
            [
                0.13342121883997232,
                0.33669960724546666,
                0.5419602355404671,
                0.650644027452261,
                0.7048416241157497,
                0.7226613262428676,
            ],
        ],
    },
    np.float64(7.7285714285714295): {
        "betas": [
            [0.6177018513870798],
            [0.6387019506703786, 0.13431267768556263],
            [0.6289793672543967, 0.20320619836814394, 0.0333120483115815],
            [0.6107273135396132, 0.2329809760058602, 0.050336406807617376, -0.012474475607251064],
            [0.8551907692365743, 0.35709486030880244, 0.1875767406370286, 0.11336377652108864, 0.06411917090813851],
            [
                0.8367574755377278,
                0.3545007472807048,
                0.19780886464446595,
                0.12612588915794484,
                0.08592565217873306,
                0.04910650950501647,
            ],
        ],
        "gammas": [
            [0.19590869420068],
            [0.17315812910763245, 0.6957734486831898],
            [0.14556083614488186, 0.45194714874793274, 0.9762342758387857],
            [0.13285741101960363, 0.37278755750759857, 0.8753156743727859, 1.0378776222890904],
            [0.15176016065027556, 0.36664457315587057, 0.5450642745956231, 0.6549891070133426, 0.7411593382452256],
            [
                0.1600889835097758,
                0.36023768197984196,
                0.5017581189869667,
                0.5809145482346778,
                0.6516424648230491,
                0.7040389852215003,
            ],
        ],
    },
    np.float64(8.364285714285716): {
        "betas": [
            [0.6613087023717436],
            [0.6840280399230754, 0.193187683247804],
            [0.6848963731190656, 0.2869182627192944, 0.09881152178616809],
            [0.6503578577293075, 0.28346049828538555, 0.12455630309095315, 0.08752552439274894],
            [0.7551907692365744, 0.4360931941956404, 0.18668446746151895, 0.08229070702391925, 0.07951820654309921],
            [
                0.7367574755377279,
                0.38471369526713617,
                0.13501413581916952,
                0.08097655493041304,
                0.05179471874075883,
                0.11813564981197744,
            ],
        ],
        "gammas": [
            [0.19349487173328558],
            [0.158970480765394, 0.5957734486831898],
            [0.1351915706531806, 0.4086819154004091, 0.9418186463425668],
            [0.1307103229375442, 0.3801284311503517, 0.8159465192756639, 1.1378776222890905],
            [0.08169434097680744, 0.26664457315587053, 0.6117518021086851, 0.7549891070133425, 0.8411593382452256],
            [
                0.0838469207908235,
                0.2662594660599266,
                0.6017581189869666,
                0.6809145482346778,
                0.7516424648230491,
                0.8040389852215003,
            ],
        ],
    },
    np.float64(9.0): {
        "betas": [
            [0.7030797512917815],
            [0.7157566116800773, 0.24446336472124044],
            [0.6876514473693516, 0.29647364333004916, 0.1603174930973263],
            [0.665183458956117, 0.31031393713358624, 0.1337654187961919, 0.12932519851564275],
            [0.6652932719285003, 0.3507882481557496, 0.15356076116824313, 0.0888084423478434, 0.1095891701200366],
            [
                0.72690462421164,
                0.3551540465351025,
                0.1546299570326792,
                0.09030124214247158,
                0.03032700484638127,
                0.12803005734076145,
            ],
        ],
        "gammas": [
            [0.19129374904790783],
            [0.14966323913480298, 0.5486248819617311],
            [0.12993743997394394, 0.4077225035485231, 1.041818646342567],
            [0.11343030062828927, 0.31181477028545146, 0.7159465192756639, 1.1396332132853026],
            [0.09491686634715626, 0.24362397242215109, 0.5117518021086851, 0.7843776029064042, 0.9411593382452256],
            [
                0.10175086149108414,
                0.25579922333048266,
                0.5017581189869667,
                0.7066235110556579,
                0.6967656199402016,
                0.7526299687711503,
            ],
        ],
    },
}

RESULTS_D8 = {
    0: {
        "betas": [
            [0.39269907228741574],
            [0.5096727475436276, 0.2734429125386979],
            [0.5641792938282348, 0.3865445285415814, 0.2143468548799745],
            [0.5842983590432397, 0.44003828055497424, 0.32238787601842966, 0.17698919318160702],
            [0.6022259720882883, 0.4702564059736316, 0.37922177795111883, 0.2853293446721277, 0.15222799417721844],
            [
                0.6114412636626544,
                0.48741732509274865,
                0.4107470705123959,
                0.3438517100156593,
                0.2531731465268967,
                0.1323633895402455,
            ],
        ],
        "gammas": [
            [0.4806019504744409],
            [0.368876216243991, 0.6537525102145751],
            [0.31965224081435983, 0.5644625417740576, 0.6418732314606785],
            [0.28540614022524696, 0.5109908667027291, 0.5663325151912271, 0.6502068810198736],
            [0.26220742605131814, 0.4762667724208674, 0.512783937076352, 0.5767241603988552, 0.6535890371272889],
            [
                0.24472681666067586,
                0.449184389551385,
                0.4795503715386773,
                0.5232785309393636,
                0.5839727576677174,
                0.6581957335366035,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.3926175774395113],
            [0.5094755480941173, 0.27339190980662503],
            [0.5639501185557009, 0.3864684270363091, 0.21441804220227229],
            [0.5840805514435395, 0.43997929427257193, 0.3224591147127318, 0.1770156925701385],
            [0.6020479683405281, 0.470231546299295, 0.37928912862802555, 0.28533253625492044, 0.15225311769337926],
            [
                0.6113058679725698,
                0.48745564589266127,
                0.41081065932870636,
                0.3438072272253928,
                0.2531780421037175,
                0.13237650673330825,
            ],
        ],
        "gammas": [
            [0.48028718886027866],
            [0.36844509523921765, 0.6535764538406538],
            [0.31913299566949116, 0.5641424847125072, 0.6416935850643735],
            [0.28493656354008584, 0.5106684832978066, 0.5661707637481262, 0.6501324102556165],
            [0.2617736542869652, 0.4760109128478527, 0.5127514470642744, 0.5766576215372938, 0.6535555878642576],
            [
                0.24433331386377108,
                0.44898633719042963,
                0.47959681233702983,
                0.5231970547185174,
                0.5839124418772075,
                0.6581594982054919,
            ],
        ],
    },
    np.float64(0.8071428571428572): {
        "betas": [
            [0.38772621145984293],
            [0.4998257221551915, 0.27206700786467786],
            [0.5537652177763953, 0.38473442576055744, 0.21795286942042572],
            [0.5765610128781596, 0.43980946827191664, 0.3249628175792715, 0.1786100941532921],
            [0.595696614527897, 0.4712706541509027, 0.38064642796926335, 0.2842589603423342, 0.15315116838712553],
            [
                0.6071255133793287,
                0.4908060267424593,
                0.4118595093661202,
                0.34112256704246174,
                0.25290059462391856,
                0.13296549825247114,
            ],
        ],
        "gammas": [
            [0.4603483157504113],
            [0.3434099049102143, 0.6446252260712768],
            [0.2919450302636359, 0.5498065421070097, 0.6355351624321971],
            [0.2622322859032838, 0.49903620658359893, 0.5622510430513343, 0.6445188284512312],
            [0.2409748811205178, 0.4664652276326448, 0.5128514356072489, 0.5705325473674541, 0.650947731018566],
            [
                0.2259827893832763,
                0.44200089121378505,
                0.48253750404099255,
                0.5173228464793977,
                0.5810343224396536,
                0.6554675494353862,
            ],
        ],
    },
    np.float64(1.5142857142857145): {
        "betas": [
            [0.37865885293395724],
            [0.49123972065537863, 0.2752005599647303],
            [0.5472490012322322, 0.3870281039317179, 0.22067175744291193],
            [0.5760862642439137, 0.4458100085682062, 0.3254925267205843, 0.1799021849685175],
            [0.5957695480749896, 0.4760932744120105, 0.3771554973525198, 0.27941792882663136, 0.15291093269073522],
            [
                0.6102083927228479,
                0.49764373792704786,
                0.408087330558916,
                0.33465267575532687,
                0.24952928843389688,
                0.13298298521813787,
            ],
        ],
        "gammas": [
            [0.4136732857643902],
            [0.2998212943516737, 0.6375832621477753],
            [0.2540287064339793, 0.5405404736001302, 0.6362139237833407],
            [0.23321931305686244, 0.49501693642168254, 0.5636307510889269, 0.6316873122434086],
            [0.21625421708150025, 0.46416201952276565, 0.51717217854955, 0.5566099887027847, 0.6451820874480166],
            [
                0.204886912581753,
                0.4420588208722177,
                0.4890330869626688,
                0.5055440535604495,
                0.5756543225141855,
                0.6497382026030658,
            ],
        ],
    },
    np.float64(2.2214285714285715): {
        "betas": [
            [0.37397635382760197],
            [0.4951214434433015, 0.2797265914071886],
            [0.5526879388166742, 0.3878477851186134, 0.21829342204960855],
            [0.5861015648645161, 0.4505993409240493, 0.32137932840824746, 0.18006086951215616],
            [0.605097212416105, 0.47870885721054035, 0.3692046948053057, 0.27202701280527875, 0.1503896633148325],
            [
                0.6211840500908105,
                0.5010974302924339,
                0.39967797512479436,
                0.3258016697644137,
                0.24141630835002792,
                0.1315699197230629,
            ],
        ],
        "gammas": [
            [0.3570796715426493],
            [0.26429183925175276, 0.6468461680696744],
            [0.2277833057540072, 0.5475723419901571, 0.6434476353224547],
            [0.2135814864317106, 0.5036672693988415, 0.5679109962426534, 0.615214544781472],
            [0.2006512610945218, 0.4733402133550066, 0.5236885481525223, 0.5423010204816552, 0.6375619015443553],
            [
                0.19164088501978122,
                0.45162965449734715,
                0.4967971641194743,
                0.4943781310057722,
                0.5684243069712083,
                0.642117772794809,
            ],
        ],
    },
    np.float64(2.928571428571429): {
        "betas": [
            [0.3794725943108701],
            [0.5080672963075186, 0.28069491497460203],
            [0.564650863260094, 0.38282263207134337, 0.21155259676876198],
            [0.6011860760319697, 0.45062130033600595, 0.3144871071193785, 0.17980333812422378],
            [0.618666155715277, 0.4767041677150026, 0.35894547257272696, 0.26366032725411703, 0.1459568578663365],
            [
                0.63455464608755,
                0.4982081443175052,
                0.38767907119312367,
                0.315179712558108,
                0.22898647898387495,
                0.12866879997108827,
            ],
        ],
        "gammas": [
            [0.3088927581082188],
            [0.24133717752018288, 0.6705999594273964],
            [0.21186154638579555, 0.565402786138035, 0.6540111572127065],
            [0.20157234372768482, 0.5201848057604249, 0.573923403027989, 0.5988142364465475],
            [0.19137294544736427, 0.48972283121374977, 0.531930042728429, 0.5309159524057032, 0.6274618378617892],
            [
                0.18367882013383993,
                0.4667883441357446,
                0.5057398772122181,
                0.4858451114012688,
                0.5591817277113639,
                0.6348500194962541,
            ],
        ],
    },
    np.float64(3.635714285714286): {
        "betas": [
            [0.3941684235212895],
            [0.5249792025795906, 0.2770791763598703],
            [0.5782493156959327, 0.3708706502104454, 0.20141808104130426],
            [0.6180258691345241, 0.44544087288313255, 0.3059494240010159, 0.1792394459183355],
            [0.6333323103051808, 0.46947966551991266, 0.34661921764512854, 0.2556039069812821, 0.1407785214997927],
            [
                0.6478800588941077,
                0.4885992760499711,
                0.37263199993049284,
                0.303316664564741,
                0.21418616483280126,
                0.12401912175073548,
            ],
        ],
        "gammas": [
            [0.2735946422147497],
            [0.22695687767014275, 0.7061764086270242],
            [0.20207695040685095, 0.5905120754593413, 0.6683268725703418],
            [0.19425359334018333, 0.5430679806563231, 0.5831691753207265, 0.5856813570181263],
            [0.18556467370499588, 0.5108707580178934, 0.5421780099529501, 0.5223489166604225, 0.6128705847793147],
            [
                0.1788510425182643,
                0.48630412698842845,
                0.5169615393744961,
                0.4805023070643496,
                0.5481603875438432,
                0.6304645879984271,
            ],
        ],
    },
    np.float64(4.3428571428571425): {
        "betas": [
            [0.4153006594666764],
            [0.5430196469598777, 0.2688798189386351],
            [0.5909407566334514, 0.3514596146379794, 0.18881263776555637],
            [0.6349633599959893, 0.43460812591968095, 0.2952513279034487, 0.17758869389200707],
            [0.647750637588622, 0.4566916792934317, 0.33230625006575465, 0.24903566669844368, 0.13679772978722235],
            [
                0.6609026240390661,
                0.4729985444052137,
                0.35537987898943624,
                0.2910019242356076,
                0.2004051983532674,
                0.11722879512215455,
            ],
        ],
        "gammas": [
            [0.248401873529554],
            [0.21787074928263084, 0.7543329388630702],
            [0.1958970051707183, 0.6216569500281192, 0.6884505656903324],
            [0.18983122295173896, 0.5729830040694603, 0.598405106979536, 0.5786111888374866],
            [0.18173558150278335, 0.5355546608912044, 0.5557149788578266, 0.5165508843859902, 0.5924008569014098],
            [
                0.17580349678627719,
                0.5095747499189478,
                0.5321550260412125,
                0.4792046706182236,
                0.5360651108653128,
                0.6285247886777715,
            ],
        ],
    },
    np.float64(5.05): {
        "betas": [
            [0.4409256986708161],
            [0.5607230291758759, 0.2558426953390365],
            [0.6014542332093405, 0.3237784470376156, 0.1753348089891398],
            [0.6503307777274421, 0.41563373037682894, 0.27932608916489915, 0.17234429030067075],
            [0.6618148212040179, 0.43801188236012706, 0.31674960007677827, 0.24448770539736683, 0.13620478735480673],
            [
                0.67386278844519,
                0.4512536936609712,
                0.3354684341862968,
                0.27843517559049336,
                0.19136581200332395,
                0.10888089029382109,
            ],
        ],
        "gammas": [
            [0.2301417663035236],
            [0.21213409984103504, 0.8184997975223088],
            [0.19168151970859473, 0.6568523289401242, 0.7181177149960661],
            [0.18697571176512737, 0.6101298199184535, 0.6249827194679377, 0.5816861916276358],
            [0.1790872806106054, 0.5632007106402134, 0.5759056856399838, 0.5161960227337745, 0.5699645443876555],
            [
                0.1728695874350981,
                0.5321623503116216,
                0.5532345501455119,
                0.48280763477859145,
                0.5211912930286786,
                0.6203854077754385,
            ],
        ],
    },
    np.float64(5.757142857142857): {
        "betas": [
            [0.470011564065462],
            [0.5769200946716146, 0.2368484517217734],
            [0.6084975010820918, 0.28575688714528347, 0.16413493287201233],
            [0.6578532627926608, 0.37538764913958816, 0.24659544050517326, 0.15481107610281541],
            [0.6769045896816018, 0.41299373049450716, 0.3006259099310731, 0.24043146753121034, 0.13930142786531818],
            [
                0.6880014743806373,
                0.41987139380134786,
                0.31333652708638,
                0.26692858313660395,
                0.19282577564923306,
                0.10474819601329532,
            ],
        ],
        "gammas": [
            [0.2166410850899079],
            [0.20845189376334747, 0.9041502306010971],
            [0.1874272285338859, 0.6852702481593519, 0.7672666944300097],
            [0.1826719702551402, 0.6408295974288887, 0.6779565496472941, 0.6089387799381002],
            [0.1764264497914222, 0.5903917557018762, 0.6097442559551453, 0.5286060527353321, 0.5556624155038115],
            [
                0.16518717169870623,
                0.5270179804032469,
                0.5822299876909178,
                0.4980623443559627,
                0.5042739313947568,
                0.5913858064769164,
            ],
        ],
    },
    np.float64(6.464285714285714): {
        "betas": [
            [0.5021477465249556],
            [0.5895120833425945, 0.2086061461257621],
            [0.6090161684045375, 0.23516054921920798, 0.16041755994362758],
            [0.6297112195484157, 0.27538764913958813, 0.20118291911330596, 0.12370125266625916],
            [0.7521326802679178, 0.41215545532928766, 0.29114600294159537, 0.2293843175994632, 0.14069200706592966],
            [
                0.7874322116469984,
                0.44421253519980597,
                0.30772481962329856,
                0.2531219731941162,
                0.19075027111578607,
                0.10964033805382294,
            ],
        ],
        "gammas": [
            [0.20655595723362666],
            [0.20483281986843993, 1.0041502306010972],
            [0.17897449875950286, 0.6619927539470241, 0.8672666944300097],
            [0.16289387061329394, 0.5408295974288887, 0.7615563774665227, 0.7079232201302862],
            [0.15050877595564977, 0.4903917557018762, 0.6421897671338562, 0.5816408386944503, 0.5841220013446515],
            [
                0.1359820156954254,
                0.4270179804032469,
                0.5866334363415339,
                0.5393273416457061,
                0.5344386695199541,
                0.5938072831522945,
            ],
        ],
    },
    np.float64(7.171428571428572): {
        "betas": [
            [0.5373459179298301],
            [0.5886576841519068, 0.15612970101684318],
            [0.611399187477365, 0.18516364492399934, 0.14674686893990677],
            [0.6111769782445496, 0.21734567078250894, 0.16071383464488154, 0.1157190832605866],
            [0.8521326802679178, 0.43653289112579846, 0.25936110364394066, 0.1888791357183466, 0.11821820390673018],
            [
                0.8874322116469984,
                0.4735195327388836,
                0.27624715666013505,
                0.2068033733660856,
                0.15664174552147656,
                0.09811957237886405,
            ],
        ],
        "gammas": [
            [0.19907980065025402],
            [0.18981910219714637, 0.9041502306010972],
            [0.1754849806543174, 0.6675915379902027, 0.9672666944300097],
            [0.15618277678284115, 0.49275755519803915, 0.8615563774665227, 0.8079232201302862],
            [0.12967071675093317, 0.39039175570187623, 0.6116458941519932, 0.6432788412954992, 0.6667778537625697],
            [
                0.11349024964581839,
                0.3270179804032469,
                0.5376570176419045,
                0.5929412493610665,
                0.6209818894968518,
                0.6514772495959382,
            ],
        ],
    },
    np.float64(7.878571428571429): {
        "betas": [
            [0.5759233200687489],
            [0.6022705879634649, 0.118126223981543],
            [0.6131600460958483, 0.16561018008052686, 0.10131816838600392],
            [0.6030581680499252, 0.17981024524174266, 0.08551311490828395, 0.09709684236560856],
            [0.8970333301258887, 0.40982096973391036, 0.2134006394895777, 0.14571877261493196, 0.0962972394298554],
            [
                0.8951246683501889,
                0.4137042182210481,
                0.21612065125673183,
                0.15107774592866938,
                0.11640886299010685,
                0.0787743808339752,
            ],
        ],
        "gammas": [
            [0.19374540803933066],
            [0.17865913542019676, 0.8041502306010972],
            [0.16079733115370543, 0.5675915379902027, 1.0672666944300098],
            [0.15022048439612345, 0.473065582507556, 0.9615563774665227, 0.9079232201302861],
            [0.12312071818501125, 0.34966020615352333, 0.5958418396495591, 0.7129659569470876, 0.7667778537625697],
            [
                0.11877236440524302,
                0.3239927032545763,
                0.547979049325959,
                0.6625404205144922,
                0.716826370210235,
                0.7352691367730732,
            ],
        ],
    },
    np.float64(8.585714285714285): {
        "betas": [
            [0.6182973902672051],
            [0.6369120357760736, 0.13031403277177325],
            [0.6285455675851425, 0.19111979030115692, 0.037614555766414315],
            [0.6212040502853985, 0.23378236208617442, 0.05614470944662582, 0.010342890823394638],
            [0.8588700420762707, 0.3455965366167418, 0.18303714826103254, 0.11559519291934017, 0.06980797328677328],
            [
                0.8492592199966608,
                0.3398752689780787,
                0.18913089575756512,
                0.12544295655743226,
                0.08976494706582736,
                0.05508188171005855,
            ],
        ],
        "gammas": [
            [0.1902773617829728],
            [0.16790636691350802, 0.7041502306010973],
            [0.14398094412202864, 0.4675915379902027, 0.9672666944300098],
            [0.12830747380395344, 0.37306558250755595, 0.8615563774665227, 0.9044667353780147],
            [0.14908333329453247, 0.3961659072884014, 0.5966880962838866, 0.7095186497531537, 0.7884448044485021],
            [
                0.15638600383146364,
                0.3915720290028508,
                0.551777545196551,
                0.6368042808822301,
                0.6980033277149381,
                0.7394922511857212,
            ],
        ],
    },
    np.float64(9.292857142857143): {
        "betas": [
            [0.6640130537993525],
            [0.681131548107613, 0.18513848725987828],
            [0.6698756128812003, 0.2773607317225503, 0.08563112099841912],
            [0.6627627582696285, 0.2991503980017002, 0.11945316666168719, 0.07443805290163345],
            [0.7588700420762707, 0.41123940003709136, 0.1717779171719905, 0.07443060286059545, 0.059332335822238604],
            [
                0.7492592199966608,
                0.3642707197057112,
                0.1361934884336752,
                0.08632101040622707,
                0.04449437495845792,
                0.09242437037482079,
            ],
        ],
        "gammas": [
            [0.18831765249024232],
            [0.154521556892856, 0.6041502306010973],
            [0.12497820847419033, 0.3748349964804824, 0.8672666944300098],
            [0.12560514626857539, 0.3673858729514731, 0.7615563774665227, 1.0044667353780148],
            [0.09122082846959824, 0.2961659072884014, 0.649419381746326, 0.8095186497531537, 0.888444804448502],
            [
                0.09196176742221371,
                0.29157202900285084,
                0.651777545196551,
                0.73680428088223,
                0.7980033277149381,
                0.8394922511857211,
            ],
        ],
    },
    np.float64(10.0): {
        "betas": [
            [0.7080769957355263],
            [0.7160166060857616, 0.23707686357134664],
            [0.6892256128069597, 0.29749418572985753, 0.15087203487134154],
            [0.6615212672487829, 0.30439677627588146, 0.13219934110417558, 0.1321695199797299],
            [0.6668598029303451, 0.34055889464719635, 0.14652976004547905, 0.0840905447003312, 0.10214635070385415],
            [
                0.7267835878629951,
                0.34106186549138,
                0.14596474832156106,
                0.08679252152721842,
                0.018361715838387076,
                0.12395649402123501,
            ],
        ],
        "gammas": [
            [0.186580079800671],
            [0.14598775171519973, 0.5616047903786019],
            [0.125490754324663, 0.39808776081082037, 0.9672666944300098],
            [0.11053246455871482, 0.304714247582013, 0.6815500674873333, 1.1044667353780149],
            [0.09615762377774494, 0.2534239411985045, 0.549419381746326, 0.8429669224488509, 0.988444804448502],
            [
                0.10388616335819602,
                0.27241516676009253,
                0.551777545196551,
                0.7808494112785934,
                0.7233580174389509,
                0.7593479531789994,
            ],
        ],
    },
}

RESULTS_D9 = {
    0: {
        "betas": [
            [0.3926990710975179],
            [0.5081142351246916, 0.2729059297948021],
            [0.5626092769268434, 0.3843336376291099, 0.21391195488769346],
            [0.5828411311279913, 0.4374994659068232, 0.3200798286836044, 0.17647665332697743],
            [0.6009134813079936, 0.46795188474007593, 0.37658540629073606, 0.28286663520482097, 0.151758708481154],
            [
                0.6102441054796545,
                0.4851790772697452,
                0.4082433660483002,
                0.3408676202222191,
                0.250703234679609,
                0.13191676323701804,
            ],
        ],
        "gammas": [
            [0.4826258181937241],
            [0.37016606200040797, 0.6549000776615398],
            [0.32065713017691594, 0.5647664840990418, 0.6414869655121614],
            [0.286366633705826, 0.5112299971764087, 0.5652791127242625, 0.649143445741534],
            [0.26305006194770836, 0.4766368469103263, 0.5120970645622372, 0.5752215834972401, 0.6517481801168015],
            [
                0.24554316409216007,
                0.44949721617506827,
                0.4789521549507317,
                0.522279242397429,
                0.5816769268913987,
                0.655734967751374,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.39261506576866967],
            [0.5078762244962461, 0.27282498810350087],
            [0.5623317492699254, 0.3842247305700726, 0.2139891520527419],
            [0.5825531527176833, 0.4373513013502805, 0.32014424974793526, 0.1765169729316764],
            [0.6006530077839436, 0.46786314018356184, 0.376678758640286, 0.28289097353712905, 0.15179025827935935],
            [
                0.610034420324829,
                0.4851493032698718,
                0.40833103658009,
                0.34085225114314166,
                0.25071329512289486,
                0.131929058719183,
            ],
        ],
        "gammas": [
            [0.4823449519768303],
            [0.36975184319424276, 0.6546845806163796],
            [0.320128165143335, 0.5643856399596912, 0.6412706140763792],
            [0.2858715217490503, 0.5108250714796059, 0.5650655274606426, 0.6490942226259652],
            [0.2625705670146307, 0.4762737885918526, 0.5120102672511616, 0.575195005672049, 0.6517205521681814],
            [
                0.24512053703808023,
                0.4492097415209489,
                0.47895098608775605,
                0.5222594292343025,
                0.5816567238632548,
                0.6557332509684821,
            ],
        ],
    },
    np.float64(0.8785714285714286): {
        "betas": [
            [0.3866045460872371],
            [0.49454077911529665, 0.27020805122110153],
            [0.5485351975466872, 0.3816040561430149, 0.21854674241275035],
            [0.5710210328234387, 0.43554422141917715, 0.32378584150331585, 0.17870592715154554],
            [0.5908165042586694, 0.4677121614213657, 0.3796341434077202, 0.28286049152330955, 0.15323188992259626],
            [
                0.6026191061546688,
                0.4876227519189787,
                0.4110195826413747,
                0.33903494018990493,
                0.2511967621150553,
                0.13286112287841131,
            ],
        ],
        "gammas": [
            [0.46113892808873475],
            [0.3413919428192161, 0.6417348408852765],
            [0.28832783168948123, 0.5450648733242784, 0.6334148140199024],
            [0.25860217757018694, 0.49364786953099526, 0.5591245533798229, 0.6439057915975015],
            [0.2373695271049017, 0.46174273194242405, 0.5107191837133409, 0.5700544504494277, 0.6497978240557042],
            [
                0.2225916079507537,
                0.43768830253927804,
                0.4810545399099088,
                0.51716730934978,
                0.5791201899160914,
                0.6534326823402018,
            ],
        ],
    },
    np.float64(1.6571428571428573): {
        "betas": [
            [0.3752453671338366],
            [0.4831891385099901, 0.2739984453102281],
            [0.5405653231178698, 0.38557103705928636, 0.22216248401999455],
            [0.5693098532779255, 0.44294257075195914, 0.32549125168708076, 0.18047866624118059],
            [0.5899885423479772, 0.47389126286972344, 0.3771279718301344, 0.2787114915890848, 0.15337878798670956],
            [
                0.6048446823673232,
                0.4955754131812804,
                0.40796876521312814,
                0.3331152031913913,
                0.2487985101560918,
                0.13318807154191464,
            ],
        ],
        "gammas": [
            [0.41074666511724967],
            [0.29316593999126533, 0.6306710136300677],
            [0.24671717189879072, 0.5335287996879484, 0.6351452512109315],
            [0.22652296024562205, 0.4876004564806484, 0.5611801317061629, 0.6318586648493644],
            [0.2099707106840311, 0.4577894054446226, 0.5155676357135149, 0.5567097903036318, 0.6452005751149453],
            [
                0.19900388813763345,
                0.43614873756798284,
                0.4877396589212253,
                0.5052918469967568,
                0.5747622663110498,
                0.64885990806151,
            ],
        ],
    },
    np.float64(2.435714285714286): {
        "betas": [
            [0.3690967247427332],
            [0.4874179832770963, 0.2797345414618772],
            [0.5473146420173792, 0.3882868184953528, 0.22008528431656715],
            [0.5802034011752206, 0.44901133286385486, 0.32190335112101487, 0.18068298651207873],
            [0.5999903563623109, 0.4774869822074967, 0.36932224414075676, 0.27166308800635675, 0.15114293392449715],
            [
                0.6165453006305935,
                0.5000262046189979,
                0.3998882823659759,
                0.32472537828676096,
                0.24182855943936532,
                0.13200813553829407,
            ],
        ],
        "gammas": [
            [0.3506595941568883],
            [0.2557570241644089, 0.6391338303514327],
            [0.21966312085499107, 0.5413557105988533, 0.6435603229936928],
            [0.20612033120380335, 0.4965992452205425, 0.5661159894643656, 0.6163261900353163],
            [0.19363670267715025, 0.46702256681139664, 0.522198652953729, 0.5423908867519938, 0.6389200402426134],
            [
                0.18510333236688625,
                0.44576247291608845,
                0.49540339070071304,
                0.4939344204118708,
                0.5691575715238716,
                0.6428573783625463,
            ],
        ],
    },
    np.float64(3.2142857142857144): {
        "betas": [
            [0.3745296229070062],
            [0.5018106480106704, 0.28143085635610143],
            [0.5612170346787784, 0.3848896825813838, 0.21356153812618678],
            [0.5964847457944007, 0.4497669372510962, 0.3153150460998822, 0.1802826274710175],
            [0.6144631614767877, 0.4760158721138734, 0.35908065315193344, 0.2634469685176217, 0.14692311755952592],
            [
                0.6310678467000324,
                0.4981246766812296,
                0.3883840533713212,
                0.31447307001097613,
                0.23047207396123282,
                0.12933158313747412,
            ],
        ],
        "gammas": [
            [0.30120776985108616],
            [0.23235109473819957, 0.6628327406505637],
            [0.20373931200055698, 0.5604175029419352, 0.6547845042087764],
            [0.193997365686331, 0.5137556657052478, 0.5721992593418447, 0.600569206604109],
            [0.18418914213424678, 0.4837105920104368, 0.5302028852110532, 0.530831226027304, 0.6304452498357783],
            [
                0.1769891466031242,
                0.4613969005286707,
                0.5041234016413028,
                0.4853296423777415,
                0.5617201494346377,
                0.6369784735544659,
            ],
        ],
    },
    np.float64(3.992857142857143): {
        "betas": [
            [0.3897353994539859],
            [0.5203337398889972, 0.2783078180893236],
            [0.5766748612577471, 0.3745243810977727, 0.2034732935303349],
            [0.6145419981677352, 0.44524552692818475, 0.3071345537416933, 0.17961843672886296],
            [0.6300399500602913, 0.469242373422001, 0.3468643501071997, 0.25520289941979457, 0.1416198193170288],
            [
                0.6454758145859107,
                0.48943928262134884,
                0.37364781622628995,
                0.3027518352972282,
                0.21610628967358278,
                0.12501269642159418,
            ],
        ],
        "gammas": [
            [0.2659215941521676],
            [0.21790004419578804, 0.6980750907227958],
            [0.19413473362417638, 0.5869705951060816, 0.6695482490220177],
            [0.18672099777927245, 0.5373435117906643, 0.580863349811933, 0.5874657205367854],
            [0.17846583578562772, 0.5056108732585305, 0.5402056555670106, 0.5221995284631836, 0.6180563199096125],
            [
                0.17217289326772467,
                0.48167072282208656,
                0.5149367051278151,
                0.4796540857044198,
                0.5521058225181802,
                0.6333054288755167,
            ],
        ],
    },
    np.float64(4.771428571428571): {
        "betas": [
            [0.4114627589134222],
            [0.5400174052322284, 0.2706233273386393],
            [0.5910950423764557, 0.35683068608903495, 0.19050795468052803],
            [0.6328948782544476, 0.4355855578216587, 0.2973429917689968, 0.17822905530876712],
            [0.6453668467138179, 0.4570382090654036, 0.3326885665618701, 0.2480745928808796, 0.13690136223793614],
            [
                0.6592559292346384,
                0.4745534488959098,
                0.3563472697440156,
                0.2902694216729572,
                0.20161916961460702,
                0.11861392697410612,
            ],
        ],
        "gammas": [
            [0.24110348909434695],
            [0.20885185176726087, 0.7455131457656162],
            [0.18826348592500106, 0.620282216596373, 0.6898778147757622],
            [0.1824787108363769, 0.5683669739073965, 0.5944918850370617, 0.579466909174614],
            [0.17494533502273815, 0.5320548990709892, 0.5533786813415416, 0.5161942314853878, 0.6000254149486689],
            [
                0.1694015123197655,
                0.5066586251420636,
                0.5295093134976686,
                0.47756113691941865,
                0.5408139227494401,
                0.6323062825801553,
            ],
        ],
    },
    np.float64(5.55): {
        "betas": [
            [0.4376391091246919],
            [0.5595243296485087, 0.25837257753786663],
            [0.6034728564895557, 0.33136161320962176, 0.17591673914620834],
            [0.6505328379498408, 0.4196847783397048, 0.28401133969888215, 0.17451773837988022],
            [0.6602692617399543, 0.43930131269005246, 0.3172119165825931, 0.24287725448335737, 0.13491831540473032],
            [
                0.6727527102384984,
                0.45392031144991035,
                0.33655638005380517,
                0.2774753798935745,
                0.1905769370006252,
                0.11026408283679064,
            ],
        ],
        "gammas": [
            [0.22325193301538615],
            [0.20325193677087805, 0.8088022053788844],
            [0.18465272799385737, 0.6600915405972455, 0.7189094447541332],
            [0.18012175313628473, 0.6084637851438164, 0.6174063498842721, 0.5796787044700527],
            [0.1728997879644195, 0.5633359672756179, 0.5724088289694428, 0.5144916808131571, 0.5786712595624445],
            [
                0.16749762054427828,
                0.5347503810628107,
                0.5500261575011604,
                0.47994364866884226,
                0.5273182484504514,
                0.6282544233713674,
            ],
        ],
    },
    np.float64(6.328571428571428): {
        "betas": [
            [0.46722892880630024],
            [0.5779731236799994, 0.24086014221769791],
            [0.6131544799233533, 0.2968560415471345, 0.16210717922826579],
            [0.6645748706931789, 0.3916386444447657, 0.26015583551248245, 0.16340195446367706],
            [0.6756823177769085, 0.415927755438699, 0.3012486641324098, 0.2389426196729595, 0.1366657572480932],
            [
                0.6866489318861504,
                0.42615588767014173,
                0.31370437407748303,
                0.26495072211067366,
                0.18745003609129307,
                0.10335528112985974,
            ],
        ],
        "gammas": [
            [0.2101103918689138],
            [0.19992641387412857, 0.8943938839062285],
            [0.18190718673977224, 0.7017129860231973, 0.7634987900778528],
            [0.17819221557610118, 0.6549098133219717, 0.6608483763646171, 0.5964792272687419],
            [0.17166476370284323, 0.5996604462461341, 0.6029532092264551, 0.522395810405631, 0.5620884763173302],
            [
                0.16428205630122897,
                0.5546710253127897,
                0.5797300150367883,
                0.489817425809271,
                0.5106161046540832,
                0.6075472220238425,
            ],
        ],
    },
    np.float64(7.107142857142857): {
        "betas": [
            [0.4998612996583307],
            [0.5938360145750073, 0.21598069506924852],
            [0.6173021966426923, 0.24834088550632555, 0.15487837560842344],
            [0.6452253519296808, 0.2916386444447657, 0.2053243956382006, 0.12621969774950867],
            [0.6985561114510743, 0.3880749053020765, 0.2846534299445725, 0.23247925550036724, 0.14012841284478625],
            [
                0.7256654704657849,
                0.3986308571615185,
                0.3010142393559457,
                0.2567288979467171,
                0.19684901926538176,
                0.1100573274024558,
            ],
        ],
        "gammas": [
            [0.20032785266902747],
            [0.1969787676821108, 0.9943938839062285],
            [0.17619992063389378, 0.7056783172830937, 0.8484756468749124],
            [0.15867670328402766, 0.5549098133219718, 0.7492847183781827, 0.6958049938035548],
            [0.16737055499817746, 0.6168408277407803, 0.6551406586051525, 0.5532270563119052, 0.5632076351118355],
            [
                0.14076447982273071,
                0.4546710253127897,
                0.6103785861546597,
                0.5379368639719503,
                0.5164890977126986,
                0.5821636661241296,
            ],
        ],
    },
    np.float64(7.885714285714285): {
        "betas": [
            [0.5356166557262941],
            [0.6030228144296598, 0.17508341120614312],
            [0.6181792180884472, 0.1924673371138887, 0.14781148913645067],
            [0.6209125358917494, 0.22941324662483437, 0.17317605516979884, 0.11530690939398312],
            [0.7985561114510743, 0.4084026347460778, 0.2711033878874228, 0.20914141421364865, 0.12811557198428145],
            [
                0.8256654704657849,
                0.44675752168575317,
                0.2838890025550187,
                0.22236334341633687,
                0.16958784230830093,
                0.10295645920806554,
            ],
        ],
        "gammas": [
            [0.19311331861451128],
            [0.1926776778183039, 1.0943938839062286],
            [0.17014668567238259, 0.6799102618774718, 0.9484756468749124],
            [0.14880378433510907, 0.4776100245214624, 0.8492847183781826, 0.7958049938035547],
            [0.14903092752926472, 0.5168408277407803, 0.6572032180373222, 0.6069480969012372, 0.6245415919541988],
            [
                0.11841116646647089,
                0.3546710253127897,
                0.5726260361180534,
                0.5912697833589962,
                0.5965150277999162,
                0.6352377148604732,
            ],
        ],
    },
    np.float64(8.664285714285715): {
        "betas": [
            [0.5749339355114155],
            [0.6061945123139716, 0.11206167254855498],
            [0.620054721414618, 0.16710715137972834, 0.1137055451979385],
            [0.6147056267388178, 0.17902989930134236, 0.1007034540610342, 0.10219273510094476],
            [0.8836899221191772, 0.39647688161415795, 0.22129139677018722, 0.15657583793252805, 0.0993531810799287],
            [
                0.9010897623584803,
                0.4280853690341704,
                0.22940201300395602,
                0.1619632159012638,
                0.12364188696706443,
                0.08277662913775562,
            ],
        ],
        "gammas": [
            [0.18802869401830205],
            [0.18125208236854232, 0.9943938839062286],
            [0.15727800453102628, 0.5799102618774719, 1.0484756468749123],
            [0.15005234217388216, 0.5056778415384905, 0.9492847183781826, 0.8958049938035547],
            [0.13303332188620678, 0.41684082774078035, 0.6388718126592837, 0.6910148043697351, 0.7245415919541988],
            [
                0.11209811144223827,
                0.3204085785749226,
                0.5461307437569124,
                0.6507495658393277,
                0.6965150277999161,
                0.730629334503576,
            ],
        ],
    },
    np.float64(9.442857142857143): {
        "betas": [
            [0.6184660385438182],
            [0.6376687397084877, 0.09934228007462978],
            [0.6289635319137641, 0.18179054000958647, 0.0429177197417862],
            [0.6343280448674545, 0.21399751391605007, 0.056553042330546234, 0.02820508101841329],
            [0.8595492088938499, 0.3413953279171477, 0.18120624108873123, 0.11807861778259343, 0.07411010812124981],
            [
                0.8566043027863222,
                0.33542384072497505,
                0.18465682803191194,
                0.12605590507644834,
                0.09274104920707074,
                0.0594193876430459,
            ],
        ],
        "gammas": [
            [0.1848512061827197],
            [0.17331863233077302, 0.8943938839062286],
            [0.14190175976327907, 0.4799102618774719, 0.9645804974494147],
            [0.13041114574322968, 0.4056778415384905, 0.8492847183781826, 0.9832921981054764],
            [0.14252085865546965, 0.4093322235855959, 0.6326200119353184, 0.7488371180403842, 0.823978633047503],
            [
                0.14757569382621566,
                0.40287099428174505,
                0.5857446071838946,
                0.6771688926712888,
                0.7361729969148118,
                0.7728040913930116,
            ],
        ],
    },
    np.float64(10.221428571428572): {
        "betas": [
            [0.6661309903298928],
            [0.6911719581717104, 0.1467269114454198],
            [0.6653970617892121, 0.26123657068518347, 0.07522596894133966],
            [0.6668719589680062, 0.2967833112561744, 0.11717748064643631, 0.06373658985316887],
            [0.7595492088938499, 0.3565349334571236, 0.12836277995085515, 0.05299675253895819, 0.01185270814003573],
            [
                0.7566043027863222,
                0.3608205901877894,
                0.14508438100782717,
                0.08415451270267299,
                0.035784655749598764,
                0.06403373678849766,
            ],
        ],
        "gammas": [
            [0.18330733688295908],
            [0.1639684478187955, 0.7943938839062287],
            [0.12278929185788788, 0.3799102618774719, 0.8645804974494147],
            [0.12114736474092956, 0.35439411402192916, 0.7492847183781827, 1.0832921981054764],
            [0.101433159099717, 0.30933222358559587, 0.6236775016642324, 0.7989058186936466, 0.8333871496622176],
            [
                0.09454159902512714,
                0.302870994281745,
                0.6546235894910443,
                0.7771688926712887,
                0.8361729969148117,
                0.8728040913930116,
            ],
        ],
    },
    np.float64(11.0): {
        "betas": [
            [0.7124661397645641],
            [0.7315533006079079, 0.21514013844847837],
            [0.6909796547758047, 0.2935098649762942, 0.14372253934938825],
            [0.6640491589393624, 0.3006215175570316, 0.1300388193655339, 0.12786269424981073],
            [0.6595492088938499, 0.32558859084219566, 0.14060072935259763, 0.07537986323102751, 0.0994999934519072],
            [
                0.7274618858868772,
                0.3392934971525975,
                0.1445957542780181,
                0.0847007743491614,
                0.031455612377264054,
                0.11629616512526599,
            ],
        ],
        "gammas": [
            [0.18202651198426437],
            [0.15247555568239154, 0.6943938839062287],
            [0.12248635421013733, 0.3980679846911749, 0.9645804974494147],
            [0.10862183643769968, 0.3081384464551468, 0.7096872286875711, 1.1832921981054765],
            [0.0970678402859082, 0.2584426393443658, 0.5674692404638368, 0.878025234668639, 0.9333871496622176],
            [
                0.1013865783433556,
                0.2708445320189553,
                0.5546235894910443,
                0.7857416335081658,
                0.831854395285413,
                0.8661907560254498,
            ],
        ],
    },
}

RESULTS_D99 = {
    0: {
        "betas": [
            [0.39269907577849844],
            [0.49704898432352174, 0.269361976099958],
            [0.5511261023736032, 0.368983713112854, 0.21112428163805297],
            [0.5720817285761584, 0.41934304327010996, 0.30427126509982183, 0.17318177658948722],
            [0.5909470504344296, 0.4509251288916888, 0.3577635092310199, 0.26588812795243333, 0.1488213333515451],
            [
                0.60133957410758,
                0.4687170095071594,
                0.3898721417056226,
                0.3196449700817234,
                0.23401790338564893,
                0.12927922128300992,
            ],
        ],
        "gammas": [
            [0.4983266603509544],
            [0.3805923767291694, 0.6644249524255581],
            [0.3287857696484992, 0.5682995697052741, 0.6405129747351154],
            [0.2940979168514135, 0.5139883330574803, 0.5590332022492934, 0.6432782305778084],
            [0.2697742432131618, 0.4799404704290834, 0.5077374159404012, 0.5654656350285169, 0.6405251907160555],
            [
                0.252112348551788,
                0.4526967853417578,
                0.47524676836281754,
                0.5152419637702114,
                0.5663477463663908,
                0.6404548670910051,
            ],
        ],
    },
    np.float64(0.1): {
        "betas": [
            [0.39263977639408865],
            [0.4948252228692409, 0.2675934366365204],
            [0.5384533459295354, 0.352582811798433, 0.20111524348604978],
            [0.5442500144223004, 0.3745486602947313, 0.2688296157723472, 0.15753817714509122],
            [0.5533485162628938, 0.3821479362768948, 0.28675408947104175, 0.23150168665924514, 0.1422073413833403],
            [
                0.5694588086830402,
                0.39398204890211763,
                0.2898721417056226,
                0.2627194697472444,
                0.2232256705490405,
                0.12905324437121915,
            ],
        ],
        "gammas": [
            [0.4983068935464589],
            [0.38045305456274203, 0.6634584524491386],
            [0.3285127881686002, 0.5643366910619946, 0.6316221713797316],
            [0.2950168369082858, 0.49919000355986765, 0.5296274252763943, 0.6145915673220063],
            [0.2715236231332641, 0.45718402971785793, 0.44529894039036316, 0.49813527991108303, 0.6167684824783028],
            [
                0.2575627854952631,
                0.4354913870705729,
                0.39430813131334363,
                0.4152419637702114,
                0.5212567264297944,
                0.6353081893202109,
            ],
        ],
    },
    np.float64(7.307142857142857): {
        "betas": [
            [0.29263977639408867],
            [0.39482522286924093, 0.1675934366365204],
            [0.43845334592953544, 0.252582811798433, 0.29353714680249177],
            [0.4442500144223004, 0.27454866029473124, 0.3688296157723472, 0.1753271881190926],
            [0.45334851626289385, 0.28214793627689483, 0.3774274592854078, 0.2728522844567147, 0.14971242591428477],
            [
                0.46945880868304024,
                0.29398204890211765,
                0.3366652567797117,
                0.3160865558357137,
                0.2412090951516702,
                0.13383904179642678,
            ],
        ],
        "gammas": [
            [0.3983068935464589],
            [0.28045305456274205, 0.5634584524491386],
            [0.22851278816860018, 0.4643366910619946, 0.5316221713797317],
            [0.2507394486321914, 0.39919000355986767, 0.4296274252763943, 0.7145915673220062],
            [0.23047128910057663, 0.3571840297178579, 0.34529894039036313, 0.5981352799110831, 0.6762646484776615],
            [
                0.15756278549526312,
                0.3354913870705729,
                0.29430813131334366,
                0.48376518635055454,
                0.5691228731011181,
                0.6581475796909272,
            ],
        ],
    },
    np.float64(14.514285714285714): {
        "betas": [
            [0.19263977639408866],
            [0.29482522286924095, 0.20450048562665885],
            [0.33845334592953547, 0.29047532747339766, 0.21962567698185634],
            [0.3442500144223004, 0.3077166866480123, 0.30527605711541067, 0.20117595068250183],
            [0.3533485162628939, 0.22230958368702944, 0.2774274592854078, 0.3728522844567147, 0.08629363138098109],
            [
                0.3774906222422438,
                0.39398204890211763,
                0.39961812184996254,
                0.3493145014031966,
                0.2591559185771718,
                0.14585160069372197,
            ],
        ],
        "gammas": [
            [0.2983068935464589],
            [0.18045305456274205, 0.46345845244913864],
            [0.12851278816860018, 0.3643366910619946, 0.4856716735200194],
            [0.15073944863219138, 0.2991900035598677, 0.399178581612194, 0.6423712609882585],
            [0.33047128910057666, 0.2571840297178579, 0.3532733891558354, 0.5103839219813412, 0.6699137528807888],
            [
                0.10576005044052622,
                0.2354913870705729,
                0.39430804653424795,
                0.5012324549237247,
                0.5623115559182408,
                0.6479903570609071,
            ],
        ],
    },
    np.float64(21.721428571428575): {
        "betas": [
            [0.1773234517366022],
            [0.29917379584250947, 0.3045004856266589],
            [0.34845398049816484, 0.3894211926699834, 0.24035094571323481],
            [0.34747475361634095, 0.4077166866480123, 0.3294226157344235, 0.20379628684977616],
            [0.3278510992644549, 0.32230958368702944, 0.1774274592854078, 0.3531283604044305, 0.1862936313809811],
            [
                0.4096619844044748,
                0.48559096807160146,
                0.4171705924665766,
                0.33784845203297803,
                0.25014774120436994,
                0.14064664636966212,
            ],
        ],
        "gammas": [
            [0.1983068935464589],
            [0.11019310533220952, 0.48755378831853025],
            [0.09641246495283422, 0.3779660866916573, 0.5856716735200194],
            [0.10436305247707892, 0.3032380186330657, 0.499178581612194, 0.6350236494539065],
            [0.23047128910057665, 0.2195487246245332, 0.2532733891558354, 0.4103839219813412, 0.6958871322196974],
            [
                0.07947875435454278,
                0.28681154168717726,
                0.47038174251341036,
                0.5133502700261219,
                0.5701452224685735,
                0.6444177236993325,
            ],
        ],
    },
    np.float64(28.92857142857143): {
        "betas": [
            [0.2773234517366022],
            [0.35913655684099616, 0.3250670383048343],
            [0.40003739013910306, 0.40478007758808904, 0.24059999527007084],
            [0.4167308541545291, 0.44954593772555795, 0.3320837392223725, 0.1941565659552747],
            [0.35290460925679645, 0.42201202437009766, 0.2774274592854078, 0.2930499438748297, 0.17043265041077685],
            [
                0.4192413896146701,
                0.4737019881323511,
                0.4108912957040332,
                0.3303701280755937,
                0.24897349616101144,
                0.14338481774716508,
            ],
        ],
        "gammas": [
            [0.10884833921395393],
            [0.08741007234039452, 0.5256745229541866],
            [0.08008375656753146, 0.4163401490227461, 0.6468677911782081],
            [0.07685102994448478, 0.36008425809333305, 0.5601466920522432, 0.6462729470176131],
            [0.13047128910057665, 0.2853853963099898, 0.3532733891558354, 0.5074628738230793, 0.6505825831330432],
            [
                0.07919596661853733,
                0.29432047834306924,
                0.47447497360565405,
                0.5162668877569868,
                0.5681661768648855,
                0.6422520500277668,
            ],
        ],
    },
    np.float64(36.135714285714286): {
        "betas": [
            [0.3143875829814654],
            [0.39998947881977154, 0.317037496019857],
            [0.43858570878180425, 0.39249569639579446, 0.23392562803826372],
            [0.4534746480042659, 0.4360552391648014, 0.32126791359304663, 0.18903638429717176],
            [0.45290460925679643, 0.4270928915439349, 0.35594511560057357, 0.27950648533317257, 0.1619640582755441],
            [
                0.4566251943355529,
                0.4535758192667408,
                0.3884082594054951,
                0.3158684855121705,
                0.23441153081265378,
                0.1331875245746799,
            ],
        ],
        "gammas": [
            [0.09576898505610003],
            [0.07906599141127799, 0.5512957506831024],
            [0.07391032832395247, 0.4403886763854994, 0.6439044017887159],
            [0.07138143948951287, 0.38047540173942074, 0.561758698769556, 0.6503411802916664],
            [0.07477150755438688, 0.3320957991485969, 0.45327338915583537, 0.5674023306996047, 0.6444709710649086],
            [
                0.07319285708146409,
                0.315562857287929,
                0.46699487276311674,
                0.5256866809838323,
                0.5689873392876376,
                0.6519152987443925,
            ],
        ],
    },
    np.float64(43.34285714285715): {
        "betas": [
            [0.3488051984021024],
            [0.43809516473353505, 0.3055921939167233],
            [0.47542272659146045, 0.3768073813803693, 0.22630627872014755],
            [0.48513377244676636, 0.41766357036935037, 0.3087236029846437, 0.18268164196152994],
            [0.5071099882757442, 0.4371846155585358, 0.34939503073161654, 0.2634436133157413, 0.15261407642131608],
            [
                0.5117088165388374,
                0.4427015714967118,
                0.3723902283215204,
                0.3021012942470355,
                0.22731741878931286,
                0.1311091912508963,
            ],
        ],
        "gammas": [
            [0.08767285116265498],
            [0.07354006664624772, 0.5795084244191185],
            [0.06971422444927336, 0.46908392619805844, 0.63936796588339],
            [0.06818234947565985, 0.40403364142658216, 0.5648273224309821, 0.6579975069014096],
            [0.06557120641277372, 0.3705806897770495, 0.5065227580368724, 0.5856712717233131, 0.6576799703592066],
            [
                0.06563802643956552,
                0.34351041317009423,
                0.4659896036199218,
                0.5338028010200907,
                0.5731622204281077,
                0.6550045602894236,
            ],
        ],
    },
    np.float64(50.550000000000004): {
        "betas": [
            [0.38386847582528943],
            [0.4744587711287043, 0.29094960678145726],
            [0.5122051831490451, 0.35926123084520994, 0.21816087996732078],
            [0.5216670124108383, 0.3965365112653853, 0.2935240140481561, 0.17366966485213078],
            [0.542442177280542, 0.41900836094771315, 0.3333601309229356, 0.25262453022393144, 0.14613844083984917],
            [
                0.5497235734222002,
                0.4254081759821226,
                0.3582218798494384,
                0.28986803345761214,
                0.2192588293095625,
                0.12547040061300718,
            ],
        ],
        "gammas": [
            [0.0817874829522904],
            [0.06973004108250176, 0.6135323246317484],
            [0.06669100918971163, 0.5064708565898143, 0.6330452993614294],
            [0.06515435514937304, 0.4354522607014648, 0.572246835132189, 0.6651357621996822],
            [0.0629895338429971, 0.40039319381346256, 0.5125270023358718, 0.6002780810707928, 0.6689567607063349],
            [
                0.06268345244045012,
                0.37469802315488054,
                0.4707642553167252,
                0.5551926902857711,
                0.5815644926611574,
                0.6693333798467574,
            ],
        ],
    },
    np.float64(57.75714285714286): {
        "betas": [
            [0.419939254411505],
            [0.5098257185465974, 0.27309186104169714],
            [0.5503187245477663, 0.3416748493596455, 0.21056444598826188],
            [0.5563907976919136, 0.3710559966477631, 0.27642725782443234, 0.16383335650186348],
            [0.578830633355931, 0.39840504900585577, 0.3142348525030197, 0.2381111849406803, 0.13773564081522038],
            [
                0.5870300707987742,
                0.40634841833049556,
                0.34074546425658997,
                0.2760013776284749,
                0.20993895509014734,
                0.12208100468885939,
            ],
        ],
        "gammas": [
            [0.0773694424960173],
            [0.06710614220073849, 0.6573608802578453],
            [0.06444652712021957, 0.5564921639125482, 0.6258660832870633],
            [0.06329228079153859, 0.47587697614570645, 0.5822001545807717, 0.6677992515541266],
            [0.061055346619785386, 0.4383827754840783, 0.5275308930860214, 0.6164564474508577, 0.6941138328899031],
            [
                0.06083013788554278,
                0.4058919930571059,
                0.4774964074653188,
                0.5795795572873393,
                0.5921190011621443,
                0.6825207135593616,
            ],
        ],
    },
    np.float64(64.96428571428571): {
        "betas": [
            [0.457581091528274],
            [0.5447928745236779, 0.2518025828087634],
            [0.5909273166731673, 0.32590012490393694, 0.2039336097851704],
            [0.5899448894229287, 0.3424132892034876, 0.25877842344824586, 0.1531066499364504],
            [0.6100566850914404, 0.3699658642716484, 0.2849889293854239, 0.2134766409374939, 0.12463739133554096],
            [
                0.6264547308183614,
                0.38823613793965805,
                0.31789454588681215,
                0.25414505000128174,
                0.1993048713489511,
                0.11677938872881341,
            ],
        ],
        "gammas": [
            [0.07402710748603547],
            [0.06540836525161653, 0.7173685371495302],
            [0.06275673842700237, 0.623552934270035, 0.6229190206932498],
            [0.06226746055747379, 0.5339347870091614, 0.6021854132515891, 0.6719315712056183],
            [0.060107646485676416, 0.49082546071228983, 0.5700812581985555, 0.6023097194647261, 0.7344166581301949],
            [
                0.05927983029872795,
                0.464875767915193,
                0.49716229590149646,
                0.6028809535544845,
                0.6185940807153975,
                0.687265308920571,
            ],
        ],
    },
    np.float64(72.17142857142856): {
        "betas": [
            [0.49762722063045095],
            [0.5800425618053279, 0.22653440996330232],
            [0.6337321632913596, 0.3110849128578759, 0.19647933787713331],
            [0.620258821603403, 0.3084937499132245, 0.24154280735046169, 0.14357001235233766],
            [0.6375303314339612, 0.33007568401282705, 0.2563228992858043, 0.19404602614325947, 0.11261823206360728],
            [
                0.6652194399436583,
                0.3586801013634808,
                0.28287533438827195,
                0.22825884160696858,
                0.17837237546566878,
                0.10317280468031895,
            ],
        ],
        "gammas": [
            [0.07155742323500575],
            [0.06452871606922973, 0.8055349942945089],
            [0.06165393420438491, 0.7121952593756229, 0.6361880685594605],
            [0.06239503734476344, 0.6201698825879058, 0.6258775839859302, 0.6666407797238746],
            [0.06032403593251101, 0.5644346647579903, 0.6168889247072438, 0.5834502668324882, 0.7632220789352655],
            [
                0.0584133063966126,
                0.5219125508010518,
                0.5604419498258154,
                0.5961828188929216,
                0.6761303323729986,
                0.7455010972756365,
            ],
        ],
    },
    np.float64(79.37857142857142): {
        "betas": [
            [0.5414348768869418],
            [0.6198615297569369, 0.1994551072537649],
            [0.6787667340869832, 0.28997815267524796, 0.17997510019691432],
            [0.664213573200612, 0.27807882367446407, 0.22579127252169856, 0.13667553873265006],
            [0.6685466773368044, 0.2865301309036673, 0.23074745724257728, 0.18170730814856773, 0.10214232539065159],
            [
                0.6849169857885207,
                0.3056144947581335,
                0.23965782126182586,
                0.19914605148968398,
                0.14740806823958863,
                0.08473043511125149,
            ],
        ],
        "gammas": [
            [0.06989036210898864],
            [0.06417258923640404, 0.9055349942945089],
            [0.06119835948688394, 0.8121952593756229, 0.703803510743424],
            [0.0621634841989267, 0.7201698825879058, 0.673306187742905, 0.693817628429847],
            [0.061147063746568975, 0.6644346647579903, 0.6833211731745366, 0.5927209680187677, 0.7735246803436978],
            [
                0.05972682361680934,
                0.6219125508010518,
                0.6603072037999018,
                0.5737745048373477,
                0.6988701086925415,
                0.8429699322783057,
            ],
        ],
    },
    np.float64(86.58571428571429): {
        "betas": [
            [0.5915965919594469],
            [0.6707826168017158, 0.17036241669907107],
            [0.744531407822664, 0.2642591045867013, 0.15780093375517953],
            [0.732899714353588, 0.2502583073980567, 0.20179806832448724, 0.12451658071915166],
            [0.7210650537315223, 0.2406309116880291, 0.20389997820533443, 0.1730767037863707, 0.09744411731729348],
            [
                0.7319148077675914,
                0.2514709374890127,
                0.19763356613545646,
                0.18054685718235983,
                0.13343245166703288,
                0.07412707116714323,
            ],
        ],
        "gammas": [
            [0.06911498726863155],
            [0.06400271468836703, 1.0055349942945089],
            [0.06121207817943356, 0.9121952593756228, 0.8038035107434239],
            [0.06160630273337939, 0.8201698825879058, 0.7676412733461827, 0.7836412394454905],
            [0.06167725014892227, 0.7644346647579903, 0.7833211731745365, 0.6356664702731575, 0.7964677270804016],
            [
                0.06067402197188281,
                0.7219125508010518,
                0.7603072037999018,
                0.6068479474574988,
                0.6967543119562638,
                0.9061406611601993,
            ],
        ],
    },
    np.float64(93.79285714285714): {
        "betas": [
            [0.6548586285743839],
            [0.7297688844990997, 0.12664991566397288],
            [0.844531407822664, 0.25665822295912055, 0.13933562743850317],
            [0.832899714353588, 0.2513169087799761, 0.18813019416827226, 0.10898305615168723],
            [0.8210650537315223, 0.21547131707738346, 0.18004135210559222, 0.14193893575639224, 0.08316069642654153],
            [
                0.8319148077675914,
                0.21581036939588408,
                0.16648411503123797,
                0.1460083296862857,
                0.114891264088854,
                0.06501329119109855,
            ],
        ],
        "gammas": [
            [0.06972125503429875],
            [0.06425281826643738, 1.105534994294509],
            [0.06188531612639614, 0.8121952593756229, 0.9038035107434239],
            [0.06285462907313481, 0.8130383877393051, 0.7358451049660475, 0.8836412394454904],
            [0.06301544347354457, 0.8644346647579902, 0.8213822153319881, 0.7356664702731575, 0.8964677270804016],
            [
                0.0617224436999596,
                0.7981628689448406,
                0.8439182908573061,
                0.7068479474574988,
                0.7878550809126916,
                1.0061406611601993,
            ],
        ],
    },
    np.float64(101.0): {
        "betas": [
            [0.7548586285743839],
            [0.7496708614715476, 0.1092197584728762],
            [0.744531407822664, 0.15896711197090035, 0.09132160370617846],
            [0.8726958924909669, 0.2921544371776281, 0.20384035777320372, 0.13087297381802868],
            [0.8317483229434639, 0.2511924942740555, 0.22800621828822853, 0.1990111756447336, 0.12674639032862092],
            [
                0.8188463301478063,
                0.22840483622545463,
                0.21318949887361466,
                0.1991828068234782,
                0.13399382895433495,
                0.09009425781000469,
            ],
        ],
        "gammas": [
            [0.07456915335553582],
            [0.0652616719076063, 1.096749650347276],
            [0.05951495489706435, 0.7121952593756229, 1.003803510743424],
            [0.06266938303733485, 0.7130383877393052, 0.7410846871104745, 0.9836412394454904],
            [0.06459293159667202, 0.7644346647579903, 0.7407800741439395, 0.6356664702731575, 0.9964677270804015],
            [
                0.06449419076010372,
                0.6981628689448406,
                0.7439182908573061,
                0.6068479474574988,
                0.6878550809126917,
                1.1061406611601994,
            ],
        ],
    },
}
