#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['imxInsights',
 'imxInsights.diff',
 'imxInsights.domain',
 'imxInsights.domain.area',
 'imxInsights.domain.models',
 'imxInsights.graph',
 'imxInsights.graph.queries',
 'imxInsights.repo',
 'imxInsights.repo.tree',
 'imxInsights.report',
 'imxInsights.utils']

package_data = \
{'': ['*']}

install_requires = \
['loguru',
 'ruamel.yaml',
 'lxml',
 'shapely',
 'shapelyM',
 'pyproj',
 'dateparser',
 'pandas',
 'xlsxwriter',
 'Jinja2',
 'networkx',
 'matplotlib',
 'nest-asyncio',
 'arcGisFeatureCash',
 'nest_asyncio']

extras_require = \
{'dev': ['black[jupyter]',
         'bumpversion',
         'flake8-black',
         'flake8-docstrings',
         'flake8',
         'isort',
         'mypy',
         'pre-commit',
         'pytest',
         'pytest-cov',
         'pytest-mock',
         'markdown-include',
         'mike',
         'mkdocs',
         'mkdocs-jupyter',
         'mkdocs-material',
         'mkdocs-mermaid2-plugin',
         'mkdocstrings[crystal, python]>=0.18',
         'pymdown-extensions',
         'python-dotenv',
         'cryptography',
         'matplotlib'],
 'jupyter': ['jupyterlab', 'pygwalker']}

setup(name='imxInsights',
      version='0.1.0.dev1',
      description='python imx insights module to get information from imx files',
      author=None,
      author_email='Hzd <Hazedd@users.noreply.github.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='~=3.10',
     )
