# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

import datetime
import sys

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
from pathlib import Path

sys.path.insert(0, str(Path(__file__).parent.parent.resolve()))

# -- Project information -----------------------------------------------------

project = "pybotters"
copyright = f"2021-{datetime.date.today().year}, MtkN1"
author = "MtkN1"


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx_copybutton",
    "sphinx_new_tab_link",
    "sphinx.ext.napoleon",
    "sphinx.ext.intersphinx",
    "sphinx_llms_txt",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "ja"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store", ".venv"]

intersphinx_mapping = {
    "python": ("https://docs.python.org/3/", None),
    "sphinx": ("https://www.sphinx-doc.org/en/master/", None),
    "aiohttp": ("https://docs.aiohttp.org/en/stable/", None),
}
intersphinx_disabled_domains = ["std"]

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"
html_logo = "logo_150.png"
html_favicon = "favicon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

source_suffix = [".rst"]

autoclass_content = "both"

templates_path = ["_templates"]

html_title = "pybotters Docs"

html_baseurl = "https://pybotters.readthedocs.io/ja/stable/"

# -- Options llms.txt --------------------------------------------------------

llms_txt_summary = """`pybotters` is a Python library for crypto bot traders.
This library is an **HTTP and WebSocket API client**.
It has the following features, making it useful for developing a trading bot.

Please note: The links below are in HTML format due to the documentation builder's
requirements. However, you can access the original source files (reStructuredText)
directly.
For example, for `https://pybotters.readthedocs.io/ja/stable/index.html`, you can access
the source at `https://pybotters.readthedocs.io/ja/stable/_sources/index.rst.txt`. For
LLMs, using the source files is generally more efficient than parsing HTML."""
