# zrok
zrok client access

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import zrok_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import zrok_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import zrok_api
from zrok_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to /api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = zrok_api.Configuration(
    host = "/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: key
configuration.api_key['key'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['key'] = 'Bearer'


# Enter a context with an instance of the API client
with zrok_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = zrok_api.AccountApi(api_client)
    body = zrok_api.ChangePasswordRequest() # ChangePasswordRequest |  (optional)

    try:
        api_instance.change_password(body=body)
    except ApiException as e:
        print("Exception when calling AccountApi->change_password: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to */api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**change_password**](docs/AccountApi.md#change_password) | **POST** /changePassword | 
*AccountApi* | [**invite**](docs/AccountApi.md#invite) | **POST** /invite | 
*AccountApi* | [**login**](docs/AccountApi.md#login) | **POST** /login | 
*AccountApi* | [**regenerate_account_token**](docs/AccountApi.md#regenerate_account_token) | **POST** /regenerateAccountToken | 
*AccountApi* | [**register**](docs/AccountApi.md#register) | **POST** /register | 
*AccountApi* | [**reset_password**](docs/AccountApi.md#reset_password) | **POST** /resetPassword | 
*AccountApi* | [**reset_password_request**](docs/AccountApi.md#reset_password_request) | **POST** /resetPasswordRequest | 
*AccountApi* | [**verify**](docs/AccountApi.md#verify) | **POST** /verify | 
*AdminApi* | [**add_frontend_grant**](docs/AdminApi.md#add_frontend_grant) | **POST** /frontend/grant | 
*AdminApi* | [**add_organization_member**](docs/AdminApi.md#add_organization_member) | **POST** /organization/add | 
*AdminApi* | [**create_account**](docs/AdminApi.md#create_account) | **POST** /account | 
*AdminApi* | [**create_frontend**](docs/AdminApi.md#create_frontend) | **POST** /frontend | 
*AdminApi* | [**create_identity**](docs/AdminApi.md#create_identity) | **POST** /identity | 
*AdminApi* | [**create_organization**](docs/AdminApi.md#create_organization) | **POST** /organization | 
*AdminApi* | [**delete_account**](docs/AdminApi.md#delete_account) | **DELETE** /account | 
*AdminApi* | [**delete_frontend**](docs/AdminApi.md#delete_frontend) | **DELETE** /frontend | 
*AdminApi* | [**delete_frontend_grant**](docs/AdminApi.md#delete_frontend_grant) | **DELETE** /frontend/grant | 
*AdminApi* | [**delete_identity**](docs/AdminApi.md#delete_identity) | **DELETE** /identity | 
*AdminApi* | [**delete_organization**](docs/AdminApi.md#delete_organization) | **DELETE** /organization | 
*AdminApi* | [**grants**](docs/AdminApi.md#grants) | **POST** /grants | 
*AdminApi* | [**invite_token_generate**](docs/AdminApi.md#invite_token_generate) | **POST** /invite/token/generate | 
*AdminApi* | [**list_frontends**](docs/AdminApi.md#list_frontends) | **GET** /frontends | 
*AdminApi* | [**list_organization_members**](docs/AdminApi.md#list_organization_members) | **POST** /organization/list | 
*AdminApi* | [**list_organizations**](docs/AdminApi.md#list_organizations) | **GET** /organizations | 
*AdminApi* | [**remove_organization_member**](docs/AdminApi.md#remove_organization_member) | **POST** /organization/remove | 
*AdminApi* | [**update_frontend**](docs/AdminApi.md#update_frontend) | **PATCH** /frontend | 
*AgentApi* | [**enroll**](docs/AgentApi.md#enroll) | **POST** /agent/enroll | 
*AgentApi* | [**ping**](docs/AgentApi.md#ping) | **POST** /agent/ping | 
*AgentApi* | [**remote_access**](docs/AgentApi.md#remote_access) | **POST** /agent/access | 
*AgentApi* | [**remote_share**](docs/AgentApi.md#remote_share) | **POST** /agent/share | 
*AgentApi* | [**remote_status**](docs/AgentApi.md#remote_status) | **POST** /agent/status | 
*AgentApi* | [**remote_unaccess**](docs/AgentApi.md#remote_unaccess) | **POST** /agent/unaccess | 
*AgentApi* | [**remote_unshare**](docs/AgentApi.md#remote_unshare) | **POST** /agent/unshare | 
*AgentApi* | [**share_http_healthcheck**](docs/AgentApi.md#share_http_healthcheck) | **POST** /agent/share/http-healthcheck | 
*AgentApi* | [**unenroll**](docs/AgentApi.md#unenroll) | **POST** /agent/unenroll | 
*EnvironmentApi* | [**disable**](docs/EnvironmentApi.md#disable) | **POST** /disable | 
*EnvironmentApi* | [**enable**](docs/EnvironmentApi.md#enable) | **POST** /enable | 
*MetadataApi* | [**client_version_check**](docs/MetadataApi.md#client_version_check) | **POST** /clientVersionCheck | 
*MetadataApi* | [**configuration**](docs/MetadataApi.md#configuration) | **GET** /configuration | 
*MetadataApi* | [**get_account_detail**](docs/MetadataApi.md#get_account_detail) | **GET** /detail/account | 
*MetadataApi* | [**get_account_metrics**](docs/MetadataApi.md#get_account_metrics) | **GET** /metrics/account | 
*MetadataApi* | [**get_environment_detail**](docs/MetadataApi.md#get_environment_detail) | **GET** /detail/environment/{envZId} | 
*MetadataApi* | [**get_environment_metrics**](docs/MetadataApi.md#get_environment_metrics) | **GET** /metrics/environment/{envId} | 
*MetadataApi* | [**get_frontend_detail**](docs/MetadataApi.md#get_frontend_detail) | **GET** /detail/frontend/{frontendId} | 
*MetadataApi* | [**get_share_detail**](docs/MetadataApi.md#get_share_detail) | **GET** /detail/share/{shareToken} | 
*MetadataApi* | [**get_share_metrics**](docs/MetadataApi.md#get_share_metrics) | **GET** /metrics/share/{shareToken} | 
*MetadataApi* | [**get_sparklines**](docs/MetadataApi.md#get_sparklines) | **POST** /sparklines | 
*MetadataApi* | [**list_memberships**](docs/MetadataApi.md#list_memberships) | **GET** /memberships | 
*MetadataApi* | [**list_org_members**](docs/MetadataApi.md#list_org_members) | **GET** /members/{organizationToken} | 
*MetadataApi* | [**list_public_frontends_for_account**](docs/MetadataApi.md#list_public_frontends_for_account) | **GET** /overview/public-frontends | 
*MetadataApi* | [**org_account_overview**](docs/MetadataApi.md#org_account_overview) | **GET** /overview/{organizationToken}/{accountEmail} | 
*MetadataApi* | [**overview**](docs/MetadataApi.md#overview) | **GET** /overview | 
*MetadataApi* | [**version**](docs/MetadataApi.md#version) | **GET** /version | 
*MetadataApi* | [**version_inventory**](docs/MetadataApi.md#version_inventory) | **GET** /versions | 
*ShareApi* | [**access**](docs/ShareApi.md#access) | **POST** /access | 
*ShareApi* | [**share**](docs/ShareApi.md#share) | **POST** /share | 
*ShareApi* | [**unaccess**](docs/ShareApi.md#unaccess) | **DELETE** /unaccess | 
*ShareApi* | [**unshare**](docs/ShareApi.md#unshare) | **DELETE** /unshare | 
*ShareApi* | [**update_access**](docs/ShareApi.md#update_access) | **PATCH** /access | 
*ShareApi* | [**update_share**](docs/ShareApi.md#update_share) | **PATCH** /share | 


## Documentation For Models

 - [Access201Response](docs/Access201Response.md)
 - [AccessRequest](docs/AccessRequest.md)
 - [AddFrontendGrantRequest](docs/AddFrontendGrantRequest.md)
 - [AddOrganizationMemberRequest](docs/AddOrganizationMemberRequest.md)
 - [AuthUser](docs/AuthUser.md)
 - [ChangePasswordRequest](docs/ChangePasswordRequest.md)
 - [ClientVersionCheckRequest](docs/ClientVersionCheckRequest.md)
 - [Configuration](docs/Configuration.md)
 - [CreateFrontend201Response](docs/CreateFrontend201Response.md)
 - [CreateFrontendRequest](docs/CreateFrontendRequest.md)
 - [CreateIdentity201Response](docs/CreateIdentity201Response.md)
 - [CreateIdentityRequest](docs/CreateIdentityRequest.md)
 - [CreateOrganization201Response](docs/CreateOrganization201Response.md)
 - [CreateOrganizationRequest](docs/CreateOrganizationRequest.md)
 - [DeleteIdentityRequest](docs/DeleteIdentityRequest.md)
 - [DisableRequest](docs/DisableRequest.md)
 - [EnableRequest](docs/EnableRequest.md)
 - [Enroll200Response](docs/Enroll200Response.md)
 - [EnrollRequest](docs/EnrollRequest.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentAndResources](docs/EnvironmentAndResources.md)
 - [Frontend](docs/Frontend.md)
 - [GetSparklines200Response](docs/GetSparklines200Response.md)
 - [GetSparklinesRequest](docs/GetSparklinesRequest.md)
 - [InviteRequest](docs/InviteRequest.md)
 - [InviteTokenGenerateRequest](docs/InviteTokenGenerateRequest.md)
 - [ListFrontends200ResponseInner](docs/ListFrontends200ResponseInner.md)
 - [ListMemberships200Response](docs/ListMemberships200Response.md)
 - [ListMemberships200ResponseMembershipsInner](docs/ListMemberships200ResponseMembershipsInner.md)
 - [ListOrganizationMembers200Response](docs/ListOrganizationMembers200Response.md)
 - [ListOrganizationMembers200ResponseMembersInner](docs/ListOrganizationMembers200ResponseMembersInner.md)
 - [ListOrganizations200Response](docs/ListOrganizations200Response.md)
 - [ListOrganizations200ResponseOrganizationsInner](docs/ListOrganizations200ResponseOrganizationsInner.md)
 - [ListPublicFrontendsForAccount200Response](docs/ListPublicFrontendsForAccount200Response.md)
 - [ListPublicFrontendsForAccount200ResponsePublicFrontendsInner](docs/ListPublicFrontendsForAccount200ResponsePublicFrontendsInner.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [Metrics](docs/Metrics.md)
 - [MetricsSample](docs/MetricsSample.md)
 - [Overview](docs/Overview.md)
 - [Ping200Response](docs/Ping200Response.md)
 - [Principal](docs/Principal.md)
 - [RegenerateAccountToken200Response](docs/RegenerateAccountToken200Response.md)
 - [RegenerateAccountTokenRequest](docs/RegenerateAccountTokenRequest.md)
 - [RegisterRequest](docs/RegisterRequest.md)
 - [RemoteAccessRequest](docs/RemoteAccessRequest.md)
 - [RemoteShare200Response](docs/RemoteShare200Response.md)
 - [RemoteShareRequest](docs/RemoteShareRequest.md)
 - [RemoteStatus200Response](docs/RemoteStatus200Response.md)
 - [RemoteStatus200ResponseAccessesInner](docs/RemoteStatus200ResponseAccessesInner.md)
 - [RemoteStatus200ResponseSharesInner](docs/RemoteStatus200ResponseSharesInner.md)
 - [RemoteUnaccessRequest](docs/RemoteUnaccessRequest.md)
 - [RemoteUnshareRequest](docs/RemoteUnshareRequest.md)
 - [RemoveOrganizationMemberRequest](docs/RemoveOrganizationMemberRequest.md)
 - [ResetPasswordRequest](docs/ResetPasswordRequest.md)
 - [Share](docs/Share.md)
 - [ShareHttpHealthcheck200Response](docs/ShareHttpHealthcheck200Response.md)
 - [ShareHttpHealthcheckRequest](docs/ShareHttpHealthcheckRequest.md)
 - [ShareRequest](docs/ShareRequest.md)
 - [ShareResponse](docs/ShareResponse.md)
 - [SparkDataSample](docs/SparkDataSample.md)
 - [UnaccessRequest](docs/UnaccessRequest.md)
 - [UnshareRequest](docs/UnshareRequest.md)
 - [UpdateAccessRequest](docs/UpdateAccessRequest.md)
 - [UpdateFrontendRequest](docs/UpdateFrontendRequest.md)
 - [UpdateShareRequest](docs/UpdateShareRequest.md)
 - [Verify200Response](docs/Verify200Response.md)
 - [VerifyRequest](docs/VerifyRequest.md)
 - [VersionInventory200Response](docs/VersionInventory200Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="key"></a>
### key

- **Type**: API key
- **API key parameter name**: x-token
- **Location**: HTTP header


## Author




