# coding: utf-8

"""
    zrok

    zrok client access

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RemoteShareRequest(BaseModel):
    """
    RemoteShareRequest
    """ # noqa: E501
    env_zid: Optional[StrictStr] = Field(default=None, alias="envZId")
    share_mode: Optional[StrictStr] = Field(default=None, alias="shareMode")
    token: Optional[StrictStr] = None
    target: Optional[StrictStr] = None
    basic_auth: Optional[List[StrictStr]] = Field(default=None, alias="basicAuth")
    frontend_selection: Optional[List[StrictStr]] = Field(default=None, alias="frontendSelection")
    backend_mode: Optional[StrictStr] = Field(default=None, alias="backendMode")
    insecure: Optional[StrictBool] = None
    oauth_provider: Optional[StrictStr] = Field(default=None, alias="oauthProvider")
    oauth_email_address_patterns: Optional[List[StrictStr]] = Field(default=None, alias="oauthEmailAddressPatterns")
    oauth_check_interval: Optional[StrictStr] = Field(default=None, alias="oauthCheckInterval")
    open: Optional[StrictBool] = None
    access_grants: Optional[List[StrictStr]] = Field(default=None, alias="accessGrants")
    __properties: ClassVar[List[str]] = ["envZId", "shareMode", "token", "target", "basicAuth", "frontendSelection", "backendMode", "insecure", "oauthProvider", "oauthEmailAddressPatterns", "oauthCheckInterval", "open", "accessGrants"]

    @field_validator('share_mode')
    def share_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private', 'reserved']):
            raise ValueError("must be one of enum values ('public', 'private', 'reserved')")
        return value

    @field_validator('backend_mode')
    def backend_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['proxy', 'web', 'tcpTunnel', 'udpTunnel', 'caddy', 'drive', 'socks', 'vpn']):
            raise ValueError("must be one of enum values ('proxy', 'web', 'tcpTunnel', 'udpTunnel', 'caddy', 'drive', 'socks', 'vpn')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RemoteShareRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RemoteShareRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "envZId": obj.get("envZId"),
            "shareMode": obj.get("shareMode"),
            "token": obj.get("token"),
            "target": obj.get("target"),
            "basicAuth": obj.get("basicAuth"),
            "frontendSelection": obj.get("frontendSelection"),
            "backendMode": obj.get("backendMode"),
            "insecure": obj.get("insecure"),
            "oauthProvider": obj.get("oauthProvider"),
            "oauthEmailAddressPatterns": obj.get("oauthEmailAddressPatterns"),
            "oauthCheckInterval": obj.get("oauthCheckInterval"),
            "open": obj.get("open"),
            "accessGrants": obj.get("accessGrants")
        })
        return _obj


