window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"muutils": {"fullname": "muutils", "modulename": "muutils", "kind": "module", "doc": "<p><a href=\"https://pypi.org/project/muutils/\"><img src=\"https://img.shields.io/pypi/v/muutils\" alt=\"PyPI\" /></a>\n<img src=\"https://img.shields.io/pypi/dm/muutils\" alt=\"PyPI - Downloads\" />\n<a href=\"https://miv.name/muutils\"><img src=\"https://img.shields.io/badge/docs-latest-blue\" alt=\"docs\" /></a></p>\n\n<p><a href=\"https://github.com/mivanit/muutils/actions/workflows/checks.yml\"><img src=\"https://github.com/mivanit/muutils/actions/workflows/checks.yml/badge.svg\" alt=\"Checks\" /></a>\n<a href=\"https://github.com/mivanit/muutils/actions/workflows/make-docs.yml\"><img src=\"https://github.com/mivanit/muutils/actions/workflows/make-docs.yml/badge.svg\" alt=\"Checks\" /></a>\n<a href=\"docs/coverage/html/\"><img src=\"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSI5OSIgaGVpZ2h0PSIyMCI+CiAgICA8bGluZWFyR3JhZGllbnQgaWQ9ImIiIHgyPSIwIiB5Mj0iMTAwJSI+CiAgICAgICAgPHN0b3Agb2Zmc2V0PSIwIiBzdG9wLWNvbG9yPSIjYmJiIiBzdG9wLW9wYWNpdHk9Ii4xIi8+CiAgICAgICAgPHN0b3Agb2Zmc2V0PSIxIiBzdG9wLW9wYWNpdHk9Ii4xIi8+CiAgICA8L2xpbmVhckdyYWRpZW50PgogICAgPG1hc2sgaWQ9ImEiPgogICAgICAgIDxyZWN0IHdpZHRoPSI5OSIgaGVpZ2h0PSIyMCIgcng9IjMiIGZpbGw9IiNmZmYiLz4KICAgIDwvbWFzaz4KICAgIDxnIG1hc2s9InVybCgjYSkiPgogICAgICAgIDxwYXRoIGZpbGw9IiM1NTUiIGQ9Ik0wIDBoNjN2MjBIMHoiLz4KICAgICAgICA8cGF0aCBmaWxsPSIjYTRhNjFkIiBkPSJNNjMgMGgzNnYyMEg2M3oiLz4KICAgICAgICA8cGF0aCBmaWxsPSJ1cmwoI2IpIiBkPSJNMCAwaDk5djIwSDB6Ii8+CiAgICA8L2c+CiAgICA8ZyBmaWxsPSIjZmZmIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmb250LWZhbWlseT0iRGVqYVZ1IFNhbnMsVmVyZGFuYSxHZW5ldmEsc2Fucy1zZXJpZiIgZm9udC1zaXplPSIxMSI+CiAgICAgICAgPHRleHQgeD0iMzEuNSIgeT0iMTUiIGZpbGw9IiMwMTAxMDEiIGZpbGwtb3BhY2l0eT0iLjMiPmNvdmVyYWdlPC90ZXh0PgogICAgICAgIDx0ZXh0IHg9IjMxLjUiIHk9IjE0Ij5jb3ZlcmFnZTwvdGV4dD4KICAgICAgICA8dGV4dCB4PSI4MCIgeT0iMTUiIGZpbGw9IiMwMTAxMDEiIGZpbGwtb3BhY2l0eT0iLjMiPjg1JTwvdGV4dD4KICAgICAgICA8dGV4dCB4PSI4MCIgeT0iMTQiPjg1JTwvdGV4dD4KICAgIDwvZz4KPC9zdmc+Cg==\" alt=\"Coverage\" /></a></p>\n\n<p><img src=\"https://img.shields.io/github/commit-activity/t/mivanit/muutils\" alt=\"GitHub commits\" />\n<img src=\"https://img.shields.io/github/commit-activity/m/mivanit/muutils\" alt=\"GitHub commit activity\" />\n<img src=\"https://img.shields.io/github/issues-pr-closed/mivanit/muutils\" alt=\"GitHub closed pull requests\" />\n<img src=\"https://img.shields.io/github/languages/code-size/mivanit/muutils\" alt=\"code size, bytes\" />\n<!-- <img src=\"https://img.shields.io/tokei/lines/github.com/mivanit/muutils\" alt=\"Lines of code\" /> --></p>\n\n<p><code>muutils</code>, stylized as \"$\\mu$utils\" or \"\u03bcutils\", is a collection of miscellaneous python utilities, meant to be small and with no dependencies outside of standard python.</p>\n\n<h1 id=\"installation\">installation</h1>\n\n<p>PyPi: <a href=\"https://pypi.org/project/muutils/\">muutils</a></p>\n\n<pre><code>pip install muutils\n</code></pre>\n\n<p>Note that for using <code>mlutils</code>, <code>tensor_utils</code>, <code>nbutils.configure_notebook</code>, or the array serialization features of <code>json_serialize</code>, you will need to install with optional <code>array</code> dependencies:</p>\n\n<pre><code>pip install muutils[array]\n</code></pre>\n\n<h1 id=\"documentation\">documentation</h1>\n\n<p><a href=\"https://miv.name/muutils\"><strong>hosted html docs:</strong></a> <a href=\"https://miv.name/muutils\">https://miv.name/muutils</a></p>\n\n<ul>\n<li><a href=\"https://miv.name/muutils/combined/muutils.html\">single-page html docs</a> <a href=\"https://github.com/mivanit/muutils/tree/main/docs/combined/muutils.html\">(absolute source link)</a></li>\n<li><a href=\"https://miv.name/muutils/combined/muutils.md\">single-page markdown docs</a> <a href=\"https://github.com/mivanit/muutils/tree/main/docs/combined/muutils.md\">(absolute source link)</a></li>\n<li>Test coverage: <a href=\"https://miv.name/muutils/coverage/html/\"><img src=\"https://miv.name/muutils/coverage/coverage.svg\" alt=\"Test Coverage\" /></a> <a href=\"https://miv.name/muutils/coverage/html/\">webpage</a> <a href=\"https://github.com/mivanit/muutils/tree/main/docs/coverage/html/\">(absolute source link)</a> <a href=\"https://github.com/mivanit/muutils/tree/main/docs/coverage/coverage.txt\">(plain text)</a></li>\n</ul>\n\n<h1 id=\"modules\">modules</h1>\n\n<h2 id=\"statcounterhttpsgithubcommivanitmuutilstreemainmuutilsstatcounterpy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/statcounter.py\"><code>statcounter</code></a></h2>\n\n<p>an extension of <code>collections.Counter</code> that provides \"smart\" computation of stats (mean, variance, median, other percentiles) from the counter object without using <code>Counter.elements()</code></p>\n\n<h2 id=\"dictmagichttpsgithubcommivanitmuutilstreemainmuutilsdictmagicpy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/dictmagic.py\"><code>dictmagic</code></a></h2>\n\n<p>has utilities for working with dictionaries, like:</p>\n\n<ul>\n<li><p>converting dotlist-dictionaries to nested dictionaries and back:</p>\n\n<p><div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">dotlist_to_nested_dict</span><span class=\"p\">({</span><span class=\"s1\">&#39;a.b.c&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a.b.d&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a.e&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">})</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;c&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;d&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">},</span> <span class=\"s1\">&#39;e&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}}</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">nested_dict_to_dotlist</span><span class=\"p\">({</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;c&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;d&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">},</span> <span class=\"s1\">&#39;e&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}})</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;a.b.c&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a.b.d&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a.e&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}</span>\n</code></pre>\n</div></p></li>\n<li><p><code>DefaulterDict</code> which works like a <code>defaultdict</code> but can generate the default value based on the key</p></li>\n<li><p><code>condense_tensor_dict</code> takes a dict of dotlist-tensors and gives a more human-readable summary:</p>\n\n<p><div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">model</span> <span class=\"o\">=</span> <span class=\"n\">MyGPT</span><span class=\"p\">()</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">condense_tensor_dict</span><span class=\"p\">(</span><span class=\"n\">model</span><span class=\"o\">.</span><span class=\"n\">named_parameters</span><span class=\"p\">(),</span> <span class=\"s1\">&#39;yaml&#39;</span><span class=\"p\">))</span>\n</code></pre>\n</div></p>\n\n<p><div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nt\">embed</span><span class=\"p\">:</span>\n<span class=\"w\">    </span><span class=\"nt\">W_E</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(50257, 768)</span>\n<span class=\"nt\">pos_embed</span><span class=\"p\">:</span>\n<span class=\"w\">    </span><span class=\"nt\">W_pos</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(1024, 768)</span>\n<span class=\"nt\">blocks</span><span class=\"p\">:</span>\n<span class=\"w\">  </span><span class=\"s\">&#39;[0-11]&#39;</span><span class=\"p p-Indicator\">:</span>\n<span class=\"w\">    </span><span class=\"nt\">attn</span><span class=\"p\">:</span>\n<span class=\"w\">      </span><span class=\"s\">&#39;[W_Q,</span><span class=\"nv\"> </span><span class=\"s\">W_K,</span><span class=\"nv\"> </span><span class=\"s\">W_V]&#39;</span><span class=\"p p-Indicator\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(12, 768, 64)</span>\n<span class=\"w\">    </span><span class=\"nt\">W_O</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(12, 64, 768)</span>\n<span class=\"w\">      </span><span class=\"l l-Scalar l-Scalar-Plain\">&#39;[b_Q, b_K, b_V]&#39;</span><span class=\"p p-Indicator\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(12, 64)</span>\n<span class=\"w\">    </span><span class=\"nt\">b_O</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(768,)</span>\n<span class=\"l l-Scalar l-Scalar-Plain\">&lt;...&gt;</span>\n</code></pre>\n</div></p></li>\n</ul>\n\n<h2 id=\"kappahttpsgithubcommivanitmuutilstreemainmuutilskappapy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/kappa.py\"><code>kappa</code></a></h2>\n\n<p>Anonymous gettitem, so you can do things like</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">k</span> <span class=\"o\">=</span> <span class=\"n\">Kappa</span><span class=\"p\">(</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">x</span><span class=\"o\">**</span><span class=\"mi\">2</span><span class=\"p\">)</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">k</span><span class=\"p\">[</span><span class=\"mi\">2</span><span class=\"p\">]</span>\n<span class=\"mi\">4</span>\n</code></pre>\n</div>\n\n<h2 id=\"sysinfohttpsgithubcommivanitmuutilstreemainmuutilssysinfopy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/sysinfo.py\"><code>sysinfo</code></a></h2>\n\n<p>utility for getting a bunch of system information. useful for logging.</p>\n\n<h2 id=\"misc\"><code>misc</code>:</h2>\n\n<p>contains a few utilities:\n    - <code>stable_hash()</code> uses <code>hashlib.sha256</code> to compute a hash of an object that is stable across runs of python\n    - <code>list_join</code> and <code>list_split</code> which behave like <code>str.join</code> and <code>str.split</code> but for lists\n    - <code>sanitize_fname</code> and <code>dict_to_filename</code> for simplifying the creation of unique filename\n    - <code>shorten_numerical_to_str()</code> and <code>str_to_numeric</code> turns numbers like <code>123456789</code> into <code>\"123M\"</code> and back\n    - <code>freeze</code>, which prevents an object from being modified. Also see <a href=\"https://github.com/diegojromerolopez/gelidum/\">gelidum</a></p>\n\n<h2 id=\"nbutilshttpsgithubcommivanitmuutilstreemainmuutilsnbutils\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/nbutils\"><code>nbutils</code></a></h2>\n\n<p>contains utilities for working with jupyter notebooks, such as:</p>\n\n<ul>\n<li>quickly converting notebooks to python scripts (and running those scripts) for testing in CI</li>\n<li>configuring notebooks, to make it easier to switch between figure output formats, locations, and more</li>\n<li>shorthand for displaying mermaid diagrams and TeX</li>\n</ul>\n\n<h2 id=\"json_serializehttpsgithubcommivanitmuutilstreemainmuutilsjson_serialize\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/json_serialize\"><code>json_serialize</code></a></h2>\n\n<p>a tool for serializing and loading arbitrary python objects into json. plays nicely with <a href=\"https://github.com/mivanit/ZANJ/\"><code>ZANJ</code></a></p>\n\n<h2 id=\"tensor_utilshttpsgithubcommivanitmuutilstreemainmuutilstensor_utilspy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/tensor_utils.py\"><code>tensor_utils</code></a></h2>\n\n<p>contains minor utilities for working with pytorch tensors and numpy arrays, mostly for making type conversions easier</p>\n\n<h2 id=\"group_equivhttpsgithubcommivanitmuutilstreemainmuutilsgroup_equivpy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/group_equiv.py\"><code>group_equiv</code></a></h2>\n\n<p>groups elements from a sequence according to a given equivalence relation, without assuming that the equivalence relation obeys the transitive property</p>\n\n<h2 id=\"jsonlineshttpsgithubcommivanitmuutilstreemainmuutilsjsonlinespy\"><a href=\"https://github.com/mivanit/muutils/tree/main/muutils/jsonlines.py\"><code>jsonlines</code></a></h2>\n\n<p>an extremely simple utility for reading/writing <code>jsonl</code> files</p>\n\n<h2 id=\"zanjhttpsgithubcommivanitzanj\"><a href=\"https://github.com/mivanit/ZANJ/\"><code>ZANJ</code></a></h2>\n\n<p>is a human-readable and simple format for ML models, datasets, and arbitrary objects. It's build around having a zip file with <code>json</code> and <code>npy</code> files, and has been spun off into its <a href=\"https://github.com/mivanit/ZANJ/\">own project</a>.</p>\n\n<p>There are a couple work-in-progress utilities in <a href=\"https://github.com/mivanit/muutils/tree/main/muutils/_wip/\"><code>_wip</code></a> that aren't ready for anything, but nothing in this repo is suitable for production. Use at your own risk!</p>\n"}, "muutils.collect_warnings": {"fullname": "muutils.collect_warnings", "modulename": "muutils.collect_warnings", "kind": "module", "doc": "<p></p>\n"}, "muutils.collect_warnings.CollateWarnings": {"fullname": "muutils.collect_warnings.CollateWarnings", "modulename": "muutils.collect_warnings", "qualname": "CollateWarnings", "kind": "class", "doc": "<p>Capture every warning issued inside a <code>with</code> block and print a collated\nsummary when the block exits.</p>\n\n<p>Internally this wraps <code>warnings.catch_warnings(record=True)</code> so that all\nwarnings raised in the block are recorded.  When the context exits, identical\nwarnings are grouped and (optionally) printed with a user-defined format.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>print_on_exit : bool</code>\nWhether to print the summary when the context exits\n(defaults to <code>True</code>)</li>\n<li><p><code>fmt : str</code>\nFormat string used for printing each line of the summary.\nAvailable fields are:</p>\n\n<ul>\n<li><code>{count}</code>     : number of occurrences</li>\n<li><code>{filename}</code>  : file where the warning originated</li>\n<li><code>{lineno}</code>    : line number</li>\n<li><code>{category}</code>  : warning class name</li>\n<li><code>{message}</code>   : warning message text</li>\n</ul>\n\n<p>(defaults to <code>\"({count}x) {filename}:{lineno} {category}: {message}\"</code>)</p></li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><p><code>CollateWarnings</code>\nThe context-manager instance.  After exit, the attribute\n<code>counts</code> holds a mapping</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{(</span><span class=\"n\">filename</span><span class=\"p\">,</span> <span class=\"n\">lineno</span><span class=\"p\">,</span> <span class=\"n\">category</span><span class=\"p\">,</span> <span class=\"n\">message</span><span class=\"p\">):</span> <span class=\"n\">count</span><span class=\"p\">}</span>\n</code></pre>\n</div></li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">warnings</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"k\">with</span> <span class=\"n\">CollateWarnings</span><span class=\"p\">()</span> <span class=\"k\">as</span> <span class=\"n\">cw</span><span class=\"p\">:</span>\n<span class=\"o\">...</span>     <span class=\"n\">warnings</span><span class=\"o\">.</span><span class=\"n\">warn</span><span class=\"p\">(</span><span class=\"s2\">&quot;deprecated&quot;</span><span class=\"p\">,</span> <span class=\"ne\">DeprecationWarning</span><span class=\"p\">)</span>\n<span class=\"o\">...</span>     <span class=\"n\">warnings</span><span class=\"o\">.</span><span class=\"n\">warn</span><span class=\"p\">(</span><span class=\"s2\">&quot;deprecated&quot;</span><span class=\"p\">,</span> <span class=\"ne\">DeprecationWarning</span><span class=\"p\">)</span>\n<span class=\"o\">...</span>     <span class=\"n\">warnings</span><span class=\"o\">.</span><span class=\"n\">warn</span><span class=\"p\">(</span><span class=\"s2\">&quot;other&quot;</span><span class=\"p\">,</span> <span class=\"ne\">UserWarning</span><span class=\"p\">)</span>\n<span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"n\">x</span><span class=\"p\">)</span> <span class=\"o\">/</span><span class=\"n\">tmp</span><span class=\"o\">/</span><span class=\"n\">example</span><span class=\"o\">.</span><span class=\"n\">py</span><span class=\"p\">:</span><span class=\"mi\">42</span> <span class=\"ne\">DeprecationWarning</span><span class=\"p\">:</span> <span class=\"n\">deprecated</span>\n<span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"n\">x</span><span class=\"p\">)</span> <span class=\"o\">/</span><span class=\"n\">tmp</span><span class=\"o\">/</span><span class=\"n\">example</span><span class=\"o\">.</span><span class=\"n\">py</span><span class=\"p\">:</span><span class=\"mi\">43</span> <span class=\"ne\">UserWarning</span><span class=\"p\">:</span> <span class=\"n\">other</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">cw</span><span class=\"o\">.</span><span class=\"n\">counts</span>\n<span class=\"p\">{(</span><span class=\"s1\">&#39;/tmp/example.py&#39;</span><span class=\"p\">,</span> <span class=\"mi\">42</span><span class=\"p\">,</span> <span class=\"s1\">&#39;DeprecationWarning&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;deprecated&#39;</span><span class=\"p\">):</span> <span class=\"mi\">2</span><span class=\"p\">,</span>\n <span class=\"p\">(</span><span class=\"s1\">&#39;/tmp/example.py&#39;</span><span class=\"p\">,</span> <span class=\"mi\">43</span><span class=\"p\">,</span> <span class=\"s1\">&#39;UserWarning&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">):</span> <span class=\"mi\">1</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "bases": "contextlib.AbstractContextManager['CollateWarnings']"}, "muutils.collect_warnings.CollateWarnings.__init__": {"fullname": "muutils.collect_warnings.CollateWarnings.__init__", "modulename": "muutils.collect_warnings", "qualname": "CollateWarnings.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">print_on_exit</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">fmt</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;(</span><span class=\"si\">{count}</span><span class=\"s1\">x) </span><span class=\"si\">{filename}</span><span class=\"s1\">:</span><span class=\"si\">{lineno}</span><span class=\"s1\"> </span><span class=\"si\">{category}</span><span class=\"s1\">: </span><span class=\"si\">{message}</span><span class=\"s1\">&#39;</span></span>)</span>"}, "muutils.collect_warnings.CollateWarnings.counts": {"fullname": "muutils.collect_warnings.CollateWarnings.counts", "modulename": "muutils.collect_warnings", "qualname": "CollateWarnings.counts", "kind": "variable", "doc": "<p></p>\n", "annotation": ": collections.Counter[tuple[str, int, str, str]]"}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"fullname": "muutils.collect_warnings.CollateWarnings.print_on_exit", "modulename": "muutils.collect_warnings", "qualname": "CollateWarnings.print_on_exit", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.collect_warnings.CollateWarnings.fmt": {"fullname": "muutils.collect_warnings.CollateWarnings.fmt", "modulename": "muutils.collect_warnings", "qualname": "CollateWarnings.fmt", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.console_unicode": {"fullname": "muutils.console_unicode", "modulename": "muutils.console_unicode", "kind": "module", "doc": "<p></p>\n"}, "muutils.console_unicode.get_console_safe_str": {"fullname": "muutils.console_unicode.get_console_safe_str", "modulename": "muutils.console_unicode", "qualname": "get_console_safe_str", "kind": "function", "doc": "<p>Determine a console-safe string based on the preferred encoding.</p>\n\n<p>This function attempts to encode a given <code>default</code> string using the system's preferred encoding.\nIf encoding is successful, it returns the <code>default</code> string; otherwise, it returns a <code>fallback</code> string.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>default : str</code>\nThe primary string intended for use, to be tested against the system's preferred encoding.</li>\n<li><code>fallback : str</code>\nThe alternative string to be used if <code>default</code> cannot be encoded in the system's preferred encoding.</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>str</code>\nEither <code>default</code> or <code>fallback</code> based on whether <code>default</code> can be encoded safely.</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">get_console_safe_str</span><span class=\"p\">(</span><span class=\"s2\">&quot;caf\u00e9&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;cafe&quot;</span><span class=\"p\">)</span>\n<span class=\"s2\">&quot;caf\u00e9&quot;</span>  <span class=\"c1\"># This result may vary based on the system&#39;s preferred encoding.</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">fallback</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.dbg": {"fullname": "muutils.dbg", "modulename": "muutils.dbg", "kind": "module", "doc": "<p>this code is based on an implementation of the Rust builtin <code>dbg!</code> for Python, originally from\n<a href=\"https://github.com/tylerwince/pydbg/blob/master/pydbg.py\">https://github.com/tylerwince/pydbg/blob/master/pydbg.py</a>\nalthough it has been significantly modified</p>\n\n<p>licensed under MIT:</p>\n\n<p>Copyright (c) 2019 Tyler Wince</p>\n\n<p>Permission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:</p>\n\n<p>The above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.</p>\n\n<p>THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.</p>\n"}, "muutils.dbg.PATH_MODE": {"fullname": "muutils.dbg.PATH_MODE", "modulename": "muutils.dbg", "qualname": "PATH_MODE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;relative&#x27;, &#x27;absolute&#x27;]", "default_value": "&#x27;relative&#x27;"}, "muutils.dbg.DEFAULT_VAL_JOINER": {"fullname": "muutils.dbg.DEFAULT_VAL_JOINER", "modulename": "muutils.dbg", "qualname": "DEFAULT_VAL_JOINER", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27; = &#x27;"}, "muutils.dbg.dbg": {"fullname": "muutils.dbg.dbg", "modulename": "muutils.dbg", "qualname": "dbg", "kind": "function", "doc": "<p>Call dbg with any variable or expression.</p>\n\n<p>Calling dbg will print to stderr the current filename and lineno,\nas well as the passed expression and what the expression evaluates to:</p>\n\n<pre><code>    from muutils.dbg import dbg\n\n    a = 2\n    b = 5\n\n    dbg(a+b)\n\n    def square(x: int) -&gt; int:\n            return x * x\n\n    dbg(square(a))\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">exp</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_ExpType</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">dbg</span><span class=\"o\">.</span><span class=\"n\">_NoExpPassedSentinel</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">dbg</span><span class=\"o\">.</span><span class=\"n\">_NoExpPassedSentinel</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">formatter</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">val_joiner</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; = &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_ExpType</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">dbg</span><span class=\"o\">.</span><span class=\"n\">_NoExpPassedSentinel</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"fullname": "muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS", "modulename": "muutils.dbg", "qualname": "DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, Union[NoneType, bool, int, str]]", "default_value": "{&#x27;fmt&#x27;: &#x27;unicode&#x27;, &#x27;precision&#x27;: 2, &#x27;stats&#x27;: True, &#x27;shape&#x27;: True, &#x27;dtype&#x27;: True, &#x27;device&#x27;: True, &#x27;requires_grad&#x27;: True, &#x27;sparkline&#x27;: True, &#x27;sparkline_bins&#x27;: 7, &#x27;sparkline_logy&#x27;: None, &#x27;colored&#x27;: True, &#x27;eq_char&#x27;: &#x27;=&#x27;}"}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"fullname": "muutils.dbg.DBG_TENSOR_VAL_JOINER", "modulename": "muutils.dbg", "qualname": "DBG_TENSOR_VAL_JOINER", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;: &#x27;"}, "muutils.dbg.tensor_info": {"fullname": "muutils.dbg.tensor_info", "modulename": "muutils.dbg", "qualname": "tensor_info", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tensor</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.DBG_DICT_DEFAULTS": {"fullname": "muutils.dbg.DBG_DICT_DEFAULTS", "modulename": "muutils.dbg", "qualname": "DBG_DICT_DEFAULTS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, Union[bool, int, str]]", "default_value": "{&#x27;key_types&#x27;: True, &#x27;val_types&#x27;: True, &#x27;max_len&#x27;: 32, &#x27;indent&#x27;: &#x27;  &#x27;, &#x27;max_depth&#x27;: 3}"}, "muutils.dbg.DBG_LIST_DEFAULTS": {"fullname": "muutils.dbg.DBG_LIST_DEFAULTS", "modulename": "muutils.dbg", "qualname": "DBG_LIST_DEFAULTS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, Union[bool, int, str]]", "default_value": "{&#x27;max_len&#x27;: 16, &#x27;summary_show_types&#x27;: True}"}, "muutils.dbg.list_info": {"fullname": "muutils.dbg.list_info", "modulename": "muutils.dbg", "qualname": "list_info", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lst</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.TENSOR_STR_TYPES": {"fullname": "muutils.dbg.TENSOR_STR_TYPES", "modulename": "muutils.dbg", "qualname": "TENSOR_STR_TYPES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Set[str]", "default_value": "{&quot;&lt;class &#x27;torch.Tensor&#x27;&gt;&quot;, &quot;&lt;class &#x27;numpy.ndarray&#x27;&gt;&quot;}"}, "muutils.dbg.dict_info": {"fullname": "muutils.dbg.dict_info", "modulename": "muutils.dbg", "qualname": "dict_info", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">d</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">depth</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.info_auto": {"fullname": "muutils.dbg.info_auto", "modulename": "muutils.dbg", "qualname": "info_auto", "kind": "function", "doc": "<p>Automatically format an object for debugging.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.dbg_tensor": {"fullname": "muutils.dbg.dbg_tensor", "modulename": "muutils.dbg", "qualname": "dbg_tensor", "kind": "function", "doc": "<p>dbg function for tensors, using tensor_info formatter.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tensor</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">_ExpType</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">_ExpType</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.dbg_dict": {"fullname": "muutils.dbg.dbg_dict", "modulename": "muutils.dbg", "qualname": "dbg_dict", "kind": "function", "doc": "<p>dbg function for dictionaries, using dict_info formatter.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">d</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">_ExpType_dict</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">_ExpType_dict</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.dbg_auto": {"fullname": "muutils.dbg.dbg_auto", "modulename": "muutils.dbg", "qualname": "dbg_auto", "kind": "function", "doc": "<p>dbg function for automatic formatting based on type.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">_ExpType</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">_ExpType</span>:</span></span>", "funcdef": "def"}, "muutils.dbg.grep_repr": {"fullname": "muutils.dbg.grep_repr", "modulename": "muutils.dbg", "qualname": "grep_repr", "kind": "function", "doc": "<p>grep-like search on <code>repr(obj)</code> with improved grep-style options.</p>\n\n<p>By default, string patterns are case-insensitive. Pre-compiled regex\npatterns use their own flags.</p>\n\n<p>Parameters:</p>\n\n<ul>\n<li>obj: Object to search (its repr() string is scanned)</li>\n<li>pattern: Regular expression pattern (string or pre-compiled)</li>\n<li>char_context: Characters of context before/after each match (default: 20)</li>\n<li>line_context: Lines of context before/after; overrides char_context</li>\n<li>before_context: Lines of context before match (like grep -B)</li>\n<li>after_context: Lines of context after match (like grep -A)</li>\n<li>context: Lines of context before AND after (like grep -C)</li>\n<li>max_count: Stop after this many matches</li>\n<li>cased: Force case-sensitive search for string patterns</li>\n<li>loose: Normalize spaces/punctuation for flexible matching</li>\n<li>line_numbers: Show line numbers in output</li>\n<li>highlight: Wrap matches with ANSI color codes</li>\n<li>color: ANSI color code (default: \"31\" for red)</li>\n<li>separator: Separator between multiple matches</li>\n<li>quiet: Return results instead of printing</li>\n</ul>\n\n<p>Returns:</p>\n\n<ul>\n<li>None if quiet=False (prints to stdout)</li>\n<li>List[str] if quiet=True (returns formatted output lines)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">pattern</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">re</span><span class=\"o\">.</span><span class=\"n\">Pattern</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">char_context</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"mi\">20</span>,</span><span class=\"param\">\t<span class=\"n\">line_context</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">before_context</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">after_context</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">context</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">max_count</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">cased</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">loose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">line_numbers</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">highlight</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">color</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;31&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">separator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;--&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">quiet</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic": {"fullname": "muutils.dictmagic", "modulename": "muutils.dictmagic", "kind": "module", "doc": "<p>making working with dictionaries easier</p>\n\n<ul>\n<li><code>DefaulterDict</code>: like a defaultdict, but default_factory is passed the key as an argument</li>\n<li>various methods for working wit dotlist-nested dicts, converting to and from them</li>\n<li><code>condense_nested_dicts</code>: condense a nested dict, by condensing numeric or matching keys with matching values to ranges</li>\n<li><code>condense_tensor_dict</code>: convert a dictionary of tensors to a dictionary of shapes</li>\n<li><code>kwargs_to_nested_dict</code>: given kwargs from fire, convert them to a nested dict</li>\n</ul>\n"}, "muutils.dictmagic.DefaulterDict": {"fullname": "muutils.dictmagic.DefaulterDict", "modulename": "muutils.dictmagic", "qualname": "DefaulterDict", "kind": "class", "doc": "<p>like a defaultdict, but default_factory is passed the key as an argument</p>\n", "bases": "typing.Dict[~_KT, ~_VT], typing.Generic[~_KT, ~_VT]"}, "muutils.dictmagic.DefaulterDict.default_factory": {"fullname": "muutils.dictmagic.DefaulterDict.default_factory", "modulename": "muutils.dictmagic", "qualname": "DefaulterDict.default_factory", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Callable[[~_KT], ~_VT]"}, "muutils.dictmagic.defaultdict_to_dict_recursive": {"fullname": "muutils.dictmagic.defaultdict_to_dict_recursive", "modulename": "muutils.dictmagic", "qualname": "defaultdict_to_dict_recursive", "kind": "function", "doc": "<p>Convert a defaultdict or DefaulterDict to a normal dict, recursively</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dd</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">collections</span><span class=\"o\">.</span><span class=\"n\">defaultdict</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">dictmagic</span><span class=\"o\">.</span><span class=\"n\">DefaulterDict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.dotlist_to_nested_dict": {"fullname": "muutils.dictmagic.dotlist_to_nested_dict", "modulename": "muutils.dictmagic", "qualname": "dotlist_to_nested_dict", "kind": "function", "doc": "<p>Convert a dict with dot-separated keys to a nested dict</p>\n\n<p>Example:</p>\n\n<pre><code>&gt;&gt;&gt; dotlist_to_nested_dict({'a.b.c': 1, 'a.b.d': 2, 'a.e': 3})\n{'a': {'b': {'c': 1, 'd': 2}, 'e': 3}}\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dot_dict</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.nested_dict_to_dotlist": {"fullname": "muutils.dictmagic.nested_dict_to_dotlist", "modulename": "muutils.dictmagic", "qualname": "nested_dict_to_dotlist", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">nested_dict</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">allow_lists</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.update_with_nested_dict": {"fullname": "muutils.dictmagic.update_with_nested_dict", "modulename": "muutils.dictmagic", "qualname": "update_with_nested_dict", "kind": "function", "doc": "<p>Update a dict with a nested dict</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">update_with_nested_dict</span><span class=\"p\">({</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span> <span class=\"s2\">&quot;c&quot;</span><span class=\"p\">:</span> <span class=\"o\">-</span><span class=\"mi\">1</span><span class=\"p\">},</span> <span class=\"p\">{</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s2\">&quot;b&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">}})</span>\n<span class=\"go\">{&#39;a&#39;: {&#39;b&#39;: 2}, &#39;c&#39;: -1}</span>\n</code></pre>\n</div>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>original: dict[str, Any]</code>\nthe dict to update (will be modified in-place)</li>\n<li><code>update: dict[str, Any]</code>\nthe dict to update with</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li><code>dict</code>\nthe updated dict</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">original</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">update</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.kwargs_to_nested_dict": {"fullname": "muutils.dictmagic.kwargs_to_nested_dict", "modulename": "muutils.dictmagic", "qualname": "kwargs_to_nested_dict", "kind": "function", "doc": "<p>given kwargs from fire, convert them to a nested dict</p>\n\n<p>if strip_prefix is not None, then all keys must start with the prefix. by default,\nwill warn if an unknown prefix is found, but can be set to raise an error or ignore it:\n<code>when_unknown_prefix: ErrorMode</code></p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">main</span><span class=\"p\">(</span><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">kwargs_to_nested_dict</span><span class=\"p\">(</span><span class=\"n\">kwargs</span><span class=\"p\">))</span>\n<span class=\"n\">fire</span><span class=\"o\">.</span><span class=\"n\">Fire</span><span class=\"p\">(</span><span class=\"n\">main</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>running the above script will give:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>$<span class=\"w\"> </span>python<span class=\"w\"> </span>test.py<span class=\"w\"> </span>--a.b.c<span class=\"o\">=</span><span class=\"m\">1</span><span class=\"w\"> </span>--a.b.d<span class=\"o\">=</span><span class=\"m\">2</span><span class=\"w\"> </span>--a.e<span class=\"o\">=</span><span class=\"m\">3</span>\n<span class=\"o\">{</span><span class=\"s1\">&#39;a&#39;</span>:<span class=\"w\"> </span><span class=\"o\">{</span><span class=\"s1\">&#39;b&#39;</span>:<span class=\"w\"> </span><span class=\"o\">{</span><span class=\"s1\">&#39;c&#39;</span>:<span class=\"w\"> </span><span class=\"m\">1</span>,<span class=\"w\"> </span><span class=\"s1\">&#39;d&#39;</span>:<span class=\"w\"> </span><span class=\"m\">2</span><span class=\"o\">}</span>,<span class=\"w\"> </span><span class=\"s1\">&#39;e&#39;</span>:<span class=\"w\"> </span><span class=\"m\">3</span><span class=\"o\">}}</span>\n</code></pre>\n</div>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>kwargs_dict: dict[str, Any]</code>\nthe kwargs dict to convert</li>\n<li><code>sep: str = \".\"</code>\nthe separator to use for nested keys</li>\n<li><code>strip_prefix: Optional[str] = None</code>\nif not None, then all keys must start with this prefix</li>\n<li><code>when_unknown_prefix: ErrorMode = ErrorMode.WARN</code>\nwhat to do when an unknown prefix is found</li>\n<li><code>transform_key: Callable[[str], str] | None = None</code>\na function to apply to each key before adding it to the dict (applied after stripping the prefix)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">kwargs_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">strip_prefix</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">when_unknown_prefix</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Warn</span>,</span><span class=\"param\">\t<span class=\"n\">transform_key</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.is_numeric_consecutive": {"fullname": "muutils.dictmagic.is_numeric_consecutive", "modulename": "muutils.dictmagic", "qualname": "is_numeric_consecutive", "kind": "function", "doc": "<p>Check if the list of keys is numeric and consecutive.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lst</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.condense_nested_dicts_numeric_keys": {"fullname": "muutils.dictmagic.condense_nested_dicts_numeric_keys", "modulename": "muutils.dictmagic", "qualname": "condense_nested_dicts_numeric_keys", "kind": "function", "doc": "<p>condense a nested dict, by condensing numeric keys with matching values to ranges</p>\n\n<h1 id=\"examples\">Examples:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">condense_nested_dicts_numeric_keys</span><span class=\"p\">({</span><span class=\"s1\">&#39;1&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;2&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;3&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;4&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;5&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;6&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">})</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;[1-3]&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;[4-6]&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">}</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">condense_nested_dicts_numeric_keys</span><span class=\"p\">({</span><span class=\"s1\">&#39;1&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;1&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;2&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">},</span> <span class=\"s1\">&#39;2&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">})</span>\n<span class=\"p\">{</span><span class=\"s2\">&quot;1&quot;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s2\">&quot;[1-2]&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;a&quot;</span><span class=\"p\">},</span> <span class=\"s2\">&quot;2&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;b&quot;</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"fullname": "muutils.dictmagic.condense_nested_dicts_matching_values", "modulename": "muutils.dictmagic", "qualname": "condense_nested_dicts_matching_values", "kind": "function", "doc": "<p>condense a nested dict, by condensing keys with matching values</p>\n\n<h1 id=\"examples-todo\">Examples: TODO</h1>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>data : dict[str, Any]</code>\ndata to process</li>\n<li><code>val_condense_fallback_mapping : Callable[[Any], Hashable] | None</code>\na function to apply to each value before adding it to the dict (if it's not hashable)\n(defaults to <code>None</code>)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">val_condense_fallback_mapping</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Hashable</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.condense_nested_dicts": {"fullname": "muutils.dictmagic.condense_nested_dicts", "modulename": "muutils.dictmagic", "qualname": "condense_nested_dicts", "kind": "function", "doc": "<p>condense a nested dict, by condensing numeric or matching keys with matching values to ranges</p>\n\n<p>combines the functionality of <code>condense_nested_dicts_numeric_keys()</code> and <code>condense_nested_dicts_matching_values()</code></p>\n\n<h1 id=\"note-this-process-is-not-meant-to-be-reversible-and-is-intended-for-pretty-printing-and-visualization-purposes\">NOTE: this process is not meant to be reversible, and is intended for pretty-printing and visualization purposes</h1>\n\n<p>it's not reversible because types are lost to make the printing pretty</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>data : dict[str, Any]</code>\ndata to process</li>\n<li><code>condense_numeric_keys : bool</code>\n whether to condense numeric keys (e.g. \"1\", \"2\", \"3\") to ranges (e.g. \"[1-3]\")\n(defaults to <code>True</code>)</li>\n<li><code>condense_matching_values : bool</code>\n whether to condense keys with matching values\n(defaults to <code>True</code>)</li>\n<li><code>val_condense_fallback_mapping : Callable[[Any], Hashable] | None</code>\n a function to apply to each value before adding it to the dict (if it's not hashable)\n(defaults to <code>None</code>)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">condense_numeric_keys</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">condense_matching_values</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">val_condense_fallback_mapping</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Hashable</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.tuple_dims_replace": {"fullname": "muutils.dictmagic.tuple_dims_replace", "modulename": "muutils.dictmagic", "qualname": "tuple_dims_replace", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">t</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dims_names_map</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.dictmagic.TensorDict": {"fullname": "muutils.dictmagic.TensorDict", "modulename": "muutils.dictmagic", "qualname": "TensorDict", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Dict[str, ForwardRef(&#x27;torch.Tensor|np.ndarray&#x27;)]"}, "muutils.dictmagic.TensorIterable": {"fullname": "muutils.dictmagic.TensorIterable", "modulename": "muutils.dictmagic", "qualname": "TensorIterable", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Iterable[typing.Tuple[str, ForwardRef(&#x27;torch.Tensor|np.ndarray&#x27;)]]"}, "muutils.dictmagic.TensorDictFormats": {"fullname": "muutils.dictmagic.TensorDictFormats", "modulename": "muutils.dictmagic", "qualname": "TensorDictFormats", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;dict&#x27;, &#x27;json&#x27;, &#x27;yaml&#x27;, &#x27;yml&#x27;]"}, "muutils.dictmagic.condense_tensor_dict": {"fullname": "muutils.dictmagic.condense_tensor_dict", "modulename": "muutils.dictmagic", "qualname": "condense_tensor_dict", "kind": "function", "doc": "<p>Convert a dictionary of tensors to a dictionary of shapes.</p>\n\n<p>by default, values are converted to strings of their shapes (for nice printing).\nIf you want the actual shapes, set <code>shapes_convert = lambda x: x</code> or <code>shapes_convert = None</code>.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>data : dict[str, \"torch.Tensor|np.ndarray\"] | Iterable[tuple[str, \"torch.Tensor|np.ndarray\"]]</code>\na either a <code>TensorDict</code> dict from strings to tensors, or an <code>TensorIterable</code> iterable of (key, tensor) pairs (like you might get from a <code>dict().items())</code> )</li>\n<li><code>fmt : TensorDictFormats</code>\nformat to return the result in -- either a dict, or dump to json/yaml directly for pretty printing. will crash if yaml is not installed.\n(defaults to <code>'dict'</code>)</li>\n<li><code>shapes_convert : Callable[[tuple], Any]</code>\nconversion of a shape tuple to a string or other format (defaults to turning it into a string and removing quotes)\n(defaults to <code>lambdax:str(x).replace('\"', '').replace(\"'\", '')</code>)</li>\n<li><code>drop_batch_dims : int</code>\nnumber of leading dimensions to drop from the shape\n(defaults to <code>0</code>)</li>\n<li><code>sep : str</code>\nseparator to use for nested keys\n(defaults to <code>'.'</code>)</li>\n<li><code>dims_names_map : dict[int, str] | None</code>\nconvert certain dimension values in shape. not perfect, can be buggy\n(defaults to <code>None</code>)</li>\n<li><code>condense_numeric_keys : bool</code>\nwhether to condense numeric keys (e.g. \"1\", \"2\", \"3\") to ranges (e.g. \"[1-3]\"), passed on to <code>condense_nested_dicts</code>\n(defaults to <code>True</code>)</li>\n<li><code>condense_matching_values : bool</code>\nwhether to condense keys with matching values, passed on to <code>condense_nested_dicts</code>\n(defaults to <code>True</code>)</li>\n<li><code>val_condense_fallback_mapping : Callable[[Any], Hashable] | None</code>\na function to apply to each value before adding it to the dict (if it's not hashable), passed on to <code>condense_nested_dicts</code>\n(defaults to <code>None</code>)</li>\n<li><code>return_format : TensorDictFormats | None</code>\nlegacy alias for <code>fmt</code> kwarg</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>str|dict[str, str|tuple[int, ...]]</code>\ndict if <code>return_format='dict'</code>, a string for <code>json</code> or <code>yaml</code> output</li>\n</ul>\n\n<h1 id=\"examples\">Examples:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">model</span> <span class=\"o\">=</span> <span class=\"n\">transformer_lens</span><span class=\"o\">.</span><span class=\"n\">HookedTransformer</span><span class=\"o\">.</span><span class=\"n\">from_pretrained</span><span class=\"p\">(</span><span class=\"s2\">&quot;gpt2&quot;</span><span class=\"p\">)</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">condense_tensor_dict</span><span class=\"p\">(</span><span class=\"n\">model</span><span class=\"o\">.</span><span class=\"n\">named_parameters</span><span class=\"p\">(),</span> <span class=\"n\">return_format</span><span class=\"o\">=</span><span class=\"s1\">&#39;yaml&#39;</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nt\">embed</span><span class=\"p\">:</span>\n<span class=\"w\">  </span><span class=\"nt\">W_E</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(50257, 768)</span>\n<span class=\"nt\">pos_embed</span><span class=\"p\">:</span>\n<span class=\"w\">  </span><span class=\"nt\">W_pos</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(1024, 768)</span>\n<span class=\"nt\">blocks</span><span class=\"p\">:</span>\n<span class=\"w\">  </span><span class=\"s\">&#39;[0-11]&#39;</span><span class=\"p p-Indicator\">:</span>\n<span class=\"w\">    </span><span class=\"nt\">attn</span><span class=\"p\">:</span>\n<span class=\"w\">      </span><span class=\"s\">&#39;[W_Q,</span><span class=\"nv\"> </span><span class=\"s\">W_K,</span><span class=\"nv\"> </span><span class=\"s\">W_V]&#39;</span><span class=\"p p-Indicator\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(12, 768, 64)</span>\n<span class=\"w\">      </span><span class=\"nt\">W_O</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(12, 64, 768)</span>\n<span class=\"w\">      </span><span class=\"s\">&#39;[b_Q,</span><span class=\"nv\"> </span><span class=\"s\">b_K,</span><span class=\"nv\"> </span><span class=\"s\">b_V]&#39;</span><span class=\"p p-Indicator\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(12, 64)</span>\n<span class=\"w\">      </span><span class=\"nt\">b_O</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(768,)</span>\n<span class=\"w\">    </span><span class=\"nt\">mlp</span><span class=\"p\">:</span>\n<span class=\"w\">      </span><span class=\"nt\">W_in</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(768, 3072)</span>\n<span class=\"w\">      </span><span class=\"nt\">b_in</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(3072,)</span>\n<span class=\"w\">      </span><span class=\"nt\">W_out</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(3072, 768)</span>\n<span class=\"w\">      </span><span class=\"nt\">b_out</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(768,)</span>\n<span class=\"nt\">unembed</span><span class=\"p\">:</span>\n<span class=\"w\">  </span><span class=\"nt\">W_U</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(768, 50257)</span>\n<span class=\"w\">  </span><span class=\"nt\">b_U</span><span class=\"p\">:</span><span class=\"w\"> </span><span class=\"l l-Scalar l-Scalar-Plain\">(50257,)</span>\n</code></pre>\n</div>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> :  if <code>return_format</code> is not one of 'dict', 'json', or 'yaml', or if you try to use 'yaml' output without having PyYAML installed</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"s1\">&#39;TensorDict | TensorIterable&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fmt</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;dict&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;json&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;yaml&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;yml&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;dict&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">shapes_convert</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"nb\">tuple</span><span class=\"p\">],</span> <span class=\"n\">Any</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">function</span> <span class=\"n\">_default_shapes_convert</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">drop_batch_dims</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">dims_names_map</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">condense_numeric_keys</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">condense_matching_values</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">val_condense_fallback_mapping</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Hashable</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">return_format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;dict&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;json&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;yaml&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;yml&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]]]</span>:</span></span>", "funcdef": "def"}, "muutils.errormode": {"fullname": "muutils.errormode", "modulename": "muutils.errormode", "kind": "module", "doc": "<p>provides <code>ErrorMode</code> enum for handling errors consistently</p>\n\n<p>pass an <code>error_mode: ErrorMode</code> to a function to specify how to handle a certain kind of exception.\nThat function then instead of <code>raise</code>ing or <code>warnings.warn</code>ing, calls <code>error_mode.process</code> with the message and the exception.</p>\n\n<p>you can also specify the exception class to raise, the warning class to use, and the source of the exception/warning.</p>\n"}, "muutils.errormode.WarningFunc": {"fullname": "muutils.errormode.WarningFunc", "modulename": "muutils.errormode", "qualname": "WarningFunc", "kind": "class", "doc": "<p>Base class for protocol classes.</p>\n\n<p>Protocol classes are defined as::</p>\n\n<pre><code>class Proto(Protocol):\n    def meth(self) -&gt; int:\n        ...\n</code></pre>\n\n<p>Such classes are primarily used with static type checkers that recognize\nstructural subtyping (static duck-typing).</p>\n\n<p>For example::</p>\n\n<pre><code>class C:\n    def meth(self) -&gt; int:\n        return 0\n\ndef func(x: Proto) -&gt; int:\n    return x.meth()\n\nfunc(C())  # Passes static type check\n</code></pre>\n\n<p>See PEP 544 for details. Protocol classes decorated with\n@typing.runtime_checkable act as simple-minded runtime protocols that check\nonly the presence of given attributes, ignoring their type signatures.\nProtocol classes can be generic, they are defined as::</p>\n\n<pre><code>class GenProto[T](Protocol):\n    def meth(self) -&gt; T:\n        ...\n</code></pre>\n", "bases": "typing.Protocol"}, "muutils.errormode.WarningFunc.__init__": {"fullname": "muutils.errormode.WarningFunc.__init__", "modulename": "muutils.errormode", "qualname": "WarningFunc.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.errormode.LoggingFunc": {"fullname": "muutils.errormode.LoggingFunc", "modulename": "muutils.errormode", "qualname": "LoggingFunc", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Callable[[str], NoneType]"}, "muutils.errormode.GLOBAL_WARN_FUNC": {"fullname": "muutils.errormode.GLOBAL_WARN_FUNC", "modulename": "muutils.errormode", "qualname": "GLOBAL_WARN_FUNC", "kind": "function", "doc": "<p>Issue a warning, or maybe ignore it or raise an exception.</p>\n\n<p>message\n  Text of the warning message.\ncategory\n  The Warning category subclass. Defaults to UserWarning.\nstacklevel\n  How far up the call stack to make this warning appear. A value of 2 for\n  example attributes the warning to the caller of the code calling warn().\nsource\n  If supplied, the destroyed object which emitted a ResourceWarning\nskip_file_prefixes\n  An optional tuple of module filename prefixes indicating frames to skip\n  during stacklevel computations for stack frame attribution.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.errormode.GLOBAL_LOG_FUNC": {"fullname": "muutils.errormode.GLOBAL_LOG_FUNC", "modulename": "muutils.errormode", "qualname": "GLOBAL_LOG_FUNC", "kind": "function", "doc": "<p>Prints the values to a stream, or to sys.stdout by default.</p>\n\n<p>sep\n  string inserted between values, default a space.\nend\n  string appended after the last value, default a newline.\nfile\n  a file-like object (stream); defaults to the current sys.stdout.\nflush\n  whether to forcibly flush the stream.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"o\">=</span><span class=\"s1\">&#39; &#39;</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"o\">=</span><span class=\"s1\">&#39;</span><span class=\"se\">\\n</span><span class=\"s1\">&#39;</span>, </span><span class=\"param\"><span class=\"n\">file</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">flush</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.errormode.custom_showwarning": {"fullname": "muutils.errormode.custom_showwarning", "modulename": "muutils.errormode", "qualname": "custom_showwarning", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"ne\">Warning</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">category</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"ne\">Warning</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lineno</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.errormode.ErrorMode": {"fullname": "muutils.errormode.ErrorMode", "modulename": "muutils.errormode", "qualname": "ErrorMode", "kind": "class", "doc": "<p>Enum for handling errors consistently</p>\n\n<p>pass one of the instances of this enum to a function to specify how to handle a certain kind of exception.</p>\n\n<p>That function then instead of <code>raise</code>ing or <code>warnings.warn</code>ing, calls <code>error_mode.process</code> with the message and the exception.</p>\n", "bases": "enum.Enum"}, "muutils.errormode.ErrorMode.EXCEPT": {"fullname": "muutils.errormode.ErrorMode.EXCEPT", "modulename": "muutils.errormode", "qualname": "ErrorMode.EXCEPT", "kind": "variable", "doc": "<p></p>\n", "default_value": "ErrorMode.Except"}, "muutils.errormode.ErrorMode.WARN": {"fullname": "muutils.errormode.ErrorMode.WARN", "modulename": "muutils.errormode", "qualname": "ErrorMode.WARN", "kind": "variable", "doc": "<p></p>\n", "default_value": "ErrorMode.Warn"}, "muutils.errormode.ErrorMode.LOG": {"fullname": "muutils.errormode.ErrorMode.LOG", "modulename": "muutils.errormode", "qualname": "ErrorMode.LOG", "kind": "variable", "doc": "<p></p>\n", "default_value": "ErrorMode.Log"}, "muutils.errormode.ErrorMode.IGNORE": {"fullname": "muutils.errormode.ErrorMode.IGNORE", "modulename": "muutils.errormode", "qualname": "ErrorMode.IGNORE", "kind": "variable", "doc": "<p></p>\n", "default_value": "ErrorMode.Ignore"}, "muutils.errormode.ErrorMode.process": {"fullname": "muutils.errormode.ErrorMode.process", "modulename": "muutils.errormode", "qualname": "ErrorMode.process", "kind": "function", "doc": "<p>process an exception or warning according to the error mode</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>msg : str</code>\nmessage to pass to <code>except_cls</code> or <code>warn_func</code></li>\n<li><code>except_cls : typing.Type[Exception]</code>\n exception class to raise, must be a subclass of <code>Exception</code>\n(defaults to <code>ValueError</code>)</li>\n<li><code>warn_cls : typing.Type[Warning]</code>\n warning class to use, must be a subclass of <code>Warning</code>\n(defaults to <code>UserWarning</code>)</li>\n<li><code>except_from : typing.Optional[Exception]</code>\n will <code>raise except_cls(msg) from except_from</code> if not <code>None</code>\n(defaults to <code>None</code>)</li>\n<li><code>warn_func : WarningFunc | None</code>\n function to use for warnings, must have the signature <code>warn_func(msg: str, category: typing.Type[Warning], source: typing.Any = None) -&gt; None</code>\n(defaults to <code>None</code>)</li>\n<li><code>log_func : LoggingFunc | None</code>\n function to use for logging, must have the signature <code>log_func(msg: str) -&gt; None</code>\n(defaults to <code>None</code>)</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>except_cls</code> : _description_</li>\n<li><code>except_cls</code> : _description_</li>\n<li><code>ValueError</code> : _description_</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\texcept_cls: Type[Exception] = &lt;class &#x27;ValueError&#x27;&gt;,</span><span class=\"param\">\twarn_cls: Type[Warning] = &lt;class &#x27;UserWarning&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">except_from</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"ne\">Exception</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">warn_func</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">WarningFunc</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">log_func</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.errormode.ErrorMode.from_any": {"fullname": "muutils.errormode.ErrorMode.from_any", "modulename": "muutils.errormode", "qualname": "ErrorMode.from_any", "kind": "function", "doc": "<p>initialize an <code>ErrorMode</code> from a string or an <code>ErrorMode</code> instance</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">mode</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span>,</span><span class=\"param\">\t<span class=\"n\">allow_aliases</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">allow_prefix</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span>:</span></span>", "funcdef": "def"}, "muutils.errormode.ErrorMode.serialize": {"fullname": "muutils.errormode.ErrorMode.serialize", "modulename": "muutils.errormode", "qualname": "ErrorMode.serialize", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.errormode.ErrorMode.load": {"fullname": "muutils.errormode.ErrorMode.load", "modulename": "muutils.errormode", "qualname": "ErrorMode.load", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span>:</span></span>", "funcdef": "def"}, "muutils.errormode.ERROR_MODE_ALIASES": {"fullname": "muutils.errormode.ERROR_MODE_ALIASES", "modulename": "muutils.errormode", "qualname": "ERROR_MODE_ALIASES", "kind": "variable", "doc": "<p>map of string aliases to <code>ErrorMode</code> instances</p>\n", "annotation": ": dict[str, muutils.errormode.ErrorMode]", "default_value": "{&#x27;except&#x27;: ErrorMode.Except, &#x27;warn&#x27;: ErrorMode.Warn, &#x27;log&#x27;: ErrorMode.Log, &#x27;ignore&#x27;: ErrorMode.Ignore, &#x27;e&#x27;: ErrorMode.Except, &#x27;error&#x27;: ErrorMode.Except, &#x27;err&#x27;: ErrorMode.Except, &#x27;raise&#x27;: ErrorMode.Except, &#x27;w&#x27;: ErrorMode.Warn, &#x27;warning&#x27;: ErrorMode.Warn, &#x27;l&#x27;: ErrorMode.Log, &#x27;print&#x27;: ErrorMode.Log, &#x27;output&#x27;: ErrorMode.Log, &#x27;show&#x27;: ErrorMode.Log, &#x27;display&#x27;: ErrorMode.Log, &#x27;i&#x27;: ErrorMode.Ignore, &#x27;silent&#x27;: ErrorMode.Ignore, &#x27;quiet&#x27;: ErrorMode.Ignore, &#x27;nothing&#x27;: ErrorMode.Ignore}"}, "muutils.group_equiv": {"fullname": "muutils.group_equiv", "modulename": "muutils.group_equiv", "kind": "module", "doc": "<p>group items by assuming that <code>eq_func</code> defines an equivalence relation</p>\n"}, "muutils.group_equiv.group_by_equivalence": {"fullname": "muutils.group_equiv.group_by_equivalence", "modulename": "muutils.group_equiv", "qualname": "group_by_equivalence", "kind": "function", "doc": "<p>group items by assuming that <code>eq_func</code> implies an equivalence relation but might not be transitive</p>\n\n<p>so, if f(a,b) and f(b,c) then f(a,c) might be false, but we still want to put [a,b,c] in the same class</p>\n\n<p>note that lists are used to avoid the need for hashable items, and to allow for duplicates</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>items_in: Sequence[T]</code> the items to group</li>\n<li><code>eq_func: Callable[[T, T], bool]</code> a function that returns true if two items are equivalent. need not be transitive</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">items_in</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">eq_func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.interval": {"fullname": "muutils.interval", "modulename": "muutils.interval", "kind": "module", "doc": "<p>represents a mathematical <code>Interval</code> over the real numbers</p>\n"}, "muutils.interval.Number": {"fullname": "muutils.interval.Number", "modulename": "muutils.interval", "qualname": "Number", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[float, int]"}, "muutils.interval.Interval": {"fullname": "muutils.interval.Interval", "modulename": "muutils.interval", "qualname": "Interval", "kind": "class", "doc": "<p>Represents a mathematical interval, open by default.</p>\n\n<p>The Interval class can represent both open and closed intervals, as well as half-open intervals.\nIt supports various initialization methods and provides containment checks.</p>\n\n<p>Examples:</p>\n\n<pre><code>&gt;&gt;&gt; i1 = Interval(1, 5)  # Default open interval (1, 5)\n&gt;&gt;&gt; 3 in i1\nTrue\n&gt;&gt;&gt; 1 in i1\nFalse\n&gt;&gt;&gt; i2 = Interval([1, 5])  # Closed interval [1, 5]\n&gt;&gt;&gt; 1 in i2\nTrue\n&gt;&gt;&gt; i3 = Interval(1, 5, closed_L=True)  # Half-open interval [1, 5)\n&gt;&gt;&gt; str(i3)\n'[1, 5)'\n&gt;&gt;&gt; i4 = ClosedInterval(1, 5)  # Closed interval [1, 5]\n&gt;&gt;&gt; i5 = OpenInterval(1, 5)  # Open interval (1, 5)\n</code></pre>\n"}, "muutils.interval.Interval.__init__": {"fullname": "muutils.interval.Interval.__init__", "modulename": "muutils.interval", "qualname": "Interval.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]],</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">is_closed</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">closed_L</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">closed_R</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "muutils.interval.Interval.lower": {"fullname": "muutils.interval.Interval.lower", "modulename": "muutils.interval", "qualname": "Interval.lower", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[float, int]"}, "muutils.interval.Interval.upper": {"fullname": "muutils.interval.Interval.upper", "modulename": "muutils.interval", "qualname": "Interval.upper", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[float, int]"}, "muutils.interval.Interval.closed_L": {"fullname": "muutils.interval.Interval.closed_L", "modulename": "muutils.interval", "qualname": "Interval.closed_L", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.closed_R": {"fullname": "muutils.interval.Interval.closed_R", "modulename": "muutils.interval", "qualname": "Interval.closed_R", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.singleton_set": {"fullname": "muutils.interval.Interval.singleton_set", "modulename": "muutils.interval", "qualname": "Interval.singleton_set", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[set[Union[float, int]]]"}, "muutils.interval.Interval.is_closed": {"fullname": "muutils.interval.Interval.is_closed", "modulename": "muutils.interval", "qualname": "Interval.is_closed", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.is_open": {"fullname": "muutils.interval.Interval.is_open", "modulename": "muutils.interval", "qualname": "Interval.is_open", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.is_half_open": {"fullname": "muutils.interval.Interval.is_half_open", "modulename": "muutils.interval", "qualname": "Interval.is_half_open", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.is_singleton": {"fullname": "muutils.interval.Interval.is_singleton", "modulename": "muutils.interval", "qualname": "Interval.is_singleton", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.is_empty": {"fullname": "muutils.interval.Interval.is_empty", "modulename": "muutils.interval", "qualname": "Interval.is_empty", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.is_finite": {"fullname": "muutils.interval.Interval.is_finite", "modulename": "muutils.interval", "qualname": "Interval.is_finite", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.interval.Interval.singleton": {"fullname": "muutils.interval.Interval.singleton", "modulename": "muutils.interval", "qualname": "Interval.singleton", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[float, int]"}, "muutils.interval.Interval.get_empty": {"fullname": "muutils.interval.Interval.get_empty", "modulename": "muutils.interval", "qualname": "Interval.get_empty", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.get_singleton": {"fullname": "muutils.interval.Interval.get_singleton", "modulename": "muutils.interval", "qualname": "Interval.get_singleton", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.numerical_contained": {"fullname": "muutils.interval.Interval.numerical_contained", "modulename": "muutils.interval", "qualname": "Interval.numerical_contained", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">item</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.interval_contained": {"fullname": "muutils.interval.Interval.interval_contained", "modulename": "muutils.interval", "qualname": "Interval.interval_contained", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">item</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.from_str": {"fullname": "muutils.interval.Interval.from_str", "modulename": "muutils.interval", "qualname": "Interval.from_str", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.copy": {"fullname": "muutils.interval.Interval.copy", "modulename": "muutils.interval", "qualname": "Interval.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.size": {"fullname": "muutils.interval.Interval.size", "modulename": "muutils.interval", "qualname": "Interval.size", "kind": "function", "doc": "<p>Returns the size of the interval.</p>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>float</code>\nthe size of the interval</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.clamp": {"fullname": "muutils.interval.Interval.clamp", "modulename": "muutils.interval", "qualname": "Interval.clamp", "kind": "function", "doc": "<p>Clamp the given value to the interval bounds.</p>\n\n<p>For open bounds, the clamped value will be slightly inside the interval (by epsilon).</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>value : Union[int, float]</code>\nthe value to clamp.</li>\n<li><code>epsilon : float</code>\nmargin for open bounds\n(defaults to <code>_EPSILON</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>float</code>\nthe clamped value</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> : If the input value is NaN.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">epsilon</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1e-10</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.intersection": {"fullname": "muutils.interval.Interval.intersection", "modulename": "muutils.interval", "qualname": "Interval.intersection", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "muutils.interval.Interval.union": {"fullname": "muutils.interval.Interval.union", "modulename": "muutils.interval", "qualname": "Interval.union", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">interval</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "muutils.interval.ClosedInterval": {"fullname": "muutils.interval.ClosedInterval", "modulename": "muutils.interval", "qualname": "ClosedInterval", "kind": "class", "doc": "<p>Represents a mathematical interval, open by default.</p>\n\n<p>The Interval class can represent both open and closed intervals, as well as half-open intervals.\nIt supports various initialization methods and provides containment checks.</p>\n\n<p>Examples:</p>\n\n<pre><code>&gt;&gt;&gt; i1 = Interval(1, 5)  # Default open interval (1, 5)\n&gt;&gt;&gt; 3 in i1\nTrue\n&gt;&gt;&gt; 1 in i1\nFalse\n&gt;&gt;&gt; i2 = Interval([1, 5])  # Closed interval [1, 5]\n&gt;&gt;&gt; 1 in i2\nTrue\n&gt;&gt;&gt; i3 = Interval(1, 5, closed_L=True)  # Half-open interval [1, 5)\n&gt;&gt;&gt; str(i3)\n'[1, 5)'\n&gt;&gt;&gt; i4 = ClosedInterval(1, 5)  # Closed interval [1, 5]\n&gt;&gt;&gt; i5 = OpenInterval(1, 5)  # Open interval (1, 5)\n</code></pre>\n", "bases": "Interval"}, "muutils.interval.ClosedInterval.__init__": {"fullname": "muutils.interval.ClosedInterval.__init__", "modulename": "muutils.interval", "qualname": "ClosedInterval.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">],</span> <span class=\"nb\">float</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "muutils.interval.OpenInterval": {"fullname": "muutils.interval.OpenInterval", "modulename": "muutils.interval", "qualname": "OpenInterval", "kind": "class", "doc": "<p>Represents a mathematical interval, open by default.</p>\n\n<p>The Interval class can represent both open and closed intervals, as well as half-open intervals.\nIt supports various initialization methods and provides containment checks.</p>\n\n<p>Examples:</p>\n\n<pre><code>&gt;&gt;&gt; i1 = Interval(1, 5)  # Default open interval (1, 5)\n&gt;&gt;&gt; 3 in i1\nTrue\n&gt;&gt;&gt; 1 in i1\nFalse\n&gt;&gt;&gt; i2 = Interval([1, 5])  # Closed interval [1, 5]\n&gt;&gt;&gt; 1 in i2\nTrue\n&gt;&gt;&gt; i3 = Interval(1, 5, closed_L=True)  # Half-open interval [1, 5)\n&gt;&gt;&gt; str(i3)\n'[1, 5)'\n&gt;&gt;&gt; i4 = ClosedInterval(1, 5)  # Closed interval [1, 5]\n&gt;&gt;&gt; i5 = OpenInterval(1, 5)  # Open interval (1, 5)\n</code></pre>\n", "bases": "Interval"}, "muutils.interval.OpenInterval.__init__": {"fullname": "muutils.interval.OpenInterval.__init__", "modulename": "muutils.interval", "qualname": "OpenInterval.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">],</span> <span class=\"nb\">float</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "muutils.json_serialize": {"fullname": "muutils.json_serialize", "modulename": "muutils.json_serialize", "kind": "module", "doc": "<p>submodule for serializing things to json in a recoverable way</p>\n\n<p>you can throw <em>any</em> object into <code>muutils.json_serialize.json_serialize</code>\nand it will return a <code>JSONitem</code>, meaning a bool, int, float, str, None, list of <code>JSONitem</code>s, or a dict mappting to <code>JSONitem</code>.</p>\n\n<p>The goal of this is if you want to just be able to store something as relatively human-readable JSON, and don't care as much about recovering it, you can throw it into <code>json_serialize</code> and it will just work. If you want to do so in a recoverable way, check out <a href=\"https://github.com/mivanit/ZANJ\"><code>ZANJ</code></a>.</p>\n\n<p>it will do so by looking in <code>DEFAULT_HANDLERS</code>, which will keep it as-is if its already valid, then try to find a <code>.serialize()</code> method on the object, and then have a bunch of special cases. You can add handlers by initializing a <code>JsonSerializer</code> object and passing a sequence of them to <code>handlers_pre</code></p>\n\n<p>additionally, <code>SerializeableDataclass</code> is a special kind of dataclass where you specify how to serialize each field, and a <code>.serialize()</code> method is automatically added to the class. This is done by using the <code>serializable_dataclass</code> decorator, inheriting from <code>SerializeableDataclass</code>, and <code>serializable_field</code> in place of <code>dataclasses.field</code> when defining non-standard fields.</p>\n\n<p>This module plays nicely with and is a dependency of the <a href=\"https://github.com/mivanit/ZANJ\"><code>ZANJ</code></a> library, which extends this to support saving things to disk in a more efficient way than just plain json (arrays are saved as npy files, for example), and automatically detecting how to load saved objects into their original classes.</p>\n"}, "muutils.json_serialize.json_serialize": {"fullname": "muutils.json_serialize.json_serialize", "modulename": "muutils.json_serialize.json_serialize", "kind": "module", "doc": "<p>provides the basic framework for json serialization of objects</p>\n\n<p>notably:</p>\n\n<ul>\n<li><code>SerializerHandler</code> defines how to serialize a specific type of object</li>\n<li><code>JsonSerializer</code> handles configuration for which handlers to use</li>\n<li><code>json_serialize</code> provides the default configuration if you don't care -- call it on any object!</li>\n</ul>\n"}, "muutils.json_serialize.serializable_dataclass": {"fullname": "muutils.json_serialize.serializable_dataclass", "modulename": "muutils.json_serialize.serializable_dataclass", "kind": "module", "doc": "<p>save and load objects to and from json or compatible formats in a recoverable way</p>\n\n<p><code>d = dataclasses.asdict(my_obj)</code> will give you a dict, but if some fields are not json-serializable,\nyou will get an error when you call <code>json.dumps(d)</code>. This module provides a way around that.</p>\n\n<p>Instead, you define your class:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">MyClass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">a</span><span class=\"p\">:</span> <span class=\"nb\">int</span>\n    <span class=\"n\">b</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n</code></pre>\n</div>\n\n<p>and then you can call <code>my_obj.serialize()</code> to get a dict that can be serialized to json. So, you can do:</p>\n\n<pre><code>&gt;&gt;&gt; my_obj = MyClass(a=1, b=\"q\")\n&gt;&gt;&gt; s = json.dumps(my_obj.serialize())\n&gt;&gt;&gt; s\n'{_FORMAT_KEY: \"MyClass(SerializableDataclass)\", \"a\": 1, \"b\": \"q\"}'\n&gt;&gt;&gt; read_obj = MyClass.load(json.loads(s))\n&gt;&gt;&gt; read_obj == my_obj\nTrue\n</code></pre>\n\n<p>This isn't too impressive on its own, but it gets more useful when you have nested classses,\nor fields that are not json-serializable by default:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n    <span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">MyClass</span>\n    <span class=\"n\">act_fun</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">Module</span> <span class=\"o\">=</span> <span class=\"n\">serializable_field</span><span class=\"p\">(</span>\n        <span class=\"n\">default</span><span class=\"o\">=</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">ReLU</span><span class=\"p\">(),</span>\n        <span class=\"n\">serialization_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">),</span>\n        <span class=\"n\">deserialize_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">getattr</span><span class=\"p\">(</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"p\">,</span> <span class=\"n\">x</span><span class=\"p\">)(),</span>\n    <span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>which gives us:</p>\n\n<pre><code>&gt;&gt;&gt; nc = NestedClass(x=\"q\", y=MyClass(a=1, b=\"q\"), act_fun=torch.nn.Sigmoid())\n&gt;&gt;&gt; s = json.dumps(nc.serialize())\n&gt;&gt;&gt; s\n'{_FORMAT_KEY: \"NestedClass(SerializableDataclass)\", \"x\": \"q\", \"y\": {_FORMAT_KEY: \"MyClass(SerializableDataclass)\", \"a\": 1, \"b\": \"q\"}, \"act_fun\": \"Sigmoid\"}'\n&gt;&gt;&gt; read_nc = NestedClass.load(json.loads(s))\n&gt;&gt;&gt; read_nc == nc\nTrue\n</code></pre>\n"}, "muutils.json_serialize.serializable_field": {"fullname": "muutils.json_serialize.serializable_field", "modulename": "muutils.json_serialize.serializable_field", "kind": "module", "doc": "<p>extends <code>dataclasses.Field</code> for use with <code>SerializableDataclass</code></p>\n\n<p>In particular, instead of using <code>dataclasses.field</code>, use <code>serializable_field</code> to define fields in a <code>SerializableDataclass</code>.\nYou provide information on how the field should be serialized and loaded (as well as anything that goes into <code>dataclasses.field</code>)\nwhen you define the field, and the <code>SerializableDataclass</code> will automatically use those functions.</p>\n"}, "muutils.json_serialize.arr_metadata": {"fullname": "muutils.json_serialize.arr_metadata", "modulename": "muutils.json_serialize", "qualname": "arr_metadata", "kind": "function", "doc": "<p>get metadata for a numpy array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">arr</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.load_array": {"fullname": "muutils.json_serialize.load_array", "modulename": "muutils.json_serialize", "qualname": "load_array", "kind": "function", "doc": "<p>load a json-serialized array, infer the mode if not specified</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">array_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_list_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_hex_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_b64_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;external&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zero_dim&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.BASE_HANDLERS": {"fullname": "muutils.json_serialize.BASE_HANDLERS", "modulename": "muutils.json_serialize", "qualname": "BASE_HANDLERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "(SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;base types&#x27;, desc=&#x27;base types (bool, int, float, str, None)&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;dictionaries&#x27;, desc=&#x27;dictionaries&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;(list, tuple) -&gt; list&#x27;, desc=&#x27;lists and tuples as lists&#x27;))"}, "muutils.json_serialize.JSONitem": {"fullname": "muutils.json_serialize.JSONitem", "modulename": "muutils.json_serialize", "qualname": "JSONitem", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[bool, int, float, str, NoneType, typing.List[typing.Union[bool, int, float, str, NoneType, typing.List[typing.Any], typing.Dict[str, typing.Any]]], typing.Dict[str, typing.Union[bool, int, float, str, NoneType, typing.List[typing.Any], typing.Dict[str, typing.Any]]]]"}, "muutils.json_serialize.JsonSerializer": {"fullname": "muutils.json_serialize.JsonSerializer", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer", "kind": "class", "doc": "<p>Json serialization class (holds configs)</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>array_mode : ArrayMode</code>\nhow to write arrays\n(defaults to <code>\"array_list_meta\"</code>)</li>\n<li><code>error_mode : ErrorMode</code>\nwhat to do when we can't serialize an object (will use repr as fallback if \"ignore\" or \"warn\")\n(defaults to <code>\"except\"</code>)</li>\n<li><code>handlers_pre : MonoTuple[SerializerHandler]</code>\nhandlers to use before the default handlers\n(defaults to <code>tuple()</code>)</li>\n<li><code>handlers_default : MonoTuple[SerializerHandler]</code>\ndefault handlers to use\n(defaults to <code>DEFAULT_HANDLERS</code>)</li>\n<li><code>write_only_format : bool</code>\nchanges _FORMAT_KEY keys in output to \"__write_format__\" (when you want to serialize something in a way that zanj won't try to recover the object when loading)\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code>: on init, if <code>args</code> is not empty</li>\n<li><code>SerializationException</code>: on <code>json_serialize()</code>, if any error occurs when trying to serialize an object and <code>error_mode</code> is set to <code>ErrorMode.EXCEPT\"</code></li>\n</ul>\n"}, "muutils.json_serialize.JsonSerializer.__init__": {"fullname": "muutils.json_serialize.JsonSerializer.__init__", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">array_mode</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_list_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_hex_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_b64_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;external&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zero_dim&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;array_list_meta&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">error_mode</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span>,</span><span class=\"param\">\t<span class=\"n\">handlers_pre</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">handlers_default</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;base types&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;base types (bool, int, float, str, None)&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;dictionaries&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;dictionaries&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;(list, tuple) -&gt; list&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;lists and tuples as lists&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"n\">_serialize_override_serialize_func</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;.serialize override&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;objects with .serialize method&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;namedtuple -&gt; dict&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;namedtuples as dicts&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;dataclass -&gt; dict&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;dataclasses as dicts&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;path -&gt; str&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;Path objects as posix strings&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;obj -&gt; str(obj)&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;directly serialize objects in `SERIALIZE_DIRECT_AS_STR` to strings&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;numpy.ndarray&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;numpy arrays&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;torch.Tensor&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;pytorch tensors&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;pandas.DataFrame&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;pandas DataFrames&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;(set, list, tuple, Iterable) -&gt; list&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;sets, lists, tuples, and Iterables as lists&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;fallback&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;fallback handler -- serialize object attributes and special functions as strings&#39;</span><span class=\"p\">))</span>,</span><span class=\"param\">\t<span class=\"n\">write_only_format</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "muutils.json_serialize.JsonSerializer.array_mode": {"fullname": "muutils.json_serialize.JsonSerializer.array_mode", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.array_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;list&#x27;, &#x27;array_list_meta&#x27;, &#x27;array_hex_meta&#x27;, &#x27;array_b64_meta&#x27;, &#x27;external&#x27;, &#x27;zero_dim&#x27;]"}, "muutils.json_serialize.JsonSerializer.error_mode": {"fullname": "muutils.json_serialize.JsonSerializer.error_mode", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.error_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": muutils.errormode.ErrorMode"}, "muutils.json_serialize.JsonSerializer.write_only_format": {"fullname": "muutils.json_serialize.JsonSerializer.write_only_format", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.write_only_format", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.json_serialize.JsonSerializer.handlers": {"fullname": "muutils.json_serialize.JsonSerializer.handlers", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.handlers", "kind": "variable", "doc": "<p></p>\n", "annotation": ": None"}, "muutils.json_serialize.JsonSerializer.json_serialize": {"fullname": "muutils.json_serialize.JsonSerializer.json_serialize", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.json_serialize", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.JsonSerializer.hashify": {"fullname": "muutils.json_serialize.JsonSerializer.hashify", "modulename": "muutils.json_serialize", "qualname": "JsonSerializer.hashify", "kind": "function", "doc": "<p>try to turn any object into something hashable</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">force</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">tuple</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.try_catch": {"fullname": "muutils.json_serialize.try_catch", "modulename": "muutils.json_serialize", "qualname": "try_catch", "kind": "function", "doc": "<p>wraps the function to catch exceptions, returns serialized error message on exception</p>\n\n<p>returned func will return normal result on success, or error message on exception</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.json_serialize.dc_eq": {"fullname": "muutils.json_serialize.dc_eq", "modulename": "muutils.json_serialize", "qualname": "dc_eq", "kind": "function", "doc": "<p>checks if two dataclasses which (might) hold numpy arrays are equal</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>dc1</code>: the first dataclass</li>\n<li><code>dc2</code>: the second dataclass</li>\n<li><code>except_when_class_mismatch: bool</code>\nif <code>True</code>, will throw <code>TypeError</code> if the classes are different.\nif not, will return false by default or attempt to compare the fields if <code>false_when_class_mismatch</code> is <code>False</code>\n(default: <code>False</code>)</li>\n<li><code>false_when_class_mismatch: bool</code>\nonly relevant if <code>except_when_class_mismatch</code> is <code>False</code>.\nif <code>True</code>, will return <code>False</code> if the classes are different.\nif <code>False</code>, will attempt to compare the fields.</li>\n<li><code>except_when_field_mismatch: bool</code>\nonly relevant if <code>except_when_class_mismatch</code> is <code>False</code> and <code>false_when_class_mismatch</code> is <code>False</code>.\nif <code>True</code>, will throw <code>TypeError</code> if the fields are different.\n(default: <code>True</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>bool</code>: True if the dataclasses are equal, False otherwise</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>TypeError</code>: if the dataclasses are of different classes</li>\n<li><code>AttributeError</code>: if the dataclasses have different fields</li>\n</ul>\n\n<h1 id=\"todo-after-except-when-class-mismatch-is-false-shouldnt-we-then-go-to-field-keys-match\">TODO: after \"except when class mismatch\" is False, shouldn't we then go to \"field keys match\"?</h1>\n\n<pre><code>          [START]\n             \u25bc\n       \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510  \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n       \u2502dc1 is dc2?\u251c\u2500\u25ba\u2502 classes \u2502\n       \u2514\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518No\u2502 match?  \u2502\n  \u2500\u2500\u2500\u2500    \u2502           \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524\n (True)\u25c4\u2500\u2500\u2518Yes        \u2502No       \u2502Yes\n  \u2500\u2500\u2500\u2500                \u25bc         \u25bc\n      \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510 \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n      \u2502 except when    \u2502 \u2502 fields keys\u2502\n      \u2502 class mismatch?\u2502 \u2502 match?     \u2502\n      \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2518 \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2518\n      \u2502Yes        \u2502No    \u2502No     \u2502Yes\n      \u25bc           \u25bc      \u25bc       \u25bc\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510  \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n{ raise     } \u2502 except   \u2502  \u2502 field  \u2502\n{ TypeError } \u2502 when     \u2502  \u2502 values \u2502\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  \u2502 field    \u2502  \u2502 match? \u2502\n              \u2502 mismatch?\u2502  \u251c\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2518\n              \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2518  \u2502    \u2502Yes\n              \u2502Yes    \u2502No   \u2502No  \u25bc\n              \u25bc       \u25bc     \u2502   \u2500\u2500\u2500\u2500\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500     \u2500\u2500\u2500\u2500\u2500  \u2502  (True)\n{ raise         }   (False)\u25c4\u2518   \u2500\u2500\u2500\u2500\n{ AttributeError}    \u2500\u2500\u2500\u2500\u2500\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dc1</span>,</span><span class=\"param\">\t<span class=\"n\">dc2</span>,</span><span class=\"param\">\t<span class=\"n\">except_when_class_mismatch</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">false_when_class_mismatch</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">except_when_field_mismatch</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.SerializableDataclass": {"fullname": "muutils.json_serialize.SerializableDataclass", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass", "kind": "class", "doc": "<p>Base class for serializable dataclasses</p>\n\n<p>only for linting and type checking, still need to call <code>serializable_dataclass</code> decorator</p>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">MyClass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">a</span><span class=\"p\">:</span> <span class=\"nb\">int</span>\n    <span class=\"n\">b</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n</code></pre>\n</div>\n\n<p>and then you can call <code>my_obj.serialize()</code> to get a dict that can be serialized to json. So, you can do:</p>\n\n<pre><code>&gt;&gt;&gt; my_obj = MyClass(a=1, b=\"q\")\n&gt;&gt;&gt; s = json.dumps(my_obj.serialize())\n&gt;&gt;&gt; s\n'{_FORMAT_KEY: \"MyClass(SerializableDataclass)\", \"a\": 1, \"b\": \"q\"}'\n&gt;&gt;&gt; read_obj = MyClass.load(json.loads(s))\n&gt;&gt;&gt; read_obj == my_obj\nTrue\n</code></pre>\n\n<p>This isn't too impressive on its own, but it gets more useful when you have nested classses,\nor fields that are not json-serializable by default:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n    <span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">MyClass</span>\n    <span class=\"n\">act_fun</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">Module</span> <span class=\"o\">=</span> <span class=\"n\">serializable_field</span><span class=\"p\">(</span>\n        <span class=\"n\">default</span><span class=\"o\">=</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">ReLU</span><span class=\"p\">(),</span>\n        <span class=\"n\">serialization_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">),</span>\n        <span class=\"n\">deserialize_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">getattr</span><span class=\"p\">(</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"p\">,</span> <span class=\"n\">x</span><span class=\"p\">)(),</span>\n    <span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>which gives us:</p>\n\n<pre><code>&gt;&gt;&gt; nc = NestedClass(x=\"q\", y=MyClass(a=1, b=\"q\"), act_fun=torch.nn.Sigmoid())\n&gt;&gt;&gt; s = json.dumps(nc.serialize())\n&gt;&gt;&gt; s\n'{_FORMAT_KEY: \"NestedClass(SerializableDataclass)\", \"x\": \"q\", \"y\": {_FORMAT_KEY: \"MyClass(SerializableDataclass)\", \"a\": 1, \"b\": \"q\"}, \"act_fun\": \"Sigmoid\"}'\n&gt;&gt;&gt; read_nc = NestedClass.load(json.loads(s))\n&gt;&gt;&gt; read_nc == nc\nTrue\n</code></pre>\n", "bases": "abc.ABC"}, "muutils.json_serialize.SerializableDataclass.serialize": {"fullname": "muutils.json_serialize.SerializableDataclass.serialize", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass.serialize", "kind": "function", "doc": "<p>returns the class as a dict, implemented by using <code>@serializable_dataclass</code> decorator</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.SerializableDataclass.load": {"fullname": "muutils.json_serialize.SerializableDataclass.load", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass.load", "kind": "function", "doc": "<p>takes in an appropriately structured dict and returns an instance of the class, implemented by using <code>@serializable_dataclass</code> decorator</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">T</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"fullname": "muutils.json_serialize.SerializableDataclass.validate_fields_types", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass.validate_fields_types", "kind": "function", "doc": "<p>validate the types of all the fields on a <code>SerializableDataclass</code>. calls <code>SerializableDataclass__validate_field_type</code> for each field</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"fullname": "muutils.json_serialize.SerializableDataclass.validate_field_type", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass.validate_field_type", "kind": "function", "doc": "<p>given a dataclass, check the field matches the type hint</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">field</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_field</span><span class=\"o\">.</span><span class=\"n\">SerializableField</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.SerializableDataclass.diff": {"fullname": "muutils.json_serialize.SerializableDataclass.diff", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass.diff", "kind": "function", "doc": "<p>get a rich and recursive diff between two instances of a serializable dataclass</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">))</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;self&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}}</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"o\">=</span><span class=\"s2\">&quot;q1&quot;</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"o\">=</span><span class=\"s2\">&quot;q2&quot;</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">)))</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;x&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;self&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;q1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;q2&#39;</span><span class=\"p\">},</span> <span class=\"s1\">&#39;y&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;self&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}}}</span>\n</code></pre>\n</div>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>other : SerializableDataclass</code>\nother instance to compare against</li>\n<li><code>of_serialized : bool</code>\nif true, compare serialized data and not raw values\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>dict[str, Any]</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> : if the instances are not of the same type</li>\n<li><code>ValueError</code> : if the instances are <code>dataclasses.dataclass</code> but not <code>SerializableDataclass</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_dataclass</span><span class=\"o\">.</span><span class=\"n\">SerializableDataclass</span>,</span><span class=\"param\">\t<span class=\"n\">of_serialized</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"fullname": "muutils.json_serialize.SerializableDataclass.update_from_nested_dict", "modulename": "muutils.json_serialize", "qualname": "SerializableDataclass.update_from_nested_dict", "kind": "function", "doc": "<p>update the instance from a nested dict, useful for configuration from command line args</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<pre><code>- `nested_dict : dict[str, Any]`\n    nested dict to update the instance with\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">nested_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.json_serialize.array": {"fullname": "muutils.json_serialize.array", "modulename": "muutils.json_serialize.array", "kind": "module", "doc": "<p>this utilities module handles serialization and loading of numpy and torch arrays as json</p>\n\n<ul>\n<li><code>array_list_meta</code> is less efficient (arrays are stored as nested lists), but preserves both metadata and human readability.</li>\n<li><code>array_b64_meta</code> is the most efficient, but is not human readable.</li>\n<li><code>external</code> is mostly for use in <a href=\"https://github.com/mivanit/ZANJ\"><code>ZANJ</code></a></li>\n</ul>\n"}, "muutils.json_serialize.array.ArrayMode": {"fullname": "muutils.json_serialize.array.ArrayMode", "modulename": "muutils.json_serialize.array", "qualname": "ArrayMode", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;list&#x27;, &#x27;array_list_meta&#x27;, &#x27;array_hex_meta&#x27;, &#x27;array_b64_meta&#x27;, &#x27;external&#x27;, &#x27;zero_dim&#x27;]"}, "muutils.json_serialize.array.array_n_elements": {"fullname": "muutils.json_serialize.array.array_n_elements", "modulename": "muutils.json_serialize.array", "qualname": "array_n_elements", "kind": "function", "doc": "<p>get the number of elements in an array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">arr</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.array.arr_metadata": {"fullname": "muutils.json_serialize.array.arr_metadata", "modulename": "muutils.json_serialize.array", "qualname": "arr_metadata", "kind": "function", "doc": "<p>get metadata for a numpy array</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">arr</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.array.serialize_array": {"fullname": "muutils.json_serialize.array.serialize_array", "modulename": "muutils.json_serialize.array", "qualname": "serialize_array", "kind": "function", "doc": "<p>serialize a numpy or pytorch array in one of several modes</p>\n\n<p>if the object is zero-dimensional, simply get the unique item</p>\n\n<p><code>array_mode: ArrayMode</code> can be one of:</p>\n\n<ul>\n<li><code>list</code>: serialize as a list of values, no metadata (equivalent to <code>arr.tolist()</code>)</li>\n<li><code>array_list_meta</code>: serialize dict with metadata, actual list under the key <code>data</code></li>\n<li><code>array_hex_meta</code>: serialize dict with metadata, actual hex string under the key <code>data</code></li>\n<li><code>array_b64_meta</code>: serialize dict with metadata, actual base64 string under the key <code>data</code></li>\n</ul>\n\n<p>for <code>array_list_meta</code>, <code>array_hex_meta</code>, and <code>array_b64_meta</code>, the serialized object is:</p>\n\n<pre><code>{\n    _FORMAT_KEY: &lt;array_list_meta|array_hex_meta&gt;,\n    \"shape\": arr.shape,\n    \"dtype\": str(arr.dtype),\n    \"data\": &lt;arr.tolist()|arr.tobytes().hex()|base64.b64encode(arr.tobytes()).decode()&gt;,\n}\n</code></pre>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>arr : Any</code> array to serialize</li>\n<li><code>array_mode : ArrayMode</code> mode in which to serialize the array\n(defaults to <code>None</code> and inheriting from <code>jser: JsonSerializer</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>JSONitem</code>\njson serialized array</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>KeyError</code> : if the array mode is not valid</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">jser</span><span class=\"p\">:</span> <span class=\"s2\">&quot;&#39;JsonSerializer&#39;&quot;</span>,</span><span class=\"param\">\t<span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">array_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_list_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_hex_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_b64_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;external&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zero_dim&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.array.infer_array_mode": {"fullname": "muutils.json_serialize.array.infer_array_mode", "modulename": "muutils.json_serialize.array", "qualname": "infer_array_mode", "kind": "function", "doc": "<p>given a serialized array, infer the mode</p>\n\n<p>assumes the array was serialized via <code>serialize_array()</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_list_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_hex_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_b64_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;external&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zero_dim&#39;</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.array.load_array": {"fullname": "muutils.json_serialize.array.load_array", "modulename": "muutils.json_serialize.array", "qualname": "load_array", "kind": "function", "doc": "<p>load a json-serialized array, infer the mode if not specified</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">array_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_list_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_hex_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_b64_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;external&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zero_dim&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"fullname": "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SERIALIZER_SPECIAL_KEYS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": None", "default_value": "(&#x27;__name__&#x27;, &#x27;__doc__&#x27;, &#x27;__module__&#x27;, &#x27;__class__&#x27;, &#x27;__dict__&#x27;, &#x27;__annotations__&#x27;)"}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"fullname": "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SERIALIZER_SPECIAL_FUNCS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, typing.Callable]", "default_value": "{&#x27;str&#x27;: &lt;class &#x27;str&#x27;&gt;, &#x27;dir&#x27;: &lt;built-in function dir&gt;, &#x27;type&#x27;: &lt;function &lt;lambda&gt;&gt;, &#x27;repr&#x27;: &lt;function &lt;lambda&gt;&gt;, &#x27;code&#x27;: &lt;function &lt;lambda&gt;&gt;, &#x27;sourcefile&#x27;: &lt;function &lt;lambda&gt;&gt;}"}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"fullname": "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SERIALIZE_DIRECT_AS_STR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Set[str]", "default_value": "{&quot;&lt;class &#x27;torch.device&#x27;&gt;&quot;, &quot;&lt;class &#x27;torch.dtype&#x27;&gt;&quot;}"}, "muutils.json_serialize.json_serialize.ObjectPath": {"fullname": "muutils.json_serialize.json_serialize.ObjectPath", "modulename": "muutils.json_serialize.json_serialize", "qualname": "ObjectPath", "kind": "variable", "doc": "<p></p>\n", "default_value": "tuple[typing.Union[str, int], ...]"}, "muutils.json_serialize.json_serialize.SerializerHandler": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler", "kind": "class", "doc": "<p>a handler for a specific type of object</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<pre><code>- `check : Callable[[JsonSerializer, Any], bool]` takes a JsonSerializer and an object, returns whether to use this handler\n- `serialize : Callable[[JsonSerializer, Any, ObjectPath], JSONitem]` takes a JsonSerializer, an object, and the current path, returns the serialized object\n- `desc : str` description of the handler (optional)\n</code></pre>\n"}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler.__init__", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">check</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">JsonSerializer</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">serialize_func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">JsonSerializer</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]],</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">uid</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">desc</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "muutils.json_serialize.json_serialize.SerializerHandler.check": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler.check", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler.check", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Callable[[muutils.json_serialize.json_serialize.JsonSerializer, Any, tuple[Union[str, int], ...]], bool]"}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler.serialize_func", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Callable[[muutils.json_serialize.json_serialize.JsonSerializer, Any, tuple[Union[str, int], ...]], Union[bool, int, float, str, NoneType, List[Union[bool, int, float, str, NoneType, List[Any], Dict[str, Any]]], Dict[str, Union[bool, int, float, str, NoneType, List[Any], Dict[str, Any]]]]]"}, "muutils.json_serialize.json_serialize.SerializerHandler.uid": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler.uid", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler.uid", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.json_serialize.json_serialize.SerializerHandler.desc": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler.desc", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler.desc", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"fullname": "muutils.json_serialize.json_serialize.SerializerHandler.serialize", "modulename": "muutils.json_serialize.json_serialize", "qualname": "SerializerHandler.serialize", "kind": "function", "doc": "<p>serialize the handler info</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.json_serialize.BASE_HANDLERS": {"fullname": "muutils.json_serialize.json_serialize.BASE_HANDLERS", "modulename": "muutils.json_serialize.json_serialize", "qualname": "BASE_HANDLERS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": None", "default_value": "(SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;base types&#x27;, desc=&#x27;base types (bool, int, float, str, None)&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;dictionaries&#x27;, desc=&#x27;dictionaries&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;(list, tuple) -&gt; list&#x27;, desc=&#x27;lists and tuples as lists&#x27;))"}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"fullname": "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS", "modulename": "muutils.json_serialize.json_serialize", "qualname": "DEFAULT_HANDLERS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": None", "default_value": "(SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;base types&#x27;, desc=&#x27;base types (bool, int, float, str, None)&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;dictionaries&#x27;, desc=&#x27;dictionaries&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;(list, tuple) -&gt; list&#x27;, desc=&#x27;lists and tuples as lists&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function _serialize_override_serialize_func&gt;, uid=&#x27;.serialize override&#x27;, desc=&#x27;objects with .serialize method&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;namedtuple -&gt; dict&#x27;, desc=&#x27;namedtuples as dicts&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;dataclass -&gt; dict&#x27;, desc=&#x27;dataclasses as dicts&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;path -&gt; str&#x27;, desc=&#x27;Path objects as posix strings&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;obj -&gt; str(obj)&#x27;, desc=&#x27;directly serialize objects in `SERIALIZE_DIRECT_AS_STR` to strings&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;numpy.ndarray&#x27;, desc=&#x27;numpy arrays&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;torch.Tensor&#x27;, desc=&#x27;pytorch tensors&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;pandas.DataFrame&#x27;, desc=&#x27;pandas DataFrames&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;(set, list, tuple, Iterable) -&gt; list&#x27;, desc=&#x27;sets, lists, tuples, and Iterables as lists&#x27;), SerializerHandler(check=&lt;function &lt;lambda&gt;&gt;, serialize_func=&lt;function &lt;lambda&gt;&gt;, uid=&#x27;fallback&#x27;, desc=&#x27;fallback handler -- serialize object attributes and special functions as strings&#x27;))"}, "muutils.json_serialize.json_serialize.JsonSerializer": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer", "kind": "class", "doc": "<p>Json serialization class (holds configs)</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>array_mode : ArrayMode</code>\nhow to write arrays\n(defaults to <code>\"array_list_meta\"</code>)</li>\n<li><code>error_mode : ErrorMode</code>\nwhat to do when we can't serialize an object (will use repr as fallback if \"ignore\" or \"warn\")\n(defaults to <code>\"except\"</code>)</li>\n<li><code>handlers_pre : MonoTuple[SerializerHandler]</code>\nhandlers to use before the default handlers\n(defaults to <code>tuple()</code>)</li>\n<li><code>handlers_default : MonoTuple[SerializerHandler]</code>\ndefault handlers to use\n(defaults to <code>DEFAULT_HANDLERS</code>)</li>\n<li><code>write_only_format : bool</code>\nchanges _FORMAT_KEY keys in output to \"__write_format__\" (when you want to serialize something in a way that zanj won't try to recover the object when loading)\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code>: on init, if <code>args</code> is not empty</li>\n<li><code>SerializationException</code>: on <code>json_serialize()</code>, if any error occurs when trying to serialize an object and <code>error_mode</code> is set to <code>ErrorMode.EXCEPT\"</code></li>\n</ul>\n"}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.__init__", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">array_mode</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;list&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_list_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_hex_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;array_b64_meta&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;external&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zero_dim&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;array_list_meta&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">error_mode</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span>,</span><span class=\"param\">\t<span class=\"n\">handlers_pre</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">handlers_default</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;base types&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;base types (bool, int, float, str, None)&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;dictionaries&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;dictionaries&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;(list, tuple) -&gt; list&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;lists and tuples as lists&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"n\">_serialize_override_serialize_func</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;.serialize override&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;objects with .serialize method&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;namedtuple -&gt; dict&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;namedtuples as dicts&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;dataclass -&gt; dict&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;dataclasses as dicts&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;path -&gt; str&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;Path objects as posix strings&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;obj -&gt; str(obj)&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;directly serialize objects in `SERIALIZE_DIRECT_AS_STR` to strings&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;numpy.ndarray&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;numpy arrays&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;torch.Tensor&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;pytorch tensors&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;pandas.DataFrame&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;pandas DataFrames&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;(set, list, tuple, Iterable) -&gt; list&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;sets, lists, tuples, and Iterables as lists&#39;</span><span class=\"p\">),</span> <span class=\"n\">SerializerHandler</span><span class=\"p\">(</span><span class=\"n\">check</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">serialize_func</span><span class=\"o\">=&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span><span class=\"p\">,</span> <span class=\"n\">uid</span><span class=\"o\">=</span><span class=\"s1\">&#39;fallback&#39;</span><span class=\"p\">,</span> <span class=\"n\">desc</span><span class=\"o\">=</span><span class=\"s1\">&#39;fallback handler -- serialize object attributes and special functions as strings&#39;</span><span class=\"p\">))</span>,</span><span class=\"param\">\t<span class=\"n\">write_only_format</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.array_mode", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.array_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;list&#x27;, &#x27;array_list_meta&#x27;, &#x27;array_hex_meta&#x27;, &#x27;array_b64_meta&#x27;, &#x27;external&#x27;, &#x27;zero_dim&#x27;]"}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.error_mode", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.error_mode", "kind": "variable", "doc": "<p></p>\n", "annotation": ": muutils.errormode.ErrorMode"}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.write_only_format", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.json_serialize.json_serialize.JsonSerializer.handlers": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.handlers", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.handlers", "kind": "variable", "doc": "<p></p>\n", "annotation": ": None"}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.json_serialize", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.json_serialize.JsonSerializer.hashify": {"fullname": "muutils.json_serialize.json_serialize.JsonSerializer.hashify", "modulename": "muutils.json_serialize.json_serialize", "qualname": "JsonSerializer.hashify", "kind": "function", "doc": "<p>try to turn any object into something hashable</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">force</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">tuple</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"fullname": "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER", "modulename": "muutils.json_serialize.json_serialize", "qualname": "GLOBAL_JSON_SERIALIZER", "kind": "variable", "doc": "<p></p>\n", "annotation": ": muutils.json_serialize.json_serialize.JsonSerializer", "default_value": "&lt;muutils.json_serialize.json_serialize.JsonSerializer object&gt;"}, "muutils.json_serialize.json_serialize.json_serialize": {"fullname": "muutils.json_serialize.json_serialize.json_serialize", "modulename": "muutils.json_serialize.json_serialize", "qualname": "json_serialize", "kind": "function", "doc": "<p>serialize object to json-serializable object with default config</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"fullname": "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "CantGetTypeHintsWarning", "kind": "class", "doc": "<p>special warning for when we can't get type hints</p>\n", "bases": "builtins.UserWarning"}, "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"fullname": "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "ZanjMissingWarning", "kind": "class", "doc": "<p>special warning for when <a href=\"https://github.com/mivanit/ZANJ\"><code>ZANJ</code></a> is missing -- <code>register_loader_serializable_dataclass</code> will not work</p>\n", "bases": "builtins.UserWarning"}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"fullname": "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "zanj_register_loader_serializable_dataclass", "kind": "function", "doc": "<p>Register a serializable dataclass with the ZANJ import</p>\n\n<p>this allows <code>ZANJ().read()</code> to load the class and not just return plain dicts</p>\n\n<h1 id=\"todo-there-is-some-duplication-here-with-register_loader_handler\">TODO: there is some duplication here with register_loader_handler</h1>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"fullname": "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "FieldIsNotInitOrSerializeWarning", "kind": "class", "doc": "<p>Base class for warnings generated by user code.</p>\n", "bases": "builtins.UserWarning"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass__validate_field_type", "kind": "function", "doc": "<p>given a dataclass, check the field matches the type hint</p>\n\n<p>this function is written to <code>SerializableDataclass.validate_field_type</code></p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>self : SerializableDataclass</code>\n<code>SerializableDataclass</code> instance</li>\n<li><code>field : SerializableField | str</code>\nfield to validate, will get from <code>self.__dataclass_fields__</code> if an <code>str</code></li>\n<li><code>on_typecheck_error : ErrorMode</code>\n what to do if type checking throws an exception (except, warn, ignore). If <code>ignore</code> and an exception is thrown, the function will return <code>False</code>\n(defaults to <code>_DEFAULT_ON_TYPECHECK_ERROR</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>bool</code>\nif the field type is correct. <code>False</code> if the field type is incorrect or an exception is thrown and <code>on_typecheck_error</code> is <code>ignore</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_dataclass</span><span class=\"o\">.</span><span class=\"n\">SerializableDataclass</span>,</span><span class=\"param\">\t<span class=\"n\">field</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_field</span><span class=\"o\">.</span><span class=\"n\">SerializableField</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass__validate_fields_types__dict", "kind": "function", "doc": "<p>validate the types of all the fields on a <code>SerializableDataclass</code>. calls <code>SerializableDataclass__validate_field_type</code> for each field</p>\n\n<p>returns a dict of field names to bools, where the bool is if the field type is valid</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_dataclass</span><span class=\"o\">.</span><span class=\"n\">SerializableDataclass</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass__validate_fields_types", "kind": "function", "doc": "<p>validate the types of all the fields on a <code>SerializableDataclass</code>. calls <code>SerializableDataclass__validate_field_type</code> for each field</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_dataclass</span><span class=\"o\">.</span><span class=\"n\">SerializableDataclass</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass", "kind": "class", "doc": "<p>Base class for serializable dataclasses</p>\n\n<p>only for linting and type checking, still need to call <code>serializable_dataclass</code> decorator</p>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">MyClass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">a</span><span class=\"p\">:</span> <span class=\"nb\">int</span>\n    <span class=\"n\">b</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n</code></pre>\n</div>\n\n<p>and then you can call <code>my_obj.serialize()</code> to get a dict that can be serialized to json. So, you can do:</p>\n\n<pre><code>&gt;&gt;&gt; my_obj = MyClass(a=1, b=\"q\")\n&gt;&gt;&gt; s = json.dumps(my_obj.serialize())\n&gt;&gt;&gt; s\n'{_FORMAT_KEY: \"MyClass(SerializableDataclass)\", \"a\": 1, \"b\": \"q\"}'\n&gt;&gt;&gt; read_obj = MyClass.load(json.loads(s))\n&gt;&gt;&gt; read_obj == my_obj\nTrue\n</code></pre>\n\n<p>This isn't too impressive on its own, but it gets more useful when you have nested classses,\nor fields that are not json-serializable by default:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n    <span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">MyClass</span>\n    <span class=\"n\">act_fun</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">Module</span> <span class=\"o\">=</span> <span class=\"n\">serializable_field</span><span class=\"p\">(</span>\n        <span class=\"n\">default</span><span class=\"o\">=</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"o\">.</span><span class=\"n\">ReLU</span><span class=\"p\">(),</span>\n        <span class=\"n\">serialization_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">),</span>\n        <span class=\"n\">deserialize_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">getattr</span><span class=\"p\">(</span><span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">nn</span><span class=\"p\">,</span> <span class=\"n\">x</span><span class=\"p\">)(),</span>\n    <span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>which gives us:</p>\n\n<pre><code>&gt;&gt;&gt; nc = NestedClass(x=\"q\", y=MyClass(a=1, b=\"q\"), act_fun=torch.nn.Sigmoid())\n&gt;&gt;&gt; s = json.dumps(nc.serialize())\n&gt;&gt;&gt; s\n'{_FORMAT_KEY: \"NestedClass(SerializableDataclass)\", \"x\": \"q\", \"y\": {_FORMAT_KEY: \"MyClass(SerializableDataclass)\", \"a\": 1, \"b\": \"q\"}, \"act_fun\": \"Sigmoid\"}'\n&gt;&gt;&gt; read_nc = NestedClass.load(json.loads(s))\n&gt;&gt;&gt; read_nc == nc\nTrue\n</code></pre>\n", "bases": "abc.ABC"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass.serialize", "kind": "function", "doc": "<p>returns the class as a dict, implemented by using <code>@serializable_dataclass</code> decorator</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass.load", "kind": "function", "doc": "<p>takes in an appropriately structured dict and returns an instance of the class, implemented by using <code>@serializable_dataclass</code> decorator</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">T</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass.validate_fields_types", "kind": "function", "doc": "<p>validate the types of all the fields on a <code>SerializableDataclass</code>. calls <code>SerializableDataclass__validate_field_type</code> for each field</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass.validate_field_type", "kind": "function", "doc": "<p>given a dataclass, check the field matches the type hint</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">field</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_field</span><span class=\"o\">.</span><span class=\"n\">SerializableField</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass.diff", "kind": "function", "doc": "<p>get a rich and recursive diff between two instances of a serializable dataclass</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">))</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;self&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}}</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"o\">=</span><span class=\"s2\">&quot;q1&quot;</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">NestedClass</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"o\">=</span><span class=\"s2\">&quot;q2&quot;</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">)))</span>\n<span class=\"p\">{</span><span class=\"s1\">&#39;x&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;self&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;q1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;q2&#39;</span><span class=\"p\">},</span> <span class=\"s1\">&#39;y&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;self&#39;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s1\">&#39;other&#39;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">}}}</span>\n</code></pre>\n</div>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>other : SerializableDataclass</code>\nother instance to compare against</li>\n<li><code>of_serialized : bool</code>\nif true, compare serialized data and not raw values\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>dict[str, Any]</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> : if the instances are not of the same type</li>\n<li><code>ValueError</code> : if the instances are <code>dataclasses.dataclass</code> but not <code>SerializableDataclass</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_dataclass</span><span class=\"o\">.</span><span class=\"n\">SerializableDataclass</span>,</span><span class=\"param\">\t<span class=\"n\">of_serialized</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"fullname": "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "SerializableDataclass.update_from_nested_dict", "kind": "function", "doc": "<p>update the instance from a nested dict, useful for configuration from command line args</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<pre><code>- `nested_dict : dict[str, Any]`\n    nested dict to update the instance with\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">nested_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"fullname": "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "get_cls_type_hints_cached", "kind": "function", "doc": "<p>cached typing.get_type_hints for a class</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"fullname": "muutils.json_serialize.serializable_dataclass.get_cls_type_hints", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "get_cls_type_hints", "kind": "function", "doc": "<p>helper function to get type hints for a class</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_dataclass.KWOnlyError": {"fullname": "muutils.json_serialize.serializable_dataclass.KWOnlyError", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "KWOnlyError", "kind": "class", "doc": "<p>kw-only dataclasses are not supported in python &lt;3.9</p>\n", "bases": "builtins.NotImplementedError"}, "muutils.json_serialize.serializable_dataclass.FieldError": {"fullname": "muutils.json_serialize.serializable_dataclass.FieldError", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "FieldError", "kind": "class", "doc": "<p>base class for field errors</p>\n", "bases": "builtins.ValueError"}, "muutils.json_serialize.serializable_dataclass.NotSerializableFieldException": {"fullname": "muutils.json_serialize.serializable_dataclass.NotSerializableFieldException", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "NotSerializableFieldException", "kind": "class", "doc": "<p>field is not a <code>SerializableField</code></p>\n", "bases": "FieldError"}, "muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"fullname": "muutils.json_serialize.serializable_dataclass.FieldSerializationError", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "FieldSerializationError", "kind": "class", "doc": "<p>error while serializing a field</p>\n", "bases": "FieldError"}, "muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"fullname": "muutils.json_serialize.serializable_dataclass.FieldLoadingError", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "FieldLoadingError", "kind": "class", "doc": "<p>error while loading a field</p>\n", "bases": "FieldError"}, "muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"fullname": "muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "FieldTypeMismatchError", "kind": "class", "doc": "<p>error when a field type does not match the type hint</p>\n", "bases": "FieldError, builtins.TypeError"}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"fullname": "muutils.json_serialize.serializable_dataclass.serializable_dataclass", "modulename": "muutils.json_serialize.serializable_dataclass", "qualname": "serializable_dataclass", "kind": "function", "doc": "<p>decorator to make a dataclass serializable. <strong>must also make it inherit from <code>SerializableDataclass</code>!!</strong></p>\n\n<p>types will be validated (like pydantic) unless <code>on_typecheck_mismatch</code> is set to <code>ErrorMode.IGNORE</code></p>\n\n<p>behavior of most kwargs matches that of <code>dataclasses.dataclass</code>, but with some additional kwargs. any kwargs not listed here are passed to <code>dataclasses.dataclass</code></p>\n\n<p>Returns the same class as was passed in, with dunder methods added based on the fields defined in the class.</p>\n\n<p>Examines PEP 526 <code>__annotations__</code> to determine fields.</p>\n\n<p>If init is true, an <code>__init__()</code> method is added to the class. If repr is true, a <code>__repr__()</code> method is added. If order is true, rich comparison dunder methods are added. If unsafe_hash is true, a <code>__hash__()</code> method function is added. If frozen is true, fields may not be assigned to after instance creation.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@serializable_dataclass</span><span class=\"p\">(</span><span class=\"n\">kw_only</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">Myclass</span><span class=\"p\">(</span><span class=\"n\">SerializableDataclass</span><span class=\"p\">):</span>\n    <span class=\"n\">a</span><span class=\"p\">:</span> <span class=\"nb\">int</span>\n    <span class=\"n\">b</span><span class=\"p\">:</span> <span class=\"nb\">str</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">Myclass</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">b</span><span class=\"o\">=</span><span class=\"s2\">&quot;q&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">serialize</span><span class=\"p\">()</span>\n<span class=\"p\">{</span><span class=\"n\">_FORMAT_KEY</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Myclass(SerializableDataclass)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>_cls : _type_</code>\nclass to decorate. don't pass this arg, just use this as a decorator\n(defaults to <code>None</code>)</li>\n<li><code>init : bool</code>\nwhether to add an <code>__init__</code> method\n<em>(passed to dataclasses.dataclass)</em>\n(defaults to <code>True</code>)</li>\n<li><code>repr : bool</code>\nwhether to add a <code>__repr__</code> method\n<em>(passed to dataclasses.dataclass)</em>\n(defaults to <code>True</code>)</li>\n<li><code>order : bool</code>\nwhether to add rich comparison methods\n<em>(passed to dataclasses.dataclass)</em>\n(defaults to <code>False</code>)</li>\n<li><code>unsafe_hash : bool</code>\nwhether to add a <code>__hash__</code> method\n<em>(passed to dataclasses.dataclass)</em>\n(defaults to <code>False</code>)</li>\n<li><code>frozen : bool</code>\nwhether to make the class frozen\n<em>(passed to dataclasses.dataclass)</em>\n(defaults to <code>False</code>)</li>\n<li><code>properties_to_serialize : Optional[list[str]]</code>\nwhich properties to add to the serialized data dict\n<strong>SerializableDataclass only</strong>\n(defaults to <code>None</code>)</li>\n<li><code>register_handler : bool</code>\nif true, register the class with ZANJ for loading\n<strong>SerializableDataclass only</strong>\n(defaults to <code>True</code>)</li>\n<li><code>on_typecheck_error : ErrorMode</code>\nwhat to do if type checking throws an exception (except, warn, ignore). If <code>ignore</code> and an exception is thrown, type validation will still return false\n<strong>SerializableDataclass only</strong></li>\n<li><code>on_typecheck_mismatch : ErrorMode</code>\nwhat to do if a type mismatch is found (except, warn, ignore). If <code>ignore</code>, type validation will return <code>True</code>\n<strong>SerializableDataclass only</strong></li>\n<li><code>methods_no_override : list[str]|None</code>\nlist of methods that should not be overridden by the decorator\nby default, <code>__eq__</code>, <code>serialize</code>, <code>load</code>, and <code>validate_fields_types</code> are overridden by this function,\nbut you can disable this if you'd rather write your own. <code>dataclasses.dataclass</code> might still overwrite these, and those options take precedence\n<strong>SerializableDataclass only</strong>\n(defaults to <code>None</code>)</li>\n<li><code>**kwargs</code>\n<em>(passed to dataclasses.dataclass)</em></li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>_type_</code>\nthe decorated class</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>KWOnlyError</code> : only raised if <code>kw_only</code> is <code>True</code> and python version is &lt;3.9, since <code>dataclasses.dataclass</code> does not support this</li>\n<li><code>NotSerializableFieldException</code> : if a field is not a <code>SerializableField</code></li>\n<li><code>FieldSerializationError</code> : if there is an error serializing a field</li>\n<li><code>AttributeError</code> : if a property is not found on the class</li>\n<li><code>FieldLoadingError</code> : if there is an error loading a field</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">_cls</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">init</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"nb\">repr</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">eq</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">order</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">unsafe_hash</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">frozen</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">properties_to_serialize</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">register_handler</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_mismatch</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Warn</span>,</span><span class=\"param\">\t<span class=\"n\">methods_no_override</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_field.SerializableField": {"fullname": "muutils.json_serialize.serializable_field.SerializableField", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField", "kind": "class", "doc": "<p>extension of <code>dataclasses.Field</code> with additional serialization properties</p>\n", "bases": "dataclasses.Field"}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.__init__", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">default_factory</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[],</span> <span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">init</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"nb\">repr</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"nb\">hash</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">compare</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">doc</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">metadata</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">mappingproxy</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">kw_only</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">serialize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">serialization_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">loading_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">deserialize_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">assert_type</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">custom_typecheck_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">&lt;</span><span class=\"n\">member</span> <span class=\"s1\">&#39;type&#39;</span> <span class=\"n\">of</span> <span class=\"s1\">&#39;SerializableField&#39;</span> <span class=\"n\">objects</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.serialize", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.serialize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.serialization_fn", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.serialization_fn", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Callable[[Any], Any]]"}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.loading_fn", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.loading_fn", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Callable[[Any], Any]]"}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.deserialize_fn", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Callable[[Any], Any]]"}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.assert_type", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.assert_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.custom_typecheck_fn", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Callable[[&lt;member &#x27;type&#x27; of &#x27;SerializableField&#x27; objects&gt;], bool]]"}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.from_Field", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.from_Field", "kind": "function", "doc": "<p>copy all values from a <code>dataclasses.Field</code> to new <code>SerializableField</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">field</span><span class=\"p\">:</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">Field</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_field</span><span class=\"o\">.</span><span class=\"n\">SerializableField</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.serializable_field.SerializableField.name": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.name", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.name", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.type": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.type", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.type", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.default": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.default", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.default", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.default_factory", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.default_factory", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.init": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.init", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.init", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.repr", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.repr", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.hash", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.hash", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.compare", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.compare", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.metadata", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.metadata", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.kw_only", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.kw_only", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"fullname": "muutils.json_serialize.serializable_field.SerializableField.doc", "modulename": "muutils.json_serialize.serializable_field", "qualname": "SerializableField.doc", "kind": "variable", "doc": "<p></p>\n"}, "muutils.json_serialize.serializable_field.serializable_field": {"fullname": "muutils.json_serialize.serializable_field.serializable_field", "modulename": "muutils.json_serialize.serializable_field", "qualname": "serializable_field", "kind": "function", "doc": "<p>Create a new <code>SerializableField</code></p>\n\n<pre><code>default: Sfield_T | dataclasses._MISSING_TYPE = dataclasses.MISSING,\ndefault_factory: Callable[[], Sfield_T]\n| dataclasses._MISSING_TYPE = dataclasses.MISSING,\ninit: bool = True,\nrepr: bool = True,\nhash: Optional[bool] = None,\ncompare: bool = True,\ndoc: str | None = None, # new in python 3.14. can alternately pass `description` to match pydantic, but this is discouraged\nmetadata: types.MappingProxyType | None = None,\nkw_only: bool | dataclasses._MISSING_TYPE = dataclasses.MISSING,\n# ----------------------------------------------------------------------\n# new in `SerializableField`, not in `dataclasses.Field`\nserialize: bool = True,\nserialization_fn: Optional[Callable[[Any], Any]] = None,\nloading_fn: Optional[Callable[[Any], Any]] = None,\ndeserialize_fn: Optional[Callable[[Any], Any]] = None,\nassert_type: bool = True,\ncustom_typecheck_fn: Optional[Callable[[type], bool]] = None,\n</code></pre>\n\n<h1 id=\"new-parameters\">new Parameters:</h1>\n\n<ul>\n<li><code>serialize</code>: whether to serialize this field when serializing the class'</li>\n<li><code>serialization_fn</code>: function taking the instance of the field and returning a serializable object. If not provided, will iterate through the <code>SerializerHandler</code>s defined in <code>muutils.json_serialize.json_serialize</code></li>\n<li><code>loading_fn</code>: function taking the serialized object and returning the instance of the field. If not provided, will take object as-is.</li>\n<li><code>deserialize_fn</code>: new alternative to <code>loading_fn</code>. takes only the field's value, not the whole class. if both <code>loading_fn</code> and <code>deserialize_fn</code> are provided, an error will be raised.</li>\n<li><code>assert_type</code>: whether to assert the type of the field when loading. if <code>False</code>, will not check the type of the field.</li>\n<li><code>custom_typecheck_fn</code>: function taking the type of the field and returning whether the type itself is valid. if not provided, will use the default type checking.</li>\n</ul>\n\n<h1 id=\"gotchas\">Gotchas:</h1>\n\n<ul>\n<li><code>loading_fn</code> takes the dict of the <strong>class</strong>, not the field. if you wanted a <code>loading_fn</code> that does nothing, you'd write:</li>\n</ul>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">MyClass</span><span class=\"p\">:</span>\n    <span class=\"n\">my_field</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"n\">serializable_field</span><span class=\"p\">(</span>\n        <span class=\"n\">serialization_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">),</span>\n        <span class=\"n\">loading_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">[</span><span class=\"s2\">&quot;my_field&quot;</span><span class=\"p\">]:</span> <span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">)</span>\n    <span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>using <code>deserialize_fn</code> instead:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">class</span><span class=\"w\"> </span><span class=\"nc\">MyClass</span><span class=\"p\">:</span>\n    <span class=\"n\">my_field</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"n\">serializable_field</span><span class=\"p\">(</span>\n        <span class=\"n\">serialization_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">),</span>\n        <span class=\"n\">deserialize_fn</span><span class=\"o\">=</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">)</span>\n    <span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>In the above code, <code>my_field</code> is an int but will be serialized as a string.</p>\n\n<p>note that if not using ZANJ, and you have a class inside a container, you MUST provide\n<code>serialization_fn</code> and <code>loading_fn</code> to serialize and load the container.\nZANJ will automatically do this for you.</p>\n\n<h1 id=\"todo-custom_value_check_fn-function-taking-the-value-of-the-field-and-returning-whether-the-value-itself-is-valid-if-not-provided-any-value-is-valid-as-long-as-it-passes-the-type-test\">TODO: <code>custom_value_check_fn</code>: function taking the value of the field and returning whether the value itself is valid. if not provided, any value is valid as long as it passes the type test</h1>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">_args</span>,</span><span class=\"param\">\t<span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">default_factory</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">init</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"nb\">repr</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"nb\">hash</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">compare</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">doc</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">metadata</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">mappingproxy</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">kw_only</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">dataclasses</span><span class=\"o\">.</span><span class=\"n\">_MISSING_TYPE</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">serialize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">serialization_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">deserialize_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">assert_type</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">custom_typecheck_fn</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"nb\">type</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.util": {"fullname": "muutils.json_serialize.util", "modulename": "muutils.json_serialize.util", "kind": "module", "doc": "<p>utilities for json_serialize</p>\n"}, "muutils.json_serialize.util.BaseType": {"fullname": "muutils.json_serialize.util.BaseType", "modulename": "muutils.json_serialize.util", "qualname": "BaseType", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[bool, int, float, str, NoneType]"}, "muutils.json_serialize.util.JSONitem": {"fullname": "muutils.json_serialize.util.JSONitem", "modulename": "muutils.json_serialize.util", "qualname": "JSONitem", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[bool, int, float, str, NoneType, typing.List[typing.Union[bool, int, float, str, NoneType, typing.List[typing.Any], typing.Dict[str, typing.Any]]], typing.Dict[str, typing.Union[bool, int, float, str, NoneType, typing.List[typing.Any], typing.Dict[str, typing.Any]]]]"}, "muutils.json_serialize.util.JSONdict": {"fullname": "muutils.json_serialize.util.JSONdict", "modulename": "muutils.json_serialize.util", "qualname": "JSONdict", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Dict[str, typing.Union[bool, int, float, str, NoneType, typing.List[typing.Union[bool, int, float, str, NoneType, typing.List[typing.Any], typing.Dict[str, typing.Any]]], typing.Dict[str, typing.Union[bool, int, float, str, NoneType, typing.List[typing.Any], typing.Dict[str, typing.Any]]]]]"}, "muutils.json_serialize.util.Hashableitem": {"fullname": "muutils.json_serialize.util.Hashableitem", "modulename": "muutils.json_serialize.util", "qualname": "Hashableitem", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[bool, int, float, str, tuple]"}, "muutils.json_serialize.util.UniversalContainer": {"fullname": "muutils.json_serialize.util.UniversalContainer", "modulename": "muutils.json_serialize.util", "qualname": "UniversalContainer", "kind": "class", "doc": "<p>contains everything -- <code>x in UniversalContainer()</code> is always True</p>\n"}, "muutils.json_serialize.util.isinstance_namedtuple": {"fullname": "muutils.json_serialize.util.isinstance_namedtuple", "modulename": "muutils.json_serialize.util", "qualname": "isinstance_namedtuple", "kind": "function", "doc": "<p>checks if <code>x</code> is a <code>namedtuple</code></p>\n\n<p>credit to <a href=\"https://stackoverflow.com/questions/2166818/how-to-check-if-an-object-is-an-instance-of-a-namedtuple\">https://stackoverflow.com/questions/2166818/how-to-check-if-an-object-is-an-instance-of-a-namedtuple</a></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.util.try_catch": {"fullname": "muutils.json_serialize.util.try_catch", "modulename": "muutils.json_serialize.util", "qualname": "try_catch", "kind": "function", "doc": "<p>wraps the function to catch exceptions, returns serialized error message on exception</p>\n\n<p>returned func will return normal result on success, or error message on exception</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.json_serialize.util.SerializationException": {"fullname": "muutils.json_serialize.util.SerializationException", "modulename": "muutils.json_serialize.util", "qualname": "SerializationException", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "builtins.Exception"}, "muutils.json_serialize.util.string_as_lines": {"fullname": "muutils.json_serialize.util.string_as_lines", "modulename": "muutils.json_serialize.util", "qualname": "string_as_lines", "kind": "function", "doc": "<p>for easier reading of long strings in json, split up by newlines</p>\n\n<p>sort of like how jupyter notebooks do it</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">s</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.util.safe_getsource": {"fullname": "muutils.json_serialize.util.safe_getsource", "modulename": "muutils.json_serialize.util", "qualname": "safe_getsource", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.util.array_safe_eq": {"fullname": "muutils.json_serialize.util.array_safe_eq", "modulename": "muutils.json_serialize.util", "qualname": "array_safe_eq", "kind": "function", "doc": "<p>check if two objects are equal, account for if numpy arrays or torch tensors</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">a</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">b</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.util.dc_eq": {"fullname": "muutils.json_serialize.util.dc_eq", "modulename": "muutils.json_serialize.util", "qualname": "dc_eq", "kind": "function", "doc": "<p>checks if two dataclasses which (might) hold numpy arrays are equal</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>dc1</code>: the first dataclass</li>\n<li><code>dc2</code>: the second dataclass</li>\n<li><code>except_when_class_mismatch: bool</code>\nif <code>True</code>, will throw <code>TypeError</code> if the classes are different.\nif not, will return false by default or attempt to compare the fields if <code>false_when_class_mismatch</code> is <code>False</code>\n(default: <code>False</code>)</li>\n<li><code>false_when_class_mismatch: bool</code>\nonly relevant if <code>except_when_class_mismatch</code> is <code>False</code>.\nif <code>True</code>, will return <code>False</code> if the classes are different.\nif <code>False</code>, will attempt to compare the fields.</li>\n<li><code>except_when_field_mismatch: bool</code>\nonly relevant if <code>except_when_class_mismatch</code> is <code>False</code> and <code>false_when_class_mismatch</code> is <code>False</code>.\nif <code>True</code>, will throw <code>TypeError</code> if the fields are different.\n(default: <code>True</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>bool</code>: True if the dataclasses are equal, False otherwise</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>TypeError</code>: if the dataclasses are of different classes</li>\n<li><code>AttributeError</code>: if the dataclasses have different fields</li>\n</ul>\n\n<h1 id=\"todo-after-except-when-class-mismatch-is-false-shouldnt-we-then-go-to-field-keys-match\">TODO: after \"except when class mismatch\" is False, shouldn't we then go to \"field keys match\"?</h1>\n\n<pre><code>          [START]\n             \u25bc\n       \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510  \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n       \u2502dc1 is dc2?\u251c\u2500\u25ba\u2502 classes \u2502\n       \u2514\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518No\u2502 match?  \u2502\n  \u2500\u2500\u2500\u2500    \u2502           \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524\n (True)\u25c4\u2500\u2500\u2518Yes        \u2502No       \u2502Yes\n  \u2500\u2500\u2500\u2500                \u25bc         \u25bc\n      \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510 \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n      \u2502 except when    \u2502 \u2502 fields keys\u2502\n      \u2502 class mismatch?\u2502 \u2502 match?     \u2502\n      \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2518 \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2518\n      \u2502Yes        \u2502No    \u2502No     \u2502Yes\n      \u25bc           \u25bc      \u25bc       \u25bc\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510  \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n{ raise     } \u2502 except   \u2502  \u2502 field  \u2502\n{ TypeError } \u2502 when     \u2502  \u2502 values \u2502\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  \u2502 field    \u2502  \u2502 match? \u2502\n              \u2502 mismatch?\u2502  \u251c\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2518\n              \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2518  \u2502    \u2502Yes\n              \u2502Yes    \u2502No   \u2502No  \u25bc\n              \u25bc       \u25bc     \u2502   \u2500\u2500\u2500\u2500\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500     \u2500\u2500\u2500\u2500\u2500  \u2502  (True)\n{ raise         }   (False)\u25c4\u2518   \u2500\u2500\u2500\u2500\n{ AttributeError}    \u2500\u2500\u2500\u2500\u2500\n \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dc1</span>,</span><span class=\"param\">\t<span class=\"n\">dc2</span>,</span><span class=\"param\">\t<span class=\"n\">except_when_class_mismatch</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">false_when_class_mismatch</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">except_when_field_mismatch</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.json_serialize.util.MonoTuple": {"fullname": "muutils.json_serialize.util.MonoTuple", "modulename": "muutils.json_serialize.util", "qualname": "MonoTuple", "kind": "class", "doc": "<p>tuple type hint, but for a tuple of any length with all the same type</p>\n"}, "muutils.jsonlines": {"fullname": "muutils.jsonlines", "modulename": "muutils.jsonlines", "kind": "module", "doc": "<p>utilities for reading and writing jsonlines files, including gzip support</p>\n"}, "muutils.jsonlines.jsonl_load": {"fullname": "muutils.jsonlines.jsonl_load", "modulename": "muutils.jsonlines", "qualname": "jsonl_load", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">/</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">use_gzip</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]]]]]</span>:</span></span>", "funcdef": "def"}, "muutils.jsonlines.jsonl_load_log": {"fullname": "muutils.jsonlines.jsonl_load_log", "modulename": "muutils.jsonlines", "qualname": "jsonl_load_log", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"o\">*</span>, </span><span class=\"param\"><span class=\"n\">use_gzip</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.jsonlines.jsonl_write": {"fullname": "muutils.jsonlines.jsonl_write", "modulename": "muutils.jsonlines", "qualname": "jsonl_write", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">items</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">use_gzip</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">gzip_compresslevel</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.kappa": {"fullname": "muutils.kappa", "modulename": "muutils.kappa", "kind": "module", "doc": "<p>anonymous getitem class</p>\n\n<p>util for constructing a class which has a getitem method which just calls a function</p>\n\n<p>a <code>lambda</code> is an anonymous function: kappa is the letter before lambda in the greek alphabet,\nhence the name of this class</p>\n"}, "muutils.kappa.Kappa": {"fullname": "muutils.kappa.Kappa", "modulename": "muutils.kappa", "qualname": "Kappa", "kind": "class", "doc": "<p>A Mapping is a generic container for associating key/value\npairs.</p>\n\n<p>This class provides concrete generic implementations of all\nmethods except for __getitem__, __iter__, and __len__.</p>\n", "bases": "typing.Mapping[~_kappa_K, ~_kappa_V]"}, "muutils.kappa.Kappa.__init__": {"fullname": "muutils.kappa.Kappa.__init__", "modulename": "muutils.kappa", "qualname": "Kappa.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func_getitem</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">_kappa_K</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">_kappa_V</span><span class=\"p\">]</span></span>)</span>"}, "muutils.kappa.Kappa.func_getitem": {"fullname": "muutils.kappa.Kappa.func_getitem", "modulename": "muutils.kappa", "qualname": "Kappa.func_getitem", "kind": "variable", "doc": "<p></p>\n"}, "muutils.kappa.Kappa.doc": {"fullname": "muutils.kappa.Kappa.doc", "modulename": "muutils.kappa", "qualname": "Kappa.doc", "kind": "variable", "doc": "<p></p>\n"}, "muutils.logger": {"fullname": "muutils.logger", "modulename": "muutils.logger", "kind": "module", "doc": "<p>(deprecated) experimenting with logging utilities</p>\n"}, "muutils.logger.Logger": {"fullname": "muutils.logger.Logger", "modulename": "muutils.logger", "qualname": "Logger", "kind": "class", "doc": "<p>logger with more features, including log levels and streams</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<pre><code>    - `log_path : str | None`\n    default log file path\n    (defaults to `None`)\n    - `log_file : AnyIO | None`\n    default log io, should have a `.write()` method (pass only this or `log_path`, not both)\n    (defaults to `None`)\n    - `timestamp : bool`\n    whether to add timestamps to every log message (under the `_timestamp` key)\n    (defaults to `True`)\n    - `default_level : int`\n    default log level for streams/messages that don't specify a level\n    (defaults to `0`)\n    - `console_print_threshold : int`\n    log level at which to print to the console, anything greater will not be printed unless overridden by `console_print`\n    (defaults to `50`)\n    - `level_header : HeaderFunction`\n    function for formatting log messages when printing to console\n    (defaults to `HEADER_FUNCTIONS[\"md\"]`)\n</code></pre>\n\n<p></p>\n\n<ul>\n<li><code>keep_last_msg_time : bool</code>\nwhether to keep the last message time\n(defaults to <code>True</code>)</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<pre><code>    - `ValueError` : _description_\n</code></pre>\n", "bases": "muutils.logger.simplelogger.SimpleLogger"}, "muutils.logger.Logger.__init__": {"fullname": "muutils.logger.Logger.__init__", "modulename": "muutils.logger", "qualname": "Logger.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">log_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">log_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_level</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">console_print_threshold</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">50</span>,</span><span class=\"param\">\t<span class=\"n\">level_header</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">headerfuncs</span><span class=\"o\">.</span><span class=\"n\">HeaderFunction</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">function</span> <span class=\"n\">md_header_function</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">streams</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">loggingstream</span><span class=\"o\">.</span><span class=\"n\">LoggingStream</span><span class=\"p\">],</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">loggingstream</span><span class=\"o\">.</span><span class=\"n\">LoggingStream</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">keep_last_msg_time</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">timestamp</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.logger.Logger.log": {"fullname": "muutils.logger.Logger.log", "modulename": "muutils.logger", "qualname": "Logger.log", "kind": "function", "doc": "<p>logging function</p>\n\n<h3 id=\"parameters\">Parameters:</h3>\n\n<ul>\n<li><code>msg : JSONitem</code>\nmessage (usually string or dict) to be logged</li>\n<li><code>lvl : int | None</code>\nlevel of message (lower levels are more important)\n(defaults to <code>None</code>)</li>\n<li><code>console_print : bool</code>\noverride <code>console_print_threshold</code> setting\n(defaults to <code>False</code>)</li>\n<li><code>stream : str | None</code>\nwhether to log to a stream (defaults to <code>None</code>), which logs to the default <code>None</code> stream\n(defaults to <code>None</code>)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lvl</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">console_print</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">extra_indent</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.logger.Logger.log_elapsed_last": {"fullname": "muutils.logger.Logger.log_elapsed_last", "modulename": "muutils.logger", "qualname": "Logger.log_elapsed_last", "kind": "function", "doc": "<p>logs the time elapsed since the last message was printed to the console (in any stream)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lvl</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">console_print</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.logger.Logger.flush_all": {"fullname": "muutils.logger.Logger.flush_all", "modulename": "muutils.logger", "qualname": "Logger.flush_all", "kind": "function", "doc": "<p>flush all streams</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.logger.LoggingStream": {"fullname": "muutils.logger.LoggingStream", "modulename": "muutils.logger", "qualname": "LoggingStream", "kind": "class", "doc": "<p>properties of a logging stream</p>\n\n<ul>\n<li><code>name: str</code> name of the stream</li>\n<li><code>aliases: set[str]</code> aliases for the stream\n(calls to these names will be redirected to this stream. duplicate alises will result in errors)\nTODO: perhaps duplicate alises should result in duplicate writes?</li>\n<li><code>file: str|bool|AnyIO|None</code> file to write to\n<ul>\n<li>if <code>None</code>, will write to standard log</li>\n<li>if <code>True</code>, will write to <code>name + \".log\"</code></li>\n<li>if <code>False</code> will \"write\" to <code>NullIO</code> (throw it away)</li>\n<li>if a string, will write to that file</li>\n<li>if a fileIO type object, will write to that object</li>\n</ul></li>\n<li><code>default_level: int|None</code> default level for this stream</li>\n<li><code>default_contents: dict[str, Callable[[], Any]]</code> default contents for this stream</li>\n<li><code>last_msg: tuple[float, Any]|None</code> last message written to this stream (timestamp, message)</li>\n</ul>\n"}, "muutils.logger.LoggingStream.__init__": {"fullname": "muutils.logger.LoggingStream.__init__", "modulename": "muutils.logger", "qualname": "LoggingStream.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">aliases</span><span class=\"p\">:</span> <span class=\"nb\">set</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_level</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_contents</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">[[],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "muutils.logger.LoggingStream.name": {"fullname": "muutils.logger.LoggingStream.name", "modulename": "muutils.logger", "qualname": "LoggingStream.name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None"}, "muutils.logger.LoggingStream.aliases": {"fullname": "muutils.logger.LoggingStream.aliases", "modulename": "muutils.logger", "qualname": "LoggingStream.aliases", "kind": "variable", "doc": "<p></p>\n", "annotation": ": set[str | None]"}, "muutils.logger.LoggingStream.file": {"fullname": "muutils.logger.LoggingStream.file", "modulename": "muutils.logger", "qualname": "LoggingStream.file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[str, bool, TextIO, muutils.logger.simplelogger.NullIO, NoneType]", "default_value": "None"}, "muutils.logger.LoggingStream.default_level": {"fullname": "muutils.logger.LoggingStream.default_level", "modulename": "muutils.logger", "qualname": "LoggingStream.default_level", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int | None", "default_value": "None"}, "muutils.logger.LoggingStream.default_contents": {"fullname": "muutils.logger.LoggingStream.default_contents", "modulename": "muutils.logger", "qualname": "LoggingStream.default_contents", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, typing.Callable[[], typing.Any]]"}, "muutils.logger.LoggingStream.handler": {"fullname": "muutils.logger.LoggingStream.handler", "modulename": "muutils.logger", "qualname": "LoggingStream.handler", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[TextIO, muutils.logger.simplelogger.NullIO, NoneType]", "default_value": "None"}, "muutils.logger.LoggingStream.make_handler": {"fullname": "muutils.logger.LoggingStream.make_handler", "modulename": "muutils.logger", "qualname": "LoggingStream.make_handler", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.logger.SimpleLogger": {"fullname": "muutils.logger.SimpleLogger", "modulename": "muutils.logger", "qualname": "SimpleLogger", "kind": "class", "doc": "<p>logs training data to a jsonl file</p>\n"}, "muutils.logger.SimpleLogger.__init__": {"fullname": "muutils.logger.SimpleLogger.__init__", "modulename": "muutils.logger", "qualname": "SimpleLogger.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">log_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">log_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">timestamp</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "muutils.logger.SimpleLogger.log": {"fullname": "muutils.logger.SimpleLogger.log", "modulename": "muutils.logger", "qualname": "SimpleLogger.log", "kind": "function", "doc": "<p>log a message to the log file, and optionally to the console</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">console_print</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.logger.TimerContext": {"fullname": "muutils.logger.TimerContext", "modulename": "muutils.logger", "qualname": "TimerContext", "kind": "class", "doc": "<p>context manager for timing code</p>\n"}, "muutils.logger.TimerContext.start_time": {"fullname": "muutils.logger.TimerContext.start_time", "modulename": "muutils.logger", "qualname": "TimerContext.start_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.TimerContext.end_time": {"fullname": "muutils.logger.TimerContext.end_time", "modulename": "muutils.logger", "qualname": "TimerContext.end_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.TimerContext.elapsed_time": {"fullname": "muutils.logger.TimerContext.elapsed_time", "modulename": "muutils.logger", "qualname": "TimerContext.elapsed_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.exception_context": {"fullname": "muutils.logger.exception_context", "modulename": "muutils.logger.exception_context", "kind": "module", "doc": "<p></p>\n"}, "muutils.logger.exception_context.ExceptionContext": {"fullname": "muutils.logger.exception_context.ExceptionContext", "modulename": "muutils.logger.exception_context", "qualname": "ExceptionContext", "kind": "class", "doc": "<p>context manager which catches all exceptions happening while the context is open, <code>.write()</code> the exception trace to the given stream, and then raises the exception</p>\n\n<p>for example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">errorfile</span> <span class=\"o\">=</span> <span class=\"nb\">open</span><span class=\"p\">(</span><span class=\"s1\">&#39;error.log&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;w&#39;</span><span class=\"p\">)</span>\n\n<span class=\"k\">with</span> <span class=\"n\">ExceptionContext</span><span class=\"p\">(</span><span class=\"n\">errorfile</span><span class=\"p\">):</span>\n        <span class=\"c1\"># do something that might throw an exception</span>\n        <span class=\"c1\"># if it does, the exception trace will be written to errorfile</span>\n        <span class=\"c1\"># and then the exception will be raised</span>\n</code></pre>\n</div>\n"}, "muutils.logger.exception_context.ExceptionContext.__init__": {"fullname": "muutils.logger.exception_context.ExceptionContext.__init__", "modulename": "muutils.logger.exception_context", "qualname": "ExceptionContext.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">stream</span></span>)</span>"}, "muutils.logger.exception_context.ExceptionContext.stream": {"fullname": "muutils.logger.exception_context.ExceptionContext.stream", "modulename": "muutils.logger.exception_context", "qualname": "ExceptionContext.stream", "kind": "variable", "doc": "<p></p>\n"}, "muutils.logger.headerfuncs": {"fullname": "muutils.logger.headerfuncs", "modulename": "muutils.logger.headerfuncs", "kind": "module", "doc": "<p></p>\n"}, "muutils.logger.headerfuncs.HeaderFunction": {"fullname": "muutils.logger.headerfuncs.HeaderFunction", "modulename": "muutils.logger.headerfuncs", "qualname": "HeaderFunction", "kind": "class", "doc": "<p>Base class for protocol classes.</p>\n\n<p>Protocol classes are defined as::</p>\n\n<pre><code>class Proto(Protocol):\n    def meth(self) -&gt; int:\n        ...\n</code></pre>\n\n<p>Such classes are primarily used with static type checkers that recognize\nstructural subtyping (static duck-typing).</p>\n\n<p>For example::</p>\n\n<pre><code>class C:\n    def meth(self) -&gt; int:\n        return 0\n\ndef func(x: Proto) -&gt; int:\n    return x.meth()\n\nfunc(C())  # Passes static type check\n</code></pre>\n\n<p>See PEP 544 for details. Protocol classes decorated with\n@typing.runtime_checkable act as simple-minded runtime protocols that check\nonly the presence of given attributes, ignoring their type signatures.\nProtocol classes can be generic, they are defined as::</p>\n\n<pre><code>class GenProto[T](Protocol):\n    def meth(self) -&gt; T:\n        ...\n</code></pre>\n", "bases": "typing.Protocol"}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"fullname": "muutils.logger.headerfuncs.HeaderFunction.__init__", "modulename": "muutils.logger.headerfuncs", "qualname": "HeaderFunction.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.logger.headerfuncs.md_header_function": {"fullname": "muutils.logger.headerfuncs.md_header_function", "modulename": "muutils.logger.headerfuncs", "qualname": "md_header_function", "kind": "function", "doc": "<p>standard header function. will output</p>\n\n<ul>\n<li><p><code># {msg}</code></p>\n\n<pre><code>for levels in [0, 9]\n</code></pre></li>\n<li><p><code>## {msg}</code></p>\n\n<pre><code>for levels in [10, 19], and so on\n</code></pre></li>\n<li><p><code>[{stream}] # {msg}</code></p>\n\n<pre><code>for a non-`None` stream, with level headers as before\n</code></pre></li>\n<li><p><code>!WARNING! [{stream}] {msg}</code></p>\n\n<pre><code>for level in [-9, -1]\n</code></pre></li>\n<li><p><code>!!WARNING!! [{stream}] {msg}</code></p>\n\n<pre><code>for level in [-19, -10] and so on\n</code></pre></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">lvl</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent_lvl</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;  &#39;</span>,</span><span class=\"param\">\t<span class=\"n\">extra_indent</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.logger.headerfuncs.HEADER_FUNCTIONS": {"fullname": "muutils.logger.headerfuncs.HEADER_FUNCTIONS", "modulename": "muutils.logger.headerfuncs", "qualname": "HEADER_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, muutils.logger.headerfuncs.HeaderFunction]", "default_value": "{&#x27;md&#x27;: &lt;function md_header_function&gt;}"}, "muutils.logger.log_util": {"fullname": "muutils.logger.log_util", "modulename": "muutils.logger.log_util", "kind": "module", "doc": "<p></p>\n"}, "muutils.logger.log_util.get_any_from_stream": {"fullname": "muutils.logger.log_util.get_any_from_stream", "modulename": "muutils.logger.log_util", "qualname": "get_any_from_stream", "kind": "function", "doc": "<p>get the first value of a key from a stream. errors if not found</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.logger.log_util.gather_log": {"fullname": "muutils.logger.log_util.gather_log", "modulename": "muutils.logger.log_util", "qualname": "gather_log", "kind": "function", "doc": "<p>gathers and sorts all streams from a log</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.logger.log_util.gather_stream": {"fullname": "muutils.logger.log_util.gather_stream", "modulename": "muutils.logger.log_util", "qualname": "gather_stream", "kind": "function", "doc": "<p>gets all entries from a specific stream in a log file</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.logger.log_util.gather_val": {"fullname": "muutils.logger.log_util.gather_val", "modulename": "muutils.logger.log_util", "qualname": "gather_val", "kind": "function", "doc": "<p>gather specific keys from a specific stream in a log file</p>\n\n<p>example:\nif \"log.jsonl\" has contents:</p>\n\n<pre><code>{\"a\": 1, \"b\": 2, \"c\": 3, \"_stream\": \"s1\"}\n{\"a\": 4, \"b\": 5, \"c\": 6, \"_stream\": \"s1\"}\n{\"a\": 7, \"b\": 8, \"c\": 9, \"_stream\": \"s2\"}\n</code></pre>\n\n<p>then <code>gather_val(\"log.jsonl\", \"s1\", (\"a\", \"b\"))</code> will return</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">[</span>\n    <span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">],</span>\n    <span class=\"p\">[</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">]</span>\n<span class=\"p\">]</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">keys</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">allow_skip</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.logger.logger": {"fullname": "muutils.logger.logger", "modulename": "muutils.logger.logger", "kind": "module", "doc": "<p>logger with streams &amp; levels, and a timer context manager</p>\n\n<ul>\n<li><code>SimpleLogger</code> is an extremely simple logger that can write to both console and a file</li>\n<li><code>Logger</code> class handles levels in a slightly different way than default python <code>logging</code>,\nand also has \"streams\" which allow for different sorts of output in the same logger\nthis was mostly made with training models in mind and storing both metadata and loss</li>\n<li><code>TimerContext</code> is a context manager that can be used to time the duration of a block of code</li>\n</ul>\n"}, "muutils.logger.logger.decode_level": {"fullname": "muutils.logger.logger.decode_level", "modulename": "muutils.logger.logger", "qualname": "decode_level", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.logger.logger.Logger": {"fullname": "muutils.logger.logger.Logger", "modulename": "muutils.logger.logger", "qualname": "Logger", "kind": "class", "doc": "<p>logger with more features, including log levels and streams</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<pre><code>    - `log_path : str | None`\n    default log file path\n    (defaults to `None`)\n    - `log_file : AnyIO | None`\n    default log io, should have a `.write()` method (pass only this or `log_path`, not both)\n    (defaults to `None`)\n    - `timestamp : bool`\n    whether to add timestamps to every log message (under the `_timestamp` key)\n    (defaults to `True`)\n    - `default_level : int`\n    default log level for streams/messages that don't specify a level\n    (defaults to `0`)\n    - `console_print_threshold : int`\n    log level at which to print to the console, anything greater will not be printed unless overridden by `console_print`\n    (defaults to `50`)\n    - `level_header : HeaderFunction`\n    function for formatting log messages when printing to console\n    (defaults to `HEADER_FUNCTIONS[\"md\"]`)\n</code></pre>\n\n<p></p>\n\n<ul>\n<li><code>keep_last_msg_time : bool</code>\nwhether to keep the last message time\n(defaults to <code>True</code>)</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<pre><code>    - `ValueError` : _description_\n</code></pre>\n", "bases": "muutils.logger.simplelogger.SimpleLogger"}, "muutils.logger.logger.Logger.__init__": {"fullname": "muutils.logger.logger.Logger.__init__", "modulename": "muutils.logger.logger", "qualname": "Logger.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">log_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">log_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_level</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">console_print_threshold</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">50</span>,</span><span class=\"param\">\t<span class=\"n\">level_header</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">headerfuncs</span><span class=\"o\">.</span><span class=\"n\">HeaderFunction</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">function</span> <span class=\"n\">md_header_function</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">streams</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">loggingstream</span><span class=\"o\">.</span><span class=\"n\">LoggingStream</span><span class=\"p\">],</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">loggingstream</span><span class=\"o\">.</span><span class=\"n\">LoggingStream</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">()</span>,</span><span class=\"param\">\t<span class=\"n\">keep_last_msg_time</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">timestamp</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.logger.logger.Logger.log": {"fullname": "muutils.logger.logger.Logger.log", "modulename": "muutils.logger.logger", "qualname": "Logger.log", "kind": "function", "doc": "<p>logging function</p>\n\n<h3 id=\"parameters\">Parameters:</h3>\n\n<ul>\n<li><code>msg : JSONitem</code>\nmessage (usually string or dict) to be logged</li>\n<li><code>lvl : int | None</code>\nlevel of message (lower levels are more important)\n(defaults to <code>None</code>)</li>\n<li><code>console_print : bool</code>\noverride <code>console_print_threshold</code> setting\n(defaults to <code>False</code>)</li>\n<li><code>stream : str | None</code>\nwhether to log to a stream (defaults to <code>None</code>), which logs to the default <code>None</code> stream\n(defaults to <code>None</code>)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lvl</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">console_print</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">extra_indent</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.logger.logger.Logger.log_elapsed_last": {"fullname": "muutils.logger.logger.Logger.log_elapsed_last", "modulename": "muutils.logger.logger", "qualname": "Logger.log_elapsed_last", "kind": "function", "doc": "<p>logs the time elapsed since the last message was printed to the console (in any stream)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lvl</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">console_print</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.logger.logger.Logger.flush_all": {"fullname": "muutils.logger.logger.Logger.flush_all", "modulename": "muutils.logger.logger", "qualname": "Logger.flush_all", "kind": "function", "doc": "<p>flush all streams</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.logger.loggingstream": {"fullname": "muutils.logger.loggingstream", "modulename": "muutils.logger.loggingstream", "kind": "module", "doc": "<p></p>\n"}, "muutils.logger.loggingstream.LoggingStream": {"fullname": "muutils.logger.loggingstream.LoggingStream", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream", "kind": "class", "doc": "<p>properties of a logging stream</p>\n\n<ul>\n<li><code>name: str</code> name of the stream</li>\n<li><code>aliases: set[str]</code> aliases for the stream\n(calls to these names will be redirected to this stream. duplicate alises will result in errors)\nTODO: perhaps duplicate alises should result in duplicate writes?</li>\n<li><code>file: str|bool|AnyIO|None</code> file to write to\n<ul>\n<li>if <code>None</code>, will write to standard log</li>\n<li>if <code>True</code>, will write to <code>name + \".log\"</code></li>\n<li>if <code>False</code> will \"write\" to <code>NullIO</code> (throw it away)</li>\n<li>if a string, will write to that file</li>\n<li>if a fileIO type object, will write to that object</li>\n</ul></li>\n<li><code>default_level: int|None</code> default level for this stream</li>\n<li><code>default_contents: dict[str, Callable[[], Any]]</code> default contents for this stream</li>\n<li><code>last_msg: tuple[float, Any]|None</code> last message written to this stream (timestamp, message)</li>\n</ul>\n"}, "muutils.logger.loggingstream.LoggingStream.__init__": {"fullname": "muutils.logger.loggingstream.LoggingStream.__init__", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">aliases</span><span class=\"p\">:</span> <span class=\"nb\">set</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_level</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_contents</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">[[],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "muutils.logger.loggingstream.LoggingStream.name": {"fullname": "muutils.logger.loggingstream.LoggingStream.name", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None"}, "muutils.logger.loggingstream.LoggingStream.aliases": {"fullname": "muutils.logger.loggingstream.LoggingStream.aliases", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.aliases", "kind": "variable", "doc": "<p></p>\n", "annotation": ": set[str | None]"}, "muutils.logger.loggingstream.LoggingStream.file": {"fullname": "muutils.logger.loggingstream.LoggingStream.file", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[str, bool, TextIO, muutils.logger.simplelogger.NullIO, NoneType]", "default_value": "None"}, "muutils.logger.loggingstream.LoggingStream.default_level": {"fullname": "muutils.logger.loggingstream.LoggingStream.default_level", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.default_level", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int | None", "default_value": "None"}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"fullname": "muutils.logger.loggingstream.LoggingStream.default_contents", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.default_contents", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, typing.Callable[[], typing.Any]]"}, "muutils.logger.loggingstream.LoggingStream.handler": {"fullname": "muutils.logger.loggingstream.LoggingStream.handler", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.handler", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[TextIO, muutils.logger.simplelogger.NullIO, NoneType]", "default_value": "None"}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"fullname": "muutils.logger.loggingstream.LoggingStream.make_handler", "modulename": "muutils.logger.loggingstream", "qualname": "LoggingStream.make_handler", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.logger.simplelogger": {"fullname": "muutils.logger.simplelogger", "modulename": "muutils.logger.simplelogger", "kind": "module", "doc": "<p></p>\n"}, "muutils.logger.simplelogger.NullIO": {"fullname": "muutils.logger.simplelogger.NullIO", "modulename": "muutils.logger.simplelogger", "qualname": "NullIO", "kind": "class", "doc": "<p>null IO class</p>\n"}, "muutils.logger.simplelogger.NullIO.write": {"fullname": "muutils.logger.simplelogger.NullIO.write", "modulename": "muutils.logger.simplelogger", "qualname": "NullIO.write", "kind": "function", "doc": "<p>write to nothing! this throws away the message</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "muutils.logger.simplelogger.NullIO.flush": {"fullname": "muutils.logger.simplelogger.NullIO.flush", "modulename": "muutils.logger.simplelogger", "qualname": "NullIO.flush", "kind": "function", "doc": "<p>flush nothing! this is a no-op</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.logger.simplelogger.NullIO.close": {"fullname": "muutils.logger.simplelogger.NullIO.close", "modulename": "muutils.logger.simplelogger", "qualname": "NullIO.close", "kind": "function", "doc": "<p>close nothing! this is a no-op</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.logger.simplelogger.AnyIO": {"fullname": "muutils.logger.simplelogger.AnyIO", "modulename": "muutils.logger.simplelogger", "qualname": "AnyIO", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[typing.TextIO, muutils.logger.simplelogger.NullIO]"}, "muutils.logger.simplelogger.SimpleLogger": {"fullname": "muutils.logger.simplelogger.SimpleLogger", "modulename": "muutils.logger.simplelogger", "qualname": "SimpleLogger", "kind": "class", "doc": "<p>logs training data to a jsonl file</p>\n"}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"fullname": "muutils.logger.simplelogger.SimpleLogger.__init__", "modulename": "muutils.logger.simplelogger", "qualname": "SimpleLogger.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">log_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">log_file</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">TextIO</span><span class=\"p\">,</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">logger</span><span class=\"o\">.</span><span class=\"n\">simplelogger</span><span class=\"o\">.</span><span class=\"n\">NullIO</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">timestamp</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "muutils.logger.simplelogger.SimpleLogger.log": {"fullname": "muutils.logger.simplelogger.SimpleLogger.log", "modulename": "muutils.logger.simplelogger", "qualname": "SimpleLogger.log", "kind": "function", "doc": "<p>log a message to the log file, and optionally to the console</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">msg</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">console_print</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.logger.timing": {"fullname": "muutils.logger.timing", "modulename": "muutils.logger.timing", "kind": "module", "doc": "<p></p>\n"}, "muutils.logger.timing.TimerContext": {"fullname": "muutils.logger.timing.TimerContext", "modulename": "muutils.logger.timing", "qualname": "TimerContext", "kind": "class", "doc": "<p>context manager for timing code</p>\n"}, "muutils.logger.timing.TimerContext.start_time": {"fullname": "muutils.logger.timing.TimerContext.start_time", "modulename": "muutils.logger.timing", "qualname": "TimerContext.start_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.timing.TimerContext.end_time": {"fullname": "muutils.logger.timing.TimerContext.end_time", "modulename": "muutils.logger.timing", "qualname": "TimerContext.end_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.timing.TimerContext.elapsed_time": {"fullname": "muutils.logger.timing.TimerContext.elapsed_time", "modulename": "muutils.logger.timing", "qualname": "TimerContext.elapsed_time", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.timing.filter_time_str": {"fullname": "muutils.logger.timing.filter_time_str", "modulename": "muutils.logger.timing", "qualname": "filter_time_str", "kind": "function", "doc": "<p>assuming format <code>h:mm:ss</code>, clips off the hours if its 0</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">time</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.logger.timing.ProgressEstimator": {"fullname": "muutils.logger.timing.ProgressEstimator", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator", "kind": "class", "doc": "<p>estimates progress and can give a progress bar</p>\n"}, "muutils.logger.timing.ProgressEstimator.__init__": {"fullname": "muutils.logger.timing.ProgressEstimator.__init__", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">n_total</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pbar_fill</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;\u2588&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">pbar_empty</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; &#39;</span>,</span><span class=\"param\">\t<span class=\"n\">pbar_bounds</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"s1\">&#39;|&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;|&#39;</span><span class=\"p\">)</span></span>)</span>"}, "muutils.logger.timing.ProgressEstimator.n_total": {"fullname": "muutils.logger.timing.ProgressEstimator.n_total", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.n_total", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "muutils.logger.timing.ProgressEstimator.starttime": {"fullname": "muutils.logger.timing.ProgressEstimator.starttime", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.starttime", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.logger.timing.ProgressEstimator.pbar_fill": {"fullname": "muutils.logger.timing.ProgressEstimator.pbar_fill", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.pbar_fill", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"fullname": "muutils.logger.timing.ProgressEstimator.pbar_empty", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.pbar_empty", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"fullname": "muutils.logger.timing.ProgressEstimator.pbar_bounds", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.pbar_bounds", "kind": "variable", "doc": "<p></p>\n", "annotation": ": tuple[str, str]"}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"fullname": "muutils.logger.timing.ProgressEstimator.total_str_len", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.total_str_len", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"fullname": "muutils.logger.timing.ProgressEstimator.get_timing_raw", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.get_timing_raw", "kind": "function", "doc": "<p>returns dict(elapsed, per_iter, remaining, percent)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"fullname": "muutils.logger.timing.ProgressEstimator.get_pbar", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.get_pbar", "kind": "function", "doc": "<p>returns a progress bar</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">width</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">30</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"fullname": "muutils.logger.timing.ProgressEstimator.get_progress_default", "modulename": "muutils.logger.timing", "qualname": "ProgressEstimator.get_progress_default", "kind": "function", "doc": "<p>returns a progress string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.math": {"fullname": "muutils.math", "modulename": "muutils.math", "kind": "module", "doc": "<p></p>\n"}, "muutils.math.bins": {"fullname": "muutils.math.bins", "modulename": "muutils.math.bins", "kind": "module", "doc": "<p></p>\n"}, "muutils.math.bins.Bins": {"fullname": "muutils.math.bins.Bins", "modulename": "muutils.math.bins", "qualname": "Bins", "kind": "class", "doc": "<p></p>\n"}, "muutils.math.bins.Bins.__init__": {"fullname": "muutils.math.bins.Bins.__init__", "modulename": "muutils.math.bins", "qualname": "Bins.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">n_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">32</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">stop</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">scale</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;lin&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;log&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;log&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">_log_min</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.001</span>,</span><span class=\"param\">\t<span class=\"n\">_zero_in_small_start_log</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span>)</span>"}, "muutils.math.bins.Bins.n_bins": {"fullname": "muutils.math.bins.Bins.n_bins", "modulename": "muutils.math.bins", "qualname": "Bins.n_bins", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "32"}, "muutils.math.bins.Bins.start": {"fullname": "muutils.math.bins.Bins.start", "modulename": "muutils.math.bins", "qualname": "Bins.start", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float", "default_value": "0"}, "muutils.math.bins.Bins.stop": {"fullname": "muutils.math.bins.Bins.stop", "modulename": "muutils.math.bins", "qualname": "Bins.stop", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float", "default_value": "1.0"}, "muutils.math.bins.Bins.scale": {"fullname": "muutils.math.bins.Bins.scale", "modulename": "muutils.math.bins", "qualname": "Bins.scale", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;lin&#x27;, &#x27;log&#x27;]", "default_value": "&#x27;log&#x27;"}, "muutils.math.bins.Bins.edges": {"fullname": "muutils.math.bins.Bins.edges", "modulename": "muutils.math.bins", "qualname": "Bins.edges", "kind": "variable", "doc": "<p></p>\n", "annotation": ": jaxtyping.Float[ndarray, &#x27;n_bins+1&#x27;]"}, "muutils.math.bins.Bins.centers": {"fullname": "muutils.math.bins.Bins.centers", "modulename": "muutils.math.bins", "qualname": "Bins.centers", "kind": "variable", "doc": "<p></p>\n", "annotation": ": jaxtyping.Float[ndarray, &#x27;n_bins&#x27;]"}, "muutils.math.bins.Bins.changed_n_bins_copy": {"fullname": "muutils.math.bins.Bins.changed_n_bins_copy", "modulename": "muutils.math.bins", "qualname": "Bins.changed_n_bins_copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">n_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">math</span><span class=\"o\">.</span><span class=\"n\">bins</span><span class=\"o\">.</span><span class=\"n\">Bins</span>:</span></span>", "funcdef": "def"}, "muutils.math.matrix_powers": {"fullname": "muutils.math.matrix_powers", "modulename": "muutils.math.matrix_powers", "kind": "module", "doc": "<p></p>\n"}, "muutils.math.matrix_powers.matrix_powers": {"fullname": "muutils.math.matrix_powers.matrix_powers", "modulename": "muutils.math.matrix_powers", "qualname": "matrix_powers", "kind": "function", "doc": "<p>Compute multiple powers of a matrix efficiently.</p>\n\n<p>Uses binary exponentiation to compute powers in O(log max(powers))\nmatrix multiplications, avoiding redundant calculations when\ncomputing multiple powers.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>A : Float[np.ndarray, \"n n\"]</code>\nSquare matrix to exponentiate</li>\n<li><code>powers : Sequence[int]</code>\nList of powers to compute (non-negative integers)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>dict[int, Float[np.ndarray, \"n n\"]]</code>\nDictionary mapping each requested power to the corresponding matrix power</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">A</span><span class=\"p\">:</span> <span class=\"n\">jaxtyping</span><span class=\"o\">.</span><span class=\"n\">Float</span><span class=\"p\">[</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"s1\">&#39;n n&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">powers</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">jaxtyping</span><span class=\"o\">.</span><span class=\"n\">Float</span><span class=\"p\">[</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"s1\">&#39;n_powers n n&#39;</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.math.matrix_powers.matrix_powers_torch": {"fullname": "muutils.math.matrix_powers.matrix_powers_torch", "modulename": "muutils.math.matrix_powers", "qualname": "matrix_powers_torch", "kind": "function", "doc": "<p>Compute multiple powers of a matrix efficiently.</p>\n\n<p>Uses binary exponentiation to compute powers in O(log max(powers))\nmatrix multiplications, avoiding redundant calculations when\ncomputing multiple powers.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>A : Float[torch.Tensor, \"n n\"]</code>\nSquare matrix to exponentiate</li>\n<li><code>powers : Sequence[int]</code>\nList of powers to compute (non-negative integers)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Float[torch.Tensor, \"n_powers n n\"]</code>\nTensor containing the requested matrix powers stacked along the first dimension</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> : If no powers are requested or if A is not a square matrix</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">A</span>, </span><span class=\"param\"><span class=\"n\">powers</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc": {"fullname": "muutils.misc", "modulename": "muutils.misc", "kind": "module", "doc": "<p>miscellaneous utilities</p>\n\n<ul>\n<li><code>stable_hash</code> for hashing that is stable across runs</li>\n<li><code>muutils.misc.sequence</code> for sequence manipulation, applying mappings, and string-like operations on lists</li>\n<li><code>muutils.misc.string</code> for sanitizing things for filenames, adjusting docstrings, and converting dicts to filenames</li>\n<li><code>muutils.misc.numerical</code> for turning numbers into nice strings and back</li>\n<li><code>muutils.misc.freezing</code> for freezing things</li>\n<li><code>muutils.misc.classes</code> for some weird class utilities</li>\n</ul>\n"}, "muutils.misc.stable_hash": {"fullname": "muutils.misc.stable_hash", "modulename": "muutils.misc", "qualname": "stable_hash", "kind": "function", "doc": "<p>Returns a stable hash of the given string. not cryptographically secure, but stable between runs</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">s</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bytes</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "muutils.misc.WhenMissing": {"fullname": "muutils.misc.WhenMissing", "modulename": "muutils.misc", "qualname": "WhenMissing", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;except&#x27;, &#x27;skip&#x27;, &#x27;include&#x27;]"}, "muutils.misc.empty_sequence_if_attr_false": {"fullname": "muutils.misc.empty_sequence_if_attr_false", "modulename": "muutils.misc", "qualname": "empty_sequence_if_attr_false", "kind": "function", "doc": "<p>Returns <code>itr</code> if <code>attr_owner</code> has the attribute <code>attr_name</code> and it boolean casts to <code>True</code>. Returns an empty sequence otherwise.</p>\n\n<p>Particularly useful for optionally inserting delimiters into a sequence depending on an <code>TokenizerElement</code> attribute.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>itr: Iterable[Any]</code>\nThe iterable to return if the attribute is <code>True</code>.</li>\n<li><code>attr_owner: Any</code>\nThe object to check for the attribute.</li>\n<li><code>attr_name: str</code>\nThe name of the attribute to check.</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>itr: Iterable</code> if <code>attr_owner</code> has the attribute <code>attr_name</code> and it boolean casts to <code>True</code>, otherwise an empty sequence.</li>\n<li><code>()</code> an empty sequence if the attribute is <code>False</code> or not present.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">itr</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">attr_owner</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">attr_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.flatten": {"fullname": "muutils.misc.flatten", "modulename": "muutils.misc", "qualname": "flatten", "kind": "function", "doc": "<p>Flattens an arbitrarily nested iterable.\nFlattens all iterable data types except for <code>str</code> and <code>bytes</code>.</p>\n\n<h1 id=\"returns\">Returns</h1>\n\n<p>Generator over the flattened sequence.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>it</code>: Any arbitrarily nested iterable.</li>\n<li><code>levels_to_flatten</code>: Number of levels to flatten by, starting at the outermost layer. If <code>None</code>, performs full flattening.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">it</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">levels_to_flatten</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Generator</span>:</span></span>", "funcdef": "def"}, "muutils.misc.list_split": {"fullname": "muutils.misc.list_split", "modulename": "muutils.misc", "qualname": "list_split", "kind": "function", "doc": "<p>split a list into sublists by <code>val</code>. similar to \"a_b_c\".split(\"_\")</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">4</span><span class=\"p\">,</span><span class=\"mi\">5</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">6</span><span class=\"p\">],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">6</span><span class=\"p\">]]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[],</span> <span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">]]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">]]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[]]</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lst</span><span class=\"p\">:</span> <span class=\"nb\">list</span>, </span><span class=\"param\"><span class=\"n\">val</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.list_join": {"fullname": "muutils.misc.list_join", "modulename": "muutils.misc", "qualname": "list_join", "kind": "function", "doc": "<p>add a <em>new</em> instance of <code>factory()</code> between each element of <code>lst</code></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_join</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"k\">lambda</span> <span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_join</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"k\">lambda</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">),</span> <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">time</span><span class=\"p\">()][</span><span class=\"mi\">1</span><span class=\"p\">])</span>\n<span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mf\">1600000000.0</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mf\">1600000000.1</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lst</span><span class=\"p\">:</span> <span class=\"nb\">list</span>, </span><span class=\"param\"><span class=\"n\">factory</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "muutils.misc.apply_mapping": {"fullname": "muutils.misc.apply_mapping", "modulename": "muutils.misc", "qualname": "apply_mapping", "kind": "function", "doc": "<p>Given an iterable and a mapping, apply the mapping to the iterable with certain options</p>\n\n<p>Gotcha: if <code>when_missing</code> is invalid, this is totally fine until a missing key is actually encountered.</p>\n\n<p>Note: you can use this with <code>muutils.kappa.Kappa</code> if you want to pass a function instead of a dict</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>mapping : Mapping[_AM_K, _AM_V]</code>\nmust have <code>__contains__</code> and <code>__getitem__</code>, both of which take <code>_AM_K</code> and the latter returns <code>_AM_V</code></li>\n<li><code>iter : Iterable[_AM_K]</code>\nthe iterable to apply the mapping to</li>\n<li><code>when_missing : WhenMissing</code>\n what to do when a key is missing from the mapping -- this is what distinguishes this function from <code>map</code>\n you can choose from <code>\"skip\"</code>, <code>\"include\"</code> (without converting), and <code>\"except\"</code>\n(defaults to <code>\"skip\"</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<p>return type is one of:</p>\n\n<ul>\n<li><code>list[_AM_V]</code> if <code>when_missing</code> is <code>\"skip\"</code> or <code>\"except\"</code></li>\n<li><code>list[Union[_AM_K, _AM_V]]</code> if <code>when_missing</code> is <code>\"include\"</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>KeyError</code> : if the item is missing from the mapping and <code>when_missing</code> is <code>\"except\"</code></li>\n<li><code>ValueError</code> : if <code>when_missing</code> is invalid</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"n\">Mapping</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"nb\">iter</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">when_missing</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;except&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;skip&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;include&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;skip&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.apply_mapping_chain": {"fullname": "muutils.misc.apply_mapping_chain", "modulename": "muutils.misc", "qualname": "apply_mapping_chain", "kind": "function", "doc": "<p>Given an iterable and a mapping, chain the mappings together</p>\n\n<p>Gotcha: if <code>when_missing</code> is invalid, this is totally fine until a missing key is actually encountered.</p>\n\n<p>Note: you can use this with <code>muutils.kappa.Kappa</code> if you want to pass a function instead of a dict</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>mapping : Mapping[_AM_K, Iterable[_AM_V]]</code>\nmust have <code>__contains__</code> and <code>__getitem__</code>, both of which take <code>_AM_K</code> and the latter returns <code>Iterable[_AM_V]</code></li>\n<li><code>iter : Iterable[_AM_K]</code>\nthe iterable to apply the mapping to</li>\n<li><code>when_missing : WhenMissing</code>\nwhat to do when a key is missing from the mapping -- this is what distinguishes this function from <code>map</code>\nyou can choose from <code>\"skip\"</code>, <code>\"include\"</code> (without converting), and <code>\"except\"</code>\n(defaults to <code>\"skip\"</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<p>return type is one of:</p>\n\n<ul>\n<li><code>list[_AM_V]</code> if <code>when_missing</code> is <code>\"skip\"</code> or <code>\"except\"</code></li>\n<li><code>list[Union[_AM_K, _AM_V]]</code> if <code>when_missing</code> is <code>\"include\"</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>KeyError</code> : if the item is missing from the mapping and <code>when_missing</code> is <code>\"except\"</code></li>\n<li><code>ValueError</code> : if <code>when_missing</code> is invalid</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"n\">Mapping</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"nb\">iter</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">when_missing</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;except&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;skip&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;include&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;skip&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sanitize_name": {"fullname": "muutils.misc.sanitize_name", "modulename": "muutils.misc", "qualname": "sanitize_name", "kind": "function", "doc": "<p>sanitize a string, leaving only alphanumerics and <code>additional_allowed_chars</code></p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>name : str | None</code>\ninput string</li>\n<li><code>additional_allowed_chars : str</code>\nadditional characters to allow, none by default\n(defaults to <code>\"\"</code>)</li>\n<li><code>replace_invalid : str</code>\n character to replace invalid characters with\n(defaults to <code>\"\"</code>)</li>\n<li><code>when_none : str | None</code>\n string to return if <code>name</code> is <code>None</code>. if <code>None</code>, raises an exception\n(defaults to <code>\"_None_\"</code>)</li>\n<li><code>leading_digit_prefix : str</code>\n character to prefix the string with if it starts with a digit\n(defaults to <code>\"\"</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>str</code>\nsanitized string</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">additional_allowed_chars</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">replace_invalid</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">when_none</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;_None_&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">leading_digit_prefix</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sanitize_fname": {"fullname": "muutils.misc.sanitize_fname", "modulename": "muutils.misc", "qualname": "sanitize_fname", "kind": "function", "doc": "<p>sanitize a filename to posix standards</p>\n\n<ul>\n<li>leave only alphanumerics, <code>_</code> (underscore), '-' (dash) and <code>.</code> (period)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sanitize_identifier": {"fullname": "muutils.misc.sanitize_identifier", "modulename": "muutils.misc", "qualname": "sanitize_identifier", "kind": "function", "doc": "<p>sanitize an identifier (variable or function name)</p>\n\n<ul>\n<li>leave only alphanumerics and <code>_</code> (underscore)</li>\n<li>prefix with <code>_</code> if it starts with a digit</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.dict_to_filename": {"fullname": "muutils.misc.dict_to_filename", "modulename": "muutils.misc", "qualname": "dict_to_filename", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">format_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"si\">{key}</span><span class=\"s1\">_</span><span class=\"si\">{val}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">separator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">max_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">255</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.dynamic_docstring": {"fullname": "muutils.misc.dynamic_docstring", "modulename": "muutils.misc", "qualname": "dynamic_docstring", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">**</span><span class=\"n\">doc_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.shorten_numerical_to_str": {"fullname": "muutils.misc.shorten_numerical_to_str", "modulename": "muutils.misc", "qualname": "shorten_numerical_to_str", "kind": "function", "doc": "<p>shorten a large numerical value to a string\n1234 -> 1K</p>\n\n<p>precision guaranteed to 1 in 10, but can be higher. reverse of <code>str_to_numeric</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">num</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">small_as_decimal</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">precision</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.str_to_numeric": {"fullname": "muutils.misc.str_to_numeric", "modulename": "muutils.misc", "qualname": "str_to_numeric", "kind": "function", "doc": "<p>Convert a string representing a quantity to a numeric value.</p>\n\n<p>The string can represent an integer, python float, fraction, or shortened via <code>shorten_numerical_to_str</code>.</p>\n\n<h1 id=\"examples\">Examples:</h1>\n\n<pre><code>&gt;&gt;&gt; str_to_numeric(\"5\")\n5\n&gt;&gt;&gt; str_to_numeric(\"0.1\")\n0.1\n&gt;&gt;&gt; str_to_numeric(\"1/5\")\n0.2\n&gt;&gt;&gt; str_to_numeric(\"-1K\")\n-1000.0\n&gt;&gt;&gt; str_to_numeric(\"1.5M\")\n1500000.0\n&gt;&gt;&gt; str_to_numeric(\"1.2e2\")\n120.0\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">quantity</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.misc.FrozenDict": {"fullname": "muutils.misc.FrozenDict", "modulename": "muutils.misc", "qualname": "FrozenDict", "kind": "class", "doc": "<p></p>\n", "bases": "builtins.dict"}, "muutils.misc.FrozenList": {"fullname": "muutils.misc.FrozenList", "modulename": "muutils.misc", "qualname": "FrozenList", "kind": "class", "doc": "<p>Built-in mutable sequence.</p>\n\n<p>If no argument is given, the constructor creates a new empty list.\nThe argument must be an iterable if specified.</p>\n", "bases": "builtins.list"}, "muutils.misc.FrozenList.append": {"fullname": "muutils.misc.FrozenList.append", "modulename": "muutils.misc", "qualname": "FrozenList.append", "kind": "function", "doc": "<p>Append object to the end of the list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.FrozenList.extend": {"fullname": "muutils.misc.FrozenList.extend", "modulename": "muutils.misc", "qualname": "FrozenList.extend", "kind": "function", "doc": "<p>Extend list by appending elements from the iterable.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">iterable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.FrozenList.insert": {"fullname": "muutils.misc.FrozenList.insert", "modulename": "muutils.misc", "qualname": "FrozenList.insert", "kind": "function", "doc": "<p>Insert object before index.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.FrozenList.remove": {"fullname": "muutils.misc.FrozenList.remove", "modulename": "muutils.misc", "qualname": "FrozenList.remove", "kind": "function", "doc": "<p>Remove first occurrence of value.</p>\n\n<p>Raises ValueError if the value is not present.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.FrozenList.pop": {"fullname": "muutils.misc.FrozenList.pop", "modulename": "muutils.misc", "qualname": "FrozenList.pop", "kind": "function", "doc": "<p>Remove and return item at index (default last).</p>\n\n<p>Raises IndexError if list is empty or index is out of range.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"o\">=-</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.FrozenList.clear": {"fullname": "muutils.misc.FrozenList.clear", "modulename": "muutils.misc", "qualname": "FrozenList.clear", "kind": "function", "doc": "<p>Remove all items from list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freeze": {"fullname": "muutils.misc.freeze", "modulename": "muutils.misc", "qualname": "freeze", "kind": "function", "doc": "<p>recursively freeze an object in-place so that its attributes and elements cannot be changed</p>\n\n<p>messy in the sense that sometimes the object is modified in place, but you can't rely on that. always use the return value.</p>\n\n<p>the <a href=\"https://github.com/diegojromerolopez/gelidum/\">gelidum</a> package is a more complete implementation of this idea</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">instance</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "muutils.misc.is_abstract": {"fullname": "muutils.misc.is_abstract", "modulename": "muutils.misc", "qualname": "is_abstract", "kind": "function", "doc": "<p>Returns if a class is abstract.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"nb\">type</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.get_all_subclasses": {"fullname": "muutils.misc.get_all_subclasses", "modulename": "muutils.misc", "qualname": "get_all_subclasses", "kind": "function", "doc": "<p>Returns a set containing all child classes in the subclass graph of <code>class_</code>.\nI.e., includes subclasses of subclasses, etc.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>include_self</code>: Whether to include <code>class_</code> itself in the returned set</li>\n<li><code>class_</code>: Superclass</li>\n</ul>\n\n<h1 id=\"development\">Development</h1>\n\n<p>Since most class hierarchies are small, the inefficiencies of the existing recursive implementation aren't problematic.\nIt might be valuable to refactor with memoization if the need arises to use this function on a very large class hierarchy.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">class_</span><span class=\"p\">:</span> <span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">include_self</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">set</span><span class=\"p\">[</span><span class=\"nb\">type</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.isinstance_by_type_name": {"fullname": "muutils.misc.isinstance_by_type_name", "modulename": "muutils.misc", "qualname": "isinstance_by_type_name", "kind": "function", "doc": "<p>Behaves like stdlib <code>isinstance</code> except it accepts a string representation of the type rather than the type itself.\nThis is a hacky function intended to circumvent the need to import a type into a module.\nIt is susceptible to type name collisions.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<p><code>o</code>: Object (not the type itself) whose type to interrogate\n<code>type_name</code>: The string returned by <code>type_.__name__</code>.\nGeneric types are not supported, only types that would appear in <code>type_.__mro__</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">o</span><span class=\"p\">:</span> <span class=\"nb\">object</span>, </span><span class=\"param\"><span class=\"n\">type_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.IsDataclass": {"fullname": "muutils.misc.IsDataclass", "modulename": "muutils.misc", "qualname": "IsDataclass", "kind": "class", "doc": "<p>Base class for protocol classes.</p>\n\n<p>Protocol classes are defined as::</p>\n\n<pre><code>class Proto(Protocol):\n    def meth(self) -&gt; int:\n        ...\n</code></pre>\n\n<p>Such classes are primarily used with static type checkers that recognize\nstructural subtyping (static duck-typing).</p>\n\n<p>For example::</p>\n\n<pre><code>class C:\n    def meth(self) -&gt; int:\n        return 0\n\ndef func(x: Proto) -&gt; int:\n    return x.meth()\n\nfunc(C())  # Passes static type check\n</code></pre>\n\n<p>See PEP 544 for details. Protocol classes decorated with\n@typing.runtime_checkable act as simple-minded runtime protocols that check\nonly the presence of given attributes, ignoring their type signatures.\nProtocol classes can be generic, they are defined as::</p>\n\n<pre><code>class GenProto[T](Protocol):\n    def meth(self) -&gt; T:\n        ...\n</code></pre>\n", "bases": "typing.Protocol"}, "muutils.misc.IsDataclass.__init__": {"fullname": "muutils.misc.IsDataclass.__init__", "modulename": "muutils.misc", "qualname": "IsDataclass.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.misc.get_hashable_eq_attrs": {"fullname": "muutils.misc.get_hashable_eq_attrs", "modulename": "muutils.misc", "qualname": "get_hashable_eq_attrs", "kind": "function", "doc": "<p>Returns a tuple of all fields used for equality comparison, including the type of the dataclass itself.\nThe type is included to preserve the unequal equality behavior of instances of different dataclasses whose fields are identical.\nEssentially used to generate a hashable dataclass representation for equality comparison even if it's not frozen.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dc</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">misc</span><span class=\"o\">.</span><span class=\"n\">classes</span><span class=\"o\">.</span><span class=\"n\">IsDataclass</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.dataclass_set_equals": {"fullname": "muutils.misc.dataclass_set_equals", "modulename": "muutils.misc", "qualname": "dataclass_set_equals", "kind": "function", "doc": "<p>Compares 2 collections of dataclass instances as if they were sets.\nDuplicates are ignored in the same manner as a set.\nUnfrozen dataclasses can't be placed in sets since they're not hashable.\nCollections of them may be compared using this function.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">coll1</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">misc</span><span class=\"o\">.</span><span class=\"n\">classes</span><span class=\"o\">.</span><span class=\"n\">IsDataclass</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">coll2</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">misc</span><span class=\"o\">.</span><span class=\"n\">classes</span><span class=\"o\">.</span><span class=\"n\">IsDataclass</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.classes": {"fullname": "muutils.misc.classes", "modulename": "muutils.misc.classes", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.classes.is_abstract": {"fullname": "muutils.misc.classes.is_abstract", "modulename": "muutils.misc.classes", "qualname": "is_abstract", "kind": "function", "doc": "<p>Returns if a class is abstract.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span><span class=\"p\">:</span> <span class=\"nb\">type</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.classes.get_all_subclasses": {"fullname": "muutils.misc.classes.get_all_subclasses", "modulename": "muutils.misc.classes", "qualname": "get_all_subclasses", "kind": "function", "doc": "<p>Returns a set containing all child classes in the subclass graph of <code>class_</code>.\nI.e., includes subclasses of subclasses, etc.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>include_self</code>: Whether to include <code>class_</code> itself in the returned set</li>\n<li><code>class_</code>: Superclass</li>\n</ul>\n\n<h1 id=\"development\">Development</h1>\n\n<p>Since most class hierarchies are small, the inefficiencies of the existing recursive implementation aren't problematic.\nIt might be valuable to refactor with memoization if the need arises to use this function on a very large class hierarchy.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">class_</span><span class=\"p\">:</span> <span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">include_self</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">set</span><span class=\"p\">[</span><span class=\"nb\">type</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.classes.isinstance_by_type_name": {"fullname": "muutils.misc.classes.isinstance_by_type_name", "modulename": "muutils.misc.classes", "qualname": "isinstance_by_type_name", "kind": "function", "doc": "<p>Behaves like stdlib <code>isinstance</code> except it accepts a string representation of the type rather than the type itself.\nThis is a hacky function intended to circumvent the need to import a type into a module.\nIt is susceptible to type name collisions.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<p><code>o</code>: Object (not the type itself) whose type to interrogate\n<code>type_name</code>: The string returned by <code>type_.__name__</code>.\nGeneric types are not supported, only types that would appear in <code>type_.__mro__</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">o</span><span class=\"p\">:</span> <span class=\"nb\">object</span>, </span><span class=\"param\"><span class=\"n\">type_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.classes.IsDataclass": {"fullname": "muutils.misc.classes.IsDataclass", "modulename": "muutils.misc.classes", "qualname": "IsDataclass", "kind": "class", "doc": "<p>Base class for protocol classes.</p>\n\n<p>Protocol classes are defined as::</p>\n\n<pre><code>class Proto(Protocol):\n    def meth(self) -&gt; int:\n        ...\n</code></pre>\n\n<p>Such classes are primarily used with static type checkers that recognize\nstructural subtyping (static duck-typing).</p>\n\n<p>For example::</p>\n\n<pre><code>class C:\n    def meth(self) -&gt; int:\n        return 0\n\ndef func(x: Proto) -&gt; int:\n    return x.meth()\n\nfunc(C())  # Passes static type check\n</code></pre>\n\n<p>See PEP 544 for details. Protocol classes decorated with\n@typing.runtime_checkable act as simple-minded runtime protocols that check\nonly the presence of given attributes, ignoring their type signatures.\nProtocol classes can be generic, they are defined as::</p>\n\n<pre><code>class GenProto[T](Protocol):\n    def meth(self) -&gt; T:\n        ...\n</code></pre>\n", "bases": "typing.Protocol"}, "muutils.misc.classes.IsDataclass.__init__": {"fullname": "muutils.misc.classes.IsDataclass.__init__", "modulename": "muutils.misc.classes", "qualname": "IsDataclass.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.misc.classes.get_hashable_eq_attrs": {"fullname": "muutils.misc.classes.get_hashable_eq_attrs", "modulename": "muutils.misc.classes", "qualname": "get_hashable_eq_attrs", "kind": "function", "doc": "<p>Returns a tuple of all fields used for equality comparison, including the type of the dataclass itself.\nThe type is included to preserve the unequal equality behavior of instances of different dataclasses whose fields are identical.\nEssentially used to generate a hashable dataclass representation for equality comparison even if it's not frozen.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dc</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">misc</span><span class=\"o\">.</span><span class=\"n\">classes</span><span class=\"o\">.</span><span class=\"n\">IsDataclass</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.classes.dataclass_set_equals": {"fullname": "muutils.misc.classes.dataclass_set_equals", "modulename": "muutils.misc.classes", "qualname": "dataclass_set_equals", "kind": "function", "doc": "<p>Compares 2 collections of dataclass instances as if they were sets.\nDuplicates are ignored in the same manner as a set.\nUnfrozen dataclasses can't be placed in sets since they're not hashable.\nCollections of them may be compared using this function.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">coll1</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">misc</span><span class=\"o\">.</span><span class=\"n\">classes</span><span class=\"o\">.</span><span class=\"n\">IsDataclass</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">coll2</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">misc</span><span class=\"o\">.</span><span class=\"n\">classes</span><span class=\"o\">.</span><span class=\"n\">IsDataclass</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.freezing": {"fullname": "muutils.misc.freezing", "modulename": "muutils.misc.freezing", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.freezing.FrozenDict": {"fullname": "muutils.misc.freezing.FrozenDict", "modulename": "muutils.misc.freezing", "qualname": "FrozenDict", "kind": "class", "doc": "<p></p>\n", "bases": "builtins.dict"}, "muutils.misc.freezing.FrozenList": {"fullname": "muutils.misc.freezing.FrozenList", "modulename": "muutils.misc.freezing", "qualname": "FrozenList", "kind": "class", "doc": "<p>Built-in mutable sequence.</p>\n\n<p>If no argument is given, the constructor creates a new empty list.\nThe argument must be an iterable if specified.</p>\n", "bases": "builtins.list"}, "muutils.misc.freezing.FrozenList.append": {"fullname": "muutils.misc.freezing.FrozenList.append", "modulename": "muutils.misc.freezing", "qualname": "FrozenList.append", "kind": "function", "doc": "<p>Append object to the end of the list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freezing.FrozenList.extend": {"fullname": "muutils.misc.freezing.FrozenList.extend", "modulename": "muutils.misc.freezing", "qualname": "FrozenList.extend", "kind": "function", "doc": "<p>Extend list by appending elements from the iterable.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">iterable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freezing.FrozenList.insert": {"fullname": "muutils.misc.freezing.FrozenList.insert", "modulename": "muutils.misc.freezing", "qualname": "FrozenList.insert", "kind": "function", "doc": "<p>Insert object before index.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freezing.FrozenList.remove": {"fullname": "muutils.misc.freezing.FrozenList.remove", "modulename": "muutils.misc.freezing", "qualname": "FrozenList.remove", "kind": "function", "doc": "<p>Remove first occurrence of value.</p>\n\n<p>Raises ValueError if the value is not present.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freezing.FrozenList.pop": {"fullname": "muutils.misc.freezing.FrozenList.pop", "modulename": "muutils.misc.freezing", "qualname": "FrozenList.pop", "kind": "function", "doc": "<p>Remove and return item at index (default last).</p>\n\n<p>Raises IndexError if list is empty or index is out of range.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"o\">=-</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freezing.FrozenList.clear": {"fullname": "muutils.misc.freezing.FrozenList.clear", "modulename": "muutils.misc.freezing", "qualname": "FrozenList.clear", "kind": "function", "doc": "<p>Remove all items from list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.freezing.freeze": {"fullname": "muutils.misc.freezing.freeze", "modulename": "muutils.misc.freezing", "qualname": "freeze", "kind": "function", "doc": "<p>recursively freeze an object in-place so that its attributes and elements cannot be changed</p>\n\n<p>messy in the sense that sometimes the object is modified in place, but you can't rely on that. always use the return value.</p>\n\n<p>the <a href=\"https://github.com/diegojromerolopez/gelidum/\">gelidum</a> package is a more complete implementation of this idea</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">instance</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func": {"fullname": "muutils.misc.func", "modulename": "muutils.misc.func", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.func.FuncParams": {"fullname": "muutils.misc.func.FuncParams", "modulename": "muutils.misc.func", "qualname": "FuncParams", "kind": "variable", "doc": "<p></p>\n", "default_value": "~FuncParams"}, "muutils.misc.func.FuncParamsPreWrap": {"fullname": "muutils.misc.func.FuncParamsPreWrap", "modulename": "muutils.misc.func", "qualname": "FuncParamsPreWrap", "kind": "variable", "doc": "<p></p>\n", "default_value": "~FuncParamsPreWrap"}, "muutils.misc.func.process_kwarg": {"fullname": "muutils.misc.func.process_kwarg", "modulename": "muutils.misc.func", "qualname": "process_kwarg", "kind": "function", "doc": "<p>Decorator that applies a processor to a keyword argument.</p>\n\n<p>The underlying function is expected to have a keyword argument\n(with name <code>kwarg_name</code>) of type <code>T_out</code>, but the caller provides\na value of type <code>T_in</code> that is converted via <code>processor</code>.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>kwarg_name : str</code>\nThe name of the keyword argument to process.</li>\n<li><code>processor : Callable[[T_in], T_out]</code>\nA callable that converts the input value (<code>T_in</code>) into the\ntype expected by the function (<code>T_out</code>).</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li>A decorator that converts a function of type\n<code>Callable[OutputParams, ReturnType]</code> (expecting <code>kwarg_name</code> of type <code>T_out</code>)\ninto one of type <code>Callable[InputParams, ReturnType]</code> (accepting <code>kwarg_name</code> of type <code>T_in</code>).</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">kwarg_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">processor</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">T_process_in</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">T_process_out</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParamsPreWrap</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]],</span> <span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.validate_kwarg": {"fullname": "muutils.misc.func.validate_kwarg", "modulename": "muutils.misc.func", "qualname": "validate_kwarg", "kind": "function", "doc": "<p>Decorator that validates a specific keyword argument.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>kwarg_name : str</code>\nThe name of the keyword argument to validate.</li>\n<li><code>validator : Callable[[Any], bool]</code>\nA callable that returns True if the keyword argument is valid.</li>\n<li><code>description : str | None</code>\nA message template if validation fails.</li>\n<li><code>action : str</code>\nEither <code>\"raise\"</code> (default) or <code>\"warn\"</code>.</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Callable[[Callable[FuncParams, ReturnType]], Callable[FuncParams, ReturnType]]</code>\nA decorator that validates the keyword argument.</li>\n</ul>\n\n<h1 id=\"modifies\">Modifies:</h1>\n\n<ul>\n<li>If validation fails and <code>action==\"warn\"</code>, emits a warning.\nOtherwise, raises a ValueError.</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@validate_kwarg</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">,</span> <span class=\"k\">lambda</span> <span class=\"n\">val</span><span class=\"p\">:</span> <span class=\"n\">val</span> <span class=\"o\">&gt;</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Invalid </span><span class=\"si\">{kwarg_name}</span><span class=\"s2\">: </span><span class=\"si\">{value}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">my_func</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">int</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"nb\">int</span><span class=\"p\">:</span>\n    <span class=\"k\">return</span> <span class=\"n\">x</span>\n\n<span class=\"k\">assert</span> <span class=\"n\">my_func</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">)</span> <span class=\"o\">==</span> <span class=\"mi\">1</span>\n</code></pre>\n</div>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> if validation fails and <code>action == \"raise\"</code>.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">kwarg_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">validator</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">T_kwarg</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">action</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]],</span> <span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.replace_kwarg": {"fullname": "muutils.misc.func.replace_kwarg", "modulename": "muutils.misc.func", "qualname": "replace_kwarg", "kind": "function", "doc": "<p>Decorator that replaces a specific keyword argument value by identity comparison.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>kwarg_name : str</code>\nThe name of the keyword argument to replace.</li>\n<li><code>check : Callable[[T_kwarg], bool]</code>\nA callable that returns True if the keyword argument should be replaced.</li>\n<li><code>replacement_value : T_kwarg</code>\nThe value to replace with.</li>\n<li><code>replace_if_missing : bool</code>\nIf True, replaces the keyword argument even if it's missing.</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Callable[[Callable[FuncParams, ReturnType]], Callable[FuncParams, ReturnType]]</code>\nA decorator that replaces the keyword argument value.</li>\n</ul>\n\n<h1 id=\"modifies\">Modifies:</h1>\n\n<ul>\n<li>Updates <code>kwargs[kwarg_name]</code> if its value is <code>default_value</code>.</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@replace_kwarg</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">,</span> <span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"s2\">&quot;default_string&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">my_func</span><span class=\"p\">(</span><span class=\"o\">*</span><span class=\"p\">,</span> <span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"nb\">str</span><span class=\"p\">:</span>\n    <span class=\"k\">return</span> <span class=\"n\">x</span>\n\n<span class=\"k\">assert</span> <span class=\"n\">my_func</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">)</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;default_string&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">kwarg_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">check</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">T_kwarg</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">replacement_value</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">T_kwarg</span>,</span><span class=\"param\">\t<span class=\"n\">replace_if_missing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]],</span> <span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.is_none": {"fullname": "muutils.misc.func.is_none", "modulename": "muutils.misc.func", "qualname": "is_none", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.always_true": {"fullname": "muutils.misc.func.always_true", "modulename": "muutils.misc.func", "qualname": "always_true", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.always_false": {"fullname": "muutils.misc.func.always_false", "modulename": "muutils.misc.func", "qualname": "always_false", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.format_docstring": {"fullname": "muutils.misc.func.format_docstring", "modulename": "muutils.misc.func", "qualname": "format_docstring", "kind": "function", "doc": "<p>Decorator that formats a function's docstring with the provided keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">fmt_kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]],</span> <span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">FuncParams</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.func.LambdaArgs": {"fullname": "muutils.misc.func.LambdaArgs", "modulename": "muutils.misc.func", "qualname": "LambdaArgs", "kind": "variable", "doc": "<p></p>\n", "default_value": "LambdaArgs"}, "muutils.misc.func.typed_lambda": {"fullname": "muutils.misc.func.typed_lambda", "modulename": "muutils.misc.func", "qualname": "typed_lambda", "kind": "function", "doc": "<p>Wraps a lambda function with type hints.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>fn : Callable[[Unpack[LambdaArgs]], ReturnType]</code>\nThe lambda function to wrap.</li>\n<li><code>in_types : tuple[type, ...]</code>\nTuple of input types.</li>\n<li><code>out_type : type[ReturnType]</code>\nThe output type.</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Callable[..., ReturnType]</code>\nA new function with annotations matching the given signature.</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">add</span> <span class=\"o\">=</span> <span class=\"n\">typed_lambda</span><span class=\"p\">(</span><span class=\"k\">lambda</span> <span class=\"n\">x</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"n\">x</span> <span class=\"o\">+</span> <span class=\"n\">y</span><span class=\"p\">,</span> <span class=\"p\">(</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">),</span> <span class=\"nb\">int</span><span class=\"p\">)</span>\n<span class=\"k\">assert</span> <span class=\"n\">add</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">)</span> <span class=\"o\">==</span> <span class=\"mi\">3</span>\n</code></pre>\n</div>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> if the number of input types doesn't match the lambda's parameters.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">fn</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">LambdaArgs</span><span class=\"p\">]],</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">in_types</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">LambdaArgsTypes</span>,</span><span class=\"param\">\t<span class=\"n\">out_type</span><span class=\"p\">:</span> <span class=\"nb\">type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">LambdaArgs</span><span class=\"p\">]],</span> <span class=\"o\">~</span><span class=\"n\">ReturnType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.hashing": {"fullname": "muutils.misc.hashing", "modulename": "muutils.misc.hashing", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.hashing.stable_hash": {"fullname": "muutils.misc.hashing.stable_hash", "modulename": "muutils.misc.hashing", "qualname": "stable_hash", "kind": "function", "doc": "<p>Returns a stable hash of the given string. not cryptographically secure, but stable between runs</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">s</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bytes</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "muutils.misc.hashing.stable_json_dumps": {"fullname": "muutils.misc.hashing.stable_json_dumps", "modulename": "muutils.misc.hashing", "qualname": "stable_json_dumps", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">d</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.hashing.base64_hash": {"fullname": "muutils.misc.hashing.base64_hash", "modulename": "muutils.misc.hashing", "qualname": "base64_hash", "kind": "function", "doc": "<p>Returns a base64 representation of the hash of the given string. not cryptographically secure</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">s</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bytes</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.numerical": {"fullname": "muutils.misc.numerical", "modulename": "muutils.misc.numerical", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.numerical.shorten_numerical_to_str": {"fullname": "muutils.misc.numerical.shorten_numerical_to_str", "modulename": "muutils.misc.numerical", "qualname": "shorten_numerical_to_str", "kind": "function", "doc": "<p>shorten a large numerical value to a string\n1234 -> 1K</p>\n\n<p>precision guaranteed to 1 in 10, but can be higher. reverse of <code>str_to_numeric</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">num</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">small_as_decimal</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">precision</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.numerical.str_to_numeric": {"fullname": "muutils.misc.numerical.str_to_numeric", "modulename": "muutils.misc.numerical", "qualname": "str_to_numeric", "kind": "function", "doc": "<p>Convert a string representing a quantity to a numeric value.</p>\n\n<p>The string can represent an integer, python float, fraction, or shortened via <code>shorten_numerical_to_str</code>.</p>\n\n<h1 id=\"examples\">Examples:</h1>\n\n<pre><code>&gt;&gt;&gt; str_to_numeric(\"5\")\n5\n&gt;&gt;&gt; str_to_numeric(\"0.1\")\n0.1\n&gt;&gt;&gt; str_to_numeric(\"1/5\")\n0.2\n&gt;&gt;&gt; str_to_numeric(\"-1K\")\n-1000.0\n&gt;&gt;&gt; str_to_numeric(\"1.5M\")\n1500000.0\n&gt;&gt;&gt; str_to_numeric(\"1.2e2\")\n120.0\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">quantity</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sequence": {"fullname": "muutils.misc.sequence", "modulename": "muutils.misc.sequence", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.sequence.WhenMissing": {"fullname": "muutils.misc.sequence.WhenMissing", "modulename": "muutils.misc.sequence", "qualname": "WhenMissing", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;except&#x27;, &#x27;skip&#x27;, &#x27;include&#x27;]"}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"fullname": "muutils.misc.sequence.empty_sequence_if_attr_false", "modulename": "muutils.misc.sequence", "qualname": "empty_sequence_if_attr_false", "kind": "function", "doc": "<p>Returns <code>itr</code> if <code>attr_owner</code> has the attribute <code>attr_name</code> and it boolean casts to <code>True</code>. Returns an empty sequence otherwise.</p>\n\n<p>Particularly useful for optionally inserting delimiters into a sequence depending on an <code>TokenizerElement</code> attribute.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>itr: Iterable[Any]</code>\nThe iterable to return if the attribute is <code>True</code>.</li>\n<li><code>attr_owner: Any</code>\nThe object to check for the attribute.</li>\n<li><code>attr_name: str</code>\nThe name of the attribute to check.</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>itr: Iterable</code> if <code>attr_owner</code> has the attribute <code>attr_name</code> and it boolean casts to <code>True</code>, otherwise an empty sequence.</li>\n<li><code>()</code> an empty sequence if the attribute is <code>False</code> or not present.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">itr</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">attr_owner</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">attr_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sequence.flatten": {"fullname": "muutils.misc.sequence.flatten", "modulename": "muutils.misc.sequence", "qualname": "flatten", "kind": "function", "doc": "<p>Flattens an arbitrarily nested iterable.\nFlattens all iterable data types except for <code>str</code> and <code>bytes</code>.</p>\n\n<h1 id=\"returns\">Returns</h1>\n\n<p>Generator over the flattened sequence.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>it</code>: Any arbitrarily nested iterable.</li>\n<li><code>levels_to_flatten</code>: Number of levels to flatten by, starting at the outermost layer. If <code>None</code>, performs full flattening.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">it</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">levels_to_flatten</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Generator</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sequence.list_split": {"fullname": "muutils.misc.sequence.list_split", "modulename": "muutils.misc.sequence", "qualname": "list_split", "kind": "function", "doc": "<p>split a list into sublists by <code>val</code>. similar to \"a_b_c\".split(\"_\")</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">4</span><span class=\"p\">,</span><span class=\"mi\">5</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">6</span><span class=\"p\">],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">6</span><span class=\"p\">]]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[],</span> <span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">]]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">]]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_split</span><span class=\"p\">([],</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[[]]</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lst</span><span class=\"p\">:</span> <span class=\"nb\">list</span>, </span><span class=\"param\"><span class=\"n\">val</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sequence.list_join": {"fullname": "muutils.misc.sequence.list_join", "modulename": "muutils.misc.sequence", "qualname": "list_join", "kind": "function", "doc": "<p>add a <em>new</em> instance of <code>factory()</code> between each element of <code>lst</code></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_join</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"k\">lambda</span> <span class=\"p\">:</span> <span class=\"mi\">0</span><span class=\"p\">)</span>\n<span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">0</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">]</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">list_join</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span><span class=\"mi\">2</span><span class=\"p\">,</span><span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"k\">lambda</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">),</span> <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">time</span><span class=\"p\">()][</span><span class=\"mi\">1</span><span class=\"p\">])</span>\n<span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mf\">1600000000.0</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mf\">1600000000.1</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lst</span><span class=\"p\">:</span> <span class=\"nb\">list</span>, </span><span class=\"param\"><span class=\"n\">factory</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sequence.apply_mapping": {"fullname": "muutils.misc.sequence.apply_mapping", "modulename": "muutils.misc.sequence", "qualname": "apply_mapping", "kind": "function", "doc": "<p>Given an iterable and a mapping, apply the mapping to the iterable with certain options</p>\n\n<p>Gotcha: if <code>when_missing</code> is invalid, this is totally fine until a missing key is actually encountered.</p>\n\n<p>Note: you can use this with <code>muutils.kappa.Kappa</code> if you want to pass a function instead of a dict</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>mapping : Mapping[_AM_K, _AM_V]</code>\nmust have <code>__contains__</code> and <code>__getitem__</code>, both of which take <code>_AM_K</code> and the latter returns <code>_AM_V</code></li>\n<li><code>iter : Iterable[_AM_K]</code>\nthe iterable to apply the mapping to</li>\n<li><code>when_missing : WhenMissing</code>\n what to do when a key is missing from the mapping -- this is what distinguishes this function from <code>map</code>\n you can choose from <code>\"skip\"</code>, <code>\"include\"</code> (without converting), and <code>\"except\"</code>\n(defaults to <code>\"skip\"</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<p>return type is one of:</p>\n\n<ul>\n<li><code>list[_AM_V]</code> if <code>when_missing</code> is <code>\"skip\"</code> or <code>\"except\"</code></li>\n<li><code>list[Union[_AM_K, _AM_V]]</code> if <code>when_missing</code> is <code>\"include\"</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>KeyError</code> : if the item is missing from the mapping and <code>when_missing</code> is <code>\"except\"</code></li>\n<li><code>ValueError</code> : if <code>when_missing</code> is invalid</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"n\">Mapping</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"nb\">iter</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">when_missing</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;except&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;skip&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;include&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;skip&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.sequence.apply_mapping_chain": {"fullname": "muutils.misc.sequence.apply_mapping_chain", "modulename": "muutils.misc.sequence", "qualname": "apply_mapping_chain", "kind": "function", "doc": "<p>Given an iterable and a mapping, chain the mappings together</p>\n\n<p>Gotcha: if <code>when_missing</code> is invalid, this is totally fine until a missing key is actually encountered.</p>\n\n<p>Note: you can use this with <code>muutils.kappa.Kappa</code> if you want to pass a function instead of a dict</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>mapping : Mapping[_AM_K, Iterable[_AM_V]]</code>\nmust have <code>__contains__</code> and <code>__getitem__</code>, both of which take <code>_AM_K</code> and the latter returns <code>Iterable[_AM_V]</code></li>\n<li><code>iter : Iterable[_AM_K]</code>\nthe iterable to apply the mapping to</li>\n<li><code>when_missing : WhenMissing</code>\nwhat to do when a key is missing from the mapping -- this is what distinguishes this function from <code>map</code>\nyou can choose from <code>\"skip\"</code>, <code>\"include\"</code> (without converting), and <code>\"except\"</code>\n(defaults to <code>\"skip\"</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<p>return type is one of:</p>\n\n<ul>\n<li><code>list[_AM_V]</code> if <code>when_missing</code> is <code>\"skip\"</code> or <code>\"except\"</code></li>\n<li><code>list[Union[_AM_K, _AM_V]]</code> if <code>when_missing</code> is <code>\"include\"</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>KeyError</code> : if the item is missing from the mapping and <code>when_missing</code> is <code>\"except\"</code></li>\n<li><code>ValueError</code> : if <code>when_missing</code> is invalid</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"n\">Mapping</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"nb\">iter</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">when_missing</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;except&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;skip&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;include&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;skip&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">_AM_K</span><span class=\"p\">,</span> <span class=\"o\">~</span><span class=\"n\">_AM_V</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.misc.string": {"fullname": "muutils.misc.string", "modulename": "muutils.misc.string", "kind": "module", "doc": "<p></p>\n"}, "muutils.misc.string.sanitize_name": {"fullname": "muutils.misc.string.sanitize_name", "modulename": "muutils.misc.string", "qualname": "sanitize_name", "kind": "function", "doc": "<p>sanitize a string, leaving only alphanumerics and <code>additional_allowed_chars</code></p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>name : str | None</code>\ninput string</li>\n<li><code>additional_allowed_chars : str</code>\nadditional characters to allow, none by default\n(defaults to <code>\"\"</code>)</li>\n<li><code>replace_invalid : str</code>\n character to replace invalid characters with\n(defaults to <code>\"\"</code>)</li>\n<li><code>when_none : str | None</code>\n string to return if <code>name</code> is <code>None</code>. if <code>None</code>, raises an exception\n(defaults to <code>\"_None_\"</code>)</li>\n<li><code>leading_digit_prefix : str</code>\n character to prefix the string with if it starts with a digit\n(defaults to <code>\"\"</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>str</code>\nsanitized string</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">additional_allowed_chars</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">replace_invalid</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">when_none</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;_None_&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">leading_digit_prefix</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.string.sanitize_fname": {"fullname": "muutils.misc.string.sanitize_fname", "modulename": "muutils.misc.string", "qualname": "sanitize_fname", "kind": "function", "doc": "<p>sanitize a filename to posix standards</p>\n\n<ul>\n<li>leave only alphanumerics, <code>_</code> (underscore), '-' (dash) and <code>.</code> (period)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.string.sanitize_identifier": {"fullname": "muutils.misc.string.sanitize_identifier", "modulename": "muutils.misc.string", "qualname": "sanitize_identifier", "kind": "function", "doc": "<p>sanitize an identifier (variable or function name)</p>\n\n<ul>\n<li>leave only alphanumerics and <code>_</code> (underscore)</li>\n<li>prefix with <code>_</code> if it starts with a digit</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.misc.string.dict_to_filename": {"fullname": "muutils.misc.string.dict_to_filename", "modulename": "muutils.misc.string", "qualname": "dict_to_filename", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">format_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"si\">{key}</span><span class=\"s1\">_</span><span class=\"si\">{val}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">separator</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">max_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">255</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.misc.string.dynamic_docstring": {"fullname": "muutils.misc.string.dynamic_docstring", "modulename": "muutils.misc.string", "qualname": "dynamic_docstring", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">**</span><span class=\"n\">doc_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.mlutils": {"fullname": "muutils.mlutils", "modulename": "muutils.mlutils", "kind": "module", "doc": "<p>miscellaneous utilities for ML pipelines</p>\n"}, "muutils.mlutils.ARRAY_IMPORTS": {"fullname": "muutils.mlutils.ARRAY_IMPORTS", "modulename": "muutils.mlutils", "qualname": "ARRAY_IMPORTS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "muutils.mlutils.DEFAULT_SEED": {"fullname": "muutils.mlutils.DEFAULT_SEED", "modulename": "muutils.mlutils", "qualname": "DEFAULT_SEED", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "42"}, "muutils.mlutils.GLOBAL_SEED": {"fullname": "muutils.mlutils.GLOBAL_SEED", "modulename": "muutils.mlutils", "qualname": "GLOBAL_SEED", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "42"}, "muutils.mlutils.get_device": {"fullname": "muutils.mlutils.get_device", "modulename": "muutils.mlutils", "qualname": "get_device", "kind": "function", "doc": "<p>Get the torch.device instance on which <code>torch.Tensor</code>s should be allocated.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span>:</span></span>", "funcdef": "def"}, "muutils.mlutils.set_reproducibility": {"fullname": "muutils.mlutils.set_reproducibility", "modulename": "muutils.mlutils", "qualname": "set_reproducibility", "kind": "function", "doc": "<p>Improve model reproducibility. See <a href=\"https://github.com/NVIDIA/framework-determinism\">https://github.com/NVIDIA/framework-determinism</a> for more information.</p>\n\n<p>Deterministic operations tend to have worse performance than nondeterministic operations, so this method trades\noff performance for reproducibility. Set use_deterministic_algorithms to True to improve performance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">42</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.mlutils.chunks": {"fullname": "muutils.mlutils.chunks", "modulename": "muutils.mlutils", "qualname": "chunks", "kind": "function", "doc": "<p>Yield successive chunks from an iterator.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">it</span>, </span><span class=\"param\"><span class=\"n\">chunk_size</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.mlutils.get_checkpoint_paths_for_run": {"fullname": "muutils.mlutils.get_checkpoint_paths_for_run", "modulename": "muutils.mlutils", "qualname": "get_checkpoint_paths_for_run", "kind": "function", "doc": "<p>get checkpoints of the format from the run_path</p>\n\n<p>note that <code>checkpoints_format</code> should contain a glob pattern with:</p>\n\n<ul>\n<li>unresolved \"{extension}\" format term for the extension</li>\n<li>a wildcard for the iteration number</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">run_path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">extension</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;pt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;zanj&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">checkpoints_format</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;checkpoints/model.iter_*.</span><span class=\"si\">{extension}</span><span class=\"s1\">&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.mlutils.register_method": {"fullname": "muutils.mlutils.register_method", "modulename": "muutils.mlutils", "qualname": "register_method", "kind": "function", "doc": "<p>Decorator to add a method to the method_dict</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">method_dict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">...</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">custom_name</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">F</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">F</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.mlutils.pprint_summary": {"fullname": "muutils.mlutils.pprint_summary", "modulename": "muutils.mlutils", "qualname": "pprint_summary", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">summary</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils": {"fullname": "muutils.nbutils", "modulename": "muutils.nbutils", "kind": "module", "doc": "<p>utilities for working with notebooks</p>\n\n<ul>\n<li>configuring figures mdoes and torch devices: <code>configure_notebook</code></li>\n<li>converting them to scripts: <code>convert_ipynb_to_script</code></li>\n<li>running them as tests: <code>run_notebook_tests</code></li>\n<li>and working with diagrams/LaTeX: <code>mermaid</code>, <code>print_tex</code></li>\n</ul>\n"}, "muutils.nbutils.mm": {"fullname": "muutils.nbutils.mm", "modulename": "muutils.nbutils", "qualname": "mm", "kind": "function", "doc": "<p>for plotting mermaid.js diagrams</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">graph</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils.configure_notebook": {"fullname": "muutils.nbutils.configure_notebook", "modulename": "muutils.nbutils.configure_notebook", "kind": "module", "doc": "<p>shared utilities for setting up a notebook</p>\n"}, "muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning": {"fullname": "muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning", "modulename": "muutils.nbutils.configure_notebook", "qualname": "PlotlyNotInstalledWarning", "kind": "class", "doc": "<p>Base class for warnings generated by user code.</p>\n", "bases": "builtins.UserWarning"}, "muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"fullname": "muutils.nbutils.configure_notebook.PLOTLY_IMPORTED", "modulename": "muutils.nbutils.configure_notebook", "qualname": "PLOTLY_IMPORTED", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "muutils.nbutils.configure_notebook.PlottingMode": {"fullname": "muutils.nbutils.configure_notebook.PlottingMode", "modulename": "muutils.nbutils.configure_notebook", "qualname": "PlottingMode", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;ignore&#x27;, &#x27;inline&#x27;, &#x27;widget&#x27;, &#x27;save&#x27;]"}, "muutils.nbutils.configure_notebook.PLOT_MODE": {"fullname": "muutils.nbutils.configure_notebook.PLOT_MODE", "modulename": "muutils.nbutils.configure_notebook", "qualname": "PLOT_MODE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;ignore&#x27;, &#x27;inline&#x27;, &#x27;widget&#x27;, &#x27;save&#x27;]", "default_value": "&#x27;inline&#x27;"}, "muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"fullname": "muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE", "modulename": "muutils.nbutils.configure_notebook", "qualname": "CONVERSION_PLOTMODE_OVERRIDE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[Literal[&#x27;ignore&#x27;, &#x27;inline&#x27;, &#x27;widget&#x27;, &#x27;save&#x27;]]", "default_value": "None"}, "muutils.nbutils.configure_notebook.FIG_COUNTER": {"fullname": "muutils.nbutils.configure_notebook.FIG_COUNTER", "modulename": "muutils.nbutils.configure_notebook", "qualname": "FIG_COUNTER", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "0"}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"fullname": "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT", "modulename": "muutils.nbutils.configure_notebook", "qualname": "FIG_OUTPUT_FMT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None", "default_value": "None"}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"fullname": "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME", "modulename": "muutils.nbutils.configure_notebook", "qualname": "FIG_NUMBERED_FNAME", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;figure-{num}&#x27;"}, "muutils.nbutils.configure_notebook.FIG_CONFIG": {"fullname": "muutils.nbutils.configure_notebook.FIG_CONFIG", "modulename": "muutils.nbutils.configure_notebook", "qualname": "FIG_CONFIG", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict | None", "default_value": "None"}, "muutils.nbutils.configure_notebook.FIG_BASEPATH": {"fullname": "muutils.nbutils.configure_notebook.FIG_BASEPATH", "modulename": "muutils.nbutils.configure_notebook", "qualname": "FIG_BASEPATH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None", "default_value": "None"}, "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"fullname": "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW", "modulename": "muutils.nbutils.configure_notebook", "qualname": "CLOSE_AFTER_PLOTSHOW", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "False"}, "muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"fullname": "muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS", "modulename": "muutils.nbutils.configure_notebook", "qualname": "MATPLOTLIB_FORMATS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;pdf&#x27;, &#x27;png&#x27;, &#x27;jpg&#x27;, &#x27;jpeg&#x27;, &#x27;svg&#x27;, &#x27;eps&#x27;, &#x27;ps&#x27;, &#x27;tif&#x27;, &#x27;tiff&#x27;]"}, "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"fullname": "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS", "modulename": "muutils.nbutils.configure_notebook", "qualname": "TIKZPLOTLIB_FORMATS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;tex&#x27;, &#x27;tikz&#x27;]"}, "muutils.nbutils.configure_notebook.UnknownFigureFormatWarning": {"fullname": "muutils.nbutils.configure_notebook.UnknownFigureFormatWarning", "modulename": "muutils.nbutils.configure_notebook", "qualname": "UnknownFigureFormatWarning", "kind": "class", "doc": "<p>Base class for warnings generated by user code.</p>\n", "bases": "builtins.UserWarning"}, "muutils.nbutils.configure_notebook.universal_savefig": {"fullname": "muutils.nbutils.configure_notebook.universal_savefig", "modulename": "muutils.nbutils.configure_notebook", "qualname": "universal_savefig", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">fmt</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.nbutils.configure_notebook.setup_plots": {"fullname": "muutils.nbutils.configure_notebook.setup_plots", "modulename": "muutils.nbutils.configure_notebook", "qualname": "setup_plots", "kind": "function", "doc": "<p>Set up plot saving/rendering options</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">plot_mode</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ignore&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;inline&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;widget&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;save&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;inline&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fig_output_fmt</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;pdf&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fig_numbered_fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;figure-</span><span class=\"si\">{num}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fig_config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fig_basepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">close_after_plotshow</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.nbutils.configure_notebook.configure_notebook": {"fullname": "muutils.nbutils.configure_notebook.configure_notebook", "modulename": "muutils.nbutils.configure_notebook", "qualname": "configure_notebook", "kind": "function", "doc": "<p>Shared Jupyter notebook setup steps</p>\n\n<ul>\n<li>Set random seeds and library reproducibility settings</li>\n<li>Set device based on availability</li>\n<li>Set module reloading before code execution</li>\n<li>Set plot formatting</li>\n<li>Set plot saving/rendering options</li>\n</ul>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>seed : int</code>\n random seed across libraries including torch, numpy, and random (defaults to <code>42</code>)\n(defaults to <code>42</code>)</li>\n<li><code>device : typing.Any</code>\npytorch device to use\n(defaults to <code>None</code>)</li>\n<li><code>dark_mode : bool</code>\nfigures in dark mode\n(defaults to <code>True</code>)</li>\n<li><code>plot_mode : PlottingMode</code>\nhow to display plots, one of <code>PlottingMode</code> or <code>[\"ignore\", \"inline\", \"widget\", \"save\"]</code>\n(defaults to <code>\"inline\"</code>)</li>\n<li><code>fig_output_fmt : str | None</code>\nformat for saving figures\n(defaults to <code>\"pdf\"</code>)</li>\n<li><code>fig_numbered_fname : str</code>\n format for saving figures with numbers (if they aren't named)\n(defaults to <code>\"figure-{num}\"</code>)</li>\n<li><code>fig_config : dict | None</code>\nmetadata to save with the figures\n(defaults to <code>None</code>)</li>\n<li><code>fig_basepath : str | None</code>\n base path for saving figures\n(defaults to <code>None</code>)</li>\n<li><code>close_after_plotshow : bool</code>\n close figures after showing them\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>torch.device|None</code>\nthe device set, if torch is installed</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">42</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dark_mode</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">plot_mode</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ignore&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;inline&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;widget&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;save&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;inline&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fig_output_fmt</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;pdf&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fig_numbered_fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;figure-</span><span class=\"si\">{num}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">fig_config</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fig_basepath</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">close_after_plotshow</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">device</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.nbutils.configure_notebook.plotshow": {"fullname": "muutils.nbutils.configure_notebook.plotshow", "modulename": "muutils.nbutils.configure_notebook", "qualname": "plotshow", "kind": "function", "doc": "<p>Show the active plot, depending on global configs</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">fname</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">plot_mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ignore&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;inline&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;widget&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;save&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fmt</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils.convert_ipynb_to_script": {"fullname": "muutils.nbutils.convert_ipynb_to_script", "modulename": "muutils.nbutils.convert_ipynb_to_script", "kind": "module", "doc": "<p>fast conversion of Jupyter Notebooks to scripts, with some basic and hacky filtering and formatting.</p>\n"}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"fullname": "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS", "modulename": "muutils.nbutils.convert_ipynb_to_script", "qualname": "DISABLE_PLOTS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, list[str]]", "default_value": "{&#x27;matplotlib&#x27;: [&#x27;\\n# ------------------------------------------------------------\\n# Disable matplotlib plots, done during processing by `convert_ipynb_to_script.py`\\nimport matplotlib.pyplot as plt\\nplt.show = lambda: None\\n# ------------------------------------------------------------\\n&#x27;], &#x27;circuitsvis&#x27;: [&#x27;\\n# ------------------------------------------------------------\\n# Disable circuitsvis plots, done during processing by `convert_ipynb_to_script.py`\\nfrom circuitsvis.utils.convert_props import PythonProperty, convert_props\\nfrom circuitsvis.utils.render import RenderedHTML, render, render_cdn, render_local\\n\\ndef new_render(\\n    react_element_name: str,\\n    **kwargs: PythonProperty\\n) -&gt; RenderedHTML:\\n    &quot;return a visualization as raw HTML&quot;\\n    local_src = render_local(react_element_name, **kwargs)\\n    cdn_src = render_cdn(react_element_name, **kwargs)\\n    # return as string instead of RenderedHTML for CI\\n    return str(RenderedHTML(local_src, cdn_src))\\n\\nrender = new_render\\n# ------------------------------------------------------------\\n&#x27;], &#x27;muutils&#x27;: [&#x27;import muutils.nbutils.configure_notebook as nb_conf\\nnb_conf.CONVERSION_PLOTMODE_OVERRIDE = &quot;ignore&quot;\\n&#x27;]}"}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"fullname": "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING", "modulename": "muutils.nbutils.convert_ipynb_to_script", "qualname": "DISABLE_PLOTS_WARNING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[str]", "default_value": "[&quot;# ------------------------------------------------------------\\n# WARNING: this script is auto-generated by `convert_ipynb_to_script.py`\\n# showing plots has been disabled, so this is presumably in a temp dict for CI or something\\n# so don&#x27;t modify this code, it will be overwritten!\\n# ------------------------------------------------------------\\n&quot;]"}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"fullname": "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script", "modulename": "muutils.nbutils.convert_ipynb_to_script", "qualname": "disable_plots_in_script", "kind": "function", "doc": "<p>Disable plots in a script by adding cursed things after the import statements</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">script_lines</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"fullname": "muutils.nbutils.convert_ipynb_to_script.convert_ipynb", "modulename": "muutils.nbutils.convert_ipynb_to_script", "qualname": "convert_ipynb", "kind": "function", "doc": "<p>Convert Jupyter Notebook to a script, doing some basic filtering and formatting.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<pre><code>- `notebook: dict`: Jupyter Notebook loaded as json.\n- `strip_md_cells: bool = False`: Remove markdown cells from the output script.\n- `header_comment: str = r'#%%'`: Comment string to separate cells in the output script.\n- `disable_plots: bool = False`: Disable plots in the output script.\n- `filter_out_lines: str|typing.Sequence[str] = ('%', '!')`: comment out lines starting with these strings (in code blocks).\n    if a string is passed, it will be split by char and each char will be treated as a separate filter.\n</code></pre>\n\n<h1 id=\"returns\">Returns</h1>\n\n<pre><code>- `str`: Converted script.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">notebook</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">strip_md_cells</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">header_comment</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;#</span><span class=\"si\">%%</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">disable_plots</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">filter_out_lines</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"s1\">&#39;%&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;!&#39;</span><span class=\"p\">)</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"fullname": "muutils.nbutils.convert_ipynb_to_script.process_file", "modulename": "muutils.nbutils.convert_ipynb_to_script", "qualname": "process_file", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">in_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">out_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strip_md_cells</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">header_comment</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;#</span><span class=\"si\">%%</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">disable_plots</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">filter_out_lines</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"s1\">&#39;%&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;!&#39;</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"fullname": "muutils.nbutils.convert_ipynb_to_script.process_dir", "modulename": "muutils.nbutils.convert_ipynb_to_script", "qualname": "process_dir", "kind": "function", "doc": "<p>Convert all Jupyter Notebooks in a directory to scripts.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<pre><code>- `input_dir: str`: Input directory.\n- `output_dir: str`: Output directory.\n- `strip_md_cells: bool = False`: Remove markdown cells from the output script.\n- `header_comment: str = r'#%%'`: Comment string to separate cells in the output script.\n- `disable_plots: bool = False`: Disable plots in the output script.\n- `filter_out_lines: str|typing.Sequence[str] = ('%', '!')`: comment out lines starting with these strings (in code blocks).\n    if a string is passed, it will be split by char and each char will be treated as a separate filter.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">input_dir</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">output_dir</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strip_md_cells</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">header_comment</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;#</span><span class=\"si\">%%</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">disable_plots</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">filter_out_lines</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"s1\">&#39;%&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;!&#39;</span><span class=\"p\">)</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils.mermaid": {"fullname": "muutils.nbutils.mermaid", "modulename": "muutils.nbutils.mermaid", "kind": "module", "doc": "<p>display mermaid.js diagrams in jupyter notebooks by the <code>mermaid.ink/img</code> service</p>\n"}, "muutils.nbutils.mermaid.mm": {"fullname": "muutils.nbutils.mermaid.mm", "modulename": "muutils.nbutils.mermaid", "qualname": "mm", "kind": "function", "doc": "<p>for plotting mermaid.js diagrams</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">graph</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils.print_tex": {"fullname": "muutils.nbutils.print_tex", "modulename": "muutils.nbutils.print_tex", "kind": "module", "doc": "<p>quickly print a sympy expression in latex</p>\n"}, "muutils.nbutils.print_tex.print_tex": {"fullname": "muutils.nbutils.print_tex.print_tex", "modulename": "muutils.nbutils.print_tex", "qualname": "print_tex", "kind": "function", "doc": "<p>function for easily rendering a sympy expression in latex</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expr</span><span class=\"p\">:</span> <span class=\"n\">sympy</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">expr</span><span class=\"o\">.</span><span class=\"n\">Expr</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">plain</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">rendered</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.nbutils.run_notebook_tests": {"fullname": "muutils.nbutils.run_notebook_tests", "modulename": "muutils.nbutils.run_notebook_tests", "kind": "module", "doc": "<p>turn a folder of notebooks into scripts, run them, and make sure they work.</p>\n\n<p>made to be called as</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>python<span class=\"w\"> </span>-m<span class=\"w\"> </span>muutils.nbutils.run_notebook_tests<span class=\"w\"> </span>--notebooks-dir<span class=\"w\"> </span>&lt;notebooks_dir&gt;<span class=\"w\"> </span>--converted-notebooks-temp-dir<span class=\"w\"> </span>&lt;converted_notebooks_temp_dir&gt;\n</code></pre>\n</div>\n"}, "muutils.nbutils.run_notebook_tests.NotebookTestError": {"fullname": "muutils.nbutils.run_notebook_tests.NotebookTestError", "modulename": "muutils.nbutils.run_notebook_tests", "qualname": "NotebookTestError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "builtins.Exception"}, "muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"fullname": "muutils.nbutils.run_notebook_tests.SUCCESS_STR", "modulename": "muutils.nbutils.run_notebook_tests", "qualname": "SUCCESS_STR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;\u2705&#x27;"}, "muutils.nbutils.run_notebook_tests.FAILURE_STR": {"fullname": "muutils.nbutils.run_notebook_tests.FAILURE_STR", "modulename": "muutils.nbutils.run_notebook_tests", "qualname": "FAILURE_STR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;\u274c&#x27;"}, "muutils.nbutils.run_notebook_tests.run_notebook_tests": {"fullname": "muutils.nbutils.run_notebook_tests.run_notebook_tests", "modulename": "muutils.nbutils.run_notebook_tests", "qualname": "run_notebook_tests", "kind": "function", "doc": "<p>Run converted Jupyter notebooks as Python scripts and verify they execute successfully.</p>\n\n<p>Takes a directory of notebooks and their corresponding converted Python scripts,\nexecutes each script, and captures the output. Failures are collected and reported,\nwith optional early exit on first failure.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>notebooks_dir : Path</code>\nDirectory containing the original .ipynb notebook files</li>\n<li><code>converted_notebooks_temp_dir : Path</code>\nDirectory containing the corresponding converted .py files</li>\n<li><code>CI_output_suffix : str</code>\nSuffix to append to output files capturing execution results\n(defaults to <code>\".CI-output.txt\"</code>)</li>\n<li><code>run_python_cmd : str | None</code>\nCustom command to run Python scripts. Overrides python_tool and run_python_cmd_fmt if provided\n(defaults to <code>None</code>)</li>\n<li><code>run_python_cmd_fmt : str</code>\nFormat string for constructing the Python run command\n(defaults to <code>\"{python_tool} run python\"</code>)</li>\n<li><code>python_tool : str</code>\nTool used to run Python (e.g. poetry, uv)\n(defaults to <code>\"poetry\"</code>)</li>\n<li><code>exit_on_first_fail : bool</code>\nWhether to raise exception immediately on first notebook failure\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>None</code></li>\n</ul>\n\n<h1 id=\"modifies\">Modifies:</h1>\n\n<ul>\n<li>Working directory: Temporarily changes to notebooks_dir during execution</li>\n<li>Filesystem: Creates output files with CI_output_suffix for each notebook</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>NotebookTestError</code>: If any notebooks fail to execute, or if input directories are invalid</li>\n<li><code>TypeError</code>: If run_python_cmd is provided but not a string</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">run_notebook_tests</span><span class=\"p\">(</span>\n<span class=\"o\">...</span>     <span class=\"n\">notebooks_dir</span><span class=\"o\">=</span><span class=\"n\">Path</span><span class=\"p\">(</span><span class=\"s2\">&quot;notebooks&quot;</span><span class=\"p\">),</span>\n<span class=\"o\">...</span>     <span class=\"n\">converted_notebooks_temp_dir</span><span class=\"o\">=</span><span class=\"n\">Path</span><span class=\"p\">(</span><span class=\"s2\">&quot;temp/converted&quot;</span><span class=\"p\">),</span>\n<span class=\"o\">...</span>     <span class=\"n\">python_tool</span><span class=\"o\">=</span><span class=\"s2\">&quot;poetry&quot;</span>\n<span class=\"o\">...</span> <span class=\"p\">)</span>\n<span class=\"c1\"># testing notebooks in &#39;notebooks&#39;</span>\n<span class=\"c1\"># reading converted notebooks from &#39;temp/converted&#39;</span>\n<span class=\"n\">Running</span> <span class=\"mi\">1</span><span class=\"o\">/</span><span class=\"mi\">2</span><span class=\"p\">:</span> <span class=\"n\">temp</span><span class=\"o\">/</span><span class=\"n\">converted</span><span class=\"o\">/</span><span class=\"n\">notebook1</span><span class=\"o\">.</span><span class=\"n\">py</span>\n    <span class=\"n\">Output</span> <span class=\"ow\">in</span> <span class=\"n\">temp</span><span class=\"o\">/</span><span class=\"n\">converted</span><span class=\"o\">/</span><span class=\"n\">notebook1</span><span class=\"o\">.</span><span class=\"n\">CI</span><span class=\"o\">-</span><span class=\"n\">output</span><span class=\"o\">.</span><span class=\"n\">txt</span>\n    <span class=\"p\">{</span><span class=\"n\">SUCCESS_STR</span><span class=\"p\">}</span> <span class=\"n\">Run</span> <span class=\"n\">completed</span> <span class=\"k\">with</span> <span class=\"k\">return</span> <span class=\"n\">code</span> <span class=\"mi\">0</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">notebooks_dir</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">converted_notebooks_temp_dir</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">CI_output_suffix</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.CI-output.txt&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">run_python_cmd</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">run_python_cmd_fmt</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"si\">{python_tool}</span><span class=\"s1\"> run python&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">python_tool</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;poetry&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">exit_on_first_fail</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.parallel": {"fullname": "muutils.parallel", "modulename": "muutils.parallel", "kind": "module", "doc": "<p>parallel processing utilities, chiefly <code>run_maybe_parallel</code></p>\n"}, "muutils.parallel.ProgressBarFunction": {"fullname": "muutils.parallel.ProgressBarFunction", "modulename": "muutils.parallel", "qualname": "ProgressBarFunction", "kind": "class", "doc": "<p>a protocol for a progress bar function</p>\n", "bases": "typing.Protocol"}, "muutils.parallel.ProgressBarFunction.__init__": {"fullname": "muutils.parallel.ProgressBarFunction.__init__", "modulename": "muutils.parallel", "qualname": "ProgressBarFunction.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.parallel.ProgressBarOption": {"fullname": "muutils.parallel.ProgressBarOption", "modulename": "muutils.parallel", "qualname": "ProgressBarOption", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;tqdm&#x27;, &#x27;spinner&#x27;, &#x27;none&#x27;, None]"}, "muutils.parallel.DEFAULT_PBAR_FN": {"fullname": "muutils.parallel.DEFAULT_PBAR_FN", "modulename": "muutils.parallel", "qualname": "DEFAULT_PBAR_FN", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;tqdm&#x27;, &#x27;spinner&#x27;, &#x27;none&#x27;, None]", "default_value": "&#x27;tqdm&#x27;"}, "muutils.parallel.spinner_fn_wrap": {"fullname": "muutils.parallel.spinner_fn_wrap", "modulename": "muutils.parallel", "qualname": "spinner_fn_wrap", "kind": "function", "doc": "<p>spinner wrapper</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span>:</span></span>", "funcdef": "def"}, "muutils.parallel.map_kwargs_for_tqdm": {"fullname": "muutils.parallel.map_kwargs_for_tqdm", "modulename": "muutils.parallel", "qualname": "map_kwargs_for_tqdm", "kind": "function", "doc": "<p>map kwargs for tqdm, cant wrap because the pbar dissapears?</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.parallel.no_progress_fn_wrap": {"fullname": "muutils.parallel.no_progress_fn_wrap", "modulename": "muutils.parallel", "qualname": "no_progress_fn_wrap", "kind": "function", "doc": "<p>fallback to no progress bar</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterable</span>:</span></span>", "funcdef": "def"}, "muutils.parallel.set_up_progress_bar_fn": {"fullname": "muutils.parallel.set_up_progress_bar_fn", "modulename": "muutils.parallel", "qualname": "set_up_progress_bar_fn", "kind": "function", "doc": "<p>set up the progress bar function and its kwargs</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>pbar : Union[ProgressBarFunction, ProgressBarOption]</code>\nprogress bar function or option. if a function, we return as-is. if a string, we figure out which progress bar to use</li>\n<li><code>pbar_kwargs : Optional[Dict[str, Any]]</code>\nkwargs passed to the progress bar function (default to <code>None</code>)\n(defaults to <code>None</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Tuple[ProgressBarFunction, dict]</code>\na tuple of the progress bar function and its kwargs</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> : if <code>pbar</code> is not one of the valid options</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">pbar</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">parallel</span><span class=\"o\">.</span><span class=\"n\">ProgressBarFunction</span><span class=\"p\">,</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;tqdm&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;spinner&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;none&#39;</span><span class=\"p\">,</span> <span class=\"kc\">None</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">pbar_kwargs</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">extra_kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">parallel</span><span class=\"o\">.</span><span class=\"n\">ProgressBarFunction</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.parallel.run_maybe_parallel": {"fullname": "muutils.parallel.run_maybe_parallel", "modulename": "muutils.parallel", "qualname": "run_maybe_parallel", "kind": "function", "doc": "<p>a function to make it easier to sometimes parallelize an operation</p>\n\n<ul>\n<li>if <code>parallel</code> is <code>False</code>, then the function will run in serial, running <code>map(func, iterable)</code></li>\n<li>if <code>parallel</code> is <code>True</code>, then the function will run in parallel, running in parallel with the maximum number of processes</li>\n<li>if <code>parallel</code> is an <code>int</code>, it must be greater than 1, and the function will run in parallel with the number of processes specified by <code>parallel</code></li>\n</ul>\n\n<p>the maximum number of processes is given by the <code>min(len(iterable), multiprocessing.cpu_count())</code></p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>func : Callable[[InputType], OutputType]</code>\nfunction passed to either <code>map</code> or <code>Pool.imap</code></li>\n<li><code>iterable : Iterable[InputType]</code>\niterable passed to either <code>map</code> or <code>Pool.imap</code></li>\n<li><code>parallel : bool | int</code>\nwhether to run in parallel, and how many processes to use</li>\n<li><code>pbar_kwargs : Dict[str, Any]</code>\nkwargs passed to the progress bar function</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>List[OutputType]</code>\na list of the output of <code>func</code> for each element in <code>iterable</code></li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>ValueError</code> : if <code>parallel</code> is not a boolean or an integer greater than 1</li>\n<li><code>ValueError</code> : if <code>use_multiprocess=True</code> and <code>parallel=False</code></li>\n<li><code>ImportError</code> : if <code>use_multiprocess=True</code> and <code>multiprocess</code> is not available</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">InputType</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">OutputType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">iterable</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">InputType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">parallel</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">pbar_kwargs</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">chunksize</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">keep_ordered</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_multiprocess</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">pbar</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">parallel</span><span class=\"o\">.</span><span class=\"n\">ProgressBarFunction</span><span class=\"p\">,</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;tqdm&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;spinner&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;none&#39;</span><span class=\"p\">,</span> <span class=\"kc\">None</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;tqdm&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">OutputType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.spinner": {"fullname": "muutils.spinner", "modulename": "muutils.spinner", "kind": "module", "doc": "<p>decorator <code>spinner_decorator</code> and context manager <code>SpinnerContext</code> to display a spinner</p>\n\n<p>using the base <code>Spinner</code> class while some code is running.</p>\n"}, "muutils.spinner.DecoratedFunction": {"fullname": "muutils.spinner.DecoratedFunction", "modulename": "muutils.spinner", "qualname": "DecoratedFunction", "kind": "variable", "doc": "<p>Define a generic type for the decorated function</p>\n", "default_value": "~DecoratedFunction"}, "muutils.spinner.SpinnerConfig": {"fullname": "muutils.spinner.SpinnerConfig", "modulename": "muutils.spinner", "qualname": "SpinnerConfig", "kind": "class", "doc": "<p></p>\n"}, "muutils.spinner.SpinnerConfig.__init__": {"fullname": "muutils.spinner.SpinnerConfig.__init__", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">working</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>, </span><span class=\"param\"><span class=\"n\">success</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;\u2714\ufe0f&#39;</span>, </span><span class=\"param\"><span class=\"n\">fail</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;\u274c&#39;</span></span>)</span>"}, "muutils.spinner.SpinnerConfig.working": {"fullname": "muutils.spinner.SpinnerConfig.working", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.working", "kind": "variable", "doc": "<p></p>\n", "annotation": ": List[str]"}, "muutils.spinner.SpinnerConfig.success": {"fullname": "muutils.spinner.SpinnerConfig.success", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.success", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;\u2714\ufe0f&#x27;"}, "muutils.spinner.SpinnerConfig.fail": {"fullname": "muutils.spinner.SpinnerConfig.fail", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.fail", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;\u274c&#x27;"}, "muutils.spinner.SpinnerConfig.is_ascii": {"fullname": "muutils.spinner.SpinnerConfig.is_ascii", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.is_ascii", "kind": "function", "doc": "<p>whether all characters are ascii</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.SpinnerConfig.eq_lens": {"fullname": "muutils.spinner.SpinnerConfig.eq_lens", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.eq_lens", "kind": "function", "doc": "<p>whether all working characters are the same length</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.SpinnerConfig.is_valid": {"fullname": "muutils.spinner.SpinnerConfig.is_valid", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.is_valid", "kind": "function", "doc": "<p>whether the spinner config is valid</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.SpinnerConfig.from_any": {"fullname": "muutils.spinner.SpinnerConfig.from_any", "modulename": "muutils.spinner", "qualname": "SpinnerConfig.from_any", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">arg</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">SpinnerConfig</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">SpinnerConfig</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.SpinnerConfigArg": {"fullname": "muutils.spinner.SpinnerConfigArg", "modulename": "muutils.spinner", "qualname": "SpinnerConfigArg", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[str, typing.List[str], muutils.spinner.SpinnerConfig, dict]"}, "muutils.spinner.SPINNERS": {"fullname": "muutils.spinner.SPINNERS", "modulename": "muutils.spinner", "qualname": "SPINNERS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, muutils.spinner.SpinnerConfig]", "default_value": "{&#x27;default&#x27;: SpinnerConfig(working=[&#x27;|&#x27;, &#x27;/&#x27;, &#x27;-&#x27;, &#x27;\\\\&#x27;], success=&#x27;#&#x27;, fail=&#x27;X&#x27;), &#x27;dots&#x27;: SpinnerConfig(working=[&#x27;.  &#x27;, &#x27;.. &#x27;, &#x27;...&#x27;], success=&#x27;***&#x27;, fail=&#x27;xxx&#x27;), &#x27;bars&#x27;: SpinnerConfig(working=[&#x27;|  &#x27;, &#x27;|| &#x27;, &#x27;|||&#x27;], success=&#x27;|||&#x27;, fail=&#x27;///&#x27;), &#x27;arrows&#x27;: SpinnerConfig(working=[&#x27;&lt;&#x27;, &#x27;^&#x27;, &#x27;&gt;&#x27;, &#x27;v&#x27;], success=&#x27;\u25ba&#x27;, fail=&#x27;\u2716&#x27;), &#x27;arrows_2&#x27;: SpinnerConfig(working=[&#x27;\u2190&#x27;, &#x27;\u2196&#x27;, &#x27;\u2191&#x27;, &#x27;\u2197&#x27;, &#x27;\u2192&#x27;, &#x27;\u2198&#x27;, &#x27;\u2193&#x27;, &#x27;\u2199&#x27;], success=&#x27;\u2192&#x27;, fail=&#x27;\u21af&#x27;), &#x27;bouncing_bar&#x27;: SpinnerConfig(working=[&#x27;[    ]&#x27;, &#x27;[=   ]&#x27;, &#x27;[==  ]&#x27;, &#x27;[=== ]&#x27;, &#x27;[ ===]&#x27;, &#x27;[  ==]&#x27;, &#x27;[   =]&#x27;], success=&#x27;[====]&#x27;, fail=&#x27;[XXXX]&#x27;), &#x27;bar&#x27;: SpinnerConfig(working=[&#x27;[  ]&#x27;, &#x27;[- ]&#x27;, &#x27;[--]&#x27;, &#x27;[ -]&#x27;], success=&#x27;[==]&#x27;, fail=&#x27;[xx]&#x27;), &#x27;bouncing_ball&#x27;: SpinnerConfig(working=[&#x27;( \u25cf    )&#x27;, &#x27;(  \u25cf   )&#x27;, &#x27;(   \u25cf  )&#x27;, &#x27;(    \u25cf )&#x27;, &#x27;(     \u25cf)&#x27;, &#x27;(    \u25cf )&#x27;, &#x27;(   \u25cf  )&#x27;, &#x27;(  \u25cf   )&#x27;, &#x27;( \u25cf    )&#x27;, &#x27;(\u25cf     )&#x27;], success=&#x27;(\u25cf\u25cf\u25cf\u25cf\u25cf\u25cf)&#x27;, fail=&#x27;(  \u2716  )&#x27;), &#x27;ooo&#x27;: SpinnerConfig(working=[&#x27;.&#x27;, &#x27;o&#x27;, &#x27;O&#x27;, &#x27;o&#x27;], success=&#x27;O&#x27;, fail=&#x27;x&#x27;), &#x27;braille&#x27;: SpinnerConfig(working=[&#x27;\u280b&#x27;, &#x27;\u2819&#x27;, &#x27;\u2839&#x27;, &#x27;\u2838&#x27;, &#x27;\u283c&#x27;, &#x27;\u2834&#x27;, &#x27;\u2826&#x27;, &#x27;\u2827&#x27;, &#x27;\u2807&#x27;, &#x27;\u280f&#x27;], success=&#x27;\u28ff&#x27;, fail=&#x27;X&#x27;), &#x27;clock&#x27;: SpinnerConfig(working=[&#x27;\ud83d\udd5b&#x27;, &#x27;\ud83d\udd50&#x27;, &#x27;\ud83d\udd51&#x27;, &#x27;\ud83d\udd52&#x27;, &#x27;\ud83d\udd53&#x27;, &#x27;\ud83d\udd54&#x27;, &#x27;\ud83d\udd55&#x27;, &#x27;\ud83d\udd56&#x27;, &#x27;\ud83d\udd57&#x27;, &#x27;\ud83d\udd58&#x27;, &#x27;\ud83d\udd59&#x27;, &#x27;\ud83d\udd5a&#x27;], success=&#x27;\u2714\ufe0f&#x27;, fail=&#x27;\u274c&#x27;), &#x27;hourglass&#x27;: SpinnerConfig(working=[&#x27;\u23f3&#x27;, &#x27;\u231b&#x27;], success=&#x27;\u2714\ufe0f&#x27;, fail=&#x27;\u274c&#x27;), &#x27;square_corners&#x27;: SpinnerConfig(working=[&#x27;\u25f0&#x27;, &#x27;\u25f3&#x27;, &#x27;\u25f2&#x27;, &#x27;\u25f1&#x27;], success=&#x27;\u25fc&#x27;, fail=&#x27;\u2716&#x27;), &#x27;triangle&#x27;: SpinnerConfig(working=[&#x27;\u25e2&#x27;, &#x27;\u25e3&#x27;, &#x27;\u25e4&#x27;, &#x27;\u25e5&#x27;], success=&#x27;\u25c6&#x27;, fail=&#x27;\u2716&#x27;), &#x27;square_dot&#x27;: SpinnerConfig(working=[&#x27;\u28f7&#x27;, &#x27;\u28ef&#x27;, &#x27;\u28df&#x27;, &#x27;\u287f&#x27;, &#x27;\u28bf&#x27;, &#x27;\u28fb&#x27;, &#x27;\u28fd&#x27;, &#x27;\u28fe&#x27;], success=&#x27;\u28ff&#x27;, fail=&#x27;\u274c&#x27;), &#x27;box_bounce&#x27;: SpinnerConfig(working=[&#x27;\u258c&#x27;, &#x27;\u2580&#x27;, &#x27;\u2590&#x27;, &#x27;\u2584&#x27;], success=&#x27;\u25a0&#x27;, fail=&#x27;\u2716&#x27;), &#x27;hamburger&#x27;: SpinnerConfig(working=[&#x27;\u2631&#x27;, &#x27;\u2632&#x27;, &#x27;\u2634&#x27;], success=&#x27;\u2630&#x27;, fail=&#x27;\u2716&#x27;), &#x27;earth&#x27;: SpinnerConfig(working=[&#x27;\ud83c\udf0d&#x27;, &#x27;\ud83c\udf0e&#x27;, &#x27;\ud83c\udf0f&#x27;], success=&#x27;\u2714\ufe0f&#x27;, fail=&#x27;\u274c&#x27;), &#x27;growing_dots&#x27;: SpinnerConfig(working=[&#x27;\u28c0&#x27;, &#x27;\u28c4&#x27;, &#x27;\u28e4&#x27;, &#x27;\u28e6&#x27;, &#x27;\u28f6&#x27;, &#x27;\u28f7&#x27;, &#x27;\u28ff&#x27;], success=&#x27;\u28ff&#x27;, fail=&#x27;\u2716&#x27;), &#x27;dice&#x27;: SpinnerConfig(working=[&#x27;\u2680&#x27;, &#x27;\u2681&#x27;, &#x27;\u2682&#x27;, &#x27;\u2683&#x27;, &#x27;\u2684&#x27;, &#x27;\u2685&#x27;], success=&#x27;\ud83c\udfb2&#x27;, fail=&#x27;\u2716&#x27;), &#x27;wifi&#x27;: SpinnerConfig(working=[&#x27;\u2581&#x27;, &#x27;\u2582&#x27;, &#x27;\u2583&#x27;, &#x27;\u2584&#x27;, &#x27;\u2585&#x27;, &#x27;\u2586&#x27;, &#x27;\u2587&#x27;, &#x27;\u2588&#x27;], success=&#x27;\u2714\ufe0f&#x27;, fail=&#x27;\u274c&#x27;), &#x27;bounce&#x27;: SpinnerConfig(working=[&#x27;\u2801&#x27;, &#x27;\u2802&#x27;, &#x27;\u2804&#x27;, &#x27;\u2802&#x27;], success=&#x27;\u283f&#x27;, fail=&#x27;\u28bf&#x27;), &#x27;arc&#x27;: SpinnerConfig(working=[&#x27;\u25dc&#x27;, &#x27;\u25e0&#x27;, &#x27;\u25dd&#x27;, &#x27;\u25de&#x27;, &#x27;\u25e1&#x27;, &#x27;\u25df&#x27;], success=&#x27;\u25cb&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle&#x27;: SpinnerConfig(working=[&#x27;\u22b6&#x27;, &#x27;\u22b7&#x27;], success=&#x27;\u22b7&#x27;, fail=&#x27;\u2297&#x27;), &#x27;toggle2&#x27;: SpinnerConfig(working=[&#x27;\u25ab&#x27;, &#x27;\u25aa&#x27;], success=&#x27;\u25aa&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle3&#x27;: SpinnerConfig(working=[&#x27;\u25a1&#x27;, &#x27;\u25a0&#x27;], success=&#x27;\u25a0&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle4&#x27;: SpinnerConfig(working=[&#x27;\u25a0&#x27;, &#x27;\u25a1&#x27;, &#x27;\u25aa&#x27;, &#x27;\u25ab&#x27;], success=&#x27;\u25a0&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle5&#x27;: SpinnerConfig(working=[&#x27;\u25ae&#x27;, &#x27;\u25af&#x27;], success=&#x27;\u25ae&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle7&#x27;: SpinnerConfig(working=[&#x27;\u29be&#x27;, &#x27;\u29bf&#x27;], success=&#x27;\u29bf&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle8&#x27;: SpinnerConfig(working=[&#x27;\u25cd&#x27;, &#x27;\u25cc&#x27;], success=&#x27;\u25cd&#x27;, fail=&#x27;\u2716&#x27;), &#x27;toggle9&#x27;: SpinnerConfig(working=[&#x27;\u25c9&#x27;, &#x27;\u25ce&#x27;], success=&#x27;\u25c9&#x27;, fail=&#x27;\u2716&#x27;), &#x27;arrow2&#x27;: SpinnerConfig(working=[&#x27;\u2b06\ufe0f &#x27;, &#x27;\u2197\ufe0f &#x27;, &#x27;\u27a1\ufe0f &#x27;, &#x27;\u2198\ufe0f &#x27;, &#x27;\u2b07\ufe0f &#x27;, &#x27;\u2199\ufe0f &#x27;, &#x27;\u2b05\ufe0f &#x27;, &#x27;\u2196\ufe0f &#x27;], success=&#x27;\u27a1\ufe0f&#x27;, fail=&#x27;\u274c&#x27;), &#x27;point&#x27;: SpinnerConfig(working=[&#x27;\u2219\u2219\u2219&#x27;, &#x27;\u25cf\u2219\u2219&#x27;, &#x27;\u2219\u25cf\u2219&#x27;, &#x27;\u2219\u2219\u25cf&#x27;, &#x27;\u2219\u2219\u2219&#x27;], success=&#x27;\u25cf\u25cf\u25cf&#x27;, fail=&#x27;xxx&#x27;), &#x27;layer&#x27;: SpinnerConfig(working=[&#x27;-&#x27;, &#x27;=&#x27;, &#x27;\u2261&#x27;], success=&#x27;\u2261&#x27;, fail=&#x27;\u2716&#x27;), &#x27;speaker&#x27;: SpinnerConfig(working=[&#x27;\ud83d\udd08 &#x27;, &#x27;\ud83d\udd09 &#x27;, &#x27;\ud83d\udd0a &#x27;, &#x27;\ud83d\udd09 &#x27;], success=&#x27;\ud83d\udd0a&#x27;, fail=&#x27;\ud83d\udd07&#x27;), &#x27;orangePulse&#x27;: SpinnerConfig(working=[&#x27;\ud83d\udd38 &#x27;, &#x27;\ud83d\udd36 &#x27;, &#x27;\ud83d\udfe0 &#x27;, &#x27;\ud83d\udfe0 &#x27;, &#x27;\ud83d\udd37 &#x27;], success=&#x27;\ud83d\udfe0&#x27;, fail=&#x27;\u274c&#x27;), &#x27;bluePulse&#x27;: SpinnerConfig(working=[&#x27;\ud83d\udd39 &#x27;, &#x27;\ud83d\udd37 &#x27;, &#x27;\ud83d\udd35 &#x27;, &#x27;\ud83d\udd35 &#x27;, &#x27;\ud83d\udd37 &#x27;], success=&#x27;\ud83d\udd35&#x27;, fail=&#x27;\u274c&#x27;), &#x27;satellite_signal&#x27;: SpinnerConfig(working=[&#x27;\ud83d\udce1   &#x27;, &#x27;\ud83d\udce1\u00b7  &#x27;, &#x27;\ud83d\udce1\u00b7\u00b7 &#x27;, &#x27;\ud83d\udce1\u00b7\u00b7\u00b7&#x27;, &#x27;\ud83d\udce1 \u00b7\u00b7&#x27;, &#x27;\ud83d\udce1  \u00b7&#x27;], success=&#x27;\ud83d\udce1 \u2714\ufe0f &#x27;, fail=&#x27;\ud83d\udce1 \u274c &#x27;), &#x27;rocket_orbit&#x27;: SpinnerConfig(working=[&#x27;\ud83c\udf0d\ud83d\ude80  &#x27;, &#x27;\ud83c\udf0f \ud83d\ude80 &#x27;, &#x27;\ud83c\udf0e  \ud83d\ude80&#x27;], success=&#x27;\ud83c\udf0d  \u2728&#x27;, fail=&#x27;\ud83c\udf0d  \ud83d\udca5&#x27;), &#x27;ogham&#x27;: SpinnerConfig(working=[&#x27;\u1681 &#x27;, &#x27;\u1682 &#x27;, &#x27;\u1683 &#x27;, &#x27;\u1684&#x27;, &#x27;\u1685&#x27;], success=&#x27;\u169b\u169c&#x27;, fail=&#x27;\u2716&#x27;), &#x27;eth&#x27;: SpinnerConfig(working=[&#x27;\u16eb&#x27;, &#x27;\u1361&#x27;, &#x27;\u1365&#x27;, &#x27;\u1364&#x27;, &#x27;\u1367&#x27;, &#x27;\u1362&#x27;, &#x27;\u1368&#x27;], success=&#x27;\u1360&#x27;, fail=&#x27;\u2716&#x27;)}"}, "muutils.spinner.Spinner": {"fullname": "muutils.spinner.Spinner", "modulename": "muutils.spinner", "qualname": "Spinner", "kind": "class", "doc": "<p>displays a spinner, and optionally elapsed time and a mutable value while a function is running.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>update_interval : float</code>\nhow often to update the spinner display in seconds\n(defaults to <code>0.1</code>)</li>\n<li><code>initial_value : str</code>\ninitial value to display with the spinner\n(defaults to <code>\"\"</code>)</li>\n<li><code>message : str</code>\nmessage to display with the spinner\n(defaults to <code>\"\"</code>)</li>\n<li><code>format_string : str</code>\nstring to format the spinner with. must have <code>\"\\r\"</code> prepended to clear the line.\nallowed keys are <code>spinner</code>, <code>elapsed_time</code>, <code>message</code>, and <code>value</code>\n(defaults to <code>\"\\r{spinner} ({elapsed_time:.2f}s) {message}{value}\"</code>)</li>\n<li><code>output_stream : TextIO</code>\nstream to write the spinner to\n(defaults to <code>sys.stdout</code>)</li>\n<li><code>format_string_when_updated : Union[bool,str]</code>\nwhether to use a different format string when the value is updated.\nif <code>True</code>, use the default format string with a newline appended. if a string, use that string.\nthis is useful if you want update_value to print to console and be preserved.\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"deprecated-parameters\">Deprecated Parameters:</h1>\n\n<ul>\n<li><code>spinner_chars : Union[str, Sequence[str]]</code>\nsequence of strings, or key to look up in <code>SPINNER_CHARS</code>, to use as the spinner characters\n(defaults to <code>\"default\"</code>)</li>\n<li><code>spinner_complete : str</code>\nstring to display when the spinner is complete\n(defaults to looking up <code>spinner_chars</code> in <code>SPINNER_COMPLETE</code> or <code>\"#\"</code>)</li>\n</ul>\n\n<h1 id=\"methods\">Methods:</h1>\n\n<ul>\n<li><code>update_value(value: Any) -&gt; None</code>\nupdate the current value displayed by the spinner</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<h2 id=\"as-a-context-manager\">As a context manager:</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">with</span> <span class=\"n\">SpinnerContext</span><span class=\"p\">()</span> <span class=\"k\">as</span> <span class=\"n\">sp</span><span class=\"p\">:</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n        <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">)</span>\n        <span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">update_value</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Step </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"o\">+</span><span class=\"mi\">1</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"as-a-decorator\">As a decorator:</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@spinner_decorator</span>\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">long_running_function</span><span class=\"p\">():</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n        <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">)</span>\n        <span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">update_value</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Step </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"o\">+</span><span class=\"mi\">1</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n    <span class=\"k\">return</span> <span class=\"s2\">&quot;Function completed&quot;</span>\n</code></pre>\n</div>\n"}, "muutils.spinner.Spinner.__init__": {"fullname": "muutils.spinner.Spinner.__init__", "modulename": "muutils.spinner", "qualname": "Spinner.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">SpinnerConfig</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;default&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">update_interval</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.1</span>,</span><span class=\"param\">\t<span class=\"n\">initial_value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">format_string</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"se\">\\r</span><span class=\"si\">{spinner}</span><span class=\"s1\"> (</span><span class=\"si\">{elapsed_time:.2f}</span><span class=\"s1\">s) </span><span class=\"si\">{message}{value}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\toutput_stream: &lt;class &#x27;TextIO&#x27;&gt; = &lt;_io.TextIOWrapper encoding=&#x27;UTF-8&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">format_string_when_updated</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">spinner_chars</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">spinner_complete</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "muutils.spinner.Spinner.config": {"fullname": "muutils.spinner.Spinner.config", "modulename": "muutils.spinner", "qualname": "Spinner.config", "kind": "variable", "doc": "<p></p>\n", "annotation": ": muutils.spinner.SpinnerConfig"}, "muutils.spinner.Spinner.format_string_when_updated": {"fullname": "muutils.spinner.Spinner.format_string_when_updated", "modulename": "muutils.spinner", "qualname": "Spinner.format_string_when_updated", "kind": "variable", "doc": "<p>format string to use when the value is updated</p>\n", "annotation": ": Optional[str]"}, "muutils.spinner.Spinner.update_interval": {"fullname": "muutils.spinner.Spinner.update_interval", "modulename": "muutils.spinner", "qualname": "Spinner.update_interval", "kind": "variable", "doc": "<p></p>\n", "annotation": ": float"}, "muutils.spinner.Spinner.message": {"fullname": "muutils.spinner.Spinner.message", "modulename": "muutils.spinner", "qualname": "Spinner.message", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.spinner.Spinner.current_value": {"fullname": "muutils.spinner.Spinner.current_value", "modulename": "muutils.spinner", "qualname": "Spinner.current_value", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Any"}, "muutils.spinner.Spinner.format_string": {"fullname": "muutils.spinner.Spinner.format_string", "modulename": "muutils.spinner", "qualname": "Spinner.format_string", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "muutils.spinner.Spinner.output_stream": {"fullname": "muutils.spinner.Spinner.output_stream", "modulename": "muutils.spinner", "qualname": "Spinner.output_stream", "kind": "variable", "doc": "<p></p>\n", "annotation": ": &lt;class &#x27;TextIO&#x27;&gt;"}, "muutils.spinner.Spinner.start_time": {"fullname": "muutils.spinner.Spinner.start_time", "modulename": "muutils.spinner", "qualname": "Spinner.start_time", "kind": "variable", "doc": "<p>for measuring elapsed time</p>\n", "annotation": ": float"}, "muutils.spinner.Spinner.stop_spinner": {"fullname": "muutils.spinner.Spinner.stop_spinner", "modulename": "muutils.spinner", "qualname": "Spinner.stop_spinner", "kind": "variable", "doc": "<p>to stop the spinner</p>\n", "annotation": ": threading.Event"}, "muutils.spinner.Spinner.spinner_thread": {"fullname": "muutils.spinner.Spinner.spinner_thread", "modulename": "muutils.spinner", "qualname": "Spinner.spinner_thread", "kind": "variable", "doc": "<p>the thread running the spinner</p>\n", "annotation": ": Optional[threading.Thread]"}, "muutils.spinner.Spinner.value_changed": {"fullname": "muutils.spinner.Spinner.value_changed", "modulename": "muutils.spinner", "qualname": "Spinner.value_changed", "kind": "variable", "doc": "<p>whether the value has been updated since the last display</p>\n", "annotation": ": bool"}, "muutils.spinner.Spinner.term_width": {"fullname": "muutils.spinner.Spinner.term_width", "modulename": "muutils.spinner", "qualname": "Spinner.term_width", "kind": "variable", "doc": "<p>width of the terminal, for padding with spaces</p>\n", "annotation": ": int"}, "muutils.spinner.Spinner.state": {"fullname": "muutils.spinner.Spinner.state", "modulename": "muutils.spinner", "qualname": "Spinner.state", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;initialized&#x27;, &#x27;running&#x27;, &#x27;success&#x27;, &#x27;fail&#x27;]"}, "muutils.spinner.Spinner.spin": {"fullname": "muutils.spinner.Spinner.spin", "modulename": "muutils.spinner", "qualname": "Spinner.spin", "kind": "function", "doc": "<p>Function to run in a separate thread, displaying the spinner and optional information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.Spinner.update_value": {"fullname": "muutils.spinner.Spinner.update_value", "modulename": "muutils.spinner", "qualname": "Spinner.update_value", "kind": "function", "doc": "<p>Update the current value displayed by the spinner</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.Spinner.start": {"fullname": "muutils.spinner.Spinner.start", "modulename": "muutils.spinner", "qualname": "Spinner.start", "kind": "function", "doc": "<p>Start the spinner</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.Spinner.stop": {"fullname": "muutils.spinner.Spinner.stop", "modulename": "muutils.spinner", "qualname": "Spinner.stop", "kind": "function", "doc": "<p>Stop the spinner</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">failed</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.spinner.NoOpContextManager": {"fullname": "muutils.spinner.NoOpContextManager", "modulename": "muutils.spinner", "qualname": "NoOpContextManager", "kind": "class", "doc": "<p>A context manager that does nothing.</p>\n", "bases": "typing.ContextManager"}, "muutils.spinner.NoOpContextManager.__init__": {"fullname": "muutils.spinner.NoOpContextManager.__init__", "modulename": "muutils.spinner", "qualname": "NoOpContextManager.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "muutils.spinner.SpinnerContext": {"fullname": "muutils.spinner.SpinnerContext", "modulename": "muutils.spinner", "qualname": "SpinnerContext", "kind": "class", "doc": "<p>displays a spinner, and optionally elapsed time and a mutable value while a function is running.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>update_interval : float</code>\nhow often to update the spinner display in seconds\n(defaults to <code>0.1</code>)</li>\n<li><code>initial_value : str</code>\ninitial value to display with the spinner\n(defaults to <code>\"\"</code>)</li>\n<li><code>message : str</code>\nmessage to display with the spinner\n(defaults to <code>\"\"</code>)</li>\n<li><code>format_string : str</code>\nstring to format the spinner with. must have <code>\"\\r\"</code> prepended to clear the line.\nallowed keys are <code>spinner</code>, <code>elapsed_time</code>, <code>message</code>, and <code>value</code>\n(defaults to <code>\"\\r{spinner} ({elapsed_time:.2f}s) {message}{value}\"</code>)</li>\n<li><code>output_stream : TextIO</code>\nstream to write the spinner to\n(defaults to <code>sys.stdout</code>)</li>\n<li><code>format_string_when_updated : Union[bool,str]</code>\nwhether to use a different format string when the value is updated.\nif <code>True</code>, use the default format string with a newline appended. if a string, use that string.\nthis is useful if you want update_value to print to console and be preserved.\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"deprecated-parameters\">Deprecated Parameters:</h1>\n\n<ul>\n<li><code>spinner_chars : Union[str, Sequence[str]]</code>\nsequence of strings, or key to look up in <code>SPINNER_CHARS</code>, to use as the spinner characters\n(defaults to <code>\"default\"</code>)</li>\n<li><code>spinner_complete : str</code>\nstring to display when the spinner is complete\n(defaults to looking up <code>spinner_chars</code> in <code>SPINNER_COMPLETE</code> or <code>\"#\"</code>)</li>\n</ul>\n\n<h1 id=\"methods\">Methods:</h1>\n\n<ul>\n<li><code>update_value(value: Any) -&gt; None</code>\nupdate the current value displayed by the spinner</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<h2 id=\"as-a-context-manager\">As a context manager:</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">with</span> <span class=\"n\">SpinnerContext</span><span class=\"p\">()</span> <span class=\"k\">as</span> <span class=\"n\">sp</span><span class=\"p\">:</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n        <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">)</span>\n        <span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">update_value</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Step </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"o\">+</span><span class=\"mi\">1</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"as-a-decorator\">As a decorator:</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@spinner_decorator</span>\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">long_running_function</span><span class=\"p\">():</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n        <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">)</span>\n        <span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">update_value</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Step </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"o\">+</span><span class=\"mi\">1</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n    <span class=\"k\">return</span> <span class=\"s2\">&quot;Function completed&quot;</span>\n</code></pre>\n</div>\n", "bases": "Spinner, typing.ContextManager"}, "muutils.spinner.spinner_decorator": {"fullname": "muutils.spinner.spinner_decorator", "modulename": "muutils.spinner", "qualname": "spinner_decorator", "kind": "function", "doc": "<p>displays a spinner, and optionally elapsed time and a mutable value while a function is running.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>update_interval : float</code>\nhow often to update the spinner display in seconds\n(defaults to <code>0.1</code>)</li>\n<li><code>initial_value : str</code>\ninitial value to display with the spinner\n(defaults to <code>\"\"</code>)</li>\n<li><code>message : str</code>\nmessage to display with the spinner\n(defaults to <code>\"\"</code>)</li>\n<li><code>format_string : str</code>\nstring to format the spinner with. must have <code>\"\\r\"</code> prepended to clear the line.\nallowed keys are <code>spinner</code>, <code>elapsed_time</code>, <code>message</code>, and <code>value</code>\n(defaults to <code>\"\\r{spinner} ({elapsed_time:.2f}s) {message}{value}\"</code>)</li>\n<li><code>output_stream : TextIO</code>\nstream to write the spinner to\n(defaults to <code>sys.stdout</code>)</li>\n<li><code>format_string_when_updated : Union[bool,str]</code>\nwhether to use a different format string when the value is updated.\nif <code>True</code>, use the default format string with a newline appended. if a string, use that string.\nthis is useful if you want update_value to print to console and be preserved.\n(defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"deprecated-parameters\">Deprecated Parameters:</h1>\n\n<ul>\n<li><code>spinner_chars : Union[str, Sequence[str]]</code>\nsequence of strings, or key to look up in <code>SPINNER_CHARS</code>, to use as the spinner characters\n(defaults to <code>\"default\"</code>)</li>\n<li><code>spinner_complete : str</code>\nstring to display when the spinner is complete\n(defaults to looking up <code>spinner_chars</code> in <code>SPINNER_COMPLETE</code> or <code>\"#\"</code>)</li>\n</ul>\n\n<h1 id=\"methods\">Methods:</h1>\n\n<ul>\n<li><code>update_value(value: Any) -&gt; None</code>\nupdate the current value displayed by the spinner</li>\n</ul>\n\n<h1 id=\"usage\">Usage:</h1>\n\n<h2 id=\"as-a-context-manager\">As a context manager:</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">with</span> <span class=\"n\">SpinnerContext</span><span class=\"p\">()</span> <span class=\"k\">as</span> <span class=\"n\">sp</span><span class=\"p\">:</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n        <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">)</span>\n        <span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">update_value</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Step </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"o\">+</span><span class=\"mi\">1</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"as-a-decorator\">As a decorator:</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nd\">@spinner_decorator</span>\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">long_running_function</span><span class=\"p\">():</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n        <span class=\"n\">time</span><span class=\"o\">.</span><span class=\"n\">sleep</span><span class=\"p\">(</span><span class=\"mf\">0.1</span><span class=\"p\">)</span>\n        <span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">update_value</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Step </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"o\">+</span><span class=\"mi\">1</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n    <span class=\"k\">return</span> <span class=\"s2\">&quot;Function completed&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">spinner</span><span class=\"o\">.</span><span class=\"n\">SpinnerConfig</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;default&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">update_interval</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.1</span>,</span><span class=\"param\">\t<span class=\"n\">initial_value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">format_string</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"si\">{spinner}</span><span class=\"s1\"> (</span><span class=\"si\">{elapsed_time:.2f}</span><span class=\"s1\">s) </span><span class=\"si\">{message}{value}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\toutput_stream: &lt;class &#x27;TextIO&#x27;&gt; = &lt;_io.TextIOWrapper encoding=&#x27;UTF-8&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">mutable_kwarg_key</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">spinner_chars</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">spinner_complete</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"o\">~</span><span class=\"n\">DecoratedFunction</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">DecoratedFunction</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter": {"fullname": "muutils.statcounter", "modulename": "muutils.statcounter", "kind": "module", "doc": "<p><code>StatCounter</code> class for counting and calculating statistics on numbers</p>\n\n<p>cleaner and more efficient than just using a <code>Counter</code> or array</p>\n"}, "muutils.statcounter.NumericSequence": {"fullname": "muutils.statcounter.NumericSequence", "modulename": "muutils.statcounter", "qualname": "NumericSequence", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Sequence[typing.Union[float, int, ForwardRef(&#x27;NumericSequence&#x27;)]]"}, "muutils.statcounter.universal_flatten": {"fullname": "muutils.statcounter.universal_flatten", "modulename": "muutils.statcounter", "qualname": "universal_flatten", "kind": "function", "doc": "<p>flattens any iterable</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">arr</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">ForwardRef</span><span class=\"p\">(</span><span class=\"s1\">&#39;NumericSequence&#39;</span><span class=\"p\">)]]]],</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">require_rectangular</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">ForwardRef</span><span class=\"p\">(</span><span class=\"s1\">&#39;NumericSequence&#39;</span><span class=\"p\">)]]</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter": {"fullname": "muutils.statcounter.StatCounter", "modulename": "muutils.statcounter", "qualname": "StatCounter", "kind": "class", "doc": "<p><code>Counter</code>, but with some stat calculation methods which assume the keys are numerical</p>\n\n<p>works best when the keys are <code>int</code>s</p>\n", "bases": "collections.Counter"}, "muutils.statcounter.StatCounter.validate": {"fullname": "muutils.statcounter.StatCounter.validate", "modulename": "muutils.statcounter", "qualname": "StatCounter.validate", "kind": "function", "doc": "<p>validate the counter as being all floats or ints</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.min": {"fullname": "muutils.statcounter.StatCounter.min", "modulename": "muutils.statcounter", "qualname": "StatCounter.min", "kind": "function", "doc": "<p>minimum value</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.max": {"fullname": "muutils.statcounter.StatCounter.max", "modulename": "muutils.statcounter", "qualname": "StatCounter.max", "kind": "function", "doc": "<p>maximum value</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.total": {"fullname": "muutils.statcounter.StatCounter.total", "modulename": "muutils.statcounter", "qualname": "StatCounter.total", "kind": "function", "doc": "<p>Sum of the counts</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.keys_sorted": {"fullname": "muutils.statcounter.StatCounter.keys_sorted", "modulename": "muutils.statcounter", "qualname": "StatCounter.keys_sorted", "kind": "variable", "doc": "<p>return the keys</p>\n", "annotation": ": list"}, "muutils.statcounter.StatCounter.percentile": {"fullname": "muutils.statcounter.StatCounter.percentile", "modulename": "muutils.statcounter", "qualname": "StatCounter.percentile", "kind": "function", "doc": "<p>return the value at the given percentile</p>\n\n<p>this could be log time if we did binary search, but that would be a lot of added complexity</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">p</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.median": {"fullname": "muutils.statcounter.StatCounter.median", "modulename": "muutils.statcounter", "qualname": "StatCounter.median", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.mean": {"fullname": "muutils.statcounter.StatCounter.mean", "modulename": "muutils.statcounter", "qualname": "StatCounter.mean", "kind": "function", "doc": "<p>return the mean of the values</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.mode": {"fullname": "muutils.statcounter.StatCounter.mode", "modulename": "muutils.statcounter", "qualname": "StatCounter.mode", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.std": {"fullname": "muutils.statcounter.StatCounter.std", "modulename": "muutils.statcounter", "qualname": "StatCounter.std", "kind": "function", "doc": "<p>return the standard deviation of the values</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.summary": {"fullname": "muutils.statcounter.StatCounter.summary", "modulename": "muutils.statcounter", "qualname": "StatCounter.summary", "kind": "function", "doc": "<p>return a summary of the stats, without the raw data. human readable and small</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">typecast</span><span class=\"p\">:</span> <span class=\"n\">Callable</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">function</span> <span class=\"n\">StatCounter</span><span class=\"o\">.&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">extra_percentiles</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.serialize": {"fullname": "muutils.statcounter.StatCounter.serialize", "modulename": "muutils.statcounter", "qualname": "StatCounter.serialize", "kind": "function", "doc": "<p>return a json-serializable version of the counter</p>\n\n<p>includes both the output of <code>summary</code> and the raw data:</p>\n\n<p>```json\n{\n    \"StatCounter\": { <keys, values from raw data> },\n    \"summary\": self.summary(typecast, extra_percentiles=extra_percentiles),\n}</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">typecast</span><span class=\"p\">:</span> <span class=\"n\">Callable</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">function</span> <span class=\"n\">StatCounter</span><span class=\"o\">.&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">extra_percentiles</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.load": {"fullname": "muutils.statcounter.StatCounter.load", "modulename": "muutils.statcounter", "qualname": "StatCounter.load", "kind": "function", "doc": "<p>load from a the output of <code>StatCounter.serialize</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">statcounter</span><span class=\"o\">.</span><span class=\"n\">StatCounter</span>:</span></span>", "funcdef": "def"}, "muutils.statcounter.StatCounter.from_list_arrays": {"fullname": "muutils.statcounter.StatCounter.from_list_arrays", "modulename": "muutils.statcounter", "qualname": "StatCounter.from_list_arrays", "kind": "function", "doc": "<p>calls <code>map_func</code> on each element of <code>universal_flatten(arr)</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">arr</span>,</span><span class=\"param\">\tmap_func: Callable = &lt;class &#x27;float&#x27;&gt;</span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">statcounter</span><span class=\"o\">.</span><span class=\"n\">StatCounter</span>:</span></span>", "funcdef": "def"}, "muutils.sysinfo": {"fullname": "muutils.sysinfo", "modulename": "muutils.sysinfo", "kind": "module", "doc": "<p>utilities for getting information about the system, see <code>SysInfo</code> class</p>\n"}, "muutils.sysinfo.SysInfo": {"fullname": "muutils.sysinfo.SysInfo", "modulename": "muutils.sysinfo", "qualname": "SysInfo", "kind": "class", "doc": "<p>getters for various information about the system</p>\n"}, "muutils.sysinfo.SysInfo.python": {"fullname": "muutils.sysinfo.SysInfo.python", "modulename": "muutils.sysinfo", "qualname": "SysInfo.python", "kind": "function", "doc": "<p>details about python version</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.sysinfo.SysInfo.pip": {"fullname": "muutils.sysinfo.SysInfo.pip", "modulename": "muutils.sysinfo", "qualname": "SysInfo.pip", "kind": "function", "doc": "<p>installed packages info</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.sysinfo.SysInfo.pytorch": {"fullname": "muutils.sysinfo.SysInfo.pytorch", "modulename": "muutils.sysinfo", "qualname": "SysInfo.pytorch", "kind": "function", "doc": "<p>pytorch and cuda information</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.sysinfo.SysInfo.platform": {"fullname": "muutils.sysinfo.SysInfo.platform", "modulename": "muutils.sysinfo", "qualname": "SysInfo.platform", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.sysinfo.SysInfo.git_info": {"fullname": "muutils.sysinfo.SysInfo.git_info", "modulename": "muutils.sysinfo", "qualname": "SysInfo.git_info", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">with_log</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.sysinfo.SysInfo.get_all": {"fullname": "muutils.sysinfo.SysInfo.get_all", "modulename": "muutils.sysinfo", "qualname": "SysInfo.get_all", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">include</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">exclude</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info": {"fullname": "muutils.tensor_info", "modulename": "muutils.tensor_info", "kind": "module", "doc": "<p>get metadata about a tensor, mostly for <code>muutils.dbg</code></p>\n"}, "muutils.tensor_info.COLORS": {"fullname": "muutils.tensor_info.COLORS", "modulename": "muutils.tensor_info", "qualname": "COLORS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, Dict[str, str]]", "default_value": "{&#x27;latex&#x27;: {&#x27;range&#x27;: &#x27;\\\\textcolor{purple}&#x27;, &#x27;mean&#x27;: &#x27;\\\\textcolor{teal}&#x27;, &#x27;std&#x27;: &#x27;\\\\textcolor{orange}&#x27;, &#x27;median&#x27;: &#x27;\\\\textcolor{green}&#x27;, &#x27;warning&#x27;: &#x27;\\\\textcolor{red}&#x27;, &#x27;shape&#x27;: &#x27;\\\\textcolor{magenta}&#x27;, &#x27;dtype&#x27;: &#x27;\\\\textcolor{gray}&#x27;, &#x27;device&#x27;: &#x27;\\\\textcolor{gray}&#x27;, &#x27;requires_grad&#x27;: &#x27;\\\\textcolor{gray}&#x27;, &#x27;sparkline&#x27;: &#x27;\\\\textcolor{blue}&#x27;, &#x27;torch&#x27;: &#x27;\\\\textcolor{orange}&#x27;, &#x27;dtype_bool&#x27;: &#x27;\\\\textcolor{gray}&#x27;, &#x27;dtype_int&#x27;: &#x27;\\\\textcolor{blue}&#x27;, &#x27;dtype_float&#x27;: &#x27;\\\\textcolor{red!70}&#x27;, &#x27;dtype_str&#x27;: &#x27;\\\\textcolor{red}&#x27;, &#x27;device_cuda&#x27;: &#x27;\\\\textcolor{green}&#x27;, &#x27;reset&#x27;: &#x27;&#x27;}, &#x27;terminal&#x27;: {&#x27;range&#x27;: &#x27;\\x1b[35m&#x27;, &#x27;mean&#x27;: &#x27;\\x1b[36m&#x27;, &#x27;std&#x27;: &#x27;\\x1b[33m&#x27;, &#x27;median&#x27;: &#x27;\\x1b[32m&#x27;, &#x27;warning&#x27;: &#x27;\\x1b[31m&#x27;, &#x27;shape&#x27;: &#x27;\\x1b[95m&#x27;, &#x27;dtype&#x27;: &#x27;\\x1b[90m&#x27;, &#x27;device&#x27;: &#x27;\\x1b[90m&#x27;, &#x27;requires_grad&#x27;: &#x27;\\x1b[90m&#x27;, &#x27;sparkline&#x27;: &#x27;\\x1b[34m&#x27;, &#x27;torch&#x27;: &#x27;\\x1b[38;5;208m&#x27;, &#x27;dtype_bool&#x27;: &#x27;\\x1b[38;5;245m&#x27;, &#x27;dtype_int&#x27;: &#x27;\\x1b[38;5;39m&#x27;, &#x27;dtype_float&#x27;: &#x27;\\x1b[38;5;167m&#x27;, &#x27;device_cuda&#x27;: &#x27;\\x1b[38;5;76m&#x27;, &#x27;reset&#x27;: &#x27;\\x1b[0m&#x27;}, &#x27;none&#x27;: {&#x27;range&#x27;: &#x27;&#x27;, &#x27;mean&#x27;: &#x27;&#x27;, &#x27;std&#x27;: &#x27;&#x27;, &#x27;median&#x27;: &#x27;&#x27;, &#x27;warning&#x27;: &#x27;&#x27;, &#x27;shape&#x27;: &#x27;&#x27;, &#x27;dtype&#x27;: &#x27;&#x27;, &#x27;device&#x27;: &#x27;&#x27;, &#x27;requires_grad&#x27;: &#x27;&#x27;, &#x27;sparkline&#x27;: &#x27;&#x27;, &#x27;torch&#x27;: &#x27;&#x27;, &#x27;dtype_bool&#x27;: &#x27;&#x27;, &#x27;dtype_int&#x27;: &#x27;&#x27;, &#x27;dtype_float&#x27;: &#x27;&#x27;, &#x27;dtype_str&#x27;: &#x27;&#x27;, &#x27;device_cuda&#x27;: &#x27;&#x27;, &#x27;reset&#x27;: &#x27;&#x27;}}"}, "muutils.tensor_info.OutputFormat": {"fullname": "muutils.tensor_info.OutputFormat", "modulename": "muutils.tensor_info", "qualname": "OutputFormat", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;unicode&#x27;, &#x27;latex&#x27;, &#x27;ascii&#x27;]"}, "muutils.tensor_info.SYMBOLS": {"fullname": "muutils.tensor_info.SYMBOLS", "modulename": "muutils.tensor_info", "qualname": "SYMBOLS", "kind": "variable", "doc": "<p>Symbols for different formats</p>\n", "annotation": ": Dict[Literal[&#x27;unicode&#x27;, &#x27;latex&#x27;, &#x27;ascii&#x27;], Dict[str, str]]", "default_value": "{&#x27;latex&#x27;: {&#x27;range&#x27;: &#x27;\\\\mathcal{R}&#x27;, &#x27;mean&#x27;: &#x27;\\\\mu&#x27;, &#x27;std&#x27;: &#x27;\\\\sigma&#x27;, &#x27;median&#x27;: &#x27;\\\\tilde{x}&#x27;, &#x27;distribution&#x27;: &#x27;\\\\mathbb{P}&#x27;, &#x27;distribution_log&#x27;: &#x27;\\\\mathbb{P}_L&#x27;, &#x27;nan_values&#x27;: &#x27;\\\\text{NANvals}&#x27;, &#x27;warning&#x27;: &#x27;!!!&#x27;, &#x27;requires_grad&#x27;: &#x27;\\\\nabla&#x27;, &#x27;true&#x27;: &#x27;\\\\checkmark&#x27;, &#x27;false&#x27;: &#x27;\\\\times&#x27;}, &#x27;unicode&#x27;: {&#x27;range&#x27;: &#x27;R&#x27;, &#x27;mean&#x27;: &#x27;\u03bc&#x27;, &#x27;std&#x27;: &#x27;\u03c3&#x27;, &#x27;median&#x27;: &#x27;x\u0303&#x27;, &#x27;distribution&#x27;: &#x27;\u2119&#x27;, &#x27;distribution_log&#x27;: &#x27;\u2119\u02ea&#x27;, &#x27;nan_values&#x27;: &#x27;NANvals&#x27;, &#x27;warning&#x27;: &#x27;\ud83d\udea8&#x27;, &#x27;requires_grad&#x27;: &#x27;\u2207&#x27;, &#x27;true&#x27;: &#x27;\u2713&#x27;, &#x27;false&#x27;: &#x27;\u2717&#x27;}, &#x27;ascii&#x27;: {&#x27;range&#x27;: &#x27;range&#x27;, &#x27;mean&#x27;: &#x27;mean&#x27;, &#x27;std&#x27;: &#x27;std&#x27;, &#x27;median&#x27;: &#x27;med&#x27;, &#x27;distribution&#x27;: &#x27;dist&#x27;, &#x27;distribution_log&#x27;: &#x27;dist_log&#x27;, &#x27;nan_values&#x27;: &#x27;NANvals&#x27;, &#x27;warning&#x27;: &#x27;!!!&#x27;, &#x27;requires_grad&#x27;: &#x27;requires_grad&#x27;, &#x27;true&#x27;: &#x27;1&#x27;, &#x27;false&#x27;: &#x27;0&#x27;}}"}, "muutils.tensor_info.SPARK_CHARS": {"fullname": "muutils.tensor_info.SPARK_CHARS", "modulename": "muutils.tensor_info", "qualname": "SPARK_CHARS", "kind": "variable", "doc": "<p>characters for sparklines in different formats</p>\n", "annotation": ": Dict[Literal[&#x27;unicode&#x27;, &#x27;latex&#x27;, &#x27;ascii&#x27;], List[str]]", "default_value": "{&#x27;unicode&#x27;: [&#x27; &#x27;, &#x27;\u2581&#x27;, &#x27;\u2582&#x27;, &#x27;\u2583&#x27;, &#x27;\u2584&#x27;, &#x27;\u2585&#x27;, &#x27;\u2586&#x27;, &#x27;\u2587&#x27;, &#x27;\u2588&#x27;], &#x27;ascii&#x27;: [&#x27; &#x27;, &#x27;_&#x27;, &#x27;.&#x27;, &#x27;-&#x27;, &#x27;~&#x27;, &#x27;=&#x27;, &#x27;#&#x27;], &#x27;latex&#x27;: [&#x27; &#x27;, &#x27;\u2581&#x27;, &#x27;\u2582&#x27;, &#x27;\u2583&#x27;, &#x27;\u2584&#x27;, &#x27;\u2585&#x27;, &#x27;\u2586&#x27;, &#x27;\u2587&#x27;, &#x27;\u2588&#x27;]}"}, "muutils.tensor_info.array_info": {"fullname": "muutils.tensor_info.array_info", "modulename": "muutils.tensor_info", "qualname": "array_info", "kind": "function", "doc": "<p>Extract statistical information from an array-like object.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>A : array-like</code>\nArray to analyze (numpy array or torch tensor)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Dict[str, Any]</code>\nDictionary containing raw statistical information with numeric values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">A</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">hist_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info.generate_sparkline": {"fullname": "muutils.tensor_info.generate_sparkline", "modulename": "muutils.tensor_info", "qualname": "generate_sparkline", "kind": "function", "doc": "<p>Generate a sparkline visualization of the histogram.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>histogram : np.ndarray</code>\nHistogram data</li>\n<li><code>format : Literal[\"unicode\", \"latex\", \"ascii\"]</code>\nOutput format (defaults to <code>\"unicode\"</code>)</li>\n<li><code>log_y : bool|None</code>\nWhether to use logarithmic y-scale. <code>None</code> for automatic detection\n(defaults to <code>None</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>tuple[str, bool]</code>\nSparkline visualization and whether log scale was used</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">histogram</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"nb\">format</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;unicode&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;latex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ascii&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;unicode&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">log_y</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info.DEFAULT_SETTINGS": {"fullname": "muutils.tensor_info.DEFAULT_SETTINGS", "modulename": "muutils.tensor_info", "qualname": "DEFAULT_SETTINGS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, Any]", "default_value": "{&#x27;fmt&#x27;: &#x27;unicode&#x27;, &#x27;precision&#x27;: 2, &#x27;stats&#x27;: True, &#x27;shape&#x27;: True, &#x27;dtype&#x27;: True, &#x27;device&#x27;: True, &#x27;requires_grad&#x27;: True, &#x27;sparkline&#x27;: False, &#x27;sparkline_bins&#x27;: 5, &#x27;sparkline_logy&#x27;: None, &#x27;colored&#x27;: False, &#x27;as_list&#x27;: False, &#x27;eq_char&#x27;: &#x27;=&#x27;}"}, "muutils.tensor_info.apply_color": {"fullname": "muutils.tensor_info.apply_color", "modulename": "muutils.tensor_info", "qualname": "apply_color", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">color_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">colors</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">using_tex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info.colorize_dtype": {"fullname": "muutils.tensor_info.colorize_dtype", "modulename": "muutils.tensor_info", "qualname": "colorize_dtype", "kind": "function", "doc": "<p>Colorize dtype string with specific colors for torch and type names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dtype_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">colors</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">using_tex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info.format_shape_colored": {"fullname": "muutils.tensor_info.format_shape_colored", "modulename": "muutils.tensor_info", "qualname": "format_shape_colored", "kind": "function", "doc": "<p>Format shape with proper coloring for both 1D and multi-D arrays.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">shape_val</span>, </span><span class=\"param\"><span class=\"n\">colors</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">using_tex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info.format_device_colored": {"fullname": "muutils.tensor_info.format_device_colored", "modulename": "muutils.tensor_info", "qualname": "format_device_colored", "kind": "function", "doc": "<p>Format device string with CUDA highlighting.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">device_str</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">colors</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">using_tex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_info.array_summary": {"fullname": "muutils.tensor_info.array_summary", "modulename": "muutils.tensor_info", "qualname": "array_summary", "kind": "function", "doc": "<p>Format array information into a readable summary.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>array</code>\narray-like object (numpy array or torch tensor)</li>\n<li><code>precision : int</code>\nDecimal places (defaults to <code>2</code>)</li>\n<li><code>format : Literal[\"unicode\", \"latex\", \"ascii\"]</code>\nOutput format (defaults to <code>{default_fmt}</code>)</li>\n<li><code>stats : bool</code>\nWhether to include statistical info (\u03bc, \u03c3, x\u0303) (defaults to <code>True</code>)</li>\n<li><code>shape : bool</code>\nWhether to include shape info (defaults to <code>True</code>)</li>\n<li><code>dtype : bool</code>\nWhether to include dtype info (defaults to <code>True</code>)</li>\n<li><code>device : bool</code>\nWhether to include device info for torch tensors (defaults to <code>True</code>)</li>\n<li><code>requires_grad : bool</code>\nWhether to include requires_grad info for torch tensors (defaults to <code>True</code>)</li>\n<li><code>sparkline : bool</code>\nWhether to include a sparkline visualization (defaults to <code>False</code>)</li>\n<li><code>sparkline_width : int</code>\nWidth of the sparkline (defaults to <code>20</code>)</li>\n<li><code>sparkline_logy : bool|None</code>\nWhether to use logarithmic y-scale for sparkline (defaults to <code>None</code>)</li>\n<li><code>colored : bool</code>\nWhether to add color to output (defaults to <code>False</code>)</li>\n<li><code>as_list : bool</code>\nWhether to return as list of strings instead of joined string (defaults to <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>Union[str, List[str]]</code>\nFormatted statistical summary, either as string or list of strings</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">array</span>,</span><span class=\"param\">\t<span class=\"n\">fmt</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;unicode&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;latex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ascii&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">precision</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">stats</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">shape</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">dtype</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">device</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">requires_grad</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">sparkline</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">sparkline_bins</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">sparkline_logy</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">colored</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">eq_char</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">as_list</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">tensor_info</span><span class=\"o\">.</span><span class=\"n\">_UseDefaultType</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils": {"fullname": "muutils.tensor_utils", "modulename": "muutils.tensor_utils", "kind": "module", "doc": "<p>utilities for working with tensors and arrays.</p>\n\n<p>notably:</p>\n\n<ul>\n<li><code>TYPE_TO_JAX_DTYPE</code> : a mapping from python, numpy, and torch types to <code>jaxtyping</code> types</li>\n<li><code>DTYPE_MAP</code> mapping string representations of types to their type</li>\n<li><code>TORCH_DTYPE_MAP</code> mapping string representations of types to torch types</li>\n<li><code>compare_state_dicts</code> for comparing two state dicts and giving a detailed error message on whether if was keys, shapes, or values that didn't match</li>\n</ul>\n"}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"fullname": "muutils.tensor_utils.TYPE_TO_JAX_DTYPE", "modulename": "muutils.tensor_utils", "qualname": "TYPE_TO_JAX_DTYPE", "kind": "variable", "doc": "<p>dict mapping python, numpy, and torch types to <code>jaxtyping</code> types</p>\n", "annotation": ": dict", "default_value": "{&lt;class &#x27;float&#x27;&gt;: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, &lt;class &#x27;int&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;jaxtyping.Float&#x27;&gt;: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, &lt;class &#x27;jaxtyping.Int&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;bool&#x27;&gt;: &lt;class &#x27;jaxtyping.Bool&#x27;&gt;, &lt;class &#x27;jaxtyping.Bool&#x27;&gt;: &lt;class &#x27;jaxtyping.Bool&#x27;&gt;, &lt;class &#x27;numpy.bool&#x27;&gt;: &lt;class &#x27;jaxtyping.Bool&#x27;&gt;, torch.bool: &lt;class &#x27;jaxtyping.Bool&#x27;&gt;, &lt;class &#x27;numpy.float16&#x27;&gt;: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, &lt;class &#x27;numpy.float32&#x27;&gt;: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, &lt;class &#x27;numpy.float64&#x27;&gt;: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, &lt;class &#x27;numpy.int8&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;numpy.int16&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;numpy.int32&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;numpy.int64&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;numpy.longlong&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, &lt;class &#x27;numpy.uint8&#x27;&gt;: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, torch.float32: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, torch.float16: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, torch.float64: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, torch.bfloat16: &lt;class &#x27;jaxtyping.Float&#x27;&gt;, torch.int32: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, torch.int8: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, torch.int16: &lt;class &#x27;jaxtyping.Int&#x27;&gt;, torch.int64: &lt;class &#x27;jaxtyping.Int&#x27;&gt;}"}, "muutils.tensor_utils.jaxtype_factory": {"fullname": "muutils.tensor_utils.jaxtype_factory", "modulename": "muutils.tensor_utils", "qualname": "jaxtype_factory", "kind": "function", "doc": "<p>usage:</p>\n\n<pre><code>ATensor = jaxtype_factory(\"ATensor\", torch.Tensor, jaxtyping.Float)\nx: ATensor[\"dim1 dim2\", np.float32]\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">array_type</span><span class=\"p\">:</span> <span class=\"nb\">type</span>,</span><span class=\"param\">\tdefault_jax_dtype=&lt;class &#x27;jaxtyping.Float&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">legacy_mode</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Warn</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">type</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.ATensor": {"fullname": "muutils.tensor_utils.ATensor", "modulename": "muutils.tensor_utils", "qualname": "ATensor", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;muutils.tensor_utils.jaxtype_factory.&lt;locals&gt;._BaseArray&#x27;&gt;"}, "muutils.tensor_utils.NDArray": {"fullname": "muutils.tensor_utils.NDArray", "modulename": "muutils.tensor_utils", "qualname": "NDArray", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;muutils.tensor_utils.jaxtype_factory.&lt;locals&gt;._BaseArray&#x27;&gt;"}, "muutils.tensor_utils.numpy_to_torch_dtype": {"fullname": "muutils.tensor_utils.numpy_to_torch_dtype", "modulename": "muutils.tensor_utils", "qualname": "numpy_to_torch_dtype", "kind": "function", "doc": "<p>convert numpy dtype to torch dtype</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dtype</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">dtype</span><span class=\"p\">,</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">dtype</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">dtype</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.DTYPE_LIST": {"fullname": "muutils.tensor_utils.DTYPE_LIST", "modulename": "muutils.tensor_utils", "qualname": "DTYPE_LIST", "kind": "variable", "doc": "<p>list of all the python, numpy, and torch numerical types I could think of</p>\n", "annotation": ": list", "default_value": "[&lt;class &#x27;bool&#x27;&gt;, &lt;class &#x27;int&#x27;&gt;, &lt;class &#x27;float&#x27;&gt;, torch.float32, torch.float32, torch.float64, torch.float16, torch.float64, torch.bfloat16, torch.complex64, torch.complex128, torch.int32, torch.int8, torch.int16, torch.int32, torch.int64, torch.int64, torch.int16, torch.uint8, torch.bool, &lt;class &#x27;numpy.float16&#x27;&gt;, &lt;class &#x27;numpy.float32&#x27;&gt;, &lt;class &#x27;numpy.float64&#x27;&gt;, &lt;class &#x27;numpy.float16&#x27;&gt;, &lt;class &#x27;numpy.float32&#x27;&gt;, &lt;class &#x27;numpy.float64&#x27;&gt;, &lt;class &#x27;numpy.complex64&#x27;&gt;, &lt;class &#x27;numpy.complex128&#x27;&gt;, &lt;class &#x27;numpy.int8&#x27;&gt;, &lt;class &#x27;numpy.int16&#x27;&gt;, &lt;class &#x27;numpy.int32&#x27;&gt;, &lt;class &#x27;numpy.int64&#x27;&gt;, &lt;class &#x27;numpy.longlong&#x27;&gt;, &lt;class &#x27;numpy.int16&#x27;&gt;, &lt;class &#x27;numpy.uint8&#x27;&gt;, &lt;class &#x27;numpy.bool&#x27;&gt;]"}, "muutils.tensor_utils.DTYPE_MAP": {"fullname": "muutils.tensor_utils.DTYPE_MAP", "modulename": "muutils.tensor_utils", "qualname": "DTYPE_MAP", "kind": "variable", "doc": "<p>mapping from string representations of types to their type</p>\n", "annotation": ": dict", "default_value": "{&quot;&lt;class &#x27;bool&#x27;&gt;&quot;: &lt;class &#x27;bool&#x27;&gt;, &quot;&lt;class &#x27;int&#x27;&gt;&quot;: &lt;class &#x27;int&#x27;&gt;, &quot;&lt;class &#x27;float&#x27;&gt;&quot;: &lt;class &#x27;float&#x27;&gt;, &#x27;torch.float32&#x27;: torch.float32, &#x27;torch.float64&#x27;: torch.float64, &#x27;torch.float16&#x27;: torch.float16, &#x27;torch.bfloat16&#x27;: torch.bfloat16, &#x27;torch.complex64&#x27;: torch.complex64, &#x27;torch.complex128&#x27;: torch.complex128, &#x27;torch.int32&#x27;: torch.int32, &#x27;torch.int8&#x27;: torch.int8, &#x27;torch.int16&#x27;: torch.int16, &#x27;torch.int64&#x27;: torch.int64, &#x27;torch.uint8&#x27;: torch.uint8, &#x27;torch.bool&#x27;: torch.bool, &quot;&lt;class &#x27;numpy.float16&#x27;&gt;&quot;: &lt;class &#x27;numpy.float16&#x27;&gt;, &quot;&lt;class &#x27;numpy.float32&#x27;&gt;&quot;: &lt;class &#x27;numpy.float32&#x27;&gt;, &quot;&lt;class &#x27;numpy.float64&#x27;&gt;&quot;: &lt;class &#x27;numpy.float64&#x27;&gt;, &quot;&lt;class &#x27;numpy.complex64&#x27;&gt;&quot;: &lt;class &#x27;numpy.complex64&#x27;&gt;, &quot;&lt;class &#x27;numpy.complex128&#x27;&gt;&quot;: &lt;class &#x27;numpy.complex128&#x27;&gt;, &quot;&lt;class &#x27;numpy.int8&#x27;&gt;&quot;: &lt;class &#x27;numpy.int8&#x27;&gt;, &quot;&lt;class &#x27;numpy.int16&#x27;&gt;&quot;: &lt;class &#x27;numpy.int16&#x27;&gt;, &quot;&lt;class &#x27;numpy.int32&#x27;&gt;&quot;: &lt;class &#x27;numpy.int32&#x27;&gt;, &quot;&lt;class &#x27;numpy.int64&#x27;&gt;&quot;: &lt;class &#x27;numpy.int64&#x27;&gt;, &quot;&lt;class &#x27;numpy.longlong&#x27;&gt;&quot;: &lt;class &#x27;numpy.longlong&#x27;&gt;, &quot;&lt;class &#x27;numpy.uint8&#x27;&gt;&quot;: &lt;class &#x27;numpy.uint8&#x27;&gt;, &quot;&lt;class &#x27;numpy.bool&#x27;&gt;&quot;: &lt;class &#x27;numpy.bool&#x27;&gt;, &#x27;float16&#x27;: &lt;class &#x27;numpy.float16&#x27;&gt;, &#x27;float32&#x27;: &lt;class &#x27;numpy.float32&#x27;&gt;, &#x27;float64&#x27;: &lt;class &#x27;numpy.float64&#x27;&gt;, &#x27;complex64&#x27;: &lt;class &#x27;numpy.complex64&#x27;&gt;, &#x27;complex128&#x27;: &lt;class &#x27;numpy.complex128&#x27;&gt;, &#x27;int8&#x27;: &lt;class &#x27;numpy.int8&#x27;&gt;, &#x27;int16&#x27;: &lt;class &#x27;numpy.int16&#x27;&gt;, &#x27;int32&#x27;: &lt;class &#x27;numpy.int32&#x27;&gt;, &#x27;int64&#x27;: &lt;class &#x27;numpy.int64&#x27;&gt;, &#x27;longlong&#x27;: &lt;class &#x27;numpy.longlong&#x27;&gt;, &#x27;uint8&#x27;: &lt;class &#x27;numpy.uint8&#x27;&gt;, &#x27;bool&#x27;: &lt;class &#x27;numpy.bool&#x27;&gt;}"}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"fullname": "muutils.tensor_utils.TORCH_DTYPE_MAP", "modulename": "muutils.tensor_utils", "qualname": "TORCH_DTYPE_MAP", "kind": "variable", "doc": "<p>mapping from string representations of types to specifically torch types</p>\n", "annotation": ": dict", "default_value": "{&quot;&lt;class &#x27;bool&#x27;&gt;&quot;: torch.bool, &quot;&lt;class &#x27;int&#x27;&gt;&quot;: torch.int64, &quot;&lt;class &#x27;float&#x27;&gt;&quot;: torch.float64, &#x27;torch.float32&#x27;: torch.float32, &#x27;torch.float64&#x27;: torch.float64, &#x27;torch.float16&#x27;: torch.float16, &#x27;torch.bfloat16&#x27;: torch.bfloat16, &#x27;torch.complex64&#x27;: torch.complex64, &#x27;torch.complex128&#x27;: torch.complex128, &#x27;torch.int32&#x27;: torch.int32, &#x27;torch.int8&#x27;: torch.int8, &#x27;torch.int16&#x27;: torch.int16, &#x27;torch.int64&#x27;: torch.int64, &#x27;torch.uint8&#x27;: torch.uint8, &#x27;torch.bool&#x27;: torch.bool, &quot;&lt;class &#x27;numpy.float16&#x27;&gt;&quot;: torch.float16, &quot;&lt;class &#x27;numpy.float32&#x27;&gt;&quot;: torch.float32, &quot;&lt;class &#x27;numpy.float64&#x27;&gt;&quot;: torch.float64, &quot;&lt;class &#x27;numpy.complex64&#x27;&gt;&quot;: torch.complex64, &quot;&lt;class &#x27;numpy.complex128&#x27;&gt;&quot;: torch.complex128, &quot;&lt;class &#x27;numpy.int8&#x27;&gt;&quot;: torch.int8, &quot;&lt;class &#x27;numpy.int16&#x27;&gt;&quot;: torch.int16, &quot;&lt;class &#x27;numpy.int32&#x27;&gt;&quot;: torch.int32, &quot;&lt;class &#x27;numpy.int64&#x27;&gt;&quot;: torch.int64, &quot;&lt;class &#x27;numpy.longlong&#x27;&gt;&quot;: torch.int64, &quot;&lt;class &#x27;numpy.uint8&#x27;&gt;&quot;: torch.uint8, &quot;&lt;class &#x27;numpy.bool&#x27;&gt;&quot;: torch.bool, &#x27;float16&#x27;: torch.float16, &#x27;float32&#x27;: torch.float32, &#x27;float64&#x27;: torch.float64, &#x27;complex64&#x27;: torch.complex64, &#x27;complex128&#x27;: torch.complex128, &#x27;int8&#x27;: torch.int8, &#x27;int16&#x27;: torch.int16, &#x27;int32&#x27;: torch.int32, &#x27;int64&#x27;: torch.int64, &#x27;longlong&#x27;: torch.int64, &#x27;uint8&#x27;: torch.uint8, &#x27;bool&#x27;: torch.bool}"}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"fullname": "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP", "modulename": "muutils.tensor_utils", "qualname": "TORCH_OPTIMIZERS_MAP", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, typing.Type[torch.optim.optimizer.Optimizer]]", "default_value": "{&#x27;Adagrad&#x27;: &lt;class &#x27;torch.optim.adagrad.Adagrad&#x27;&gt;, &#x27;Adam&#x27;: &lt;class &#x27;torch.optim.adam.Adam&#x27;&gt;, &#x27;AdamW&#x27;: &lt;class &#x27;torch.optim.adamw.AdamW&#x27;&gt;, &#x27;SparseAdam&#x27;: &lt;class &#x27;torch.optim.sparse_adam.SparseAdam&#x27;&gt;, &#x27;Adamax&#x27;: &lt;class &#x27;torch.optim.adamax.Adamax&#x27;&gt;, &#x27;ASGD&#x27;: &lt;class &#x27;torch.optim.asgd.ASGD&#x27;&gt;, &#x27;LBFGS&#x27;: &lt;class &#x27;torch.optim.lbfgs.LBFGS&#x27;&gt;, &#x27;NAdam&#x27;: &lt;class &#x27;torch.optim.nadam.NAdam&#x27;&gt;, &#x27;RAdam&#x27;: &lt;class &#x27;torch.optim.radam.RAdam&#x27;&gt;, &#x27;RMSprop&#x27;: &lt;class &#x27;torch.optim.rmsprop.RMSprop&#x27;&gt;, &#x27;Rprop&#x27;: &lt;class &#x27;torch.optim.rprop.Rprop&#x27;&gt;, &#x27;SGD&#x27;: &lt;class &#x27;torch.optim.sgd.SGD&#x27;&gt;}"}, "muutils.tensor_utils.pad_tensor": {"fullname": "muutils.tensor_utils.pad_tensor", "modulename": "muutils.tensor_utils", "qualname": "pad_tensor", "kind": "function", "doc": "<p>pad a 1-d tensor on the left with pad_value to length <code>padded_length</code></p>\n\n<p>set <code>rpad = True</code> to pad on the right instead</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tensor</span><span class=\"p\">:</span> <span class=\"n\">jaxtyping</span><span class=\"o\">.</span><span class=\"n\">Shaped</span><span class=\"p\">[</span><span class=\"n\">Tensor</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dim1&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">padded_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pad_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">rpad</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">jaxtyping</span><span class=\"o\">.</span><span class=\"n\">Shaped</span><span class=\"p\">[</span><span class=\"n\">Tensor</span><span class=\"p\">,</span> <span class=\"s1\">&#39;padded_length&#39;</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.lpad_tensor": {"fullname": "muutils.tensor_utils.lpad_tensor", "modulename": "muutils.tensor_utils", "qualname": "lpad_tensor", "kind": "function", "doc": "<p>pad a 1-d tensor on the left with pad_value to length <code>padded_length</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tensor</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">padded_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pad_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.rpad_tensor": {"fullname": "muutils.tensor_utils.rpad_tensor", "modulename": "muutils.tensor_utils", "qualname": "rpad_tensor", "kind": "function", "doc": "<p>pad a 1-d tensor on the right with pad_value to length <code>pad_length</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tensor</span><span class=\"p\">:</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>,</span><span class=\"param\">\t<span class=\"n\">pad_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pad_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.pad_array": {"fullname": "muutils.tensor_utils.pad_array", "modulename": "muutils.tensor_utils", "qualname": "pad_array", "kind": "function", "doc": "<p>pad a 1-d array on the left with pad_value to length <code>padded_length</code></p>\n\n<p>set <code>rpad = True</code> to pad on the right instead</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">array</span><span class=\"p\">:</span> <span class=\"n\">jaxtyping</span><span class=\"o\">.</span><span class=\"n\">Shaped</span><span class=\"p\">[</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dim1&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">padded_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pad_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">rpad</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">jaxtyping</span><span class=\"o\">.</span><span class=\"n\">Shaped</span><span class=\"p\">[</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"s1\">&#39;padded_length&#39;</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.lpad_array": {"fullname": "muutils.tensor_utils.lpad_array", "modulename": "muutils.tensor_utils", "qualname": "lpad_array", "kind": "function", "doc": "<p>pad a 1-d array on the left with pad_value to length <code>padded_length</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">array</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">padded_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pad_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.rpad_array": {"fullname": "muutils.tensor_utils.rpad_array", "modulename": "muutils.tensor_utils", "qualname": "rpad_array", "kind": "function", "doc": "<p>pad a 1-d array on the right with pad_value to length <code>pad_length</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">array</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">pad_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">pad_value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.get_dict_shapes": {"fullname": "muutils.tensor_utils.get_dict_shapes", "modulename": "muutils.tensor_utils", "qualname": "get_dict_shapes", "kind": "function", "doc": "<p>given a state dict or cache dict, compute the shapes and put them in a nested dict</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">d</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.string_dict_shapes": {"fullname": "muutils.tensor_utils.string_dict_shapes", "modulename": "muutils.tensor_utils", "qualname": "string_dict_shapes", "kind": "function", "doc": "<p>printable version of get_dict_shapes</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">d</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">torch</span><span class=\"o\">.</span><span class=\"n\">Tensor</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.tensor_utils.StateDictCompareError": {"fullname": "muutils.tensor_utils.StateDictCompareError", "modulename": "muutils.tensor_utils", "qualname": "StateDictCompareError", "kind": "class", "doc": "<p>raised when state dicts don't match</p>\n", "bases": "builtins.AssertionError"}, "muutils.tensor_utils.StateDictKeysError": {"fullname": "muutils.tensor_utils.StateDictKeysError", "modulename": "muutils.tensor_utils", "qualname": "StateDictKeysError", "kind": "class", "doc": "<p>raised when state dict keys don't match</p>\n", "bases": "StateDictCompareError"}, "muutils.tensor_utils.StateDictShapeError": {"fullname": "muutils.tensor_utils.StateDictShapeError", "modulename": "muutils.tensor_utils", "qualname": "StateDictShapeError", "kind": "class", "doc": "<p>raised when state dict shapes don't match</p>\n", "bases": "StateDictCompareError"}, "muutils.tensor_utils.StateDictValueError": {"fullname": "muutils.tensor_utils.StateDictValueError", "modulename": "muutils.tensor_utils", "qualname": "StateDictValueError", "kind": "class", "doc": "<p>raised when state dict values don't match</p>\n", "bases": "StateDictCompareError"}, "muutils.tensor_utils.compare_state_dicts": {"fullname": "muutils.tensor_utils.compare_state_dicts", "modulename": "muutils.tensor_utils", "qualname": "compare_state_dicts", "kind": "function", "doc": "<p>compare two dicts of tensors</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>d1 : dict</code></li>\n<li><code>d2 : dict</code></li>\n<li><code>rtol : float</code>\n(defaults to <code>1e-5</code>)</li>\n<li><code>atol : float</code>\n(defaults to <code>1e-8</code>)</li>\n<li><code>verbose : bool</code>\n(defaults to <code>True</code>)</li>\n</ul>\n\n<h1 id=\"raises\">Raises:</h1>\n\n<ul>\n<li><code>StateDictKeysError</code> : keys don't match</li>\n<li><code>StateDictShapeError</code> : shapes don't match (but keys do)</li>\n<li><code>StateDictValueError</code> : values don't match (but keys and shapes do)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">d1</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">d2</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">rtol</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1e-05</span>,</span><span class=\"param\">\t<span class=\"n\">atol</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1e-08</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "muutils.timeit_fancy": {"fullname": "muutils.timeit_fancy", "modulename": "muutils.timeit_fancy", "kind": "module", "doc": "<p><code>timeit_fancy</code> is just a fancier version of timeit with more options</p>\n"}, "muutils.timeit_fancy.FancyTimeitResult": {"fullname": "muutils.timeit_fancy.FancyTimeitResult", "modulename": "muutils.timeit_fancy", "qualname": "FancyTimeitResult", "kind": "class", "doc": "<p>return type of <code>timeit_fancy</code></p>\n", "bases": "typing.NamedTuple"}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"fullname": "muutils.timeit_fancy.FancyTimeitResult.__init__", "modulename": "muutils.timeit_fancy", "qualname": "FancyTimeitResult.__init__", "kind": "function", "doc": "<p>Create new instance of FancyTimeitResult(timings, return_value, profile)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">timings</span><span class=\"p\">:</span> <span class=\"n\">ForwardRef</span><span class=\"p\">(</span><span class=\"s1\">&#39;StatCounter&#39;</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">return_value</span><span class=\"p\">:</span> <span class=\"n\">ForwardRef</span><span class=\"p\">(</span><span class=\"s1\">&#39;T_return&#39;</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">profile</span><span class=\"p\">:</span> <span class=\"n\">ForwardRef</span><span class=\"p\">(</span><span class=\"s1\">&#39;Union[pstats.Stats, None]&#39;</span><span class=\"p\">)</span></span>)</span>"}, "muutils.timeit_fancy.FancyTimeitResult.timings": {"fullname": "muutils.timeit_fancy.FancyTimeitResult.timings", "modulename": "muutils.timeit_fancy", "qualname": "FancyTimeitResult.timings", "kind": "variable", "doc": "<p>Alias for field number 0</p>\n", "annotation": ": muutils.statcounter.StatCounter"}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"fullname": "muutils.timeit_fancy.FancyTimeitResult.return_value", "modulename": "muutils.timeit_fancy", "qualname": "FancyTimeitResult.return_value", "kind": "variable", "doc": "<p>Alias for field number 1</p>\n", "annotation": ": ~T_return"}, "muutils.timeit_fancy.FancyTimeitResult.profile": {"fullname": "muutils.timeit_fancy.FancyTimeitResult.profile", "modulename": "muutils.timeit_fancy", "qualname": "FancyTimeitResult.profile", "kind": "variable", "doc": "<p>Alias for field number 2</p>\n", "annotation": ": Optional[pstats.Stats]"}, "muutils.timeit_fancy.timeit_fancy": {"fullname": "muutils.timeit_fancy.timeit_fancy", "modulename": "muutils.timeit_fancy", "qualname": "timeit_fancy", "kind": "function", "doc": "<p>Wrapper for <code>timeit</code> to get the fastest run of a callable with more customization options.</p>\n\n<p>Approximates the functionality of the %timeit magic or command line interface in a Python callable.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>cmd: Callable[[], T_return] | str</code>\nThe callable to time. If a string, it will be passed to <code>timeit.Timer</code> as the <code>stmt</code> argument.</li>\n<li><code>setup: str</code>\nThe setup code to run before <code>cmd</code>. If a string, it will be passed to <code>timeit.Timer</code> as the <code>setup</code> argument.</li>\n<li><code>repeats: int</code>\nThe number of times to run <code>cmd</code> to get a reliable measurement.</li>\n<li><code>namespace: dict[str, Any]</code>\nPassed to <code>timeit.Timer</code> constructor.\nIf <code>cmd</code> or <code>setup</code> use local or global variables, they must be passed here. See <code>timeit</code> documentation for details.</li>\n<li><code>get_return: bool</code>\nWhether to pass the value returned from <code>cmd</code>. If True, the return value will be appended in a tuple with execution time.\nThis is for speed and convenience so that <code>cmd</code> doesn't need to be run again in the calling scope if the return values are needed.\n(default: <code>False</code>)</li>\n<li><code>do_profiling: bool</code>\nWhether to return a <code>pstats.Stats</code> object in addition to the time and return value.\n(default: <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<p><code>FancyTimeitResult</code>, which is a NamedTuple with the following fields:</p>\n\n<ul>\n<li><code>time: float</code>\nThe time in seconds it took to run <code>cmd</code> the minimum number of times to get a reliable measurement.</li>\n<li><code>return_value: T|None</code>\nThe return value of <code>cmd</code> if <code>get_return</code> is <code>True</code>, otherwise <code>None</code>.</li>\n<li><code>profile: pstats.Stats|None</code>\nA <code>pstats.Stats</code> object if <code>do_profiling</code> is <code>True</code>, otherwise <code>None</code>.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">cmd</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">[[],</span> <span class=\"o\">~</span><span class=\"n\">T_return</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">setup</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">[[],</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">function</span> <span class=\"o\">&lt;</span><span class=\"k\">lambda</span><span class=\"o\">&gt;&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">repeats</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span>,</span><span class=\"param\">\t<span class=\"n\">namespace</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">get_return</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">do_profiling</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">timeit_fancy</span><span class=\"o\">.</span><span class=\"n\">FancyTimeitResult</span>:</span></span>", "funcdef": "def"}, "muutils.validate_type": {"fullname": "muutils.validate_type", "modulename": "muutils.validate_type", "kind": "module", "doc": "<p>experimental utility for validating types in python, see <code>validate_type</code></p>\n"}, "muutils.validate_type.GenericAliasTypes": {"fullname": "muutils.validate_type.GenericAliasTypes", "modulename": "muutils.validate_type", "qualname": "GenericAliasTypes", "kind": "variable", "doc": "<p></p>\n", "annotation": ": tuple", "default_value": "(&lt;class &#x27;types.GenericAlias&#x27;&gt;, &lt;class &#x27;typing._GenericAlias&#x27;&gt;, &lt;class &#x27;typing._UnionGenericAlias&#x27;&gt;, &lt;class &#x27;typing._BaseGenericAlias&#x27;&gt;)"}, "muutils.validate_type.IncorrectTypeException": {"fullname": "muutils.validate_type.IncorrectTypeException", "modulename": "muutils.validate_type", "qualname": "IncorrectTypeException", "kind": "class", "doc": "<p>Inappropriate argument type.</p>\n", "bases": "builtins.TypeError"}, "muutils.validate_type.TypeHintNotImplementedError": {"fullname": "muutils.validate_type.TypeHintNotImplementedError", "modulename": "muutils.validate_type", "qualname": "TypeHintNotImplementedError", "kind": "class", "doc": "<p>Method or function hasn't been implemented yet.</p>\n", "bases": "builtins.NotImplementedError"}, "muutils.validate_type.InvalidGenericAliasError": {"fullname": "muutils.validate_type.InvalidGenericAliasError", "modulename": "muutils.validate_type", "qualname": "InvalidGenericAliasError", "kind": "class", "doc": "<p>Inappropriate argument type.</p>\n", "bases": "builtins.TypeError"}, "muutils.validate_type.validate_type": {"fullname": "muutils.validate_type.validate_type", "modulename": "muutils.validate_type", "qualname": "validate_type", "kind": "function", "doc": "<p>Validate that a <code>value</code> is of the <code>expected_type</code></p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>value</code>: the value to check the type of</li>\n<li><code>expected_type</code>: the type to check against. Not all types are supported</li>\n<li><code>do_except</code>: if <code>True</code>, raise an exception if the type is incorrect (instead of returning <code>False</code>)\n(default: <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li><code>bool</code>: <code>True</code> if the value is of the expected type, <code>False</code> otherwise.</li>\n</ul>\n\n<h1 id=\"raises\">Raises</h1>\n\n<ul>\n<li><code>IncorrectTypeException(TypeError)</code>: if the type is incorrect and <code>do_except</code> is <code>True</code></li>\n<li><code>TypeHintNotImplementedError(NotImplementedError)</code>: if the type hint is not implemented</li>\n<li><code>InvalidGenericAliasError(TypeError)</code>: if the generic alias is invalid</li>\n</ul>\n\n<p>use <code>typeguard</code> for a more robust solution: <a href=\"https://github.com/agronholm/typeguard\">https://github.com/agronholm/typeguard</a></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">expected_type</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">do_except</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "muutils.validate_type.get_fn_allowed_kwargs": {"fullname": "muutils.validate_type.get_fn_allowed_kwargs", "modulename": "muutils.validate_type", "qualname": "get_fn_allowed_kwargs", "kind": "function", "doc": "<p>Get the allowed kwargs for a function, raising an exception if the signature cannot be determined.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fn</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Set</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "muutils.web": {"fullname": "muutils.web", "modulename": "muutils.web", "kind": "module", "doc": "<p></p>\n"}, "muutils.web.bundle_html": {"fullname": "muutils.web.bundle_html", "modulename": "muutils.web.bundle_html", "kind": "module", "doc": "<p>Inline / bundle external assets (CSS, JS, SVG, PNG) into an HTML document.</p>\n\n<p>Default mode uses <strong>zero external dependencies</strong> and a few well-targeted\nregular expressions.  If you install <em>beautifulsoup4</em> you can enable the\nfar more robust BS4 mode by passing <code>InlineConfig(use_bs4=True)</code>.</p>\n"}, "muutils.web.bundle_html.AssetExt": {"fullname": "muutils.web.bundle_html.AssetExt", "modulename": "muutils.web.bundle_html", "qualname": "AssetExt", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;.css&#x27;, &#x27;.js&#x27;, &#x27;.svg&#x27;, &#x27;.png&#x27;]"}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"fullname": "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS", "modulename": "muutils.web.bundle_html", "qualname": "DEFAULT_ALLOWED_EXTENSIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[set[Literal[&#x27;.css&#x27;, &#x27;.js&#x27;, &#x27;.svg&#x27;, &#x27;.png&#x27;]]]", "default_value": "{&#x27;.svg&#x27;, &#x27;.css&#x27;, &#x27;.js&#x27;, &#x27;.png&#x27;}"}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"fullname": "muutils.web.bundle_html.DEFAULT_TAG_ATTR", "modulename": "muutils.web.bundle_html", "qualname": "DEFAULT_TAG_ATTR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[dict[str, str]]", "default_value": "{&#x27;link&#x27;: &#x27;href&#x27;, &#x27;script&#x27;: &#x27;src&#x27;, &#x27;img&#x27;: &#x27;src&#x27;, &#x27;use&#x27;: &#x27;xlink:href&#x27;}"}, "muutils.web.bundle_html.MIME_BY_EXT": {"fullname": "muutils.web.bundle_html.MIME_BY_EXT", "modulename": "muutils.web.bundle_html", "qualname": "MIME_BY_EXT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[dict[Literal[&#x27;.css&#x27;, &#x27;.js&#x27;, &#x27;.svg&#x27;, &#x27;.png&#x27;], str]]", "default_value": "{&#x27;.css&#x27;: &#x27;text/css&#x27;, &#x27;.js&#x27;: &#x27;application/javascript&#x27;, &#x27;.svg&#x27;: &#x27;image/svg+xml&#x27;, &#x27;.png&#x27;: &#x27;image/png&#x27;}"}, "muutils.web.bundle_html.InlineConfig": {"fullname": "muutils.web.bundle_html.InlineConfig", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig", "kind": "class", "doc": "<p>High-level configuration for the inliner.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>allowed_extensions : set[AssetExt]</code>\nExtensions that may be inlined.</li>\n<li><code>tag_attr : dict[str, str]</code>\nMapping <em>tag -> attribute</em> that holds the asset reference.</li>\n<li><code>max_bytes : int</code>\nAssets larger than this are ignored.</li>\n<li><code>local : bool</code>\nAllow local filesystem assets.</li>\n<li><code>remote : bool</code>\nAllow remote http/https assets.</li>\n<li><code>include_filename_comments : bool</code>\nSurround every replacement with <code>&lt;!-- begin '...' --&gt;</code>\nand <code>&lt;!-- end '...' --&gt;</code>.</li>\n<li><code>use_bs4 : bool</code>\nParse the document with BeautifulSoup if available.</li>\n</ul>\n"}, "muutils.web.bundle_html.InlineConfig.__init__": {"fullname": "muutils.web.bundle_html.InlineConfig.__init__", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">allowed_extensions</span><span class=\"p\">:</span> <span class=\"nb\">set</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;.css&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;.js&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;.svg&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;.png&#39;</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">tag_attr</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">max_bytes</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">131072</span>,</span><span class=\"param\">\t<span class=\"n\">local</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">remote</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">include_filename_comments</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">use_bs4</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"fullname": "muutils.web.bundle_html.InlineConfig.allowed_extensions", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.allowed_extensions", "kind": "variable", "doc": "<p></p>\n", "annotation": ": set[typing.Literal[&#x27;.css&#x27;, &#x27;.js&#x27;, &#x27;.svg&#x27;, &#x27;.png&#x27;]]"}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"fullname": "muutils.web.bundle_html.InlineConfig.tag_attr", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.tag_attr", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, str]"}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"fullname": "muutils.web.bundle_html.InlineConfig.max_bytes", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.max_bytes", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "131072"}, "muutils.web.bundle_html.InlineConfig.local": {"fullname": "muutils.web.bundle_html.InlineConfig.local", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.local", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "muutils.web.bundle_html.InlineConfig.remote": {"fullname": "muutils.web.bundle_html.InlineConfig.remote", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.remote", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "False"}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"fullname": "muutils.web.bundle_html.InlineConfig.include_filename_comments", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.include_filename_comments", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "muutils.web.bundle_html.InlineConfig.use_bs4": {"fullname": "muutils.web.bundle_html.InlineConfig.use_bs4", "modulename": "muutils.web.bundle_html", "qualname": "InlineConfig.use_bs4", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "False"}, "muutils.web.bundle_html.inline_html_assets": {"fullname": "muutils.web.bundle_html.inline_html_assets", "modulename": "muutils.web.bundle_html", "qualname": "inline_html_assets", "kind": "function", "doc": "<p>Inline permitted external assets inside <em>html</em>.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>html : str</code>\nRaw HTML text.</li>\n<li><code>base_path : Path</code>\nDirectory used to resolve relative asset paths.</li>\n<li><code>config : InlineConfig | None</code>\nInlining options (see <code>InlineConfig</code>).</li>\n<li><code>prettify : bool</code>\nPretty-print output (only effective in BS4 mode).</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li><code>str</code>\nModified HTML.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">html</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">base_path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">web</span><span class=\"o\">.</span><span class=\"n\">bundle_html</span><span class=\"o\">.</span><span class=\"n\">InlineConfig</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">prettify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "muutils.web.bundle_html.inline_html_file": {"fullname": "muutils.web.bundle_html.inline_html_file", "modulename": "muutils.web.bundle_html", "qualname": "inline_html_file", "kind": "function", "doc": "<p>Read <em>html_path</em>, inline its assets, and write the result.</p>\n\n<h1 id=\"parameters\">Parameters</h1>\n\n<ul>\n<li><code>html_path : Path</code>\nSource HTML file.</li>\n<li><code>output_path : Path</code>\nDestination path to write the modified HTML.</li>\n<li><code>base_path : Path | None</code>\nDirectory used to resolve relative asset paths (defaults to the HTML file's directory).\nIf <code>None</code>, uses the directory of <em>html_path</em>.\n(default: <code>None</code> -> use <code>html_path.parent</code>)</li>\n<li><code>config : InlineConfig | None</code>\nInlining options.\nIf <code>None</code>, uses default configuration.\n(default: <code>None</code> -> use <code>InlineConfig()</code>)</li>\n<li><code>prettify : bool</code>\nPretty-print when <code>use_bs4=True</code>.\n(default: <code>False</code>)</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li><code>Path</code>\nPath actually written.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">html_path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">output_path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">base_path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">web</span><span class=\"o\">.</span><span class=\"n\">bundle_html</span><span class=\"o\">.</span><span class=\"n\">InlineConfig</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">prettify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">_local</span><span class=\"o\">.</span><span class=\"n\">Path</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"muutils": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1346}, "muutils.collect_warnings": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.collect_warnings.CollateWarnings": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 573}, "muutils.collect_warnings.CollateWarnings.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 3}, "muutils.collect_warnings.CollateWarnings.counts": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.collect_warnings.CollateWarnings.fmt": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.console_unicode": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.console_unicode.get_console_safe_str": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 212}, "muutils.dbg": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 213}, "muutils.dbg.PATH_MODE": {"qualname": 2, "fullname": 4, "annotation": 9, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.DEFAULT_VAL_JOINER": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 4, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.dbg": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 157, "bases": 0, "doc": 65}, "muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"qualname": 5, "fullname": 7, "annotation": 6, "default_value": 69, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"qualname": 4, "fullname": 6, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.tensor_info": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "muutils.dbg.DBG_DICT_DEFAULTS": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 31, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.DBG_LIST_DEFAULTS": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 14, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.list_info": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 3}, "muutils.dbg.TENSOR_STR_TYPES": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 20, "signature": 0, "bases": 0, "doc": 3}, "muutils.dbg.dict_info": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 3}, "muutils.dbg.info_auto": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 9}, "muutils.dbg.dbg_tensor": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 11}, "muutils.dbg.dbg_dict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 11}, "muutils.dbg.dbg_auto": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 11}, "muutils.dbg.grep_repr": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 335, "bases": 0, "doc": 227}, "muutils.dictmagic": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 101}, "muutils.dictmagic.DefaulterDict": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 10, "doc": 15}, "muutils.dictmagic.DefaulterDict.default_factory": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.dictmagic.defaultdict_to_dict_recursive": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 12}, "muutils.dictmagic.dotlist_to_nested_dict": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 60}, "muutils.dictmagic.nested_dict_to_dotlist": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 3}, "muutils.dictmagic.update_with_nested_dict": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 82, "bases": 0, "doc": 178}, "muutils.dictmagic.kwargs_to_nested_dict": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 183, "bases": 0, "doc": 353}, "muutils.dictmagic.is_numeric_consecutive": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 13}, "muutils.dictmagic.condense_nested_dicts_numeric_keys": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 303}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 91, "bases": 0, "doc": 71}, "muutils.dictmagic.condense_nested_dicts": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 131, "bases": 0, "doc": 183}, "muutils.dictmagic.tuple_dims_replace": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 97, "bases": 0, "doc": 3}, "muutils.dictmagic.TensorDict": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "muutils.dictmagic.TensorIterable": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "muutils.dictmagic.TensorDictFormats": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 15, "signature": 0, "bases": 0, "doc": 3}, "muutils.dictmagic.condense_tensor_dict": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 397, "bases": 0, "doc": 861}, "muutils.errormode": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 82}, "muutils.errormode.WarningFunc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 137}, "muutils.errormode.WarningFunc.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "muutils.errormode.LoggingFunc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 3, "signature": 0, "bases": 0, "doc": 3}, "muutils.errormode.GLOBAL_WARN_FUNC": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 91}, "muutils.errormode.GLOBAL_LOG_FUNC": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 55}, "muutils.errormode.custom_showwarning": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 150, "bases": 0, "doc": 3}, "muutils.errormode.ErrorMode": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 59}, "muutils.errormode.ErrorMode.EXCEPT": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "muutils.errormode.ErrorMode.WARN": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "muutils.errormode.ErrorMode.LOG": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "muutils.errormode.ErrorMode.IGNORE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "muutils.errormode.ErrorMode.process": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 142, "bases": 0, "doc": 229}, "muutils.errormode.ErrorMode.from_any": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 16}, "muutils.errormode.ErrorMode.serialize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "muutils.errormode.ErrorMode.load": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 3}, "muutils.errormode.ERROR_MODE_ALIASES": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 115, "signature": 0, "bases": 0, "doc": 11}, "muutils.group_equiv": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "muutils.group_equiv.group_by_equivalence": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 75, "bases": 0, "doc": 111}, "muutils.interval": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "muutils.interval.Number": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 3, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 140}, "muutils.interval.Interval.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 124, "bases": 0, "doc": 3}, "muutils.interval.Interval.lower": {"qualname": 2, "fullname": 4, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.upper": {"qualname": 2, "fullname": 4, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.closed_L": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.closed_R": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.singleton_set": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.is_closed": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.is_open": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.is_half_open": {"qualname": 4, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.is_singleton": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.is_empty": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.is_finite": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.singleton": {"qualname": 2, "fullname": 4, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.interval.Interval.get_empty": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "muutils.interval.Interval.get_singleton": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 3}, "muutils.interval.Interval.numerical_contained": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 3}, "muutils.interval.Interval.interval_contained": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 3}, "muutils.interval.Interval.from_str": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 3}, "muutils.interval.Interval.copy": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 3}, "muutils.interval.Interval.size": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 26}, "muutils.interval.Interval.clamp": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 101}, "muutils.interval.Interval.intersection": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "muutils.interval.Interval.union": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "muutils.interval.ClosedInterval": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 140}, "muutils.interval.ClosedInterval.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "muutils.interval.OpenInterval": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 140}, "muutils.interval.OpenInterval.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "muutils.json_serialize": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 314}, "muutils.json_serialize.json_serialize": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 64}, "muutils.json_serialize.serializable_dataclass": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 479}, "muutils.json_serialize.serializable_field": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 76}, "muutils.json_serialize.arr_metadata": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 8}, "muutils.json_serialize.load_array": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 274, "bases": 0, "doc": 13}, "muutils.json_serialize.BASE_HANDLERS": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 88, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.JSONitem": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 35, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 212}, "muutils.json_serialize.JsonSerializer.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 1358, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer.array_mode": {"qualname": 3, "fullname": 6, "annotation": 28, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer.error_mode": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer.write_only_format": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer.handlers": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer.json_serialize": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 237, "bases": 0, "doc": 3}, "muutils.json_serialize.JsonSerializer.hashify": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 121, "bases": 0, "doc": 10}, "muutils.json_serialize.try_catch": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 29}, "muutils.json_serialize.dc_eq": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 84, "bases": 0, "doc": 366}, "muutils.json_serialize.SerializableDataclass": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 437}, "muutils.json_serialize.SerializableDataclass.serialize": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 16}, "muutils.json_serialize.SerializableDataclass.load": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 24}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 84, "bases": 0, "doc": 12}, "muutils.json_serialize.SerializableDataclass.diff": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 79, "bases": 0, "doc": 452}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 37}, "muutils.json_serialize.array": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 76}, "muutils.json_serialize.array.ArrayMode": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.array.array_n_elements": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "muutils.json_serialize.array.arr_metadata": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 8}, "muutils.json_serialize.array.serialize_array": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 329, "bases": 0, "doc": 263}, "muutils.json_serialize.array.infer_array_mode": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 251, "bases": 0, "doc": 22}, "muutils.json_serialize.array.load_array": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 274, "bases": 0, "doc": 13}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"qualname": 3, "fullname": 8, "annotation": 2, "default_value": 20, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"qualname": 3, "fullname": 8, "annotation": 4, "default_value": 62, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"qualname": 4, "fullname": 9, "annotation": 2, "default_value": 20, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.ObjectPath": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 4, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SerializerHandler": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 63}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 335, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SerializerHandler.check": {"qualname": 2, "fullname": 7, "annotation": 12, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"qualname": 3, "fullname": 8, "annotation": 33, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SerializerHandler.uid": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SerializerHandler.desc": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 6}, "muutils.json_serialize.json_serialize.BASE_HANDLERS": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 88, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 385, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 212}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 1358, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"qualname": 3, "fullname": 8, "annotation": 28, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"qualname": 3, "fullname": 8, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"qualname": 4, "fullname": 9, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer.handlers": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 237, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.JsonSerializer.hashify": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 121, "bases": 0, "doc": 10}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"qualname": 3, "fullname": 8, "annotation": 7, "default_value": 11, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.json_serialize.json_serialize": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 231, "bases": 0, "doc": 11}, "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 12}, "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 22}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 41}, "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 106, "bases": 0, "doc": 158}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 84, "bases": 0, "doc": 44}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 24}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 437}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 16}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 23}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 24}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 84, "bases": 0, "doc": 12}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 79, "bases": 0, "doc": 452}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 37}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 10}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 11}, "muutils.json_serialize.serializable_dataclass.KWOnlyError": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 13}, "muutils.json_serialize.serializable_dataclass.FieldError": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 7}, "muutils.json_serialize.serializable_dataclass.NotSerializableFieldException": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 9}, "muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 7}, "muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 7}, "muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 3, "doc": 13}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 292, "bases": 0, "doc": 870}, "muutils.json_serialize.serializable_field.SerializableField": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 12}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 509, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"qualname": 3, "fullname": 8, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"qualname": 3, "fullname": 8, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"qualname": 3, "fullname": 8, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"qualname": 3, "fullname": 8, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"qualname": 4, "fullname": 9, "annotation": 15, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 16}, "muutils.json_serialize.serializable_field.SerializableField.name": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.type": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.default": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.init": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.serializable_field.serializable_field": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 467, "bases": 0, "doc": 656}, "muutils.json_serialize.util": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "muutils.json_serialize.util.BaseType": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.util.JSONitem": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 35, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.util.JSONdict": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 37, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.util.Hashableitem": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "muutils.json_serialize.util.UniversalContainer": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 13}, "muutils.json_serialize.util.isinstance_namedtuple": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 31}, "muutils.json_serialize.util.try_catch": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 29}, "muutils.json_serialize.util.SerializationException": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "muutils.json_serialize.util.string_as_lines": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 24}, "muutils.json_serialize.util.safe_getsource": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "muutils.json_serialize.util.array_safe_eq": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 16}, "muutils.json_serialize.util.dc_eq": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 84, "bases": 0, "doc": 366}, "muutils.json_serialize.util.MonoTuple": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "muutils.jsonlines": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "muutils.jsonlines.jsonl_load": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 290, "bases": 0, "doc": 3}, "muutils.jsonlines.jsonl_load_log": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 59, "bases": 0, "doc": 3}, "muutils.jsonlines.jsonl_write": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 243, "bases": 0, "doc": 3}, "muutils.kappa": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 48}, "muutils.kappa.Kappa": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 7, "doc": 31}, "muutils.kappa.Kappa.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 3}, "muutils.kappa.Kappa.func_getitem": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.kappa.Kappa.doc": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "muutils.logger.Logger": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 186}, "muutils.logger.Logger.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 295, "bases": 0, "doc": 3}, "muutils.logger.Logger.log": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 291, "bases": 0, "doc": 105}, "muutils.logger.Logger.log_elapsed_last": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 19}, "muutils.logger.Logger.flush_all": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 5}, "muutils.logger.LoggingStream": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 177}, "muutils.logger.LoggingStream.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 253, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.name": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.aliases": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.file": {"qualname": 2, "fullname": 4, "annotation": 9, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.default_level": {"qualname": 3, "fullname": 5, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.default_contents": {"qualname": 3, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.handler": {"qualname": 2, "fullname": 4, "annotation": 7, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.LoggingStream.make_handler": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "muutils.logger.SimpleLogger": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "muutils.logger.SimpleLogger.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 99, "bases": 0, "doc": 3}, "muutils.logger.SimpleLogger.log": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 214, "bases": 0, "doc": 14}, "muutils.logger.TimerContext": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.logger.TimerContext.start_time": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.TimerContext.end_time": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.TimerContext.elapsed_time": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.exception_context": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.exception_context.ExceptionContext": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 127}, "muutils.logger.exception_context.ExceptionContext.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "muutils.logger.exception_context.ExceptionContext.stream": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.headerfuncs": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.headerfuncs.HeaderFunction": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 137}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "muutils.logger.headerfuncs.md_header_function": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 107, "bases": 0, "doc": 117}, "muutils.logger.headerfuncs.HEADER_FUNCTIONS": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.log_util": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.log_util.get_any_from_stream": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 16}, "muutils.logger.log_util.gather_log": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 10}, "muutils.logger.log_util.gather_stream": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 13}, "muutils.logger.log_util.gather_val": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 73, "bases": 0, "doc": 127}, "muutils.logger.logger": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 106}, "muutils.logger.logger.decode_level": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "muutils.logger.logger.Logger": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 186}, "muutils.logger.logger.Logger.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 295, "bases": 0, "doc": 3}, "muutils.logger.logger.Logger.log": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 291, "bases": 0, "doc": 105}, "muutils.logger.logger.Logger.log_elapsed_last": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 19}, "muutils.logger.logger.Logger.flush_all": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 5}, "muutils.logger.loggingstream": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 177}, "muutils.logger.loggingstream.LoggingStream.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 253, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.name": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.aliases": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.file": {"qualname": 2, "fullname": 5, "annotation": 9, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.default_level": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"qualname": 3, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.handler": {"qualname": 2, "fullname": 5, "annotation": 7, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "muutils.logger.simplelogger": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.simplelogger.NullIO": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 5}, "muutils.logger.simplelogger.NullIO.write": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 10}, "muutils.logger.simplelogger.NullIO.flush": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "muutils.logger.simplelogger.NullIO.close": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "muutils.logger.simplelogger.AnyIO": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 7, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.simplelogger.SimpleLogger": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 99, "bases": 0, "doc": 3}, "muutils.logger.simplelogger.SimpleLogger.log": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 214, "bases": 0, "doc": 14}, "muutils.logger.timing": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.TimerContext": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.logger.timing.TimerContext.start_time": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.TimerContext.end_time": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.TimerContext.elapsed_time": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.filter_time_str": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 14}, "muutils.logger.timing.ProgressEstimator": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "muutils.logger.timing.ProgressEstimator.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 112, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.n_total": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.starttime": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.pbar_fill": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"qualname": 3, "fullname": 6, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 10}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 6}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 6}, "muutils.math": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 146, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.n_bins": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.start": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.stop": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.scale": {"qualname": 2, "fullname": 5, "annotation": 9, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.edges": {"qualname": 2, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.centers": {"qualname": 2, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.bins.Bins.changed_n_bins_copy": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 3}, "muutils.math.matrix_powers": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.math.matrix_powers.matrix_powers": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 83, "bases": 0, "doc": 98}, "muutils.math.matrix_powers.matrix_powers_torch": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 126}, "muutils.misc": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 95}, "muutils.misc.stable_hash": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 17}, "muutils.misc.WhenMissing": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.empty_sequence_if_attr_false": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 164}, "muutils.misc.flatten": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 76}, "muutils.misc.list_split": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 271}, "muutils.misc.list_join": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 201}, "muutils.misc.apply_mapping": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 143, "bases": 0, "doc": 290}, "muutils.misc.apply_mapping_chain": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 147, "bases": 0, "doc": 286}, "muutils.misc.sanitize_name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 123, "bases": 0, "doc": 154}, "muutils.misc.sanitize_fname": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 30}, "muutils.misc.sanitize_identifier": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 40}, "muutils.misc.dict_to_filename": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 89, "bases": 0, "doc": 3}, "muutils.misc.dynamic_docstring": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "muutils.misc.shorten_numerical_to_str": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 32}, "muutils.misc.str_to_numeric": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 99}, "muutils.misc.FrozenDict": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "muutils.misc.FrozenList": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 30}, "muutils.misc.FrozenList.append": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "muutils.misc.FrozenList.extend": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "muutils.misc.FrozenList.insert": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 7}, "muutils.misc.FrozenList.remove": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 19}, "muutils.misc.FrozenList.pop": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 26}, "muutils.misc.FrozenList.clear": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 8}, "muutils.misc.freeze": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 59}, "muutils.misc.is_abstract": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 9}, "muutils.misc.get_all_subclasses": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 102}, "muutils.misc.isinstance_by_type_name": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 94}, "muutils.misc.IsDataclass": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 137}, "muutils.misc.IsDataclass.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "muutils.misc.get_hashable_eq_attrs": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 56}, "muutils.misc.dataclass_set_equals": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 73, "bases": 0, "doc": 46}, "muutils.misc.classes": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.classes.is_abstract": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 9}, "muutils.misc.classes.get_all_subclasses": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 102}, "muutils.misc.classes.isinstance_by_type_name": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 94}, "muutils.misc.classes.IsDataclass": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 137}, "muutils.misc.classes.IsDataclass.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "muutils.misc.classes.get_hashable_eq_attrs": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 56}, "muutils.misc.classes.dataclass_set_equals": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 73, "bases": 0, "doc": 46}, "muutils.misc.freezing": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.freezing.FrozenDict": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "muutils.misc.freezing.FrozenList": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 30}, "muutils.misc.freezing.FrozenList.append": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "muutils.misc.freezing.FrozenList.extend": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 11}, "muutils.misc.freezing.FrozenList.insert": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 7}, "muutils.misc.freezing.FrozenList.remove": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 19}, "muutils.misc.freezing.FrozenList.pop": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 26}, "muutils.misc.freezing.FrozenList.clear": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 8}, "muutils.misc.freezing.freeze": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 59}, "muutils.misc.func": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.func.FuncParams": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.func.FuncParamsPreWrap": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.func.process_kwarg": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 165}, "muutils.misc.func.validate_kwarg": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 144, "bases": 0, "doc": 300}, "muutils.misc.func.replace_kwarg": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 122, "bases": 0, "doc": 279}, "muutils.misc.func.is_none": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "muutils.misc.func.always_true": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "muutils.misc.func.always_false": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "muutils.misc.func.format_docstring": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 15}, "muutils.misc.func.LambdaArgs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.func.typed_lambda": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 207}, "muutils.misc.hashing": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.hashing.stable_hash": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 17}, "muutils.misc.hashing.stable_json_dumps": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "muutils.misc.hashing.base64_hash": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 16}, "muutils.misc.numerical": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.numerical.shorten_numerical_to_str": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 32}, "muutils.misc.numerical.str_to_numeric": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 99}, "muutils.misc.sequence": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.sequence.WhenMissing": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 164}, "muutils.misc.sequence.flatten": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 76}, "muutils.misc.sequence.list_split": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 271}, "muutils.misc.sequence.list_join": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 201}, "muutils.misc.sequence.apply_mapping": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 143, "bases": 0, "doc": 290}, "muutils.misc.sequence.apply_mapping_chain": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 147, "bases": 0, "doc": 286}, "muutils.misc.string": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.misc.string.sanitize_name": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 123, "bases": 0, "doc": 154}, "muutils.misc.string.sanitize_fname": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 30}, "muutils.misc.string.sanitize_identifier": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 40}, "muutils.misc.string.dict_to_filename": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 89, "bases": 0, "doc": 3}, "muutils.misc.string.dynamic_docstring": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "muutils.mlutils": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.mlutils.ARRAY_IMPORTS": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.mlutils.DEFAULT_SEED": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.mlutils.GLOBAL_SEED": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.mlutils.get_device": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 17}, "muutils.mlutils.set_reproducibility": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 45}, "muutils.mlutils.chunks": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 9}, "muutils.mlutils.get_checkpoint_paths_for_run": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 46}, "muutils.mlutils.register_method": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 95, "bases": 0, "doc": 11}, "muutils.mlutils.pprint_summary": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "muutils.nbutils": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 59}, "muutils.nbutils.mm": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 7}, "muutils.nbutils.configure_notebook": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.PlottingMode": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 15, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.PLOT_MODE": {"qualname": 2, "fullname": 6, "annotation": 15, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"qualname": 3, "fullname": 7, "annotation": 15, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.FIG_COUNTER": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"qualname": 3, "fullname": 7, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"qualname": 3, "fullname": 7, "annotation": 2, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.FIG_CONFIG": {"qualname": 2, "fullname": 6, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.FIG_BASEPATH": {"qualname": 2, "fullname": 6, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"qualname": 3, "fullname": 7, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 29, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.UnknownFigureFormatWarning": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "muutils.nbutils.configure_notebook.universal_savefig": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 3}, "muutils.nbutils.configure_notebook.setup_plots": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 201, "bases": 0, "doc": 7}, "muutils.nbutils.configure_notebook.configure_notebook": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 275, "bases": 0, "doc": 285}, "muutils.nbutils.configure_notebook.plotshow": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 117, "bases": 0, "doc": 10}, "muutils.nbutils.convert_ipynb_to_script": {"qualname": 0, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 18}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"qualname": 2, "fullname": 8, "annotation": 3, "default_value": 154, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"qualname": 3, "fullname": 9, "annotation": 2, "default_value": 47, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"qualname": 4, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 15}, "muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 142, "bases": 0, "doc": 119}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 165, "bases": 0, "doc": 3}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 198, "bases": 0, "doc": 107}, "muutils.nbutils.mermaid": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "muutils.nbutils.mermaid.mm": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 7}, "muutils.nbutils.print_tex": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "muutils.nbutils.print_tex.print_tex": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 11}, "muutils.nbutils.run_notebook_tests": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 76}, "muutils.nbutils.run_notebook_tests.NotebookTestError": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.run_notebook_tests.FAILURE_STR": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.nbutils.run_notebook_tests.run_notebook_tests": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 522}, "muutils.parallel": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "muutils.parallel.ProgressBarFunction": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 9}, "muutils.parallel.ProgressBarFunction.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "muutils.parallel.ProgressBarOption": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "muutils.parallel.DEFAULT_PBAR_FN": {"qualname": 3, "fullname": 5, "annotation": 12, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.parallel.spinner_fn_wrap": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 4}, "muutils.parallel.map_kwargs_for_tqdm": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 12}, "muutils.parallel.no_progress_fn_wrap": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 7}, "muutils.parallel.set_up_progress_bar_fn": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 142, "bases": 0, "doc": 123}, "muutils.parallel.run_maybe_parallel": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 261, "bases": 0, "doc": 294}, "muutils.spinner": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 32}, "muutils.spinner.DecoratedFunction": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 10}, "muutils.spinner.SpinnerConfig": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerConfig.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerConfig.working": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerConfig.success": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerConfig.fail": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerConfig.is_ascii": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 7}, "muutils.spinner.SpinnerConfig.eq_lens": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "muutils.spinner.SpinnerConfig.is_valid": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 8}, "muutils.spinner.SpinnerConfig.from_any": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerConfigArg": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.SPINNERS": {"qualname": 1, "fullname": 3, "annotation": 5, "default_value": 1272, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 563}, "muutils.spinner.Spinner.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 308, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.config": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.format_string_when_updated": {"qualname": 5, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "muutils.spinner.Spinner.update_interval": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.message": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.current_value": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.format_string": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.output_stream": {"qualname": 3, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.start_time": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "muutils.spinner.Spinner.stop_spinner": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "muutils.spinner.Spinner.spinner_thread": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.spinner.Spinner.value_changed": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "muutils.spinner.Spinner.term_width": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "muutils.spinner.Spinner.state": {"qualname": 2, "fullname": 4, "annotation": 15, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.spinner.Spinner.spin": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 15}, "muutils.spinner.Spinner.update_value": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 10}, "muutils.spinner.Spinner.start": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 5}, "muutils.spinner.Spinner.stop": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 5}, "muutils.spinner.NoOpContextManager": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 9}, "muutils.spinner.NoOpContextManager.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "muutils.spinner.SpinnerContext": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 3, "doc": 563}, "muutils.spinner.spinner_decorator": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 315, "bases": 0, "doc": 563}, "muutils.statcounter": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 28}, "muutils.statcounter.NumericSequence": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "muutils.statcounter.universal_flatten": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 139, "bases": 0, "doc": 5}, "muutils.statcounter.StatCounter": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 28}, "muutils.statcounter.StatCounter.validate": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 11}, "muutils.statcounter.StatCounter.min": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 4}, "muutils.statcounter.StatCounter.max": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 4}, "muutils.statcounter.StatCounter.total": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 6}, "muutils.statcounter.StatCounter.keys_sorted": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 5}, "muutils.statcounter.StatCounter.percentile": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 30}, "muutils.statcounter.StatCounter.median": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "muutils.statcounter.StatCounter.mean": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 8}, "muutils.statcounter.StatCounter.mode": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "muutils.statcounter.StatCounter.std": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "muutils.statcounter.StatCounter.summary": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 113, "bases": 0, "doc": 16}, "muutils.statcounter.StatCounter.serialize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 86, "bases": 0, "doc": 44}, "muutils.statcounter.StatCounter.load": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 12}, "muutils.statcounter.StatCounter.from_list_arrays": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 17}, "muutils.sysinfo": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "muutils.sysinfo.SysInfo": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "muutils.sysinfo.SysInfo.python": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 6}, "muutils.sysinfo.SysInfo.pip": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 5}, "muutils.sysinfo.SysInfo.pytorch": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 6}, "muutils.sysinfo.SysInfo.platform": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 3}, "muutils.sysinfo.SysInfo.git_info": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 3}, "muutils.sysinfo.SysInfo.get_all": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 82, "bases": 0, "doc": 3}, "muutils.tensor_info": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 13}, "muutils.tensor_info.COLORS": {"qualname": 1, "fullname": 4, "annotation": 4, "default_value": 378, "signature": 0, "bases": 0, "doc": 3}, "muutils.tensor_info.OutputFormat": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "muutils.tensor_info.SYMBOLS": {"qualname": 1, "fullname": 4, "annotation": 14, "default_value": 262, "signature": 0, "bases": 0, "doc": 6}, "muutils.tensor_info.SPARK_CHARS": {"qualname": 2, "fullname": 5, "annotation": 13, "default_value": 87, "signature": 0, "bases": 0, "doc": 8}, "muutils.tensor_info.array_info": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 56}, "muutils.tensor_info.generate_sparkline": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 114, "bases": 0, "doc": 95}, "muutils.tensor_info.DEFAULT_SETTINGS": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 75, "signature": 0, "bases": 0, "doc": 3}, "muutils.tensor_info.apply_color": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 3}, "muutils.tensor_info.colorize_dtype": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 14}, "muutils.tensor_info.format_shape_colored": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 15}, "muutils.tensor_info.format_device_colored": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 9}, "muutils.tensor_info.array_summary": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 605, "bases": 0, "doc": 293}, "muutils.tensor_utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 98}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 320, "signature": 0, "bases": 0, "doc": 14}, "muutils.tensor_utils.jaxtype_factory": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 91, "bases": 0, "doc": 22}, "muutils.tensor_utils.ATensor": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 16, "signature": 0, "bases": 0, "doc": 3}, "muutils.tensor_utils.NDArray": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 16, "signature": 0, "bases": 0, "doc": 3}, "muutils.tensor_utils.numpy_to_torch_dtype": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 8}, "muutils.tensor_utils.DTYPE_LIST": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 166, "signature": 0, "bases": 0, "doc": 16}, "muutils.tensor_utils.DTYPE_MAP": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 467, "signature": 0, "bases": 0, "doc": 11}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 334, "signature": 0, "bases": 0, "doc": 12}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"qualname": 3, "fullname": 6, "annotation": 7, "default_value": 159, "signature": 0, "bases": 0, "doc": 3}, "muutils.tensor_utils.pad_tensor": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 113, "bases": 0, "doc": 32}, "muutils.tensor_utils.lpad_tensor": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 19}, "muutils.tensor_utils.rpad_tensor": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 19}, "muutils.tensor_utils.pad_array": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 113, "bases": 0, "doc": 32}, "muutils.tensor_utils.lpad_array": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 19}, "muutils.tensor_utils.rpad_array": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 19}, "muutils.tensor_utils.get_dict_shapes": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 59, "bases": 0, "doc": 19}, "muutils.tensor_utils.string_dict_shapes": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 8}, "muutils.tensor_utils.StateDictCompareError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 9}, "muutils.tensor_utils.StateDictKeysError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 10}, "muutils.tensor_utils.StateDictShapeError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 10}, "muutils.tensor_utils.StateDictValueError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 10}, "muutils.tensor_utils.compare_state_dicts": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 87, "bases": 0, "doc": 116}, "muutils.timeit_fancy": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "muutils.timeit_fancy.FancyTimeitResult": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 9}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 12}, "muutils.timeit_fancy.FancyTimeitResult.timings": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"qualname": 3, "fullname": 6, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.timeit_fancy.FancyTimeitResult.profile": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "muutils.timeit_fancy.timeit_fancy": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 194, "bases": 0, "doc": 369}, "muutils.validate_type": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "muutils.validate_type.GenericAliasTypes": {"qualname": 1, "fullname": 4, "annotation": 2, "default_value": 30, "signature": 0, "bases": 0, "doc": 3}, "muutils.validate_type.IncorrectTypeException": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 6}, "muutils.validate_type.TypeHintNotImplementedError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "muutils.validate_type.InvalidGenericAliasError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 6}, "muutils.validate_type.validate_type": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 177}, "muutils.validate_type.get_fn_allowed_kwargs": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 19}, "muutils.web": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 58}, "muutils.web.bundle_html.AssetExt": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 15, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"qualname": 3, "fullname": 7, "annotation": 15, "default_value": 14, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"qualname": 3, "fullname": 7, "annotation": 3, "default_value": 30, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.MIME_BY_EXT": {"qualname": 3, "fullname": 7, "annotation": 16, "default_value": 30, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 137}, "muutils.web.bundle_html.InlineConfig.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 213, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"qualname": 3, "fullname": 7, "annotation": 16, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"qualname": 3, "fullname": 7, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"qualname": 3, "fullname": 7, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.local": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.remote": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"qualname": 4, "fullname": 8, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.InlineConfig.use_bs4": {"qualname": 3, "fullname": 7, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "muutils.web.bundle_html.inline_html_assets": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 107, "bases": 0, "doc": 92}, "muutils.web.bundle_html.inline_html_file": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 160, "bases": 0, "doc": 163}}, "length": 576, "save": true}, "index": {"qualname": {"root": {"docs": {"muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}, "muutils.interval.Interval.__init__": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.kappa.Kappa.__init__": {"tf": 1}, "muutils.logger.Logger.__init__": {"tf": 1}, "muutils.logger.LoggingStream.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"tf": 1}, "muutils.logger.logger.Logger.__init__": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.__init__": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.Spinner.__init__": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}}, "df": 28, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"muutils.collect_warnings.CollateWarnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_info.apply_color": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.tensor_info.COLORS": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.colorize_dtype": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.tensor_info.format_shape_colored": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.nbutils.configure_notebook.FIG_COUNTER": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.is_numeric_consecutive": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}}, "df": 4}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.interval.Interval.numerical_contained": {"tf": 1}, "muutils.interval.Interval.interval_contained": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.logger.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.FIG_CONFIG": {"tf": 1}, "muutils.spinner.Spinner.config": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.configure_notebook": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"muutils.interval.Interval.copy": {"tf": 1}, "muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"muutils.errormode.custom_showwarning": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.spinner.Spinner.current_value": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.simplelogger.NullIO.close": {"tf": 1}, "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}}, "df": 2, "d": {"docs": {"muutils.interval.Interval.closed_L": {"tf": 1}, "muutils.interval.Interval.closed_R": {"tf": 1}, "muutils.interval.Interval.is_closed": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval.ClosedInterval": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"muutils.interval.Interval.clamp": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"muutils.misc.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"muutils.json_serialize.try_catch": {"tf": 1}, "muutils.json_serialize.util.try_catch": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler.check": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}, "muutils.spinner.Spinner.value_changed": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_info.SPARK_CHARS": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"muutils.mlutils.chunks": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.bins.Bins.centers": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}, "muutils.interval.Interval.__init__": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.kappa.Kappa.__init__": {"tf": 1}, "muutils.logger.Logger.__init__": {"tf": 1}, "muutils.logger.LoggingStream.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"tf": 1}, "muutils.logger.logger.Logger.__init__": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.__init__": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.Spinner.__init__": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}}, "df": 29}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"muutils.dbg.tensor_info": {"tf": 1}, "muutils.dbg.list_info": {"tf": 1}, "muutils.dbg.dict_info": {"tf": 1}, "muutils.dbg.info_auto": {"tf": 1}, "muutils.sysinfo.SysInfo.git_info": {"tf": 1}, "muutils.tensor_info.array_info": {"tf": 1}}, "df": 6}, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.array.infer_array_mode": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval.Interval": {"tf": 1}, "muutils.interval.Interval.__init__": {"tf": 1}, "muutils.interval.Interval.lower": {"tf": 1}, "muutils.interval.Interval.upper": {"tf": 1}, "muutils.interval.Interval.closed_L": {"tf": 1}, "muutils.interval.Interval.closed_R": {"tf": 1}, "muutils.interval.Interval.singleton_set": {"tf": 1}, "muutils.interval.Interval.is_closed": {"tf": 1}, "muutils.interval.Interval.is_open": {"tf": 1}, "muutils.interval.Interval.is_half_open": {"tf": 1}, "muutils.interval.Interval.is_singleton": {"tf": 1}, "muutils.interval.Interval.is_empty": {"tf": 1}, "muutils.interval.Interval.is_finite": {"tf": 1}, "muutils.interval.Interval.singleton": {"tf": 1}, "muutils.interval.Interval.get_empty": {"tf": 1}, "muutils.interval.Interval.get_singleton": {"tf": 1}, "muutils.interval.Interval.numerical_contained": {"tf": 1}, "muutils.interval.Interval.interval_contained": {"tf": 1.4142135623730951}, "muutils.interval.Interval.from_str": {"tf": 1}, "muutils.interval.Interval.copy": {"tf": 1}, "muutils.interval.Interval.size": {"tf": 1}, "muutils.interval.Interval.clamp": {"tf": 1}, "muutils.interval.Interval.intersection": {"tf": 1}, "muutils.interval.Interval.union": {"tf": 1}, "muutils.spinner.Spinner.update_interval": {"tf": 1}}, "df": 25}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.intersection": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.validate_type.IncorrectTypeException": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.validate_type.InvalidGenericAliasError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.inline_html_assets": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.web.bundle_html.InlineConfig": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.local": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.remote": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}}, "df": 9}}}}}}}}}}}, "s": {"docs": {"muutils.dictmagic.is_numeric_consecutive": {"tf": 1}, "muutils.interval.Interval.is_closed": {"tf": 1}, "muutils.interval.Interval.is_open": {"tf": 1}, "muutils.interval.Interval.is_half_open": {"tf": 1}, "muutils.interval.Interval.is_singleton": {"tf": 1}, "muutils.interval.Interval.is_empty": {"tf": 1}, "muutils.interval.Interval.is_finite": {"tf": 1}, "muutils.misc.is_abstract": {"tf": 1}, "muutils.misc.classes.is_abstract": {"tf": 1}, "muutils.misc.func.is_none": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.isinstance_namedtuple": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}}, "df": 3}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.IsDataclass": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.IsDataclass": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.errormode.ErrorMode.IGNORE": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 2}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.misc.sanitize_identifier": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}}, "df": 2}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.mlutils.ARRAY_IMPORTS": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {"muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.nbutils.print_tex.print_tex": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.errormode.ErrorMode.process": {"tf": 1}, "muutils.misc.func.process_kwarg": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 4}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.timing.ProgressEstimator": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.n_total": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.starttime": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}}, "df": 11}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.parallel.ProgressBarFunction": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.parallel.ProgressBarOption": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.timeit_fancy.FancyTimeitResult.profile": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.dbg.PATH_MODE": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"muutils.parallel.run_maybe_parallel": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"muutils.tensor_utils.pad_tensor": {"tf": 1}, "muutils.tensor_utils.pad_array": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.matrix_powers.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {"muutils.misc.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}}, "df": 2}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.mlutils.pprint_summary": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"muutils.nbutils.configure_notebook.PLOT_MODE": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.PlottingMode": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"muutils.nbutils.configure_notebook.setup_plots": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 4, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}, "muutils.nbutils.configure_notebook.plotshow": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"muutils.sysinfo.SysInfo.platform": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.statcounter.StatCounter.percentile": {"tf": 1}}, "df": 1}}}}}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.sysinfo.SysInfo.python": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"muutils.sysinfo.SysInfo.pytorch": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"muutils.sysinfo.SysInfo.pip": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.is_open": {"tf": 1}, "muutils.interval.Interval.is_half_open": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval.OpenInterval": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.json_serialize.json_serialize.ObjectPath": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}, "muutils.spinner.Spinner.output_stream": {"tf": 1}}, "df": 2, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"muutils.tensor_info.OutputFormat": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"muutils.errormode.ErrorMode.EXCEPT": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.exception_context.ExceptionContext": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "t": {"docs": {"muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"muutils.misc.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}}, "df": 2}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}}, "df": 2}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.errormode.ErrorMode": {"tf": 1}, "muutils.errormode.ErrorMode.EXCEPT": {"tf": 1}, "muutils.errormode.ErrorMode.WARN": {"tf": 1}, "muutils.errormode.ErrorMode.LOG": {"tf": 1}, "muutils.errormode.ErrorMode.IGNORE": {"tf": 1}, "muutils.errormode.ErrorMode.process": {"tf": 1}, "muutils.errormode.ErrorMode.from_any": {"tf": 1}, "muutils.errormode.ErrorMode.serialize": {"tf": 1}, "muutils.errormode.ErrorMode.load": {"tf": 1}}, "df": 9}}}}}}}}, "q": {"docs": {"muutils.json_serialize.dc_eq": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}, "muutils.json_serialize.util.dc_eq": {"tf": 1}, "muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}}, "df": 6, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.group_equiv.group_by_equivalence": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"muutils.interval.Interval.is_empty": {"tf": 1}, "muutils.interval.Interval.get_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 5}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.array.array_n_elements": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.timing.TimerContext.elapsed_time": {"tf": 1}}, "df": 4}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"muutils.logger.TimerContext.end_time": {"tf": 1}, "muutils.logger.timing.TimerContext.end_time": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.bins.Bins.edges": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.tensor_utils.jaxtype_factory": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.func.always_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {"muutils.spinner.SpinnerConfig.fail": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.run_notebook_tests.FAILURE_STR": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"muutils.timeit_fancy.timeit_fancy": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"muutils.timeit_fancy.FancyTimeitResult": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.timings": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.profile": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1}, "muutils.kappa.Kappa.func_getitem": {"tf": 1}}, "df": 4, "s": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.logger.headerfuncs.md_header_function": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.logger.headerfuncs.HEADER_FUNCTIONS": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.func.FuncParams": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"muutils.misc.func.FuncParamsPreWrap": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"muutils.errormode.ErrorMode.from_any": {"tf": 1}, "muutils.interval.Interval.from_str": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}, "muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1}}, "df": 8}, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.FrozenDict": {"tf": 1}, "muutils.misc.freezing.FrozenDict": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.FrozenList": {"tf": 1}, "muutils.misc.FrozenList.append": {"tf": 1}, "muutils.misc.FrozenList.extend": {"tf": 1}, "muutils.misc.FrozenList.insert": {"tf": 1}, "muutils.misc.FrozenList.remove": {"tf": 1}, "muutils.misc.FrozenList.pop": {"tf": 1}, "muutils.misc.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.FrozenList": {"tf": 1}, "muutils.misc.freezing.FrozenList.append": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.remove": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}}, "df": 14}}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.freeze": {"tf": 1}, "muutils.misc.freezing.freeze": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.interval.Interval.is_finite": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.serializable_field": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.json_serialize.serializable_field.serializable_field": {"tf": 1}}, "df": 6, "s": {"docs": {"muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldError": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.LoggingStream.file": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 4, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.timing.filter_time_str": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}}, "df": 1}}, "g": {"docs": {"muutils.nbutils.configure_notebook.FIG_COUNTER": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_CONFIG": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_BASEPATH": {"tf": 1}}, "df": 5}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}, "muutils.spinner.Spinner.format_string": {"tf": 1}, "muutils.tensor_info.format_shape_colored": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}}, "df": 7, "s": {"docs": {"muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"tf": 1}, "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}, "muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}, "muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}}, "df": 9, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"muutils.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.simplelogger.NullIO.flush": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.flatten": {"tf": 1}, "muutils.misc.sequence.flatten": {"tf": 1}, "muutils.statcounter.universal_flatten": {"tf": 1}}, "df": 3}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.interval.Interval.get_empty": {"tf": 1}, "muutils.interval.Interval.get_singleton": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.mlutils.get_device": {"tf": 1}, "muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.sysinfo.SysInfo.get_all": {"tf": 1}, "muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}}, "df": 18, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.safe_getsource": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"muutils.kappa.Kappa.func_getitem": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.generate_sparkline": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.validate_type.GenericAliasTypes": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"muutils.dbg.grep_repr": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"muutils.group_equiv.group_by_equivalence": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1}, "muutils.mlutils.GLOBAL_SEED": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.log_util.gather_log": {"tf": 1}, "muutils.logger.log_util.gather_stream": {"tf": 1}, "muutils.logger.log_util.gather_val": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.sysinfo.SysInfo.git_info": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.json_serialize.util.safe_getsource": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.sanitize_name": {"tf": 1}, "muutils.misc.sanitize_fname": {"tf": 1}, "muutils.misc.sanitize_identifier": {"tf": 1}, "muutils.misc.string.sanitize_name": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}}, "df": 6}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.universal_savefig": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.dbg.TENSOR_STR_TYPES": {"tf": 1}, "muutils.interval.Interval.from_str": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}, "muutils.logger.timing.filter_time_str": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}, "muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.str_to_numeric": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.str_to_numeric": {"tf": 1}, "muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"tf": 1}, "muutils.nbutils.run_notebook_tests.FAILURE_STR": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.util.string_as_lines": {"tf": 1}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}, "muutils.spinner.Spinner.format_string": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.logger.log_util.gather_stream": {"tf": 1}, "muutils.spinner.Spinner.output_stream": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.TimerContext.start_time": {"tf": 1}, "muutils.logger.timing.TimerContext.start_time": {"tf": 1}, "muutils.math.bins.Bins.start": {"tf": 1}, "muutils.spinner.Spinner.start_time": {"tf": 1}, "muutils.spinner.Spinner.start": {"tf": 1}}, "df": 5, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.timing.ProgressEstimator.starttime": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_json_dumps": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.spinner.Spinner.state": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 2, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictCompareError": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictKeysError": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictShapeError": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictValueError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.statcounter.StatCounter": {"tf": 1}, "muutils.statcounter.StatCounter.validate": {"tf": 1}, "muutils.statcounter.StatCounter.min": {"tf": 1}, "muutils.statcounter.StatCounter.max": {"tf": 1}, "muutils.statcounter.StatCounter.total": {"tf": 1}, "muutils.statcounter.StatCounter.keys_sorted": {"tf": 1}, "muutils.statcounter.StatCounter.percentile": {"tf": 1}, "muutils.statcounter.StatCounter.median": {"tf": 1}, "muutils.statcounter.StatCounter.mean": {"tf": 1}, "muutils.statcounter.StatCounter.mode": {"tf": 1}, "muutils.statcounter.StatCounter.std": {"tf": 1}, "muutils.statcounter.StatCounter.summary": {"tf": 1}, "muutils.statcounter.StatCounter.serialize": {"tf": 1}, "muutils.statcounter.StatCounter.load": {"tf": 1}, "muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1}}, "df": 15}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {"muutils.math.bins.Bins.stop": {"tf": 1}, "muutils.spinner.Spinner.stop_spinner": {"tf": 1}, "muutils.spinner.Spinner.stop": {"tf": 1}}, "df": 3}}, "d": {"docs": {"muutils.statcounter.StatCounter.std": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.mlutils.pprint_summary": {"tf": 1}, "muutils.statcounter.StatCounter.summary": {"tf": 1}, "muutils.tensor_info.array_summary": {"tf": 1}}, "df": 4}}}}}, "b": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"tf": 1}, "muutils.spinner.SpinnerConfig.success": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.errormode.custom_showwarning": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.format_shape_colored": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.errormode.ErrorMode.serialize": {"tf": 1}, "muutils.json_serialize.json_serialize": {"tf": 1}, "muutils.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.array.serialize_array": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.json_serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1}, "muutils.statcounter.StatCounter.serialize": {"tf": 1}}, "df": 13, "r": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1}}, "df": 3, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.check": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.uid": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.desc": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"tf": 1}}, "df": 7}}}}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field.serializable_field": {"tf": 1}}, "df": 5, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}}, "df": 17}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.serializable_field.SerializableField": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}}, "df": 20}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.json_serialize.util.SerializationException": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {"muutils.interval.Interval.singleton_set": {"tf": 1}, "muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}, "muutils.mlutils.set_reproducibility": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 5, "u": {"docs": {}, "df": 0, "p": {"docs": {"muutils.nbutils.configure_notebook.setup_plots": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_info.DEFAULT_SETTINGS": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.mlutils.DEFAULT_SEED": {"tf": 1}, "muutils.mlutils.GLOBAL_SEED": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.singleton_set": {"tf": 1}, "muutils.interval.Interval.is_singleton": {"tf": 1}, "muutils.interval.Interval.singleton": {"tf": 1}, "muutils.interval.Interval.get_singleton": {"tf": 1}}, "df": 4}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.interval.Interval.size": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.SimpleLogger": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.log": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.log": {"tf": 1}}, "df": 6}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.list_split": {"tf": 1}, "muutils.misc.sequence.list_split": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.spinner.Spinner.spin": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.spinner.Spinner": {"tf": 1}, "muutils.spinner.Spinner.__init__": {"tf": 1}, "muutils.spinner.Spinner.config": {"tf": 1}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}, "muutils.spinner.Spinner.update_interval": {"tf": 1}, "muutils.spinner.Spinner.message": {"tf": 1}, "muutils.spinner.Spinner.current_value": {"tf": 1}, "muutils.spinner.Spinner.format_string": {"tf": 1}, "muutils.spinner.Spinner.output_stream": {"tf": 1}, "muutils.spinner.Spinner.start_time": {"tf": 1}, "muutils.spinner.Spinner.stop_spinner": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.spinner_thread": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.value_changed": {"tf": 1}, "muutils.spinner.Spinner.term_width": {"tf": 1}, "muutils.spinner.Spinner.state": {"tf": 1}, "muutils.spinner.Spinner.spin": {"tf": 1}, "muutils.spinner.Spinner.update_value": {"tf": 1}, "muutils.spinner.Spinner.start": {"tf": 1}, "muutils.spinner.Spinner.stop": {"tf": 1}, "muutils.spinner.spinner_decorator": {"tf": 1}}, "df": 21, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.spinner.SpinnerConfig": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.working": {"tf": 1}, "muutils.spinner.SpinnerConfig.success": {"tf": 1}, "muutils.spinner.SpinnerConfig.fail": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}, "muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}}, "df": 9, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"muutils.spinner.SpinnerConfigArg": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.spinner.SpinnerContext": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"muutils.spinner.SPINNERS": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"muutils.tensor_info.SPARK_CHARS": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.generate_sparkline": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.math.bins.Bins.scale": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.statcounter.StatCounter.keys_sorted": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"muutils.sysinfo.SysInfo": {"tf": 1}, "muutils.sysinfo.SysInfo.python": {"tf": 1}, "muutils.sysinfo.SysInfo.pip": {"tf": 1}, "muutils.sysinfo.SysInfo.pytorch": {"tf": 1}, "muutils.sysinfo.SysInfo.platform": {"tf": 1}, "muutils.sysinfo.SysInfo.git_info": {"tf": 1}, "muutils.sysinfo.SysInfo.get_all": {"tf": 1}}, "df": 7}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_info.SYMBOLS": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dbg.PATH_MODE": {"tf": 1}, "muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}, "muutils.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.array.infer_array_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.nbutils.configure_notebook.PLOT_MODE": {"tf": 1}, "muutils.statcounter.StatCounter.mode": {"tf": 1}}, "df": 9}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.MonoTuple": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"muutils.math.matrix_powers.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"tf": 1}}, "df": 1}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.LoggingStream.make_handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"tf": 1}}, "df": 2}}, "p": {"docs": {"muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}, "muutils.tensor_utils.DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.apply_mapping": {"tf": 1}, "muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sequence.apply_mapping": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}}, "df": 4}}}}}, "y": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {"muutils.parallel.run_maybe_parallel": {"tf": 1}}, "df": 1}}}, "x": {"docs": {"muutils.statcounter.StatCounter.max": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"muutils.json_serialize.arr_metadata": {"tf": 1}, "muutils.json_serialize.array.arr_metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}}, "df": 3}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"muutils.mlutils.register_method": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"muutils.spinner.Spinner.message": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"muutils.statcounter.StatCounter.median": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"muutils.statcounter.StatCounter.mean": {"tf": 1}}, "df": 1}}}, "d": {"docs": {"muutils.logger.headerfuncs.md_header_function": {"tf": 1}}, "df": 1}, "m": {"docs": {"muutils.nbutils.mm": {"tf": 1}, "muutils.nbutils.mermaid.mm": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.statcounter.StatCounter.min": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dbg.DEFAULT_VAL_JOINER": {"tf": 1}, "muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.logger.LoggingStream.default_level": {"tf": 1}, "muutils.logger.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_level": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.mlutils.DEFAULT_SEED": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}, "muutils.tensor_info.DEFAULT_SETTINGS": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"tf": 1}}, "df": 15, "s": {"docs": {"muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_LIST_DEFAULTS": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.DefaulterDict": {"tf": 1}, "muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler.desc": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.logger.decode_level": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.spinner.DecoratedFunction": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.spinner.spinner_decorator": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.mlutils.get_device": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "g": {"docs": {"muutils.dbg.dbg": {"tf": 1}, "muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"tf": 1}, "muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_LIST_DEFAULTS": {"tf": 1}, "muutils.dbg.dbg_tensor": {"tf": 1}, "muutils.dbg.dbg_dict": {"tf": 1}, "muutils.dbg.dbg_auto": {"tf": 1}}, "df": 8}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1}, "muutils.dbg.dict_info": {"tf": 1}, "muutils.dbg.dbg_dict": {"tf": 1}, "muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}, "muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}, "muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}}, "df": 16, "s": {"docs": {"muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 4}}}, "m": {"docs": {}, "df": 0, "s": {"docs": {"muutils.dictmagic.tuple_dims_replace": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "f": {"docs": {"muutils.json_serialize.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}}, "df": 2}}, "r": {"docs": {"muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 3}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}, "muutils.kappa.Kappa.doc": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.dynamic_docstring": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.misc.string.dynamic_docstring": {"tf": 1}}, "df": 3}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"tf": 1}, "muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}}, "df": 5}}}}}}}}, "c": {"docs": {"muutils.json_serialize.dc_eq": {"tf": 1}, "muutils.json_serialize.util.dc_eq": {"tf": 1}}, "df": 2}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"muutils.misc.dynamic_docstring": {"tf": 1}, "muutils.misc.string.dynamic_docstring": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.hashing.stable_json_dumps": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.colorize_dtype": {"tf": 1}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"tf": 1}, "muutils.tensor_utils.numpy_to_torch_dtype": {"tf": 1}, "muutils.tensor_utils.DTYPE_LIST": {"tf": 1}, "muutils.tensor_utils.DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"tf": 1}}, "df": 6}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.dbg.DEFAULT_VAL_JOINER": {"tf": 1}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"tf": 1}, "muutils.logger.log_util.gather_val": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "e": {"docs": {"muutils.spinner.Spinner.current_value": {"tf": 1}, "muutils.spinner.Spinner.value_changed": {"tf": 1}, "muutils.spinner.Spinner.update_value": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"tf": 1}}, "df": 4, "s": {"docs": {"muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.misc.func.validate_kwarg": {"tf": 1}, "muutils.statcounter.StatCounter.validate": {"tf": 1}, "muutils.validate_type.validate_type": {"tf": 1}}, "df": 10}}}}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.list_join": {"tf": 1}, "muutils.misc.sequence.list_join": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.dbg.DEFAULT_VAL_JOINER": {"tf": 1}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.json_serialize.json_serialize": {"tf": 1}, "muutils.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1}, "muutils.json_serialize.json_serialize.json_serialize": {"tf": 1}, "muutils.misc.hashing.stable_json_dumps": {"tf": 1}}, "df": 6, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"muutils.json_serialize.JSONitem": {"tf": 1}, "muutils.json_serialize.util.JSONitem": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.JsonSerializer": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.JsonSerializer.handlers": {"tf": 1}, "muutils.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.JsonSerializer.hashify": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.handlers": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.hashify": {"tf": 1}}, "df": 16}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.json_serialize.util.JSONdict": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {"muutils.jsonlines.jsonl_load": {"tf": 1}, "muutils.jsonlines.jsonl_load_log": {"tf": 1}, "muutils.jsonlines.jsonl_write": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_utils.jaxtype_factory": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"tf": 1}, "muutils.dbg.tensor_info": {"tf": 1}, "muutils.dbg.TENSOR_STR_TYPES": {"tf": 1}, "muutils.dbg.dbg_tensor": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}, "muutils.tensor_utils.pad_tensor": {"tf": 1}, "muutils.tensor_utils.lpad_tensor": {"tf": 1}, "muutils.tensor_utils.rpad_tensor": {"tf": 1}}, "df": 9, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.TensorDict": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.dictmagic.TensorDictFormats": {"tf": 1}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.TensorIterable": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "x": {"docs": {"muutils.nbutils.print_tex.print_tex": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.nbutils.run_notebook_tests.run_notebook_tests": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {"muutils.spinner.Spinner.term_width": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"tf": 1}, "muutils.validate_type.validate_type": {"tf": 1}}, "df": 11, "s": {"docs": {"muutils.dbg.TENSOR_STR_TYPES": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}}, "df": 5}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"muutils.misc.func.typed_lambda": {"tf": 1}}, "df": 1}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.validate_type.TypeHintNotImplementedError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}, "o": {"docs": {"muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}, "muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}, "muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.str_to_numeric": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.str_to_numeric": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"tf": 1}, "muutils.tensor_utils.numpy_to_torch_dtype": {"tf": 1}}, "df": 12, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.logger.timing.ProgressEstimator.n_total": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}, "muutils.statcounter.StatCounter.total": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1}, "muutils.tensor_utils.numpy_to_torch_dtype": {"tf": 1}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}}, "df": 4}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.tuple_dims_replace": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"muutils.json_serialize.try_catch": {"tf": 1}, "muutils.json_serialize.util.try_catch": {"tf": 1}}, "df": 2}, "u": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.func.always_true": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.TimerContext.start_time": {"tf": 1}, "muutils.logger.TimerContext.end_time": {"tf": 1}, "muutils.logger.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.timing.TimerContext.start_time": {"tf": 1}, "muutils.logger.timing.TimerContext.end_time": {"tf": 1}, "muutils.logger.timing.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.timing.filter_time_str": {"tf": 1}, "muutils.spinner.Spinner.start_time": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.TimerContext": {"tf": 1}, "muutils.logger.TimerContext.start_time": {"tf": 1}, "muutils.logger.TimerContext.end_time": {"tf": 1}, "muutils.logger.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.timing.TimerContext": {"tf": 1}, "muutils.logger.timing.TimerContext.start_time": {"tf": 1}, "muutils.logger.timing.TimerContext.end_time": {"tf": 1}, "muutils.logger.timing.TimerContext.elapsed_time": {"tf": 1}}, "df": 8}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.timeit_fancy.timeit_fancy": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.timeit_fancy.FancyTimeitResult.timings": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"tf": 1}}, "df": 1}}}}}}}}}}, "q": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "m": {"docs": {"muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"muutils.spinner.Spinner.spinner_thread": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.arr_metadata": {"tf": 1}, "muutils.json_serialize.array.arr_metadata": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "y": {"docs": {"muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.json_serialize.load_array": {"tf": 1}, "muutils.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.array.array_n_elements": {"tf": 1}, "muutils.json_serialize.array.serialize_array": {"tf": 1}, "muutils.json_serialize.array.infer_array_mode": {"tf": 1}, "muutils.json_serialize.array.load_array": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}, "muutils.mlutils.ARRAY_IMPORTS": {"tf": 1}, "muutils.tensor_info.array_info": {"tf": 1}, "muutils.tensor_info.array_summary": {"tf": 1}, "muutils.tensor_utils.pad_array": {"tf": 1}, "muutils.tensor_utils.lpad_array": {"tf": 1}, "muutils.tensor_utils.rpad_array": {"tf": 1}}, "df": 15, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.array.ArrayMode": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"muutils.dbg.info_auto": {"tf": 1}, "muutils.dbg.dbg_auto": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"muutils.errormode.ErrorMode.from_any": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "o": {"docs": {"muutils.logger.simplelogger.AnyIO": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}, "muutils.logger.LoggingStream.aliases": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.aliases": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {"muutils.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.logger.Logger.flush_all": {"tf": 1}, "muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}, "muutils.sysinfo.SysInfo.get_all": {"tf": 1}}, "df": 5, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}}, "df": 3}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.func.always_true": {"tf": 1}, "muutils.misc.func.always_false": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}, "muutils.json_serialize.util.string_as_lines": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.web.bundle_html.AssetExt": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"muutils.web.bundle_html.inline_html_assets": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"tf": 1}}, "df": 4, "s": {"docs": {"muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.ATensor": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"muutils.misc.apply_mapping": {"tf": 1}, "muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sequence.apply_mapping": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}, "muutils.tensor_info.apply_color": {"tf": 1}}, "df": 5}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"muutils.misc.FrozenList.append": {"tf": 1}, "muutils.misc.freezing.FrozenList.append": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.is_abstract": {"tf": 1}, "muutils.misc.classes.is_abstract": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"muutils.interval.Interval.closed_L": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dbg.DBG_LIST_DEFAULTS": {"tf": 1}, "muutils.dbg.list_info": {"tf": 1}, "muutils.misc.list_split": {"tf": 1}, "muutils.misc.list_join": {"tf": 1}, "muutils.misc.sequence.list_split": {"tf": 1}, "muutils.misc.sequence.list_join": {"tf": 1}, "muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1}, "muutils.tensor_utils.DTYPE_LIST": {"tf": 1}}, "df": 8}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.util.string_as_lines": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.errormode.ErrorMode.LOG": {"tf": 1}, "muutils.jsonlines.jsonl_load_log": {"tf": 1}, "muutils.logger.Logger.log": {"tf": 1}, "muutils.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.SimpleLogger.log": {"tf": 1}, "muutils.logger.log_util.gather_log": {"tf": 1}, "muutils.logger.logger.Logger.log": {"tf": 1}, "muutils.logger.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.log": {"tf": 1}}, "df": 10, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"muutils.errormode.LoggingFunc": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"muutils.logger.LoggingStream": {"tf": 1}, "muutils.logger.LoggingStream.__init__": {"tf": 1}, "muutils.logger.LoggingStream.name": {"tf": 1}, "muutils.logger.LoggingStream.aliases": {"tf": 1}, "muutils.logger.LoggingStream.file": {"tf": 1}, "muutils.logger.LoggingStream.default_level": {"tf": 1}, "muutils.logger.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.LoggingStream.handler": {"tf": 1}, "muutils.logger.LoggingStream.make_handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.__init__": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.name": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.aliases": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.file": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_level": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"tf": 1}}, "df": 18}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.Logger": {"tf": 1}, "muutils.logger.Logger.__init__": {"tf": 1}, "muutils.logger.Logger.log": {"tf": 1}, "muutils.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.logger.Logger": {"tf": 1}, "muutils.logger.logger.Logger.__init__": {"tf": 1}, "muutils.logger.logger.Logger.log": {"tf": 1}, "muutils.logger.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.logger.Logger.flush_all": {"tf": 1}}, "df": 10}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"muutils.errormode.ErrorMode.load": {"tf": 1}, "muutils.json_serialize.load_array": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.array.load_array": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.jsonlines.jsonl_load": {"tf": 1}, "muutils.jsonlines.jsonl_load_log": {"tf": 1}, "muutils.statcounter.StatCounter.load": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.interval.Interval.lower": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.web.bundle_html.InlineConfig.local": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.logger.Logger.log_elapsed_last": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"muutils.misc.func.typed_lambda": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.func.LambdaArgs": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"muutils.logger.LoggingStream.default_level": {"tf": 1}, "muutils.logger.logger.decode_level": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_level": {"tf": 1}}, "df": 3}}}, "n": {"docs": {"muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"muutils.tensor_utils.lpad_tensor": {"tf": 1}, "muutils.tensor_utils.lpad_array": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {"muutils.interval.Interval.closed_R": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {"muutils.dbg.grep_repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"muutils.mlutils.set_reproducibility": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.tuple_dims_replace": {"tf": 1}, "muutils.misc.func.replace_kwarg": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}, "muutils.mlutils.register_method": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.FrozenList.remove": {"tf": 1}, "muutils.misc.freezing.FrozenList.remove": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.InlineConfig.remote": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"muutils.timeit_fancy.FancyTimeitResult.return_value": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "w": {"docs": {"muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.nbutils.run_notebook_tests.run_notebook_tests": {"tf": 1}, "muutils.parallel.run_maybe_parallel": {"tf": 1}}, "df": 3}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"muutils.tensor_utils.rpad_tensor": {"tf": 1}, "muutils.tensor_utils.rpad_array": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {"muutils.json_serialize.array.array_n_elements": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.n_total": {"tf": 1}, "muutils.math.bins.Bins.n_bins": {"tf": 1}, "muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}, "muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}}, "df": 9}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"muutils.dictmagic.is_numeric_consecutive": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.misc.str_to_numeric": {"tf": 1}, "muutils.misc.numerical.str_to_numeric": {"tf": 1}}, "df": 4, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval.Interval.numerical_contained": {"tf": 1}, "muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.statcounter.NumericSequence": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.interval.Number": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"muutils.tensor_utils.numpy_to_torch_dtype": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"muutils.logger.simplelogger.NullIO": {"tf": 1}, "muutils.logger.simplelogger.NullIO.write": {"tf": 1}, "muutils.logger.simplelogger.NullIO.flush": {"tf": 1}, "muutils.logger.simplelogger.NullIO.close": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {"muutils.parallel.no_progress_fn_wrap": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.json_serialize.serializable_dataclass.NotSerializableFieldException": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {"muutils.nbutils.configure_notebook.configure_notebook": {"tf": 1}, "muutils.nbutils.run_notebook_tests.run_notebook_tests": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.nbutils.run_notebook_tests.NotebookTestError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.func.is_none": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.spinner.NoOpContextManager": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.logger.LoggingStream.name": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.name": {"tf": 1}, "muutils.misc.sanitize_name": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}, "muutils.misc.string.sanitize_name": {"tf": 1}}, "df": 7, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.isinstance_namedtuple": {"tf": 1}}, "df": 1}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"muutils.tensor_utils.NDArray": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.spinner.Spinner.update_interval": {"tf": 1}, "muutils.spinner.Spinner.update_value": {"tf": 1}}, "df": 5, "d": {"docs": {"muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.interval.Interval.upper": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.union": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.nbutils.configure_notebook.universal_savefig": {"tf": 1}, "muutils.statcounter.universal_flatten": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.util.UniversalContainer": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.UnknownFigureFormatWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler.uid": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.dictmagic.update_with_nested_dict": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.spinner.Spinner.term_width": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.ErrorMode.WARN": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"muutils.errormode.WarningFunc": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.jsonlines.jsonl_write": {"tf": 1}, "muutils.logger.simplelogger.NullIO.write": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {"muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.WhenMissing": {"tf": 1}, "muutils.misc.sequence.WhenMissing": {"tf": 1}}, "df": 2}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.spinner.SpinnerConfig.working": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.func.process_kwarg": {"tf": 1}, "muutils.misc.func.validate_kwarg": {"tf": 1}, "muutils.misc.func.replace_kwarg": {"tf": 1}}, "df": 3, "s": {"docs": {"muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}, "muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}}, "df": 3}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.KWOnlyError": {"tf": 1}}, "df": 1}}}}}}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1}, "muutils.statcounter.StatCounter.keys_sorted": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {"muutils.kappa.Kappa": {"tf": 1}, "muutils.kappa.Kappa.__init__": {"tf": 1}, "muutils.kappa.Kappa.func_getitem": {"tf": 1}, "muutils.kappa.Kappa.doc": {"tf": 1}}, "df": 4}}}}}, "b": {"docs": {}, "df": 0, "y": {"docs": {"muutils.group_equiv.group_by_equivalence": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}, "muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"6": {"4": {"docs": {"muutils.misc.hashing.base64_hash": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"muutils.json_serialize.BASE_HANDLERS": {"tf": 1}, "muutils.json_serialize.json_serialize.BASE_HANDLERS": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.BaseType": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.nbutils.configure_notebook.FIG_BASEPATH": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {"muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"muutils.logger.timing.ProgressEstimator.pbar_bounds": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.bins.Bins": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.math.bins.Bins.n_bins": {"tf": 1.4142135623730951}, "muutils.math.bins.Bins.start": {"tf": 1}, "muutils.math.bins.Bins.stop": {"tf": 1}, "muutils.math.bins.Bins.scale": {"tf": 1}, "muutils.math.bins.Bins.edges": {"tf": 1}, "muutils.math.bins.Bins.centers": {"tf": 1}, "muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1.4142135623730951}}, "df": 9}}}, "s": {"4": {"docs": {"muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"muutils.interval.Interval.is_half_open": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.LoggingStream.handler": {"tf": 1}, "muutils.logger.LoggingStream.make_handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"tf": 1}}, "df": 4, "s": {"docs": {"muutils.json_serialize.BASE_HANDLERS": {"tf": 1}, "muutils.json_serialize.JsonSerializer.handlers": {"tf": 1}, "muutils.json_serialize.json_serialize.BASE_HANDLERS": {"tf": 1}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.handlers": {"tf": 1}}, "df": 5}}}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.misc.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_hash": {"tf": 1}, "muutils.misc.hashing.base64_hash": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"muutils.json_serialize.JsonSerializer.hashify": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.hashify": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"muutils.json_serialize.util.Hashableitem": {"tf": 1}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.headerfuncs.md_header_function": {"tf": 1}, "muutils.logger.headerfuncs.HEADER_FUNCTIONS": {"tf": 1}}, "df": 2, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.logger.headerfuncs.HeaderFunction": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"muutils.web.bundle_html.inline_html_assets": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 2}}}}, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "j": {"docs": {"muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "fullname": {"root": {"docs": {"muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}, "muutils.interval.Interval.__init__": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.kappa.Kappa.__init__": {"tf": 1}, "muutils.logger.Logger.__init__": {"tf": 1}, "muutils.logger.LoggingStream.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"tf": 1}, "muutils.logger.logger.Logger.__init__": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.__init__": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.Spinner.__init__": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}}, "df": 28, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"muutils": {"tf": 1}, "muutils.collect_warnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}, "muutils.console_unicode": {"tf": 1}, "muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.dbg": {"tf": 1}, "muutils.dbg.PATH_MODE": {"tf": 1}, "muutils.dbg.DEFAULT_VAL_JOINER": {"tf": 1}, "muutils.dbg.dbg": {"tf": 1}, "muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"tf": 1}, "muutils.dbg.tensor_info": {"tf": 1}, "muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_LIST_DEFAULTS": {"tf": 1}, "muutils.dbg.list_info": {"tf": 1}, "muutils.dbg.TENSOR_STR_TYPES": {"tf": 1}, "muutils.dbg.dict_info": {"tf": 1}, "muutils.dbg.info_auto": {"tf": 1}, "muutils.dbg.dbg_tensor": {"tf": 1}, "muutils.dbg.dbg_dict": {"tf": 1}, "muutils.dbg.dbg_auto": {"tf": 1}, "muutils.dbg.grep_repr": {"tf": 1}, "muutils.dictmagic": {"tf": 1}, "muutils.dictmagic.DefaulterDict": {"tf": 1}, "muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}, "muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}, "muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}, "muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.dictmagic.is_numeric_consecutive": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.dictmagic.tuple_dims_replace": {"tf": 1}, "muutils.dictmagic.TensorDict": {"tf": 1}, "muutils.dictmagic.TensorIterable": {"tf": 1}, "muutils.dictmagic.TensorDictFormats": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}, "muutils.errormode": {"tf": 1}, "muutils.errormode.WarningFunc": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}, "muutils.errormode.LoggingFunc": {"tf": 1}, "muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.errormode.custom_showwarning": {"tf": 1}, "muutils.errormode.ErrorMode": {"tf": 1}, "muutils.errormode.ErrorMode.EXCEPT": {"tf": 1}, "muutils.errormode.ErrorMode.WARN": {"tf": 1}, "muutils.errormode.ErrorMode.LOG": {"tf": 1}, "muutils.errormode.ErrorMode.IGNORE": {"tf": 1}, "muutils.errormode.ErrorMode.process": {"tf": 1}, "muutils.errormode.ErrorMode.from_any": {"tf": 1}, "muutils.errormode.ErrorMode.serialize": {"tf": 1}, "muutils.errormode.ErrorMode.load": {"tf": 1}, "muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}, "muutils.group_equiv": {"tf": 1}, "muutils.group_equiv.group_by_equivalence": {"tf": 1}, "muutils.interval": {"tf": 1}, "muutils.interval.Number": {"tf": 1}, "muutils.interval.Interval": {"tf": 1}, "muutils.interval.Interval.__init__": {"tf": 1}, "muutils.interval.Interval.lower": {"tf": 1}, "muutils.interval.Interval.upper": {"tf": 1}, "muutils.interval.Interval.closed_L": {"tf": 1}, "muutils.interval.Interval.closed_R": {"tf": 1}, "muutils.interval.Interval.singleton_set": {"tf": 1}, "muutils.interval.Interval.is_closed": {"tf": 1}, "muutils.interval.Interval.is_open": {"tf": 1}, "muutils.interval.Interval.is_half_open": {"tf": 1}, "muutils.interval.Interval.is_singleton": {"tf": 1}, "muutils.interval.Interval.is_empty": {"tf": 1}, "muutils.interval.Interval.is_finite": {"tf": 1}, "muutils.interval.Interval.singleton": {"tf": 1}, "muutils.interval.Interval.get_empty": {"tf": 1}, "muutils.interval.Interval.get_singleton": {"tf": 1}, "muutils.interval.Interval.numerical_contained": {"tf": 1}, "muutils.interval.Interval.interval_contained": {"tf": 1}, "muutils.interval.Interval.from_str": {"tf": 1}, "muutils.interval.Interval.copy": {"tf": 1}, "muutils.interval.Interval.size": {"tf": 1}, "muutils.interval.Interval.clamp": {"tf": 1}, "muutils.interval.Interval.intersection": {"tf": 1}, "muutils.interval.Interval.union": {"tf": 1}, "muutils.interval.ClosedInterval": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}, "muutils.interval.OpenInterval": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}, "muutils.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field": {"tf": 1}, "muutils.json_serialize.arr_metadata": {"tf": 1}, "muutils.json_serialize.load_array": {"tf": 1}, "muutils.json_serialize.BASE_HANDLERS": {"tf": 1}, "muutils.json_serialize.JSONitem": {"tf": 1}, "muutils.json_serialize.JsonSerializer": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.JsonSerializer.handlers": {"tf": 1}, "muutils.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.JsonSerializer.hashify": {"tf": 1}, "muutils.json_serialize.try_catch": {"tf": 1}, "muutils.json_serialize.dc_eq": {"tf": 1}, "muutils.json_serialize.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.array": {"tf": 1}, "muutils.json_serialize.array.ArrayMode": {"tf": 1}, "muutils.json_serialize.array.array_n_elements": {"tf": 1}, "muutils.json_serialize.array.arr_metadata": {"tf": 1}, "muutils.json_serialize.array.serialize_array": {"tf": 1}, "muutils.json_serialize.array.infer_array_mode": {"tf": 1}, "muutils.json_serialize.array.load_array": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}, "muutils.json_serialize.json_serialize.ObjectPath": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.check": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.uid": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.desc": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.BASE_HANDLERS": {"tf": 1}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.handlers": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.hashify": {"tf": 1}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1}, "muutils.json_serialize.json_serialize.json_serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.KWOnlyError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.NotSerializableFieldException": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}, "muutils.json_serialize.serializable_field.serializable_field": {"tf": 1}, "muutils.json_serialize.util": {"tf": 1}, "muutils.json_serialize.util.BaseType": {"tf": 1}, "muutils.json_serialize.util.JSONitem": {"tf": 1}, "muutils.json_serialize.util.JSONdict": {"tf": 1}, "muutils.json_serialize.util.Hashableitem": {"tf": 1}, "muutils.json_serialize.util.UniversalContainer": {"tf": 1}, "muutils.json_serialize.util.isinstance_namedtuple": {"tf": 1}, "muutils.json_serialize.util.try_catch": {"tf": 1}, "muutils.json_serialize.util.SerializationException": {"tf": 1}, "muutils.json_serialize.util.string_as_lines": {"tf": 1}, "muutils.json_serialize.util.safe_getsource": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}, "muutils.json_serialize.util.dc_eq": {"tf": 1}, "muutils.json_serialize.util.MonoTuple": {"tf": 1}, "muutils.jsonlines": {"tf": 1}, "muutils.jsonlines.jsonl_load": {"tf": 1}, "muutils.jsonlines.jsonl_load_log": {"tf": 1}, "muutils.jsonlines.jsonl_write": {"tf": 1}, "muutils.kappa": {"tf": 1}, "muutils.kappa.Kappa": {"tf": 1}, "muutils.kappa.Kappa.__init__": {"tf": 1}, "muutils.kappa.Kappa.func_getitem": {"tf": 1}, "muutils.kappa.Kappa.doc": {"tf": 1}, "muutils.logger": {"tf": 1}, "muutils.logger.Logger": {"tf": 1}, "muutils.logger.Logger.__init__": {"tf": 1}, "muutils.logger.Logger.log": {"tf": 1}, "muutils.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.LoggingStream": {"tf": 1}, "muutils.logger.LoggingStream.__init__": {"tf": 1}, "muutils.logger.LoggingStream.name": {"tf": 1}, "muutils.logger.LoggingStream.aliases": {"tf": 1}, "muutils.logger.LoggingStream.file": {"tf": 1}, "muutils.logger.LoggingStream.default_level": {"tf": 1}, "muutils.logger.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.LoggingStream.handler": {"tf": 1}, "muutils.logger.LoggingStream.make_handler": {"tf": 1}, "muutils.logger.SimpleLogger": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.log": {"tf": 1}, "muutils.logger.TimerContext": {"tf": 1}, "muutils.logger.TimerContext.start_time": {"tf": 1}, "muutils.logger.TimerContext.end_time": {"tf": 1}, "muutils.logger.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.exception_context": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}, "muutils.logger.headerfuncs": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"tf": 1}, "muutils.logger.headerfuncs.md_header_function": {"tf": 1}, "muutils.logger.headerfuncs.HEADER_FUNCTIONS": {"tf": 1}, "muutils.logger.log_util": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.logger.log_util.gather_log": {"tf": 1}, "muutils.logger.log_util.gather_stream": {"tf": 1}, "muutils.logger.log_util.gather_val": {"tf": 1}, "muutils.logger.logger": {"tf": 1}, "muutils.logger.logger.decode_level": {"tf": 1}, "muutils.logger.logger.Logger": {"tf": 1}, "muutils.logger.logger.Logger.__init__": {"tf": 1}, "muutils.logger.logger.Logger.log": {"tf": 1}, "muutils.logger.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.loggingstream": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.__init__": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.name": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.aliases": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.file": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_level": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"tf": 1}, "muutils.logger.simplelogger": {"tf": 1}, "muutils.logger.simplelogger.NullIO": {"tf": 1}, "muutils.logger.simplelogger.NullIO.write": {"tf": 1}, "muutils.logger.simplelogger.NullIO.flush": {"tf": 1}, "muutils.logger.simplelogger.NullIO.close": {"tf": 1}, "muutils.logger.simplelogger.AnyIO": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.log": {"tf": 1}, "muutils.logger.timing": {"tf": 1}, "muutils.logger.timing.TimerContext": {"tf": 1}, "muutils.logger.timing.TimerContext.start_time": {"tf": 1}, "muutils.logger.timing.TimerContext.end_time": {"tf": 1}, "muutils.logger.timing.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.timing.filter_time_str": {"tf": 1}, "muutils.logger.timing.ProgressEstimator": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.n_total": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.starttime": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.math": {"tf": 1}, "muutils.math.bins": {"tf": 1}, "muutils.math.bins.Bins": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.math.bins.Bins.n_bins": {"tf": 1}, "muutils.math.bins.Bins.start": {"tf": 1}, "muutils.math.bins.Bins.stop": {"tf": 1}, "muutils.math.bins.Bins.scale": {"tf": 1}, "muutils.math.bins.Bins.edges": {"tf": 1}, "muutils.math.bins.Bins.centers": {"tf": 1}, "muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}, "muutils.math.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1}, "muutils.misc": {"tf": 1}, "muutils.misc.stable_hash": {"tf": 1}, "muutils.misc.WhenMissing": {"tf": 1}, "muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.flatten": {"tf": 1}, "muutils.misc.list_split": {"tf": 1}, "muutils.misc.list_join": {"tf": 1}, "muutils.misc.apply_mapping": {"tf": 1}, "muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sanitize_name": {"tf": 1}, "muutils.misc.sanitize_fname": {"tf": 1}, "muutils.misc.sanitize_identifier": {"tf": 1}, "muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.dynamic_docstring": {"tf": 1}, "muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.str_to_numeric": {"tf": 1}, "muutils.misc.FrozenDict": {"tf": 1}, "muutils.misc.FrozenList": {"tf": 1}, "muutils.misc.FrozenList.append": {"tf": 1}, "muutils.misc.FrozenList.extend": {"tf": 1}, "muutils.misc.FrozenList.insert": {"tf": 1}, "muutils.misc.FrozenList.remove": {"tf": 1}, "muutils.misc.FrozenList.pop": {"tf": 1}, "muutils.misc.FrozenList.clear": {"tf": 1}, "muutils.misc.freeze": {"tf": 1}, "muutils.misc.is_abstract": {"tf": 1}, "muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.IsDataclass": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes": {"tf": 1}, "muutils.misc.classes.is_abstract": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.IsDataclass": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}, "muutils.misc.freezing": {"tf": 1}, "muutils.misc.freezing.FrozenDict": {"tf": 1}, "muutils.misc.freezing.FrozenList": {"tf": 1}, "muutils.misc.freezing.FrozenList.append": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.remove": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.freeze": {"tf": 1}, "muutils.misc.func": {"tf": 1}, "muutils.misc.func.FuncParams": {"tf": 1}, "muutils.misc.func.FuncParamsPreWrap": {"tf": 1}, "muutils.misc.func.process_kwarg": {"tf": 1}, "muutils.misc.func.validate_kwarg": {"tf": 1}, "muutils.misc.func.replace_kwarg": {"tf": 1}, "muutils.misc.func.is_none": {"tf": 1}, "muutils.misc.func.always_true": {"tf": 1}, "muutils.misc.func.always_false": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.misc.func.LambdaArgs": {"tf": 1}, "muutils.misc.func.typed_lambda": {"tf": 1}, "muutils.misc.hashing": {"tf": 1}, "muutils.misc.hashing.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_json_dumps": {"tf": 1}, "muutils.misc.hashing.base64_hash": {"tf": 1}, "muutils.misc.numerical": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.str_to_numeric": {"tf": 1}, "muutils.misc.sequence": {"tf": 1}, "muutils.misc.sequence.WhenMissing": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.flatten": {"tf": 1}, "muutils.misc.sequence.list_split": {"tf": 1}, "muutils.misc.sequence.list_join": {"tf": 1}, "muutils.misc.sequence.apply_mapping": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}, "muutils.misc.string": {"tf": 1}, "muutils.misc.string.sanitize_name": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.misc.string.dynamic_docstring": {"tf": 1}, "muutils.mlutils": {"tf": 1}, "muutils.mlutils.ARRAY_IMPORTS": {"tf": 1}, "muutils.mlutils.DEFAULT_SEED": {"tf": 1}, "muutils.mlutils.GLOBAL_SEED": {"tf": 1}, "muutils.mlutils.get_device": {"tf": 1}, "muutils.mlutils.set_reproducibility": {"tf": 1}, "muutils.mlutils.chunks": {"tf": 1}, "muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.mlutils.register_method": {"tf": 1}, "muutils.mlutils.pprint_summary": {"tf": 1}, "muutils.nbutils": {"tf": 1}, "muutils.nbutils.mm": {"tf": 1}, "muutils.nbutils.configure_notebook": {"tf": 1}, "muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning": {"tf": 1}, "muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"tf": 1}, "muutils.nbutils.configure_notebook.PlottingMode": {"tf": 1}, "muutils.nbutils.configure_notebook.PLOT_MODE": {"tf": 1}, "muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_COUNTER": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_CONFIG": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_BASEPATH": {"tf": 1}, "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}, "muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"tf": 1}, "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"tf": 1}, "muutils.nbutils.configure_notebook.UnknownFigureFormatWarning": {"tf": 1}, "muutils.nbutils.configure_notebook.universal_savefig": {"tf": 1}, "muutils.nbutils.configure_notebook.setup_plots": {"tf": 1}, "muutils.nbutils.configure_notebook.configure_notebook": {"tf": 1}, "muutils.nbutils.configure_notebook.plotshow": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}, "muutils.nbutils.mermaid": {"tf": 1}, "muutils.nbutils.mermaid.mm": {"tf": 1}, "muutils.nbutils.print_tex": {"tf": 1}, "muutils.nbutils.print_tex.print_tex": {"tf": 1}, "muutils.nbutils.run_notebook_tests": {"tf": 1}, "muutils.nbutils.run_notebook_tests.NotebookTestError": {"tf": 1}, "muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"tf": 1}, "muutils.nbutils.run_notebook_tests.FAILURE_STR": {"tf": 1}, "muutils.nbutils.run_notebook_tests.run_notebook_tests": {"tf": 1}, "muutils.parallel": {"tf": 1}, "muutils.parallel.ProgressBarFunction": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}, "muutils.parallel.ProgressBarOption": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}, "muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}, "muutils.parallel.run_maybe_parallel": {"tf": 1}, "muutils.spinner": {"tf": 1}, "muutils.spinner.DecoratedFunction": {"tf": 1}, "muutils.spinner.SpinnerConfig": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.working": {"tf": 1}, "muutils.spinner.SpinnerConfig.success": {"tf": 1}, "muutils.spinner.SpinnerConfig.fail": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}, "muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}, "muutils.spinner.SpinnerConfigArg": {"tf": 1}, "muutils.spinner.SPINNERS": {"tf": 1}, "muutils.spinner.Spinner": {"tf": 1}, "muutils.spinner.Spinner.__init__": {"tf": 1}, "muutils.spinner.Spinner.config": {"tf": 1}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}, "muutils.spinner.Spinner.update_interval": {"tf": 1}, "muutils.spinner.Spinner.message": {"tf": 1}, "muutils.spinner.Spinner.current_value": {"tf": 1}, "muutils.spinner.Spinner.format_string": {"tf": 1}, "muutils.spinner.Spinner.output_stream": {"tf": 1}, "muutils.spinner.Spinner.start_time": {"tf": 1}, "muutils.spinner.Spinner.stop_spinner": {"tf": 1}, "muutils.spinner.Spinner.spinner_thread": {"tf": 1}, "muutils.spinner.Spinner.value_changed": {"tf": 1}, "muutils.spinner.Spinner.term_width": {"tf": 1}, "muutils.spinner.Spinner.state": {"tf": 1}, "muutils.spinner.Spinner.spin": {"tf": 1}, "muutils.spinner.Spinner.update_value": {"tf": 1}, "muutils.spinner.Spinner.start": {"tf": 1}, "muutils.spinner.Spinner.stop": {"tf": 1}, "muutils.spinner.NoOpContextManager": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}, "muutils.spinner.SpinnerContext": {"tf": 1}, "muutils.spinner.spinner_decorator": {"tf": 1}, "muutils.statcounter": {"tf": 1}, "muutils.statcounter.NumericSequence": {"tf": 1}, "muutils.statcounter.universal_flatten": {"tf": 1}, "muutils.statcounter.StatCounter": {"tf": 1}, "muutils.statcounter.StatCounter.validate": {"tf": 1}, "muutils.statcounter.StatCounter.min": {"tf": 1}, "muutils.statcounter.StatCounter.max": {"tf": 1}, "muutils.statcounter.StatCounter.total": {"tf": 1}, "muutils.statcounter.StatCounter.keys_sorted": {"tf": 1}, "muutils.statcounter.StatCounter.percentile": {"tf": 1}, "muutils.statcounter.StatCounter.median": {"tf": 1}, "muutils.statcounter.StatCounter.mean": {"tf": 1}, "muutils.statcounter.StatCounter.mode": {"tf": 1}, "muutils.statcounter.StatCounter.std": {"tf": 1}, "muutils.statcounter.StatCounter.summary": {"tf": 1}, "muutils.statcounter.StatCounter.serialize": {"tf": 1}, "muutils.statcounter.StatCounter.load": {"tf": 1}, "muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1}, "muutils.sysinfo": {"tf": 1}, "muutils.sysinfo.SysInfo": {"tf": 1}, "muutils.sysinfo.SysInfo.python": {"tf": 1}, "muutils.sysinfo.SysInfo.pip": {"tf": 1}, "muutils.sysinfo.SysInfo.pytorch": {"tf": 1}, "muutils.sysinfo.SysInfo.platform": {"tf": 1}, "muutils.sysinfo.SysInfo.git_info": {"tf": 1}, "muutils.sysinfo.SysInfo.get_all": {"tf": 1}, "muutils.tensor_info": {"tf": 1}, "muutils.tensor_info.COLORS": {"tf": 1}, "muutils.tensor_info.OutputFormat": {"tf": 1}, "muutils.tensor_info.SYMBOLS": {"tf": 1}, "muutils.tensor_info.SPARK_CHARS": {"tf": 1}, "muutils.tensor_info.array_info": {"tf": 1}, "muutils.tensor_info.generate_sparkline": {"tf": 1}, "muutils.tensor_info.DEFAULT_SETTINGS": {"tf": 1}, "muutils.tensor_info.apply_color": {"tf": 1}, "muutils.tensor_info.colorize_dtype": {"tf": 1}, "muutils.tensor_info.format_shape_colored": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}, "muutils.tensor_info.array_summary": {"tf": 1}, "muutils.tensor_utils": {"tf": 1}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"tf": 1}, "muutils.tensor_utils.jaxtype_factory": {"tf": 1}, "muutils.tensor_utils.ATensor": {"tf": 1}, "muutils.tensor_utils.NDArray": {"tf": 1}, "muutils.tensor_utils.numpy_to_torch_dtype": {"tf": 1}, "muutils.tensor_utils.DTYPE_LIST": {"tf": 1}, "muutils.tensor_utils.DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}, "muutils.tensor_utils.pad_tensor": {"tf": 1}, "muutils.tensor_utils.lpad_tensor": {"tf": 1}, "muutils.tensor_utils.rpad_tensor": {"tf": 1}, "muutils.tensor_utils.pad_array": {"tf": 1}, "muutils.tensor_utils.lpad_array": {"tf": 1}, "muutils.tensor_utils.rpad_array": {"tf": 1}, "muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}, "muutils.tensor_utils.StateDictCompareError": {"tf": 1}, "muutils.tensor_utils.StateDictKeysError": {"tf": 1}, "muutils.tensor_utils.StateDictShapeError": {"tf": 1}, "muutils.tensor_utils.StateDictValueError": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}, "muutils.timeit_fancy": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.timings": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.profile": {"tf": 1}, "muutils.timeit_fancy.timeit_fancy": {"tf": 1}, "muutils.validate_type": {"tf": 1}, "muutils.validate_type.GenericAliasTypes": {"tf": 1}, "muutils.validate_type.IncorrectTypeException": {"tf": 1}, "muutils.validate_type.TypeHintNotImplementedError": {"tf": 1}, "muutils.validate_type.InvalidGenericAliasError": {"tf": 1}, "muutils.validate_type.validate_type": {"tf": 1}, "muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}, "muutils.web": {"tf": 1}, "muutils.web.bundle_html": {"tf": 1}, "muutils.web.bundle_html.AssetExt": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"tf": 1}, "muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}, "muutils.web.bundle_html.InlineConfig": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.local": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.remote": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}, "muutils.web.bundle_html.inline_html_assets": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 576}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dbg.PATH_MODE": {"tf": 1}, "muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}, "muutils.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.array.infer_array_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.nbutils.configure_notebook.PLOT_MODE": {"tf": 1}, "muutils.statcounter.StatCounter.mode": {"tf": 1}}, "df": 9}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.MonoTuple": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {"muutils.math": {"tf": 1}, "muutils.math.bins": {"tf": 1}, "muutils.math.bins.Bins": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.math.bins.Bins.n_bins": {"tf": 1}, "muutils.math.bins.Bins.start": {"tf": 1}, "muutils.math.bins.Bins.stop": {"tf": 1}, "muutils.math.bins.Bins.scale": {"tf": 1}, "muutils.math.bins.Bins.edges": {"tf": 1}, "muutils.math.bins.Bins.centers": {"tf": 1}, "muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}, "muutils.math.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1}}, "df": 14}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"muutils.math.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers": {"tf": 1.4142135623730951}, "muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1.4142135623730951}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"tf": 1}}, "df": 1}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.LoggingStream.make_handler": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.make_handler": {"tf": 1}}, "df": 2}}, "p": {"docs": {"muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}, "muutils.tensor_utils.DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.apply_mapping": {"tf": 1}, "muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sequence.apply_mapping": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}}, "df": 4}}}}}, "y": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {"muutils.parallel.run_maybe_parallel": {"tf": 1}}, "df": 1}}}, "x": {"docs": {"muutils.statcounter.StatCounter.max": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"muutils.json_serialize.arr_metadata": {"tf": 1}, "muutils.json_serialize.array.arr_metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}}, "df": 3}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"muutils.mlutils.register_method": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"muutils.nbutils.mermaid": {"tf": 1}, "muutils.nbutils.mermaid.mm": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"muutils.spinner.Spinner.message": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"muutils.statcounter.StatCounter.median": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"muutils.statcounter.StatCounter.mean": {"tf": 1}}, "df": 1}}}, "d": {"docs": {"muutils.logger.headerfuncs.md_header_function": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"muutils.misc": {"tf": 1}, "muutils.misc.stable_hash": {"tf": 1}, "muutils.misc.WhenMissing": {"tf": 1}, "muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.flatten": {"tf": 1}, "muutils.misc.list_split": {"tf": 1}, "muutils.misc.list_join": {"tf": 1}, "muutils.misc.apply_mapping": {"tf": 1}, "muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sanitize_name": {"tf": 1}, "muutils.misc.sanitize_fname": {"tf": 1}, "muutils.misc.sanitize_identifier": {"tf": 1}, "muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.dynamic_docstring": {"tf": 1}, "muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.str_to_numeric": {"tf": 1}, "muutils.misc.FrozenDict": {"tf": 1}, "muutils.misc.FrozenList": {"tf": 1}, "muutils.misc.FrozenList.append": {"tf": 1}, "muutils.misc.FrozenList.extend": {"tf": 1}, "muutils.misc.FrozenList.insert": {"tf": 1}, "muutils.misc.FrozenList.remove": {"tf": 1}, "muutils.misc.FrozenList.pop": {"tf": 1}, "muutils.misc.FrozenList.clear": {"tf": 1}, "muutils.misc.freeze": {"tf": 1}, "muutils.misc.is_abstract": {"tf": 1}, "muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.IsDataclass": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes": {"tf": 1}, "muutils.misc.classes.is_abstract": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.IsDataclass": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}, "muutils.misc.freezing": {"tf": 1}, "muutils.misc.freezing.FrozenDict": {"tf": 1}, "muutils.misc.freezing.FrozenList": {"tf": 1}, "muutils.misc.freezing.FrozenList.append": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.remove": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.freeze": {"tf": 1}, "muutils.misc.func": {"tf": 1}, "muutils.misc.func.FuncParams": {"tf": 1}, "muutils.misc.func.FuncParamsPreWrap": {"tf": 1}, "muutils.misc.func.process_kwarg": {"tf": 1}, "muutils.misc.func.validate_kwarg": {"tf": 1}, "muutils.misc.func.replace_kwarg": {"tf": 1}, "muutils.misc.func.is_none": {"tf": 1}, "muutils.misc.func.always_true": {"tf": 1}, "muutils.misc.func.always_false": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.misc.func.LambdaArgs": {"tf": 1}, "muutils.misc.func.typed_lambda": {"tf": 1}, "muutils.misc.hashing": {"tf": 1}, "muutils.misc.hashing.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_json_dumps": {"tf": 1}, "muutils.misc.hashing.base64_hash": {"tf": 1}, "muutils.misc.numerical": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.str_to_numeric": {"tf": 1}, "muutils.misc.sequence": {"tf": 1}, "muutils.misc.sequence.WhenMissing": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.flatten": {"tf": 1}, "muutils.misc.sequence.list_split": {"tf": 1}, "muutils.misc.sequence.list_join": {"tf": 1}, "muutils.misc.sequence.apply_mapping": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}, "muutils.misc.string": {"tf": 1}, "muutils.misc.string.sanitize_name": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.misc.string.dynamic_docstring": {"tf": 1}}, "df": 83}}, "n": {"docs": {"muutils.statcounter.StatCounter.min": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"muutils.mlutils": {"tf": 1}, "muutils.mlutils.ARRAY_IMPORTS": {"tf": 1}, "muutils.mlutils.DEFAULT_SEED": {"tf": 1}, "muutils.mlutils.GLOBAL_SEED": {"tf": 1}, "muutils.mlutils.get_device": {"tf": 1}, "muutils.mlutils.set_reproducibility": {"tf": 1}, "muutils.mlutils.chunks": {"tf": 1}, "muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.mlutils.register_method": {"tf": 1}, "muutils.mlutils.pprint_summary": {"tf": 1}}, "df": 10}}}}}}, "m": {"docs": {"muutils.nbutils.mm": {"tf": 1}, "muutils.nbutils.mermaid.mm": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"muutils.collect_warnings.CollateWarnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_info.apply_color": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.tensor_info.COLORS": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.colorize_dtype": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.tensor_info.format_shape_colored": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.nbutils.configure_notebook.FIG_COUNTER": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.console_unicode": {"tf": 1}, "muutils.console_unicode.get_console_safe_str": {"tf": 1.4142135623730951}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.is_numeric_consecutive": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}}, "df": 4}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.interval.Interval.numerical_contained": {"tf": 1}, "muutils.interval.Interval.interval_contained": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.logger.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"tf": 1}}, "df": 2}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.exception_context": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}}, "df": 4}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.FIG_CONFIG": {"tf": 1}, "muutils.spinner.Spinner.config": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook": {"tf": 1}, "muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning": {"tf": 1}, "muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"tf": 1}, "muutils.nbutils.configure_notebook.PlottingMode": {"tf": 1}, "muutils.nbutils.configure_notebook.PLOT_MODE": {"tf": 1}, "muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_COUNTER": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_CONFIG": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_BASEPATH": {"tf": 1}, "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}, "muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"tf": 1}, "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"tf": 1}, "muutils.nbutils.configure_notebook.UnknownFigureFormatWarning": {"tf": 1}, "muutils.nbutils.configure_notebook.universal_savefig": {"tf": 1}, "muutils.nbutils.configure_notebook.setup_plots": {"tf": 1}, "muutils.nbutils.configure_notebook.configure_notebook": {"tf": 1.4142135623730951}, "muutils.nbutils.configure_notebook.plotshow": {"tf": 1}}, "df": 19}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"muutils.nbutils.convert_ipynb_to_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"tf": 1.4142135623730951}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 7}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"muutils.interval.Interval.copy": {"tf": 1}, "muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"muutils.errormode.custom_showwarning": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.spinner.Spinner.current_value": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.simplelogger.NullIO.close": {"tf": 1}, "muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}}, "df": 2, "d": {"docs": {"muutils.interval.Interval.closed_L": {"tf": 1}, "muutils.interval.Interval.closed_R": {"tf": 1}, "muutils.interval.Interval.is_closed": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval.ClosedInterval": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"muutils.interval.Interval.clamp": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.classes": {"tf": 1}, "muutils.misc.classes.is_abstract": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.IsDataclass": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}}, "df": 8}}}}}, "s": {"docs": {"muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"muutils.misc.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"muutils.json_serialize.try_catch": {"tf": 1}, "muutils.json_serialize.util.try_catch": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler.check": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.math.bins.Bins.changed_n_bins_copy": {"tf": 1}, "muutils.spinner.Spinner.value_changed": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.apply_mapping_chain": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_info.SPARK_CHARS": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"muutils.mlutils.chunks": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.bins.Bins.centers": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.ErrorMode.WARN": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.collect_warnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.counts": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}}, "df": 6}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"muutils.errormode.WarningFunc": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.dictmagic.update_with_nested_dict": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.spinner.Spinner.term_width": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.jsonlines.jsonl_write": {"tf": 1}, "muutils.logger.simplelogger.NullIO.write": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {"muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.WhenMissing": {"tf": 1}, "muutils.misc.sequence.WhenMissing": {"tf": 1}}, "df": 2}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.spinner.SpinnerConfig.working": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {"muutils.web": {"tf": 1}, "muutils.web.bundle_html": {"tf": 1}, "muutils.web.bundle_html.AssetExt": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"tf": 1}, "muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}, "muutils.web.bundle_html.InlineConfig": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.local": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.remote": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}, "muutils.web.bundle_html.inline_html_assets": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 17}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.__init__": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}, "muutils.interval.Interval.__init__": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.kappa.Kappa.__init__": {"tf": 1}, "muutils.logger.Logger.__init__": {"tf": 1}, "muutils.logger.LoggingStream.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.headerfuncs.HeaderFunction.__init__": {"tf": 1}, "muutils.logger.logger.Logger.__init__": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.__init__": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.math.bins.Bins.__init__": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.Spinner.__init__": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}}, "df": 29}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"muutils.dbg.tensor_info": {"tf": 1}, "muutils.dbg.list_info": {"tf": 1}, "muutils.dbg.dict_info": {"tf": 1}, "muutils.dbg.info_auto": {"tf": 1}, "muutils.sysinfo.SysInfo.git_info": {"tf": 1}, "muutils.tensor_info": {"tf": 1}, "muutils.tensor_info.COLORS": {"tf": 1}, "muutils.tensor_info.OutputFormat": {"tf": 1}, "muutils.tensor_info.SYMBOLS": {"tf": 1}, "muutils.tensor_info.SPARK_CHARS": {"tf": 1}, "muutils.tensor_info.array_info": {"tf": 1.4142135623730951}, "muutils.tensor_info.generate_sparkline": {"tf": 1}, "muutils.tensor_info.DEFAULT_SETTINGS": {"tf": 1}, "muutils.tensor_info.apply_color": {"tf": 1}, "muutils.tensor_info.colorize_dtype": {"tf": 1}, "muutils.tensor_info.format_shape_colored": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}, "muutils.tensor_info.array_summary": {"tf": 1}}, "df": 18}, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.array.infer_array_mode": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval": {"tf": 1}, "muutils.interval.Number": {"tf": 1}, "muutils.interval.Interval": {"tf": 1.4142135623730951}, "muutils.interval.Interval.__init__": {"tf": 1.4142135623730951}, "muutils.interval.Interval.lower": {"tf": 1.4142135623730951}, "muutils.interval.Interval.upper": {"tf": 1.4142135623730951}, "muutils.interval.Interval.closed_L": {"tf": 1.4142135623730951}, "muutils.interval.Interval.closed_R": {"tf": 1.4142135623730951}, "muutils.interval.Interval.singleton_set": {"tf": 1.4142135623730951}, "muutils.interval.Interval.is_closed": {"tf": 1.4142135623730951}, "muutils.interval.Interval.is_open": {"tf": 1.4142135623730951}, "muutils.interval.Interval.is_half_open": {"tf": 1.4142135623730951}, "muutils.interval.Interval.is_singleton": {"tf": 1.4142135623730951}, "muutils.interval.Interval.is_empty": {"tf": 1.4142135623730951}, "muutils.interval.Interval.is_finite": {"tf": 1.4142135623730951}, "muutils.interval.Interval.singleton": {"tf": 1.4142135623730951}, "muutils.interval.Interval.get_empty": {"tf": 1.4142135623730951}, "muutils.interval.Interval.get_singleton": {"tf": 1.4142135623730951}, "muutils.interval.Interval.numerical_contained": {"tf": 1.4142135623730951}, "muutils.interval.Interval.interval_contained": {"tf": 1.7320508075688772}, "muutils.interval.Interval.from_str": {"tf": 1.4142135623730951}, "muutils.interval.Interval.copy": {"tf": 1.4142135623730951}, "muutils.interval.Interval.size": {"tf": 1.4142135623730951}, "muutils.interval.Interval.clamp": {"tf": 1.4142135623730951}, "muutils.interval.Interval.intersection": {"tf": 1.4142135623730951}, "muutils.interval.Interval.union": {"tf": 1.4142135623730951}, "muutils.interval.ClosedInterval": {"tf": 1}, "muutils.interval.ClosedInterval.__init__": {"tf": 1}, "muutils.interval.OpenInterval": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}, "muutils.spinner.Spinner.update_interval": {"tf": 1}}, "df": 31}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.intersection": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.validate_type.IncorrectTypeException": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.validate_type.InvalidGenericAliasError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.inline_html_assets": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.web.bundle_html.InlineConfig": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.__init__": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.tag_attr": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.max_bytes": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.local": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.remote": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}}, "df": 9}}}}}}}}}}}, "s": {"docs": {"muutils.dictmagic.is_numeric_consecutive": {"tf": 1}, "muutils.interval.Interval.is_closed": {"tf": 1}, "muutils.interval.Interval.is_open": {"tf": 1}, "muutils.interval.Interval.is_half_open": {"tf": 1}, "muutils.interval.Interval.is_singleton": {"tf": 1}, "muutils.interval.Interval.is_empty": {"tf": 1}, "muutils.interval.Interval.is_finite": {"tf": 1}, "muutils.misc.is_abstract": {"tf": 1}, "muutils.misc.classes.is_abstract": {"tf": 1}, "muutils.misc.func.is_none": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.isinstance_namedtuple": {"tf": 1}, "muutils.misc.isinstance_by_type_name": {"tf": 1}, "muutils.misc.classes.isinstance_by_type_name": {"tf": 1}}, "df": 3}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.IsDataclass": {"tf": 1}, "muutils.misc.IsDataclass.__init__": {"tf": 1}, "muutils.misc.classes.IsDataclass": {"tf": 1}, "muutils.misc.classes.IsDataclass.__init__": {"tf": 1}}, "df": 4}}}}}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.errormode.ErrorMode.IGNORE": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 2}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.misc.sanitize_identifier": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}}, "df": 2}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.mlutils.ARRAY_IMPORTS": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {"muutils.nbutils.convert_ipynb_to_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"tf": 1.4142135623730951}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 7}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}, "muutils.nbutils.print_tex": {"tf": 1}, "muutils.nbutils.print_tex.print_tex": {"tf": 1.4142135623730951}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.errormode.ErrorMode.process": {"tf": 1}, "muutils.misc.func.process_kwarg": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 4}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.timing.ProgressEstimator": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.__init__": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.n_total": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.starttime": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}}, "df": 11}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.parallel.ProgressBarFunction": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.parallel.ProgressBarOption": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.timeit_fancy.FancyTimeitResult.profile": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.dbg.PATH_MODE": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"muutils.parallel": {"tf": 1}, "muutils.parallel.ProgressBarFunction": {"tf": 1}, "muutils.parallel.ProgressBarFunction.__init__": {"tf": 1}, "muutils.parallel.ProgressBarOption": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}, "muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}, "muutils.parallel.run_maybe_parallel": {"tf": 1.4142135623730951}}, "df": 10}}}}}}, "d": {"docs": {"muutils.tensor_utils.pad_tensor": {"tf": 1}, "muutils.tensor_utils.pad_array": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_bounds": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.matrix_powers": {"tf": 1}, "muutils.math.matrix_powers.matrix_powers": {"tf": 1.4142135623730951}, "muutils.math.matrix_powers.matrix_powers_torch": {"tf": 1.4142135623730951}}, "df": 3}}}}, "p": {"docs": {"muutils.misc.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}}, "df": 2}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"muutils.mlutils.pprint_summary": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"muutils.nbutils.configure_notebook.PLOT_MODE": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"muutils.nbutils.configure_notebook.PLOTLY_IMPORTED": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.PlotlyNotInstalledWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.PlottingMode": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"muutils.nbutils.configure_notebook.setup_plots": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 4, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"muutils.nbutils.configure_notebook.CLOSE_AFTER_PLOTSHOW": {"tf": 1}, "muutils.nbutils.configure_notebook.plotshow": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"muutils.sysinfo.SysInfo.platform": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.statcounter.StatCounter.percentile": {"tf": 1}}, "df": 1}}}}}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.sysinfo.SysInfo.python": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"muutils.sysinfo.SysInfo.pytorch": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"muutils.sysinfo.SysInfo.pip": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.is_open": {"tf": 1}, "muutils.interval.Interval.is_half_open": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.interval.OpenInterval": {"tf": 1}, "muutils.interval.OpenInterval.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"muutils.json_serialize.json_serialize.ObjectPath": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.configure_notebook.CONVERSION_PLOTMODE_OVERRIDE": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}, "muutils.spinner.Spinner.output_stream": {"tf": 1}}, "df": 2, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"muutils.tensor_info.OutputFormat": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.print_on_exit": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"muutils.errormode.ErrorMode.EXCEPT": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.logger.exception_context": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.exception_context.ExceptionContext": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.__init__": {"tf": 1}, "muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "t": {"docs": {"muutils.web.bundle_html.MIME_BY_EXT": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"muutils.misc.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}}, "df": 2}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.allowed_extensions": {"tf": 1}}, "df": 2}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.errormode": {"tf": 1}, "muutils.errormode.WarningFunc": {"tf": 1}, "muutils.errormode.WarningFunc.__init__": {"tf": 1}, "muutils.errormode.LoggingFunc": {"tf": 1}, "muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.errormode.custom_showwarning": {"tf": 1}, "muutils.errormode.ErrorMode": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.EXCEPT": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.WARN": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.LOG": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.IGNORE": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.process": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.from_any": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.serialize": {"tf": 1.4142135623730951}, "muutils.errormode.ErrorMode.load": {"tf": 1.4142135623730951}, "muutils.errormode.ERROR_MODE_ALIASES": {"tf": 1}}, "df": 17}}}}}}}}, "q": {"docs": {"muutils.json_serialize.dc_eq": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}, "muutils.json_serialize.util.dc_eq": {"tf": 1}, "muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}}, "df": 6, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {"muutils.group_equiv": {"tf": 1}, "muutils.group_equiv.group_by_equivalence": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.group_equiv.group_by_equivalence": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"muutils.interval.Interval.is_empty": {"tf": 1}, "muutils.interval.Interval.get_empty": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.pbar_empty": {"tf": 1}, "muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 5}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.array.array_n_elements": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.TimerContext.elapsed_time": {"tf": 1}, "muutils.logger.logger.Logger.log_elapsed_last": {"tf": 1}, "muutils.logger.timing.TimerContext.elapsed_time": {"tf": 1}}, "df": 4}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"muutils.logger.TimerContext.end_time": {"tf": 1}, "muutils.logger.timing.TimerContext.end_time": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.math.bins.Bins.edges": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "t": {"docs": {"muutils.collect_warnings.CollateWarnings.fmt": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.tensor_utils.jaxtype_factory": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.func.always_false": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {"muutils.spinner.SpinnerConfig.fail": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.run_notebook_tests.FAILURE_STR": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"muutils.timeit_fancy": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.timings": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.profile": {"tf": 1}, "muutils.timeit_fancy.timeit_fancy": {"tf": 1.4142135623730951}}, "df": 7, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"muutils.timeit_fancy.FancyTimeitResult": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.__init__": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.timings": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.return_value": {"tf": 1}, "muutils.timeit_fancy.FancyTimeitResult.profile": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1}, "muutils.kappa.Kappa.func_getitem": {"tf": 1}, "muutils.misc.func": {"tf": 1}, "muutils.misc.func.FuncParams": {"tf": 1}, "muutils.misc.func.FuncParamsPreWrap": {"tf": 1}, "muutils.misc.func.process_kwarg": {"tf": 1}, "muutils.misc.func.validate_kwarg": {"tf": 1}, "muutils.misc.func.replace_kwarg": {"tf": 1}, "muutils.misc.func.is_none": {"tf": 1}, "muutils.misc.func.always_true": {"tf": 1}, "muutils.misc.func.always_false": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.misc.func.LambdaArgs": {"tf": 1}, "muutils.misc.func.typed_lambda": {"tf": 1}}, "df": 16, "s": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.logger.headerfuncs.md_header_function": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.logger.headerfuncs.HEADER_FUNCTIONS": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.func.FuncParams": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"muutils.misc.func.FuncParamsPreWrap": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"muutils.errormode.ErrorMode.from_any": {"tf": 1}, "muutils.interval.Interval.from_str": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}, "muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1}}, "df": 8}, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.FrozenDict": {"tf": 1}, "muutils.misc.freezing.FrozenDict": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.FrozenList": {"tf": 1}, "muutils.misc.FrozenList.append": {"tf": 1}, "muutils.misc.FrozenList.extend": {"tf": 1}, "muutils.misc.FrozenList.insert": {"tf": 1}, "muutils.misc.FrozenList.remove": {"tf": 1}, "muutils.misc.FrozenList.pop": {"tf": 1}, "muutils.misc.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.FrozenList": {"tf": 1}, "muutils.misc.freezing.FrozenList.append": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.remove": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}}, "df": 14}}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.freeze": {"tf": 1}, "muutils.misc.freezing.freeze": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.freezing": {"tf": 1}, "muutils.misc.freezing.FrozenDict": {"tf": 1}, "muutils.misc.freezing.FrozenList": {"tf": 1}, "muutils.misc.freezing.FrozenList.append": {"tf": 1}, "muutils.misc.freezing.FrozenList.extend": {"tf": 1}, "muutils.misc.freezing.FrozenList.insert": {"tf": 1}, "muutils.misc.freezing.FrozenList.remove": {"tf": 1}, "muutils.misc.freezing.FrozenList.pop": {"tf": 1}, "muutils.misc.freezing.FrozenList.clear": {"tf": 1}, "muutils.misc.freezing.freeze": {"tf": 1}}, "df": 10}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.interval.Interval.is_finite": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.serializable_field": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}, "muutils.json_serialize.serializable_field.serializable_field": {"tf": 1.4142135623730951}}, "df": 25, "s": {"docs": {"muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldError": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.LoggingStream.file": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.web.bundle_html.inline_html_file": {"tf": 1}}, "df": 4, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.web.bundle_html.InlineConfig.include_filename_comments": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.timing.filter_time_str": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"muutils.logger.timing.ProgressEstimator.pbar_fill": {"tf": 1}}, "df": 1}}, "g": {"docs": {"muutils.nbutils.configure_notebook.FIG_COUNTER": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_OUTPUT_FMT": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_CONFIG": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_BASEPATH": {"tf": 1}}, "df": 5}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.parallel.map_kwargs_for_tqdm": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}, "muutils.spinner.Spinner.format_string": {"tf": 1}, "muutils.tensor_info.format_shape_colored": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}}, "df": 7, "s": {"docs": {"muutils.nbutils.configure_notebook.MATPLOTLIB_FORMATS": {"tf": 1}, "muutils.nbutils.configure_notebook.TIKZPLOTLIB_FORMATS": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}, "muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.parallel.no_progress_fn_wrap": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}, "muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}}, "df": 9, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.nbutils.configure_notebook.FIG_NUMBERED_FNAME": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"muutils.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.logger.Logger.flush_all": {"tf": 1}, "muutils.logger.simplelogger.NullIO.flush": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.flatten": {"tf": 1}, "muutils.misc.sequence.flatten": {"tf": 1}, "muutils.statcounter.universal_flatten": {"tf": 1}}, "df": 3}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.console_unicode": {"tf": 1}, "muutils.console_unicode.get_console_safe_str": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.union": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.nbutils.configure_notebook.universal_savefig": {"tf": 1}, "muutils.statcounter.universal_flatten": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.util.UniversalContainer": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.UnknownFigureFormatWarning": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}, "p": {"docs": {"muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.spinner.Spinner.update_interval": {"tf": 1}, "muutils.spinner.Spinner.update_value": {"tf": 1}}, "df": 5, "d": {"docs": {"muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.interval.Interval.upper": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler.uid": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"muutils.json_serialize.util": {"tf": 1}, "muutils.json_serialize.util.BaseType": {"tf": 1}, "muutils.json_serialize.util.JSONitem": {"tf": 1}, "muutils.json_serialize.util.JSONdict": {"tf": 1}, "muutils.json_serialize.util.Hashableitem": {"tf": 1}, "muutils.json_serialize.util.UniversalContainer": {"tf": 1}, "muutils.json_serialize.util.isinstance_namedtuple": {"tf": 1}, "muutils.json_serialize.util.try_catch": {"tf": 1}, "muutils.json_serialize.util.SerializationException": {"tf": 1}, "muutils.json_serialize.util.string_as_lines": {"tf": 1}, "muutils.json_serialize.util.safe_getsource": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}, "muutils.json_serialize.util.dc_eq": {"tf": 1}, "muutils.json_serialize.util.MonoTuple": {"tf": 1}, "muutils.logger.log_util": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.logger.log_util.gather_log": {"tf": 1}, "muutils.logger.log_util.gather_stream": {"tf": 1}, "muutils.logger.log_util.gather_val": {"tf": 1}}, "df": 19, "s": {"docs": {"muutils.tensor_utils": {"tf": 1}, "muutils.tensor_utils.TYPE_TO_JAX_DTYPE": {"tf": 1}, "muutils.tensor_utils.jaxtype_factory": {"tf": 1}, "muutils.tensor_utils.ATensor": {"tf": 1}, "muutils.tensor_utils.NDArray": {"tf": 1}, "muutils.tensor_utils.numpy_to_torch_dtype": {"tf": 1}, "muutils.tensor_utils.DTYPE_LIST": {"tf": 1}, "muutils.tensor_utils.DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_DTYPE_MAP": {"tf": 1}, "muutils.tensor_utils.TORCH_OPTIMIZERS_MAP": {"tf": 1}, "muutils.tensor_utils.pad_tensor": {"tf": 1}, "muutils.tensor_utils.lpad_tensor": {"tf": 1}, "muutils.tensor_utils.rpad_tensor": {"tf": 1}, "muutils.tensor_utils.pad_array": {"tf": 1}, "muutils.tensor_utils.lpad_array": {"tf": 1}, "muutils.tensor_utils.rpad_array": {"tf": 1}, "muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}, "muutils.tensor_utils.StateDictCompareError": {"tf": 1}, "muutils.tensor_utils.StateDictKeysError": {"tf": 1}, "muutils.tensor_utils.StateDictShapeError": {"tf": 1}, "muutils.tensor_utils.StateDictValueError": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 23}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"muutils.web.bundle_html.InlineConfig.use_bs4": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.interval.Interval.get_empty": {"tf": 1}, "muutils.interval.Interval.get_singleton": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_timing_raw": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_pbar": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.get_hashable_eq_attrs": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.get_hashable_eq_attrs": {"tf": 1}, "muutils.mlutils.get_device": {"tf": 1}, "muutils.mlutils.get_checkpoint_paths_for_run": {"tf": 1}, "muutils.sysinfo.SysInfo.get_all": {"tf": 1}, "muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.validate_type.get_fn_allowed_kwargs": {"tf": 1}}, "df": 18, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.util.safe_getsource": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"muutils.kappa.Kappa.func_getitem": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.generate_sparkline": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.validate_type.GenericAliasTypes": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"muutils.dbg.grep_repr": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"muutils.group_equiv": {"tf": 1}, "muutils.group_equiv.group_by_equivalence": {"tf": 1.4142135623730951}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.errormode.GLOBAL_WARN_FUNC": {"tf": 1}, "muutils.errormode.GLOBAL_LOG_FUNC": {"tf": 1}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1}, "muutils.mlutils.GLOBAL_SEED": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.log_util.gather_log": {"tf": 1}, "muutils.logger.log_util.gather_stream": {"tf": 1}, "muutils.logger.log_util.gather_val": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.sysinfo.SysInfo.git_info": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.json_serialize.util.safe_getsource": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.sanitize_name": {"tf": 1}, "muutils.misc.sanitize_fname": {"tf": 1}, "muutils.misc.sanitize_identifier": {"tf": 1}, "muutils.misc.string.sanitize_name": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}}, "df": 6}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.nbutils.configure_notebook.universal_savefig": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"muutils.console_unicode.get_console_safe_str": {"tf": 1}, "muutils.dbg.TENSOR_STR_TYPES": {"tf": 1}, "muutils.interval.Interval.from_str": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}, "muutils.logger.timing.filter_time_str": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.total_str_len": {"tf": 1}, "muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.str_to_numeric": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.str_to_numeric": {"tf": 1}, "muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"tf": 1}, "muutils.nbutils.run_notebook_tests.FAILURE_STR": {"tf": 1}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.json_serialize.util.string_as_lines": {"tf": 1}, "muutils.misc.string": {"tf": 1}, "muutils.misc.string.sanitize_name": {"tf": 1}, "muutils.misc.string.sanitize_fname": {"tf": 1}, "muutils.misc.string.sanitize_identifier": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.misc.string.dynamic_docstring": {"tf": 1}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1}, "muutils.spinner.Spinner.format_string": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}}, "df": 10}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"muutils.logger.exception_context.ExceptionContext.stream": {"tf": 1}, "muutils.logger.log_util.get_any_from_stream": {"tf": 1}, "muutils.logger.log_util.gather_stream": {"tf": 1}, "muutils.spinner.Spinner.output_stream": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"muutils.logger.TimerContext.start_time": {"tf": 1}, "muutils.logger.timing.TimerContext.start_time": {"tf": 1}, "muutils.math.bins.Bins.start": {"tf": 1}, "muutils.spinner.Spinner.start_time": {"tf": 1}, "muutils.spinner.Spinner.start": {"tf": 1}}, "df": 5, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.timing.ProgressEstimator.starttime": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_hash": {"tf": 1}, "muutils.misc.hashing.stable_json_dumps": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"muutils.spinner.Spinner.state": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 2, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictCompareError": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictKeysError": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictShapeError": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.tensor_utils.StateDictValueError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.statcounter": {"tf": 1}, "muutils.statcounter.NumericSequence": {"tf": 1}, "muutils.statcounter.universal_flatten": {"tf": 1}, "muutils.statcounter.StatCounter": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.validate": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.min": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.max": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.total": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.keys_sorted": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.percentile": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.median": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.mean": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.mode": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.std": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.summary": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.serialize": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.load": {"tf": 1.4142135623730951}, "muutils.statcounter.StatCounter.from_list_arrays": {"tf": 1.4142135623730951}}, "df": 18}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {"muutils.math.bins.Bins.stop": {"tf": 1}, "muutils.spinner.Spinner.stop_spinner": {"tf": 1}, "muutils.spinner.Spinner.stop": {"tf": 1}}, "df": 3}}, "d": {"docs": {"muutils.statcounter.StatCounter.std": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.mlutils.pprint_summary": {"tf": 1}, "muutils.statcounter.StatCounter.summary": {"tf": 1}, "muutils.tensor_info.array_summary": {"tf": 1}}, "df": 4}}}}}, "b": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"muutils.misc.get_all_subclasses": {"tf": 1}, "muutils.misc.classes.get_all_subclasses": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.nbutils.run_notebook_tests.SUCCESS_STR": {"tf": 1}, "muutils.spinner.SpinnerConfig.success": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.errormode.custom_showwarning": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"muutils.misc.shorten_numerical_to_str": {"tf": 1}, "muutils.misc.numerical.shorten_numerical_to_str": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.format_shape_colored": {"tf": 1}}, "df": 1, "s": {"docs": {"muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.errormode.ErrorMode.serialize": {"tf": 1}, "muutils.json_serialize": {"tf": 1}, "muutils.json_serialize.json_serialize": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field": {"tf": 1}, "muutils.json_serialize.arr_metadata": {"tf": 1}, "muutils.json_serialize.load_array": {"tf": 1}, "muutils.json_serialize.BASE_HANDLERS": {"tf": 1}, "muutils.json_serialize.JSONitem": {"tf": 1}, "muutils.json_serialize.JsonSerializer": {"tf": 1}, "muutils.json_serialize.JsonSerializer.__init__": {"tf": 1}, "muutils.json_serialize.JsonSerializer.array_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.error_mode": {"tf": 1}, "muutils.json_serialize.JsonSerializer.write_only_format": {"tf": 1}, "muutils.json_serialize.JsonSerializer.handlers": {"tf": 1}, "muutils.json_serialize.JsonSerializer.json_serialize": {"tf": 1.4142135623730951}, "muutils.json_serialize.JsonSerializer.hashify": {"tf": 1}, "muutils.json_serialize.try_catch": {"tf": 1}, "muutils.json_serialize.dc_eq": {"tf": 1}, "muutils.json_serialize.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.serialize": {"tf": 1.4142135623730951}, "muutils.json_serialize.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.array": {"tf": 1}, "muutils.json_serialize.array.ArrayMode": {"tf": 1}, "muutils.json_serialize.array.array_n_elements": {"tf": 1}, "muutils.json_serialize.array.arr_metadata": {"tf": 1}, "muutils.json_serialize.array.serialize_array": {"tf": 1.4142135623730951}, "muutils.json_serialize.array.infer_array_mode": {"tf": 1}, "muutils.json_serialize.array.load_array": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1.7320508075688772}, "muutils.json_serialize.json_serialize.ObjectPath": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SerializerHandler": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SerializerHandler.check": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1.7320508075688772}, "muutils.json_serialize.json_serialize.SerializerHandler.uid": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SerializerHandler.desc": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"tf": 1.7320508075688772}, "muutils.json_serialize.json_serialize.BASE_HANDLERS": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer.__init__": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer.array_mode": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer.error_mode": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer.write_only_format": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer.handlers": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.JsonSerializer.json_serialize": {"tf": 1.7320508075688772}, "muutils.json_serialize.json_serialize.JsonSerializer.hashify": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1.4142135623730951}, "muutils.json_serialize.json_serialize.json_serialize": {"tf": 1.7320508075688772}, "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.KWOnlyError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.NotSerializableFieldException": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}, "muutils.json_serialize.serializable_field.serializable_field": {"tf": 1}, "muutils.json_serialize.util": {"tf": 1}, "muutils.json_serialize.util.BaseType": {"tf": 1}, "muutils.json_serialize.util.JSONitem": {"tf": 1}, "muutils.json_serialize.util.JSONdict": {"tf": 1}, "muutils.json_serialize.util.Hashableitem": {"tf": 1}, "muutils.json_serialize.util.UniversalContainer": {"tf": 1}, "muutils.json_serialize.util.isinstance_namedtuple": {"tf": 1}, "muutils.json_serialize.util.try_catch": {"tf": 1}, "muutils.json_serialize.util.SerializationException": {"tf": 1}, "muutils.json_serialize.util.string_as_lines": {"tf": 1}, "muutils.json_serialize.util.safe_getsource": {"tf": 1}, "muutils.json_serialize.util.array_safe_eq": {"tf": 1}, "muutils.json_serialize.util.dc_eq": {"tf": 1}, "muutils.json_serialize.util.MonoTuple": {"tf": 1}, "muutils.statcounter.StatCounter.serialize": {"tf": 1}}, "df": 115, "r": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}, "muutils.json_serialize.json_serialize.GLOBAL_JSON_SERIALIZER": {"tf": 1}}, "df": 3, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.__init__": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.check": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize_func": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.uid": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.desc": {"tf": 1}, "muutils.json_serialize.json_serialize.SerializerHandler.serialize": {"tf": 1}}, "df": 7}}}}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_field": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints_cached": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.get_cls_type_hints": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.KWOnlyError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.NotSerializableFieldException": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldSerializationError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldLoadingError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.FieldTypeMismatchError": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.serializable_dataclass": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_field.SerializableField": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}, "muutils.json_serialize.serializable_field.serializable_field": {"tf": 1.4142135623730951}}, "df": 46, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}}, "df": 17}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"muutils.json_serialize.serializable_field.SerializableField": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.__init__": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialize": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.loading_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.assert_type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.custom_typecheck_fn": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.from_Field": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.name": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.type": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.init": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.repr": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.hash": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.compare": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.metadata": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.kw_only": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}}, "df": 20}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.serialization_fn": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.json_serialize.util.SerializationException": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {"muutils.interval.Interval.singleton_set": {"tf": 1}, "muutils.misc.dataclass_set_equals": {"tf": 1}, "muutils.misc.classes.dataclass_set_equals": {"tf": 1}, "muutils.mlutils.set_reproducibility": {"tf": 1}, "muutils.parallel.set_up_progress_bar_fn": {"tf": 1}}, "df": 5, "u": {"docs": {}, "df": 0, "p": {"docs": {"muutils.nbutils.configure_notebook.setup_plots": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_info.DEFAULT_SETTINGS": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.misc.empty_sequence_if_attr_false": {"tf": 1}, "muutils.misc.sequence": {"tf": 1}, "muutils.misc.sequence.WhenMissing": {"tf": 1}, "muutils.misc.sequence.empty_sequence_if_attr_false": {"tf": 1.4142135623730951}, "muutils.misc.sequence.flatten": {"tf": 1}, "muutils.misc.sequence.list_split": {"tf": 1}, "muutils.misc.sequence.list_join": {"tf": 1}, "muutils.misc.sequence.apply_mapping": {"tf": 1}, "muutils.misc.sequence.apply_mapping_chain": {"tf": 1}}, "df": 9}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.mlutils.DEFAULT_SEED": {"tf": 1}, "muutils.mlutils.GLOBAL_SEED": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.interval.Interval.singleton_set": {"tf": 1}, "muutils.interval.Interval.is_singleton": {"tf": 1}, "muutils.interval.Interval.singleton": {"tf": 1}, "muutils.interval.Interval.get_singleton": {"tf": 1}}, "df": 4}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.interval.Interval.size": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.logger.SimpleLogger": {"tf": 1}, "muutils.logger.SimpleLogger.__init__": {"tf": 1}, "muutils.logger.SimpleLogger.log": {"tf": 1}, "muutils.logger.simplelogger": {"tf": 1}, "muutils.logger.simplelogger.NullIO": {"tf": 1}, "muutils.logger.simplelogger.NullIO.write": {"tf": 1}, "muutils.logger.simplelogger.NullIO.flush": {"tf": 1}, "muutils.logger.simplelogger.NullIO.close": {"tf": 1}, "muutils.logger.simplelogger.AnyIO": {"tf": 1}, "muutils.logger.simplelogger.SimpleLogger": {"tf": 1.4142135623730951}, "muutils.logger.simplelogger.SimpleLogger.__init__": {"tf": 1.4142135623730951}, "muutils.logger.simplelogger.SimpleLogger.log": {"tf": 1.4142135623730951}}, "df": 12}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_KEYS": {"tf": 1}, "muutils.json_serialize.json_serialize.SERIALIZER_SPECIAL_FUNCS": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"muutils.misc.list_split": {"tf": 1}, "muutils.misc.sequence.list_split": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"muutils.spinner.Spinner.spin": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"muutils.parallel.spinner_fn_wrap": {"tf": 1}, "muutils.spinner": {"tf": 1}, "muutils.spinner.DecoratedFunction": {"tf": 1}, "muutils.spinner.SpinnerConfig": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.working": {"tf": 1}, "muutils.spinner.SpinnerConfig.success": {"tf": 1}, "muutils.spinner.SpinnerConfig.fail": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}, "muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}, "muutils.spinner.SpinnerConfigArg": {"tf": 1}, "muutils.spinner.SPINNERS": {"tf": 1}, "muutils.spinner.Spinner": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.__init__": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.config": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.format_string_when_updated": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.update_interval": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.message": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.current_value": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.format_string": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.output_stream": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.start_time": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.stop_spinner": {"tf": 1.7320508075688772}, "muutils.spinner.Spinner.spinner_thread": {"tf": 1.7320508075688772}, "muutils.spinner.Spinner.value_changed": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.term_width": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.state": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.spin": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.update_value": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.start": {"tf": 1.4142135623730951}, "muutils.spinner.Spinner.stop": {"tf": 1.4142135623730951}, "muutils.spinner.NoOpContextManager": {"tf": 1}, "muutils.spinner.NoOpContextManager.__init__": {"tf": 1}, "muutils.spinner.SpinnerContext": {"tf": 1}, "muutils.spinner.spinner_decorator": {"tf": 1.4142135623730951}}, "df": 37, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"muutils.spinner.SpinnerConfig": {"tf": 1}, "muutils.spinner.SpinnerConfig.__init__": {"tf": 1}, "muutils.spinner.SpinnerConfig.working": {"tf": 1}, "muutils.spinner.SpinnerConfig.success": {"tf": 1}, "muutils.spinner.SpinnerConfig.fail": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_ascii": {"tf": 1}, "muutils.spinner.SpinnerConfig.eq_lens": {"tf": 1}, "muutils.spinner.SpinnerConfig.is_valid": {"tf": 1}, "muutils.spinner.SpinnerConfig.from_any": {"tf": 1}}, "df": 9, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"muutils.spinner.SpinnerConfigArg": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"muutils.spinner.SpinnerContext": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"muutils.spinner.SPINNERS": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"muutils.tensor_info.SPARK_CHARS": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"muutils.tensor_info.generate_sparkline": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.math.bins.Bins.scale": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"muutils.nbutils.convert_ipynb_to_script": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1.4142135623730951}, "muutils.nbutils.convert_ipynb_to_script.convert_ipynb": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_file": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 7}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"muutils.statcounter.StatCounter.keys_sorted": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"muutils.sysinfo": {"tf": 1}, "muutils.sysinfo.SysInfo": {"tf": 1.4142135623730951}, "muutils.sysinfo.SysInfo.python": {"tf": 1.4142135623730951}, "muutils.sysinfo.SysInfo.pip": {"tf": 1.4142135623730951}, "muutils.sysinfo.SysInfo.pytorch": {"tf": 1.4142135623730951}, "muutils.sysinfo.SysInfo.platform": {"tf": 1.4142135623730951}, "muutils.sysinfo.SysInfo.git_info": {"tf": 1.4142135623730951}, "muutils.sysinfo.SysInfo.get_all": {"tf": 1.4142135623730951}}, "df": 8}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"muutils.tensor_info.SYMBOLS": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "g": {"docs": {"muutils.dbg": {"tf": 1}, "muutils.dbg.PATH_MODE": {"tf": 1}, "muutils.dbg.DEFAULT_VAL_JOINER": {"tf": 1}, "muutils.dbg.dbg": {"tf": 1.4142135623730951}, "muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1.4142135623730951}, "muutils.dbg.DBG_TENSOR_VAL_JOINER": {"tf": 1.4142135623730951}, "muutils.dbg.tensor_info": {"tf": 1}, "muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1.4142135623730951}, "muutils.dbg.DBG_LIST_DEFAULTS": {"tf": 1.4142135623730951}, "muutils.dbg.list_info": {"tf": 1}, "muutils.dbg.TENSOR_STR_TYPES": {"tf": 1}, "muutils.dbg.dict_info": {"tf": 1}, "muutils.dbg.info_auto": {"tf": 1}, "muutils.dbg.dbg_tensor": {"tf": 1.4142135623730951}, "muutils.dbg.dbg_dict": {"tf": 1.4142135623730951}, "muutils.dbg.dbg_auto": {"tf": 1.4142135623730951}, "muutils.dbg.grep_repr": {"tf": 1}}, "df": 17}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dbg.DEFAULT_VAL_JOINER": {"tf": 1}, "muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}, "muutils.json_serialize.json_serialize.DEFAULT_HANDLERS": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default": {"tf": 1}, "muutils.json_serialize.serializable_field.SerializableField.default_factory": {"tf": 1}, "muutils.logger.LoggingStream.default_level": {"tf": 1}, "muutils.logger.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_level": {"tf": 1}, "muutils.logger.loggingstream.LoggingStream.default_contents": {"tf": 1}, "muutils.logger.timing.ProgressEstimator.get_progress_default": {"tf": 1}, "muutils.mlutils.DEFAULT_SEED": {"tf": 1}, "muutils.parallel.DEFAULT_PBAR_FN": {"tf": 1}, "muutils.tensor_info.DEFAULT_SETTINGS": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_ALLOWED_EXTENSIONS": {"tf": 1}, "muutils.web.bundle_html.DEFAULT_TAG_ATTR": {"tf": 1}}, "df": 15, "s": {"docs": {"muutils.dbg.DBG_TENSOR_ARRAY_SUMMARY_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1}, "muutils.dbg.DBG_LIST_DEFAULTS": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.DefaulterDict": {"tf": 1}, "muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {"muutils.json_serialize.json_serialize.SerializerHandler.desc": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.deserialize_fn": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"muutils.logger.logger.decode_level": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"muutils.spinner.DecoratedFunction": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"muutils.spinner.spinner_decorator": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"muutils.mlutils.get_device": {"tf": 1}, "muutils.tensor_info.format_device_colored": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dbg.DBG_DICT_DEFAULTS": {"tf": 1}, "muutils.dbg.dict_info": {"tf": 1}, "muutils.dbg.dbg_dict": {"tf": 1}, "muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}, "muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}, "muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}, "muutils.json_serialize.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.update_from_nested_dict": {"tf": 1}, "muutils.misc.dict_to_filename": {"tf": 1}, "muutils.misc.string.dict_to_filename": {"tf": 1}, "muutils.tensor_utils.get_dict_shapes": {"tf": 1}, "muutils.tensor_utils.string_dict_shapes": {"tf": 1}}, "df": 16, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"muutils.dictmagic": {"tf": 1}, "muutils.dictmagic.DefaulterDict": {"tf": 1}, "muutils.dictmagic.DefaulterDict.default_factory": {"tf": 1}, "muutils.dictmagic.defaultdict_to_dict_recursive": {"tf": 1}, "muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}, "muutils.dictmagic.update_with_nested_dict": {"tf": 1}, "muutils.dictmagic.kwargs_to_nested_dict": {"tf": 1}, "muutils.dictmagic.is_numeric_consecutive": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.dictmagic.tuple_dims_replace": {"tf": 1}, "muutils.dictmagic.TensorDict": {"tf": 1}, "muutils.dictmagic.TensorIterable": {"tf": 1}, "muutils.dictmagic.TensorDictFormats": {"tf": 1}, "muutils.dictmagic.condense_tensor_dict": {"tf": 1}}, "df": 17}}}}}, "s": {"docs": {"muutils.dictmagic.condense_nested_dicts_numeric_keys": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts_matching_values": {"tf": 1}, "muutils.dictmagic.condense_nested_dicts": {"tf": 1}, "muutils.tensor_utils.compare_state_dicts": {"tf": 1}}, "df": 4}}}, "m": {"docs": {}, "df": 0, "s": {"docs": {"muutils.dictmagic.tuple_dims_replace": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "f": {"docs": {"muutils.json_serialize.SerializableDataclass.diff": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.diff": {"tf": 1}}, "df": 2}}, "r": {"docs": {"muutils.nbutils.convert_ipynb_to_script.process_dir": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"muutils.json_serialize.json_serialize.SERIALIZE_DIRECT_AS_STR": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.DISABLE_PLOTS_WARNING": {"tf": 1}, "muutils.nbutils.convert_ipynb_to_script.disable_plots_in_script": {"tf": 1}}, "df": 3}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"muutils.dictmagic.dotlist_to_nested_dict": {"tf": 1}, "muutils.dictmagic.nested_dict_to_dotlist": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {"muutils.json_serialize.serializable_field.SerializableField.doc": {"tf": 1}, "muutils.kappa.Kappa.doc": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"muutils.misc.dynamic_docstring": {"tf": 1}, "muutils.misc.func.format_docstring": {"tf": 1}, "muutils.misc.string.dynamic_docstring": {"tf": 1}}, "df": 3}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"muutils.json_serialize.serializable_dataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.CantGetTypeHintsWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.ZanjMissingWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.zanj_register_loader_serializable_dataclass": {"tf": 1.4142135623730951}, "muutils.json_serialize.serializable_dataclass.FieldIsNotInitOrSerializeWarning": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_field_type": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types__dict": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass__validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.serialize": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.load": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_fields_types": {"tf": 1}, "muutils.json_serialize.serializable_dataclass.SerializableDataclass.validate_field_type": {"tf": 1}, "muutils.js