from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="ozonapi-async",
    version="0.1.0",
    author="a-ulianov",
    description="Python client for Ozon API",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/a-ulianov/OzonAPI",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Programming Language :: Python :: 3.14",
    ],
    python_requires=">=3.10",
    install_requires=[
        "aiohappyeyeballs==2.6.1",
        "aiohttp==3.12.15",
        "aiolimiter==1.2.1",
        "aiosignal==1.4.0",
        "annotated-types==0.7.0",
        "attrs==25.3.0",
        "colorama==0.4.6",
        "coverage==7.11.0",
        "frozenlist==1.7.0",
        "idna==3.10",
        "iniconfig==2.1.0",
        "loguru==0.7.3",
        "multidict==6.6.4",
        "packaging==25.0",
        "pluggy==1.6.0",
        "propcache==0.3.2",
        "pydantic==2.11.9",
        "pydantic-settings==2.11.0",
        "pydantic_core==2.33.2",
        "Pygments==2.19.2",
        "pytest==8.4.2",
        "pytest-asyncio==1.2.0",
        "pytest-cov==7.0.0",
        "python-dotenv==1.1.1",
        "tenacity==9.1.2",
        "typing-inspection==0.4.2",
        "typing_extensions==4.15.0",
        "win32_setctime==1.2.0",
        "yarl==1.20.1",
    ],
)