"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const asset_manifest_artifact_1 = require("./artifacts/asset-manifest-artifact");
const ros_stack_artifact_1 = require("./artifacts/ros-stack-artifact");
const nested_cloud_assembly_artifact_1 = require("./artifacts/nested-cloud-assembly-artifact");
const tree_cloud_artifact_1 = require("./artifacts/tree-cloud-artifact");
const cloud_artifact_1 = require("./cloud-artifact");
const cxschema = require("@alicloud/ros-cdk-assembly-schema");
/**
 * Add the 'fromManifest' factory function
 *
 * It is defined in a separate file to avoid circular dependencies between 'cloud-artifact.ts'
 * and all of its subclass files.
 */
cloud_artifact_1.CloudArtifact.fromManifest = function fromManifest(assembly, id, artifact) {
    switch (artifact.type) {
        case cxschema.ArtifactType.ALIYUN_ROS_STACK:
            return new ros_stack_artifact_1.RosStackArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.CDK_TREE:
            return new tree_cloud_artifact_1.TreeCloudArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.ASSET_MANIFEST:
            return new asset_manifest_artifact_1.AssetManifestArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY:
            return new nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact(assembly, id, artifact);
        default:
            return undefined;
    }
};
//# sourceMappingURL=data:application/json;base64,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