
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: ContribPlugin(BuildFileAddress(BuildFile(contrib/node/src/python/pants/contrib/node/BUILD, FileSystemProjectTree(/Users/stuhood/src/pants)), plugin))

from setuptools import setup

setup(**
{   'classifiers': [   'Intended Audience :: Developers',
                       'License :: OSI Approved :: Apache Software License',
                       'Operating System :: MacOS :: MacOS X',
                       'Operating System :: POSIX :: Linux',
                       'Programming Language :: Python',
                       'Topic :: Software Development :: Build Tools'],
    'description': 'Node.js support for pants.',
    'entry_points': {   'pantsbuild.plugin': [   'build_file_aliases = pants.contrib.node.register:build_file_aliases',
                                                 'register_goals = pants.contrib.node.register:register_goals',
                                                 'global_subsystems = pants.contrib.node.register:global_subsystems']},
    'install_requires': ['pantsbuild.pants==0.0.79', 'six>=1.9.0,<2'],
    'license': 'Apache License, Version 2.0',
    'long_description': 'Pants is an Apache2 licensed build tool written in Python.\n\nThe latest documentation can be found `here <http://pantsbuild.github.io/>`_.\n\nRELEASE HISTORY\n===============\n\n0.0.79 (03/26/2016)\n-------------------\n\nThis is the regularly scheduled release that would have been 0.0.78. Due to an upload issue and\na desire for immutable versions, the 0.0.78 version number was skipped: all deprecations have been\nextended by one release to account for that.\n\nBugfixes\n~~~~~~~~\n\n* Only mark a build incremental if it is successfully cloned\n  `RB #3613 <https://rbcommons.com/s/twitter/r/3613>`_\n\n* Avoid pathological regex performance when linkifying large ivy output.\n  `RB #3603 <https://rbcommons.com/s/twitter/r/3603>`_\n\n* Convert ivy lock to use OwnerPrintingPIDLockFile\n  `RB #3598 <https://rbcommons.com/s/twitter/r/3598>`_\n\n* Fix errors due to iterating over None-types in ivy resolve.\n  `RB #3596 <https://rbcommons.com/s/twitter/r/3596>`_\n\n* Do not return directories from BUILD file\'s globs implementation\n  `RB #3590 <https://rbcommons.com/s/twitter/r/3590>`_\n\n* Fix unicode parsing of ini files.\n  `RB #3595 <https://rbcommons.com/s/twitter/r/3595>`_\n\n* Fix \'compute_hashes\' for \'Page\' target type\n  `RB #3591 <https://rbcommons.com/s/twitter/r/3591>`_\n\n* Fix globs for empty SourcesField\n  `RB #3614 <https://rbcommons.com/s/twitter/r/3614>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Validate command line options regardless whether goals use them.\n  `RB #3594 <https://rbcommons.com/s/twitter/r/3594>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Allow a period in a namedver for publishing\n  `RB #3611 <https://rbcommons.com/s/twitter/r/3611>`_\n\n* Bump the junit runner release to 1.0.4 to pick up latest code changes\n  `RB #3599 <https://rbcommons.com/s/twitter/r/3599>`_\n\n* Re-add the ConsoleRunnerOutputTests and consolodate them into ConsoleRunnerTest, also move test clases used for testing into junit/lib directory\n  `RB #2406 <https://rbcommons.com/s/twitter/r/2406>`_\n  `RB #3588 <https://rbcommons.com/s/twitter/r/3588>`_\n\n* Add the Android SDK to the linux CI and turn on Android tests.\n  `RB #3538 <https://rbcommons.com/s/twitter/r/3538>`_\n\n* Update pyflakes to 1.1.0, enable pyflakes checks and fix all warnings\n  `RB #3601 <https://rbcommons.com/s/twitter/r/3601>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Calculate legacy target sources using the engine\n  `Issue #3058 <https://github.com/pantsbuild/pants/issues/3058>`_\n  `RB #3474 <https://rbcommons.com/s/twitter/r/3474>`_\n  `RB #3592 <https://rbcommons.com/s/twitter/r/3592>`_\n\n* Split literal from netrc credentials to allow pickling\n  `Issue #3058 <https://github.com/pantsbuild/pants/issues/3058>`_\n  `RB #3605 <https://rbcommons.com/s/twitter/r/3605>`_\n\n* Make shader classes top-level to allow for pickling\n  `RB #3606 <https://rbcommons.com/s/twitter/r/3606>`_\n\n* [engine] no longer content address subject\n  `Issue #3066 <https://github.com/pantsbuild/pants/issues/3066>`_\n  `RB #3593 <https://rbcommons.com/s/twitter/r/3593>`_\n  `RB #3604 <https://rbcommons.com/s/twitter/r/3604>`_\n\n* Hide cycle in testprojects\n  `RB #3600 <https://rbcommons.com/s/twitter/r/3600>`_\n\n* [engine] Eliminate non-determinism computing cache keys\n  `RB #3593 <https://rbcommons.com/s/twitter/r/3593>`_\n\n0.0.77 (03/18/2016)\n-------------------\n\nBugfixes\n~~~~~~~~\n\n* Update --pinger-tries option to int\n  `RB #3541 <https://rbcommons.com/s/twitter/r/3541>`_\n  `RB #3561 <https://rbcommons.com/s/twitter/r/3561>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Report @Ignore tests in xml reports from JUnit and create report for tests that fail in initialization\n  `RB #3571 <https://rbcommons.com/s/twitter/r/3571>`_\n\n* Record the compile classpath used to compile jvm targets.\n  `RB #3576 <https://rbcommons.com/s/twitter/r/3576>`_\n\n* Add ignore option to pyflakes check\n  `RB #3569 <https://rbcommons.com/s/twitter/r/3569>`_\n\n* Prepare for a global --shard flag.\n  `RB #3560 <https://rbcommons.com/s/twitter/r/3560>`_\n\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Bump junit-runner to 1.0.3\n  `RB #3585 <https://rbcommons.com/s/twitter/r/3585>`_\n\n* Remove unneeded args4j handler registrations that cause failures in\n  tests and rename TestParser\n  \n  `Issue #1727 <https://github.com/pantsbuild/pants/issues/1727>`_\n  `RB #3571 <https://rbcommons.com/s/twitter/r/3571>`_\n  `RB #3583 <https://rbcommons.com/s/twitter/r/3583>`_\n\n* Set public API markers for subsystem, process, reporting and scm\n  `RB #3551 <https://rbcommons.com/s/twitter/r/3551>`_\n\n* Create and use stable symlinks for the target results dir\n  `RB #3553 <https://rbcommons.com/s/twitter/r/3553>`_\n\n* Split Ivy Resolve into Resolve / Fetch steps\n  `Issue #3052 <https://github.com/pantsbuild/pants/issues/3052>`_\n  `Issue #3053 <https://github.com/pantsbuild/pants/issues/3053>`_\n  `Issue #3054 <https://github.com/pantsbuild/pants/issues/3054>`_\n  `Issue #3055 <https://github.com/pantsbuild/pants/issues/3055>`_\n  `RB #3555 <https://rbcommons.com/s/twitter/r/3555>`_\n\n* [pantsd] Add support for fetching watchman via BinaryUtil.\n  `RB #3557 <https://rbcommons.com/s/twitter/r/3557>`_\n\n* Only bootstrap the zinc worker pool if there is work to do\n  `RB #3559 <https://rbcommons.com/s/twitter/r/3559>`_\n\n* Bump pex requirement to 1.1.4.\n  `RB #3568 <https://rbcommons.com/s/twitter/r/3568>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Introduce ProductGraph invalidation.\n  `RB #3578 <https://rbcommons.com/s/twitter/r/3578>`_\n\n* [engine] skip caching for native nodes\n  `RB #3581 <https://rbcommons.com/s/twitter/r/3581>`_\n\n* [engine] More pickle cleanups\n  `RB #3577 <https://rbcommons.com/s/twitter/r/3577>`_\n\n* [engine] cache StepResult under StepRequest\n  `RB #3494 <https://rbcommons.com/s/twitter/r/3494>`_\n\n* [engine] turn off pickle memoization\n  `Issue #2969 <https://github.com/pantsbuild/pants/issues/2969>`_\n  `RB #3574 <https://rbcommons.com/s/twitter/r/3574>`_\n\n* [engine] Add support for directory matches to PathGlobs, and use for inference\n  `RB #3567 <https://rbcommons.com/s/twitter/r/3567>`_\n\n\n0.0.76 (03/11/2016)\n-------------------\n\nThis release features:\n\n* The removal of the --fail-slow option to pytest.  This is now the default,\n  use --fail-fast for the opposite behavior.\n\n* Moving the Android backend into contrib.\n\n* Support for a special append syntax for list options: +=.\n\n* Tightening up of some aspects of option type conversion. There may be options\n  in plugins that were relying on broken behavior (such as when using a string where an\n  int was expected), and that will now (correctly) break.\n\n* Deprecation of the PANTS_DEFAULT_* env vars in favor of PANTS_GLOBAL_*.\n\n* Lots of engine work.\n\n* A fix to task implementation versions so that bumping the task version\n  will also invalidate artifacts it produced (not just invalidate .pants.d entries).\n\nAPI Changes\n~~~~~~~~~~~\n\n* Move Android into contrib and remove android special-casing.\n  `RB #3530 <https://rbcommons.com/s/twitter/r/3530>`_\n  `RB #3531 <https://rbcommons.com/s/twitter/r/3531>`_\n\nBugfixes\n~~~~~~~~\n\n* fix typo introduced in https://rbcommons.com/s/twitter/r/3531/\n  `RB #3531 <https://rbcommons.com/s/twitter/r/3531>`_\n  `RB #3552 <https://rbcommons.com/s/twitter/r/3552>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Reimplement list options to support appending.\n  `RB #3541 <https://rbcommons.com/s/twitter/r/3541>`_\n\n* Initial round of pantsd + new engine + watchman integration.\n  `RB #3524 <https://rbcommons.com/s/twitter/r/3524>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Adds support for golang meta info for imports\n  `Issue #2378 <https://github.com/pantsbuild/pants/issues/2378>`_\n  `RB #3443 <https://rbcommons.com/s/twitter/r/3443>`_\n\n* Update export TODO to point to the relevant intellij-plugin issue; rm ref to non-existent option\n  `RB #3558 <https://rbcommons.com/s/twitter/r/3558>`_\n\n* Use the task implementation version in the fingerprint of a task, to cause cache invalidation for TaskIdentityFingerprintStrategy.\n  `RB #3546 <https://rbcommons.com/s/twitter/r/3546>`_\n\n* Deprecate version_filter from python_requirement\n  `RB #3545 <https://rbcommons.com/s/twitter/r/3545>`_\n\n* Add _copy_target_attributes implementation to antlr\n  `RB #3352 <https://rbcommons.com/s/twitter/r/3352>`_\n  `RB #3402 <https://rbcommons.com/s/twitter/r/3402>`_\n  `RB #3547 <https://rbcommons.com/s/twitter/r/3547>`_\n\n* Make synthetic jar_library targets dependencies of android_binary.\n  `RB #3526 <https://rbcommons.com/s/twitter/r/3526>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Move storage out of scheduler to engine\n  `RB #3554 <https://rbcommons.com/s/twitter/r/3554>`_\n\n* [engine] Add native filesystem node type.\n  `RB #3550 <https://rbcommons.com/s/twitter/r/3550>`_\n\n* [engine] Implement support for recursive path globs\n  `RB #3540 <https://rbcommons.com/s/twitter/r/3540>`_\n\n* [engine] Extract scheduler test setup to a helper\n  `RB #3548 <https://rbcommons.com/s/twitter/r/3548>`_\n\n* [bugfix] Properly opt out of zinc\'s fingerprinting of Resources.\n  `RB #3185 <https://rbcommons.com/s/twitter/r/3185>`_\n\n* [engine] switch content addressable storage from dict to a embedded db\n  `RB #3517 <https://rbcommons.com/s/twitter/r/3517>`_\n\n0.0.75 (03/07/2016)\n-------------------\n\nThis release completes the deprecation cycle for several options:\n\n* `--scala-platform-runtime`: The `--scala-platform-version` is now used to configure the scala runtime lib.\n* `--use-old-naming-style` for the `export-classpath` goal: The old naming style is no longer supported.\n* `--spec-excludes`: Use `--ignore-patterns` instead.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove deprecated code planned to remove in 0.0.74 and 0.0.75 versions\n  `RB #3527 <https://rbcommons.com/s/twitter/r/3527>`_\n\nBugfixes\n~~~~~~~~\n\n* Lock ivy resolution based on the cache directory being used.\n  `RB #3529 <https://rbcommons.com/s/twitter/r/3529>`_\n\n* Fix an issue where ivy-bootstrap is ignoring http proxy setttings\n  `RB #3522 <https://rbcommons.com/s/twitter/r/3522>`_\n\n* Clone jars rather than mutating them during ivy resolve\n  `RB #3203 <https://rbcommons.com/s/twitter/r/3203>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* allow list-owners to accept multiple source files and output JSON\n  `RB #2755 <https://rbcommons.com/s/twitter/r/2755>`_\n  `RB #3534 <https://rbcommons.com/s/twitter/r/3534>`_\n\n* add JSON output-format option to dependees\n  `RB #3534 <https://rbcommons.com/s/twitter/r/3534>`_\n  `RB #3536 <https://rbcommons.com/s/twitter/r/3536>`_\n\n* Allow running prep_commands in goals other than test\n  `RB #3519 <https://rbcommons.com/s/twitter/r/3519>`_\n\n* When using ./pants options, hide options from super-scopes.\n  `RB #3528 <https://rbcommons.com/s/twitter/r/3528>`_\n\n* zinc: optionize fatal-warnings compiler args\n  `RB #3509 <https://rbcommons.com/s/twitter/r/3509>`_\n\n* An option to set the location of config files.\n  `RB #3500 <https://rbcommons.com/s/twitter/r/3500>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Fix failing test on CI after \'Remove deprecated code planned to remove in 0.0.74 and 0.0.75 versions\' change\n  `RB #3527 <https://rbcommons.com/s/twitter/r/3527>`_\n  `RB #3533 <https://rbcommons.com/s/twitter/r/3533>`_\n\n* Set public API markers for task and util\n  `RB #3520 <https://rbcommons.com/s/twitter/r/3520>`_\n\n* Set public api markers for jvm backend\n  `RB #3515 <https://rbcommons.com/s/twitter/r/3515>`_\n\n* pythonstyle perf: dont parse the exclusions file for every source file.\n  `RB #3518 <https://rbcommons.com/s/twitter/r/3518>`_\n\n* Extract a BuildGraph interface\n  `Issue #2979 <https://github.com/pantsbuild/pants/issues/2979>`_\n  `RB #3514 <https://rbcommons.com/s/twitter/r/3514>`_\n\n* increase compile.zinc integration test timeout\n  `RB #3507 <https://rbcommons.com/s/twitter/r/3507>`_\n\n* fix zinc testing instructions\n  `RB #3513 <https://rbcommons.com/s/twitter/r/3513>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Implement the BuildGraph interface via the engine\n  `RB #3516 <https://rbcommons.com/s/twitter/r/3516>`_\n\n0.0.74 (02/27/2016)\n-------------------\n\nThis release changes how pants detects the buildroot from using the location of a\n\'pants.ini\' file, to using the location of a file named \'pants\' (usually the name of\nthe pants executable script at the root of a repo). This is in service of allowing for\nzero-or-more pants.ini/config files in the future.\n\nAdditionally, there is now support for validating that all options defined in a\npants.ini file are valid options. Passing or configuring \'--verify-config\' will trigger\nthis validation. To allow global options to be verified, a new [GLOBAL] section is now the\nrecommend place to specify global options. This differentiates them from [DEFAULT] options,\nwhich may be used as template values in other config sections, and thus cannot be verified.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Set public api markers for jvm tasks\n  `RB #3499 <https://rbcommons.com/s/twitter/r/3499>`_\n\n* Change how we detect the buildroot.\n  `RB #3489 <https://rbcommons.com/s/twitter/r/3489>`_\n\n* Add public api markers for core_tasks\n  `RB #3490 <https://rbcommons.com/s/twitter/r/3490>`_\n\n* Add [GLOBAL] in pants.ini for pants global options; Add config file validations against options\n  `RB #3475 <https://rbcommons.com/s/twitter/r/3475>`_\n\n* Add public api markers for pantsd and options\n  `RB #3484 <https://rbcommons.com/s/twitter/r/3484>`_\n\nBugfixes\n~~~~~~~~\n\n* Allow for running the invalidation report when clean-all is on the command line\n  `RB #3503 <https://rbcommons.com/s/twitter/r/3503>`_\n\n* Enable fail-fast for pytest so it works like fail-fast for junit\n  `RB #3497 <https://rbcommons.com/s/twitter/r/3497>`_\n\n* Reset Subsystems when creating a new context in tests\n  `RB #3496 <https://rbcommons.com/s/twitter/r/3496>`_\n\n* Set timeout for the long running \'testprojects\' integration test\n  `RB #3491 <https://rbcommons.com/s/twitter/r/3491>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Java checkstyle will optionally not include the runtime classpath with checkstyle\n  `RB #3487 <https://rbcommons.com/s/twitter/r/3487>`_\n\n* Error out on duplicate artifacts for jar publish.\n  `RB #3481 <https://rbcommons.com/s/twitter/r/3481>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Change ivy resolve ordering to attempt load first and fall back to full resolve if load fails.\n  `RB #3501 <https://rbcommons.com/s/twitter/r/3501>`_\n\n* Clean up extraneous code in jvm_compile.\n  `RB #3504 <https://rbcommons.com/s/twitter/r/3504>`_\n\n* Retrieve jars from IvyInfo using a collection of coordinates instead of jar_library targets.\n  `RB #3495 <https://rbcommons.com/s/twitter/r/3495>`_\n\n* Document the \'timeout\' parameter to junit_tests and python_tests\n  `RB #3492 <https://rbcommons.com/s/twitter/r/3492>`_\n\n* When a timeout triggers, first do SIGTERM, then wait a bit, and then do SIGKILL\n  `RB #3479 <https://rbcommons.com/s/twitter/r/3479>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Introduce content-addressability\n  `Issue #2968 <https://github.com/pantsbuild/pants/issues/2968>`_\n  `Issue #2956 <https://github.com/pantsbuild/pants/issues/2956>`_\n  `RB #3498 <https://rbcommons.com/s/twitter/r/3498>`_\n\n* [engine] First round of work for \'native\' filesystem support\n  `Issue #2946, <https://github.com/pantsbuild/pants/issues/2946>`_\n  `RB #3488 <https://rbcommons.com/s/twitter/r/3488>`_\n\n* [engine] Implement recursive address walking\n  `RB #3485 <https://rbcommons.com/s/twitter/r/3485>`_\n\n0.0.73 (02/19/2016)\n-------------------\n\nThis release features more formal public API docstrings for many modules\nand classes.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Add public API markers for python backend and others\n  `RB #3473 <https://rbcommons.com/s/twitter/r/3473>`_\n  `RB #3469 <https://rbcommons.com/s/twitter/r/3469>`_\n\n* Upgrade default go to 1.6.\n  `RB #3476 <https://rbcommons.com/s/twitter/r/3476>`_\n\nBugfixes\n~~~~~~~~\n\n* Add styleguide to docs\n  `RB #3456 <https://rbcommons.com/s/twitter/r/3456>`_\n\n* Remove unused kwarg, locally_changed_targets, from Task.invalidated\n  `RB #3467 <https://rbcommons.com/s/twitter/r/3467>`_\n\n* support searching multiple linux java dist dirs\n  `RB #3472 <https://rbcommons.com/s/twitter/r/3472>`_\n\n* Separate cli spec parsing from filesystem walking\n  `RB #3466 <https://rbcommons.com/s/twitter/r/3466>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Allow for random build ordering\n  `RB #3462 <https://rbcommons.com/s/twitter/r/3462>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Bump junit runner and jar tool versions to newly published\n  `RB #3477 <https://rbcommons.com/s/twitter/r/3477>`_\n\n* Add Foursquare\'s Fsq.io to the "Powered By"  page.\n  `RB #3323 <https://rbcommons.com/s/twitter/r/3323>`_\n\n* Upgrade default go to 1.6.\n  `RB #3476 <https://rbcommons.com/s/twitter/r/3476>`_\n\n* Remove unused partitioning support in cache and invalidation support\n  `RB #3467 <https://rbcommons.com/s/twitter/r/3467>`_\n  `RB #3474 <https://rbcommons.com/s/twitter/r/3474>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Noop only a cyclic dependency, and not an entire Node\n  `RB #3478 <https://rbcommons.com/s/twitter/r/3478>`_\n\n* [engine] Tighten input validation\n  `Issue #2525 <https://github.com/pantsbuild/pants/issues/2525>`_\n  `Issue #2526 <https://github.com/pantsbuild/pants/issues/2526>`_\n  `RB #3245 <https://rbcommons.com/s/twitter/r/3245>`_\n  `RB #3448 <https://rbcommons.com/s/twitter/r/3448>`_\n\n\n0.0.72 (02/16/2016)\n-------------------\nThis release concludes the deprecation cycle for the old API for\nscanning BUILD files.\n\nThe following classes were removed:\n\n* ``FilesystemBuildFile`` (Create ``BuildFile`` with ``IoFilesystem`` instead.)\n* ``ScmBuildFile`` (Create ``BuildFile`` with ``ScmFilesystem`` instead.)\n\nThe following methods were removed:\n\n* ``BuildFile.scan_buildfiles`` (Use ``BuildFile.scan_build_files`` instead.)\n* ``BuildFile.from_cache``\n* ``BuildFile.file_exists``\n* ``BuildFile.descendants``\n* ``BuildFile.ancestors``\n* ``BuildFile.siblings``\n* ``BuildFile.family`` (Use ``get_build_files_family`` instead.)\n* ``BuildFileAddressMapper.from_cache``\n* ``BuildFileAddressMapper.scan_buildfiles``\n* ``BuildFileAddressMapper.address_map_from_build_file`` (Use ``address_map_from_build_files`` instead.)\n* ``BuildFileAddressMapper.parse_build_file_family`` (Use ``parse_build_files`` instead.)\n\nThis release features formal public API docstrings for many modules\nand classes.  It also includes many bugfixes and minor improvements.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Add public api markers to the following:\n  `RB #3453 <https://rbcommons.com/s/twitter/r/3453>`_\n\n* add public api markers to several modules\n  `RB #3442 <https://rbcommons.com/s/twitter/r/3442>`_\n\n* add public api markers\n  `RB #3440 <https://rbcommons.com/s/twitter/r/3440>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix `./pants list` without arguments output\n  `RB #3464 <https://rbcommons.com/s/twitter/r/3464>`_\n\n* jar-tool properly skipping Manifest file using entry\'s jarPath\n  `RB #3437 <https://rbcommons.com/s/twitter/r/3437>`_\n\n* fix pathdeps for synthetic targets.\n  `RB #3454 <https://rbcommons.com/s/twitter/r/3454>`_\n\n* Add param to fingerprint_strategy __eq__\n  `RB #3446 <https://rbcommons.com/s/twitter/r/3446>`_\n\n* Increase resolution from .1 second to 1 second\n  `RB #3311 <https://rbcommons.com/s/twitter/r/3311>`_\n\n* Fix build break due to missing whitespace\n\n* Fix linkify for relative paths pointing outside the buildroot\n  `RB #3441 <https://rbcommons.com/s/twitter/r/3441>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Options goal to show only functioning options instead of all.\n  `RB #3455 <https://rbcommons.com/s/twitter/r/3455>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Skip hashing in ivy fingerprint strategy if target doesn\'t need fingerprinting\n  `RB #3447 <https://rbcommons.com/s/twitter/r/3447>`_\n\n* Add \'Deprecation Policy\' docs for 1.0.0.\n  `RB #3457 <https://rbcommons.com/s/twitter/r/3457>`_\n\n* Remove dead code\n  `RB #3454 <https://rbcommons.com/s/twitter/r/3454>`_\n  `RB #3461 <https://rbcommons.com/s/twitter/r/3461>`_\n\n* Clean up stale builds in .pants.d\n  `RB #2506 <https://rbcommons.com/s/twitter/r/2506>`_\n  `RB #3444 <https://rbcommons.com/s/twitter/r/3444>`_\n\n* Adding a newline symbol for unary shading rules.\n  `RB #3452 <https://rbcommons.com/s/twitter/r/3452>`_\n\n* Make IvyTaskMixin.ivy_resolve private, introduce ivy_classpath; clean up some ivy resolve tests\n  `RB #3450 <https://rbcommons.com/s/twitter/r/3450>`_\n\n* Move namedtuple declarations out of IvyUtils._generate_jar_template\n  `RB #3451 <https://rbcommons.com/s/twitter/r/3451>`_\n\n* Adjust type comment for targets param in JarDependencyManagement.targets_by_artifact_set\n  `RB #3449 <https://rbcommons.com/s/twitter/r/3449>`_\n\n* Only invalidate haskell-project targets.\n  `RB #3445 <https://rbcommons.com/s/twitter/r/3445>`_\n\n* Polishing --ignore-patterns change\n  `RB #3438 <https://rbcommons.com/s/twitter/r/3438>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Minor import cleanups\n  `RB #3458 <https://rbcommons.com/s/twitter/r/3458>`_\n\n0.0.71 (02/05/2016)\n-------------------\n\nThis release is primarily comprised of bugfixes, although there was also removal of support for the\ndeprecated `--use-old-naming-style` flag for the `export-classpath` goal.\n\nIf you use pants with custom plugins you\'ve developed, you should be interested in the first\nappearance of a means of communicating the public APIs you can rely on.  You can read\nhttps://rbcommons.com/s/twitter/r/3417 to get a peek at what\'s to come.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove deprecated `--use-old-naming-style` flag.\n  `RB #3427 <https://rbcommons.com/s/twitter/r/3427>`_\n\nBugfixes\n~~~~~~~~\n\n* bug fix: remove duplicate 3rdparty jars in the bundle\n  `RB #3329 <https://rbcommons.com/s/twitter/r/3329>`_\n  `RB #3412 <https://rbcommons.com/s/twitter/r/3412>`_\n\n* Fix __metaclass__ T605:WARNING.\n  `RB #3424 <https://rbcommons.com/s/twitter/r/3424>`_\n\n* Retain file permissions when shading monolithic jars.\n  `RB #3420 <https://rbcommons.com/s/twitter/r/3420>`_\n\n* Bump jarjar.  The new version is faster and fixes a bug.\n  `RB #3405 <https://rbcommons.com/s/twitter/r/3405>`_\n\n* If the junit output file doesn\'t exist, it should still count as an error on the target\n  `RB #3407 <https://rbcommons.com/s/twitter/r/3407>`_\n\n* When a python test fails outside of a function, the resultslog message is just [EF] file.py, without the double-colons\n  `RB #3397 <https://rbcommons.com/s/twitter/r/3397>`_\n\n* Fix "ValueError: too many values to unpack" when parsing interpreter versions.\n  `RB #3411 <https://rbcommons.com/s/twitter/r/3411>`_\n\n* Update how_to_develop.md\'s examples\n  `RB #3408 <https://rbcommons.com/s/twitter/r/3408>`_\n\n* bug fix: is_app filter not applied when using wildcard\n  `RB #3272 <https://rbcommons.com/s/twitter/r/3272>`_\n  `RB #3398 <https://rbcommons.com/s/twitter/r/3398>`_\n\n* Add validations to jvm_app bundles; Fix typo in BundleProps construction; fix relative globs\n  `RB #3396 <https://rbcommons.com/s/twitter/r/3396>`_\n\n* Add process-level buildroot validation to NailgunExecutor.\n  `RB #3393 <https://rbcommons.com/s/twitter/r/3393>`_\n\n* Adding support for multiline param help descriptions in Pants BUILD Dictionary\n  `RB #3399 <https://rbcommons.com/s/twitter/r/3399>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Cleaning up jarjar rules, and adding support for keep and zap.\n  `RB #3428 <https://rbcommons.com/s/twitter/r/3428>`_\n\n* Introduce ignore_patterns option\n  `RB #3414 <https://rbcommons.com/s/twitter/r/3414>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Fix bad test target deps.\n  `RB #3425 <https://rbcommons.com/s/twitter/r/3425>`_\n\n* add public api markers\n  `RB #3417 <https://rbcommons.com/s/twitter/r/3417>`_\n\n* Attempt a fix for flaky zinc compile failures under Travis-CI.\n  `RB #3413 <https://rbcommons.com/s/twitter/r/3413>`_\n  `RB #3426 <https://rbcommons.com/s/twitter/r/3426>`_\n\n* Cleanup: rename ivy_resolve kwarg custom_args to extra_args; move / rm unnecessary conf or defaults; rm unnecessary extra_args\n  `RB #3416 <https://rbcommons.com/s/twitter/r/3416>`_\n\n* Use one zinc worker per core by default.\n  `RB #3413 <https://rbcommons.com/s/twitter/r/3413>`_\n\n* Add sublime text project/workspace extensions to pants .gitignore.\n  `RB #3409 <https://rbcommons.com/s/twitter/r/3409>`_\n\n* Refactor IvyTaskMixin\'s ivy_resolve and functions it depends on\n  `RB #3371 <https://rbcommons.com/s/twitter/r/3371>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Implement BUILD file parsing inside the engine\n  `RB #3377 <https://rbcommons.com/s/twitter/r/3377>`_\n\n\n0.0.70 (01/29/2016)\n-------------------\n\nThis release contains a few big steps towards 1.0.0! The last known issues with build\ncaching are fixed, so this release enables using a local build cache by default. The\nrelease also includes \'task implementation versioning\', so that cached artifacts will\nautomatically be invalidated as the implementations of Tasks change between pants releases.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Improve deprecated option handling to allow options hinting beyond deprecation version.\n  `RB #3369 <https://rbcommons.com/s/twitter/r/3369>`_\n\n* Remove the need to specify scalastyle in BUILD.tools\n  `RB #3355 <https://rbcommons.com/s/twitter/r/3355>`_\n\n* Bumping Node to 5.5.0\n  `RB #3366 <https://rbcommons.com/s/twitter/r/3366>`_\n\nBugfixes\n~~~~~~~~\n\n* Don\'t error in export when a target does not have an alias\n  `RB #3379 <https://rbcommons.com/s/twitter/r/3379>`_\n  `RB #3383 <https://rbcommons.com/s/twitter/r/3383>`_\n\n* Permits creation of StatsDB in a directory that does not yet exist.\n  `RB #3384 <https://rbcommons.com/s/twitter/r/3384>`_\n\n* Don\'t skip writing <artifact>s to ivy.xml even if there\'s only one.\n  `RB #3388 <https://rbcommons.com/s/twitter/r/3388>`_\n\n* Add and use an invalidation-local use_cache setting in IvyTaskMixin\n  `RB #3386 <https://rbcommons.com/s/twitter/r/3386>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Enable releasing the scalajs plugin\n  `RB #3340 <https://rbcommons.com/s/twitter/r/3340>`_\n\n* Allow failover for remote cache\n  `RB #3374 <https://rbcommons.com/s/twitter/r/3374>`_\n\n* Enable local caching by default, but disable within pantsbuild/pants.\n  `RB #3391 <https://rbcommons.com/s/twitter/r/3391>`_\n\n* Improved task implementation version\n  `RB #3331 <https://rbcommons.com/s/twitter/r/3331>`_\n  `RB #3381 <https://rbcommons.com/s/twitter/r/3381>`_\n\n* Multiple dependency_managements with multiple ivy resolves.\n  `RB #3336 <https://rbcommons.com/s/twitter/r/3336>`_\n  `RB #3367 <https://rbcommons.com/s/twitter/r/3367>`_\n\n* A managed_jar_libraries factory to reduce 3rdparty duplication.\n  `RB #3372 <https://rbcommons.com/s/twitter/r/3372>`_\n\n* Add support for go_thrift_library().\n  `RB #3353 <https://rbcommons.com/s/twitter/r/3353>`_\n  `RB #3365 <https://rbcommons.com/s/twitter/r/3365>`_\n\nRefactoring, Improvements, and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Add a command line option to turn off prompting before publishing\n  `RB #3387 <https://rbcommons.com/s/twitter/r/3387>`_\n\n* Update help message for failed publishing\n  `RB #3385 <https://rbcommons.com/s/twitter/r/3385>`_\n\n* Add is_synthetic in pants export\n  `RB #3239 <https://rbcommons.com/s/twitter/r/3239>`_\n\n* BuildFile refactoring: rename scan_project_tree_build_files to scan_build_files, get_project_tree_build_files_family to get_build_files_family\n  `RB #3382 <https://rbcommons.com/s/twitter/r/3382>`_\n\n* BuildFile refactoring: add more constraints to BuildFile constructor\n  `RB #3376 <https://rbcommons.com/s/twitter/r/3376>`_\n\n* BuildFile refactoring: remove usages and deprecate of BuildFile\'s family, ancestors, siblings and descendants methods\n  `RB #3368 <https://rbcommons.com/s/twitter/r/3368>`_\n\n* build_file_alias Perf Improvement: Move class declaration out of method target_macro\n  `RB #3361 <https://rbcommons.com/s/twitter/r/3361>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Eager execution and fully declarative dependencies\n  `RB #3339 <https://rbcommons.com/s/twitter/r/3339>`_\n\n\n0.0.69 (01/22/2016)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release contains the new `managed_dependencies()` target which\nallows you to pin the versions of transitive dependencies on jvm\nartifacts.  This is equivalent to the `<dependencyManagement>`\nfeature in Maven.\n\nBugfixes\n~~~~~~~~\n\n* Revert "Add RecursiveVersion and tests"\n  `RB #3331 <https://rbcommons.com/s/twitter/r/3331>`_\n  `RB #3351 <https://rbcommons.com/s/twitter/r/3351>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* First pass at dependency management implementation.\n  `RB #3336 <https://rbcommons.com/s/twitter/r/3336>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* SimpleCodegenTask: Add copy_target_attributes\n  `RB #3352 <https://rbcommons.com/s/twitter/r/3352>`_\n\n* Make more glob usages lazy; Pass FilesetWithSpec through source field validation, Make BundleProps.filemap lazy\n  `RB #3344 <https://rbcommons.com/s/twitter/r/3344>`_\n\n* Update the docs for the ./pants bash-completion script\n  `RB #3349 <https://rbcommons.com/s/twitter/r/3349>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* [engine] Move dependencies onto configuration\n  `RB #3316 <https://rbcommons.com/s/twitter/r/3316>`_\n\n0.0.68 (01/15/2016)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release concludes the deprecation cycle for backend/core,\nwhich has been removed.  It also simplifies the output directories\nfor internal and external jars when creating jvm bundles.\n\nAPI Changes\n~~~~~~~~~~~\n\n* bundle_create cleanup: merge internal-libs and libs\n  `RB #3261 <https://rbcommons.com/s/twitter/r/3261>`_\n  `RB #3329 <https://rbcommons.com/s/twitter/r/3329>`_\n\n* Get rid of backend/authentication.\n  `RB #3335 <https://rbcommons.com/s/twitter/r/3335>`_\n\n* Kill the build.manual annotation and the old source_roots.py.\n  `RB #3333 <https://rbcommons.com/s/twitter/r/3333>`_\n\n* Remove backend core.\n  `RB #3324 <https://rbcommons.com/s/twitter/r/3324>`_\n\n* Add a method call to allow adding a new goal to jvm_prep_command in a custom plugin\n  `RB #3325 <https://rbcommons.com/s/twitter/r/3325>`_\n\n* add --jvm-distributions-{min,max}imum-version options\n  `Issue #2396 <https://github.com/pantsbuild/pants/issues/2396>`_\n  `RB #3310 <https://rbcommons.com/s/twitter/r/3310>`_\n\nBugfixes\n~~~~~~~~\n\n* Bug fix: use target.id as bundle prefix to avoid conflict from basenames\n  `RB #3119 <https://rbcommons.com/s/twitter/r/3119>`_\n  `RB #3250 <https://rbcommons.com/s/twitter/r/3250>`_\n  `RB #3272 <https://rbcommons.com/s/twitter/r/3272>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Support `go test` blackbox tests.\n  `RB #3327 <https://rbcommons.com/s/twitter/r/3327>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Group classpath products by their targets\n  `RB #3329 <https://rbcommons.com/s/twitter/r/3329>`_\n  `RB #3338 <https://rbcommons.com/s/twitter/r/3338>`_\n\n* Improve test.pytest failure when coverage is enabled.\n  `RB #3334 <https://rbcommons.com/s/twitter/r/3334>`_\n\n* Add RecursiveVersion and tests\n  `RB #3331 <https://rbcommons.com/s/twitter/r/3331>`_\n\n* Bump the default Go distribution to 1.5.3.\n  `RB #3337 <https://rbcommons.com/s/twitter/r/3337>`_\n\n* Fixup links in `Test{Parallel,Serial}`.\n  `RB #3326 <https://rbcommons.com/s/twitter/r/3326>`_\n\n* Follow-up options/documentation changes after scala removed from BUILD.tools\n  `RB #3302 <https://rbcommons.com/s/twitter/r/3302>`_\n\n0.0.67 (01/08/2016)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release brings an upgrade to pex 1.1.2 for faster python chroot\ngeneration as well as bug fixes that get `./pants repl` working for\nscala 2.11 and `./pants test` now handling exceptions in junit\n`@BeforeClass` methods.\n\nThere is also a glimpse into the future where a pants daemon awaits.\nTry it out by adding `--enable-pantsd` to your command line - run times\nare 100ms or so faster for many operations.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Bump pex version pinning to 1.1.2.\n  `RB #3319 <https://rbcommons.com/s/twitter/r/3319>`_\n\n* extend --use-old-naming-style deprecation\n  `RB #3300 <https://rbcommons.com/s/twitter/r/3300>`_\n  `RB #3309 <https://rbcommons.com/s/twitter/r/3309>`_\n\n* Add target id to export\n  `RB #3291 <https://rbcommons.com/s/twitter/r/3291>`_\n\n* Bump junit-runner version\n  `RB #3295 <https://rbcommons.com/s/twitter/r/3295>`_\n\n* Flatten stable classpath for bundle\n  `RB #3261 <https://rbcommons.com/s/twitter/r/3261>`_\n\nBugfixes\n~~~~~~~~\n\n* Turn on redirects when retrieving a URL in the fetcher API\n  `RB #3275 <https://rbcommons.com/s/twitter/r/3275>`_\n  `RB #3317 <https://rbcommons.com/s/twitter/r/3317>`_\n\n* Remove jline dep for scala 2.11 repl\n  `RB #3318 <https://rbcommons.com/s/twitter/r/3318>`_\n\n* Start the timeout *after* the process is spawned, drop the mutable process handler variable\n  `RB #3202 <https://rbcommons.com/s/twitter/r/3202>`_\n\n* Fix exception in test mechanism in case of exception in @BeforeClass method.\n  `RB #3293 <https://rbcommons.com/s/twitter/r/3293>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* New implementation of builddict/reference generation.\n  `RB #3315 <https://rbcommons.com/s/twitter/r/3315>`_\n\n* Save details on exceptions encountered to a file\n  `RB #3289 <https://rbcommons.com/s/twitter/r/3289>`_\n\n* [pantsd] Implement PantsRunner->[LocalPantsRunner,RemotePantsRunner] et al.\n  `RB #3286 <https://rbcommons.com/s/twitter/r/3286>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Logs the SUCCESS/FAILURE/ABORTED status of each workunit with stats in run_tracker.\n  `RB #3307 <https://rbcommons.com/s/twitter/r/3307>`_\n\n* Simplify build dict/reference information extraction.\n  `RB #3301 <https://rbcommons.com/s/twitter/r/3301>`_\n\n* Move Sources to a target\'s configurations, and add subclasses for each language\n  `RB #3274 <https://rbcommons.com/s/twitter/r/3274>`_\n\n* Convert loose directories in bundle classpath into jars\n  `RB #3297 <https://rbcommons.com/s/twitter/r/3297>`_\n\n* Update pinger timeout in test_pinger_timeout_config and test_global_pinger_memo.\n  `RB #3292 <https://rbcommons.com/s/twitter/r/3292>`_\n\n* Add sanity check to test_cache_read_from\n  `RB #3284 <https://rbcommons.com/s/twitter/r/3284>`_\n  `RB #3299 <https://rbcommons.com/s/twitter/r/3299>`_\n\n* Adding sanity check for locale setting\n  `RB #3296 <https://rbcommons.com/s/twitter/r/3296>`_\n\n* Create a complete product graph for the experimentation engine, and use it to validate inputs\n  `Issue #2525 <https://github.com/pantsbuild/pants/issues/2525>`_\n  `RB #3245 <https://rbcommons.com/s/twitter/r/3245>`_\n\n* Add Unit Test for artifact caching to replace test_scalastyle_cached in test_scalastyle_integration.py, and test_checkstyle_cached in test_checkstyle_integration.py.\n  `RB #3284 <https://rbcommons.com/s/twitter/r/3284>`_\n\n0.0.66 (01/02/2016)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release comes after a long and relatively quiet holiday break, but it represents a significant\nmilestone towards pants 1.0.0: it is no longer necessary to explicitly configure any tool versions\n(as was usually done with BUILD.tools); all tools, including scalac, have default classpaths.\n\nThis release also includes beta support for scala.js via the scalajs contrib module.\n\nHappy Holidays!\n\n\nAPI Changes\n~~~~~~~~~~~\n\n* Have SourcesField handle the calculation of SourceRoots\n  `RB #3230 <https://rbcommons.com/s/twitter/r/3230>`_\n\n* Remove the need to specify scala tools in BUILD.tools\n  `RB #3225 <https://rbcommons.com/s/twitter/r/3225>`_\n\n* Explicitly track when synthetic targets are injected.\n  `RB #3225 <https://rbcommons.com/s/twitter/r/3225>`_\n  `RB #3277 <https://rbcommons.com/s/twitter/r/3277>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix declaration of source scalac-plugins\n  `RB #3285 <https://rbcommons.com/s/twitter/r/3285>`_\n\n* Work around the fact that antlr3 is not currently available on pypi\n  `RB #3282 <https://rbcommons.com/s/twitter/r/3282>`_\n\n* Avoid ValueError exception from a reporting thread on shutdown\n  `RB #3278 <https://rbcommons.com/s/twitter/r/3278>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Preliminary support for scala.js\n  `RB #2453 <https://rbcommons.com/s/twitter/r/2453>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Convert binary_util to use fetcher like the ivy bootstrapper\n  `RB #3275 <https://rbcommons.com/s/twitter/r/3275>`_\n\n\n0.0.65 (12/18/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release concludes the deprecation cycle of the following items, now removed:\n\n* `--excludes` to `DuplicateDetector`.  Use `--exclude-files`, `--exclude-patterns`,\n  or `--exclude-dirs` instead.\n\n* `timeout=0` on test targets.  To use the default timeout, remove the `timeout`\n  parameter from your test target.\n\n\nAPI Changes\n~~~~~~~~~~~\n\n* prefer explicit jvm locations over internal heuristics\n  `RB #3231 <https://rbcommons.com/s/twitter/r/3231>`_\n\n* A graph_info backend.\n  `RB #3256 <https://rbcommons.com/s/twitter/r/3256>`_\n\n* Move registration of basic build file constructs.\n  `RB #3246 <https://rbcommons.com/s/twitter/r/3246>`_\n\nBugfixes\n~~~~~~~~\n\n* Fixup `GoFetch` to respect transitive injections.\n  `RB #3270 <https://rbcommons.com/s/twitter/r/3270>`_\n\n* Make jvm_compile\'s subsystem dependencies global to fix ignored options\n  `Issue #2739 <https://github.com/pantsbuild/pants/issues/2739>`_\n  `RB #3238 <https://rbcommons.com/s/twitter/r/3238>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Go Checkstyle: run checkstyle, add tests, fix examples\n  `RB #3223 <https://rbcommons.com/s/twitter/r/3223>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Go: Allow users to specify known import prefixes for import paths.\n  `RB #3120 <https://rbcommons.com/s/twitter/r/3120>`_\n\n* Explains how append-style arguments work in pants\n  `RB #3268 <https://rbcommons.com/s/twitter/r/3268>`_\n\n* Allow specification of extra env vars for junit_tests runs.\n  `RB #3140 <https://rbcommons.com/s/twitter/r/3140>`_\n  `RB #3267 <https://rbcommons.com/s/twitter/r/3267>`_\n\n* Refactor help scope computation logic.\n  `RB #3264 <https://rbcommons.com/s/twitter/r/3264>`_\n\n* Make it easy for tests to use the "real" python interpreter cache.\n  `RB #3257 <https://rbcommons.com/s/twitter/r/3257>`_\n\n* Pass `--confcutdir` to py.test invocation to restrict `conftest.py` scanning to paths in the pants buildroot.\n  `RB #3258 <https://rbcommons.com/s/twitter/r/3258>`_\n\n* Remove stale `:all` alias used by plugin integration test\n  `RB #3254 <https://rbcommons.com/s/twitter/r/3254>`_\n\n* Move conflicting python test targets to testprojects.\n  `RB #3252 <https://rbcommons.com/s/twitter/r/3252>`_\n\n* Add convenience script for running unit tests, update docs\n  `RB #3233 <https://rbcommons.com/s/twitter/r/3233>`_\n  `RB #3248 <https://rbcommons.com/s/twitter/r/3248>`_\n\n0.0.64 (12/11/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release concludes the deprecation cycle of the following items, now removed:\n\n* `dependencies` and `python_test_suite` target aliases\n  BUILD file authors should use `target` instead.\n\n* `pants.backend.core.tasks.{Task,ConsoleTask,ReplTaskMixin}`\n  Custom task authors can update imports to the new homes in `pants.task`\n\n* The `test.junit` `--no-suppress-output` option\n  You now specify `--output-mode=ALL` in the `test.junit` scope instead.\n\nThis release also fixes issues using the Scala REPL via `./pants repl` for very\nlarge classpaths.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Upgrade to junit-runner 1.0.0.\n  `RB #3232 <https://rbcommons.com/s/twitter/r/3232>`_\n\n* Remove deprecated `-suppress-output` flag.\n  `RB #3229 <https://rbcommons.com/s/twitter/r/3229>`_\n\n* Kill `dependencies`, `python_test_suite` and old task base class aliases.\n  `RB #3228 <https://rbcommons.com/s/twitter/r/3228>`_\n\nBugfixes\n~~~~~~~~\n\n* Fixup the `NodePreinstalledModuleResolver`.\n  `RB #3240 <https://rbcommons.com/s/twitter/r/3240>`_\n\n* Prepend \'//\' to Address.spec when the spec_path is empty.\n  `RB #3234 <https://rbcommons.com/s/twitter/r/3234>`_\n\n* Fix problem with too long classpath while starting scala repl: python part\n  `RB #3195 <https://rbcommons.com/s/twitter/r/3195>`_\n\n* Fix problem with too long classpath while starting scala repl: java part\n  `RB #3194 <https://rbcommons.com/s/twitter/r/3194>`_\n\n* Fixing instrumentation classpath mutation to support multiple targets and entries.\n  `RB #3108 <https://rbcommons.com/s/twitter/r/3108>`_\n\n* Use target.id to create the stable classpath for bundle and export-classpath\n  `RB #3211 <https://rbcommons.com/s/twitter/r/3211>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add an option to write build stats into a local json file.\n  `RB #3218 <https://rbcommons.com/s/twitter/r/3218>`_\n\n* Make incremental compile optional for zinc\n  `RB #3226 <https://rbcommons.com/s/twitter/r/3226>`_\n\n* Create a test timeout_maximum flag so that we can prevent people from setting an insanely huge timeout\n  `RB #3219 <https://rbcommons.com/s/twitter/r/3219>`_\n\n* Add a jvm_prep_command that can work in compile, test, and binary goals\n  `RB #3209 <https://rbcommons.com/s/twitter/r/3209>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* A docgen backend.\n  `RB #3242 <https://rbcommons.com/s/twitter/r/3242>`_\n\n* Add formatting of choices to help output\n  `RB #3241 <https://rbcommons.com/s/twitter/r/3241>`_\n\n* Remove test target aliases for pants\' tests\n  `RB #3233 <https://rbcommons.com/s/twitter/r/3233>`_\n\n* Move resources() and prep_command() out of backend/core.\n  `RB #3235 <https://rbcommons.com/s/twitter/r/3235>`_\n\n* [pantsd] Implement PantsDaemon et al.\n  `RB #3224 <https://rbcommons.com/s/twitter/r/3224>`_\n\n* New implementation of `./pants targets`.\n  `RB #3214 <https://rbcommons.com/s/twitter/r/3214>`_\n\n* Allow alternate_target_roots to specify an empty collection\n  `RB #3216 <https://rbcommons.com/s/twitter/r/3216>`_\n\n* Remove group task and register zinc_compile directly\n  `RB #3215 <https://rbcommons.com/s/twitter/r/3215>`_\n\n* Bump the default Go distribution to 1.5.2.\n  `RB #3208 <https://rbcommons.com/s/twitter/r/3208>`_\n\n0.0.63 (12/04/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release contains a few deprecations and refactorings to help prepare for 1.0.0. It\nalso includes the first release of the new Haskell module contributed by Gabriel Gonzalez.\nThanks Gabriel!\n\nAPI Changes\n~~~~~~~~~~~\n\n* Deprecate calling with_description() when registering a task.\n  `RB #3207 <https://rbcommons.com/s/twitter/r/3207>`_\n\n* Create a core_tasks top-level dir.\n  `RB #3197 <https://rbcommons.com/s/twitter/r/3197>`_\n\n* Move more tasks to core_tasks.\n  `RB #3199 <https://rbcommons.com/s/twitter/r/3199>`_\n\n* Move remaining core tasks to core_tasks.\n  `RB #3204 <https://rbcommons.com/s/twitter/r/3204>`_\n\n* Upgrade PEX to 1.1.1\n  `RB #3200 <https://rbcommons.com/s/twitter/r/3200>`_\n\n* Properly deprecate the Dependencies alias.\n  `RB #3196 <https://rbcommons.com/s/twitter/r/3196>`_\n\n* Move the rwbuf code under util/.\n  `RB #3193 <https://rbcommons.com/s/twitter/r/3193>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix cache_setup.py so build doesn\'t fail if configured cache is empty.\n  `RB #3142 <https://rbcommons.com/s/twitter/r/3142>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add Haskell plugin to `contrib/release_packages.sh`; now included in the release!\n  `RB #3198 <https://rbcommons.com/s/twitter/r/3198>`_\n\n* Refine cache stats: distinguish legit misses from miss errors\n  `RB #3190 <https://rbcommons.com/s/twitter/r/3190>`_\n\n* [pantsd] Initial implementation of the pants nailgun service.\n  `RB #3171 <https://rbcommons.com/s/twitter/r/3171>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Remove references to jmake\n  `RB #3210 <https://rbcommons.com/s/twitter/r/3210>`_\n\n* Deprecate exception.message usages\n  `RB #3201 <https://rbcommons.com/s/twitter/r/3201>`_\n\n* Make monolithic jars produced by bundle/binary slimmer\n  `RB #3133 <https://rbcommons.com/s/twitter/r/3133>`_\n\n\n0.0.62 (11/30/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release is primarily small bug fixes and minor improvements.\n\nThe following modules have been moved, with their old locations now deprecated:\n\n* `MutexTaskMixin` and `ReplTaskMixin` from `pants.backend.core` -> `pants.task`\n\nAPI Changes\n~~~~~~~~~~~\n\n* Move the test runner task mixin out of backend/core.\n  `RB #3181 <https://rbcommons.com/s/twitter/r/3181>`_\n\n* Move two generic task mixins out of backend/core.\n  `RB #3176 <https://rbcommons.com/s/twitter/r/3176>`_\n\nBugfixes\n~~~~~~~~\n\n* Jvm compile counter should increment for double check cache hits\n  `RB #3188 <https://rbcommons.com/s/twitter/r/3188>`_\n\n* Exit with non-zero status when help fails\n  `RB #3184 <https://rbcommons.com/s/twitter/r/3184>`_\n\n* When a pytest errors rather than failures, make that target also show up in TestTaskFailedError\n  `Issue #2623 <https://github.com/pantsbuild/pants/issues/2623>`_\n  `RB #3175 <https://rbcommons.com/s/twitter/r/3175>`_\n\n* Add the -no-header argument to jaxb generator to give deterministic output\n  `RB #3179 <https://rbcommons.com/s/twitter/r/3179>`_\n\n* Fix bug that recognized "C" as a remote package.\n  `RB #3170 <https://rbcommons.com/s/twitter/r/3170>`_\n\n* Fix jvm_compile product publishing for cached builds\n  `RB #3161 <https://rbcommons.com/s/twitter/r/3161>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Minimal Haskell plugin for `pants`\n  `RB #2975 <https://rbcommons.com/s/twitter/r/2975>`_\n\n* Option to specify stdout from tests to ALL, NONE or FAILURE_ONLY: python part\n  `RB #3165 <https://rbcommons.com/s/twitter/r/3165>`_\n  `RB #3145 <https://rbcommons.com/s/twitter/r/3145>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Update the dependencies returned from ivy to be in a stable (sorted) order.\n  `RB #3168 <https://rbcommons.com/s/twitter/r/3168>`_\n\n* Refactor detect_duplicates with some user friendly features\n  `RB #3178 <https://rbcommons.com/s/twitter/r/3178>`_\n\n* Updating some documentation for pants.ini Update some settings in pants.ini which used `=` instead of `:`\n  `RB #3189 <https://rbcommons.com/s/twitter/r/3189>`_\n\n* Add the compile.zinc options to the options reference\n  `RB #3186 <https://rbcommons.com/s/twitter/r/3186>`_\n\n* include_dependees no longer an optional argument.\n  `RB #1997 <https://rbcommons.com/s/twitter/r/1997>`_\n\n* Relocate task tests from tests/python/pants_test/task/ to the appropriate backend\n  `RB #3183 <https://rbcommons.com/s/twitter/r/3183>`_\n\n* Move tests corresponding to pants/task code.\n  `RB #3182 <https://rbcommons.com/s/twitter/r/3182>`_\n\n* Add error message when a JDK is not installed, add minimum requirements to documentation.\n  `RB #3136 <https://rbcommons.com/s/twitter/r/3136>`_\n\n0.0.61 (11/23/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is a hotfix release to fix two regressions in 0.0.60.  It also happens to\ninclude a small UX improvement for the console output of isolated compiles.\n\nBugfixes\n~~~~~~~~\n\n* Make sure the deprecated pants.backend.core.tasks.task module is bundled.\n  `RB #3164 <https://rbcommons.com/s/twitter/r/3164>`_\n\n* Revert "Isolate .pex dir"\n  `Issue #2610 <https://github.com/pantsbuild/pants/issues/2610>`_\n  `RB #3135 <https://rbcommons.com/s/twitter/r/3135>`_\n  `RB #3163 <https://rbcommons.com/s/twitter/r/3163>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* During a jvm compile, include a running count in the printed log.\n  `RB #3153 <https://rbcommons.com/s/twitter/r/3153>`_\n\n0.0.60 (11/21/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release is primarily small bug fixes and minor improvements.  It also\nremoves several deprecated options and methods:\n\n* `ReverseDepmap.type`.\n* `pants.backend.maven_layout`.\n* `Depmap.path_to`.\n* `SourceRoot.find`.\n* `SourceRoot.find_by_path`.\n* `pants.bin.goal_runner.SourceRootBootstrapper` and its option `[goals] bootstrap_buildfiles`.\n* `pants.build_graph.target._set_no_cache`.\n\nThe following modules have been moved, with their old locations now deprecated:\n\n* `pants.backend.core.tasks.console_task` -> `pants.task.console_task`.\n* `pants.backend.core.tasks.task` -> `pants.task.task`.\n\n\nAPI Changes\n~~~~~~~~~~~\n\n* Move ConsoleTask to pants/task.\n  `RB #3157 <https://rbcommons.com/s/twitter/r/3157>`_\n\n* Move task.py out of backend/core.\n  `RB #3130 <https://rbcommons.com/s/twitter/r/3130>`_\n\n\nBugfixes\n~~~~~~~~\n\n* Add a helper staticmethod `closure()` to `BuildGraph`.\n  `RB #3160 <https://rbcommons.com/s/twitter/r/3160>`_\n\n* Fix a bug preventing re-upload artifacts that encountered read-errors\n  `RB #1361 <https://rbcommons.com/s/twitter/r/1361>`_\n  `RB #3141 <https://rbcommons.com/s/twitter/r/3141>`_\n\n* Fix `gopkg.in` fetcher to handle subpackages.\n  `RB #3139 <https://rbcommons.com/s/twitter/r/3139>`_\n\n* Update scalac_plugin_args call to the new option name.\n  `RB #3132 <https://rbcommons.com/s/twitter/r/3132>`_\n\n* Fix cases where transitivity is required despite strict_deps; enable within the repo for Java\n  `RB #3125 <https://rbcommons.com/s/twitter/r/3125>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Isolate .pex dir\n  `RB #3135 <https://rbcommons.com/s/twitter/r/3135>`_\n\n* Group cache hits/misses by their task names\n  `RB #3137 <https://rbcommons.com/s/twitter/r/3137>`_\n\n* Add back the --[no-]color flag as deprecated.\n  `RB #3150 <https://rbcommons.com/s/twitter/r/3150>`_\n\n* Add support for extra_jvm_options to java_tests\n  `Issue #2383 <https://github.com/pantsbuild/pants/issues/2383>`_\n  `RB #3140 <https://rbcommons.com/s/twitter/r/3140>`_\n\n* Removed Wire 2.0 support.  Update default Wire library to 1.8.0\n  `RB #3124 <https://rbcommons.com/s/twitter/r/3124>`_\n\n* Remove legacy code in wire_gen and protobuf_gen designed for global codegen strategy\n  `RB #3123 <https://rbcommons.com/s/twitter/r/3123>`_\n\n0.0.59 (11/15/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is a hotfix release that pins an internal pants python requirement to prevent failures running\n`./pants test` against `python_tests` targets.\nSee more details here: http://github.com/pantsbuild/pants/issues#issue/2566\n\nBugfixes\n~~~~~~~~\n\n* Fixup floating `pytest-timeout` dep.\n  `RB #3126 <https://rbcommons.com/s/twitter/r/3126>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Allow bundle to run for all targets, rather than just target roots\n  `RB #3119 <https://rbcommons.com/s/twitter/r/3119>`_\n\n* Allow per-jvm-target configuration of fatal warnings\n  `RB #3080 <https://rbcommons.com/s/twitter/r/3080>`_\n\n* Add options to repro and expand user on output file\n  `RB #3109 <https://rbcommons.com/s/twitter/r/3109>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Remove use of twitter.common.util.topological_sort in SortTargets\n  `RB #3121 <https://rbcommons.com/s/twitter/r/3121>`_\n\n* Delay many re.compile calls.\n  `RB #3122 <https://rbcommons.com/s/twitter/r/3122>`_\n\n0.0.58 (11/13/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release completes the deprecated cycle for two options and removes them:\n\n* `--infer-test-from-siblings` for `eclipse` and `idea` goals\n* `--strategy` for various code generation tasks like protoc\n\nTwo existing tasks not installed by default have been moved from `pantsbuild.pants` to\n`pantsbuild.pants.contrib.python.checks`.  You can add `pantsbuild.pants.contrib.python.checks` to\nyour `plugins` list in `pants.ini` to get these tasks installed and start verifying your python\nBUILD deps and to check that your python code conforms to pep8 and various other lints.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove `--strategy` `--infer-test-from-siblings`.\n  `RB #3116 <https://rbcommons.com/s/twitter/r/3116>`_\n\n* Extract `python-eval` and `pythonstyle` to plugin.\n  `RB #3114 <https://rbcommons.com/s/twitter/r/3114>`_\n\nBugfixes\n~~~~~~~~\n\n* Do not invalidate jvm targets in zinc for resource dependencies change\n  `RB #3106 <https://rbcommons.com/s/twitter/r/3106>`_\n\n* Updated junit-runner to version 0.0.12\n  `RB #3092 <https://rbcommons.com/s/twitter/r/3092>`_\n\n* Fixing malformatted xml report names from junit runner.\n  `RB #3090 <https://rbcommons.com/s/twitter/r/3090>`_\n  `RB #3103 <https://rbcommons.com/s/twitter/r/3103>`_\n\n* Clean up corrupted local cache for errors that are not retryable\n  `RB #3045 <https://rbcommons.com/s/twitter/r/3045>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add `pants_requirement()` for plugin authors.\n  `RB #3112 <https://rbcommons.com/s/twitter/r/3112>`_\n\n* Allow for zinc analysis portability with the workdir located either inside or outside of the buildroot\n  `RB #3083 <https://rbcommons.com/s/twitter/r/3083>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Fixup invoking.md to refer to `--config-override`.\n  `RB #3115 <https://rbcommons.com/s/twitter/r/3115>`_\n\n* docfix: pants.ini must exist with that name. Not some other name.\n  `RB #3110 <https://rbcommons.com/s/twitter/r/3110>`_\n\n* Inline twitter.common.config.Properties and remove t.c.config dep\n  `RB #3113 <https://rbcommons.com/s/twitter/r/3113>`_\n\n* Run coverage instrumentation once for each target, streamline command line parameters\n  `RB #3107 <https://rbcommons.com/s/twitter/r/3107>`_\n\n* Break out core runtime logic into a PantsRunner\n  `RB #3054 <https://rbcommons.com/s/twitter/r/3054>`_\n\n* Improve exception handling for bad option values, such as when PANTS_CONFIG_OVERRIDE="pants.ini" exists in the environment.\n  `RB #3087 <https://rbcommons.com/s/twitter/r/3087>`_\n\n0.0.57 (11/09/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is a hotfix release that fixes a bug preventing repos using `plugins` in the `DEFAULT` section\nof `pants.ini` from upgrading to `0.0.56`.\n\nAPI Changes\n~~~~~~~~~~~\n\n* API Change: Move graph walking out of classpath_(util|products)\n  `RB #3036 <https://rbcommons.com/s/twitter/r/3036>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix bug when analysis file is corrupt or missing during an incremental compile\n  `RB #3101 <https://rbcommons.com/s/twitter/r/3101>`_\n\n* Update the option types for protobuf-gen to be list types, since they are all advanced.\n  `RB #3098 <https://rbcommons.com/s/twitter/r/3098>`_\n  `RB #3100 <https://rbcommons.com/s/twitter/r/3100>`_\n\n* Fix plugin option references in leaves.\n  `RB #3098 <https://rbcommons.com/s/twitter/r/3098>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Seed the haskell contrib with `StackDistribution`.\n  `RB #2975 <https://rbcommons.com/s/twitter/r/2975>`_\n  `RB #3095 <https://rbcommons.com/s/twitter/r/3095>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Better error message for classpath entries outside the working directory\n  `RB #3099 <https://rbcommons.com/s/twitter/r/3099>`_\n\n0.0.56 (11/06/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release squashes a bunch of bugs in various area of the codebase, and improves the performance\nof both the options and reporting systems.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove support for `type_` in jar_dependency. It has been superceded by the \'ext\' argument\n  `Issue #2442 <https://github.com/pantsbuild/pants/issues/2442>`_\n  `RB #3038 <https://rbcommons.com/s/twitter/r/3038>`_\n\n* Prevent option shadowing, and deprecate/remove some shadowed options.\n  `RB #3035 <https://rbcommons.com/s/twitter/r/3035>`_\n\n* Synthetic jars always created when invoking the JVM (Argument list too long revisited)\n  `RB #2672 <https://rbcommons.com/s/twitter/r/2672>`_\n  `RB #3003 <https://rbcommons.com/s/twitter/r/3003>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* The ./pants junit runner now works with Cucumber scenarios.\n  `RB #3090 <https://rbcommons.com/s/twitter/r/3090>`_\n\n* New compile task to publish symlinks to jars with class files to pants_distdir\n  `RB #3059 <https://rbcommons.com/s/twitter/r/3059>`_\n\n* Add new `--fail-floating` option to `GoBuildgen`.\n  `RB #3073 <https://rbcommons.com/s/twitter/r/3073>`_\n\n* Add `go` and `go-env` goals.\n  `RB #3060 <https://rbcommons.com/s/twitter/r/3060>`_\n\n* Adding NpmRun and NpmTest\n  `RB #3048 <https://rbcommons.com/s/twitter/r/3048>`_\n\n* Add --compile-zinc-debug-symbols option\n  `RB #3013 <https://rbcommons.com/s/twitter/r/3013>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix test_multiple_source_roots, ignore ordering.\n  `RB #3089 <https://rbcommons.com/s/twitter/r/3089>`_\n\n* Change JarPublish.fingerprint to JarPublish.entry_fingerprint to ensure task fingerprint can change\n  `RB #3078 <https://rbcommons.com/s/twitter/r/3078>`_\n\n* Deprecate/remove broken path-to option in depmap\n  `RB #3079 <https://rbcommons.com/s/twitter/r/3079>`_\n\n* Fix `buildgen.go` to be non-lossy for remote revs.\n  `RB #3077 <https://rbcommons.com/s/twitter/r/3077>`_\n\n* Fixup NailgunClient-related OSX CI break\n  `RB #3069 <https://rbcommons.com/s/twitter/r/3069>`_\n\n* Fix bench goal, include integration test\n  `Issue #2303 <https://github.com/pantsbuild/pants/issues/2303>`_\n  `RB #3072 <https://rbcommons.com/s/twitter/r/3072>`_\n\n* Fix missing newline at end of pants output.\n  `RB #3019 <https://rbcommons.com/s/twitter/r/3019>`_\n  `RB #3063 <https://rbcommons.com/s/twitter/r/3063>`_\n\n* For prepare.services, avoid empty classpath entries by only selecting jvm targets that have services defined\n  `RB #3058 <https://rbcommons.com/s/twitter/r/3058>`_\n\n* Safeguard against stale ProcessManager metadata re-use.\n  `RB #3047 <https://rbcommons.com/s/twitter/r/3047>`_\n\n* Fix test timeout implementation by adding abort handlers\n  `RB #2979 <https://rbcommons.com/s/twitter/r/2979>`_\n\n* Allow for sourceless codegen based purely on target parameters\n  `RB #3044 <https://rbcommons.com/s/twitter/r/3044>`_\n\n* Fix a copy-paste error in migrate_config.py.\n  `RB #3039 <https://rbcommons.com/s/twitter/r/3039>`_\n\n* Fix issue with trailing newlines in Python checkstyle\n  `RB #3033 <https://rbcommons.com/s/twitter/r/3033>`_\n\n* Make profiling cover the init sequence too.\n  `RB #3022 <https://rbcommons.com/s/twitter/r/3022>`_\n\n* Unshade org.pantsbuild.junit.annotation so that @TestParallel works\n  `RB #3012 <https://rbcommons.com/s/twitter/r/3012>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Remove pytest helpers where unittest will do.\n  `RB #3091 <https://rbcommons.com/s/twitter/r/3091>`_\n\n* Remove a hack in IvyResolve.\n  `Issue #2177 <https://github.com/pantsbuild/pants/issues/2177>`_\n  `RB #3088 <https://rbcommons.com/s/twitter/r/3088>`_\n\n* Get rid of argparse usage entirely.\n  `RB #3074 <https://rbcommons.com/s/twitter/r/3074>`_\n\n* Additional test case for changed goal\n  `RB #2589 <https://rbcommons.com/s/twitter/r/2589>`_\n  `RB #2660 <https://rbcommons.com/s/twitter/r/2660>`_\n\n* Upgrade to RBTools 0.7.5.\n  `RB #3076 <https://rbcommons.com/s/twitter/r/3076>`_\n\n* Improve handling of -v, -V, --version and --pants-version.\n  `RB #3071 <https://rbcommons.com/s/twitter/r/3071>`_\n\n* Turn off ng under OSX-CI like we do for linux.\n  `RB #3067 <https://rbcommons.com/s/twitter/r/3067>`_\n\n* Cache npm resolves in CI.\n  `RB #3065 <https://rbcommons.com/s/twitter/r/3065>`_\n\n* Improve incremental caching tests\n  `RB #3028 <https://rbcommons.com/s/twitter/r/3028>`_\n  `RB #3034 <https://rbcommons.com/s/twitter/r/3034>`_\n\n* Refactor the python checkstyle plugin system.\n  `RB #3061 <https://rbcommons.com/s/twitter/r/3061>`_\n\n* Better implementation of the reporting emitter thread.\n  `RB #3057 <https://rbcommons.com/s/twitter/r/3057>`_\n\n* Preparation to allow locating the workdir outside of the build root\n  `RB #3050 <https://rbcommons.com/s/twitter/r/3050>`_\n  `RB #3050 <https://rbcommons.com/s/twitter/r/3050>`_\n\n* Create the argparse.ArgParser instance only on demand.\n  `RB #3056 <https://rbcommons.com/s/twitter/r/3056>`_\n\n* Fix implementation of shallow copy on OptionValueContainer.\n  `RB #3041 <https://rbcommons.com/s/twitter/r/3041>`_\n\n* Defer argparse registration to the last possible moment.\n  `RB #3049 <https://rbcommons.com/s/twitter/r/3049>`_\n\n* Pave the way for server-side python nailgun components\n  `RB #3030 <https://rbcommons.com/s/twitter/r/3030>`_\n\n* Don\'t resolve node_remote_module targets by themselves and modify how REPL works\n  `RB #2997 <https://rbcommons.com/s/twitter/r/2997>`_\n\n* Remove mustache use from the reporting system.\n  `RB #3018 <https://rbcommons.com/s/twitter/r/3018>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* Add an engine/exp README.\n  `RB #3042 <https://rbcommons.com/s/twitter/r/3042>`_\n\n* Simplify and robustify `LocalMultiprocessEngine`.\n  `RB #3084 <https://rbcommons.com/s/twitter/r/3084>`_\n\n* Example of an additional planner that produces a Classpath for targets\n  `Issue #2484 <https://github.com/pantsbuild/pants/issues/2484>`_\n  `RB #3075 <https://rbcommons.com/s/twitter/r/3075>`_\n\n* Add fail-slow handling to `Engine`.\n  `RB #3040 <https://rbcommons.com/s/twitter/r/3040>`_\n\n* Cleanup a few scheduler warts.\n  `RB #3032 <https://rbcommons.com/s/twitter/r/3032>`_\n\n\n0.0.55 (10/23/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\nThis release has many experimental engine features, as well as general bug fixes and performance improvements.\n\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove the deprecated modules, `pants.base.address` and `pants.base.address_lookup_error`.\n\nNew Features\n~~~~~~~~~~~~\n\n* Add a --dependencies option to cloc.\n  `RB #3008 <https://rbcommons.com/s/twitter/r/3008>`_\n\n* Add native support for incremental caching, and use it in jvm_compile\n  `RB #2991 <https://rbcommons.com/s/twitter/r/2991>`_\n\n* A CountLinesOfCode task.\n  `RB #3005 <https://rbcommons.com/s/twitter/r/3005>`_\n\nBugfixes\n~~~~~~~~\n\n* Include JarDependency.excludes when creating cache_key. Add unittest.\n  `RB #3001 <https://rbcommons.com/s/twitter/r/3001>`_\n\n* Added junit.framework to excludes for shading\n  `RB #3017 <https://rbcommons.com/s/twitter/r/3017>`_\n\n* fix failure in test_global_pinger_memo\n  `RB #3007 <https://rbcommons.com/s/twitter/r/3007>`_\n\n* Handle case where only transitive dependencies have changed during an incremental build\n  `Issue #2446 <https://github.com/pantsbuild/pants/issues/2446>`_\n  `RB #3028 <https://rbcommons.com/s/twitter/r/3028>`_\n\nNew Engine Work\n~~~~~~~~~~~~~~~\n\n* Add support for config selectors in dep addresses.\n  `RB #3025 <https://rbcommons.com/s/twitter/r/3025>`_\n\n* Support Configurations extending one, merging N.\n  `RB #3023 <https://rbcommons.com/s/twitter/r/3023>`_\n\n* Refactor engine experiment module organization.\n  `RB #3004 <https://rbcommons.com/s/twitter/r/3004>`_\n\n* Implement a custom pickle for Serializables.\n  `RB #3002 <https://rbcommons.com/s/twitter/r/3002>`_\n\n* Introduce the new engine and two implementations.\n  `RB #3000 <https://rbcommons.com/s/twitter/r/3000>`_\n\n* Introduce the 1st cut at the new engine frontend.\n  `RB #2989 <https://rbcommons.com/s/twitter/r/2989>`_\n\n* Prepare the 1st test for the new engine front end.\n  `RB #2988 <https://rbcommons.com/s/twitter/r/2988>`_\n\n* Add a visualization tool for execution plans.\n  `RB #3010 <https://rbcommons.com/s/twitter/r/3010>`_\n\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Overwrite timing stat report files less frequently.\n  `RB #3021 <https://rbcommons.com/s/twitter/r/3021>`_\n\n* Make sure we emit the timing/stats epilog even for quiet tasks.\n  `RB #3019 <https://rbcommons.com/s/twitter/r/3019>`_\n\n* Add a fixed source root for the go_remote dir in contrib/go.\n  `RB #3027 <https://rbcommons.com/s/twitter/r/3027>`_\n\n* Restore Sources custom types per extension.\n  `RB #3010 <https://rbcommons.com/s/twitter/r/3010>`_\n  `RB #3011 <https://rbcommons.com/s/twitter/r/3011>`_\n\n* [coverage] Removing emma after its deprecation cycle.\n  `RB #3009 <https://rbcommons.com/s/twitter/r/3009>`_\n\n* Kill _JUnitRunner and move code to the JUnitRun task\n  `RB #2994 <https://rbcommons.com/s/twitter/r/2994>`_\n\n* Make \'list-owners\' faster by not instantiating already injected targets\n  `RB #2967 <https://rbcommons.com/s/twitter/r/2967>`_\n  `RB #2968 <https://rbcommons.com/s/twitter/r/2968>`_\n\n* Get rid of all bootstrap BUILD files in our repo.\n  `RB #2996 <https://rbcommons.com/s/twitter/r/2996>`_\n\n* Run python checkstyle only on invalidated targets.\n  `RB #2995 <https://rbcommons.com/s/twitter/r/2995>`_\n\n* Switch all internal code to use the new source roots mechanism.\n  `RB #2987 <https://rbcommons.com/s/twitter/r/2987>`_\n\n* Remove jmake and apt members from JvmCompile\n  `RB #2990 <https://rbcommons.com/s/twitter/r/2990>`_\n\n* Leverage fast_relpath in `BuildFileAddressMapper`.\n  `RB #2981 <https://rbcommons.com/s/twitter/r/2981>`_\n\n* Simplify fetcher regexes; doc the \'^\' assumption.\n  `RB #2980 <https://rbcommons.com/s/twitter/r/2980>`_\n\n* Remove the global codegen strategy from simple_codegen_task\n  `RB #2985 <https://rbcommons.com/s/twitter/r/2985>`_\n\n* Added an explanation to the docs re: who can be added to a review.\n  `RB #2983 <https://rbcommons.com/s/twitter/r/2983>`_\n\n0.0.54 (10/16/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release features several improvements to Go support and a refactored SourceRoot API, as well as several bug fixes and small refactors.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Move address.py/address_lookup_error.py from base to build_graph\n  `RB #2954 <https://rbcommons.com/s/twitter/r/2954>`_\n\n* Deprecate --infer-test-from-sibling argument to ide_gen.py.\n  `RB #2966 <https://rbcommons.com/s/twitter/r/2966>`_\n\n* Several deprecated methods and modules were removed:\n  `src/python/pants/base/target.py`\n  `src/python/pants/base/build_file_aliases.py`\n  `JarDependency._maybe_set_ext`\n  `JarDependency.exclude`\n  The `Repository` build file alias\n\nNew Features\n~~~~~~~~~~~~\n\n* Add support for golang.org/x remote libs.\n  `Issue #2378 <https://github.com/pantsbuild/pants/issues/2378>`_\n  `Issue #2379 <https://github.com/pantsbuild/pants/issues/2379>`_\n  `Issue #2378 <https://github.com/pantsbuild/pants/issues/2378>`_\n  `Issue #2379 <https://github.com/pantsbuild/pants/issues/2379>`_\n  `RB #2976 <https://rbcommons.com/s/twitter/r/2976>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix `buildgen.go --materialize` to act globally.\n  `RB #2977 <https://rbcommons.com/s/twitter/r/2977>`_\n\n* Fix `BuildFileAddressMapper.scan_addresses`.\n  `RB #2974 <https://rbcommons.com/s/twitter/r/2974>`_\n\n* Fix catchall except statments\n  `RB #2971 <https://rbcommons.com/s/twitter/r/2971>`_\n\n* Fix pinger cache bug and add test.\n  `RB #2948 <https://rbcommons.com/s/twitter/r/2948>`_\n\n* Fix mixed classpaths where internal-only is needed.\n  `Issue #2358 <https://github.com/pantsbuild/pants/issues/2358>`_\n  `Issue #2359 <https://github.com/pantsbuild/pants/issues/2359>`_\n  `RB #2964 <https://rbcommons.com/s/twitter/r/2964>`_\n\n* Reproduces problem with deploy_excludes()\n  `RB #2961 <https://rbcommons.com/s/twitter/r/2961>`_\n\n* Add missing BUILD dep introduced by d724e2414.\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* A new implementation of SourceRoots.\n  `RB #2970 <https://rbcommons.com/s/twitter/r/2970>`_\n\n* Restructured the Export task to make the json blob reusable.\n  `RB #2946 <https://rbcommons.com/s/twitter/r/2946>`_\n\n* Make \'changed\' faster by not instantiating already injected targets\n  `RB #2967 <https://rbcommons.com/s/twitter/r/2967>`_\n\n* Add some more badge bling.\n  `RB #2965 <https://rbcommons.com/s/twitter/r/2965>`_\n\n* Cleanup BaseTest.\n  `RB #2963 <https://rbcommons.com/s/twitter/r/2963>`_\n\n0.0.53 (10/9/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nDue to the hotfix release on Wednesday, this is a fairly light release. But because it addresses two potential correctness issues related to JVM tooling, it is well worth picking up!\n\nAPI Changes\n~~~~~~~~~~~\n\n* Move address.py/address_lookup_error.py from base to build_graph\n  `RB #2954 <https://rbcommons.com/s/twitter/r/2954>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add native timeouts to python and junit tests\n  `RB #2919 <https://rbcommons.com/s/twitter/r/2919>`_\n\n* Be more conservative about caching incremental JVM compiles\n  `RB #2940 <https://rbcommons.com/s/twitter/r/2940>`_\n\nBugfixes\n~~~~~~~~\n\n* Restore deep jvm-tool fingerprinting\n  `RB #2955 <https://rbcommons.com/s/twitter/r/2955>`_\n\n* Handle AccessDenied exception in more cases for daemon process scanning\n  `RB #2951 <https://rbcommons.com/s/twitter/r/2951>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Upgrade to pex 1.1.0\n  `RB #2956 <https://rbcommons.com/s/twitter/r/2956>`_\n\n* [exp] Support for scanning addresses, implement `list`\n  `RB #2952 <https://rbcommons.com/s/twitter/r/2952>`_\n\n* [exp] Optimize python parsers\n  `RB #2947 <https://rbcommons.com/s/twitter/r/2947>`_\n\n* [exp] Switch from \'typename\' to \'type_alias\'.\n  `RB #2945 <https://rbcommons.com/s/twitter/r/2945>`_\n\n* [exp] Support a non-inlined lazy resolve mode in Graph.\n  `RB #2944 <https://rbcommons.com/s/twitter/r/2944>`_\n\n* Emit a nice error message if the compiler used to bootstrap pants isn\'t functional\n  `RB #2949 <https://rbcommons.com/s/twitter/r/2949>`_\n\n* Eliminate travis-ci cache thrash.\n  `RB #2957 <https://rbcommons.com/s/twitter/r/2957>`_\n\n\n0.0.52 (10/7/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is a hotfix release that unpins pants own six requirement from \'==1.9\' to \'>=1.9,<2\' to allow\nfolks depending on pantsbuild sdists in their own pants built/tested code to successfully resolve\nsix.  The underlying issue is yet to be fixed, but is tracked\n`here <https://github.com/pantsbuild/pex/issues/167>`_.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Bump the default ivy bootstrap jar to 2.4.0.\n  `RB #2938 <https://rbcommons.com/s/twitter/r/2938>`_\n\n* Remove the classes_by_target and resources_by_target products\n  `RB #2928 <https://rbcommons.com/s/twitter/r/2928>`_\n\nBugfixes\n~~~~~~~~\n\n* Allow six to float a bit.\n  `RB #2942 <https://rbcommons.com/s/twitter/r/2942>`_\n\n* Add the include and exclude patterns to the payload so they will make it into the fingerprint\n  `RB #2927 <https://rbcommons.com/s/twitter/r/2927>`_\n\n* Ensure GOPATH is always controlled by pants.\n  `RB #2933 <https://rbcommons.com/s/twitter/r/2933>`_\n\n* Stopped ivy from failing if an artifact has a url specified.\n  `RB #2905 <https://rbcommons.com/s/twitter/r/2905>`_\n\n* Test-cases that passed are now properly omitted the junit summary.\n  `RB #2916 <https://rbcommons.com/s/twitter/r/2916>`_\n  `RB #2930 <https://rbcommons.com/s/twitter/r/2930>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Kill the checkstyle jvm tool override in pants.ini.\n  `RB #2941 <https://rbcommons.com/s/twitter/r/2941>`_\n\n* Only request the `classes_by_source` product if it is necessary\n  `RB #2939 <https://rbcommons.com/s/twitter/r/2939>`_\n\n* Fixup android local resolvers.\n  `RB #2934 <https://rbcommons.com/s/twitter/r/2934>`_\n\n* Simplify cobertura source paths for reporting\n  `RB #2918 <https://rbcommons.com/s/twitter/r/2918>`_\n\n* Upgrade the default Go distribution to 1.5.1.\n  `RB #2936 <https://rbcommons.com/s/twitter/r/2936>`_\n\n* Normalize AddressMapper paths for parse/forget.\n  `RB #2935 <https://rbcommons.com/s/twitter/r/2935>`_\n\n* Create test task mixin\n  `RB #2902 <https://rbcommons.com/s/twitter/r/2902>`_\n\n* Make sure tests/python/pants_test:all runs all the tests\n  `RB #2932 <https://rbcommons.com/s/twitter/r/2932>`_\n\n* Seperate out AddressMapper from Graph.\n  `RB #2931 <https://rbcommons.com/s/twitter/r/2931>`_\n\n* Add timeout configuration to Pinger and add unittest.\n  `RB #2912 <https://rbcommons.com/s/twitter/r/2912>`_\n\n* Adding Node examples\n  `RB #2900 <https://rbcommons.com/s/twitter/r/2900>`_\n\n\n0.0.51 (10/2/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release moves some packages commonly used in plugins from `pants.base` to `pants.build_graph`.\nThe old packages still work, but have been deprecated and will be removed in 0.0.53.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Move various build graph-related files to new pkg: build_graph.\n  `RB #2899 <https://rbcommons.com/s/twitter/r/2899>`_\n  `RB #2908 <https://rbcommons.com/s/twitter/r/2908>`_\n  `RB #2909 <https://rbcommons.com/s/twitter/r/2909>`_\n\nBugfixes\n~~~~~~~~\n\n* Ensure execution graph cancellation only happens once per job\n  `RB #2910 <https://rbcommons.com/s/twitter/r/2910>`_\n\n* Two performance hacks in build file parsing.\n  `RB #2895 <https://rbcommons.com/s/twitter/r/2895>`_\n\n* Performance fix for ./pants depmap --minimal\n  `RB #2896 <https://rbcommons.com/s/twitter/r/2896>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Introduce instrument_classpath, and modify cobertura to use native class filtering\n  `RB #2893 <https://rbcommons.com/s/twitter/r/2893>`_\n\n* Implement deprecation messages for entire modules.\n  `RB #2904 <https://rbcommons.com/s/twitter/r/2904>`_\n\n* Upstream the scala_jar and scala_artifact helpers to suffix the scala platform version.\n  `RB #2891 <https://rbcommons.com/s/twitter/r/2891>`_\n\n* Adding the bootstrapped node/npm to the PATH when executing commands\n  `RB #2883 <https://rbcommons.com/s/twitter/r/2883>`_\n\n* Update path(s) tasks, add tests, extract pluralize to strutil\n  `RB #2892 <https://rbcommons.com/s/twitter/r/2892>`_\n\n* Fix duplicate changelog link.\n  `RB #2890 <https://rbcommons.com/s/twitter/r/2890>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Extract Config as Configuration to its own module.\n  `RB #2924 <https://rbcommons.com/s/twitter/r/2924>`_\n\n* Define a lifecycle for Config objects.\n  `RB #2920 <https://rbcommons.com/s/twitter/r/2920>`_\n\n* Add baseline functionality for engine experiments.\n  `RB #2914 <https://rbcommons.com/s/twitter/r/2914>`_\n\n* Reformatting the junit output to be consistent with pants.\n  `RB #2917 <https://rbcommons.com/s/twitter/r/2917>`_\n  `RB #2925 <https://rbcommons.com/s/twitter/r/2925>`_\n\n* Allow junit tests to have empty sources\n  `RB #2923 <https://rbcommons.com/s/twitter/r/2923>`_\n\n* Adding a summary list of failing testcases to junit_run.\n  `RB #2916 <https://rbcommons.com/s/twitter/r/2916>`_\n\n* Adding the java language level to the IdeaGen module output.\n  `RB #2911 <https://rbcommons.com/s/twitter/r/2911>`_\n\n* Make a nicer diagnostic on parse error in pants.ini\n  `RB #2907 <https://rbcommons.com/s/twitter/r/2907>`_\n\n* Shorten long target ids by replacing superfluous characters with a hash\n  `RB #2894 <https://rbcommons.com/s/twitter/r/2894>`_\n\n* Migrate scrooge to SimpleCodegenTask\n  `RB #2808 <https://rbcommons.com/s/twitter/r/2808>`_\n\n0.0.50 (9/25/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release removes the \'global\' jvm compile strategy in favor of the \'isolated\' strategy and\nswitches the default java incremental compilation frontend from jmake to zinc.  If you were using\n\'global\' and/or jmake you\'ll have some pants.ini cleanup to do.  You can run the migration tool\nfrom the `pantsbuild/pants repository <https://github.com/pantsbuild/pants>`_ by cloning the repo\nand running the following command from there against your own repo\'s pants.ini::\n\n    pantsbuild/pants $ ./pants run migrations/options/src/python:migrate_config -- [path to your repo\'s pants.ini]\n\nThere have been several additional deprecated APIs removed in this release, please review the\nAPI Changes section below.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove artifacts from JarDependency; Kill IvyArtifact.\n  `RB #2858 <https://rbcommons.com/s/twitter/r/2858>`_\n\n* Kill deprecated `BuildFileAliases.create` method.\n  `RB #2888 <https://rbcommons.com/s/twitter/r/2888>`_\n\n* Remove the deprecated `SyntheticAddress` class.\n  `RB #2886 <https://rbcommons.com/s/twitter/r/2886>`_\n\n* Slim down the API of the Config class and move it to options/.\n  `RB #2865 <https://rbcommons.com/s/twitter/r/2865>`_\n\n* Remove the JVM global compile strategy, switch default java compiler to zinc\n  `RB #2852 <https://rbcommons.com/s/twitter/r/2852>`_\n\n* Support arbitrary expressions in option values.\n  `RB #2860 <https://rbcommons.com/s/twitter/r/2860>`_\n\nBugfixes\n~~~~~~~~\n\n* Change jar-tool to use CONCAT_TEXT by default for handling duplicates under META-INF/services\n  `RB #2881 <https://rbcommons.com/s/twitter/r/2881>`_\n\n* Upgrade to jarjar 1.6.0.\n  `RB #2880 <https://rbcommons.com/s/twitter/r/2880>`_\n\n* Improve error handling for nailgun client connection attempts\n  `RB #2869 <https://rbcommons.com/s/twitter/r/2869>`_\n\n* Fix Go targets to glob more than \'.go\' files.\n  `RB #2873 <https://rbcommons.com/s/twitter/r/2873>`_\n\n* Defend against concurrent bootstrap of the zinc compiler interface\n  `RB #2872 <https://rbcommons.com/s/twitter/r/2872>`_\n  `RB #2867 <https://rbcommons.com/s/twitter/r/2867>`_\n  `RB #2866 <https://rbcommons.com/s/twitter/r/2866>`_\n\n* Fix missing underscore, add simple unit test\n  `RB #2805 <https://rbcommons.com/s/twitter/r/2805>`_\n  `RB #2862 <https://rbcommons.com/s/twitter/r/2862>`_\n\n* Fix a protocol bug in `GopkgInFetcher` for v0\'s.\n  `RB #2857 <https://rbcommons.com/s/twitter/r/2857>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Allow resolving buildcache hosts via a REST service\n  `RB #2815 <https://rbcommons.com/s/twitter/r/2815>`_\n\n* Implement profiling inside pants.\n  `RB #2885 <https://rbcommons.com/s/twitter/r/2885>`_\n\n* Adds a new CONCAT_TEXT rule to jar tool to handle text files that might be missing the last newline.\n  `RB #2875 <https://rbcommons.com/s/twitter/r/2875>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Enable Future compatibility style checks\n  `RB #2884 <https://rbcommons.com/s/twitter/r/2884>`_\n\n* Fix another scoped option issue in the test harnesses\n  `RB #2850 <https://rbcommons.com/s/twitter/r/2850>`_\n  `RB #2870 <https://rbcommons.com/s/twitter/r/2870>`_\n\n* Fix go_local_source_test_base.py for OSX.\n  `RB #2882 <https://rbcommons.com/s/twitter/r/2882>`_\n\n* Fix javadocs and add jvm doc gen to CI.\n  `Issue #65 <https://github.com/pantsbuild/pants/issues/65>`_\n  `RB #2877 <https://rbcommons.com/s/twitter/r/2877>`_\n\n* Fixup release dry runs; use isolated plugin cache.\n  `RB #2874 <https://rbcommons.com/s/twitter/r/2874>`_\n\n* Fix scoped options initialization in test\n  `RB #2815 <https://rbcommons.com/s/twitter/r/2815>`_\n  `RB #2850 <https://rbcommons.com/s/twitter/r/2850>`_\n\n0.0.49 (9/21/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is a hotfix release that includes a fix for resolving remote go libraries\nthat use relative imports.\n\nBugfixes\n~~~~~~~~\n\n* Include resolved jar versions in compile fingerprints; ensure coordinates match artifacts.\n  `RB #2853 <https://rbcommons.com/s/twitter/r/2853>`_\n\n* Fixup GoFetch to handle relative imports.\n  `RB #2854 <https://rbcommons.com/s/twitter/r/2854>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Enhancements to the dep-usage goal\n  `RB #2851 <https://rbcommons.com/s/twitter/r/2851>`_\n\n0.0.48 (9/18/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThere is a new UI in the `./pants server` web interface that shows \'Timing Stats\' graphs.  These\ngraphs show where time is spent on a daily-aggregation basis in various tasks.  You can drill down\ninto a task to see which sub-steps are most expensive.  Try it out!\n\nWe also have a few new metadata goals to help figure out what\'s going on with file ownership and\noptions.\n\nIf you want to find out where options are coming from, the `options` goal can help you out::\n\n    $ ./pants -q options --only-overridden --scope=compile\n    compile.apt.jvm_options = [\'-Xmx1g\', \'-XX:MaxPermSize=256m\'] (from CONFIG in pants.ini)\n    compile.java.jvm_options = [\'-Xmx2G\'] (from CONFIG in pants.ini)\n    compile.java.partition_size_hint = 1000000000 (from CONFIG in pants.ini)\n    compile.zinc.jvm_options = [\'-Xmx2g\', \'-XX:MaxPermSize=256m\', \'-Dzinc.analysis.cache.limit=0\'] (from CONFIG in pants.ini)\n\nIf you\'re not sure which target(s) own a given file::\n\n    $ ./pants -q list-owners -- src/python/pants/base/target.py\n    src/python/pants/build_graph\n\nThe latter comes from new contributor Tansy Arron-Walker.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Kill \'ivy_jar_products\'.\n  `RB #2823 <https://rbcommons.com/s/twitter/r/2823>`_\n\n* Kill \'ivy_resolve_symlink_map\' and \'ivy_cache_dir\' products.\n  `RB #2819 <https://rbcommons.com/s/twitter/r/2819>`_\n\nBugfixes\n~~~~~~~~\n\n* Upgrade to jarjar 1.5.2.\n  `RB #2847 <https://rbcommons.com/s/twitter/r/2847>`_\n\n* Don\'t modify globs excludes argument value.\n  `RB #2841 <https://rbcommons.com/s/twitter/r/2841>`_\n\n* Whitelist the appropriate filter option name for zinc\n  `RB #2839 <https://rbcommons.com/s/twitter/r/2839>`_\n\n* Ensure stale classes are removed during isolated compile by cleaning classes directory prior to handling invalid targets\n  `RB #2805 <https://rbcommons.com/s/twitter/r/2805>`_\n\n* Fix `linecount` estimator for `dep-usage` goal\n  `RB #2828 <https://rbcommons.com/s/twitter/r/2828>`_\n\n* Fix resource handling for the python backend.\n  `RB #2817 <https://rbcommons.com/s/twitter/r/2817>`_\n\n* Fix coordinates of resolved jars in IvyInfo.\n  `RB #2818 <https://rbcommons.com/s/twitter/r/2818>`_\n\n* Fix `NailgunExecutor` to support more than one connect attempt\n  `RB #2822 <https://rbcommons.com/s/twitter/r/2822>`_\n\n* Fixup AndroidIntegrationTest broken by Distribution refactor.\n  `RB #2811 <https://rbcommons.com/s/twitter/r/2811>`_\n\n* Backport sbt java output fixes into zinc\n  `RB #2810 <https://rbcommons.com/s/twitter/r/2810>`_\n\n* Align ivy excludes and ClasspathProducts excludes.\n  `RB #2807 <https://rbcommons.com/s/twitter/r/2807>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* A nice timing stats report.\n  `RB #2825 <https://rbcommons.com/s/twitter/r/2825>`_\n\n* Add new console task ListOwners to determine the targets that own a source\n  `RB #2755 <https://rbcommons.com/s/twitter/r/2755>`_\n\n* Adding a console task to explain where options came from.\n  `RB #2816 <https://rbcommons.com/s/twitter/r/2816>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Deprecate \'Repository\' alias in favor of \'repo\'.\n  `RB #2845 <https://rbcommons.com/s/twitter/r/2845>`_\n\n* Fix indents (checkstyle)\n  `RB #2844 <https://rbcommons.com/s/twitter/r/2844>`_\n\n* Use list comprehension in jvm_compile to calculate valid targets\n  `RB #2843 <https://rbcommons.com/s/twitter/r/2843>`_\n\n* Transition `IvyImports` to \'compile_classpath\'.\n  `RB #2840 <https://rbcommons.com/s/twitter/r/2840>`_\n\n* Migrate `JvmBinaryTask` to \'compile_classpath\'.\n  `RB #2832 <https://rbcommons.com/s/twitter/r/2832>`_\n\n* Add support for snapshotting `ClasspathProducts`.\n  `RB #2837 <https://rbcommons.com/s/twitter/r/2837>`_\n\n* Bump to zinc 1.0.11\n  `RB #2827 <https://rbcommons.com/s/twitter/r/2827>`_\n  `RB #2836 <https://rbcommons.com/s/twitter/r/2836>`_\n  `RB #2812 <https://rbcommons.com/s/twitter/r/2812>`_\n\n* Lazily load zinc analysis\n  `RB #2827 <https://rbcommons.com/s/twitter/r/2827>`_\n\n* Add support for whitelisting of zinc options\n  `RB #2835 <https://rbcommons.com/s/twitter/r/2835>`_\n\n* Kill the unused `JvmTarget.configurations` field.\n  `RB #2834 <https://rbcommons.com/s/twitter/r/2834>`_\n\n* Kill \'jvm_build_tools_classpath_callbacks\' deps.\n  `RB #2831 <https://rbcommons.com/s/twitter/r/2831>`_\n\n* Add `:scalastyle_integration` test to `:integration` test target\n  `RB #2830 <https://rbcommons.com/s/twitter/r/2830>`_\n\n* Use fast_relpath in JvmCompileIsolatedStrategy.compute_classes_by_source\n  `RB #2826 <https://rbcommons.com/s/twitter/r/2826>`_\n\n* Enable New Style class check\n  `RB #2820 <https://rbcommons.com/s/twitter/r/2820>`_\n\n* Remove `--quiet` flag from `pip`\n  `RB #2809 <https://rbcommons.com/s/twitter/r/2809>`_\n\n* Move AptCompile to zinc\n  `RB #2806 <https://rbcommons.com/s/twitter/r/2806>`_\n\n* Add a just-in-time check of the artifact cache to the isolated compile strategy\n  `RB #2690 <https://rbcommons.com/s/twitter/r/2690>`_\n\n0.0.47 (9/11/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nBy defaulting the versions of most built-in tools, this release makes pants significantly easier to configure! Tools like antlr, jmake, nailgun, etc, will use default classpaths unless override targets are provided.\n\nAdditionally, this release adds native support for shading JVM binaries, which helps to isolate them from their deployment environment.\n\nThanks to all contributors!\n\nAPI Changes\n~~~~~~~~~~~\n\n* Add JVM distributions and platforms to the export format.\n  `RB #2784 <https://rbcommons.com/s/twitter/r/2784>`_\n\n* Added Python setup to export goal to consume in the Pants Plugin for IntelliJ.\n  `RB #2785 <https://rbcommons.com/s/twitter/r/2785>`_\n  `RB #2786 <https://rbcommons.com/s/twitter/r/2786>`_\n\n* Introduce anonymous targets built by macros.\n  `RB #2759 <https://rbcommons.com/s/twitter/r/2759>`_\n\n* Upgrade to the re-merged Node.js/io.js as the default.\n  `RB #2800 <https://rbcommons.com/s/twitter/r/2800>`_\n\nBugfixes\n~~~~~~~~\n\n* Don\'t create directory entries in the isolated compile context jar\n  `RB #2775 <https://rbcommons.com/s/twitter/r/2775>`_\n\n* Bump jar-tool release version to 0.0.7 to pick up double-slashed directory fixes\n  `RB #2763 <https://rbcommons.com/s/twitter/r/2763>`_\n  `RB #2779 <https://rbcommons.com/s/twitter/r/2779>`_\n\n* junit_run now parses errors (in addition to failures) to correctly set failing target\n  `RB #2782 <https://rbcommons.com/s/twitter/r/2782>`_\n\n* Fix the zinc name-hashing flag for unicode symbols\n  `RB #2776 <https://rbcommons.com/s/twitter/r/2776>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Support for shading rules for jvm_binary.\n  `RB #2754 <https://rbcommons.com/s/twitter/r/2754>`_\n\n* Add support for @fromfile option values.\n  `RB #2783 <https://rbcommons.com/s/twitter/r/2783>`_\n  `RB #2794 <https://rbcommons.com/s/twitter/r/2794>`_\n\n* --config-override made appendable, to support multiple pants.ini files.\n  `RB #2774 <https://rbcommons.com/s/twitter/r/2774>`_\n\n* JVM tools can now carry their own classpath, meaning that most don\'t need to be configured\n  `RB #2778 <https://rbcommons.com/s/twitter/r/2778>`_\n  `RB #2795 <https://rbcommons.com/s/twitter/r/2795>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Added migration of --jvm-jdk-paths to --jvm-distributions-paths\n  `RB #2677 <https://rbcommons.com/s/twitter/r/2677>`_\n  `RB #2781 <https://rbcommons.com/s/twitter/r/2781>`_\n\n* Example of problem with annotation processors that reference external dependencies.\n  `RB #2777 <https://rbcommons.com/s/twitter/r/2777>`_\n\n* Replace eval use with a parse_literal util.\n  `RB #2787 <https://rbcommons.com/s/twitter/r/2787>`_\n\n* Move Shader from pants.java to the jvm backend.\n  `RB #2788 <https://rbcommons.com/s/twitter/r/2788>`_\n\n* Move BuildFileAliases validation to BuildFileAliases.\n  `RB #2790 <https://rbcommons.com/s/twitter/r/2790>`_\n\n* Centralize finding target types for an alias.\n  `RB #2796 <https://rbcommons.com/s/twitter/r/2796>`_\n\n* Store timing stats in a structured way, instead of as json.\n  `RB #2797 <https://rbcommons.com/s/twitter/r/2797>`_\n\nDocumentation\n~~~~~~~~~~~~~\n\n* Added a step to publish RELEASE HISTORY back to the public website [DOC]\n  `RB #2780 <https://rbcommons.com/s/twitter/r/2780>`_\n\n* Fix buildcache doc typos, use err param rather than ignoring it in UnreadableArtifact\n  `RB #2801 <https://rbcommons.com/s/twitter/r/2801>`_\n\n0.0.46 (9/4/2015)\n-----------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release includes more support for Node.js!\n\nSupport for the environment variables `PANTS_VERBOSE` and `PANTS_BUILD_ROOT` have been removed in\nthis release.  Instead, use `--level` to turn on debugging in pants.  Pants recursively searches from\nthe current directory to the root directory until it finds the `pants.ini` file in order to find\nthe build root.\n\nThe `pants()` syntax in BUILD files has been removed (deprecated since 0.0.29).\n\nAPI Changes\n~~~~~~~~~~~\n\n* Kill PANTS_VERBOSE and PANTS_BUILD_ROOT.\n  `RB #2760 <https://rbcommons.com/s/twitter/r/2760>`_\n\n* [classpath products] introduce ResolvedJar and M2Coordinate and use them for improved exclude handling\n  `RB #2654 <https://rbcommons.com/s/twitter/r/2654>`_\n\n* Kill the `pants()` pointer, per discussion in Slack: https://pantsbuild.slack.com/archives/general/p1440451305004760\n  `RB #2650 <https://rbcommons.com/s/twitter/r/2650>`_\n\n* Make Globs classes and Bundle stand on their own.\n  `RB #2740 <https://rbcommons.com/s/twitter/r/2740>`_\n\n* Rid all targets of sources_rel_path parameters.\n  `RB #2738 <https://rbcommons.com/s/twitter/r/2738>`_\n\n* Collapse SyntheticAddress up into Address. [API]\n  `RB #2730 <https://rbcommons.com/s/twitter/r/2730>`_\n\nBugfixes\n~~~~~~~~\n\n* Fix + test 3rd party missing dep for zinc\n  `RB #2764 <https://rbcommons.com/s/twitter/r/2764>`_\n\n* Implement a synthetic jar that sets Class-Path to bypass ARG_MAX limit\n  `RB #2672 <https://rbcommons.com/s/twitter/r/2672>`_\n\n* Fixed changed goal for BUILD files in build root\n  `RB #2749 <https://rbcommons.com/s/twitter/r/2749>`_\n\n* Refactor / bug-fix for checking jars during dep check\n  `RB #2739 <https://rbcommons.com/s/twitter/r/2739>`_\n\n* PytestRun test failures parsing is broken for tests in a class\n  `RB #2714 <https://rbcommons.com/s/twitter/r/2714>`_\n\n* Make nailgun_client error when the client socket is closed.\n  `RB #2727 <https://rbcommons.com/s/twitter/r/2727>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Initial support for `resolve.npm`.\n  `RB #2723 <https://rbcommons.com/s/twitter/r/2723>`_\n\n* Add support for `repl.node`.\n  `RB #2766 <https://rbcommons.com/s/twitter/r/2766>`_\n\n* Setup the node contrib for release.\n  `RB #2768 <https://rbcommons.com/s/twitter/r/2768>`_\n\n* Add annotation processor settings to goal idea\n  `RB #2753 <https://rbcommons.com/s/twitter/r/2753>`_\n\n* Introduce job prioritization to ExecutionGraph\n  `RB #2601 <https://rbcommons.com/s/twitter/r/2601>`_\n\n* Provide include paths to thrift-linter to allow for more complex checks\n  `RB #2712 <https://rbcommons.com/s/twitter/r/2712>`_\n\n* JVM dependency usage task\n  `RB #2757 <https://rbcommons.com/s/twitter/r/2757>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Re-work REPL mutual exclusion.\n  `RB #2765 <https://rbcommons.com/s/twitter/r/2765>`_\n\n* Return cached_chroots instead of yielding them.\n  `RB #2762 <https://rbcommons.com/s/twitter/r/2762>`_\n\n* Normalize and decompose GoalRunner initialization and setup\n  `RB #2715 <https://rbcommons.com/s/twitter/r/2715>`_\n\n* Fixed pre-commit hook for CI\n  `RB #2758 <https://rbcommons.com/s/twitter/r/2758>`_\n\n* Code added check valid arguments for glob, test added as well\n  `RB #2750 <https://rbcommons.com/s/twitter/r/2750>`_\n\n* Fix newline style nits and enable newline check in pants.ini\n  `RB #2756 <https://rbcommons.com/s/twitter/r/2756>`_\n\n* Add the class name and scope name to the uninitialized subsystem error message\n  `RB #2698 <https://rbcommons.com/s/twitter/r/2698>`_\n\n* Make nailgun killing faster.\n  `RB #2685 <https://rbcommons.com/s/twitter/r/2685>`_\n\n* Switch JVM missing dep detection to use compile_classpath\n  `RB #2729 <https://rbcommons.com/s/twitter/r/2729>`_\n\n* Add transitive flag to ClasspathProduct.get_for_target[s]\n  `RB #2744 <https://rbcommons.com/s/twitter/r/2744>`_\n\n* Add transitive parameter to UnionProducts.get_for_target[s]\n  `RB #2741 <https://rbcommons.com/s/twitter/r/2741>`_\n\n* Tighten up the node target hierarchy.\n  `RB #2736 <https://rbcommons.com/s/twitter/r/2736>`_\n\n* Ensure pipeline failuires fail CI.\n  `RB #2731 <https://rbcommons.com/s/twitter/r/2731>`_\n\n* Record the BUILD target alias in BuildFileAddress.\n  `RB #2726 <https://rbcommons.com/s/twitter/r/2726>`_\n\n* Use BaseCompileIT to double-check missing dep failure and whitelist success.\n  `RB #2732 <https://rbcommons.com/s/twitter/r/2732>`_\n\n* Use Target.subsystems to expose UnknownArguments.\n  `RB #2725 <https://rbcommons.com/s/twitter/r/2725>`_\n\n* Populate classes_by_target using the context jar for the isolated strategy\n  `RB #2720 <https://rbcommons.com/s/twitter/r/2720>`_\n\n* Push OSX CI\'s over to pantsbuild-osx.\n  `RB #2724 <https://rbcommons.com/s/twitter/r/2724>`_\n\nDocumentation\n~~~~~~~~~~~~~\n\n* Update a few references to options moved to the jvm subsystem in docs and comments\n  `RB #2751 <https://rbcommons.com/s/twitter/r/2751>`_\n\n* Update developer docs mention new testing idioms\n  `RB #2743 <https://rbcommons.com/s/twitter/r/2743>`_\n\n* Clarify the RBCommons/pants-reviews setup step.\n  `RB #2733 <https://rbcommons.com/s/twitter/r/2733>`_\n\n0.0.45 (8/28/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nIn this release, the methods `with_sources()`, `with_docs()` and `with_artifact()`\nwere removed from the jar() syntax in BUILD files.   They have been deprecated since\nPants version 0.0.29.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove with_artifact(), with_sources(), and with_docs() from JarDependency\n  `RB #2687 <https://rbcommons.com/s/twitter/r/2687>`_\n\nBugfixes\n~~~~~~~~\n\n* Upgrade zincutils to 0.3.1 for parse_deps bug fix\n  `RB #2705 <https://rbcommons.com/s/twitter/r/2705>`_\n\n* Fix PythonThriftBuilder to operate on 1 target.\n  `RB #2696 <https://rbcommons.com/s/twitter/r/2696>`_\n\n* Ensure stdlib check uses normalized paths.\n  `RB #2693 <https://rbcommons.com/s/twitter/r/2693>`_\n\n* Hack around a few Distribution issues in py tests.\n  `RB #2692 <https://rbcommons.com/s/twitter/r/2692>`_\n\n* Fix GoBuildgen classname and a comment typo.\n  `RB #2689 <https://rbcommons.com/s/twitter/r/2689>`_\n\n* Making --coverage-open work for cobertura.\n  `RB #2670 <https://rbcommons.com/s/twitter/r/2670>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Implementing support for Wire 2.0 multiple proto paths.\n  `RB #2717 <https://rbcommons.com/s/twitter/r/2717>`_\n\n* [pantsd] PantsService, FSEventService & WatchmanLauncher\n  `RB #2686 <https://rbcommons.com/s/twitter/r/2686>`_\n\n* Add NodeDistribution to seed a node backend.\n  `RB #2703 <https://rbcommons.com/s/twitter/r/2703>`_\n\n* Created DistributionLocator subsystem with jvm-distributions option-space.\n  `RB #2677 <https://rbcommons.com/s/twitter/r/2677>`_\n\n* Added support for wire 2.0 arguments and beefed up tests\n  `RB #2688 <https://rbcommons.com/s/twitter/r/2688>`_\n\n* Initial commit of checkstyle\n  `RB #2593 <https://rbcommons.com/s/twitter/r/2593>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Removed scan workunit; mapping workunits now debug\n  `RB #2721 <https://rbcommons.com/s/twitter/r/2721>`_\n\n* Implement caching for the thrift linter.\n  `RB #2718 <https://rbcommons.com/s/twitter/r/2718>`_\n\n* Refactor JvmDependencyAnalyzer into a task\n  `RB #2668 <https://rbcommons.com/s/twitter/r/2668>`_\n\n* Refactor plugin system to allow for easier extension by others\n  `RB #2706 <https://rbcommons.com/s/twitter/r/2706>`_\n\n* Indented code which prints warnings for unrecognized os\'s.\n  `RB #2713 <https://rbcommons.com/s/twitter/r/2713>`_\n\n* Fixup existing docs and add missing docs.\n  `RB #2708 <https://rbcommons.com/s/twitter/r/2708>`_\n\n* Requiring explicit dependency on the DistributionLocator subsystem.\n  `RB #2707 <https://rbcommons.com/s/twitter/r/2707>`_\n\n* Reorganize option help.\n  `RB #2695 <https://rbcommons.com/s/twitter/r/2695>`_\n\n* Set \'pants-reviews\' as the default group.\n  `RB #2702 <https://rbcommons.com/s/twitter/r/2702>`_\n\n* Update to zinc 1.0.9 and sbt 0.13.9\n  `RB #2658 <https://rbcommons.com/s/twitter/r/2658>`_\n\n* Test the individual style checks and only disable the check that is currently failing CI\n  `RB #2697 <https://rbcommons.com/s/twitter/r/2697>`_\n\n0.0.44 (8/21/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nIn this release Go support should be considered beta.  Most features you\'d expect are implemented\nincluding a `buildgen.go` task that can maintain your Go BUILD files as inferred from just\n`go_binary` target definitions.  Yet to come is `doc` goal integration and an option to wire\nin-memory `buildgen.go` as an implicit bootstrap task in any pants run that includes Go targets.\n\nAlso in this release is improved control over the tools pants uses, in particular JVM selection\ncontrol.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove deprecated `[compile.java]` options.\n  `RB #2678 <https://rbcommons.com/s/twitter/r/2678>`_\n\nBugfixes\n~~~~~~~~\n\n* Better caching for Python interpreters and requirements.\n  `RB #2679 <https://rbcommons.com/s/twitter/r/2679>`_\n\n* Fixup use of removed flag `compile.java --target` in integration tests.\n  `RB #2680 <https://rbcommons.com/s/twitter/r/2680>`_\n\n* Add support for fetching Go test deps.\n  `RB #2671 <https://rbcommons.com/s/twitter/r/2671>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Integrate Go with the binary goal.\n  `RB #2681 <https://rbcommons.com/s/twitter/r/2681>`_\n\n* Initial support for Go BUILD gen.\n  `RB #2676 <https://rbcommons.com/s/twitter/r/2676>`_\n\n* Adding jdk_paths option to jvm subsystem.\n  `RB #2657 <https://rbcommons.com/s/twitter/r/2657>`_\n\n* Allow specification of kwargs that are not currently known.\n  `RB #2662 <https://rbcommons.com/s/twitter/r/2662>`_\n\n* Allow os name map in binary_util to be configured externally\n  `RB #2663 <https://rbcommons.com/s/twitter/r/2663>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* [pantsd] Watchman & StreamableWatchmanClient\n  `RB #2649 <https://rbcommons.com/s/twitter/r/2649>`_\n\n* Upgrade the default Go distribution to 1.5.\n  `RB #2669 <https://rbcommons.com/s/twitter/r/2669>`_\n\n* Align JmakeCompile error messages with reality.\n  `RB #2682 <https://rbcommons.com/s/twitter/r/2682>`_\n\n* Fixing BUILD files which had integration tests running in :all.\n  `RB #2664 <https://rbcommons.com/s/twitter/r/2664>`_\n\n* Remove log options from the zinc Setup to fix performance issue\n  `RB #2666 <https://rbcommons.com/s/twitter/r/2666>`_\n\n0.0.43 (8/19/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis release makes the isolated jvm compile strategy viable out-of-the-box for use with large\ndependency graphs. Without it, `test.junit` and `run.jvm` performance slows down significantly\ndue to the large number of loose classfile directories.\n\nPlease try it out in your repo by grabbing a copy of `pants.ini.isolated\n<https://github.com/pantsbuild/pants/blob/master/pants.ini.isolated>`_ and using a command like::\n\n    ./pants --config-override=pants.ini.isolated test examples/{src,tests}/{scala,java}/::\n\nYou\'ll like the results.  Just update your own `pants.ini` with the pants.ini.isolated settings to\nuse it by default!\n\nIn the medium term, we\'re interested in making the isolated strategy the default jvm compilation\nstrategy, so your assistance and feedback is appreciated!\n\nSpecial thanks to Stu Hood and Nick Howard for lots of work over the past months to get this point.\n\nAPI Changes\n~~~~~~~~~~~\n\n* A uniform way of expressing Task and Subsystem dependencies.\n  `Issue #1957 <https://github.com/pantsbuild/pants/issues/1957>`_\n  `RB #2653 <https://rbcommons.com/s/twitter/r/2653>`_\n\n* Remove some coverage-related options from test.junit.\n  `RB #2639 <https://rbcommons.com/s/twitter/r/2639>`_\n\n* Bump mock and six 3rdparty versions to latest\n  `RB #2633 <https://rbcommons.com/s/twitter/r/2633>`_\n\n* Re-implement suppression of output from compiler workunits\n  `RB #2590 <https://rbcommons.com/s/twitter/r/2590>`_\n\nBugfixes\n~~~~~~~~\n\n* Improved go remote library support.\n  `RB #2655 <https://rbcommons.com/s/twitter/r/2655>`_\n\n* Shorten isolation generated jar paths\n  `RB #2647 <https://rbcommons.com/s/twitter/r/2647>`_\n\n* Fix duplicate login options when publishing.\n  `RB #2560 <https://rbcommons.com/s/twitter/r/2560>`_\n\n* Fixed no attribute exception in changed goal.\n  `RB #2645 <https://rbcommons.com/s/twitter/r/2645>`_\n\n* Fix goal idea issues with mistakenly identifying a test folder as regular code, missing resources\n  folders, and resources folders overriding code folders.\n  `RB #2046 <https://rbcommons.com/s/twitter/r/2046>`_\n  `RB #2642 <https://rbcommons.com/s/twitter/r/2642>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Support for running junit tests with different jvm versions.\n  `RB #2651 <https://rbcommons.com/s/twitter/r/2651>`_\n\n* Add support for jar\'ing compile outputs in the isolated strategy.\n  `RB #2643 <https://rbcommons.com/s/twitter/r/2643>`_\n\n* Tests for \'java-resoures\' and \'java-test-resources\' in idea\n  `RB #2046 <https://rbcommons.com/s/twitter/r/2046>`_\n  `RB #2634 <https://rbcommons.com/s/twitter/r/2634>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Filter zinc compilation warnings at the Reporter level\n  `RB #2656 <https://rbcommons.com/s/twitter/r/2656>`_\n\n* Update to sbt 0.13.9.\n  `RB #2629 <https://rbcommons.com/s/twitter/r/2629>`_\n\n* Speeding up jvm-platform-validate step.\n  `Issue #1972 <https://github.com/pantsbuild/pants/issues/1972>`_\n  `RB #2626 <https://rbcommons.com/s/twitter/r/2626>`_\n\n* Added test that failed HTTP responses do not raise exceptions in artifact cache\n  `RB #2624 <https://rbcommons.com/s/twitter/r/2624>`_\n  `RB #2644 <https://rbcommons.com/s/twitter/r/2644>`_\n\n* Tweak to option default extraction for help display.\n  `RB #2640 <https://rbcommons.com/s/twitter/r/2640>`_\n\n* A few small install doc fixes.\n  `RB #2638 <https://rbcommons.com/s/twitter/r/2638>`_\n\n* Detect new package when doing ownership checks.\n  `RB #2637 <https://rbcommons.com/s/twitter/r/2637>`_\n\n* Use os.path.realpath on test tmp dirs to appease OSX.\n  `RB #2635 <https://rbcommons.com/s/twitter/r/2635>`_\n\n* Update the pants install documentation. #docfixit\n  `RB #2631 <https://rbcommons.com/s/twitter/r/2631>`_\n\n0.0.42 (8/14/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis was #docfixit week, so the release contains more doc and help improvements than usual.\nThanks in particular to Benjy for continued `./pants help` polish!\n\nThis release also add support for golang in the `contrib/go` package. Thanks to Cody Gibb and\nJohn Sirois for that work.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Elevate the pants version to a first class option\n  `RB #2627 <https://rbcommons.com/s/twitter/r/2627>`_\n\n* Support pants plugin resolution for easier inclusion of published plugins\n  `RB #2615 <https://rbcommons.com/s/twitter/r/2615>`_\n  `RB #2622 <https://rbcommons.com/s/twitter/r/2622>`_\n\n* Pin pex==1.0.3, alpha-sort & remove line breaks\n  `RB #2598 <https://rbcommons.com/s/twitter/r/2598>`_\n  `RB #2596 <https://rbcommons.com/s/twitter/r/2596>`_\n\n* Moved classifier from IvyArtifact to IvyModuleRef\n  `RB #2579 <https://rbcommons.com/s/twitter/r/2579>`_\n\nBugfixes\n~~~~~~~~\n\n* Ignore \'NonfatalArtifactCacheError\' when calling the artifact cache in the background\n  `RB #2624 <https://rbcommons.com/s/twitter/r/2624>`_\n\n* Re-Add debug option to benchmark run task, complain on no jvm targets, add test\n  `RB #2619 <https://rbcommons.com/s/twitter/r/2619>`_\n\n* Fixed what_changed for removed files\n  `RB #2589 <https://rbcommons.com/s/twitter/r/2589>`_\n\n* Disable jvm-platform-analysis by default\n  `Issue #1972 <https://github.com/pantsbuild/pants/issues/1972>`_\n  `RB #2618 <https://rbcommons.com/s/twitter/r/2618>`_\n\n* Fix ./pants help_advanced\n  `RB #2616 <https://rbcommons.com/s/twitter/r/2616>`_\n\n* Fix some more missing globs in build-file-rev mode.\n  `RB #2591 <https://rbcommons.com/s/twitter/r/2591>`_\n\n* Make jvm bundles output globs in filedeps with --globs.\n  `RB #2583 <https://rbcommons.com/s/twitter/r/2583>`_\n\n* Fix more realpath issues\n  `Issue #1933 <https://github.com/pantsbuild/pants/issues/1933>`_\n  `RB #2582 <https://rbcommons.com/s/twitter/r/2582>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Allow plaintext-reporter to be able to respect a task\'s --level and --colors options.\n  `RB #2580 <https://rbcommons.com/s/twitter/r/2580>`_\n  `RB #2614 <https://rbcommons.com/s/twitter/r/2614>`_\n\n* contrib/go: Support for Go\n  `RB #2544 <https://rbcommons.com/s/twitter/r/2544>`_\n\n* contrib/go: Setup a release sdist\n  `RB #2609 <https://rbcommons.com/s/twitter/r/2609>`_\n\n* contrib/go: Remote library support\n  `RB #2611 <https://rbcommons.com/s/twitter/r/2611>`_\n  `RB #2623 <https://rbcommons.com/s/twitter/r/2623>`_\n\n* contrib/go: Introduce GoDistribution\n  `RB #2595 <https://rbcommons.com/s/twitter/r/2595>`_\n\n* contrib/go: Integrate GoDistribution with GoTask\n  `RB #2600 <https://rbcommons.com/s/twitter/r/2600>`_\n\n* Add support for android compilation with contrib/scrooge\n  `RB #2553 <https://rbcommons.com/s/twitter/r/2553>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Added more testimonials to the Powered By page. #docfixit\n  `RB #2625 <https://rbcommons.com/s/twitter/r/2625>`_\n\n* Fingerprint more task options; particularly scalastyle configs\n  `RB #2628 <https://rbcommons.com/s/twitter/r/2628>`_\n\n* Fingerprint jvm tools task options by default\n  `RB #2620 <https://rbcommons.com/s/twitter/r/2620>`_\n\n* Make most compile-related options advanced. #docfixit\n  `RB #2617 <https://rbcommons.com/s/twitter/r/2617>`_\n\n* Make almost all global options advanced. #docfixit\n  `RB #2602 <https://rbcommons.com/s/twitter/r/2602>`_\n\n* Improve cmd-line help output. #docfixit\n  `RB #2599 <https://rbcommons.com/s/twitter/r/2599>`_\n\n* Default `-Dscala.usejavacp=true` for ScalaRepl.\n  `RB #2613 <https://rbcommons.com/s/twitter/r/2613>`_\n\n* Additional Option details for the Task developers guide. #docfixit\n  `RB #2594 <https://rbcommons.com/s/twitter/r/2594>`_\n  `RB #2612 <https://rbcommons.com/s/twitter/r/2612>`_\n\n* Improve subsystem testing support in subsystem_util.\n  `RB #2603 <https://rbcommons.com/s/twitter/r/2603>`_\n\n* Cleanups to the tasks developer\'s guide #docfixit\n  `RB #2594 <https://rbcommons.com/s/twitter/r/2594>`_\n\n* Add the optionable class to ScopeInfo. #docfixit\n  `RB #2588 <https://rbcommons.com/s/twitter/r/2588>`_\n\n* Add `pants_plugin` and `contrib_plugin` targets.\n  `RB #2615 <https://rbcommons.com/s/twitter/r/2615>`_\n\n0.0.41 (8/7/2015)\n-----------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nConfiguration for specifying scala/java compilation using zinc has\nchanged in this release.\n\nYou may need to combine `[compile.zinc-java]` and `[compile.scala]`\ninto the new section `[compile.zinc]`\n\nThe `migrate_config` tool will help you migrate your pants.ini settings\nfor this new release.  Download the pants source code and run:\n\n.. code::\n\n  ./pants run migrations/options/src/python:migrate_config --  <path to your pants.ini>\n\n\nAPI Changes\n~~~~~~~~~~~\n\n* Upgrade pex to 1.0.2.\n  `RB #2571 <https://rbcommons.com/s/twitter/r/2571>`_\n\n\nBugfixes\n~~~~~~~~\n\n* Fix ApacheThriftGen chroot normalization scope.\n  `RB #2568 <https://rbcommons.com/s/twitter/r/2568>`_\n\n* Fix crasher when no jvm_options are set\n  `RB #2578 <https://rbcommons.com/s/twitter/r/2578>`_\n\n* Handle recursive globs with build-file-rev\n  `RB #2572 <https://rbcommons.com/s/twitter/r/2572>`_\n\n* Fixup PythonTask chroot caching.\n  `RB #2567 <https://rbcommons.com/s/twitter/r/2567>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add "omnivorous" ZincCompile to consume both java and scala sources\n  `RB #2561 <https://rbcommons.com/s/twitter/r/2561>`_\n\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Do fewer classpath calculations in `junit_run`.\n  `RB #2576 <https://rbcommons.com/s/twitter/r/2576>`_\n\n* fix misc ws issues\n  `RB #2564 <https://rbcommons.com/s/twitter/r/2564>`_\n  `RB #2557 <https://rbcommons.com/s/twitter/r/2557>`_\n\n* Resurrect the --[no-]lock global flag\n  `RB #2563 <https://rbcommons.com/s/twitter/r/2563>`_\n\n* Avoid caching volatile ~/.cache/pants/stats dir.\n  `RB #2574 <https://rbcommons.com/s/twitter/r/2574>`_\n\n* remove unused imports\n  `RB #2556 <https://rbcommons.com/s/twitter/r/2556>`_\n\n* Moved logic which validates jvm platform dependencies.\n  `RB #2565 <https://rbcommons.com/s/twitter/r/2565>`_\n\n* Bypass the pip cache when testing released sdists.\n  `RB #2555 <https://rbcommons.com/s/twitter/r/2555>`_\n\n* Add an affordance for 1 flag implying another.\n  `RB #2562 <https://rbcommons.com/s/twitter/r/2562>`_\n\n* Make artifact cache `max-entries-per-target` option name match its behaviour\n  `RB #2550 <https://rbcommons.com/s/twitter/r/2550>`_\n\n* Improve stats upload.\n  `RB #2554 <https://rbcommons.com/s/twitter/r/2554>`_\n\n\n0.0.40 (7/31/2015)\n-------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThe apache thrift gen for java code now runs in `-strict` mode by default, requiring\nall struct fields declare a field id.  You can use the following configuration in\npants.ini to retain the old default behavior and turn strict checking off:\n\n.. code::\n\n  [gen.thrift]\n  strict: False\n\nThe psutil dependency used by pants has been upgraded to 3.1.1. Supporting eggs have been uploaded\nto https://github.com/pantsbuild/cheeseshop/tree/gh-pages/third_party/python/dist. *Please note*\nthat beyond this update, no further binary dependency updates will be provided at this location.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Integrate the Android SDK, android-library\n  `RB #2528 <https://rbcommons.com/s/twitter/r/2528>`_\n\nBugfixes\n~~~~~~~~\n\n* Guard against NoSuchProcess in the public API.\n  `RB #2551 <https://rbcommons.com/s/twitter/r/2551>`_\n\n* Fixup psutil.Process attribute accesses.\n  `RB #2549 <https://rbcommons.com/s/twitter/r/2549>`_\n\n* Removes type=Option.list from --compile-jvm-args option and --compile-scala-plugins\n  `RB #2536 <https://rbcommons.com/s/twitter/r/2536>`_\n  `RB #2547 <https://rbcommons.com/s/twitter/r/2547>`_\n\n* Prevent nailgun on nailgun violence when using symlinked java paths\n  `RB #2538 <https://rbcommons.com/s/twitter/r/2538>`_\n\n* Declaring product_types for simple_codegen_task.\n  `RB #2540 <https://rbcommons.com/s/twitter/r/2540>`_\n\n* Fix straggler usage of legacy psutil form\n  `RB #2546 <https://rbcommons.com/s/twitter/r/2546>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Added JvmPlatform subsystem and added platform arg to JvmTarget.\n  `RB #2494 <https://rbcommons.com/s/twitter/r/2494>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Resolve targets before creating PayloadField\n  `RB #2496 <https://rbcommons.com/s/twitter/r/2496>`_\n  `RB #2536 <https://rbcommons.com/s/twitter/r/2536>`_\n\n* Upgrade psutil to 3.1.1\n  `RB #2543 <https://rbcommons.com/s/twitter/r/2543>`_\n\n* Move thrift utils only used by scrooge to contrib/scrooge.\n  `RB #2535 <https://rbcommons.com/s/twitter/r/2535>`_\n\n* docs: add link to slackin self-invite\n  `RB #2537 <https://rbcommons.com/s/twitter/r/2537>`_\n\n* Add Clover Health to the Powered By page\n  `RB #2539 <https://rbcommons.com/s/twitter/r/2539>`_\n\n* Add Powered By page\n  `RB #2532 <https://rbcommons.com/s/twitter/r/2532>`_\n\n* Create test for java_antlr_library\n  `RB #2504 <https://rbcommons.com/s/twitter/r/2504>`_\n\n* Migrate ApacheThriftGen to SimpleCodegenTask.\n  `RB #2534 <https://rbcommons.com/s/twitter/r/2534>`_\n\n* Covert RagelGen to SimpleCodeGen.\n  `RB #2531 <https://rbcommons.com/s/twitter/r/2531>`_\n\n* Shade the Checkstyle task tool jar.\n  `RB #2533 <https://rbcommons.com/s/twitter/r/2533>`_\n\n* Support eggs for setuptools and wheel.\n  `RB #2529 <https://rbcommons.com/s/twitter/r/2529>`_\n\n0.0.39 (7/23/2015)\n------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Disallow jar_library targets without jars\n  `RB #2519 <https://rbcommons.com/s/twitter/r/2519>`_\n\nBugfixes\n~~~~~~~~\n\n* Fixup PythonChroot to ignore synthetic targets.\n  `RB #2523 <https://rbcommons.com/s/twitter/r/2523>`_\n\n* Exclude provides clauses regardless of soft_excludes\n  `RB #2524 <https://rbcommons.com/s/twitter/r/2524>`_\n\n* Fixed exclude id when name is None + added a test for excludes by just an org #1857\n  `RB #2518 <https://rbcommons.com/s/twitter/r/2518>`_\n\n* Fixup SourceRoot to handle the buildroot.\n  `RB #2514 <https://rbcommons.com/s/twitter/r/2514>`_\n\n* Fixup SetupPy handling of exported thrift.\n  `RB #2511 <https://rbcommons.com/s/twitter/r/2511>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Invalidate tasks based on BinaryUtil.version.\n  `RB #2516 <https://rbcommons.com/s/twitter/r/2516>`_\n\n* Remove local cache files\n  `Issue #1762 <https://github.com/pantsbuild/pants/issues/1762>`_\n  `RB #2506 <https://rbcommons.com/s/twitter/r/2506>`_\n\n* Option to expose intransitive target dependencies for the dependencies goal\n  `RB #2503 <https://rbcommons.com/s/twitter/r/2503>`_\n\n* Introduce Subsystem dependencies.\n  `RB #2509 <https://rbcommons.com/s/twitter/r/2509>`_\n  `RB #2515 <https://rbcommons.com/s/twitter/r/2515>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Increase robustness of ProcessManager.terminate() in the face of zombies.\n  `RB #2513 <https://rbcommons.com/s/twitter/r/2513>`_\n\n* A global isort fix.\n  `RB #2510 <https://rbcommons.com/s/twitter/r/2510>`_\n\n0.0.38 (7/21/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nA quick hotfix release to pick up a fix related to incorrectly specified scala targets.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove the with_description method from target.\n  `RB #2507 <https://rbcommons.com/s/twitter/r/2507>`_\n\nBugfixes\n~~~~~~~~\n\n* Handle the case where there are no classes for a target.\n  `RB #2489 <https://rbcommons.com/s/twitter/r/2489>`_\n\nNew Features\n~~~~~~~~~~~~\n\nNone.\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Refactor AntlrGen to use SimpleCodeGen.\n  `RB #2487 <https://rbcommons.com/s/twitter/r/2487>`_\n\n0.0.37 (7/20/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is the regularly scheduled release for 7/17/2015 (slightly behind schedule!)\n\nAPI Changes\n~~~~~~~~~~~\n\n* Unified support for process management, to prepare for a new daemon.\n  `RB #2490 <https://rbcommons.com/s/twitter/r/2490>`_\n\n* An iterator over Option registration args.\n  `RB #2478 <https://rbcommons.com/s/twitter/r/2478>`_\n\n* An iterator over OptionValueContainer keys.\n  `RB #2472 <https://rbcommons.com/s/twitter/r/2472>`_\n\nBugfixes\n~~~~~~~~\n\n* Correctly classify files as resources or classes\n  `RB #2488 <https://rbcommons.com/s/twitter/r/2488>`_\n\n* Fix test bugs introduced during the target cache refactor.\n  `RB #2483 <https://rbcommons.com/s/twitter/r/2483>`_\n\n* Don\'t explicitly enumerate goal scopes: makes life easier for the IntelliJ pants plugin.\n  `RB #2500 <https://rbcommons.com/s/twitter/r/2500>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Switch almost all python tasks over to use cached chroots.\n  `RB #2486 <https://rbcommons.com/s/twitter/r/2486>`_\n\n* Add invalidation report flag to reporting subsystem.\n  `RB #2448 <https://rbcommons.com/s/twitter/r/2448>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Add a note about the pantsbuild slack team.\n  `RB #2491 <https://rbcommons.com/s/twitter/r/2491>`_\n\n* Upgrade pantsbuild/pants to apache thrift 0.9.2.\n  `RB #2484 <https://rbcommons.com/s/twitter/r/2484>`_\n\n* Remove unused --lang option from protobuf_gen.py\n  `RB #2485 <https://rbcommons.com/s/twitter/r/2485>`_\n\n* Update release docs to recommend both server-login and pypi sections.\n  `RB #2481 <https://rbcommons.com/s/twitter/r/2481>`_\n\n0.0.36 (7/14/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThis is a quick release following up on 0.0.35 to make available internal API changes made during options refactoring.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Improved artifact cache usability by allowing tasks to opt-in to a mode that generates and then caches a directory for each target.\n  `RB #2449 <https://rbcommons.com/s/twitter/r/2449>`_\n  `RB #2471 <https://rbcommons.com/s/twitter/r/2471>`_\n\n* Re-compute the classpath for each batch of junit tests.\n  `RB #2454 <https://rbcommons.com/s/twitter/r/2454>`_\n\nBugfixes\n~~~~~~~~\n\n* Stops unit tests in test_simple_codegen_task.py in master from failing.\n  `RB #2469 <https://rbcommons.com/s/twitter/r/2469>`_\n\n* Helpful error message when \'sources\' is specified for jvm_binary.\n  `Issue #871 <https://github.com/pantsbuild/pants/issues/871>`_\n  `RB #2455 <https://rbcommons.com/s/twitter/r/2455>`_\n\n* Fix failure in test_execute_fail under python>=2.7.10 for test_simple_codegen_task.py.\n  `RB #2461 <https://rbcommons.com/s/twitter/r/2461>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Support short-form task subsystem flags.\n  `RB #2466 <https://rbcommons.com/s/twitter/r/2466>`_\n\n* Reimplement help formatting to improve clarity of both the code and output.\n  `RB #2458 <https://rbcommons.com/s/twitter/r/2458>`_\n  `RB #2464 <https://rbcommons.com/s/twitter/r/2464>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Visual docsite changes\n  `RB #2463 <https://rbcommons.com/s/twitter/r/2463>`_\n\n* Fix migrate_config to detect explicit [DEFAULT]s.\n  `RB #2465 <https://rbcommons.com/s/twitter/r/2465>`_\n\n0.0.35 (7/10/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nWith this release, if you use the\n`isolated jvm compile strategy <https://github.com/pantsbuild/pants/blob/0acdf8d8ab49a0a6bdf5084a99e0c1bca0231cf6/pants.ini.isolated>`_,\njava annotation processers that emit java sourcefiles or classfiles will be\nhandled correctly and the generated code will be bundled appropriately in jars.\nIn particular, this makes libraries like Google\'s AutoValue useable in a pants\nbuild. See: `RB #2451 <https://rbcommons.com/s/twitter/r/2451>`_.\n\nAPI Changes\n~~~~~~~~~~~\n\n* Deprecate with_description.\n  `RB #2444 <https://rbcommons.com/s/twitter/r/2444>`_\n\nBugfixes\n~~~~~~~~\n\n* Fixup BuildFile must_exist logic.\n  `RB #2441 <https://rbcommons.com/s/twitter/r/2441>`_\n\n* Upgrade to pex 1.0.1.\n  `Issue #1658 <https://github.com/pantsbuild/pants/issues/1658>`_\n  `RB #2438 <https://rbcommons.com/s/twitter/r/2438>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add an option --main to the run.jvm task to override the specification of \'main\' on a jvm_binary() target.\n  `RB #2442 <https://rbcommons.com/s/twitter/r/2442>`_\n\n* Add jvm_options for thrift-linter.\n  `RB #2445 <https://rbcommons.com/s/twitter/r/2445>`_\n\n* Added cwd argument to allow JavaTest targets to require particular working directories.\n  `RB #2440 <https://rbcommons.com/s/twitter/r/2440>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Record all output classes for the jvm isolated compile strategy.\n  `RB #2451 <https://rbcommons.com/s/twitter/r/2451>`_\n\n* Robustify the pants ivy configuration.\n  `Issue #1779 <https://github.com/pantsbuild/pants/issues/1779>`_\n  `RB #2450 <https://rbcommons.com/s/twitter/r/2450>`_\n\n* Some refactoring of global options.\n  `RB #2446 <https://rbcommons.com/s/twitter/r/2446>`_\n\n* Improved error messaging for unknown Target kwargs.\n  `RB #2443 <https://rbcommons.com/s/twitter/r/2443>`_\n\n* Remove Nailgun specific classes from zinc, since pants invokes Main directly.\n  `RB #2439 <https://rbcommons.com/s/twitter/r/2439>`_\n\n0.0.34 (7/6/2015)\n-----------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nConfiguration for specifying cache settings and jvm options for some\ntools have changed in this release.\n\nThe `migrate_config` tool will help you migrate your pants.ini settings\nfor this new release.  Download the pants source code and run:\n\n.. code::\n\n  ./pants run migrations/options/src/python:migrate_config --  <path\n  to your pants.ini>\n\nAPI Changes\n~~~~~~~~~~~\n\n* Added flags for jar sources and javadocs to export goal because Foursquare got rid of ivy goal.\n  `RB #2432 <https://rbcommons.com/s/twitter/r/2432>`_\n\n* A JVM subsystem.\n  `RB #2423 <https://rbcommons.com/s/twitter/r/2423>`_\n\n* An artifact cache subsystem.\n  `RB #2405 <https://rbcommons.com/s/twitter/r/2405>`_\n\nBugfixes\n~~~~~~~~\n\n* Change the xml report to use the fingerprint of the targets, not just their names.\n  `RB #2435 <https://rbcommons.com/s/twitter/r/2435>`_\n\n* Using linear-time BFS to sort targets topologically and group them\n  by the type.\n  `RB #2413 <https://rbcommons.com/s/twitter/r/2413>`_\n\n* Fix isort in git hook context.\n  `RB #2430 <https://rbcommons.com/s/twitter/r/2430>`_\n\n* When using soft-excludes, ignore all target defined excludes\n  `RB #2340 <https://rbcommons.com/s/twitter/r/2340>`_\n\n* Fix bash-completion goal when run from sdist/pex. Also add tests, and beef up ci.sh & release.sh.\n  `RB #2403 <https://rbcommons.com/s/twitter/r/2403>`_\n\n* [junit tool] fix suppress output emits jibberish on console.\n  `Issue #1657 <https://github.com/pantsbuild/pants/issues/1657>`_\n  `RB #2183 <https://rbcommons.com/s/twitter/r/2183>`_\n\n* In junit-runner, fix an NPE in testFailure() for different scenarios\n  `RB #2385 <https://rbcommons.com/s/twitter/r/2385>`_\n  `RB #2398 <https://rbcommons.com/s/twitter/r/2398>`_\n  `RB #2396 <https://rbcommons.com/s/twitter/r/2396>`_\n\n* Scrub timestamp from antlr generated files to have stable fp for cache\n  `RB #2382 <https://rbcommons.com/s/twitter/r/2382>`_\n\n* JVM checkstyle should obey jvm_options\n  `RB #2391 <https://rbcommons.com/s/twitter/r/2391>`_\n\n* Fix bad logger.debug call in artifact_cache.py\n  `RB #2386 <https://rbcommons.com/s/twitter/r/2386>`_\n\n* Fixed a bug where codegen would crash due to a missing flag.\n  `RB #2368 <https://rbcommons.com/s/twitter/r/2368>`_\n\n* Fixup the Git Scm detection of server_url.\n  `RB #2379 <https://rbcommons.com/s/twitter/r/2379>`_\n\n* Repair depmap --graph\n  `RB #2345 <https://rbcommons.com/s/twitter/r/2345>`_\n\nDocumentation\n~~~~~~~~~~~~~\n\n* Documented how to enable caching for tasks.\n  `RB #2420 <https://rbcommons.com/s/twitter/r/2420>`_\n\n* Remove comments that said these classes returned something.\n  `RB #2419 <https://rbcommons.com/s/twitter/r/2419>`_\n\n* Publishing doc fixes\n  `RB #2407 <https://rbcommons.com/s/twitter/r/2407>`_\n\n* Bad rst now fails the MarkdownToHtml task.\n  `RB #2394 <https://rbcommons.com/s/twitter/r/2394>`_\n\n* Add a CONTRIBUTORS maintenance script.\n  `RB #2377 <https://rbcommons.com/s/twitter/r/2377>`_\n  `RB #2378 <https://rbcommons.com/s/twitter/r/2378>`_\n\n* typo in the changelog for 0.0.33 release,  fixed formatting of globs and rglobs\n  `RB #2376 <https://rbcommons.com/s/twitter/r/2376>`_\n\n* Documentation update for debugging a JVM tool\n  `RB #2365 <https://rbcommons.com/s/twitter/r/2365>`_\n\nNew Features\n~~~~~~~~~~~~\n* Add log capture to isolated zinc compiles\n  `RB #2404 <https://rbcommons.com/s/twitter/r/2404>`_\n  `RB #2415 <https://rbcommons.com/s/twitter/r/2415>`_\n\n* Add support for restricting push remotes.\n  `RB #2383 <https://rbcommons.com/s/twitter/r/2383>`_\n\n* Ensure caliper is shaded in bench, add bench desc, use RUN so that output is printed\n  `RB #2353 <https://rbcommons.com/s/twitter/r/2353>`_\n\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Enhance the error output in simple_codegen_task.py when unable to generate target(s)\n  `RB #2427 <https://rbcommons.com/s/twitter/r/2427>`_\n\n* Add a get_rank() method to OptionValueContainer.\n  `RB #2431 <https://rbcommons.com/s/twitter/r/2431>`_\n\n* Pass jvm_options to scalastyle\n  `RB #2428 <https://rbcommons.com/s/twitter/r/2428>`_\n\n* Kill custom repos and cross-platform pex setup.\n  `RB #2402 <https://rbcommons.com/s/twitter/r/2402>`_\n\n* Add debugging for problem with invalidation and using stale report file in ivy resolve.\n  `Issue #1747 <https://github.com/pantsbuild/pants/issues/1747>`_\n  `RB #2424 <https://rbcommons.com/s/twitter/r/2424>`_\n\n* Enabled caching for scalastyle and checkstyle\n  `RB #2416 <https://rbcommons.com/s/twitter/r/2416>`_\n  `RB #2414 <https://rbcommons.com/s/twitter/r/2414>`_\n\n* Make sure all Task mixins are on the left.\n  `RB #2421 <https://rbcommons.com/s/twitter/r/2421>`_\n\n* Adds a more verbose description of tests when running\n  the -per-test-timer command. (Junit)\n  `RB #2418 <https://rbcommons.com/s/twitter/r/2418>`_\n  `RB #2408 <https://rbcommons.com/s/twitter/r/2408>`_\n\n* Re-add support for reading from a local .m2 directory\n  `RB #2409 <https://rbcommons.com/s/twitter/r/2409>`_\n\n* Replace a few references to basestring with six.\n  `RB #2410 <https://rbcommons.com/s/twitter/r/2410>`_\n\n* Promote PANTS_DEV=1 to the only ./pants mode.\n  `RB #2401 <https://rbcommons.com/s/twitter/r/2401>`_\n\n* Add task meter to protoc step in codegen\n  `RB #2392 <https://rbcommons.com/s/twitter/r/2392>`_\n\n* Simplify known scopes computation.\n  `RB #2389 <https://rbcommons.com/s/twitter/r/2389>`_\n\n* Robustify the release process.\n  `RB #2388 <https://rbcommons.com/s/twitter/r/2388>`_\n\n* A common base class for things that can register options.\n  `RB #2387 <https://rbcommons.com/s/twitter/r/2387>`_\n\n* Fixed the error messages in assert_list().\n  `RB #2370 <https://rbcommons.com/s/twitter/r/2370>`_\n\n* Simplify subsystem option scoping.\n  `RB #2380 <https://rbcommons.com/s/twitter/r/2380>`_\n\n0.0.33 (6/13/2015)\n------------------\n\nRelease Notes\n~~~~~~~~~~~~~\n\nThe migrate config tool will help you migrate your pants.ini settings\nfor this new release.  Download the pants source code and run:\n\n.. code::\n\n  ./pants run migrations/options/src/python:migrate_config --  <path\n  to your pants.ini>\n\n\nFolks who use a custom ivysettings.xml but have no ivy.ivy_settings\noption defined in pants.ini pointing to it must now add one like so:\n\n.. code::\n\n  [ivy]\n  ivy_settings: %(pants_supportdir)s/ivy/ivysettings.xml\n\nAPI Changes\n~~~~~~~~~~~\n\n* Removed --project-info flag from depmap goal\n  `RB #2363 <https://rbcommons.com/s/twitter/r/2363>`_\n\n* Deprecate PytestRun env vars.\n  `RB #2299 <https://rbcommons.com/s/twitter/r/2299>`_\n\n* Add Subsystems for options that live outside a single task, use them\n  to replace config settings in pants.ini\n  `RB #2288 <https://rbcommons.com/s/twitter/r/2288>`_\n  `RB #2276 <https://rbcommons.com/s/twitter/r/2276>`_\n  `RB #2226 <https://rbcommons.com/s/twitter/r/2226>`_\n  `RB #2176 <https://rbcommons.com/s/twitter/r/2176>`_\n  `RB #2174 <https://rbcommons.com/s/twitter/r/2174>`_\n  `RB #2139 <https://rbcommons.com/s/twitter/r/2139>`_\n  `RB #2122 <https://rbcommons.com/s/twitter/r/2122>`_\n  `RB #2100 <https://rbcommons.com/s/twitter/r/2100>`_\n  `RB #2081 <https://rbcommons.com/s/twitter/r/2081>`_\n  `RB #2063 <https://rbcommons.com/s/twitter/r/2063>`_\n\n* Read backend and bootstrap BUILD file settings from options instead of config.\n  `RB #2229 <https://rbcommons.com/s/twitter/r/2229>`_\n\n* Migrating internal tools into the pants repo and renaming to org.pantsbuild\n  `RB #2278 <https://rbcommons.com/s/twitter/r/2278>`_\n  `RB #2211 <https://rbcommons.com/s/twitter/r/2211>`_\n  `RB #2207 <https://rbcommons.com/s/twitter/r/2207>`_\n  `RB #2205 <https://rbcommons.com/s/twitter/r/2205>`_\n  `RB #2186 <https://rbcommons.com/s/twitter/r/2186>`_\n  `RB #2195 <https://rbcommons.com/s/twitter/r/2195>`_\n  `RB #2193 <https://rbcommons.com/s/twitter/r/2193>`_\n  `RB #2192 <https://rbcommons.com/s/twitter/r/2192>`_\n  `RB #2191 <https://rbcommons.com/s/twitter/r/2191>`_\n  `RB #2191 <https://rbcommons.com/s/twitter/r/2191>`_\n  `RB #2137 <https://rbcommons.com/s/twitter/r/2137>`_\n  `RB #2071 <https://rbcommons.com/s/twitter/r/2071>`_\n  `RB #2043 <https://rbcommons.com/s/twitter/r/2043>`_\n\n* Kill scala specs support.\n  `RB #2208 <https://rbcommons.com/s/twitter/r/2208>`_\n\n* Use the default ivysettings.xml provided by ivy.\n  `RB #2204 <https://rbcommons.com/s/twitter/r/2204>`_\n\n* Eliminate the globs.__sub__ use in option package.\n  `RB #2082 <https://rbcommons.com/s/twitter/r/2082>`_\n  `RB #2197 <https://rbcommons.com/s/twitter/r/2197>`_\n\n* Kill obsolete global publish.properties file.\n  `RB #994 <https://rbcommons.com/s/twitter/r/994>`_\n  `RB #2069 <https://rbcommons.com/s/twitter/r/2069>`_\n\n* Upgrade zinc to latest for perf wins.\n  `RB #2355 <https://rbcommons.com/s/twitter/r/2355>`_\n  `RB #2194 <https://rbcommons.com/s/twitter/r/2194>`_\n  `RB #2168 <https://rbcommons.com/s/twitter/r/2168>`_\n  `RB #2154 <https://rbcommons.com/s/twitter/r/2154>`_\n  `RB #2154 <https://rbcommons.com/s/twitter/r/2154>`_\n  `RB #2149 <https://rbcommons.com/s/twitter/r/2149>`_\n  `RB #2125 <https://rbcommons.com/s/twitter/r/2125>`_\n\n* Migrate jar_publish config scope.\n  `RB #2175 <https://rbcommons.com/s/twitter/r/2175>`_\n\n* Add a version number to the export format and a page with some documentation.\n  `RB #2162 <https://rbcommons.com/s/twitter/r/2162>`_\n\n* Make exclude_target_regexp option recursive\n  `RB #2136 <https://rbcommons.com/s/twitter/r/2136>`_\n\n* Kill pantsbuild dependence on maven.twttr.com.\n  `RB #2019 <https://rbcommons.com/s/twitter/r/2019>`_\n\n* Fold PythonTestBuilder into the PytestRun task.\n  `RB #1993 <https://rbcommons.com/s/twitter/r/1993>`_\n\nBugfixes\n~~~~~~~~\n\n* Fixed errors in how arguments are passed to wire_gen.\n  `RB #2354 <https://rbcommons.com/s/twitter/r/2354>`_\n\n* Compute exclude_patterns first when unpacking jars\n  `RB #2352 <https://rbcommons.com/s/twitter/r/2352>`_\n\n* Add INDEX.LIST to as a Skip JarRule when creating a fat jar\n  `RB #2342 <https://rbcommons.com/s/twitter/r/2342>`_\n\n* wrapped-globs: make rglobs output git-compatible\n  `RB #2332 <https://rbcommons.com/s/twitter/r/2332>`_\n\n* Add a coherent error message when scrooge has no sources.\n  `RB #2329 <https://rbcommons.com/s/twitter/r/2329>`_\n\n* Only run junit when there are junit_test targets in the graph.\n  `RB #2291 <https://rbcommons.com/s/twitter/r/2291>`_\n\n* Fix bootstrap local cache.\n  `RB #2336 <https://rbcommons.com/s/twitter/r/2336>`_\n\n* Added a hash to a jar name for a bootstrapped jvm tool\n  `RB #2334 <https://rbcommons.com/s/twitter/r/2334>`_\n\n* Raise TaskError to exit non-zero if jar-tool fails\n  `RB #2150 <https://rbcommons.com/s/twitter/r/2150>`_\n\n* Fix java zinc isolated compile analysis corruption described github issue #1626\n  `RB #2325 <https://rbcommons.com/s/twitter/r/2325>`_\n\n* Upstream analysis fix\n  `RB #2312 <https://rbcommons.com/s/twitter/r/2312>`_\n\n* Two changes that affect invalidation and artifact caching.\n  `RB #2269 <https://rbcommons.com/s/twitter/r/2269>`_\n\n* Add java_thrift_library fingerprint strategy\n  `RB #2265 <https://rbcommons.com/s/twitter/r/2265>`_\n\n* Moved creation of per test data to testStarted method.\n  `RB #2257 <https://rbcommons.com/s/twitter/r/2257>`_\n\n* Updated zinc to use sbt 0.13.8 and new java compilers that provide a proper log level with their output.\n  `RB #2248 <https://rbcommons.com/s/twitter/r/2248>`_\n\n* Apply excludes consistently across classpaths\n  `RB #2247 <https://rbcommons.com/s/twitter/r/2247>`_\n\n* Put all extra classpath elements (e.g., plugins) at the end (scala compile)\n  `RB #2210 <https://rbcommons.com/s/twitter/r/2210>`_\n\n* Fix missing import in git.py\n  `RB #2202 <https://rbcommons.com/s/twitter/r/2202>`_\n\n* Move a comment to work around a pytest bug.\n  `RB #2201 <https://rbcommons.com/s/twitter/r/2201>`_\n\n* More fixes for working with classifiers on jars.\n  `Issue #1489 <https://github.com/pantsbuild/pants/issues/1489>`_\n  `RB #2163 <https://rbcommons.com/s/twitter/r/2163>`_\n\n* Have ConsoleRunner halt(1) on exit(x)\n  `RB #2180 <https://rbcommons.com/s/twitter/r/2180>`_\n\n* Fix scm_build_file in symlinked directories\n  `RB #2152 <https://rbcommons.com/s/twitter/r/2152>`_\n  `RB #2157 <https://rbcommons.com/s/twitter/r/2157>`_\n\n* Added support for the ivy cache being under a symlink\'ed dir\n  `RB #2085 <https://rbcommons.com/s/twitter/r/2085>`_\n  `RB #2129 <https://rbcommons.com/s/twitter/r/2129>`_\n  `RB #2148 <https://rbcommons.com/s/twitter/r/2148>`_\n\n* Make subclasses of ChangedTargetTask respect spec_excludes\n  `RB #2146 <https://rbcommons.com/s/twitter/r/2146>`_\n\n* propagate keyboard interrupts from worker threads\n  `RB #2143 <https://rbcommons.com/s/twitter/r/2143>`_\n\n* Only add resources to the relevant target\n  `RB #2103 <https://rbcommons.com/s/twitter/r/2103>`_\n  `RB #2130 <https://rbcommons.com/s/twitter/r/2130>`_\n\n* Cleanup analysis left behind from failed isolation compiles\n  `RB #2127 <https://rbcommons.com/s/twitter/r/2127>`_\n\n* test glob operators, fix glob + error\n  `RB #2104 <https://rbcommons.com/s/twitter/r/2104>`_\n\n* Wrap lock around nailgun spawning to protect against worker threads racing to spawn servers\n  `RB #2102 <https://rbcommons.com/s/twitter/r/2102>`_\n\n* Force some files to be treated as binary.\n  `RB #2099 <https://rbcommons.com/s/twitter/r/2099>`_\n\n* Convert JarRule and JarRules to use Payload to help fingerprint its configuration\n  `RB #2096 <https://rbcommons.com/s/twitter/r/2096>`_\n\n* Fix `./pants server` output\n  `RB #2067 <https://rbcommons.com/s/twitter/r/2067>`_\n\n* Fix issue with isolated strategy and sources owned by multiple targets\n  `RB #2061 <https://rbcommons.com/s/twitter/r/2061>`_\n\n* Handle broken resource mapping files (by throwing exceptions).\n  `RB #2038 <https://rbcommons.com/s/twitter/r/2038>`_\n\n* Change subproc sigint handler to exit more cleanly\n  `RB #2024 <https://rbcommons.com/s/twitter/r/2024>`_\n\n* Include classifier in JarDependency equality / hashing\n  `RB #2029 <https://rbcommons.com/s/twitter/r/2029>`_\n\n* Migrating more data to payload fields in jvm_app and jvm_binary targets\n  `RB #2011 <https://rbcommons.com/s/twitter/r/2011>`_\n\n* Fix ivy_resolve message: Missing expected ivy output file .../.ivy2/pants/internal-...-default.xml\n  `RB #2015 <https://rbcommons.com/s/twitter/r/2015>`_\n\n* Fix ignored invalidation data in ScalaCompile\n  `RB #2018 <https://rbcommons.com/s/twitter/r/2018>`_\n\n* Don\'t specify the jmake depfile if it doesn\'t exist\n  `RB #2009 <https://rbcommons.com/s/twitter/r/2009>`_\n  `RB #2012 <https://rbcommons.com/s/twitter/r/2012>`_\n\n* Force java generation on for protobuf_gen, get rid of spurious warning\n  `RB #1994 <https://rbcommons.com/s/twitter/r/1994>`_\n\n* Fix typo in ragel-gen entries (migrate-config)\n  `RB #1995 <https://rbcommons.com/s/twitter/r/1995>`_\n\n* Fix include dependees options.\n  `RB #1760 <https://rbcommons.com/s/twitter/r/1760>`_\n\n\nDocumentation\n~~~~~~~~~~~~~\n\n* Be explicit that pants requires python 2.7.x to run.\n  `RB #2343 <https://rbcommons.com/s/twitter/r/2343>`_\n\n* Update documentation on how to develop and document a JVM tool used by Pants\n  `RB #2318 <https://rbcommons.com/s/twitter/r/2318>`_\n\n* Updates to changelog since 0.0.32 in preparation for next release.\n  `RB #2294 <https://rbcommons.com/s/twitter/r/2294>`_\n\n* Document the pantsbuild jvm tool release process.\n  `RB #2289 <https://rbcommons.com/s/twitter/r/2289>`_\n\n* Fix publishing docs for new \'publish.jar\' syntax\n  `RB #2255 <https://rbcommons.com/s/twitter/r/2255>`_\n\n* Example configuration for the isolated strategy.\n  `RB #2185 <https://rbcommons.com/s/twitter/r/2185>`_\n\n* doc: uploading timing stats\n  `RB #1700 <https://rbcommons.com/s/twitter/r/1700>`_\n\n* Add robots.txt to exclude crawlers from walking a \'staging\' test publishing dir\n  `RB #2072 <https://rbcommons.com/s/twitter/r/2072>`_\n\n* Add a note indicating that pants bootstrap requires a compiler\n  `RB #2057 <https://rbcommons.com/s/twitter/r/2057>`_\n\n* Fix docs to mention automatic excludes.\n  `RB #2014 <https://rbcommons.com/s/twitter/r/2014>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Add a global --tag option to filter targets based on their tags.\n  `RB #2362 <https://rbcommons.com/s/twitter/r/2362/>`_\n\n* Add support for ServiceLoader service providers.\n  `RB #2331 <https://rbcommons.com/s/twitter/r/2331>`_\n\n* Implemented isolated code-generation strategy for simple_codegen_task.\n  `RB #2322 <https://rbcommons.com/s/twitter/r/2322>`_\n\n* Add options for specifying python cache dirs.\n  `RB #2320 <https://rbcommons.com/s/twitter/r/2320>`_\n\n* bash autocompletion support\n  `RB #2307 <https://rbcommons.com/s/twitter/r/2307>`_\n  `RB #2326 <https://rbcommons.com/s/twitter/r/2326>`_\n\n* Invoke jvm doc tools via java.\n  `RB #2313 <https://rbcommons.com/s/twitter/r/2313>`_\n\n* Add -log-filter option to the zinc task\n  `RB #2315 <https://rbcommons.com/s/twitter/r/2315>`_\n\n* Adds a product to bundle_create\n  `RB #2254 <https://rbcommons.com/s/twitter/r/2254>`_\n\n* Add flag to disable automatic excludes\n  `RB #2252 <https://rbcommons.com/s/twitter/r/2252>`_\n\n* Find java distributions in well known locations.\n  `RB #2242 <https://rbcommons.com/s/twitter/r/2242>`_\n\n* Added information about excludes to export goal\n  `RB #2238 <https://rbcommons.com/s/twitter/r/2238>`_\n\n* In process java compilation in Zinc #1555\n  `RB #2206 <https://rbcommons.com/s/twitter/r/2206>`_\n\n* Add support for extra publication metadata.\n  `RB #2184 <https://rbcommons.com/s/twitter/r/2184>`_\n  `RB #2240 <https://rbcommons.com/s/twitter/r/2240>`_\n\n* Extract the android plugin as an sdist.\n  `RB #2249 <https://rbcommons.com/s/twitter/r/2249>`_\n\n* Adds optional output during zinc compilation.\n  `RB #2233 <https://rbcommons.com/s/twitter/r/2233>`_\n\n* Jvm Tools release process\n  `RB #2292 <https://rbcommons.com/s/twitter/r/2292>`_\n\n* Make it possible to create xml reports and output to console at the same time from ConsoleRunner.\n  `RB #2183 <https://rbcommons.com/s/twitter/r/2183>`_\n\n* Adding a product to binary_create so that we can depend on it in an external plugin.\n  `RB #2172 <https://rbcommons.com/s/twitter/r/2172>`_\n\n* Publishing to Maven Central\n  `RB #2068 <https://rbcommons.com/s/twitter/r/2068>`_\n  `RB #2188 <https://rbcommons.com/s/twitter/r/2188>`_\n\n* Provide global option to look up BUILD files in git history\n  `RB #2121 <https://rbcommons.com/s/twitter/r/2121>`_\n  `RB #2164 <https://rbcommons.com/s/twitter/r/2164>`_\n\n* Compile Java with Zinc\n  `RB #2156 <https://rbcommons.com/s/twitter/r/2156>`_\n\n* Add BuildFileManipulator implementation and tests to contrib\n  `RB #977 <https://rbcommons.com/s/twitter/r/977>`_\n\n* Add option to suppress printing the changelog during publishing\n  `RB #2140 <https://rbcommons.com/s/twitter/r/2140>`_\n\n* Filtering by targets\' tags\n  `RB #2106 <https://rbcommons.com/s/twitter/r/2106>`_\n\n* Adds the ability to specify explicit fields in MANIFEST.MF in a jvm_binary target.\n  `RB #2199 <https://rbcommons.com/s/twitter/r/2199>`_\n  `RB #2084 <https://rbcommons.com/s/twitter/r/2084>`_\n  `RB #2119 <https://rbcommons.com/s/twitter/r/2119>`_\n  `RB #2005 <https://rbcommons.com/s/twitter/r/2005>`_\n\n* Parallelize isolated jvm compile strategy\'s chunk execution.\n  `RB #2109 <https://rbcommons.com/s/twitter/r/2109>`_\n\n* Make test tasks specify which target failed in exception.\n  `RB #2090 <https://rbcommons.com/s/twitter/r/2090>`_\n  `RB #2113 <https://rbcommons.com/s/twitter/r/2113>`_\n  `RB #2112 <https://rbcommons.com/s/twitter/r/2112>`_\n\n* Support glob output in filedeps.\n  `RB #2092 <https://rbcommons.com/s/twitter/r/2092>`_\n\n* Export: support export of sources and globs\n  `RB #2082 <https://rbcommons.com/s/twitter/r/2082>`_\n  `RB #2094 <https://rbcommons.com/s/twitter/r/2094>`_\n\n* Classpath isolation: make ivy resolution locally accurate.\n  `RB #2064 <https://rbcommons.com/s/twitter/r/2064>`_\n\n* Add support for a postscript to jar_publish commit messages.\n  `RB #2070 <https://rbcommons.com/s/twitter/r/2070>`_\n\n* Add optional support for auto-shading jvm tools.\n  `RB #2052 <https://rbcommons.com/s/twitter/r/2052>`_\n  `RB #2073 <https://rbcommons.com/s/twitter/r/2073>`_\n\n* Introduce a jvm binary shader.\n  `RB #2050 <https://rbcommons.com/s/twitter/r/2050>`_\n\n* Open source the spindle plugin for pants into contrib.\n  `RB #2306 <https://rbcommons.com/s/twitter/r/2306>`_\n  `RB #2301 <https://rbcommons.com/s/twitter/r/2301>`_\n  `RB #2304 <https://rbcommons.com/s/twitter/r/2304>`_\n  `RB #2282 <https://rbcommons.com/s/twitter/r/2282>`_\n  `RB #2033 <https://rbcommons.com/s/twitter/r/2033>`_\n\n* Implement an exported ownership model.\n  `RB #2010 <https://rbcommons.com/s/twitter/r/2010>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Support caching chroots for reuse across pants runs.\n  `RB #2349 <https://rbcommons.com/s/twitter/r/2349>`_\n\n* Upgrade RBT to the latest release\n  `RB #2360 <https://rbcommons.com/s/twitter/r/2360>`_\n\n* Make sure arg to logRaw and log are only eval\'ed once. (zinc)\n  `RB #2338 <https://rbcommons.com/s/twitter/r/2338>`_\n\n* Clean up unnecessary code\n  `RB #2339 <https://rbcommons.com/s/twitter/r/2339>`_\n\n* Exclude the com.example org from travis ivy cache.\n  `RB #2344 <https://rbcommons.com/s/twitter/r/2344>`_\n\n* Avoid ivy cache thrash due to ivydata updates.\n  `RB #2333 <https://rbcommons.com/s/twitter/r/2333>`_\n\n* Various refactoring of PythonChroot and related code.\n  `RB #2327 <https://rbcommons.com/s/twitter/r/2327>`_\n\n* Have pytest_run create its chroots via its base class.\n  `RB #2314 <https://rbcommons.com/s/twitter/r/2314>`_\n\n* Add a set of memoization decorators for functions.\n  `RB #2308 <https://rbcommons.com/s/twitter/r/2308>`_\n  `RB #2317 <https://rbcommons.com/s/twitter/r/2317>`_\n\n* Allow jvm tool tests to bootstrap from the artifact cache.\n  `RB #2311 <https://rbcommons.com/s/twitter/r/2311>`_\n\n* Fixed \'has no attribute\' exception + better tests for export goal\n  `RB #2305 <https://rbcommons.com/s/twitter/r/2305>`_\n\n* Refactoring ProtobufGen to use SimpleCodeGen.\n  `RB #2302 <https://rbcommons.com/s/twitter/r/2302>`_\n\n* Refactoring JaxbGen to use SimpleCodeGen.\n  `RB #2303 <https://rbcommons.com/s/twitter/r/2303>`_\n\n* Add pants header to assorted python files\n  `RB #2298 <https://rbcommons.com/s/twitter/r/2298>`_\n\n* Remove unused imports from python files\n  `RB #2295 <https://rbcommons.com/s/twitter/r/2295>`_\n\n* Integrating Patrick\'s SimpleCodegenTask base class with WireGen.\n  `RB #2274 <https://rbcommons.com/s/twitter/r/2274>`_\n\n* Fix bad log statement in junit_run.py.\n  `RB #2290 <https://rbcommons.com/s/twitter/r/2290>`_\n\n* Provide more specific value parsing errors\n  `RB #2283 <https://rbcommons.com/s/twitter/r/2283>`_\n\n* Dry up incremental-compiler dep on sbt-interface.\n  `RB #2279 <https://rbcommons.com/s/twitter/r/2279>`_\n\n* Use BufferedOutputStream in jar-tool\n  `RB #2270 <https://rbcommons.com/s/twitter/r/2270>`_\n\n* Add relative_symlink to dirutil for latest run report\n  `RB #2271 <https://rbcommons.com/s/twitter/r/2271>`_\n\n* Shade zinc.\n  `RB #2268 <https://rbcommons.com/s/twitter/r/2268>`_\n\n* rm Exception.message calls\n  `RB #2245 <https://rbcommons.com/s/twitter/r/2245>`_\n\n* sanity check on generated cobertura xml report\n  `RB #2231 <https://rbcommons.com/s/twitter/r/2231>`_\n\n* [pants/jar] Fix a typo\n  `RB #2230 <https://rbcommons.com/s/twitter/r/2230>`_\n\n* Convert validation.assert_list isinstance checking to be lazy\n  `RB #2228 <https://rbcommons.com/s/twitter/r/2228>`_\n\n* use workunit output for cpp command running\n  `RB #2223 <https://rbcommons.com/s/twitter/r/2223>`_\n\n* Remove all global config state.\n  `RB #2222 <https://rbcommons.com/s/twitter/r/2222>`_\n  `RB #2181 <https://rbncommons.com/s/twitter/r/2181>`_\n  `RB #2160 <https://rbcommons.com/s/twitter/r/2160>`_\n  `RB #2159 <https://rbcommons.com/s/twitter/r/2159>`_\n  `RB #2151 <https://rbcommons.com/s/twitter/r/2151>`_\n  `RB #2142 <https://rbcommons.com/s/twitter/r/2142>`_\n  `RB #2141 <https://rbcommons.com/s/twitter/r/2141>`_\n\n* Make the version of specs in BUILD.tools match the one in 3rdparty/BUILD.\n  `RB #2203 <https://rbcommons.com/s/twitter/r/2203>`_\n\n* Handle warnings in BUILD file context.\n  `RB #2198 <https://rbcommons.com/s/twitter/r/2198>`_\n\n* Replace custom softreference cache with a guava cache.  (zinc)\n  `RB #2190 <https://rbcommons.com/s/twitter/r/2190>`_\n\n* Establish a source_root for pants scala code.\n  `RB #2189 <https://rbcommons.com/s/twitter/r/2189>`_\n\n* Zinc patches to improve roundtrip time\n  `RB #2178 <https://rbcommons.com/s/twitter/r/2178>`_\n\n* cache parsed mustache templates as they are requested\n  `RB #2171 <https://rbcommons.com/s/twitter/r/2171>`_\n\n* memoize linkify to reduce reporting file stat calls\n  `RB #2170 <https://rbcommons.com/s/twitter/r/2170>`_\n\n* Refactor BuildFile and BuildFileAdressMapper\n  `RB #2110 <https://rbcommons.com/s/twitter/r/2110>`_\n\n* fix whitespace in workerpool test, rm unused import\n  `RB #2144 <https://rbcommons.com/s/twitter/r/2144>`_\n\n* Use jvm-compilers as the parent of isolation workunits instead of \'isolation\', add workunits for analysis\n  `RB #2134 <https://rbcommons.com/s/twitter/r/2134>`_\n\n* Improve the error message when a tool fails to bootstrap.\n  `RB #2135 <https://rbcommons.com/s/twitter/r/2135>`_\n\n* Fix rglobs-to-filespec code.\n  `RB #2133 <https://rbcommons.com/s/twitter/r/2133>`_\n\n* Send workunit output to stderr during tests\n  `RB #2108 <https://rbcommons.com/s/twitter/r/2108>`_\n\n* Changes to zinc analysis split/merge test data generation:\n  `RB #2095 <https://rbcommons.com/s/twitter/r/2095>`_\n\n* Add a dummy workunit to the end of the run to print out a timestamp that includes the time spent in the last task.\n  `RB #2054 <https://rbcommons.com/s/twitter/r/2054>`_\n\n* Add \'java-resource\' and \'java-test-resource\' content type for Resources Roots.\n  `RB #2046 <https://rbcommons.com/s/twitter/r/2046>`_\n\n* Upgrade virtualenv from 12.0.7 to 12.1.1.\n  `RB #2047 <https://rbcommons.com/s/twitter/r/2047>`_\n\n* convert all % formatted strings under src/ to str.format format\n  `RB #2042 <https://rbcommons.com/s/twitter/r/2042>`_\n\n* Move overrides for registrations to debug.\n  `RB #2023 <https://rbcommons.com/s/twitter/r/2023>`_\n\n* Split jvm_binary.py into jvm_binary.py and jvm_app.py.\n  `RB #2006 <https://rbcommons.com/s/twitter/r/2006>`_\n\n* Validate analysis earlier, and handle it explicitly\n  `RB #1999 <https://rbcommons.com/s/twitter/r/1999>`_\n\n* Switch to importlib\n  `RB #2003 <https://rbcommons.com/s/twitter/r/2003>`_\n\n* Some refactoring and tidying-up in workunit.\n  `RB #1981 <https://rbcommons.com/s/twitter/r/1981>`_\n\n* Remove virtualenv tarball from CI cache.\n  `RB #2281 <https://rbcommons.com/s/twitter/r/2281>`_\n\n* Moved testing of examples and testprojects to tests\n  `RB #2158 <https://rbcommons.com/s/twitter/r/2158>`_\n\n* Share the python interpreter/egg caches between tests.\n  `RB #2256 <https://rbcommons.com/s/twitter/r/2256>`_\n\n* Add support for python test sharding.\n  `RB #2243 <https://rbcommons.com/s/twitter/r/2243>`_\n\n* Fixup OSX CI breaks.\n  `RB #2241 <https://rbcommons.com/s/twitter/r/2241>`_\n\n* fix test class name c&p error\n  `RB #2227 <https://rbcommons.com/s/twitter/r/2227>`_\n\n* Remove the pytest skip tag for scala publish integration test as it uses --doc-scaladoc-skip\n  `RB #2225 <https://rbcommons.com/s/twitter/r/2225>`_\n\n* integration test for classifiers\n  `RB #2216 <https://rbcommons.com/s/twitter/r/2216>`_\n  `RB #2218 <https://rbcommons.com/s/twitter/r/2218>`_\n  `RB #2232 <https://rbcommons.com/s/twitter/r/2232>`_\n\n* Use 2 IT shards to avoid OSX CI timeouts.\n  `RB #2217 <https://rbcommons.com/s/twitter/r/2217>`_\n\n* Don\'t have JvmToolTaskTestBase require access to "real" option values.\n  `RB #2213 <https://rbcommons.com/s/twitter/r/2213>`_\n\n* There were two test_export_integration.py tests.\n  `RB #2215 <https://rbcommons.com/s/twitter/r/2215>`_\n\n* Do not include integration tests in non-integration tests.\n  `RB #2173 <https://rbcommons.com/s/twitter/r/2173>`_\n\n* Streamline some test setup.\n  `RB #2167 <https://rbcommons.com/s/twitter/r/2167>`_\n\n* Ensure that certain test cleanup always happens, even if setUp fails.\n  `RB #2166 <https://rbcommons.com/s/twitter/r/2166>`_\n\n* Added a test of the bootstrapper logic with no cached bootstrap.jar\n  `RB #2126 <https://rbcommons.com/s/twitter/r/2126>`_\n\n* Remove integration tests from default targets in test BUILD files\n  `RB #2086 <https://rbcommons.com/s/twitter/r/2086>`_\n\n* Cap BootstrapJvmTools mem in JvmToolTaskTestBase.\n  `RB #2077 <https://rbcommons.com/s/twitter/r/2077>`_\n\n* Re-establish no nailguns under TravisCI.\n  `RB #1852 <https://rbcommons.com/s/twitter/r/1852>`_\n  `RB #2065 <https://rbcommons.com/s/twitter/r/2065>`_\n\n* Further cleanup of test context setup.\n  `RB #2053 <https://rbcommons.com/s/twitter/r/2053>`_\n\n* Remove plumbing for custom test config.\n  `RB #2051 <https://rbcommons.com/s/twitter/r/2051>`_\n\n* Use a fake context when testing.\n  `RB #2049 <https://rbcommons.com/s/twitter/r/2049>`_\n\n* Remove old TaskTest base class.\n  `RB #2039 <https://rbcommons.com/s/twitter/r/2039>`_\n  `RB #2031 <https://rbcommons.com/s/twitter/r/2031>`_\n  `RB #2027 <https://rbcommons.com/s/twitter/r/2027>`_\n  `RB #2022 <https://rbcommons.com/s/twitter/r/2022>`_\n  `RB #2017 <https://rbcommons.com/s/twitter/r/2017>`_\n  `RB #2016 <https://rbcommons.com/s/twitter/r/2016>`_\n\n* Refactor com.pants package to org.pantsbuild in examples and testprojects\n  `RB #2037 <https://rbcommons.com/s/twitter/r/2037>`_\n\n* Added a simple \'HelloWorld\' java example.\n  `RB #2028 <https://rbcommons.com/s/twitter/r/2028>`_\n\n* Place the workdir below the pants_workdir\n  `RB #2007 <https://rbcommons.com/s/twitter/r/2007>`_\n\n0.0.32 (3/26/2015)\n------------------\n\nBugfixes\n~~~~~~~~\n\n* Fixup minified_dependencies\n  `Issue #1329 <https://github.com/pantsbuild/pants/issues/1329>`_\n  `RB #1986 <https://rbcommons.com/s/twitter/r/1986>`_\n\n* Don`t mutate options in the linter\n  `RB #1978 <https://rbcommons.com/s/twitter/r/1978>`_\n\n* Fix a bad logic bug in zinc analysis split code\n  `RB #1969 <https://rbcommons.com/s/twitter/r/1969>`_\n\n* always use relpath on --test file args\n  `RB #1976 <https://rbcommons.com/s/twitter/r/1976>`_\n\n* Fixup resources drift in the sdist package\n  `RB #1974 <https://rbcommons.com/s/twitter/r/1974>`_\n\n* Fix publish override flag\n  `Issue #1277 <https://github.com/pantsbuild/pants/issues/1277>`_\n  `RB #1959 <https://rbcommons.com/s/twitter/r/1959>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove open_zip64 in favor of supporting zip64 everywhere\n  `RB #1984 <https://rbcommons.com/s/twitter/r/1984>`_\n\nDocumentation\n~~~~~~~~~~~~~\n\n* rm python_old, an old document\n  `RB #1973 <https://rbcommons.com/s/twitter/r/1973>`_\n\n* Updated ivysettings.xml with comments and commented out local repos\n  `RB #1979 <https://rbcommons.com/s/twitter/r/1979>`_\n\n* Update how to setup proxies in ivy\n  `RB #1975 <https://rbcommons.com/s/twitter/r/1975>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Ignore blank lines and comments in scalastyle excludes file\n  `RB #1971 <https://rbcommons.com/s/twitter/r/1971>`_\n\n* Adding a --test-junit-coverage-jvm-options flag\n  `RB #1968 <https://rbcommons.com/s/twitter/r/1968>`_\n\n* --soft-excludes flag for resolve-ivy\n  `RB #1961 <https://rbcommons.com/s/twitter/r/1961>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Rid pantsbuild.pants of an un-needed antlr dep\n  `RB #1989 <https://rbcommons.com/s/twitter/r/1989>`_\n\n* Kill the BUILD.transitional targets\n  `Issue #1126 <https://github.com/pantsbuild/pants/issues/1126>`_\n  `RB #1983 <https://rbcommons.com/s/twitter/r/1983>`_\n\n* Convert ragel-gen.py to use new options and expunge config from BinaryUtil\n  `RB #1970 <https://rbcommons.com/s/twitter/r/1970>`_\n\n* Add the JvmCompileIsolatedStrategy\n  `RB #1898 <https://rbcommons.com/s/twitter/r/1898>`_\n\n* Move construction of PythonChroot to PythonTask base class\n  `RB #1965 <https://rbcommons.com/s/twitter/r/1965>`_\n\n* Delete the PythonBinaryBuilder class\n  `RB #1964 <https://rbcommons.com/s/twitter/r/1964>`_\n\n* Removing dead code\n  `RB #1960 <https://rbcommons.com/s/twitter/r/1960>`_\n\n* Make the test check that the return code is propagated\n  `RB #1966 <https://rbcommons.com/s/twitter/r/1966>`_\n\n* Cleanup\n  `RB #1962 <https://rbcommons.com/s/twitter/r/1962>`_\n\n* Get rid of almost all direct config access in python-building code\n  `RB #1954 <https://rbcommons.com/s/twitter/r/1954>`_\n\n0.0.31 (3/20/2015)\n------------------\n\nBugfixes\n~~~~~~~~\n\n* Make JavaProtobufLibrary not exportable to fix publish.\n  `RB #1952 <https://rbcommons.com/s/twitter/r/1952>`_\n\n* Pass compression option along to temp local artifact caches.\n  `RB #1955 <https://rbcommons.com/s/twitter/r/1955>`_\n\n* Fix a missing symbol in ScalaCompile\n  `RB #1885 <https://rbcommons.com/s/twitter/r/1885>`_\n  `RB #1945 <https://rbcommons.com/s/twitter/r/1945>`_\n\n* die only when invoked directly\n  `RB #1953 <https://rbcommons.com/s/twitter/r/1953>`_\n\n* add import for traceback, and add test to exercise that code path, rm unsed kwargs\n  `RB #1868 <https://rbcommons.com/s/twitter/r/1868>`_\n  `RB #1943 <https://rbcommons.com/s/twitter/r/1943>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Use the publically released 2.1.1 version of Cobertura\n  `RB #1933 <https://rbcommons.com/s/twitter/r/1933>`_\n\nDocumentation\n~~~~~~~~~~~~~\n\n* Update docs for \'prep_command()\'\n  `RB #1940 <https://rbcommons.com/s/twitter/r/1940>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* added sources and javadocs to export goal output\n  `RB #1936 <https://rbcommons.com/s/twitter/r/1936>`_\n\n* Add flags to idea and eclipse goals to exclude pulling in sources and javadoc via ivy\n  `RB #1939 <https://rbcommons.com/s/twitter/r/1939>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Remove a spurious import in test_antlr_builder\n  `RB #1951 <https://rbcommons.com/s/twitter/r/1951>`_\n\n* Refactor ZincUtils\n  `RB #1946 <https://rbcommons.com/s/twitter/r/1946>`_\n\n* change set([]) / OrderedSet([]) to set() / OrderedSet()\n  `RB #1947 <https://rbcommons.com/s/twitter/r/1947>`_\n\n* Rename TestPythonSetup to TestSetupPy\n  `RB #1950 <https://rbcommons.com/s/twitter/r/1950>`_\n\n* Rename the PythonSetup task to SetupPy\n  `RB #1942 <https://rbcommons.com/s/twitter/r/1942>`_\n\n0.0.30 (3/18/2015)\n------------------\n\nBugfixes\n~~~~~~~~\n\n* Fix missing deps from global switch to six range\n  `RB #1931 <https://rbcommons.com/s/twitter/r/1931>`_\n  `RB #1937 <https://rbcommons.com/s/twitter/r/1937>`_\n\n* Fix python_repl to work for python_requirement_libraries\n  `RB #1934 <https://rbcommons.com/s/twitter/r/1934>`_\n\n* Move count variable outside loop\n  `RB #1926 <https://rbcommons.com/s/twitter/r/1926>`_\n\n* Fix regression in synthetic target context handling\n  `RB #1921 <https://rbcommons.com/s/twitter/r/1921>`_\n\n* Try to fix the .rst render of the CHANGELOG on pypi\n  `RB #1911 <https://rbcommons.com/s/twitter/r/1911>`_\n\n* To add android.jar to the classpath, create a copy under task\'s workdir\n  `RB #1902 <https://rbcommons.com/s/twitter/r/1902>`_\n\n* walk synthetic targets dependencies when constructing context.target()\n  `RB #1863 <https://rbcommons.com/s/twitter/r/1863>`_\n  `RB #1914 <https://rbcommons.com/s/twitter/r/1914>`_\n\n* Mix the value of the zinc name-hashing flag into cache keys\n  `RB #1912 <https://rbcommons.com/s/twitter/r/1912>`_\n\n* Allow multiple ivy artifacts distinguished only by classifier\n  `RB #1905 <https://rbcommons.com/s/twitter/r/1905>`_\n\n* Fix `Git.detect_worktree` to fail gracefully\n  `RB #1903 <https://rbcommons.com/s/twitter/r/1903>`_\n\n* Avoid reparsing analysis repeatedly\n  `RB #, <https://rbcommons.com/s/twitter/r/1898/,>`_\n  `RB #1938 <https://rbcommons.com/s/twitter/r/1938>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove the now-superfluous "parallel resource directories" hack\n  `RB #1907 <https://rbcommons.com/s/twitter/r/1907>`_\n\n* Make rglobs follow symlinked directories by default\n  `RB #1881 <https://rbcommons.com/s/twitter/r/1881>`_\n\nDocumentation\n~~~~~~~~~~~~~\n\n* Trying to clarify how to contribute docs\n  `RB #1922 <https://rbcommons.com/s/twitter/r/1922>`_\n\n* Add documentation on how to turn on extra ivy debugging\n  `RB #1906 <https://rbcommons.com/s/twitter/r/1906>`_\n\n* Adds documentation to setup_repo.md with tips for how to configure Pants to work behind a firewall\n  `RB #1899 <https://rbcommons.com/s/twitter/r/1899>`_\n\nNew Features\n~~~~~~~~~~~~\n\n* Support spec_excludes in what_changed. Prior art: https://rbcommons.com/s/twitter/r/1795/\n  `RB #1930 <https://rbcommons.com/s/twitter/r/1930>`_\n\n* Add a new \'export\' goal for use by IDE integration\n  `RB #1917 <https://rbcommons.com/s/twitter/r/1917>`_\n  `RB #1929 <https://rbcommons.com/s/twitter/r/1929>`_\n\n* Add ability to detect HTTP_PROXY or HTTPS_PROXY in environment and pass it along to ivy\n  `RB #1877 <https://rbcommons.com/s/twitter/r/1877>`_\n\n* Pants publish to support publishing extra publish artifacts as individual artifacts with classifier attached\n  `RB #1879 <https://rbcommons.com/s/twitter/r/1879>`_\n  `RB #1889 <https://rbcommons.com/s/twitter/r/1889>`_\n\nSmall improvements, Refactoring and Tooling\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n* Deleting dead abbreviate_target_ids code.\n  `RB #1918 <https://rbcommons.com/s/twitter/r/1918>`_\n  `RB #1944 <https://rbcommons.com/s/twitter/r/1944>`_\n\n* Move AptCompile to its own file\n  `RB #1935 <https://rbcommons.com/s/twitter/r/1935>`_\n\n* use six.moves.range everywhere\n  `RB #1931 <https://rbcommons.com/s/twitter/r/1931>`_\n\n* Port scrooge/linter config to the options system\n  `RB #1927 <https://rbcommons.com/s/twitter/r/1927>`_\n\n* Fixes for import issues in JvmCompileStrategy post https://rbcommons.com/s/twitter/r/1885/\n  `RB #1900 <https://rbcommons.com/s/twitter/r/1900>`_\n\n* Moving stuff out of jvm and into project info backend\n  `RB #1917 <https://rbcommons.com/s/twitter/r/1917>`_\n\n* Provides is meant to have been deprecated a long time ago\n  `RB #1915 <https://rbcommons.com/s/twitter/r/1915>`_\n\n* Move JVM debug config functionality to the new options system\n  `RB #1924 <https://rbcommons.com/s/twitter/r/1924>`_\n\n* Remove the --color option from specs_run.  See https://rbcommons.com/s/twitter/r/1814/\n  `RB #1916 <https://rbcommons.com/s/twitter/r/1916>`_\n\n* Remove superfluous \'self.conf\' argument to self.classpath\n  `RB #1913 <https://rbcommons.com/s/twitter/r/1913>`_\n\n* Update ivy_utils error messages: include classifier and switch interpolation from % to format\n  `RB #1908 <https://rbcommons.com/s/twitter/r/1908>`_\n\n* Added a python helper for check_header.sh in git pre-commit script\n  `RB #1910 <https://rbcommons.com/s/twitter/r/1910>`_\n\n* Remove direct config access in scalastyle.py\n  `RB #1897 <https://rbcommons.com/s/twitter/r/1897>`_\n\n* Replace all instances of xrange with range, as xrange is deprecated in Python 3\n  `RB #1901 <https://rbcommons.com/s/twitter/r/1901>`_\n\n* Raise a better exception on truncated Zinc analysis files\n  `RB #1896 <https://rbcommons.com/s/twitter/r/1896>`_\n\n* Fail fast for OSX CI runs\n  `RB #1894 <https://rbcommons.com/s/twitter/r/1894>`_\n\n* Upgrade to the latest rbt release\n  `RB #1893 <https://rbcommons.com/s/twitter/r/1893>`_\n\n* Use cmp instead of a file hash\n  `RB #1892 <https://rbcommons.com/s/twitter/r/1892>`_\n\n* Split out a JvmCompileStrategy interface\n  `RB #1885 <https://rbcommons.com/s/twitter/r/1885>`_\n\n* Decouple WorkUnit from RunTracker\n  `RB #1928 <https://rbcommons.com/s/twitter/r/1928>`_\n\n* Add Scm.add, change publish to add pushdb explicitly, move scm publish around\n  `RB #1868 <https://rbcommons.com/s/twitter/r/1868>`_\n\n0.0.29 (3/9/2015)\n-----------------\n\nCI\n~~\n\n* Support local pre-commit checks\n  `RB #1883 <https://rbcommons.com/s/twitter/r/1883>`_\n\n* Fix newline to fix broken master build\n  `RB #1888 <https://rbcommons.com/s/twitter/r/1888>`_\n\n* Shard out OSX CI\n  `RB #1873 <https://rbcommons.com/s/twitter/r/1873>`_\n\n* Update travis\'s pants cache settings\n  `RB #1875 <https://rbcommons.com/s/twitter/r/1875>`_\n\n* Fixup contrib tests on osx CI\n  `RB #1867 <https://rbcommons.com/s/twitter/r/1867>`_\n\n* Reduce number of test shards from 8 to 6 on Travis-ci\n  `RB #1804 <https://rbcommons.com/s/twitter/r/1804>`_\n\n* Cache the isort venv for ci runs\n  `RB #1740 <https://rbcommons.com/s/twitter/r/1740>`_\n\n* Fixup ci isort check\n  `RB #1728 <https://rbcommons.com/s/twitter/r/1728>`_\n\nTests\n~~~~~\n\n* Add jar Publish integration tests to test the generated pom and ivy.xml files\n  `RB #1879 <https://rbcommons.com/s/twitter/r/1879>`_\n\n* Added test that shows that nested scope inherits properly from cmdline, config, and env\n  `RB #1851 <https://rbcommons.com/s/twitter/r/1851>`_\n  `RB #1865 <https://rbcommons.com/s/twitter/r/1865>`_\n\n* Improve AndroidDistribution coverage\n  `RB #1861 <https://rbcommons.com/s/twitter/r/1861>`_\n\n* Modernize the protobuf and wire task tests\n  `RB #1854 <https://rbcommons.com/s/twitter/r/1854>`_\n\n* Replace python_test_suite with target\n  `RB #1821 <https://rbcommons.com/s/twitter/r/1821>`_\n\n* Switch test_jvm_run.py to the new TaskTestBase instead of the old TaskTest\n  `RB #1829 <https://rbcommons.com/s/twitter/r/1829>`_\n\n* Remove two non-useful tests\n  `RB #1828 <https://rbcommons.com/s/twitter/r/1828>`_\n\n* Fix a python run integration test\n  `RB #1810 <https://rbcommons.com/s/twitter/r/1810>`_\n\n* Work around py test_runner issue with ns packages\n  `RB #1813 <https://rbcommons.com/s/twitter/r/1813>`_\n\n* Add a test for the Git changelog\n  `RB #1792 <https://rbcommons.com/s/twitter/r/1792>`_\n\n* Create a directory with no write perms for TestAndroidConfigUtil\n  `RB #1796 <https://rbcommons.com/s/twitter/r/1796>`_\n\n* Relocated some tests (no code changes) from tests/python/pants_test/tasks into\n  tests/python/pants_test/backend/codegen/tasks to mirror the source location\n  `RB #1746 <https://rbcommons.com/s/twitter/r/1746>`_\n\nDocs\n~~~~\n\n* Add some documentation about using the pants reporting server for troubleshooting\n  `RB #1887 <https://rbcommons.com/s/twitter/r/1887>`_\n\n* Docstring reformatting for Task and InvalidationCheck\n  `RB #1769 <https://rbcommons.com/s/twitter/r/1769>`_\n\n* docs: Show correct pictures for intellij.html\n  `RB #1716 <https://rbcommons.com/s/twitter/r/1716>`_\n\n* doc += how to turn on cache\n  `RB #1668 <https://rbcommons.com/s/twitter/r/1668>`_\n\nNew language: C++\n~~~~~~~~~~~~~~~~~\n\n* Separate compile step for C++ to just compile objects\n  `RB #1855 <https://rbcommons.com/s/twitter/r/1855>`_\n\n* Fixup CppToolchain to be lazy and actually cache\n  `RB #1850 <https://rbcommons.com/s/twitter/r/1850>`_\n\n* C++ support in contrib\n  `RB #1818 <https://rbcommons.com/s/twitter/r/1818>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Kill the global `--ng-daemons` flag\n  `RB #1852 <https://rbcommons.com/s/twitter/r/1852>`_\n\n* Removed parallel_test_paths setting from pants.ini.  It isn\'t needed in the pants repo any more\n  `RB #1846 <https://rbcommons.com/s/twitter/r/1846>`_\n\n* BUILD file format cleanup:\n\n  - Deprecate bundle().add in favor of bundle(files=)\n    `RB #1788 <https://rbcommons.com/s/twitter/r/1788>`_\n  - Deprecate .intransitive() in favor of argument\n    `RB #1797 <https://rbcommons.com/s/twitter/r/1797>`_\n  - Deprecate target.with_description in favor of target(description=)\n    `RB #1790 <https://rbcommons.com/s/twitter/r/1790>`_\n  - Allow exclude in globs\n    `RB #1762 <https://rbcommons.com/s/twitter/r/1762>`_\n  - Move with_artifacts to an artifacts argument\n    `RB #1672 <https://rbcommons.com/s/twitter/r/1672>`_\n\n* An attempt to deprecate some old methods\n  `RB #1720 <https://rbcommons.com/s/twitter/r/1720>`_\n\n* Options refactor work\n\n  - Make option registration recursion optional\n    `RB #1870 <https://rbcommons.com/s/twitter/r/1870>`_\n  - Remove all direct config uses from jar_publish.py\n    `RB #1844 <https://rbcommons.com/s/twitter/r/1844>`_\n  - Read pants_distdir from options instead of config\n    `RB #1842 <https://rbcommons.com/s/twitter/r/1842>`_\n  - Remove direct config references in thrift gen code\n    `RB #1839 <https://rbcommons.com/s/twitter/r/1839>`_\n  - Android backend now exclusively uses the new option system\n    `RB #1819 <https://rbcommons.com/s/twitter/r/1819>`_\n  - Replace config use in RunTracker with options\n    `RB #1823 <https://rbcommons.com/s/twitter/r/1823>`_\n  - Add pants_bootstradir and pants_configdir to options bootstrapper\n    `RB #1835 <https://rbcommons.com/s/twitter/r/1835>`_\n  - Remove all direct config access in task.py\n    `RB #1827 <https://rbcommons.com/s/twitter/r/1827>`_\n  - Convert config-only options in goal idea and eclipse to use new options format\n    `RB #1805 <https://rbcommons.com/s/twitter/r/1805>`_\n  - Remove config_section from some tasks\n    `RB #1806 <https://rbcommons.com/s/twitter/r/1806>`_\n  - Disallow --no- on the name of boolean flags, refactor existing ones\n    `Issue #34 <https://github.com/pantsbuild/intellij-pants-plugin/issues/34>`_\n    `RB #1799 <https://rbcommons.com/s/twitter/r/1799>`_\n  - Migrating pants.ini config values for protobuf-gen to advanced registered options under gen.protobuf\n    `RB #1741 <https://rbcommons.com/s/twitter/r/1741>`_\n\n* Add a way to deprecate options with \'deprecated_version\' and \'deprecated_hint\' kwargs to register()\n  `RB #1799 <https://rbcommons.com/s/twitter/r/1799>`_\n  `RB #1814 <https://rbcommons.com/s/twitter/r/1814>`_\n\n* Implement compile_classpath using UnionProducts\n  `RB #1761 <https://rbcommons.com/s/twitter/r/1761>`_\n\n* Introduce a @deprecated decorator\n  `RB #1725 <https://rbcommons.com/s/twitter/r/1725>`_\n\n* Update jar-tool to 0.1.9 and switch to use @argfile calling convention\n  `RB #1798 <https://rbcommons.com/s/twitter/r/1798>`_\n\n* Pants to respect XDB spec for global storage on unix systems\n  `RB #1817 <https://rbcommons.com/s/twitter/r/1817>`_\n\n* Adds a mixin (ImportJarsMixin) for the IvyImports task\n  `RB #1783 <https://rbcommons.com/s/twitter/r/1783>`_\n\n* Added invalidation check to UnpackJars task\n  `RB #1776 <https://rbcommons.com/s/twitter/r/1776>`_\n\n* Enable python-eval for pants source code\n  `RB #1773 <https://rbcommons.com/s/twitter/r/1773>`_\n\n* adding xml output for python coverage\n  `Issue #1105 <https://github.com/pantsbuild/pants/issues/1105>`_\n  `RB #1770 <https://rbcommons.com/s/twitter/r/1770>`_\n\n* Optionally adds a path value onto protoc\'s PATH befor launching it\n  `RB #1756 <https://rbcommons.com/s/twitter/r/1756>`_\n\n* Add progress information to partition reporting\n  `RB #1749 <https://rbcommons.com/s/twitter/r/1749>`_\n\n* Add SignApk product and Zipalign task\n  `RB #1737 <https://rbcommons.com/s/twitter/r/1737>`_\n\n* Add an \'advanced\' parameter to registering options\n  `RB #1739 <https://rbcommons.com/s/twitter/r/1739>`_\n\n* Add an env var for enabling the profiler\n  `RB #1305 <https://rbcommons.com/s/twitter/r/1305>`_\n\nBugfixes and features\n~~~~~~~~~~~~~~~~~~~~~\n\n* Kill the .saplings split\n  `RB #1886 <https://rbcommons.com/s/twitter/r/1886>`_\n\n* Update our requests library to something more recent\n  `RB #1884 <https://rbcommons.com/s/twitter/r/1884>`_\n\n* Make a nicer looking name for workunit output\n  `RB #1876 <https://rbcommons.com/s/twitter/r/1876>`_\n\n* Fixup DxCompile jvm_options to be a list\n  `RB #1878 <https://rbcommons.com/s/twitter/r/1878>`_\n\n* Make sure <?xml starts at the beginning of the file when creating an empty xml report\n  `RB #1856 <https://rbcommons.com/s/twitter/r/1856>`_\n\n* Set print_exception_stacktrace in pants.ini\n  `RB #1872 <https://rbcommons.com/s/twitter/r/1872>`_\n\n* Handle --print-exception-stacktrace and --version more elegantly\n  `RB #1871 <https://rbcommons.com/s/twitter/r/1871>`_\n\n* Improve AndroidDistribution caching\n  `RB #1861 <https://rbcommons.com/s/twitter/r/1861>`_\n\n* Add zinc to the platform_tools for zinc_utils\n  `RB #1779 <https://rbcommons.com/s/twitter/r/1779>`_\n  `RB #1858 <https://rbcommons.com/s/twitter/r/1858>`_\n\n* Fix WARN/WARNING confusion\n  `RB #1866 <https://rbcommons.com/s/twitter/r/1866>`_\n\n* Fixup Config to find DEFAULT values for missing sections\n  `RB #1851 <https://rbcommons.com/s/twitter/r/1851>`_\n\n* Get published artifact classfier from config\n  `RB #1857 <https://rbcommons.com/s/twitter/r/1857>`_\n\n* Make Context.targets() include synthetic targets\n  `RB #1840 <https://rbcommons.com/s/twitter/r/1840>`_\n  `RB #1863 <https://rbcommons.com/s/twitter/r/1863>`_\n\n* Fix micros to be left 0 padded to 6 digits\n  `RB #1849 <https://rbcommons.com/s/twitter/r/1849>`_\n\n* Setup logging before plugins are loaded\n  `RB #1820 <https://rbcommons.com/s/twitter/r/1820>`_\n\n* Introduce pants_setup_py and contrib_setup_py helpers\n  `RB #1822 <https://rbcommons.com/s/twitter/r/1822>`_\n\n* Support zinc name hashing\n  `RB #1779 <https://rbcommons.com/s/twitter/r/1779>`_\n\n* Actually generate a depfile from t.c.tools.compiler and use it in jmake\n  `RB #1824 <https://rbcommons.com/s/twitter/r/1824>`_\n  `RB #1825 <https://rbcommons.com/s/twitter/r/1825>`_\n\n* Ivy Imports now has a cache\n  `RB #1785 <https://rbcommons.com/s/twitter/r/1785>`_\n\n* Get rid of some direct config uses in python_repl.py\n  `RB #1826 <https://rbcommons.com/s/twitter/r/1826>`_\n\n* Add check if jars exists before registering products\n  `RB #1808 <https://rbcommons.com/s/twitter/r/1808>`_\n\n* shlex the python run args\n  `RB #1782 <https://rbcommons.com/s/twitter/r/1782>`_\n\n* Convert t.c.log usages to logging\n  `RB #1815 <https://rbcommons.com/s/twitter/r/1815>`_\n\n* Kill unused twitter.common reqs and deps\n  `RB #1816 <https://rbcommons.com/s/twitter/r/1816>`_\n\n* Check import sorting before checking headers\n  `RB #1812 <https://rbcommons.com/s/twitter/r/1812>`_\n\n* Fixup typo accessing debug_port option\n  `RB #1811 <https://rbcommons.com/s/twitter/r/1811>`_\n\n* Allow the dependees goal and idea to respect the --spec_excludes option\n  `RB #1795 <https://rbcommons.com/s/twitter/r/1795>`_\n\n* Copy t.c.lang.{AbstractClass,Singleton} to pants\n  `RB #1803 <https://rbcommons.com/s/twitter/r/1803>`_\n\n* Replace all t.c.lang.Compatibility uses with six\n  `RB #1801 <https://rbcommons.com/s/twitter/r/1801>`_\n\n* Fix sp in java example readme.md\n  `RB #1800 <https://rbcommons.com/s/twitter/r/1800>`_\n\n* Add util.XmlParser and AndroidManifestParser\n  `RB #1757 <https://rbcommons.com/s/twitter/r/1757>`_\n\n* Replace Compatibility.exec_function with `six.exec_`\n  `RB #1742 <https://rbcommons.com/s/twitter/r/1742>`_\n  `RB #1794 <https://rbcommons.com/s/twitter/r/1794>`_\n\n* Take care of stale pidfiles for pants server\n  `RB #1791 <https://rbcommons.com/s/twitter/r/1791>`_\n\n* Fixup the scrooge release\n  `RB #1793 <https://rbcommons.com/s/twitter/r/1793>`_\n\n* Extract scrooge tasks to contrib/\n  `RB #1780 <https://rbcommons.com/s/twitter/r/1780>`_\n\n* Fixup JarPublish changelog rendering\n  `RB #1787 <https://rbcommons.com/s/twitter/r/1787>`_\n\n* Preserve dictionary order in the anonymizer\n  `RB #1779 <https://rbcommons.com/s/twitter/r/1779>`_\n  `RB #1781 <https://rbcommons.com/s/twitter/r/1781>`_\n\n* Fix a test file leak to the build root\n  `RB #1771 <https://rbcommons.com/s/twitter/r/1771>`_\n\n* Replace all instances of compatibility.string\n  `RB #1764 <https://rbcommons.com/s/twitter/r/1764>`_\n\n* Improve the python run error message\n  `RB #1773 <https://rbcommons.com/s/twitter/r/1773>`_\n  `RB #1777 <https://rbcommons.com/s/twitter/r/1777>`_\n\n* Upgrade pex to 0.8.6\n  `RB #1778 <https://rbcommons.com/s/twitter/r/1778>`_\n\n* Introduce a PythonEval task\n  `RB #1772 <https://rbcommons.com/s/twitter/r/1772>`_\n\n* Add an elapsed timestamp to the banner for CI\n  `RB #1775 <https://rbcommons.com/s/twitter/r/1775>`_\n\n* Trying to clean up a TODO in IvyTaskMixin\n  `RB #1753 <https://rbcommons.com/s/twitter/r/1753>`_\n\n* rm double_dag\n  `RB #1711 <https://rbcommons.com/s/twitter/r/1711>`_\n\n* Add skip / target invalidation to thrift linting\n  `RB #1755 <https://rbcommons.com/s/twitter/r/1755>`_\n\n* Fixup `Task.invalidated` UI\n  `RB #1758 <https://rbcommons.com/s/twitter/r/1758>`_\n\n* Improve the implementation of help printing\n  `RB #1739 <https://rbcommons.com/s/twitter/r/1739>`_\n  `RB #1744 <https://rbcommons.com/s/twitter/r/1744>`_\n\n* Fix TestAndroidBase task_type override miss\n  `RB #1751 <https://rbcommons.com/s/twitter/r/1751>`_\n\n* Pass the BUILD file path to compile\n  `RB #1742 <https://rbcommons.com/s/twitter/r/1742>`_\n\n* Bandaid leaks of global Config state in tests\n  `RB #1750 <https://rbcommons.com/s/twitter/r/1750>`_\n\n* Fixing cobertura coverage so that it actually works\n  `RB #1704 <https://rbcommons.com/s/twitter/r/1704>`_\n\n* Restore the ability to bootstrap Ivy with a custom configuration file\n  `RB #1709 <https://rbcommons.com/s/twitter/r/1709>`_\n\n* Kill BUILD file bytecode compilation\n  `RB #1736 <https://rbcommons.com/s/twitter/r/1736>`_\n\n* Kill \'goal\' usage in the pants script\n  `RB #1738 <https://rbcommons.com/s/twitter/r/1738>`_\n\n* Fixup ivy report generation and opening\n  `RB #1735 <https://rbcommons.com/s/twitter/r/1735>`_\n\n* Fixup pants sys.excepthook for pex context\n  `RB #1733 <https://rbcommons.com/s/twitter/r/1733>`_\n  `RB #1734 <https://rbcommons.com/s/twitter/r/1734>`_\n\n* Adding long form of help arguments to the help output\n  `RB #1732 <https://rbcommons.com/s/twitter/r/1732>`_\n\n* Simplify isort config\n  `RB #1731 <https://rbcommons.com/s/twitter/r/1731>`_\n\n* Expand scope of python file format checks\n  `RB #1729 <https://rbcommons.com/s/twitter/r/1729>`_\n\n* Add path-to option to depmap\n  `RB #1545 <https://rbcommons.com/s/twitter/r/1545>`_\n\n* Fix a stragler `.is_apt` usage\n  `RB #1724 <https://rbcommons.com/s/twitter/r/1724>`_\n\n* Introduce isort to check `*.py` import ordering\n  `RB #1726 <https://rbcommons.com/s/twitter/r/1726>`_\n\n* Upgrade to pex 0.8.5\n  `RB #1721 <https://rbcommons.com/s/twitter/r/1721>`_\n\n* cleanup is_xxx checks: is_jar_library\n  `RB #1719 <https://rbcommons.com/s/twitter/r/1719>`_\n\n* Avoid redundant traversal in classpath calculation\n  `RB #1714 <https://rbcommons.com/s/twitter/r/1714>`_\n\n* Upgrade to the latest virtualenv\n  `RB #1715 <https://rbcommons.com/s/twitter/r/1715>`_\n  `RB #1718 <https://rbcommons.com/s/twitter/r/1718>`_\n\n* Fixup the release script\n  `RB #1715 <https://rbcommons.com/s/twitter/r/1715>`_\n\n* \'./pants goal\' -> \'./pants\'\n  `RB #1617 <https://rbcommons.com/s/twitter/r/1617>`_\n\n* Add new function open_zip64 which defaults allowZip64=True for Zip files\n  `RB #1708 <https://rbcommons.com/s/twitter/r/1708>`_\n\n* Fix a bug that --bundle-archive=tar generates .tar.gz instead of a .tar\n  `RB #1707 <https://rbcommons.com/s/twitter/r/1707>`_\n\n* Remove 3rdparty debug.keystore\n  `RB #1703 <https://rbcommons.com/s/twitter/r/1703>`_\n\n* Keystore no longer a target, apks signed with SignApkTask\n  `RB #1690 <https://rbcommons.com/s/twitter/r/1690>`_\n\n* remove this jar_rule I accidentally added\n  `RB #1701 <https://rbcommons.com/s/twitter/r/1701>`_\n\n* Require pushdb migration to specify a destination directory\n  `RB #1684 <https://rbcommons.com/s/twitter/r/1684>`_\n\n0.0.28 (2/1/2015)\n-----------------\n\nBugfixes\n~~~~~~~~\n\n* Numerous doc improvements & generation fixes\n\n  - Steal some info from options docstring\n  - Document `--config-override` & `PANTS_` environment vars\n  - Document JDK_HOME & JAVA_HOME use when choosing a java distribution\n  - Rename "Goals Reference" page -> "Options Reference"\n  - Document when to use isrequired\n  - Fix Google indexing to ignore test sites\n  - Update the code layout section of Pants Internals\n  - Show changelog & for that support `page(source=\'something.rst\')`\n  - Add a reminder that you can do set-like math on FileSets\n  - Hacking on Pants itself, update `--pdb` doc\n  - Start of a "Why Choose Pants?" section\n  - Highlight plugin examples from twitter/commons\n  - Add a blurb about deploy_jar_rules to the JVM docs\n  - Show how to pass `-s` to pytest\n  - When to use java_sources, when not to\n  - Start of a Pants-with-scala page\n  - Publish page now shows `provides=` example\n  - Add a flag to omit "internal" things\n  - Slide tweaks based on class feedback\n  - Document argument splitting for options\n\n  `Issue #897 <https://github.com/pantsbuild/pants/issues/897>`_\n  `RB #1092 <https://rbcommons.com/s/twitter/r/1092>`_\n  `RB #1490 <https://rbcommons.com/s/twitter/r/1490>`_\n  `RB #1532 <https://rbcommons.com/s/twitter/r/1532>`_\n  `RB #1544 <https://rbcommons.com/s/twitter/r/1544>`_\n  `RB #1546 <https://rbcommons.com/s/twitter/r/1546>`_\n  `RB #1548 <https://rbcommons.com/s/twitter/r/1548>`_\n  `RB #1549 <https://rbcommons.com/s/twitter/r/1549>`_\n  `RB #1550 <https://rbcommons.com/s/twitter/r/1550>`_\n  `RB #1554 <https://rbcommons.com/s/twitter/r/1554>`_\n  `RB #1555 <https://rbcommons.com/s/twitter/r/1555>`_\n  `RB #1559 <https://rbcommons.com/s/twitter/r/1559>`_\n  `RB #1560 <https://rbcommons.com/s/twitter/r/1560>`_\n  `RB #1565 <https://rbcommons.com/s/twitter/r/1565>`_\n  `RB #1575 <https://rbcommons.com/s/twitter/r/1575>`_\n  `RB #1580 <https://rbcommons.com/s/twitter/r/1580>`_\n  `RB #1583 <https://rbcommons.com/s/twitter/r/1583>`_\n  `RB #1584 <https://rbcommons.com/s/twitter/r/1584>`_\n  `RB #1593 <https://rbcommons.com/s/twitter/r/1593>`_\n  `RB #1607 <https://rbcommons.com/s/twitter/r/1607>`_\n  `RB #1608 <https://rbcommons.com/s/twitter/r/1608>`_\n  `RB #1609 <https://rbcommons.com/s/twitter/r/1609>`_\n  `RB #1618 <https://rbcommons.com/s/twitter/r/1618>`_\n  `RB #1622 <https://rbcommons.com/s/twitter/r/1622>`_\n  `RB #1633 <https://rbcommons.com/s/twitter/r/1633>`_\n  `RB #1640 <https://rbcommons.com/s/twitter/r/1640>`_\n  `RB #1657 <https://rbcommons.com/s/twitter/r/1657>`_\n  `RB #1658 <https://rbcommons.com/s/twitter/r/1658>`_\n  `RB #1563 <https://rbcommons.com/s/twitter/r/1563>`_\n  `RB #1564 <https://rbcommons.com/s/twitter/r/1564>`_\n  `RB #1677 <https://rbcommons.com/s/twitter/r/1677>`_\n  `RB #1678 <https://rbcommons.com/s/twitter/r/1678>`_\n  `RB #1694 <https://rbcommons.com/s/twitter/r/1694>`_\n  `RB #1695 <https://rbcommons.com/s/twitter/r/1695>`_\n\n* Add calls to relpath so that we don\'t generate overlong filenames on mesos\n  `RB #1528 <https://rbcommons.com/s/twitter/r/1528>`_\n  `RB #1612 <https://rbcommons.com/s/twitter/r/1612>`_\n  `RB #1644 <https://rbcommons.com/s/twitter/r/1644>`_\n\n* Regularize headers\n  `RB #1691 <https://rbcommons.com/s/twitter/r/1691>`_\n\n* Pants itself uses python2.7, kill unittest2 imports\n  `RB #1689 <https://rbcommons.com/s/twitter/r/1689>`_\n\n* Make \'setup-py\' show up in \'./pants goal goals\'\n  `RB #1466 <https://rbcommons.com/s/twitter/r/1466>`_\n\n* Test that CycleException happens for cycles (instead of a stack overflow)\n  `RB #1686 <https://rbcommons.com/s/twitter/r/1686>`_\n\n* Replace t.c.collection.OrderedDict with 2.7+ stdlib\n  `RB #1687 <https://rbcommons.com/s/twitter/r/1687>`_\n\n* Make ide_gen a subclass of Task to avoid depending on compile and resources tasks\n  `Issue #997 <https://github.com/pantsbuild/pants/issues/997>`_\n  `RB #1679 <https://rbcommons.com/s/twitter/r/1679>`_\n\n* Remove with_sources() from 3rdparty/BUILD\n  `RB #1674 <https://rbcommons.com/s/twitter/r/1674>`_\n\n* Handle thrift inclusion for python in apache_thrift_gen\n  `RB #1656 <https://rbcommons.com/s/twitter/r/1656>`_\n  `RB #1675 <https://rbcommons.com/s/twitter/r/1675>`_\n\n* Make beautifulsoup4 dep fixed rather than floating\n  `RB #1670 <https://rbcommons.com/s/twitter/r/1670>`_\n\n* Fixes for unpacked_jars\n  `RB #1624 <https://rbcommons.com/s/twitter/r/1624>`_\n\n* Fix spurious Products requirements\n  `RB #1662 <https://rbcommons.com/s/twitter/r/1662>`_\n\n* Fixup the options bootstrapper to support boolean flags\n  `RB #1660 <https://rbcommons.com/s/twitter/r/1660>`_\n  `RB #1664 <https://rbcommons.com/s/twitter/r/1664>`_\n\n* Change `Distribution.cached` to compare using Revision objects\n  `RB #1653 <https://rbcommons.com/s/twitter/r/1653>`_\n\n* Map linux i686 arch to i386\n  `Issue #962 <https://github.com/pantsbuild/pants/issues/962>`_\n  `RB #1659 <https://rbcommons.com/s/twitter/r/1659>`_\n\n* bump virtualenv version to 12.0.5\n  `RB #1621 <https://rbcommons.com/s/twitter/r/1621>`_\n\n* Bugfixes in calling super methods in traversable_specs and traversable_dependency_specs\n  `RB #1611 <https://rbcommons.com/s/twitter/r/1611>`_\n\n* Raise TaskError on python antlr generation failure\n  `RB #1604 <https://rbcommons.com/s/twitter/r/1604>`_\n\n* Fix topological ordering + chunking bug in jvm_compile\n  `RB #1598 <https://rbcommons.com/s/twitter/r/1598>`_\n\n* Fix CI from RB 1604 (and change a test name as suggested by nhoward)\n  `RB #1606 <https://rbcommons.com/s/twitter/r/1606>`_\n\n* Mark some missing-deps testprojects as expected to fail\n  `RB #1601 <https://rbcommons.com/s/twitter/r/1601>`_\n\n* Fix scalac plugin support broken in a refactor\n  `RB #1596 <https://rbcommons.com/s/twitter/r/1596>`_\n\n* Do not insert an error message as the "main" class in jvm_binary_task\n  `RB #1590 <https://rbcommons.com/s/twitter/r/1590>`_\n\n* Remove variable shadowing from method in archive.py\n  `RB #1589 <https://rbcommons.com/s/twitter/r/1589>`_\n\n* Don\'t realpath jars on the classpath\n  `RB #1588 <https://rbcommons.com/s/twitter/r/1588>`_\n  `RB #1591 <https://rbcommons.com/s/twitter/r/1591>`_\n\n* Cache ivy report dependency traversals consistently\n  `RB #1557 <https://rbcommons.com/s/twitter/r/1557>`_\n\n* Print the traceback when there is a problem loading or calling a backend module\n  `RB #1582 <https://rbcommons.com/s/twitter/r/1582>`_\n\n* Kill unused Engine.execution_order method and test\n  `RB #1576 <https://rbcommons.com/s/twitter/r/1576>`_\n\n* Support use of pytest\'s --pdb mode\n  `RB #1570 <https://rbcommons.com/s/twitter/r/1570>`_\n\n* fix missing dep. allows running this test on its own\n  `RB #1561 <https://rbcommons.com/s/twitter/r/1561>`_\n\n* Remove dead code and no longer needed topo sort from cache_manager\n  `RB #1553 <https://rbcommons.com/s/twitter/r/1553>`_\n\n* Use Travis CIs new container based builds and caching\n  `RB #1523 <https://rbcommons.com/s/twitter/r/1523>`_\n  `RB #1537 <https://rbcommons.com/s/twitter/r/1537>`_\n  `RB #1538 <https://rbcommons.com/s/twitter/r/1538>`_\n\nAPI Changes\n~~~~~~~~~~~\n\n* Improvements and extensions of `WhatChanged` functionality\n\n  - Skip loading graph if no changed targets\n  - Filter targets from changed using exclude_target_regexp\n  - Compile/Test "changed" targets\n  - Optionally include direct or transitive dependees of changed targets\n  - Add changes-in-diffspec option to what-changed\n  - Refactor WhatChanged into base class, use LazySourceMapper\n  - Introduce LazySourceMapper and test\n\n  `RB #1526 <https://rbcommons.com/s/twitter/r/1526>`_\n  `RB #1534 <https://rbcommons.com/s/twitter/r/1534>`_\n  `RB #1535 <https://rbcommons.com/s/twitter/r/1535>`_\n  `RB #1542 <https://rbcommons.com/s/twitter/r/1542>`_\n  `RB #1543 <https://rbcommons.com/s/twitter/r/1543>`_\n  `RB #1567 <https://rbcommons.com/s/twitter/r/1567>`_\n  `RB #1572 <https://rbcommons.com/s/twitter/r/1572>`_\n  `RB #1595 <https://rbcommons.com/s/twitter/r/1595>`_\n  `RB #1600 <https://rbcommons.com/s/twitter/r/1600>`_\n\n* More options migration, improvements and bugfixes\n\n  - Centralize invertible arg logic\n  - Support loading boolean flags from pants.ini\n  - Add a clarifying note in migrate_config\n  - Some refactoring of IvyUtils\n  - Rename the few remaining "jvm_args" variables to "jvm_options"\n  - `./pants --help-all` lists all options\n  - Add missing stanza in the migration script\n  - Switch artifact cache setup from config to new options\n  - Migrate jvm_compile\'s direct config accesses to the options system\n  - Added some formatting to parse errors for dicts and lists in options\n  - `s/new_options/options/g`\n  - Re-implement the jvm tool registration mechanism via the options system\n  - Make JvmRun support passthru args\n\n  `RB #1347 <https://rbcommons.com/s/twitter/r/1347>`_\n  `RB #1495 <https://rbcommons.com/s/twitter/r/1495>`_\n  `RB #1521 <https://rbcommons.com/s/twitter/r/1521>`_\n  `RB #1527 <https://rbcommons.com/s/twitter/r/1527>`_\n  `RB #1552 <https://rbcommons.com/s/twitter/r/1552>`_\n  `RB #1569 <https://rbcommons.com/s/twitter/r/1569>`_\n  `RB #1585 <https://rbcommons.com/s/twitter/r/1585>`_\n  `RB #1599 <https://rbcommons.com/s/twitter/r/1599>`_\n  `RB #1626 <https://rbcommons.com/s/twitter/r/1626>`_\n  `RB #1630 <https://rbcommons.com/s/twitter/r/1630>`_\n  `RB #1631 <https://rbcommons.com/s/twitter/r/1631>`_\n  `RB #1646 <https://rbcommons.com/s/twitter/r/1646>`_\n  `RB #1680 <https://rbcommons.com/s/twitter/r/1680>`_\n  `RB #1681 <https://rbcommons.com/s/twitter/r/1681>`_\n  `RB #1696 <https://rbcommons.com/s/twitter/r/1696>`_\n\n* Upgrade pex dependency to 0.8.4\n\n  - Pick up several perf wins\n  - Pick up fix that allows pex to read older pexes\n\n  `RB #1648 <https://rbcommons.com/s/twitter/r/1648>`_\n  `RB #1693 <https://rbcommons.com/s/twitter/r/1693>`_\n\n* Upgrade jmake to org.pantsbuild releases\n\n  - Upgrade jmake to version with isPackagePrivateClass fix\n  - Upgrade jmake to version that works with java 1.5+\n\n  `Issue #13 <https://github.com/pantsbuild/jmake/issues/13>`_\n  `RB #1594 <https://rbcommons.com/s/twitter/r/1594>`_\n  `RB #1628 <https://rbcommons.com/s/twitter/r/1628>`_\n  `RB #1650 <https://rbcommons.com/s/twitter/r/1650>`_\n\n* Fix ivy resolve args + added ability to provide custom ivy configurations\n  `RB #1671 <https://rbcommons.com/s/twitter/r/1671>`_\n\n* Allow target specs to come from files\n  `RB #1669 <https://rbcommons.com/s/twitter/r/1669>`_\n\n* Remove obsolete twitter-specific hack \'is_classpath_artifact\'\n  `RB #1676 <https://rbcommons.com/s/twitter/r/1676>`_\n\n* Improve RoundEngine lifecycle\n  `RB #1665 <https://rbcommons.com/s/twitter/r/1665>`_\n\n* Changed Scala version from 2.9.3 to 2.10.3 because zinc was using 2.10.3 already\n  `RB #1610 <https://rbcommons.com/s/twitter/r/1610>`_\n\n* Prevent "round trip" dependencies\n  `RB #1603 <https://rbcommons.com/s/twitter/r/1603>`_\n\n* Edit `Config.get_required` so as to raise error for any blank options\n  `RB #1638 <https://rbcommons.com/s/twitter/r/1638>`_\n\n* Don\'t plumb an executor through when bootstrapping tools\n  `RB #1634 <https://rbcommons.com/s/twitter/r/1634>`_\n\n* Print jar_dependency deprecations to stderr\n  `RB #1632 <https://rbcommons.com/s/twitter/r/1632>`_\n\n* Add configuration parameter to control the requirements cache ttl\n  `RB #1627 <https://rbcommons.com/s/twitter/r/1627>`_\n\n* Got ivy to map in javadoc and source jars for pants goal idea\n  `RB #1613 <https://rbcommons.com/s/twitter/r/1613>`_\n  `RB #1639 <https://rbcommons.com/s/twitter/r/1639>`_\n\n* Remove the \'^\' syntax for the command line spec parsing\n  `RB #1616 <https://rbcommons.com/s/twitter/r/1616>`_\n\n* Kill leftover imports handling from early efforts\n  `RB #592 <https://rbcommons.com/s/twitter/r/592>`_\n  `RB #1614 <https://rbcommons.com/s/twitter/r/1614>`_\n\n* Adding the ability to pull in a Maven artifact and extract its contents\n  `RB #1210 <https://rbcommons.com/s/twitter/r/1210>`_\n\n* Allow FingerprintStrategy to opt out of fingerprinting\n  `RB #1602 <https://rbcommons.com/s/twitter/r/1602>`_\n\n* Remove the ivy_home property from context\n  `RB #1592 <https://rbcommons.com/s/twitter/r/1592>`_\n\n* Refactor setting of PYTHONPATH in pants.ini\n  `RB #1586 <https://rbcommons.com/s/twitter/r/1586>`_\n\n* Relocate \'to_jar_dependencies\' method back to jar_library\n  `RB #1574 <https://rbcommons.com/s/twitter/r/1574>`_\n\n* Update protobuf_gen to be able to reference sources outside of the subdirectory of the BUILD file\n  `RB #1573 <https://rbcommons.com/s/twitter/r/1573>`_\n\n* Kill goal dependencies\n  `RB #1577 <https://rbcommons.com/s/twitter/r/1577>`_\n\n* Move excludes logic into cmd_line_spec_parser so it can filter out broken build targets\n  `RB #930 <https://rbcommons.com/s/twitter/r/930>`_\n  `RB #1566 <https://rbcommons.com/s/twitter/r/1566>`_\n\n* Replace exclusives_groups with a compile_classpath product\n  `RB #1539 <https://rbcommons.com/s/twitter/r/1539>`_\n\n* Allow adding to pythonpath via pant.ini\n  `RB #1457 <https://rbcommons.com/s/twitter/r/1457>`_\n\n0.0.27 (12/19/2014)\n-------------------\n\nBugfixes\n~~~~~~~~\n\n* Fix python doc: "repl" and "setup-py" are goals now, don\'t use "py"\n  `RB #1302 <https://rbcommons.com/s/twitter/r/1302>`_\n\n* Fix python thrift generation\n  `RB #1517 <https://rbcommons.com/s/twitter/r/1517>`_\n\n* Fixup migrate_config to use new Config API\n  `RB #1514 <https://rbcommons.com/s/twitter/r/1514>`_\n\n0.0.26 (12/17/2014)\n-------------------\n\nBugfixes\n~~~~~~~~\n\n* Fix the `ScroogeGen` target selection predicate\n  `RB #1497 <https://rbcommons.com/s/twitter/r/1497>`_\n\n0.0.25 (12/17/2014)\n-------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Flesh out and convert to the new options system introduced in `pantsbuild.pants` 0.0.24\n\n  - Support loading config from multiple files\n  - Support option reads via indexing\n  - Add a `migrate_config` tool\n  - Migrate tasks to the option registration system\n  - Get rid of the old config registration mechanism\n  - Add passthru arg support in the new options system\n  - Support passthru args in tasks\n  - Allow a task type know its own options scope\n  - Support old-style flags even in the new flag system\n\n  `RB #1093 <https://rbcommons.com/s/twitter/r/1093>`_\n  `RB #1094 <https://rbcommons.com/s/twitter/r/1094>`_\n  `RB #1095 <https://rbcommons.com/s/twitter/r/1095>`_\n  `RB #1096 <https://rbcommons.com/s/twitter/r/1096>`_\n  `RB #1097 <https://rbcommons.com/s/twitter/r/1097>`_\n  `RB #1102 <https://rbcommons.com/s/twitter/r/1102>`_\n  `RB #1109 <https://rbcommons.com/s/twitter/r/1109>`_\n  `RB #1114 <https://rbcommons.com/s/twitter/r/1114>`_\n  `RB #1124 <https://rbcommons.com/s/twitter/r/1124>`_\n  `RB #1125 <https://rbcommons.com/s/twitter/r/1125>`_\n  `RB #1127 <https://rbcommons.com/s/twitter/r/1127>`_\n  `RB #1129 <https://rbcommons.com/s/twitter/r/1129>`_\n  `RB #1131 <https://rbcommons.com/s/twitter/r/1131>`_\n  `RB #1135 <https://rbcommons.com/s/twitter/r/1135>`_\n  `RB #1138 <https://rbcommons.com/s/twitter/r/1138>`_\n  `RB #1140 <https://rbcommons.com/s/twitter/r/1140>`_\n  `RB #1146 <https://rbcommons.com/s/twitter/r/1146>`_\n  `RB #1147 <https://rbcommons.com/s/twitter/r/1147>`_\n  `RB #1170 <https://rbcommons.com/s/twitter/r/1170>`_\n  `RB #1175 <https://rbcommons.com/s/twitter/r/1175>`_\n  `RB #1183 <https://rbcommons.com/s/twitter/r/1183>`_\n  `RB #1186 <https://rbcommons.com/s/twitter/r/1186>`_\n  `RB #1192 <https://rbcommons.com/s/twitter/r/1192>`_\n  `RB #1195 <https://rbcommons.com/s/twitter/r/1195>`_\n  `RB #1203 <https://rbcommons.com/s/twitter/r/1203>`_\n  `RB #1211 <https://rbcommons.com/s/twitter/r/1211>`_\n  `RB #1212 <https://rbcommons.com/s/twitter/r/1212>`_\n  `RB #1214 <https://rbcommons.com/s/twitter/r/1214>`_\n  `RB #1218 <https://rbcommons.com/s/twitter/r/1218>`_\n  `RB #1223 <https://rbcommons.com/s/twitter/r/1223>`_\n  `RB #1225 <https://rbcommons.com/s/twitter/r/1225>`_\n  `RB #1229 <https://rbcommons.com/s/twitter/r/1229>`_\n  `RB #1230 <https://rbcommons.com/s/twitter/r/1230>`_\n  `RB #1231 <https://rbcommons.com/s/twitter/r/1231>`_\n  `RB #1232 <https://rbcommons.com/s/twitter/r/1232>`_\n  `RB #1234 <https://rbcommons.com/s/twitter/r/1234>`_\n  `RB #1236 <https://rbcommons.com/s/twitter/r/1236>`_\n  `RB #1244 <https://rbcommons.com/s/twitter/r/1244>`_\n  `RB #1248 <https://rbcommons.com/s/twitter/r/1248>`_\n  `RB #1251 <https://rbcommons.com/s/twitter/r/1251>`_\n  `RB #1258 <https://rbcommons.com/s/twitter/r/1258>`_\n  `RB #1269 <https://rbcommons.com/s/twitter/r/1269>`_\n  `RB #1270 <https://rbcommons.com/s/twitter/r/1270>`_\n  `RB #1276 <https://rbcommons.com/s/twitter/r/1276>`_\n  `RB #1281 <https://rbcommons.com/s/twitter/r/1281>`_\n  `RB #1286 <https://rbcommons.com/s/twitter/r/1286>`_\n  `RB #1289 <https://rbcommons.com/s/twitter/r/1289>`_\n  `RB #1297 <https://rbcommons.com/s/twitter/r/1297>`_\n  `RB #1300 <https://rbcommons.com/s/twitter/r/1300>`_\n  `RB #1308 <https://rbcommons.com/s/twitter/r/1308>`_\n  `RB #1309 <https://rbcommons.com/s/twitter/r/1309>`_\n  `RB #1317 <https://rbcommons.com/s/twitter/r/1317>`_\n  `RB #1320 <https://rbcommons.com/s/twitter/r/1320>`_\n  `RB #1323 <https://rbcommons.com/s/twitter/r/1323>`_\n  `RB #1328 <https://rbcommons.com/s/twitter/r/1328>`_\n  `RB #1341 <https://rbcommons.com/s/twitter/r/1341>`_\n  `RB #1343 <https://rbcommons.com/s/twitter/r/1343>`_\n  `RB #1351 <https://rbcommons.com/s/twitter/r/1351>`_\n  `RB #1357 <https://rbcommons.com/s/twitter/r/1357>`_\n  `RB #1373 <https://rbcommons.com/s/twitter/r/1373>`_\n  `RB #1375 <https://rbcommons.com/s/twitter/r/1375>`_\n  `RB #1385 <https://rbcommons.com/s/twitter/r/1385>`_\n  `RB #1389 <https://rbcommons.com/s/twitter/r/1389>`_\n  `RB #1399 <https://rbcommons.com/s/twitter/r/1399>`_\n  `RB #1409 <https://rbcommons.com/s/twitter/r/1409>`_\n  `RB #1435 <https://rbcommons.com/s/twitter/r/1435>`_\n  `RB #1441 <https://rbcommons.com/s/twitter/r/1441>`_\n  `RB #1442 <https://rbcommons.com/s/twitter/r/1442>`_\n  `RB #1443 <https://rbcommons.com/s/twitter/r/1443>`_\n  `RB #1451 <https://rbcommons.com/s/twitter/r/1451>`_\n\n* Kill `Commands` and move all actions to `Tasks` in the goal infrastructure\n\n  - Kill pants own use of the deprecated goal command\n  - Restore the deprecation warning for specifying \'goal\' on the cmdline\n  - Get rid of the Command class completely\n  - Enable passthru args for python run\n\n  `RB #1321 <https://rbcommons.com/s/twitter/r/1321>`_\n  `RB #1327 <https://rbcommons.com/s/twitter/r/1327>`_\n  `RB #1394 <https://rbcommons.com/s/twitter/r/1394>`_\n  `RB #1402 <https://rbcommons.com/s/twitter/r/1402>`_\n  `RB #1448 <https://rbcommons.com/s/twitter/r/1448>`_\n  `RB #1453 <https://rbcommons.com/s/twitter/r/1453>`_\n  `RB #1465 <https://rbcommons.com/s/twitter/r/1465>`_\n  `RB #1471 <https://rbcommons.com/s/twitter/r/1471>`_\n  `RB #1476 <https://rbcommons.com/s/twitter/r/1476>`_\n  `RB #1479 <https://rbcommons.com/s/twitter/r/1479>`_\n\n* Add support for loading plugins via standard the pkg_resources entry points mechanism\n  `RB #1429 <https://rbcommons.com/s/twitter/r/1429>`_\n  `RB #1444 <https://rbcommons.com/s/twitter/r/1444>`_\n\n* Many performance improvements and bugfixes to the artifact caching subsystem\n\n  - Use a requests `Session` to enable connection pooling\n  - Make CacheKey hash and pickle friendly\n  - Multiprocessing Cache Check and Write\n  - Skip compressing/writing artifacts that are already in the cache\n  - Add the ability for JVM targets to refuse to allow themselves to be cached in the artifact cache\n  - Fix name of non-fatal cache exception\n  - Fix the issue of seeing "Error while writing to artifact cache: an integer is required"\n    during [cache check]\n  - Fix all uncompressed artifacts stored as just `.tar`\n\n  `RB #981 <https://rbcommons.com/s/twitter/r/981>`_\n  `RB #986 <https://rbcommons.com/s/twitter/r/986>`_\n  `RB #1022 <https://rbcommons.com/s/twitter/r/1022>`_\n  `RB #1197 <https://rbcommons.com/s/twitter/r/1197>`_\n  `RB #1206 <https://rbcommons.com/s/twitter/r/1206>`_\n  `RB #1233 <https://rbcommons.com/s/twitter/r/1233>`_\n  `RB #1261 <https://rbcommons.com/s/twitter/r/1261>`_\n  `RB #1264 <https://rbcommons.com/s/twitter/r/1264>`_\n  `RB #1265 <https://rbcommons.com/s/twitter/r/1265>`_\n  `RB #1272 <https://rbcommons.com/s/twitter/r/1272>`_\n  `RB #1274 <https://rbcommons.com/s/twitter/r/1274>`_\n  `RB #1249 <https://rbcommons.com/s/twitter/r/1249>`_\n  `RB #1310 <https://rbcommons.com/s/twitter/r/1310>`_\n\n* More enhancements to the `depmap` goal to support IDE plugins:\n\n  - Add Pants Target Type to `depmap` to identify scala target VS java target\n  - Add java_sources to the `depmap` info\n  - Add transitive jar dependencies to `depmap` project info goal for intellij plugin\n\n  `RB #1366 <https://rbcommons.com/s/twitter/r/1366>`_\n  `RB #1324 <https://rbcommons.com/s/twitter/r/1324>`_\n  `RB #1047 <https://rbcommons.com/s/twitter/r/1047>`_\n\n* Port pants to pex 0.8.x\n  `Issue #10 <https://github.com/pantsbuild/pex/issues/10>`_\n  `Issue #19 <https://github.com/pantsbuild/pex/issues/19>`_\n  `Issue #21 <https://github.com/pantsbuild/pex/issues/21>`_\n  `Issue #22 <https://github.com/pantsbuild/pex/issues/22>`_\n  `RB #778 <https://rbcommons.com/s/twitter/r/778>`_\n  `RB #785 <https://rbcommons.com/s/twitter/r/785>`_\n  `RB #1303 <https://rbcommons.com/s/twitter/r/1303>`_\n  `RB #1378 <https://rbcommons.com/s/twitter/r/1378>`_\n  `RB #1421 <https://rbcommons.com/s/twitter/r/1421>`_\n\n* Remove support for __file__ in BUILDs\n  `RB #1419 <https://rbcommons.com/s/twitter/r/1419>`_\n\n* Allow setting the cwd for goals `run.jvm` and `test.junit`\n  `RB #1344 <https://rbcommons.com/s/twitter/r/1344>`_\n\n* Subclasses of `Exception` have strange deserialization\n  `RB #1395 <https://rbcommons.com/s/twitter/r/1395>`_\n\n* Remove outer (pants_exe) lock and serialized cmd\n  `RB #1388 <https://rbcommons.com/s/twitter/r/1388>`_\n\n* Make all access to `Context`\'s lock via helpers\n  `RB #1391 <https://rbcommons.com/s/twitter/r/1391>`_\n\n* Allow adding entries to `source_roots`\n  `RB #1359 <https://rbcommons.com/s/twitter/r/1359>`_\n\n* Re-upload artifacts that encountered read-errors\n  `RB #1361 <https://rbcommons.com/s/twitter/r/1361>`_\n\n* Cache files created by (specially designed) annotation processors\n  `RB #1250 <https://rbcommons.com/s/twitter/r/1250>`_\n\n* Turn dependency dupes into errors\n  `RB #1332 <https://rbcommons.com/s/twitter/r/1332>`_\n\n* Add support for the Wire protobuf library\n  `RB #1275 <https://rbcommons.com/s/twitter/r/1275>`_\n\n* Pin pants support down to python2.7 - dropping 2.6\n  `RB #1278 <https://rbcommons.com/s/twitter/r/1278>`_\n\n* Add a new param for page target, links, a list of hyperlinked-to targets\n  `RB #1242 <https://rbcommons.com/s/twitter/r/1242>`_\n\n* Add git root calculation for idea goal\n  `RB #1189 <https://rbcommons.com/s/twitter/r/1189>`_\n\n* Minimal target "tags" support\n  `RB #1227 <https://rbcommons.com/s/twitter/r/1227>`_\n\n* Include traceback with failures (even without fail-fast)\n  `RB #1226 <https://rbcommons.com/s/twitter/r/1226>`_\n\n* Add support for updating the environment from prep_commands\n  `RB #1222 <https://rbcommons.com/s/twitter/r/1222>`_\n\n* Read arguments for thrift-linter from `pants.ini`\n  `RB #1215 <https://rbcommons.com/s/twitter/r/1215>`_\n\n* Configurable Compression Level for Cache Artifacts\n  `RB #1194 <https://rbcommons.com/s/twitter/r/1194>`_\n\n* Add a flexible directory re-mapper for the bundle\n  `RB #1181 <https://rbcommons.com/s/twitter/r/1181>`_\n\n* Adds the ability to pass a filter method for ZIP extraction\n  `RB #1199 <https://rbcommons.com/s/twitter/r/1199>`_\n\n* Print a diagnostic if a BUILD file references a source file that does not exist\n  `RB #1198 <https://rbcommons.com/s/twitter/r/1198>`_\n\n* Add support for running a command before tests\n  `RB #1179 <https://rbcommons.com/s/twitter/r/1179>`_\n  `RB #1177 <https://rbcommons.com/s/twitter/r/1177>`_\n\n* Add `PantsRunIntegrationTest` into `pantsbuild.pants.testinfra` package\n  `RB #1185 <https://rbcommons.com/s/twitter/r/1185>`_\n\n* Refactor `jar_library` to be able to unwrap its list of jar_dependency objects\n  `RB #1165 <https://rbcommons.com/s/twitter/r/1165>`_\n\n* When resolving a tool dep, report back the `pants.ini` section with a reference that is failing\n  `RB #1162 <https://rbcommons.com/s/twitter/r/1162>`_\n\n* Add a list assertion for `python_requirement_library`\'s requirements\n  `RB #1142 <https://rbcommons.com/s/twitter/r/1142>`_\n\n* Adding a list of dirs to exclude from the \'::\' scan in the `CmdLineSpecParser`\n  `RB #1091 <https://rbcommons.com/s/twitter/r/1091>`_\n\n* Protobuf and payload cleanups\n  `RB #1099 <https://rbcommons.com/s/twitter/r/1099>`_\n\n* Coalesce errors when parsing BUILDS in a spec\n  `RB #1061 <https://rbcommons.com/s/twitter/r/1061>`_\n\n* Refactor Payload\n  `RB #1063 <https://rbcommons.com/s/twitter/r/1063>`_\n\n* Add support for publishing plugins to pants\n  `RB #1021 <https://rbcommons.com/s/twitter/r/1021>`_\n\nBugfixes\n~~~~~~~~\n\n* Numerous doc improvements & generation fixes\n\n  - Updates to the pants essentials tech talk based on another dry-run\n  - On skinny displays, don\'t show navigation UI by default\n  - Handy rbt status tip from RBCommons newsletter\n  - Document how to create a simple plugin\n  - Update many bash examples that used old-style flags\n  - Update Pants+IntelliJ docs to say the Plugin\'s the new hotness, link to plugin\'s README\n  - Publish docs the new way\n  - Update the "Pants Essentials" tech talk slides\n  - Convert `.rst` files -> `.md` files\n  - For included code snippets, don\'t just slap in a pre, provide syntax highlighting\n  - Add notes about JDK versions supported\n  - Dust off the Task Developer\'s Guide and `rm` the "pagerank" example\n  - Add a `sitegen` task, create site with better navigation\n  - For \'goal builddict\', generate `.rst` and `.html`, not just `.rst`\n  - Narrow setup \'Operating System\' classfiers to known-good\n\n  `Issue #16 <https://github.com/pantsbuild/pex/issues/16>`_\n  `Issue #461 <https://github.com/pantsbuild/pants/issues/461>`_\n  `Issue #739 <https://github.com/pantsbuild/pants/issues/739>`_\n  `RB #891 <https://rbcommons.com/s/twitter/r/891>`_\n  `RB #1074 <https://rbcommons.com/s/twitter/r/1074>`_\n  `RB #1075 <https://rbcommons.com/s/twitter/r/1075>`_\n  `RB #1079 <https://rbcommons.com/s/twitter/r/1079>`_\n  `RB #1084 <https://rbcommons.com/s/twitter/r/1084>`_\n  `RB #1086 <https://rbcommons.com/s/twitter/r/1086>`_\n  `RB #1088 <https://rbcommons.com/s/twitter/r/1088>`_\n  `RB #1090 <https://rbcommons.com/s/twitter/r/1090>`_\n  `RB #1101 <https://rbcommons.com/s/twitter/r/1101>`_\n  `RB #1126 <https://rbcommons.com/s/twitter/r/1126>`_\n  `RB #1128 <https://rbcommons.com/s/twitter/r/1128>`_\n  `RB #1134 <https://rbcommons.com/s/twitter/r/1134>`_\n  `RB #1136 <https://rbcommons.com/s/twitter/r/1136>`_\n  `RB #1154 <https://rbcommons.com/s/twitter/r/1154>`_\n  `RB #1155 <https://rbcommons.com/s/twitter/r/1155>`_\n  `RB #1164 <https://rbcommons.com/s/twitter/r/1164>`_\n  `RB #1166 <https://rbcommons.com/s/twitter/r/1166>`_\n  `RB #1176 <https://rbcommons.com/s/twitter/r/1176>`_\n  `RB #1178 <https://rbcommons.com/s/twitter/r/1178>`_\n  `RB #1182 <https://rbcommons.com/s/twitter/r/1182>`_\n  `RB #1191 <https://rbcommons.com/s/twitter/r/1191>`_\n  `RB #1196 <https://rbcommons.com/s/twitter/r/1196>`_\n  `RB #1205 <https://rbcommons.com/s/twitter/r/1205>`_\n  `RB #1241 <https://rbcommons.com/s/twitter/r/1241>`_\n  `RB #1263 <https://rbcommons.com/s/twitter/r/1263>`_\n  `RB #1277 <https://rbcommons.com/s/twitter/r/1277>`_\n  `RB #1284 <https://rbcommons.com/s/twitter/r/1284>`_\n  `RB #1292 <https://rbcommons.com/s/twitter/r/1292>`_\n  `RB #1295 <https://rbcommons.com/s/twitter/r/1295>`_\n  `RB #1296 <https://rbcommons.com/s/twitter/r/1296>`_\n  `RB #1298 <https://rbcommons.com/s/twitter/r/1298>`_\n  `RB #1299 <https://rbcommons.com/s/twitter/r/1299>`_\n  `RB #1301 <https://rbcommons.com/s/twitter/r/1301>`_\n  `RB #1314 <https://rbcommons.com/s/twitter/r/1314>`_\n  `RB #1315 <https://rbcommons.com/s/twitter/r/1315>`_\n  `RB #1326 <https://rbcommons.com/s/twitter/r/1326>`_\n  `RB #1348 <https://rbcommons.com/s/twitter/r/1348>`_\n  `RB #1355 <https://rbcommons.com/s/twitter/r/1355>`_\n  `RB #1356 <https://rbcommons.com/s/twitter/r/1356>`_\n  `RB #1358 <https://rbcommons.com/s/twitter/r/1358>`_\n  `RB #1363 <https://rbcommons.com/s/twitter/r/1363>`_\n  `RB #1370 <https://rbcommons.com/s/twitter/r/1370>`_\n  `RB #1377 <https://rbcommons.com/s/twitter/r/1377>`_\n  `RB #1386 <https://rbcommons.com/s/twitter/r/1386>`_\n  `RB #1387 <https://rbcommons.com/s/twitter/r/1387>`_\n  `RB #1401 <https://rbcommons.com/s/twitter/r/1401>`_\n  `RB #1407 <https://rbcommons.com/s/twitter/r/1407>`_\n  `RB #1427 <https://rbcommons.com/s/twitter/r/1427>`_\n  `RB #1430 <https://rbcommons.com/s/twitter/r/1430>`_\n  `RB #1434 <https://rbcommons.com/s/twitter/r/1434>`_\n  `RB #1440 <https://rbcommons.com/s/twitter/r/1440>`_\n  `RB #1446 <https://rbcommons.com/s/twitter/r/1446>`_\n  `RB #1464 <https://rbcommons.com/s/twitter/r/1464>`_\n  `RB #1484 <https://rbcommons.com/s/twitter/r/1484>`_\n  `RB #1491 <https://rbcommons.com/s/twitter/r/1491>`_\n\n* CmdLineProcessor uses `binary class name\n  <http://docs.oracle.com/javase/specs/jvms/se7/html/jvms-4.html#jvms-4.2.1>`_\n  `RB #1489 <https://rbcommons.com/s/twitter/r/1489>`_\n\n* Use subscripting for looking up targets in resources_by_products\n  `RB #1380 <https://rbcommons.com/s/twitter/r/1380>`_\n\n* Fix/refactor checkstyle\n  `RB #1432 <https://rbcommons.com/s/twitter/r/1432>`_\n\n* Fix missing import\n  `RB #1483 <https://rbcommons.com/s/twitter/r/1483>`_\n\n* Make `./pants help` and `./pants help <goal>` work properly\n  `Issue #839 <https://github.com/pantsbuild/pants/issues/839>`_\n  `RB #1482 <https://rbcommons.com/s/twitter/r/1482>`_\n\n* Cleanup after custom options bootstrapping in reflect\n  `RB #1468 <https://rbcommons.com/s/twitter/r/1468>`_\n\n* Handle UTF-8 in thrift files for python\n  `RB #1459 <https://rbcommons.com/s/twitter/r/1459>`_\n\n* Optimize goal changed\n  `RB #1470 <https://rbcommons.com/s/twitter/r/1470>`_\n\n* Fix a bug where a request for help wasn\'t detected\n  `RB #1467 <https://rbcommons.com/s/twitter/r/1467>`_\n\n* Always relativize the classpath where possible\n  `RB #1455 <https://rbcommons.com/s/twitter/r/1455>`_\n\n* Gracefully handle another run creating latest link\n  `RB #1396 <https://rbcommons.com/s/twitter/r/1396>`_\n\n* Properly detect existence of a symlink\n  `RB #1437 <https://rbcommons.com/s/twitter/r/1437>`_\n\n* Avoid throwing in `ApacheThriftGen.__init__`\n  `RB #1428 <https://rbcommons.com/s/twitter/r/1428>`_\n\n* Fix error message in scrooge_gen\n  `RB #1426 <https://rbcommons.com/s/twitter/r/1426>`_\n\n* Fixup `BuildGraph` to handle mixes of synthetic and BUILD targets\n  `RB #1420 <https://rbcommons.com/s/twitter/r/1420>`_\n\n* Fix antlr package derivation\n  `RB #1410 <https://rbcommons.com/s/twitter/r/1410>`_\n\n* Exit workers on sigint rather than ignore\n  `RB #1405 <https://rbcommons.com/s/twitter/r/1405>`_\n\n* Fix error in string formatting\n  `RB #1416 <https://rbcommons.com/s/twitter/r/1416>`_\n\n* Add missing class\n  `RB #1414 <https://rbcommons.com/s/twitter/r/1414>`_\n\n* Add missing import for dedent in `resource_mapping.py`\n  `RB #1403 <https://rbcommons.com/s/twitter/r/1403>`_\n\n* Replace twitter commons dirutil Lock with lockfile wrapper\n  `RB #1390 <https://rbcommons.com/s/twitter/r/1390>`_\n\n* Make `interpreter_cache` a property, acquire lock in accessor\n  `Issue #819 <https://github.com/pantsbuild/pants/issues/819>`_\n  `RB #1392 <https://rbcommons.com/s/twitter/r/1392>`_\n\n* Fix `.proto` files with unicode characters in the comments\n  `RB #1330 <https://rbcommons.com/s/twitter/r/1330>`_\n\n* Make `pants goal run` for Python exit with error code 1 if the python program exits non-zero\n  `RB #1374 <https://rbcommons.com/s/twitter/r/1374>`_\n\n* Fix a bug related to adding sibling resource bases\n  `RB #1367 <https://rbcommons.com/s/twitter/r/1367>`_\n\n* Support for the `--kill-nailguns` option was inadvertently removed, this puts it back\n  `RB #1352 <https://rbcommons.com/s/twitter/r/1352>`_\n\n* fix string formatting so `test -h` does not crash\n  `RB #1353 <https://rbcommons.com/s/twitter/r/1353>`_\n\n* Fix java_sources missing dep detection\n  `RB #1336 <https://rbcommons.com/s/twitter/r/1336>`_\n\n* Fix a nasty bug when injecting target closures in BuildGraph\n  `RB #1337 <https://rbcommons.com/s/twitter/r/1337>`_\n\n* Switch `src/*` usages of `Config.load` to use `Config.from_cache` instead\n  `RB #1319 <https://rbcommons.com/s/twitter/r/1319>`_\n\n* Optimize `what_changed`, remove un-needed extra sort\n  `RB #1291 <https://rbcommons.com/s/twitter/r/1291>`_\n\n* Fix `DetectDuplicate`\'s handling of an `append`-type flag\n  `RB #1282 <https://rbcommons.com/s/twitter/r/1282>`_\n\n* Deeper selection of internal targets during publishing\n  `RB #1213 <https://rbcommons.com/s/twitter/r/1213>`_\n\n* Correctly parse named_is_latest entries from the pushdb\n  `RB #1245 <https://rbcommons.com/s/twitter/r/1245>`_\n\n* Fix error message: add missing space\n  `RB #1266 <https://rbcommons.com/s/twitter/r/1266>`_\n\n* WikiArtifact instances also have provides; limit ivy to jvm\n  `RB #1259 <https://rbcommons.com/s/twitter/r/1259>`_\n\n* Fix `[run.junit]` -> `[test.junit]`\n  `RB #1256 <https://rbcommons.com/s/twitter/r/1256>`_\n\n* Fix signature in `goal targets` and BUILD dictionary\n  `RB #1253 <https://rbcommons.com/s/twitter/r/1253>`_\n\n* Fix the regression introduced in https://rbcommons.com/s/twitter/r/1186\n  `RB #1254 <https://rbcommons.com/s/twitter/r/1254>`_\n\n* Temporarily change `stderr` log level to silence `log.init` if `--quiet`\n  `RB #1243 <https://rbcommons.com/s/twitter/r/1243>`_\n\n* Add the environment\'s `PYTHONPATH` to `sys.path` when running dev pants\n  `RB #1237 <https://rbcommons.com/s/twitter/r/1237>`_\n\n* Remove `java_sources` as target roots for scala library in `depmap` project info\n  `Issue #670 <https://github.com/pantsbuild/pants/issues/670>`_\n  `RB #1190 <https://rbcommons.com/s/twitter/r/1190>`_\n\n* Allow UTF-8 characters in changelog\n  `RB #1228 <https://rbcommons.com/s/twitter/r/1228>`_\n\n* Ensure proper semantics when replacing all tasks in a goal\n  `RB #1220 <https://rbcommons.com/s/twitter/r/1220>`_\n  `RB #1221 <https://rbcommons.com/s/twitter/r/1221>`_\n\n* Fix reading of `scalac` plugin info from config\n  `RB #1217 <https://rbcommons.com/s/twitter/r/1217>`_\n\n* Dogfood bintray for pants support binaries\n  `RB #1208 <https://rbcommons.com/s/twitter/r/1208>`_\n\n* Do not crash on unicode filenames\n  `RB #1193 <https://rbcommons.com/s/twitter/r/1193>`_\n  `RB #1209 <https://rbcommons.com/s/twitter/r/1209>`_\n\n* In the event of an exception in `jvmdoc_gen`, call `get()` on the remaining futures\n  `RB #1202 <https://rbcommons.com/s/twitter/r/1202>`_\n\n* Move `workdirs` creation from `__init__` to `pre_execute` in jvm_compile & Remove\n  `QuietTaskMixin` from several tasks\n  `RB #1173 <https://rbcommons.com/s/twitter/r/1173>`_\n\n* Switch from `os.rename` to `shutil.move` to support cross-fs renames when needed\n  `RB #1157 <https://rbcommons.com/s/twitter/r/1157>`_\n\n* Fix scalastyle task, wire it up, make configs optional\n  `RB #1145 <https://rbcommons.com/s/twitter/r/1145>`_\n\n* Fix issue 668: make `release.sh` execute packaged pants without loading internal backends\n  during testing\n  `Issue #668 <https://github.com/pantsbuild/pants/issues/668>`_\n  `RB #1158 <https://rbcommons.com/s/twitter/r/1158>`_\n\n* Add `payload.get_field_value()` to fix KeyError from `pants goal idea testprojects::`\n  `RB #1150 <https://rbcommons.com/s/twitter/r/1150>`_\n\n* Remove `debug_args` from `pants.ini`\n  `Issue #650 <https://github.com/pantsbuild/pants/issues/650>`_\n  `RB #1137 <https://rbcommons.com/s/twitter/r/1137>`_\n\n* When a jvm doc tool (e.g. scaladoc) fails in combined mode, throw an exception\n  `RB #1116 <https://rbcommons.com/s/twitter/r/1116>`_\n\n* Remove hack to add java_sources in context\n  `RB #1130 <https://rbcommons.com/s/twitter/r/1130>`_\n\n* Memoize `Address.__hash__` computation\n  `RB #1118 <https://rbcommons.com/s/twitter/r/1118>`_\n\n* Add missing coverage deps\n  `RB #1117 <https://rbcommons.com/s/twitter/r/1117>`_\n\n* get `goal targets` using similar codepath to `goal builddict`\n  `RB #1112 <https://rbcommons.com/s/twitter/r/1112>`_\n\n* Memoize fingerprints by the FPStrategy hash\n  `RB #1119 <https://rbcommons.com/s/twitter/r/1119>`_\n\n* Factor in the jvm version string into the nailgun executor fingerprint\n  `RB #1122 <https://rbcommons.com/s/twitter/r/1122>`_\n\n* Fix some error reporting issues\n  `RB #1113 <https://rbcommons.com/s/twitter/r/1113>`_\n\n* Retry on failed scm push; also, pull with rebase to increase the odds of success\n  `RB #1083 <https://rbcommons.com/s/twitter/r/1083>`_\n\n* Make sure that \'option java_package\' always overrides \'package\' in protobuf_gen\n  `RB #1108 <https://rbcommons.com/s/twitter/r/1108>`_\n\n* Fix order-dependent force handling: if a version is forced in one place, it is forced everywhere\n  `RB #1085 <https://rbcommons.com/s/twitter/r/1085>`_\n\n* Survive targets without derivations\n  `RB #1066 <https://rbcommons.com/s/twitter/r/1066>`_\n\n* Make `internal_backend` plugins 1st class local pants plugins\n  `RB #1073 <https://rbcommons.com/s/twitter/r/1073>`_\n\n0.0.24 (9/23/2014)\n------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Add a whitelist to jvm dependency analyzer\n  `RB #888 <https://rbcommons.com/s/twitter/r/888>`_\n\n* Refactor exceptions in build_file.py and build_file_parser.py to derive from a common baseclass\n  and eliminate throwing `IOError`.\n  `RB #954 <https://rbcommons.com/s/twitter/r/954>`_\n\n* Support absolute paths on the command line when they start with the build root\n  `RB #867 <https://rbcommons.com/s/twitter/r/867>`_\n\n* Make `::` fail for an invalid dir much like `:` does for a dir with no BUILD file\n  `Issue #484 <https://github.com/pantsbuild/pants/issues/484>`_\n  `RB #907 <https://rbcommons.com/s/twitter/r/907>`_\n\n* Deprecate `pants` & `dependencies` aliases and remove `config`, `goal`, `phase`,\n  `get_scm` & `set_scm` aliases\n  `RB #899 <https://rbcommons.com/s/twitter/r/899>`_\n  `RB #903 <https://rbcommons.com/s/twitter/r/903>`_\n  `RB #912 <https://rbcommons.com/s/twitter/r/912>`_\n\n* Export test infrastructure for plugin writers to use in `pantsbuild.pants.testinfra` sdist\n  `Issue #539 <https://github.com/pantsbuild/pants/issues/539>`_\n  `RB #997 <https://rbcommons.com/s/twitter/r/997>`_\n  `RB #1004 <https://rbcommons.com/s/twitter/r/1004>`_\n\n* Publishing improvements:\n\n  - Add support for doing remote publishes with an explicit snapshot name\n  - One publish/push db file per artifact\n\n  `RB #923 <https://rbcommons.com/s/twitter/r/923>`_\n  `RB #994 <https://rbcommons.com/s/twitter/r/994>`_\n\n* Several improvements to `IdeGen` derived goals:\n\n  - Adds the `--<goal>-use-source-root` for IDE project generation tasks\n  - Added `--idea-exclude-maven-target` to keep IntelliJ from indexing \'target\' directories\n  - Changes the behavior of goal idea to create a subdirectory named for the project name\n  - Added `exclude-folders` option in pants.ini, defaulted to excluding a few dirs in `.pants.d`\n\n  `Issue #564 <https://github.com/pantsbuild/pants/issues/564>`_\n  `RB #1006 <https://rbcommons.com/s/twitter/r/1006>`_\n  `RB #1017 <https://rbcommons.com/s/twitter/r/1017>`_\n  `RB #1019 <https://rbcommons.com/s/twitter/r/1019>`_\n  `RB #1023 <https://rbcommons.com/s/twitter/r/1023>`_\n\n* Enhancements to the `depmap` goal to support IDE plugins:\n\n  - Add flag to dump project info output to file\n  - Add missing resources to targets\n  - Add content type to project Info\n\n  `Issue #5 <https://github.com/pantsbuild/intellij-pants-plugin/issues/5>`_\n  `RB #964 <https://rbcommons.com/s/twitter/r/964>`_\n  `RB #987 <https://rbcommons.com/s/twitter/r/987>`_\n  `RB #998 <https://rbcommons.com/s/twitter/r/998>`_\n\n* Make `SourceRoot` fundamentally understand a rel_path\n  `RB #1036 <https://rbcommons.com/s/twitter/r/1036>`_\n\n* Added thrift-linter to pants\n  `RB #1044 <https://rbcommons.com/s/twitter/r/1044>`_\n\n* Support limiting coverage measurements globally by module or path\n  `Issue #328 <https://github.com/pantsbuild/pants/issues/328>`_\n  `Issue #369 <https://github.com/pantsbuild/pants/issues/369>`_\n  `RB #1034 <https://rbcommons.com/s/twitter/r/1034>`_\n\n* Update interpreter_cache.py to support a repo-wide interpreter requirement\n  `RB #1025 <https://rbcommons.com/s/twitter/r/1025>`_\n\n* Changed goal markdown:\n\n  - Writes output to `./dist/markdown/`\n  - Pages can include snippets from source files\n    `<http://pantsbuild.github.io/page.html#include-a-file-snippet>`_\n\n  `Issue #535 <https://github.com/pantsbuild/pants/issues/535>`_\n  `RB #949 <https://rbcommons.com/s/twitter/r/949>`_\n  `RB #961 <https://rbcommons.com/s/twitter/r/961>`_\n\n* Rename `Phase` -> `Goal`\n  `RB #856 <https://rbcommons.com/s/twitter/r/856>`_\n  `RB #879 <https://rbcommons.com/s/twitter/r/879>`_\n  `RB #880 <https://rbcommons.com/s/twitter/r/880>`_\n  `RB #887 <https://rbcommons.com/s/twitter/r/887>`_\n  `RB #890 <https://rbcommons.com/s/twitter/r/890>`_\n  `RB #910 <https://rbcommons.com/s/twitter/r/910>`_\n  `RB #913 <https://rbcommons.com/s/twitter/r/913>`_\n  `RB #915 <https://rbcommons.com/s/twitter/r/915>`_\n  `RB #931 <https://rbcommons.com/s/twitter/r/931>`_\n\n* Android support additions:\n\n  - Add `AaptBuild` task\n  - Add `JarsignerTask` and `Keystore` target\n\n  `RB #859 <https://rbcommons.com/s/twitter/r/859>`_\n  `RB #883 <https://rbcommons.com/s/twitter/r/883>`_\n\n* Git/Scm enhancements:\n\n  - Allow the buildroot to be a subdirectory of the git worktree\n  - Support getting the commit date of refs\n  - Add merge-base and origin url properties to git\n\n  `Issue #405 <https://github.com/pantsbuild/pants/issues/405>`_\n  `RB #834 <https://rbcommons.com/s/twitter/r/834>`_\n  `RB #871 <https://rbcommons.com/s/twitter/r/871>`_\n  `RB #884 <https://rbcommons.com/s/twitter/r/884>`_\n  `RB #886 <https://rbcommons.com/s/twitter/r/886>`_\n\nBugfixes\n~~~~~~~~\n\n* Numerous doc improvements & generation fixes\n  `Issue #397 <https://github.com/pantsbuild/pants/issues/397>`_\n  `Issue #451 <https://github.com/pantsbuild/pants/issues/451>`_\n  `Issue #475 <https://github.com/pantsbuild/pants/issues/475>`_\n  `RB #863 <https://rbcommons.com/s/twitter/r/863>`_\n  `RB #865 <https://rbcommons.com/s/twitter/r/865>`_\n  `RB #873 <https://rbcommons.com/s/twitter/r/873>`_\n  `RB #876 <https://rbcommons.com/s/twitter/r/876>`_\n  `RB #885 <https://rbcommons.com/s/twitter/r/885>`_\n  `RB #938 <https://rbcommons.com/s/twitter/r/938>`_\n  `RB #953 <https://rbcommons.com/s/twitter/r/953>`_\n  `RB #960 <https://rbcommons.com/s/twitter/r/960>`_\n  `RB #965 <https://rbcommons.com/s/twitter/r/965>`_\n  `RB #992 <https://rbcommons.com/s/twitter/r/992>`_\n  `RB #995 <https://rbcommons.com/s/twitter/r/995>`_\n  `RB #1007 <https://rbcommons.com/s/twitter/r/1007>`_\n  `RB #1008 <https://rbcommons.com/s/twitter/r/1008>`_\n  `RB #1018 <https://rbcommons.com/s/twitter/r/1018>`_\n  `RB #1020 <https://rbcommons.com/s/twitter/r/1020>`_\n  `RB #1048 <https://rbcommons.com/s/twitter/r/1048>`_\n\n* Fixup missing \'page.mustache\' resource for `markdown` goal\n  `Issue #498 <https://github.com/pantsbuild/pants/issues/498>`_\n  `RB #918 <https://rbcommons.com/s/twitter/r/918>`_\n\n* Publishing fixes:\n\n  - Fix credentials fetching during publishing\n  - Skipping a doc phase should result in transitive deps being skipped as well\n\n  `RB #901 <https://rbcommons.com/s/twitter/r/901>`_\n  `RB #1011 <https://rbcommons.com/s/twitter/r/1011>`_\n\n* Several `IdeGen` derived task fixes:\n\n  - Fix eclipse_gen & idea_gen for targets with both java and scala\n  - Fixup EclipseGen resources globs to include prefs.\n  - When a directory contains both `java_library` and `junit_tests` targets, make sure the IDE\n    understands this is a test path, not a lib path\n\n  `RB #857 <https://rbcommons.com/s/twitter/r/857>`_\n  `RB #916 <https://rbcommons.com/s/twitter/r/916>`_\n  `RB #996 <https://rbcommons.com/s/twitter/r/996>`_\n\n* Fixes to the `depmap` goal to support IDE plugins:\n\n  - Fixed source roots in project info in case of `ScalaLibrary` with `java_sources`\n  - Fix `--depmap-project-info` for scala sources with the same package_prefix\n  - Fix depmap KeyError\n\n  `RB #955 <https://rbcommons.com/s/twitter/r/955>`_\n  `RB #990 <https://rbcommons.com/s/twitter/r/990>`_\n  `RB #1015 <https://rbcommons.com/s/twitter/r/1015>`_\n\n* Make a better error message when os.symlink fails during bundle\n  `RB #1037 <https://rbcommons.com/s/twitter/r/1037>`_\n\n* Faster source root operations - update the internal data structure to include a tree\n  `RB #1003 <https://rbcommons.com/s/twitter/r/1003>`_\n\n* The goal filter\'s --filter-ancestor parameter works better now\n  `Issue #506 <https://github.com/pantsbuild/pants/issues/506>`_\n  `RB #925 <https://rbcommons.com/s/twitter/r/925/>`_\n\n* Fix: goal markdown failed to load page.mustache\n  `Issue #498 <https://github.com/pantsbuild/pants/issues/498>`_\n  `RB #918 <https://rbcommons.com/s/twitter/r/918>`_\n\n* Fix the `changed` goal so it can be run in a repo with a directory called \'build\'\n  `RB #872 <https://rbcommons.com/s/twitter/r/872>`_\n\n* Patch `JvmRun` to accept `JvmApp`s\n  `RB #893 <https://rbcommons.com/s/twitter/r/893>`_\n\n* Add python as default codegen product\n  `RB #894 <https://rbcommons.com/s/twitter/r/894>`_\n\n* Fix the `filedeps` goal - it was using a now-gone .expand_files() API\n  `Issue #437 <https://github.com/pantsbuild/pants/issues/437>`_,\n  `RB #939 <https://rbcommons.com/s/twitter/r/939>`_\n\n* Put back error message that shows path to missing BUILD files\n  `RB #929 <https://rbcommons.com/s/twitter/r/929>`_\n\n* Make sure the `junit_run` task only runs on targets that are junit compatible\n  `Issue #508 <https://github.com/pantsbuild/pants/issues/508>`_\n  `RB #924 <https://rbcommons.com/s/twitter/r/924>`_\n\n* Fix `./pants goal targets`\n  `Issue #333 <https://github.com/pantsbuild/pants/issues/333>`_\n  `RB #796 <https://rbcommons.com/s/twitter/r/796>`_\n  `RB #914 <https://rbcommons.com/s/twitter/r/914>`_\n\n* Add `derived_from` to `ScroogeGen` synthetic targets\n  `RB #926 <https://rbcommons.com/s/twitter/r/926>`_\n\n* Properly order resources for pants goal test and pants goal run\n  `RB #845 <https://rbcommons.com/s/twitter/r/845>`_\n\n* Fixup Dependencies to be mainly target-type agnostic\n  `Issue #499 <https://github.com/pantsbuild/pants/issues/499>`_\n  `RB #920 <https://rbcommons.com/s/twitter/r/920>`_\n\n* Fixup JvmRun only-write-cmd-line flag to accept relative paths\n  `Issue #494 <https://github.com/pantsbuild/pants/issues/494>`_\n  `RB #908 <https://rbcommons.com/s/twitter/r/908>`_\n  `RB #911 <https://rbcommons.com/s/twitter/r/911>`_\n\n* Fix the `--ivy-report` option and add integration test\n  `RB #976 <https://rbcommons.com/s/twitter/r/976>`_\n\n* Fix a regression in Emma/Cobertura and add tests\n  `Issue #508 <https://github.com/pantsbuild/pants/issues/508>`_\n  `RB #935 <https://rbcommons.com/s/twitter/r/935>`_\n\n0.0.23 (8/11/2014)\n------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Remove unused Task.invalidate_for method and unused extra_data variable\n  `RB #849 <https://rbcommons.com/s/twitter/r/849>`_\n\n* Add DxCompile task to android backend\n  `RB #840 <https://rbcommons.com/s/twitter/r/840>`_\n\n* Change all Task subclass constructor args to (\\*args, \\**kwargs)\n  `RB #846 <https://rbcommons.com/s/twitter/r/846>`_\n\n* The public API for the new options system\n  `Issue #425 <https://github.com/pantsbuild/pants/pull/425>`_\n  `RB #831 <https://rbcommons.com/s/twitter/r/831>`_\n  `RB #819 <https://rbcommons.com/s/twitter/r/819>`_\n\n* Rename pants.goal.goal.Goal to pants.goal.task_registrar.TaskRegistrar\n  `Issue #345 <https://github.com/pantsbuild/pants/pull/345>`_\n  `RB #843 <https://rbcommons.com/s/twitter/r/843>`_\n\nBugfixes\n~~~~~~~~\n\n* Better validation for AndroidTarget manifest field\n  `RB #860 <https://rbcommons.com/s/twitter/r/860>`_\n\n* Remove more references to /BUILD:target notation in docs\n  `RB #855 <https://rbcommons.com/s/twitter/r/855>`_\n  `RB #853 <https://rbcommons.com/s/twitter/r/853>`_\n\n* Fix up the error message when attempting to publish without any configured repos\n  `RB #850 <https://rbcommons.com/s/twitter/r/850>`_\n\n* Miscellaneous fixes to protobuf codegen including handling collisions deterministically\n  `RB #720 <https://rbcommons.com/s/twitter/r/720>`_\n\n* Migrate some reasonable default values from pants.ini into \'defaults\' in the pants source\n  `Issue #455 <https://github.com/pantsbuild/pants/pull/455>`_\n  `Issue #456 <https://github.com/pantsbuild/pants/pull/456>`_\n  `Issue #458 <https://github.com/pantsbuild/pants/pull/458>`_\n  `RB #852 <https://rbcommons.com/s/twitter/r/852>`_\n\n* Updated the basename and name of some targets to prevent colliding bundles in dist/\n  `RB #847 <https://rbcommons.com/s/twitter/r/847>`_\n\n* Provide a better error message when referencing the wrong path to a BUILD file\n  `RB #841 <https://rbcommons.com/s/twitter/r/841>`_\n\n* Add assert_list to ensure an argument is a list - use this to better validate many targets\n  `RB #811 <https://rbcommons.com/s/twitter/r/811>`_\n\n* Update front-facing help and error messages for Android targets/tasks\n  `RB #837 <https://rbcommons.com/s/twitter/r/837>`_\n\n* Use JvmFingerprintStrategy in cache manager\n  `RB #835 <https://rbcommons.com/s/twitter/r/835>`_\n\n0.0.22 (8/4/2014)\n-----------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Upgrade pex dependency from twitter.common.python 0.6.0 to pex 0.7.0\n  `RB #825 <https://rbcommons.com/s/twitter/r/825>`_\n\n* Added a --spec-exclude command line flag to exclude specs by regular expression\n  `RB #747 <https://rbcommons.com/s/twitter/r/747>`_\n\n* Upgrade requests, flip to a ranged requirement to help plugins\n  `RB #771 <https://rbcommons.com/s/twitter/r/771>`_\n\n* New goal ``ensime`` to generate Ensime projects for Emacs users\n  `RB #753 <https://rbcommons.com/s/twitter/r/753>`_\n\nBugfixes\n~~~~~~~~\n\n* `goal repl` consumes targets transitively\n  `RB #781 <https://rbcommons.com/s/twitter/r/781>`_\n\n* Fixup JvmCompile to always deliver non-None products that were required by downstream\n  `RB #794 <https://rbcommons.com/s/twitter/r/794>`_\n\n* Relativize classpath for non-ng java execution\n  `RB #804 <https://rbcommons.com/s/twitter/r/804>`_\n\n* Added some docs and a bugfix on debugging a JVM tool (like jar-tool or checkstyle) locally\n  `RB #791 <https://rbcommons.com/s/twitter/r/791>`_\n\n* Added an excludes attribute that is set to an empty set for all SourcePayload subclasses\n  `Issue #414 <https://github.com/pantsbuild/pants/pull/414>`_\n  `RB #793 <https://rbcommons.com/s/twitter/r/793>`_\n\n* Add binary fetching support for OSX 10.10 and populate thrift and protoc binaries\n  `RB #789 <https://rbcommons.com/s/twitter/r/789>`_\n\n* Fix the pants script exit status when bootstrapping fails\n  `RB #779 <https://rbcommons.com/s/twitter/r/779>`_\n\n* Added benchmark target to maven_layout()\n  `RB #780 <https://rbcommons.com/s/twitter/r/780>`_\n\n* Fixup a hole in external dependency listing wrt encoding\n  `RB #776 <https://rbcommons.com/s/twitter/r/776>`_\n\n* Force parsing for filtering specs\n  `RB #775 <https://rbcommons.com/s/twitter/r/775>`_\n\n* Fix a scope bug for java agent manifest writing\n  `RB #768 <https://rbcommons.com/s/twitter/r/768>`_\n  `RB #770 <https://rbcommons.com/s/twitter/r/770>`_\n\n* Plumb ivysettings.xml location to the publish template\n  `RB #764 <https://rbcommons.com/s/twitter/r/764>`_\n\n* Fix goal markdown: README.html pages clobbered each other\n  `RB #750 <https://rbcommons.com/s/twitter/r/750>`_\n\n0.0.21 (7/25/2014)\n------------------\n\nBugfixes\n~~~~~~~~\n\n* Fixup NailgunTasks with missing config_section overrides\n  `RB # 762 <https://rbcommons.com/s/twitter/r/762>`_\n\n0.0.20 (7/25/2014)\n------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Hide stack traces by default\n  `Issue #326 <https://github.com/pantsbuild/pants/issues/326>`_\n  `RB #655 <https://rbcommons.com/s/twitter/r/655>`_\n\n* Upgrade to ``twitter.common.python`` 0.6.0 and adjust to api change\n  `RB #746 <https://rbcommons.com/s/twitter/r/746>`_\n\n* Add support for `Cobertura <http://cobertura.github.io/cobertura>`_ coverage\n  `Issue #70 <https://github.com/pantsbuild/pants/issues/70>`_\n  `RB #637 <https://rbcommons.com/s/twitter/r/637>`_\n\n* Validate that ``junit_tests`` targets have non-empty sources\n  `RB #619 <https://rbcommons.com/s/twitter/r/619>`_\n\n* Add support for the `Ragel <http://www.complang.org/ragel>`_ state-machine generator\n  `Issue #353 <https://github.com/pantsbuild/pants/issues/353>`_\n  `RB #678 <https://rbcommons.com/s/twitter/r/678>`_\n\n* Add ``AndroidTask`` and ``AaptGen`` tasks\n  `RB #672 <https://rbcommons.com/s/twitter/r/672>`_\n  `RB #676 <https://rbcommons.com/s/twitter/r/676>`_\n  `RB #700 <https://rbcommons.com/s/twitter/r/700>`_\n\nBugfixes\n~~~~~~~~\n\n* Numerous doc fixes\n  `Issue #385 <https://github.com/pantsbuild/pants/issues/385>`_\n  `Issue #387 <https://github.com/pantsbuild/pants/issues/387>`_\n  `Issue #395 <https://github.com/pantsbuild/pants/issues/395>`_\n  `RB #728 <https://rbcommons.com/s/twitter/r/728>`_\n  `RB #729 <https://rbcommons.com/s/twitter/r/729>`_\n  `RB #730 <https://rbcommons.com/s/twitter/r/730>`_\n  `RB #738 <https://rbcommons.com/s/twitter/r/738>`_\n\n* Expose types needed to specify ``jvm_binary.deploy_jar_rules``\n  `Issue #383 <https://github.com/pantsbuild/pants/issues/383>`_\n  `RB #727 <https://rbcommons.com/s/twitter/r/727>`_\n\n* Require information about jars in ``depmap`` with ``--depmap-project-info``\n  `RB #721 <https://rbcommons.com/s/twitter/r/721>`_\n\n0.0.19 (7/23/2014)\n------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Enable Nailgun Per Task\n  `RB #687 <https://rbcommons.com/s/twitter/r/687>`_\n\nBugfixes\n~~~~~~~~\n\n* Numerous doc fixes\n  `RB #699 <https://rbcommons.com/s/twitter/r/699>`_\n  `RB #703 <https://rbcommons.com/s/twitter/r/703>`_\n  `RB #704 <https://rbcommons.com/s/twitter/r/704>`_\n\n* Fixup broken ``bundle`` alias\n  `Issue #375 <https://github.com/pantsbuild/pants/issues/375>`_\n  `RB #722 <https://rbcommons.com/s/twitter/r/722>`_\n\n* Remove dependencies on ``twitter.common.{dirutil,contextutils}``\n  `RB #710 <https://rbcommons.com/s/twitter/r/710>`_\n  `RB #713 <https://rbcommons.com/s/twitter/r/713>`_\n  `RB #717 <https://rbcommons.com/s/twitter/r/717>`_\n  `RB #718 <https://rbcommons.com/s/twitter/r/718>`_\n  `RB #719 <https://rbcommons.com/s/twitter/r/719>`_\n  `RB #726 <https://rbcommons.com/s/twitter/r/726>`_\n\n* Fixup missing ``JunitRun`` resources requirement\n  `RB #709 <https://rbcommons.com/s/twitter/r/709>`_\n\n* Fix transitive dependencies for ``GroupIterator``/``GroupTask``\n  `RB #706 <https://rbcommons.com/s/twitter/r/706>`_\n\n* Ensure resources are prepared after compile\n  `Issue #373 <http://github.com/pantsbuild/pants/issues/373>`_\n  `RB #708 <https://rbcommons.com/s/twitter/r/708>`_\n\n* Upgrade to ``twitter.common.python`` 0.5.10 to brings in the following bugfix::\n\n    Update the mtime on retranslation of existing distributions.\n\n    1bff97e stopped existing distributions from being overwritten, to\n    prevent subtle errors. However without updating the mtime these\n    distributions will appear to be permanently expired wrt the ttl.\n\n  `RB #707 <https://rbcommons.com/s/twitter/r/707>`_\n\n* Resurrected pants goal idea with work remaining on source and javadoc jar mapping\n  `RB #695 <https://rbcommons.com/s/twitter/r/695>`_\n\n* Fix BinaryUtil raise of BinaryNotFound\n  `Issue #367 <https://github.com/pantsbuild/pants/issues/367>`_\n  `RB #705 <https://rbcommons.com/s/twitter/r/705>`_\n\n0.0.18 (7/16/2014)\n------------------\n\nAPI Changes\n~~~~~~~~~~~\n\n* Lock globs into ``rootdir`` and below\n  `Issue #348 <https://github.com/pantsbuild/pants/issues/348>`_\n  `RB #686 <https://rbcommons.com/s/twitter/r/686>`_\n\nBugfixes\n~~~~~~~~\n\n* Several doc fixes\n  `RB #654 <https://rbcommons.com/s/twitter/r/654>`_\n  `RB #693 <https://rbcommons.com/s/twitter/r/693>`_\n\n* Fix relativity of antlr sources\n  `RB #679 <https://rbcommons.com/s/twitter/r/679>`_\n\n0.0.17 (7/15/2014)\n------------------\n\n* Initial published version of ``pantsbuild.pants``\n',
    'name': 'pantsbuild.pants.contrib.node',
    'namespace_packages': ['pants', 'pants.contrib'],
    'package_data': {   },
    'package_dir': {   '': 'src'},
    'packages': [   'pants',
                    'pants.contrib',
                    'pants.contrib.node',
                    'pants.contrib.node.subsystems',
                    'pants.contrib.node.subsystems.resolvers',
                    'pants.contrib.node.targets',
                    'pants.contrib.node.tasks'],
    'url': 'https://github.com/pantsbuild/pants',
    'version': '0.0.79',
    'zip_safe': True}
)
