# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from client.models.env_var import EnvVar
from client.models.mounted_mlp_secret import MountedMLPSecret
from client.models.prediction_job_config import PredictionJobConfig
from client.models.prediction_job_resource_request import PredictionJobResourceRequest
from client.models.resource_request import ResourceRequest
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Config(BaseModel):
    """
    Config
    """ # noqa: E501
    job_config: Optional[PredictionJobConfig] = None
    image_ref: Optional[StrictStr] = None
    service_account_name: Optional[StrictStr] = None
    resource_request: Optional[PredictionJobResourceRequest] = None
    image_builder_resource_request: Optional[ResourceRequest] = None
    env_vars: Optional[List[EnvVar]] = None
    secrets: Optional[List[MountedMLPSecret]] = None
    __properties: ClassVar[List[str]] = ["job_config", "image_ref", "service_account_name", "resource_request", "image_builder_resource_request", "env_vars", "secrets"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job_config
        if self.job_config:
            _dict['job_config'] = self.job_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_request
        if self.resource_request:
            _dict['resource_request'] = self.resource_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_builder_resource_request
        if self.image_builder_resource_request:
            _dict['image_builder_resource_request'] = self.image_builder_resource_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in env_vars (list)
        _items = []
        if self.env_vars:
            for _item in self.env_vars:
                if _item:
                    _items.append(_item.to_dict())
            _dict['env_vars'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in secrets (list)
        _items = []
        if self.secrets:
            for _item in self.secrets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['secrets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_config": PredictionJobConfig.from_dict(obj.get("job_config")) if obj.get("job_config") is not None else None,
            "image_ref": obj.get("image_ref"),
            "service_account_name": obj.get("service_account_name"),
            "resource_request": PredictionJobResourceRequest.from_dict(obj.get("resource_request")) if obj.get("resource_request") is not None else None,
            "image_builder_resource_request": ResourceRequest.from_dict(obj.get("image_builder_resource_request")) if obj.get("image_builder_resource_request") is not None else None,
            "env_vars": [EnvVar.from_dict(_item) for _item in obj.get("env_vars")] if obj.get("env_vars") is not None else None,
            "secrets": [MountedMLPSecret.from_dict(_item) for _item in obj.get("secrets")] if obj.get("secrets") is not None else None
        })
        return _obj


