# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Container(BaseModel):
    """
    Container
    """ # noqa: E501
    name: Optional[StrictStr] = None
    pod_name: Optional[StrictStr] = None
    component_type: Optional[StrictStr] = None
    namespace: Optional[StrictStr] = None
    cluster: Optional[StrictStr] = None
    gcp_project: Optional[StrictStr] = None
    version_endpoint_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["name", "pod_name", "component_type", "namespace", "cluster", "gcp_project", "version_endpoint_id"]

    @field_validator('component_type')
    def component_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('image_builder', 'model', 'transformer', 'batch_job_driver', 'batch_job_executor'):
            raise ValueError("must be one of enum values ('image_builder', 'model', 'transformer', 'batch_job_driver', 'batch_job_executor')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Container from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Container from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "pod_name": obj.get("pod_name"),
            "component_type": obj.get("component_type"),
            "namespace": obj.get("namespace"),
            "cluster": obj.get("cluster"),
            "gcp_project": obj.get("gcp_project"),
            "version_endpoint_id": obj.get("version_endpoint_id")
        })
        return _obj


