# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class GroundTruthJob(BaseModel):
    """
    GroundTruthJob
    """ # noqa: E501
    cron_schedule: StrictStr
    cpu_request: Optional[StrictStr] = None
    cpu_limit: Optional[StrictStr] = None
    memory_request: Optional[StrictStr] = None
    memory_limit: Optional[StrictStr] = None
    start_day_offset_from_now: StrictInt
    end_day_offset_from_now: StrictInt
    grace_period_day: Optional[StrictInt] = None
    service_account_secret_name: StrictStr
    __properties: ClassVar[List[str]] = ["cron_schedule", "cpu_request", "cpu_limit", "memory_request", "memory_limit", "start_day_offset_from_now", "end_day_offset_from_now", "grace_period_day", "service_account_secret_name"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of GroundTruthJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of GroundTruthJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cron_schedule": obj.get("cron_schedule"),
            "cpu_request": obj.get("cpu_request"),
            "cpu_limit": obj.get("cpu_limit"),
            "memory_request": obj.get("memory_request"),
            "memory_limit": obj.get("memory_limit"),
            "start_day_offset_from_now": obj.get("start_day_offset_from_now"),
            "end_day_offset_from_now": obj.get("end_day_offset_from_now"),
            "grace_period_day": obj.get("grace_period_day"),
            "service_account_secret_name": obj.get("service_account_secret_name")
        })
        return _obj


