# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool
from client.models.ground_truth_job import GroundTruthJob
from client.models.ground_truth_source import GroundTruthSource
from client.models.prediction_log_ingestion_resource_request import PredictionLogIngestionResourceRequest
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ModelObservability(BaseModel):
    """
    ModelObservability
    """ # noqa: E501
    enabled: StrictBool
    ground_truth_source: Optional[GroundTruthSource] = None
    ground_truth_job: Optional[GroundTruthJob] = None
    prediction_log_ingestion_resource_request: Optional[PredictionLogIngestionResourceRequest] = None
    __properties: ClassVar[List[str]] = ["enabled", "ground_truth_source", "ground_truth_job", "prediction_log_ingestion_resource_request"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ModelObservability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ground_truth_source
        if self.ground_truth_source:
            _dict['ground_truth_source'] = self.ground_truth_source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ground_truth_job
        if self.ground_truth_job:
            _dict['ground_truth_job'] = self.ground_truth_job.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prediction_log_ingestion_resource_request
        if self.prediction_log_ingestion_resource_request:
            _dict['prediction_log_ingestion_resource_request'] = self.prediction_log_ingestion_resource_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ModelObservability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "ground_truth_source": GroundTruthSource.from_dict(obj.get("ground_truth_source")) if obj.get("ground_truth_source") is not None else None,
            "ground_truth_job": GroundTruthJob.from_dict(obj.get("ground_truth_job")) if obj.get("ground_truth_job") is not None else None,
            "prediction_log_ingestion_resource_request": PredictionLogIngestionResourceRequest.from_dict(obj.get("prediction_log_ingestion_resource_request")) if obj.get("prediction_log_ingestion_resource_request") is not None else None
        })
        return _obj


