# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from client.models.image_building_job_status import ImageBuildingJobStatus
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class VersionImage(BaseModel):
    """
    VersionImage
    """ # noqa: E501
    project_id: Optional[StrictInt] = None
    model_id: Optional[StrictInt] = None
    version_id: Optional[StrictInt] = None
    image_ref: Optional[StrictStr] = None
    exists: Optional[StrictBool] = None
    image_building_job_status: Optional[ImageBuildingJobStatus] = None
    __properties: ClassVar[List[str]] = ["project_id", "model_id", "version_id", "image_ref", "exists", "image_building_job_status"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of VersionImage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_building_job_status
        if self.image_building_job_status:
            _dict['image_building_job_status'] = self.image_building_job_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of VersionImage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "project_id": obj.get("project_id"),
            "model_id": obj.get("model_id"),
            "version_id": obj.get("version_id"),
            "image_ref": obj.get("image_ref"),
            "exists": obj.get("exists"),
            "image_building_job_status": ImageBuildingJobStatus.from_dict(obj.get("image_building_job_status")) if obj.get("image_building_job_status") is not None else None
        })
        return _obj


