# merlin-sdk
API Guide for accessing Merlin's model management, deployment, and serving functionalities

The `client` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.14.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3
* python-dateutil
* pydantic

## Getting Started

In your own code, to use this library to connect and interact with merlin-sdk,
you can run the following:

```python

import time
import client
from client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = client.Configuration(
    host = "http://localhost:8080/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer
configuration.api_key['Bearer'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer'] = 'Bearer'


# Enter a context with an instance of the API client
with client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = client.AlertApi(api_client)

    try:
        # Lists teams for alert notification channel.
        api_response = api_instance.alerts_teams_get()
        print("The response of AlertApi->alerts_teams_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AlertApi->alerts_teams_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertApi* | [**alerts_teams_get**](client/docs/AlertApi.md#alerts_teams_get) | **GET** /alerts/teams | Lists teams for alert notification channel.
*AlertApi* | [**models_model_id_alerts_get**](client/docs/AlertApi.md#models_model_id_alerts_get) | **GET** /models/{model_id}/alerts | Lists alerts for given model.
*AlertApi* | [**models_model_id_endpoints_model_endpoint_id_alert_get**](client/docs/AlertApi.md#models_model_id_endpoints_model_endpoint_id_alert_get) | **GET** /models/{model_id}/endpoints/{model_endpoint_id}/alert | Gets alert for given model endpoint.
*AlertApi* | [**models_model_id_endpoints_model_endpoint_id_alert_post**](client/docs/AlertApi.md#models_model_id_endpoints_model_endpoint_id_alert_post) | **POST** /models/{model_id}/endpoints/{model_endpoint_id}/alert | Creates alert for given model endpoint.
*AlertApi* | [**models_model_id_endpoints_model_endpoint_id_alert_put**](client/docs/AlertApi.md#models_model_id_endpoints_model_endpoint_id_alert_put) | **PUT** /models/{model_id}/endpoints/{model_endpoint_id}/alert | Creates alert for given model endpoint.
*EndpointApi* | [**models_model_id_versions_version_id_endpoint_endpoint_id_containers_get**](client/docs/EndpointApi.md#models_model_id_versions_version_id_endpoint_endpoint_id_containers_get) | **GET** /models/{model_id}/versions/{version_id}/endpoint/{endpoint_id}/containers | Get all container belong to a version endpoint
*EndpointApi* | [**models_model_id_versions_version_id_endpoint_endpoint_id_delete**](client/docs/EndpointApi.md#models_model_id_versions_version_id_endpoint_endpoint_id_delete) | **DELETE** /models/{model_id}/versions/{version_id}/endpoint/{endpoint_id} | Undeploy the specified model version deployment
*EndpointApi* | [**models_model_id_versions_version_id_endpoint_endpoint_id_get**](client/docs/EndpointApi.md#models_model_id_versions_version_id_endpoint_endpoint_id_get) | **GET** /models/{model_id}/versions/{version_id}/endpoint/{endpoint_id} | Get version endpoint resource
*EndpointApi* | [**models_model_id_versions_version_id_endpoint_endpoint_id_put**](client/docs/EndpointApi.md#models_model_id_versions_version_id_endpoint_endpoint_id_put) | **PUT** /models/{model_id}/versions/{version_id}/endpoint/{endpoint_id} | Modify version endpoint, this API will redeploy the associated deployment
*EndpointApi* | [**models_model_id_versions_version_id_endpoint_get**](client/docs/EndpointApi.md#models_model_id_versions_version_id_endpoint_get) | **GET** /models/{model_id}/versions/{version_id}/endpoint | List all endpoint of a model version
*EndpointApi* | [**models_model_id_versions_version_id_endpoint_post**](client/docs/EndpointApi.md#models_model_id_versions_version_id_endpoint_post) | **POST** /models/{model_id}/versions/{version_id}/endpoint | Deploy specific version of the models
*EnvironmentApi* | [**environments_get**](client/docs/EnvironmentApi.md#environments_get) | **GET** /environments | List available environment
*LogApi* | [**logs_get**](client/docs/LogApi.md#logs_get) | **GET** /logs | Retrieve log from a container
*ModelEndpointsApi* | [**models_model_id_endpoints_get**](client/docs/ModelEndpointsApi.md#models_model_id_endpoints_get) | **GET** /models/{model_id}/endpoints | List model endpoint
*ModelEndpointsApi* | [**models_model_id_endpoints_model_endpoint_id_delete**](client/docs/ModelEndpointsApi.md#models_model_id_endpoints_model_endpoint_id_delete) | **DELETE** /models/{model_id}/endpoints/{model_endpoint_id} | Stop serving traffic to the model endpoint, then delete it.
*ModelEndpointsApi* | [**models_model_id_endpoints_model_endpoint_id_get**](client/docs/ModelEndpointsApi.md#models_model_id_endpoints_model_endpoint_id_get) | **GET** /models/{model_id}/endpoints/{model_endpoint_id} | Get a model endpoint
*ModelEndpointsApi* | [**models_model_id_endpoints_model_endpoint_id_put**](client/docs/ModelEndpointsApi.md#models_model_id_endpoints_model_endpoint_id_put) | **PUT** /models/{model_id}/endpoints/{model_endpoint_id} | Update model endpoint data. Mainly used to update its rule.
*ModelEndpointsApi* | [**models_model_id_endpoints_post**](client/docs/ModelEndpointsApi.md#models_model_id_endpoints_post) | **POST** /models/{model_id}/endpoints | Create a model endpoint
*ModelEndpointsApi* | [**projects_project_id_model_endpoints_get**](client/docs/ModelEndpointsApi.md#projects_project_id_model_endpoints_get) | **GET** /projects/{project_id}/model_endpoints | List existing model endpoints for all models in particular project
*ModelSchemaApi* | [**models_model_id_schemas_get**](client/docs/ModelSchemaApi.md#models_model_id_schemas_get) | **GET** /models/{model_id}/schemas | List all of the model schemas
*ModelSchemaApi* | [**models_model_id_schemas_put**](client/docs/ModelSchemaApi.md#models_model_id_schemas_put) | **PUT** /models/{model_id}/schemas | Creating new schemas for a model
*ModelSchemaApi* | [**models_model_id_schemas_schema_id_delete**](client/docs/ModelSchemaApi.md#models_model_id_schemas_schema_id_delete) | **DELETE** /models/{model_id}/schemas/{schema_id} | Delete schema
*ModelSchemaApi* | [**models_model_id_schemas_schema_id_get**](client/docs/ModelSchemaApi.md#models_model_id_schemas_schema_id_get) | **GET** /models/{model_id}/schemas/{schema_id} | Get detail of the schema
*ModelsApi* | [**alerts_teams_get**](client/docs/ModelsApi.md#alerts_teams_get) | **GET** /alerts/teams | Lists teams for alert notification channel.
*ModelsApi* | [**models_model_id_alerts_get**](client/docs/ModelsApi.md#models_model_id_alerts_get) | **GET** /models/{model_id}/alerts | Lists alerts for given model.
*ModelsApi* | [**models_model_id_endpoints_model_endpoint_id_alert_get**](client/docs/ModelsApi.md#models_model_id_endpoints_model_endpoint_id_alert_get) | **GET** /models/{model_id}/endpoints/{model_endpoint_id}/alert | Gets alert for given model endpoint.
*ModelsApi* | [**models_model_id_endpoints_model_endpoint_id_alert_post**](client/docs/ModelsApi.md#models_model_id_endpoints_model_endpoint_id_alert_post) | **POST** /models/{model_id}/endpoints/{model_endpoint_id}/alert | Creates alert for given model endpoint.
*ModelsApi* | [**models_model_id_endpoints_model_endpoint_id_alert_put**](client/docs/ModelsApi.md#models_model_id_endpoints_model_endpoint_id_alert_put) | **PUT** /models/{model_id}/endpoints/{model_endpoint_id}/alert | Creates alert for given model endpoint.
*ModelsApi* | [**projects_project_id_models_get**](client/docs/ModelsApi.md#projects_project_id_models_get) | **GET** /projects/{project_id}/models | List existing models
*ModelsApi* | [**projects_project_id_models_model_id_delete**](client/docs/ModelsApi.md#projects_project_id_models_model_id_delete) | **DELETE** /projects/{project_id}/models/{model_id} | Delete model
*ModelsApi* | [**projects_project_id_models_model_id_get**](client/docs/ModelsApi.md#projects_project_id_models_model_id_get) | **GET** /projects/{project_id}/models/{model_id} | Get model
*ModelsApi* | [**projects_project_id_models_post**](client/docs/ModelsApi.md#projects_project_id_models_post) | **POST** /projects/{project_id}/models | Register a new models
*PredictionJobsApi* | [**models_model_id_versions_version_id_jobs_by_page_get**](client/docs/PredictionJobsApi.md#models_model_id_versions_version_id_jobs_by_page_get) | **GET** /models/{model_id}/versions/{version_id}/jobs-by-page | List all prediction jobs of a model version with pagination
*PredictionJobsApi* | [**models_model_id_versions_version_id_jobs_get**](client/docs/PredictionJobsApi.md#models_model_id_versions_version_id_jobs_get) | **GET** /models/{model_id}/versions/{version_id}/jobs | List all prediction jobs of a model version. This endpoint is deprecated. Please use the corresponding /jobs-by-page endpoint instead.
*PredictionJobsApi* | [**models_model_id_versions_version_id_jobs_job_id_containers_get**](client/docs/PredictionJobsApi.md#models_model_id_versions_version_id_jobs_job_id_containers_get) | **GET** /models/{model_id}/versions/{version_id}/jobs/{job_id}/containers | Get all container belong to a prediction job
*PredictionJobsApi* | [**models_model_id_versions_version_id_jobs_job_id_get**](client/docs/PredictionJobsApi.md#models_model_id_versions_version_id_jobs_job_id_get) | **GET** /models/{model_id}/versions/{version_id}/jobs/{job_id} | Get prediction jobs with given id
*PredictionJobsApi* | [**models_model_id_versions_version_id_jobs_job_id_stop_put**](client/docs/PredictionJobsApi.md#models_model_id_versions_version_id_jobs_job_id_stop_put) | **PUT** /models/{model_id}/versions/{version_id}/jobs/{job_id}/stop | Stop prediction jobs with given id
*PredictionJobsApi* | [**models_model_id_versions_version_id_jobs_post**](client/docs/PredictionJobsApi.md#models_model_id_versions_version_id_jobs_post) | **POST** /models/{model_id}/versions/{version_id}/jobs | Create a prediction job from the given model version
*PredictionJobsApi* | [**projects_project_id_jobs_by_page_get**](client/docs/PredictionJobsApi.md#projects_project_id_jobs_by_page_get) | **GET** /projects/{project_id}/jobs-by-page | List all prediction jobs created using the model with pagination
*PredictionJobsApi* | [**projects_project_id_jobs_get**](client/docs/PredictionJobsApi.md#projects_project_id_jobs_get) | **GET** /projects/{project_id}/jobs | List all prediction jobs created using the model. This endpoint is deprecated. Please use the corresponding /jobs-by-page endpoint instead.
*ProjectApi* | [**projects_get**](client/docs/ProjectApi.md#projects_get) | **GET** /projects | List existing projects
*ProjectApi* | [**projects_post**](client/docs/ProjectApi.md#projects_post) | **POST** /projects | Create new project
*ProjectApi* | [**projects_project_id_get**](client/docs/ProjectApi.md#projects_project_id_get) | **GET** /projects/{project_id} | Get project
*ProjectApi* | [**projects_project_id_put**](client/docs/ProjectApi.md#projects_project_id_put) | **PUT** /projects/{project_id} | Update project
*SecretApi* | [**projects_project_id_secrets_get**](client/docs/SecretApi.md#projects_project_id_secrets_get) | **GET** /projects/{project_id}/secrets | List secret
*SecretApi* | [**projects_project_id_secrets_post**](client/docs/SecretApi.md#projects_project_id_secrets_post) | **POST** /projects/{project_id}/secrets | Create secret
*SecretApi* | [**projects_project_id_secrets_secret_id_delete**](client/docs/SecretApi.md#projects_project_id_secrets_secret_id_delete) | **DELETE** /projects/{project_id}/secrets/{secret_id} | Delete secret
*SecretApi* | [**projects_project_id_secrets_secret_id_patch**](client/docs/SecretApi.md#projects_project_id_secrets_secret_id_patch) | **PATCH** /projects/{project_id}/secrets/{secret_id} | Update secret
*StandardTransformerApi* | [**standard_transformer_simulate_post**](client/docs/StandardTransformerApi.md#standard_transformer_simulate_post) | **POST** /standard_transformer/simulate | Simulate standard transformer
*VersionApi* | [**models_model_id_versions_get**](client/docs/VersionApi.md#models_model_id_versions_get) | **GET** /models/{model_id}/versions | List versions of the models
*VersionApi* | [**models_model_id_versions_post**](client/docs/VersionApi.md#models_model_id_versions_post) | **POST** /models/{model_id}/versions | Log a new version of the models
*VersionApi* | [**models_model_id_versions_version_id_delete**](client/docs/VersionApi.md#models_model_id_versions_version_id_delete) | **DELETE** /models/{model_id}/versions/{version_id} | Delete version by ID from model
*VersionApi* | [**models_model_id_versions_version_id_get**](client/docs/VersionApi.md#models_model_id_versions_version_id_get) | **GET** /models/{model_id}/versions/{version_id} | Get version by ID from model
*VersionApi* | [**models_model_id_versions_version_id_patch**](client/docs/VersionApi.md#models_model_id_versions_version_id_patch) | **PATCH** /models/{model_id}/versions/{version_id} | Patch the version 
*VersionImageApi* | [**models_model_id_versions_version_id_image_get**](client/docs/VersionImageApi.md#models_model_id_versions_version_id_image_get) | **GET** /models/{model_id}/versions/{version_id}/image | Get the Docker image for given model version
*VersionImageApi* | [**models_model_id_versions_version_id_image_put**](client/docs/VersionImageApi.md#models_model_id_versions_version_id_image_put) | **PUT** /models/{model_id}/versions/{version_id}/image | Build the Docker image for given model version


## Documentation For Models

 - [AlertConditionMetricType](client/docs/AlertConditionMetricType.md)
 - [AlertConditionSeverity](client/docs/AlertConditionSeverity.md)
 - [AutoscalingPolicy](client/docs/AutoscalingPolicy.md)
 - [BinaryClassificationOutput](client/docs/BinaryClassificationOutput.md)
 - [BuildImageOptions](client/docs/BuildImageOptions.md)
 - [Config](client/docs/Config.md)
 - [Container](client/docs/Container.md)
 - [CustomPredictor](client/docs/CustomPredictor.md)
 - [DeploymentMode](client/docs/DeploymentMode.md)
 - [EndpointStatus](client/docs/EndpointStatus.md)
 - [EnvVar](client/docs/EnvVar.md)
 - [Environment](client/docs/Environment.md)
 - [FileFormat](client/docs/FileFormat.md)
 - [GPUConfig](client/docs/GPUConfig.md)
 - [GPUToleration](client/docs/GPUToleration.md)
 - [GroundTruthJob](client/docs/GroundTruthJob.md)
 - [GroundTruthSource](client/docs/GroundTruthSource.md)
 - [ImageBuildingJobState](client/docs/ImageBuildingJobState.md)
 - [ImageBuildingJobStatus](client/docs/ImageBuildingJobStatus.md)
 - [Label](client/docs/Label.md)
 - [ListJobsPaginatedResponse](client/docs/ListJobsPaginatedResponse.md)
 - [Logger](client/docs/Logger.md)
 - [LoggerConfig](client/docs/LoggerConfig.md)
 - [LoggerMode](client/docs/LoggerMode.md)
 - [MetricsType](client/docs/MetricsType.md)
 - [MockResponse](client/docs/MockResponse.md)
 - [Model](client/docs/Model.md)
 - [ModelEndpoint](client/docs/ModelEndpoint.md)
 - [ModelEndpointAlert](client/docs/ModelEndpointAlert.md)
 - [ModelEndpointAlertCondition](client/docs/ModelEndpointAlertCondition.md)
 - [ModelEndpointRule](client/docs/ModelEndpointRule.md)
 - [ModelEndpointRuleDestination](client/docs/ModelEndpointRuleDestination.md)
 - [ModelObservability](client/docs/ModelObservability.md)
 - [ModelPredictionConfig](client/docs/ModelPredictionConfig.md)
 - [ModelPredictionOutput](client/docs/ModelPredictionOutput.md)
 - [ModelPredictionOutputClass](client/docs/ModelPredictionOutputClass.md)
 - [ModelSchema](client/docs/ModelSchema.md)
 - [MountedMLPSecret](client/docs/MountedMLPSecret.md)
 - [OperationTracing](client/docs/OperationTracing.md)
 - [Paging](client/docs/Paging.md)
 - [PipelineTracing](client/docs/PipelineTracing.md)
 - [PredictionJob](client/docs/PredictionJob.md)
 - [PredictionJobConfig](client/docs/PredictionJobConfig.md)
 - [PredictionJobConfigBigquerySink](client/docs/PredictionJobConfigBigquerySink.md)
 - [PredictionJobConfigBigquerySource](client/docs/PredictionJobConfigBigquerySource.md)
 - [PredictionJobConfigGcsSink](client/docs/PredictionJobConfigGcsSink.md)
 - [PredictionJobConfigGcsSource](client/docs/PredictionJobConfigGcsSource.md)
 - [PredictionJobConfigMaxcomputeSink](client/docs/PredictionJobConfigMaxcomputeSink.md)
 - [PredictionJobConfigMaxcomputeSource](client/docs/PredictionJobConfigMaxcomputeSource.md)
 - [PredictionJobConfigModel](client/docs/PredictionJobConfigModel.md)
 - [PredictionJobConfigModelResult](client/docs/PredictionJobConfigModelResult.md)
 - [PredictionJobResourceRequest](client/docs/PredictionJobResourceRequest.md)
 - [PredictionLogIngestionResourceRequest](client/docs/PredictionLogIngestionResourceRequest.md)
 - [PredictionLoggerConfig](client/docs/PredictionLoggerConfig.md)
 - [Project](client/docs/Project.md)
 - [Protocol](client/docs/Protocol.md)
 - [RankingOutput](client/docs/RankingOutput.md)
 - [RegressionOutput](client/docs/RegressionOutput.md)
 - [ResourceRequest](client/docs/ResourceRequest.md)
 - [ResultType](client/docs/ResultType.md)
 - [SaveMode](client/docs/SaveMode.md)
 - [SchemaSpec](client/docs/SchemaSpec.md)
 - [Secret](client/docs/Secret.md)
 - [StandardTransformerSimulationRequest](client/docs/StandardTransformerSimulationRequest.md)
 - [StandardTransformerSimulationResponse](client/docs/StandardTransformerSimulationResponse.md)
 - [Transformer](client/docs/Transformer.md)
 - [ValueType](client/docs/ValueType.md)
 - [Version](client/docs/Version.md)
 - [VersionEndpoint](client/docs/VersionEndpoint.md)
 - [VersionImage](client/docs/VersionImage.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Bearer"></a>
### Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




