from setuptools import setup, find_packages
import os

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="SnapQRpy",
    version="0.1.0",
    author="MERO",
    author_email="qp4rm@telegram.org",
    description="Advanced QR-based screen sharing and remote control system with consent management",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://t.me/QP4RM",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: System :: Networking",
        "Topic :: Multimedia :: Video :: Capture",
        "Topic :: Security :: Cryptography",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Operating System :: OS Independent",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: POSIX :: Linux",
        "Operating System :: MacOS",
        "Operating System :: Android",
        "Operating System :: iOS",
    ],
    python_requires=">=3.11",
    install_requires=[
        "qrcode>=7.4.2",
        "Pillow>=10.0.0",
        "opencv-python>=4.8.0",
        "numpy>=1.24.0",
        "websockets>=12.0",
        "aiohttp>=3.9.0",
        "cryptography>=41.0.0",
        "pycryptodome>=3.19.0",
        "asyncio>=3.4.3",
        "flask>=3.0.0",
        "fastapi>=0.104.0",
        "uvicorn>=0.24.0",
        "aiortc>=1.6.0",
        "pyotp>=2.9.0",
        "pyzbar>=0.1.9",
        "mss>=9.0.1",
        "pyautogui>=0.9.54",
        "pynput>=1.7.6",
        "scapy>=2.5.0",
        "netifaces>=0.11.0",
        "psutil>=5.9.6",
        "requests>=2.31.0",
        "pyzmq>=25.1.1",
        "msgpack>=1.0.7",
        "protobuf>=4.25.0",
        "grpcio>=1.59.0",
        "redis>=5.0.1",
        "pymongo>=4.6.0",
        "sqlalchemy>=2.0.23",
        "pydantic>=2.5.0",
        "click>=8.1.7",
        "rich>=13.7.0",
        "colorama>=0.4.6",
        "tqdm>=4.66.1",
        "tabulate>=0.9.0",
        "PyYAML>=6.0.1",
        "toml>=0.10.2",
        "python-dotenv>=1.0.0",
        "jsonschema>=4.20.0",
        "marshmallow>=3.20.1",
        "cerberus>=1.3.5",
        "bcrypt>=4.1.1",
        "passlib>=1.7.4",
        "PyJWT>=2.8.0",
        "itsdangerous>=2.1.2",
        "schedule>=1.2.0",
        "APScheduler>=3.10.4",
        "celery>=5.3.4",
        "kombu>=5.3.4",
        "billiard>=4.2.0",
        "amqp>=5.2.0",
        "vine>=5.1.0",
        "attrs>=23.1.0",
        "cattrs>=23.2.3",
        "typeguard>=4.1.5",
        "typing-extensions>=4.8.0",
        "packaging>=23.2",
        "setuptools>=69.0.0",
        "wheel>=0.42.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.4.3",
            "pytest-asyncio>=0.21.1",
            "pytest-cov>=4.1.0",
            "black>=23.12.0",
            "flake8>=6.1.0",
            "mypy>=1.7.1",
            "pylint>=3.0.3",
            "isort>=5.13.2",
            "autopep8>=2.0.4",
        ],
        "full": [
            "tornado>=6.4",
            "twisted>=23.10.0",
            "gevent>=23.9.1",
            "eventlet>=0.33.3",
            "gunicorn>=21.2.0",
            "hypercorn>=0.16.0",
        ],
    },
    entry_points={
        "console_scripts": [
            "snapqr=snapqrpy.cli.main:main",
            "snapqr-server=snapqrpy.server.main:run_server",
            "snapqr-client=snapqrpy.client.main:run_client",
            "snapqr-gui=snapqrpy.ui.gui:launch_gui",
        ],
    },
    include_package_data=True,
    package_data={
        "snapqrpy": [
            "config/*.cfg",
            "config/*.json",
            "config/*.yaml",
            "config/*.toml",
            "assets/**/*",
            "templates/**/*",
            "locales/**/*",
            "data/**/*",
            "resources/**/*",
        ],
    },
    zip_safe=False,
    project_urls={
        "Bug Reports": "https://t.me/QP4RM",
        "Source": "https://github.com/MERO/SnapQRpy",
        "Telegram": "https://t.me/QP4RM",
    },
)
