# icotest-voice
IcoTest Voice API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.28
- Package version: 1.0.28
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```bash
pip install icotest-voice
```

Then import the package:
```python
import icotest_voice
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import icotest_voice
from icotest_voice.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://localhost/icotest_voice
# See configuration.py for a list of all supported configuration parameters.
configuration = icotest_voice.Configuration(
    host = "https://localhost/icotest_voice"
)

# Enter a context with an instance of the API client
with icotest_voice.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = icotest_voice.ControllersApi(api_client)
    controller_id = 'ac331ccb-5841-44ec-9d32-4f4fe0c3c16c' # str: the unique id of the controller

    try:
        # DELETE Controller
        api_instance.delete_controller(controller_id)
    except ApiException as e:
        print("Exception when calling ControllersApi.delete_controller: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/icotest_voice*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ControllersApi* | [**delete_controller**](docs/ControllersApi.md#delete_controller) | **DELETE** /controllers | DELETE Controller
*ControllersApi* | [**get_controllers**](docs/ControllersApi.md#get_controllers) | **GET** /controllers | GET controllers
*ControllersApi* | [**post_controller_heartbeat**](docs/ControllersApi.md#post_controller_heartbeat) | **POST** /controllers/{controller_id}/heartbeat | POST Controller heartbeat
*ControllersApi* | [**put_controller**](docs/ControllersApi.md#put_controller) | **PUT** /controllers | PUT controller
*DevicesApi* | [**delete_device**](docs/DevicesApi.md#delete_device) | **DELETE** /devices | DELETE Device
*DevicesApi* | [**get_devices**](docs/DevicesApi.md#get_devices) | **GET** /devices | GET devices
*DevicesApi* | [**get_devices_status**](docs/DevicesApi.md#get_devices_status) | **GET** /devices/{device_id}/status | GET device status
*DevicesApi* | [**get_host_config**](docs/DevicesApi.md#get_host_config) | **GET** /host/config | Your GET endpoint
*DevicesApi* | [**post_device_deregister**](docs/DevicesApi.md#post_device_deregister) | **POST** /devices/{device_id}/deregister | POST deregister device
*DevicesApi* | [**post_device_make_call**](docs/DevicesApi.md#post_device_make_call) | **POST** /devices/{device_id}/make_call | POST make call
*DevicesApi* | [**post_device_pair**](docs/DevicesApi.md#post_device_pair) | **POST** /devices/{device_id}/pair | POST device pair
*DevicesApi* | [**post_device_register**](docs/DevicesApi.md#post_device_register) | **POST** /devices/{device_id}/register | POST register device
*DevicesApi* | [**post_devices_end_call**](docs/DevicesApi.md#post_devices_end_call) | **POST** /devices/{device_id}/end_call | POST end call
*DevicesApi* | [**post_devices_heartbeat**](docs/DevicesApi.md#post_devices_heartbeat) | **POST** /devices/{device_id}/heartbeat | POST Device heartbeat
*DevicesApi* | [**post_devices_receive_call**](docs/DevicesApi.md#post_devices_receive_call) | **POST** /devices/{device_id}/receive_call | POST receive call
*DevicesApi* | [**post_devices_scan**](docs/DevicesApi.md#post_devices_scan) | **POST** /devices/{controller_id}/scan | POST device scan
*DevicesApi* | [**post_devices_send_command**](docs/DevicesApi.md#post_devices_send_command) | **POST** /devices/{device_id}/send_command | POST send command
*DevicesApi* | [**put_device**](docs/DevicesApi.md#put_device) | **PUT** /devices | PUT device
*DevicesApi* | [**put_devices_status**](docs/DevicesApi.md#put_devices_status) | **PUT** /devices/{device_id}/status | PUT device status
*DevicesApi* | [**put_host_config**](docs/DevicesApi.md#put_host_config) | **PUT** /host/config | 
*RequestsApi* | [**delete_audio_playback_file**](docs/RequestsApi.md#delete_audio_playback_file) | **DELETE** /requests/{controller_id}/delete_audio_playback_file | DELETE audio playback file
*RequestsApi* | [**delete_request**](docs/RequestsApi.md#delete_request) | **DELETE** /requests | DELETE request
*RequestsApi* | [**delete_result_file**](docs/RequestsApi.md#delete_result_file) | **DELETE** /requests/{request_id}/delete_result_file | DELETE result file
*RequestsApi* | [**delete_result_files_in_range**](docs/RequestsApi.md#delete_result_files_in_range) | **DELETE** /requests/{controller_id}/delete_result_files_in_range | DELETE result files in date-time range
*RequestsApi* | [**get_audio_playback_file_list**](docs/RequestsApi.md#get_audio_playback_file_list) | **GET** /requests/{controller_id}/get_audio_playback_file_list | GET audio playback file list
*RequestsApi* | [**get_requests**](docs/RequestsApi.md#get_requests) | **GET** /requests | GET requests
*RequestsApi* | [**get_retrieve_test_result_file**](docs/RequestsApi.md#get_retrieve_test_result_file) | **GET** /requests/{request_id}/retrieve_result_file | GET test result file
*RequestsApi* | [**get_test_result_file_list**](docs/RequestsApi.md#get_test_result_file_list) | **GET** /requests/{controller_id}/get_result_file_list | GET test result file list
*RequestsApi* | [**post_requests_heartbeat**](docs/RequestsApi.md#post_requests_heartbeat) | **POST** /requests/{request_id}/heartbeat | POST request heartbeat
*RequestsApi* | [**put_request**](docs/RequestsApi.md#put_request) | **PUT** /requests | PUT request
*RequestsApi* | [**put_request_status**](docs/RequestsApi.md#put_request_status) | **PUT** /requests/{request_id}/status | PUT request status
*RequestsApi* | [**put_upload_audio_playback_file**](docs/RequestsApi.md#put_upload_audio_playback_file) | **PUT** /requests/{controller_id}/upload_audio_playback_file | PUT upload audio playback file


## Documentation For Models

 - [Controller](docs/Controller.md)
 - [Device](docs/Device.md)
 - [HostConfig](docs/HostConfig.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse200Files](docs/InlineResponse200Files.md)
 - [Message](docs/Message.md)
 - [Request](docs/Request.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

shaun.hirst@3adesign.co.uk


