# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDatacentersResult',
    'AwaitableGetDatacentersResult',
    'get_datacenters',
]

@pulumi.output_type
class GetDatacentersResult:
    """
    A collection of values returned by getDatacenters.
    """
    def __init__(__self__, datacenter_ids=None, descriptions=None, id=None, names=None):
        if datacenter_ids and not isinstance(datacenter_ids, list):
            raise TypeError("Expected argument 'datacenter_ids' to be a list")
        pulumi.set(__self__, "datacenter_ids", datacenter_ids)
        if descriptions and not isinstance(descriptions, list):
            raise TypeError("Expected argument 'descriptions' to be a list")
        pulumi.set(__self__, "descriptions", descriptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter(name="datacenterIds")
    def datacenter_ids(self) -> Optional[Sequence[str]]:
        """
        (list) List of unique datacenter identifiers.
        """
        return pulumi.get(self, "datacenter_ids")

    @property
    @pulumi.getter
    def descriptions(self) -> Sequence[str]:
        """
        (list) List of all datacenter descriptions.
        """
        return pulumi.get(self, "descriptions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        (list) List of datacenter names.
        """
        return pulumi.get(self, "names")


class AwaitableGetDatacentersResult(GetDatacentersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatacentersResult(
            datacenter_ids=self.datacenter_ids,
            descriptions=self.descriptions,
            id=self.id,
            names=self.names)


def get_datacenters(datacenter_ids: Optional[Sequence[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatacentersResult:
    """
    Provides a list of available Hetzner Cloud Datacenters.
    This resource may be useful to create highly available infrastructure, distributed across several datacenters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    ds = hcloud.get_datacenters()
    workers = []
    for range in [{"value": i} for i in range(0, 3)]:
        workers.append(hcloud.Server(f"workers-{range['value']}",
            image="debian-9",
            server_type="cx31",
            datacenter=ds.names[range["value"]]))
    ```


    :param Sequence[str] datacenter_ids: (list) List of unique datacenter identifiers.
    """
    __args__ = dict()
    __args__['datacenterIds'] = datacenter_ids
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('hcloud:index/getDatacenters:getDatacenters', __args__, opts=opts, typ=GetDatacentersResult).value

    return AwaitableGetDatacentersResult(
        datacenter_ids=__ret__.datacenter_ids,
        descriptions=__ret__.descriptions,
        id=__ret__.id,
        names=__ret__.names)
