# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetLocationsResult',
    'AwaitableGetLocationsResult',
    'get_locations',
]

@pulumi.output_type
class GetLocationsResult:
    """
    A collection of values returned by getLocations.
    """
    def __init__(__self__, descriptions=None, id=None, location_ids=None, names=None):
        if descriptions and not isinstance(descriptions, list):
            raise TypeError("Expected argument 'descriptions' to be a list")
        pulumi.set(__self__, "descriptions", descriptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location_ids and not isinstance(location_ids, list):
            raise TypeError("Expected argument 'location_ids' to be a list")
        pulumi.set(__self__, "location_ids", location_ids)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def descriptions(self) -> Sequence[str]:
        """
        (list) List of all location descriptions.
        """
        return pulumi.get(self, "descriptions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="locationIds")
    def location_ids(self) -> Optional[Sequence[str]]:
        """
        (list) List of unique location identifiers.
        """
        return pulumi.get(self, "location_ids")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        (list) List of location names.
        """
        return pulumi.get(self, "names")


class AwaitableGetLocationsResult(GetLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationsResult(
            descriptions=self.descriptions,
            id=self.id,
            location_ids=self.location_ids,
            names=self.names)


def get_locations(location_ids: Optional[Sequence[str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationsResult:
    """
    Provides a list of available Hetzner Cloud Locations.
    This resource may be useful to create highly available infrastructure, distributed across several locations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    ds = hcloud.get_locations()
    workers = []
    for range in [{"value": i} for i in range(0, 3)]:
        workers.append(hcloud.Server(f"workers-{range['value']}",
            image="debian-9",
            server_type="cx31",
            location=ds.names[range["value"]]))
    ```


    :param Sequence[str] location_ids: (list) List of unique location identifiers.
    """
    __args__ = dict()
    __args__['locationIds'] = location_ids
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('hcloud:index/getLocations:getLocations', __args__, opts=opts, typ=GetLocationsResult).value

    return AwaitableGetLocationsResult(
        descriptions=__ret__.descriptions,
        id=__ret__.id,
        location_ids=__ret__.location_ids,
        names=__ret__.names)
