# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, backup_window=None, backups=None, datacenter=None, firewall_ids=None, id=None, image=None, ipv4_address=None, ipv6_address=None, ipv6_network=None, iso=None, labels=None, location=None, name=None, rescue=None, selector=None, server_type=None, status=None, with_selector=None, with_statuses=None):
        if backup_window and not isinstance(backup_window, str):
            raise TypeError("Expected argument 'backup_window' to be a str")
        pulumi.set(__self__, "backup_window", backup_window)
        if backups and not isinstance(backups, bool):
            raise TypeError("Expected argument 'backups' to be a bool")
        pulumi.set(__self__, "backups", backups)
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if firewall_ids and not isinstance(firewall_ids, list):
            raise TypeError("Expected argument 'firewall_ids' to be a list")
        pulumi.set(__self__, "firewall_ids", firewall_ids)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        pulumi.set(__self__, "image", image)
        if ipv4_address and not isinstance(ipv4_address, str):
            raise TypeError("Expected argument 'ipv4_address' to be a str")
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address and not isinstance(ipv6_address, str):
            raise TypeError("Expected argument 'ipv6_address' to be a str")
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_network and not isinstance(ipv6_network, str):
            raise TypeError("Expected argument 'ipv6_network' to be a str")
        pulumi.set(__self__, "ipv6_network", ipv6_network)
        if iso and not isinstance(iso, str):
            raise TypeError("Expected argument 'iso' to be a str")
        pulumi.set(__self__, "iso", iso)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rescue and not isinstance(rescue, str):
            raise TypeError("Expected argument 'rescue' to be a str")
        pulumi.set(__self__, "rescue", rescue)
        if selector and not isinstance(selector, str):
            raise TypeError("Expected argument 'selector' to be a str")
        if selector is not None:
            warnings.warn("""Please use the with_selector property instead.""", DeprecationWarning)
            pulumi.log.warn("""selector is deprecated: Please use the with_selector property instead.""")

        pulumi.set(__self__, "selector", selector)
        if server_type and not isinstance(server_type, str):
            raise TypeError("Expected argument 'server_type' to be a str")
        pulumi.set(__self__, "server_type", server_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)
        if with_statuses and not isinstance(with_statuses, list):
            raise TypeError("Expected argument 'with_statuses' to be a list")
        pulumi.set(__self__, "with_statuses", with_statuses)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> str:
        """
        (string) The backup window of the server, if enabled.
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def backups(self) -> bool:
        """
        (boolean) Whether backups are enabled.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        """
        (string) The datacenter name.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> Sequence[int]:
        """
        (Optional, list) Firewall IDs the server is attached to.
        """
        return pulumi.get(self, "firewall_ids")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        (int) Unique ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        (string) Name or ID of the image the server was created from.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        (string) The IPv4 address.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        (string) The first IPv6 address of the assigned network.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Network")
    def ipv6_network(self) -> str:
        """
        (string) The IPv6 network.
        """
        return pulumi.get(self, "ipv6_network")

    @property
    @pulumi.getter
    def iso(self) -> str:
        """
        (string) ID or Name of the mounted ISO image.
        """
        return pulumi.get(self, "iso")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        """
        (map) User-defined labels (key-value pairs)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        (string) The location name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (string) Name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rescue(self) -> str:
        return pulumi.get(self, "rescue")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> str:
        """
        (string) Name of the server type.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        (string) The status of the server.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[str]:
        return pulumi.get(self, "with_selector")

    @property
    @pulumi.getter(name="withStatuses")
    def with_statuses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "with_statuses")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            backup_window=self.backup_window,
            backups=self.backups,
            datacenter=self.datacenter,
            firewall_ids=self.firewall_ids,
            id=self.id,
            image=self.image,
            ipv4_address=self.ipv4_address,
            ipv6_address=self.ipv6_address,
            ipv6_network=self.ipv6_network,
            iso=self.iso,
            labels=self.labels,
            location=self.location,
            name=self.name,
            rescue=self.rescue,
            selector=self.selector,
            server_type=self.server_type,
            status=self.status,
            with_selector=self.with_selector,
            with_statuses=self.with_statuses)


def get_server(id: Optional[int] = None,
               name: Optional[str] = None,
               selector: Optional[str] = None,
               with_selector: Optional[str] = None,
               with_statuses: Optional[Sequence[str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Use this data source to access information about an existing resource.

    :param int id: ID of the server.
    :param str name: Name of the server.
    :param str with_selector: Label Selector. For more information about possible values, visit the [Hetzner Cloud Documentation](https://docs.hetzner.cloud/#overview-label-selector).
    :param Sequence[str] with_statuses: List only servers with the specified status, could contain `initializing`, `starting`, `running`, `stopping`, `off`, `deleting`, `rebuilding`, `migrating`, `unknown`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['selector'] = selector
    __args__['withSelector'] = with_selector
    __args__['withStatuses'] = with_statuses
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('hcloud:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        backup_window=__ret__.backup_window,
        backups=__ret__.backups,
        datacenter=__ret__.datacenter,
        firewall_ids=__ret__.firewall_ids,
        id=__ret__.id,
        image=__ret__.image,
        ipv4_address=__ret__.ipv4_address,
        ipv6_address=__ret__.ipv6_address,
        ipv6_network=__ret__.ipv6_network,
        iso=__ret__.iso,
        labels=__ret__.labels,
        location=__ret__.location,
        name=__ret__.name,
        rescue=__ret__.rescue,
        selector=__ret__.selector,
        server_type=__ret__.server_type,
        status=__ret__.status,
        with_selector=__ret__.with_selector,
        with_statuses=__ret__.with_statuses)
