# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetServerTypesResult',
    'AwaitableGetServerTypesResult',
    'get_server_types',
]

@pulumi.output_type
class GetServerTypesResult:
    """
    A collection of values returned by getServerTypes.
    """
    def __init__(__self__, descriptions=None, id=None, names=None, server_type_ids=None):
        if descriptions and not isinstance(descriptions, list):
            raise TypeError("Expected argument 'descriptions' to be a list")
        pulumi.set(__self__, "descriptions", descriptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if server_type_ids and not isinstance(server_type_ids, list):
            raise TypeError("Expected argument 'server_type_ids' to be a list")
        pulumi.set(__self__, "server_type_ids", server_type_ids)

    @property
    @pulumi.getter
    def descriptions(self) -> Sequence[str]:
        """
        (list) List of all Server Types descriptions.
        """
        return pulumi.get(self, "descriptions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        (list) List of Server Types names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="serverTypeIds")
    def server_type_ids(self) -> Optional[Sequence[str]]:
        """
        (list) List of unique Server Types identifiers.
        """
        return pulumi.get(self, "server_type_ids")


class AwaitableGetServerTypesResult(GetServerTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerTypesResult(
            descriptions=self.descriptions,
            id=self.id,
            names=self.names,
            server_type_ids=self.server_type_ids)


def get_server_types(server_type_ids: Optional[Sequence[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerTypesResult:
    """
    Provides a list of available Hetzner Cloud Server Types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    ds = hcloud.get_server_types()
    workers = []
    for range in [{"value": i} for i in range(0, 3)]:
        workers.append(hcloud.Server(f"workers-{range['value']}",
            image="debian-9",
            server_type=ds.names[range["value"]]))
    ```


    :param Sequence[str] server_type_ids: (list) List of unique Server Types identifiers.
    """
    __args__ = dict()
    __args__['serverTypeIds'] = server_type_ids
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('hcloud:index/getServerTypes:getServerTypes', __args__, opts=opts, typ=GetServerTypesResult).value

    return AwaitableGetServerTypesResult(
        descriptions=__ret__.descriptions,
        id=__ret__.id,
        names=__ret__.names,
        server_type_ids=__ret__.server_type_ids)
