# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OceanNpAutoscaler',
    'OceanNpAutoscalerAutoscaleDown',
    'OceanNpAutoscalerAutoscaleHeadroom',
    'OceanNpAutoscalerAutoscaleHeadroomAutomatic',
    'OceanNpAutoscalerResourceLimits',
    'OceanNpFilters',
    'OceanNpHeadroom',
    'OceanNpHealth',
    'OceanNpLinuxOsConfig',
    'OceanNpLinuxOsConfigSysctl',
    'OceanNpLogging',
    'OceanNpLoggingExport',
    'OceanNpLoggingExportAzureBlob',
    'OceanNpScheduling',
    'OceanNpSchedulingShutdownHours',
    'OceanNpSchedulingSuspensionHours',
    'OceanNpSchedulingTask',
    'OceanNpSchedulingTaskParameters',
    'OceanNpSchedulingTaskParametersParametersClusterRoll',
    'OceanNpSchedulingTaskParametersParametersUpgradeConfig',
    'OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters',
    'OceanNpTaint',
    'OceanNpUpdatePolicy',
    'OceanNpUpdatePolicyRollConfig',
    'OceanNpVirtualNodeGroupFilters',
    'OceanNpVirtualNodeGroupHeadroom',
    'OceanNpVirtualNodeGroupLinuxOsConfig',
    'OceanNpVirtualNodeGroupLinuxOsConfigSysctl',
    'OceanNpVirtualNodeGroupScheduling',
    'OceanNpVirtualNodeGroupSchedulingShutdownHours',
    'OceanNpVirtualNodeGroupTaint',
    'OceanNpVirtualNodeGroupUpdatePolicy',
    'OceanNpVirtualNodeGroupUpdatePolicyRollConfig',
    'OceanNpVngTemplateScheduling',
    'OceanNpVngTemplateSchedulingVngTemplateShutdownHours',
]

@pulumi.output_type
class OceanNpAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"
        elif key == "resourceLimits":
            suggest = "resource_limits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_down: Optional['outputs.OceanNpAutoscalerAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.OceanNpAutoscalerAutoscaleHeadroom'] = None,
                 autoscale_is_enabled: Optional[builtins.bool] = None,
                 resource_limits: Optional['outputs.OceanNpAutoscalerResourceLimits'] = None):
        """
        :param 'OceanNpAutoscalerAutoscaleDownArgs' autoscale_down: Auto Scaling scale down operations.
        :param 'OceanNpAutoscalerAutoscaleHeadroomArgs' autoscale_headroom: Spare resource capacity management enabling fast assignment of pods without waiting for new resources to launch.
        :param builtins.bool autoscale_is_enabled: Enable the Ocean Kubernetes Autoscaler.
        :param 'OceanNpAutoscalerResourceLimitsArgs' resource_limits: Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.OceanNpAutoscalerAutoscaleDown']:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.OceanNpAutoscalerAutoscaleHeadroom']:
        """
        Spare resource capacity management enabling fast assignment of pods without waiting for new resources to launch.
        """
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[builtins.bool]:
        """
        Enable the Ocean Kubernetes Autoscaler.
        """
        return pulumi.get(self, "autoscale_is_enabled")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional['outputs.OceanNpAutoscalerResourceLimits']:
        """
        Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        return pulumi.get(self, "resource_limits")


@pulumi.output_type
class OceanNpAutoscalerAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpAutoscalerAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpAutoscalerAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpAutoscalerAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_scale_down_percentage: Optional[builtins.int] = None):
        """
        :param builtins.int max_scale_down_percentage: The maximum percentage allowed to scale down in a single scaling action.
        """
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[builtins.int]:
        """
        The maximum percentage allowed to scale down in a single scaling action.
        """
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class OceanNpAutoscalerAutoscaleHeadroom(dict):
    def __init__(__self__, *,
                 automatic: Optional['outputs.OceanNpAutoscalerAutoscaleHeadroomAutomatic'] = None):
        """
        :param 'OceanNpAutoscalerAutoscaleHeadroomAutomaticArgs' automatic: [Automatic headroom](https://docs.spot.io/ocean/features/headroom?id=automatic-headroom) configuration.
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)

    @property
    @pulumi.getter
    def automatic(self) -> Optional['outputs.OceanNpAutoscalerAutoscaleHeadroomAutomatic']:
        """
        [Automatic headroom](https://docs.spot.io/ocean/features/headroom?id=automatic-headroom) configuration.
        """
        return pulumi.get(self, "automatic")


@pulumi.output_type
class OceanNpAutoscalerAutoscaleHeadroomAutomatic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpAutoscalerAutoscaleHeadroomAutomatic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpAutoscalerAutoscaleHeadroomAutomatic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpAutoscalerAutoscaleHeadroomAutomatic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[builtins.bool] = None,
                 percentage: Optional[builtins.int] = None):
        """
        :param builtins.bool is_enabled: Enable automatic headroom. When set to `true`, Ocean configures and optimizes headroom automatically.
        :param builtins.int percentage: Optionally set a number between 0-100 to control the percentage of total cluster resources dedicated to headroom.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        Enable automatic headroom. When set to `true`, Ocean configures and optimizes headroom automatically.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[builtins.int]:
        """
        Optionally set a number between 0-100 to control the percentage of total cluster resources dedicated to headroom.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class OceanNpAutoscalerResourceLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxVcpu":
            suggest = "max_vcpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpAutoscalerResourceLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpAutoscalerResourceLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpAutoscalerResourceLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_memory_gib: Optional[builtins.int] = None,
                 max_vcpu: Optional[builtins.int] = None):
        """
        :param builtins.int max_memory_gib: The maximum memory in GiB units that can be allocated to the cluster.
        :param builtins.int max_vcpu: The maximum cpu in vCpu units that can be allocated to the cluster.
        """
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[builtins.int]:
        """
        The maximum memory in GiB units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[builtins.int]:
        """
        The maximum cpu in vCpu units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_vcpu")


@pulumi.output_type
class OceanNpFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratedNetworking":
            suggest = "accelerated_networking"
        elif key == "diskPerformance":
            suggest = "disk_performance"
        elif key == "excludeSeries":
            suggest = "exclude_series"
        elif key == "gpuTypes":
            suggest = "gpu_types"
        elif key == "maxGpu":
            suggest = "max_gpu"
        elif key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxVcpu":
            suggest = "max_vcpu"
        elif key == "minDisk":
            suggest = "min_disk"
        elif key == "minGpu":
            suggest = "min_gpu"
        elif key == "minMemoryGib":
            suggest = "min_memory_gib"
        elif key == "minNics":
            suggest = "min_nics"
        elif key == "minVcpu":
            suggest = "min_vcpu"
        elif key == "vmTypes":
            suggest = "vm_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerated_networking: Optional[builtins.str] = None,
                 architectures: Optional[Sequence[builtins.str]] = None,
                 disk_performance: Optional[builtins.str] = None,
                 exclude_series: Optional[Sequence[builtins.str]] = None,
                 gpu_types: Optional[Sequence[builtins.str]] = None,
                 max_gpu: Optional[builtins.float] = None,
                 max_memory_gib: Optional[builtins.float] = None,
                 max_vcpu: Optional[builtins.int] = None,
                 min_disk: Optional[builtins.int] = None,
                 min_gpu: Optional[builtins.float] = None,
                 min_memory_gib: Optional[builtins.float] = None,
                 min_nics: Optional[builtins.int] = None,
                 min_vcpu: Optional[builtins.int] = None,
                 series: Optional[Sequence[builtins.str]] = None,
                 vm_types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str accelerated_networking: In case acceleratedNetworking is set to Enabled, accelerated networking applies only to the VM that enables it.
        :param Sequence[builtins.str] architectures: The filtered vm sizes will support at least one of the architectures from this list. x86_64 includes both intel64 and amd64.
        :param builtins.str disk_performance: The filtered vm sizes will support at least one of the classes from this list.
        :param Sequence[builtins.str] exclude_series: Vm sizes belonging to a series from the list will not be available for scaling
        :param Sequence[builtins.str] gpu_types: The filtered gpu types will belong to one of the gpu types from this list.
        :param builtins.float max_gpu: Maximum number of GPUs available.
        :param builtins.float max_memory_gib: Maximum amount of Memory (GiB).
        :param builtins.int max_vcpu: Maximum number of vcpus available.
        :param builtins.int min_disk: Minimum number of data disks available.
        :param builtins.float min_gpu: Minimum number of GPUs available.
        :param builtins.float min_memory_gib: Minimum amount of Memory (GiB).
        :param builtins.int min_nics: Minimum number of network interfaces.
        :param builtins.int min_vcpu: Minimum number of vcpus available.
        :param Sequence[builtins.str] series: Vm sizes belonging to a series from the list will be available for scaling. We can specify include list and series can be specified with capital or small letters, with space, without space or with underscore '_' .  For example all of these "DSv2", "Ds v2", "ds_v2" refer to same DS_v2 series.
        :param Sequence[builtins.str] vm_types: The filtered vm types will belong to one of the vm types from this list.
        """
        if accelerated_networking is not None:
            pulumi.set(__self__, "accelerated_networking", accelerated_networking)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if disk_performance is not None:
            pulumi.set(__self__, "disk_performance", disk_performance)
        if exclude_series is not None:
            pulumi.set(__self__, "exclude_series", exclude_series)
        if gpu_types is not None:
            pulumi.set(__self__, "gpu_types", gpu_types)
        if max_gpu is not None:
            pulumi.set(__self__, "max_gpu", max_gpu)
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)
        if min_disk is not None:
            pulumi.set(__self__, "min_disk", min_disk)
        if min_gpu is not None:
            pulumi.set(__self__, "min_gpu", min_gpu)
        if min_memory_gib is not None:
            pulumi.set(__self__, "min_memory_gib", min_memory_gib)
        if min_nics is not None:
            pulumi.set(__self__, "min_nics", min_nics)
        if min_vcpu is not None:
            pulumi.set(__self__, "min_vcpu", min_vcpu)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if vm_types is not None:
            pulumi.set(__self__, "vm_types", vm_types)

    @property
    @pulumi.getter(name="acceleratedNetworking")
    def accelerated_networking(self) -> Optional[builtins.str]:
        """
        In case acceleratedNetworking is set to Enabled, accelerated networking applies only to the VM that enables it.
        """
        return pulumi.get(self, "accelerated_networking")

    @property
    @pulumi.getter
    def architectures(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered vm sizes will support at least one of the architectures from this list. x86_64 includes both intel64 and amd64.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter(name="diskPerformance")
    def disk_performance(self) -> Optional[builtins.str]:
        """
        The filtered vm sizes will support at least one of the classes from this list.
        """
        return pulumi.get(self, "disk_performance")

    @property
    @pulumi.getter(name="excludeSeries")
    def exclude_series(self) -> Optional[Sequence[builtins.str]]:
        """
        Vm sizes belonging to a series from the list will not be available for scaling
        """
        return pulumi.get(self, "exclude_series")

    @property
    @pulumi.getter(name="gpuTypes")
    def gpu_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered gpu types will belong to one of the gpu types from this list.
        """
        return pulumi.get(self, "gpu_types")

    @property
    @pulumi.getter(name="maxGpu")
    def max_gpu(self) -> Optional[builtins.float]:
        """
        Maximum number of GPUs available.
        """
        return pulumi.get(self, "max_gpu")

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[builtins.float]:
        """
        Maximum amount of Memory (GiB).
        """
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[builtins.int]:
        """
        Maximum number of vcpus available.
        """
        return pulumi.get(self, "max_vcpu")

    @property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> Optional[builtins.int]:
        """
        Minimum number of data disks available.
        """
        return pulumi.get(self, "min_disk")

    @property
    @pulumi.getter(name="minGpu")
    def min_gpu(self) -> Optional[builtins.float]:
        """
        Minimum number of GPUs available.
        """
        return pulumi.get(self, "min_gpu")

    @property
    @pulumi.getter(name="minMemoryGib")
    def min_memory_gib(self) -> Optional[builtins.float]:
        """
        Minimum amount of Memory (GiB).
        """
        return pulumi.get(self, "min_memory_gib")

    @property
    @pulumi.getter(name="minNics")
    def min_nics(self) -> Optional[builtins.int]:
        """
        Minimum number of network interfaces.
        """
        return pulumi.get(self, "min_nics")

    @property
    @pulumi.getter(name="minVcpu")
    def min_vcpu(self) -> Optional[builtins.int]:
        """
        Minimum number of vcpus available.
        """
        return pulumi.get(self, "min_vcpu")

    @property
    @pulumi.getter
    def series(self) -> Optional[Sequence[builtins.str]]:
        """
        Vm sizes belonging to a series from the list will be available for scaling. We can specify include list and series can be specified with capital or small letters, with space, without space or with underscore '_' .  For example all of these "DSv2", "Ds v2", "ds_v2" refer to same DS_v2 series.
        """
        return pulumi.get(self, "series")

    @property
    @pulumi.getter(name="vmTypes")
    def vm_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered vm types will belong to one of the vm types from this list.
        """
        return pulumi.get(self, "vm_types")


@pulumi.output_type
class OceanNpHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "gpuPerUnit":
            suggest = "gpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[builtins.int] = None,
                 gpu_per_unit: Optional[builtins.int] = None,
                 memory_per_unit: Optional[builtins.int] = None,
                 num_of_units: Optional[builtins.int] = None):
        """
        :param builtins.int cpu_per_unit: Configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param builtins.int gpu_per_unit: Amount of GPU to allocate for headroom unit.
        :param builtins.int memory_per_unit: Configure the amount of memory (MiB) to allocate the headroom.
        :param builtins.int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if gpu_per_unit is not None:
            pulumi.set(__self__, "gpu_per_unit", gpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[builtins.int]:
        """
        Configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="gpuPerUnit")
    def gpu_per_unit(self) -> Optional[builtins.int]:
        """
        Amount of GPU to allocate for headroom unit.
        """
        return pulumi.get(self, "gpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[builtins.int]:
        """
        Configure the amount of memory (MiB) to allocate the headroom.
        """
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[builtins.int]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class OceanNpHealth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpHealth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpHealth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpHealth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grace_period: Optional[builtins.int] = None):
        """
        :param builtins.int grace_period: The amount of time to wait, in seconds, from the moment the instance has launched until monitoring of its health checks begins.
        """
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[builtins.int]:
        """
        The amount of time to wait, in seconds, from the moment the instance has launched until monitoring of its health checks begins.
        """
        return pulumi.get(self, "grace_period")


@pulumi.output_type
class OceanNpLinuxOsConfig(dict):
    def __init__(__self__, *,
                 sysctls: Optional[Sequence['outputs.OceanNpLinuxOsConfigSysctl']] = None):
        """
        :param Sequence['OceanNpLinuxOsConfigSysctlArgs'] sysctls: System Controls
        """
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[Sequence['outputs.OceanNpLinuxOsConfigSysctl']]:
        """
        System Controls
        """
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class OceanNpLinuxOsConfigSysctl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmMaxMapCount":
            suggest = "vm_max_map_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpLinuxOsConfigSysctl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpLinuxOsConfigSysctl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpLinuxOsConfigSysctl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_max_map_count: Optional[builtins.int] = None):
        """
        :param builtins.int vm_max_map_count: Maximum number of memory map areas a process may have. Can be configured only if OS type is Linux.
        """
        if vm_max_map_count is not None:
            pulumi.set(__self__, "vm_max_map_count", vm_max_map_count)

    @property
    @pulumi.getter(name="vmMaxMapCount")
    def vm_max_map_count(self) -> Optional[builtins.int]:
        """
        Maximum number of memory map areas a process may have. Can be configured only if OS type is Linux.
        """
        return pulumi.get(self, "vm_max_map_count")


@pulumi.output_type
class OceanNpLogging(dict):
    def __init__(__self__, *,
                 export: Optional['outputs.OceanNpLoggingExport'] = None):
        """
        :param 'OceanNpLoggingExportArgs' export: The Ocean AKS Logging Export object.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)

    @property
    @pulumi.getter
    def export(self) -> Optional['outputs.OceanNpLoggingExport']:
        """
        The Ocean AKS Logging Export object.
        """
        return pulumi.get(self, "export")


@pulumi.output_type
class OceanNpLoggingExport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlobs":
            suggest = "azure_blobs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpLoggingExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpLoggingExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpLoggingExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_blobs: Optional[Sequence['outputs.OceanNpLoggingExportAzureBlob']] = None):
        """
        :param Sequence['OceanNpLoggingExportAzureBlobArgs'] azure_blobs: Exports your cluster's logs to the storage account and container configured on the storage account [data integration](https://docs.spot.io/ocean/features/log-integration-with-azure-blob?id=log-integration-with-azure-blob) given. Each file contains logs of 3 minutes where each log is separated by a new line and saved as a JSON. The file formats are `container`/`accountId``oceanId``oceanName`_`startTime`.log
        """
        if azure_blobs is not None:
            pulumi.set(__self__, "azure_blobs", azure_blobs)

    @property
    @pulumi.getter(name="azureBlobs")
    def azure_blobs(self) -> Optional[Sequence['outputs.OceanNpLoggingExportAzureBlob']]:
        """
        Exports your cluster's logs to the storage account and container configured on the storage account [data integration](https://docs.spot.io/ocean/features/log-integration-with-azure-blob?id=log-integration-with-azure-blob) given. Each file contains logs of 3 minutes where each log is separated by a new line and saved as a JSON. The file formats are `container`/`accountId``oceanId``oceanName`_`startTime`.log
        """
        return pulumi.get(self, "azure_blobs")


@pulumi.output_type
class OceanNpLoggingExportAzureBlob(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str id: The identifier of The Azure Blob data integration to export the logs to.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The identifier of The Azure Blob data integration to export the logs to.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class OceanNpScheduling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shutdownHours":
            suggest = "shutdown_hours"
        elif key == "suspensionHours":
            suggest = "suspension_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpScheduling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpScheduling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpScheduling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shutdown_hours: Optional['outputs.OceanNpSchedulingShutdownHours'] = None,
                 suspension_hours: Optional['outputs.OceanNpSchedulingSuspensionHours'] = None,
                 tasks: Optional[Sequence['outputs.OceanNpSchedulingTask']] = None):
        """
        :param 'OceanNpSchedulingShutdownHoursArgs' shutdown_hours: An object used to specify times that the nodes in the virtual node group will be stopped.
        """
        if shutdown_hours is not None:
            pulumi.set(__self__, "shutdown_hours", shutdown_hours)
        if suspension_hours is not None:
            pulumi.set(__self__, "suspension_hours", suspension_hours)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)

    @property
    @pulumi.getter(name="shutdownHours")
    def shutdown_hours(self) -> Optional['outputs.OceanNpSchedulingShutdownHours']:
        """
        An object used to specify times that the nodes in the virtual node group will be stopped.
        """
        return pulumi.get(self, "shutdown_hours")

    @property
    @pulumi.getter(name="suspensionHours")
    def suspension_hours(self) -> Optional['outputs.OceanNpSchedulingSuspensionHours']:
        return pulumi.get(self, "suspension_hours")

    @property
    @pulumi.getter
    def tasks(self) -> Optional[Sequence['outputs.OceanNpSchedulingTask']]:
        return pulumi.get(self, "tasks")


@pulumi.output_type
class OceanNpSchedulingShutdownHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "timeWindows":
            suggest = "time_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingShutdownHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingShutdownHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingShutdownHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[builtins.bool] = None,
                 time_windows: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] time_windows: The times that the shutdown hours will apply. Required if `is_enabled` is true.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[Sequence[builtins.str]]:
        """
        The times that the shutdown hours will apply. Required if `is_enabled` is true.
        """
        return pulumi.get(self, "time_windows")


@pulumi.output_type
class OceanNpSchedulingSuspensionHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "timeWindows":
            suggest = "time_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingSuspensionHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingSuspensionHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingSuspensionHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[builtins.bool] = None,
                 time_windows: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] time_windows: The times that the shutdown hours will apply. Required if `is_enabled` is true.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[Sequence[builtins.str]]:
        """
        The times that the shutdown hours will apply. Required if `is_enabled` is true.
        """
        return pulumi.get(self, "time_windows")


@pulumi.output_type
class OceanNpSchedulingTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: builtins.str,
                 is_enabled: builtins.bool,
                 task_type: builtins.str,
                 parameters: Optional['outputs.OceanNpSchedulingTaskParameters'] = None):
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> builtins.str:
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> builtins.str:
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.OceanNpSchedulingTaskParameters']:
        return pulumi.get(self, "parameters")


@pulumi.output_type
class OceanNpSchedulingTaskParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parametersClusterRoll":
            suggest = "parameters_cluster_roll"
        elif key == "parametersUpgradeConfig":
            suggest = "parameters_upgrade_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingTaskParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingTaskParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingTaskParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters_cluster_roll: Optional['outputs.OceanNpSchedulingTaskParametersParametersClusterRoll'] = None,
                 parameters_upgrade_config: Optional['outputs.OceanNpSchedulingTaskParametersParametersUpgradeConfig'] = None):
        if parameters_cluster_roll is not None:
            pulumi.set(__self__, "parameters_cluster_roll", parameters_cluster_roll)
        if parameters_upgrade_config is not None:
            pulumi.set(__self__, "parameters_upgrade_config", parameters_upgrade_config)

    @property
    @pulumi.getter(name="parametersClusterRoll")
    def parameters_cluster_roll(self) -> Optional['outputs.OceanNpSchedulingTaskParametersParametersClusterRoll']:
        return pulumi.get(self, "parameters_cluster_roll")

    @property
    @pulumi.getter(name="parametersUpgradeConfig")
    def parameters_upgrade_config(self) -> Optional['outputs.OceanNpSchedulingTaskParametersParametersUpgradeConfig']:
        return pulumi.get(self, "parameters_upgrade_config")


@pulumi.output_type
class OceanNpSchedulingTaskParametersParametersClusterRoll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "respectPdb":
            suggest = "respect_pdb"
        elif key == "respectRestrictScaleDown":
            suggest = "respect_restrict_scale_down"
        elif key == "vngIds":
            suggest = "vng_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingTaskParametersParametersClusterRoll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingTaskParametersParametersClusterRoll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingTaskParametersParametersClusterRoll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_min_healthy_percentage: Optional[builtins.int] = None,
                 batch_size_percentage: Optional[builtins.int] = None,
                 comment: Optional[builtins.str] = None,
                 respect_pdb: Optional[builtins.bool] = None,
                 respect_restrict_scale_down: Optional[builtins.bool] = None,
                 vng_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int batch_min_healthy_percentage: Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param builtins.int batch_size_percentage: Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        :param builtins.str comment: Add a comment description for the roll. The comment is limited to 256 chars and optional.
        :param builtins.bool respect_pdb: During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        :param builtins.bool respect_restrict_scale_down: During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        :param Sequence[builtins.str] vng_ids: List of virtual node group identifiers to be rolled. Each identifier is a string. vngIds can be null, and cannot be used together with nodeNames and nodePoolNames.
        """
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)
        if respect_restrict_scale_down is not None:
            pulumi.set(__self__, "respect_restrict_scale_down", respect_restrict_scale_down)
        if vng_ids is not None:
            pulumi.set(__self__, "vng_ids", vng_ids)

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[builtins.int]:
        """
        Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[builtins.int]:
        """
        Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Add a comment description for the roll. The comment is limited to 256 chars and optional.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        """
        return pulumi.get(self, "respect_pdb")

    @property
    @pulumi.getter(name="respectRestrictScaleDown")
    def respect_restrict_scale_down(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        """
        return pulumi.get(self, "respect_restrict_scale_down")

    @property
    @pulumi.getter(name="vngIds")
    def vng_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of virtual node group identifiers to be rolled. Each identifier is a string. vngIds can be null, and cannot be used together with nodeNames and nodePoolNames.
        """
        return pulumi.get(self, "vng_ids")


@pulumi.output_type
class OceanNpSchedulingTaskParametersParametersUpgradeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyRoll":
            suggest = "apply_roll"
        elif key == "rollParameters":
            suggest = "roll_parameters"
        elif key == "scopeVersion":
            suggest = "scope_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingTaskParametersParametersUpgradeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingTaskParametersParametersUpgradeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingTaskParametersParametersUpgradeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_roll: Optional[builtins.bool] = None,
                 roll_parameters: Optional['outputs.OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters'] = None,
                 scope_version: Optional[builtins.str] = None):
        if apply_roll is not None:
            pulumi.set(__self__, "apply_roll", apply_roll)
        if roll_parameters is not None:
            pulumi.set(__self__, "roll_parameters", roll_parameters)
        if scope_version is not None:
            pulumi.set(__self__, "scope_version", scope_version)

    @property
    @pulumi.getter(name="applyRoll")
    def apply_roll(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "apply_roll")

    @property
    @pulumi.getter(name="rollParameters")
    def roll_parameters(self) -> Optional['outputs.OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters']:
        return pulumi.get(self, "roll_parameters")

    @property
    @pulumi.getter(name="scopeVersion")
    def scope_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scope_version")


@pulumi.output_type
class OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "respectPdb":
            suggest = "respect_pdb"
        elif key == "respectRestrictScaleDown":
            suggest = "respect_restrict_scale_down"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpSchedulingTaskParametersParametersUpgradeConfigRollParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_min_healthy_percentage: Optional[builtins.int] = None,
                 batch_size_percentage: Optional[builtins.int] = None,
                 comment: Optional[builtins.str] = None,
                 respect_pdb: Optional[builtins.bool] = None,
                 respect_restrict_scale_down: Optional[builtins.bool] = None):
        """
        :param builtins.int batch_min_healthy_percentage: Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param builtins.int batch_size_percentage: Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        :param builtins.str comment: Add a comment description for the roll. The comment is limited to 256 chars and optional.
        :param builtins.bool respect_pdb: During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        :param builtins.bool respect_restrict_scale_down: During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        """
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)
        if respect_restrict_scale_down is not None:
            pulumi.set(__self__, "respect_restrict_scale_down", respect_restrict_scale_down)

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[builtins.int]:
        """
        Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[builtins.int]:
        """
        Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Add a comment description for the roll. The comment is limited to 256 chars and optional.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        """
        return pulumi.get(self, "respect_pdb")

    @property
    @pulumi.getter(name="respectRestrictScaleDown")
    def respect_restrict_scale_down(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        """
        return pulumi.get(self, "respect_restrict_scale_down")


@pulumi.output_type
class OceanNpTaint(dict):
    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str effect: Set taint effect.
        :param builtins.str key: Set taint key. The following taint keys are not allowed: ["node.kubernetes.io/not-ready",  "node.kubernetes.io/unreachable", "node.kubernetes.io/unschedulable",  "node.kubernetes.io/memory-pressure",  "node.kubernetes.io/disk-pressure",  "node.kubernetes.io/network-unavailable",  "node.kubernetes.io/pid-pressure",  "node.kubernetes.io/out-of-service",  "node.cloudprovider.kubernetes.io/uninitialized",  "node.cloudprovider.kubernetes.io/shutdown", "kubernetes.azure.com/scalesetpriority"]
        :param builtins.str value: Set taint value.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        Set taint effect.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Set taint key. The following taint keys are not allowed: ["node.kubernetes.io/not-ready",  "node.kubernetes.io/unreachable", "node.kubernetes.io/unschedulable",  "node.kubernetes.io/memory-pressure",  "node.kubernetes.io/disk-pressure",  "node.kubernetes.io/network-unavailable",  "node.kubernetes.io/pid-pressure",  "node.kubernetes.io/out-of-service",  "node.cloudprovider.kubernetes.io/uninitialized",  "node.cloudprovider.kubernetes.io/shutdown", "kubernetes.azure.com/scalesetpriority"]
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Set taint value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanNpUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldRoll":
            suggest = "should_roll"
        elif key == "conditionedRoll":
            suggest = "conditioned_roll"
        elif key == "rollConfig":
            suggest = "roll_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_roll: builtins.bool,
                 conditioned_roll: Optional[builtins.bool] = None,
                 roll_config: Optional['outputs.OceanNpUpdatePolicyRollConfig'] = None):
        """
        :param builtins.bool should_roll: If set to true along with the cluster update, roll will be triggered.
        :param builtins.bool conditioned_roll: Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as availability_zones, max_pods_per_node, enable_node_public_ip, os_disk_size_gb, os_disk_type, os_sku, kubernetes_version, vnet_subnet_ids, pod_subnet_ids, labels, taints and tags).
        :param 'OceanNpUpdatePolicyRollConfigArgs' roll_config: While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        pulumi.set(__self__, "should_roll", should_roll)
        if conditioned_roll is not None:
            pulumi.set(__self__, "conditioned_roll", conditioned_roll)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> builtins.bool:
        """
        If set to true along with the cluster update, roll will be triggered.
        """
        return pulumi.get(self, "should_roll")

    @property
    @pulumi.getter(name="conditionedRoll")
    def conditioned_roll(self) -> Optional[builtins.bool]:
        """
        Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as availability_zones, max_pods_per_node, enable_node_public_ip, os_disk_size_gb, os_disk_type, os_sku, kubernetes_version, vnet_subnet_ids, pod_subnet_ids, labels, taints and tags).
        """
        return pulumi.get(self, "conditioned_roll")

    @property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional['outputs.OceanNpUpdatePolicyRollConfig']:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "roll_config")


@pulumi.output_type
class OceanNpUpdatePolicyRollConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "nodeNames":
            suggest = "node_names"
        elif key == "nodePoolNames":
            suggest = "node_pool_names"
        elif key == "respectPdb":
            suggest = "respect_pdb"
        elif key == "respectRestrictScaleDown":
            suggest = "respect_restrict_scale_down"
        elif key == "vngIds":
            suggest = "vng_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpUpdatePolicyRollConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpUpdatePolicyRollConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpUpdatePolicyRollConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_min_healthy_percentage: Optional[builtins.int] = None,
                 batch_size_percentage: Optional[builtins.int] = None,
                 comment: Optional[builtins.str] = None,
                 node_names: Optional[Sequence[builtins.str]] = None,
                 node_pool_names: Optional[Sequence[builtins.str]] = None,
                 respect_pdb: Optional[builtins.bool] = None,
                 respect_restrict_scale_down: Optional[builtins.bool] = None,
                 vng_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int batch_min_healthy_percentage: Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param builtins.int batch_size_percentage: Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        :param builtins.str comment: Add a comment description for the roll. The comment is limited to 256 chars and optional.
        :param Sequence[builtins.str] node_names: List of node names to be rolled. Each identifier is a string. nodeNames can be null, and cannot be used together with nodePoolNames and vngIds.
        :param Sequence[builtins.str] node_pool_names: List of node pools to be rolled. Each node pool name is a string. nodePoolNames can be null, and cannot be used together with nodeNames and vngIds.
        :param builtins.bool respect_pdb: During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        :param builtins.bool respect_restrict_scale_down: During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        :param Sequence[builtins.str] vng_ids: List of virtual node group identifiers to be rolled. Each identifier is a string. vngIds can be null, and cannot be used together with nodeNames and nodePoolNames.
        """
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if node_names is not None:
            pulumi.set(__self__, "node_names", node_names)
        if node_pool_names is not None:
            pulumi.set(__self__, "node_pool_names", node_pool_names)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)
        if respect_restrict_scale_down is not None:
            pulumi.set(__self__, "respect_restrict_scale_down", respect_restrict_scale_down)
        if vng_ids is not None:
            pulumi.set(__self__, "vng_ids", vng_ids)

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[builtins.int]:
        """
        Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[builtins.int]:
        """
        Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Add a comment description for the roll. The comment is limited to 256 chars and optional.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="nodeNames")
    def node_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of node names to be rolled. Each identifier is a string. nodeNames can be null, and cannot be used together with nodePoolNames and vngIds.
        """
        return pulumi.get(self, "node_names")

    @property
    @pulumi.getter(name="nodePoolNames")
    def node_pool_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of node pools to be rolled. Each node pool name is a string. nodePoolNames can be null, and cannot be used together with nodeNames and vngIds.
        """
        return pulumi.get(self, "node_pool_names")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        """
        return pulumi.get(self, "respect_pdb")

    @property
    @pulumi.getter(name="respectRestrictScaleDown")
    def respect_restrict_scale_down(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        """
        return pulumi.get(self, "respect_restrict_scale_down")

    @property
    @pulumi.getter(name="vngIds")
    def vng_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of virtual node group identifiers to be rolled. Each identifier is a string. vngIds can be null, and cannot be used together with nodeNames and nodePoolNames.
        """
        return pulumi.get(self, "vng_ids")


@pulumi.output_type
class OceanNpVirtualNodeGroupFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratedNetworking":
            suggest = "accelerated_networking"
        elif key == "diskPerformance":
            suggest = "disk_performance"
        elif key == "excludeSeries":
            suggest = "exclude_series"
        elif key == "gpuTypes":
            suggest = "gpu_types"
        elif key == "maxGpu":
            suggest = "max_gpu"
        elif key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxVcpu":
            suggest = "max_vcpu"
        elif key == "minDisk":
            suggest = "min_disk"
        elif key == "minGpu":
            suggest = "min_gpu"
        elif key == "minMemoryGib":
            suggest = "min_memory_gib"
        elif key == "minNics":
            suggest = "min_nics"
        elif key == "minVcpu":
            suggest = "min_vcpu"
        elif key == "vmTypes":
            suggest = "vm_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerated_networking: Optional[builtins.str] = None,
                 architectures: Optional[Sequence[builtins.str]] = None,
                 disk_performance: Optional[builtins.str] = None,
                 exclude_series: Optional[Sequence[builtins.str]] = None,
                 gpu_types: Optional[Sequence[builtins.str]] = None,
                 max_gpu: Optional[builtins.float] = None,
                 max_memory_gib: Optional[builtins.float] = None,
                 max_vcpu: Optional[builtins.int] = None,
                 min_disk: Optional[builtins.int] = None,
                 min_gpu: Optional[builtins.float] = None,
                 min_memory_gib: Optional[builtins.float] = None,
                 min_nics: Optional[builtins.int] = None,
                 min_vcpu: Optional[builtins.int] = None,
                 series: Optional[Sequence[builtins.str]] = None,
                 vm_types: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str accelerated_networking: In case acceleratedNetworking is set to Enabled, accelerated networking applies only to the VM that enables it.
        :param Sequence[builtins.str] architectures: The filtered vm sizes will support at least one of the architectures from this list. x86_64 includes both intel64 and amd64.
        :param builtins.str disk_performance: The filtered vm sizes will support at least one of the classes from this list.
        :param Sequence[builtins.str] exclude_series: Vm sizes belonging to a series from the list will not be available for scaling.
        :param Sequence[builtins.str] gpu_types: The filtered gpu types will belong to one of the gpu types from this list.
        :param builtins.float max_gpu: Maximum number of GPUs available.
        :param builtins.float max_memory_gib: Maximum amount of Memory (GiB).
        :param builtins.int max_vcpu: Maximum number of vcpus available.
        :param builtins.int min_disk: Minimum number of data disks available.
        :param builtins.float min_gpu: Minimum number of GPUs available.
        :param builtins.float min_memory_gib: Minimum amount of Memory (GiB).
        :param builtins.int min_nics: Minimum number of network interfaces.
        :param builtins.int min_vcpu: Minimum number of vcpus available.
        :param Sequence[builtins.str] series: Vm sizes belonging to a series from the list will be available for scaling.
        :param Sequence[builtins.str] vm_types: The filtered vm types will belong to one of the vm types from this list.
        """
        if accelerated_networking is not None:
            pulumi.set(__self__, "accelerated_networking", accelerated_networking)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if disk_performance is not None:
            pulumi.set(__self__, "disk_performance", disk_performance)
        if exclude_series is not None:
            pulumi.set(__self__, "exclude_series", exclude_series)
        if gpu_types is not None:
            pulumi.set(__self__, "gpu_types", gpu_types)
        if max_gpu is not None:
            pulumi.set(__self__, "max_gpu", max_gpu)
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)
        if min_disk is not None:
            pulumi.set(__self__, "min_disk", min_disk)
        if min_gpu is not None:
            pulumi.set(__self__, "min_gpu", min_gpu)
        if min_memory_gib is not None:
            pulumi.set(__self__, "min_memory_gib", min_memory_gib)
        if min_nics is not None:
            pulumi.set(__self__, "min_nics", min_nics)
        if min_vcpu is not None:
            pulumi.set(__self__, "min_vcpu", min_vcpu)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if vm_types is not None:
            pulumi.set(__self__, "vm_types", vm_types)

    @property
    @pulumi.getter(name="acceleratedNetworking")
    def accelerated_networking(self) -> Optional[builtins.str]:
        """
        In case acceleratedNetworking is set to Enabled, accelerated networking applies only to the VM that enables it.
        """
        return pulumi.get(self, "accelerated_networking")

    @property
    @pulumi.getter
    def architectures(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered vm sizes will support at least one of the architectures from this list. x86_64 includes both intel64 and amd64.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter(name="diskPerformance")
    def disk_performance(self) -> Optional[builtins.str]:
        """
        The filtered vm sizes will support at least one of the classes from this list.
        """
        return pulumi.get(self, "disk_performance")

    @property
    @pulumi.getter(name="excludeSeries")
    def exclude_series(self) -> Optional[Sequence[builtins.str]]:
        """
        Vm sizes belonging to a series from the list will not be available for scaling.
        """
        return pulumi.get(self, "exclude_series")

    @property
    @pulumi.getter(name="gpuTypes")
    def gpu_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered gpu types will belong to one of the gpu types from this list.
        """
        return pulumi.get(self, "gpu_types")

    @property
    @pulumi.getter(name="maxGpu")
    def max_gpu(self) -> Optional[builtins.float]:
        """
        Maximum number of GPUs available.
        """
        return pulumi.get(self, "max_gpu")

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[builtins.float]:
        """
        Maximum amount of Memory (GiB).
        """
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[builtins.int]:
        """
        Maximum number of vcpus available.
        """
        return pulumi.get(self, "max_vcpu")

    @property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> Optional[builtins.int]:
        """
        Minimum number of data disks available.
        """
        return pulumi.get(self, "min_disk")

    @property
    @pulumi.getter(name="minGpu")
    def min_gpu(self) -> Optional[builtins.float]:
        """
        Minimum number of GPUs available.
        """
        return pulumi.get(self, "min_gpu")

    @property
    @pulumi.getter(name="minMemoryGib")
    def min_memory_gib(self) -> Optional[builtins.float]:
        """
        Minimum amount of Memory (GiB).
        """
        return pulumi.get(self, "min_memory_gib")

    @property
    @pulumi.getter(name="minNics")
    def min_nics(self) -> Optional[builtins.int]:
        """
        Minimum number of network interfaces.
        """
        return pulumi.get(self, "min_nics")

    @property
    @pulumi.getter(name="minVcpu")
    def min_vcpu(self) -> Optional[builtins.int]:
        """
        Minimum number of vcpus available.
        """
        return pulumi.get(self, "min_vcpu")

    @property
    @pulumi.getter
    def series(self) -> Optional[Sequence[builtins.str]]:
        """
        Vm sizes belonging to a series from the list will be available for scaling.
        """
        return pulumi.get(self, "series")

    @property
    @pulumi.getter(name="vmTypes")
    def vm_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered vm types will belong to one of the vm types from this list.
        """
        return pulumi.get(self, "vm_types")


@pulumi.output_type
class OceanNpVirtualNodeGroupHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "gpuPerUnit":
            suggest = "gpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[builtins.int] = None,
                 gpu_per_unit: Optional[builtins.int] = None,
                 memory_per_unit: Optional[builtins.int] = None,
                 num_of_units: Optional[builtins.int] = None):
        """
        :param builtins.int cpu_per_unit: Configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param builtins.int gpu_per_unit: Amount of GPU to allocate for headroom unit.
        :param builtins.int memory_per_unit: Configure the amount of memory (MiB) to allocate the headroom.
        :param builtins.int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if gpu_per_unit is not None:
            pulumi.set(__self__, "gpu_per_unit", gpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[builtins.int]:
        """
        Configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="gpuPerUnit")
    def gpu_per_unit(self) -> Optional[builtins.int]:
        """
        Amount of GPU to allocate for headroom unit.
        """
        return pulumi.get(self, "gpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[builtins.int]:
        """
        Configure the amount of memory (MiB) to allocate the headroom.
        """
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[builtins.int]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class OceanNpVirtualNodeGroupLinuxOsConfig(dict):
    def __init__(__self__, *,
                 sysctls: Optional[Sequence['outputs.OceanNpVirtualNodeGroupLinuxOsConfigSysctl']] = None):
        """
        :param Sequence['OceanNpVirtualNodeGroupLinuxOsConfigSysctlArgs'] sysctls: System Controls
        """
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[Sequence['outputs.OceanNpVirtualNodeGroupLinuxOsConfigSysctl']]:
        """
        System Controls
        """
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class OceanNpVirtualNodeGroupLinuxOsConfigSysctl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmMaxMapCount":
            suggest = "vm_max_map_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupLinuxOsConfigSysctl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupLinuxOsConfigSysctl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupLinuxOsConfigSysctl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_max_map_count: Optional[builtins.int] = None):
        """
        :param builtins.int vm_max_map_count: Maximum number of memory map areas a process may have. Can be configured only if OS type is Linux.
        """
        if vm_max_map_count is not None:
            pulumi.set(__self__, "vm_max_map_count", vm_max_map_count)

    @property
    @pulumi.getter(name="vmMaxMapCount")
    def vm_max_map_count(self) -> Optional[builtins.int]:
        """
        Maximum number of memory map areas a process may have. Can be configured only if OS type is Linux.
        """
        return pulumi.get(self, "vm_max_map_count")


@pulumi.output_type
class OceanNpVirtualNodeGroupScheduling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shutdownHours":
            suggest = "shutdown_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupScheduling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupScheduling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupScheduling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shutdown_hours: Optional['outputs.OceanNpVirtualNodeGroupSchedulingShutdownHours'] = None):
        """
        :param 'OceanNpVirtualNodeGroupSchedulingShutdownHoursArgs' shutdown_hours: An object used to specify times that the nodes in the virtual node group will be stopped.
        """
        if shutdown_hours is not None:
            pulumi.set(__self__, "shutdown_hours", shutdown_hours)

    @property
    @pulumi.getter(name="shutdownHours")
    def shutdown_hours(self) -> Optional['outputs.OceanNpVirtualNodeGroupSchedulingShutdownHours']:
        """
        An object used to specify times that the nodes in the virtual node group will be stopped.
        """
        return pulumi.get(self, "shutdown_hours")


@pulumi.output_type
class OceanNpVirtualNodeGroupSchedulingShutdownHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "timeWindows":
            suggest = "time_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupSchedulingShutdownHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupSchedulingShutdownHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupSchedulingShutdownHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[builtins.bool] = None,
                 time_windows: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool is_enabled: Flag to enable or disable the shutdown hours mechanism. When `false`, the mechanism is deactivated, and the virtual node gorup remains in its current state.
        :param Sequence[builtins.str] time_windows: The times that the shutdown hours will apply. Required if isEnabled is true.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        Flag to enable or disable the shutdown hours mechanism. When `false`, the mechanism is deactivated, and the virtual node gorup remains in its current state.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[Sequence[builtins.str]]:
        """
        The times that the shutdown hours will apply. Required if isEnabled is true.
        """
        return pulumi.get(self, "time_windows")


@pulumi.output_type
class OceanNpVirtualNodeGroupTaint(dict):
    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str effect: Set taint effect.
        :param builtins.str key: Set taint key. The following are not allowed: "kubernetes.azure.com/scalesetpriority".
        :param builtins.str value: Set taint value.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        Set taint effect.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Set taint key. The following are not allowed: "kubernetes.azure.com/scalesetpriority".
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Set taint value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanNpVirtualNodeGroupUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldRoll":
            suggest = "should_roll"
        elif key == "conditionedRoll":
            suggest = "conditioned_roll"
        elif key == "rollConfig":
            suggest = "roll_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_roll: builtins.bool,
                 conditioned_roll: Optional[builtins.bool] = None,
                 roll_config: Optional['outputs.OceanNpVirtualNodeGroupUpdatePolicyRollConfig'] = None):
        """
        :param builtins.bool should_roll: If set to true along with the vng update, roll will be triggered.
        :param builtins.bool conditioned_roll: Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as availability_zones, max_pods_per_node, enable_node_public_ip, os_disk_size_gb, os_disk_type, os_sku, kubernetes_version, vnet_subnet_ids, pod_subnet_ids, labels, taints and tags).
        :param 'OceanNpVirtualNodeGroupUpdatePolicyRollConfigArgs' roll_config: While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        pulumi.set(__self__, "should_roll", should_roll)
        if conditioned_roll is not None:
            pulumi.set(__self__, "conditioned_roll", conditioned_roll)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> builtins.bool:
        """
        If set to true along with the vng update, roll will be triggered.
        """
        return pulumi.get(self, "should_roll")

    @property
    @pulumi.getter(name="conditionedRoll")
    def conditioned_roll(self) -> Optional[builtins.bool]:
        """
        Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as availability_zones, max_pods_per_node, enable_node_public_ip, os_disk_size_gb, os_disk_type, os_sku, kubernetes_version, vnet_subnet_ids, pod_subnet_ids, labels, taints and tags).
        """
        return pulumi.get(self, "conditioned_roll")

    @property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional['outputs.OceanNpVirtualNodeGroupUpdatePolicyRollConfig']:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "roll_config")


@pulumi.output_type
class OceanNpVirtualNodeGroupUpdatePolicyRollConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "nodeNames":
            suggest = "node_names"
        elif key == "nodePoolNames":
            suggest = "node_pool_names"
        elif key == "respectPdb":
            suggest = "respect_pdb"
        elif key == "respectRestrictScaleDown":
            suggest = "respect_restrict_scale_down"
        elif key == "vngIds":
            suggest = "vng_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVirtualNodeGroupUpdatePolicyRollConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVirtualNodeGroupUpdatePolicyRollConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVirtualNodeGroupUpdatePolicyRollConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_min_healthy_percentage: Optional[builtins.int] = None,
                 batch_size_percentage: Optional[builtins.int] = None,
                 comment: Optional[builtins.str] = None,
                 node_names: Optional[Sequence[builtins.str]] = None,
                 node_pool_names: Optional[Sequence[builtins.str]] = None,
                 respect_pdb: Optional[builtins.bool] = None,
                 respect_restrict_scale_down: Optional[builtins.bool] = None,
                 vng_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int batch_min_healthy_percentage: Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param builtins.int batch_size_percentage: Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        :param builtins.str comment: Add a comment description for the roll. The comment is limited to 256 chars and optional.
        :param Sequence[builtins.str] node_names: List of node names to be rolled. Each identifier is a string. nodeNames can be null, and cannot be used together with nodePoolNames and vngIds.
        :param Sequence[builtins.str] node_pool_names: List of node pools to be rolled. Each node pool name is a string. nodePoolNames can be null, and cannot be used together with nodeNames and vngIds.
        :param builtins.bool respect_pdb: During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        :param builtins.bool respect_restrict_scale_down: During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        :param Sequence[builtins.str] vng_ids: List of virtual node group identifiers to be rolled. Each identifier is a string. vngIds can be null, and cannot be used together with nodeNames and nodePoolNames.
        """
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if node_names is not None:
            pulumi.set(__self__, "node_names", node_names)
        if node_pool_names is not None:
            pulumi.set(__self__, "node_pool_names", node_pool_names)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)
        if respect_restrict_scale_down is not None:
            pulumi.set(__self__, "respect_restrict_scale_down", respect_restrict_scale_down)
        if vng_ids is not None:
            pulumi.set(__self__, "vng_ids", vng_ids)

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[builtins.int]:
        """
        Indicates the threshold of minimum healthy nodes in single batch. If the amount of healthy nodes in single batch is under the threshold, the roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[builtins.int]:
        """
        Value as a percent to set the size of a batch in a roll. Valid values are 0-100. In case of null as value, the default value in the backend will be 20%.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Add a comment description for the roll. The comment is limited to 256 chars and optional.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="nodeNames")
    def node_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of node names to be rolled. Each identifier is a string. nodeNames can be null, and cannot be used together with nodePoolNames and vngIds.
        """
        return pulumi.get(self, "node_names")

    @property
    @pulumi.getter(name="nodePoolNames")
    def node_pool_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of node pools to be rolled. Each node pool name is a string. nodePoolNames can be null, and cannot be used together with nodeNames and vngIds.
        """
        return pulumi.get(self, "node_pool_names")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor PDB during the nodes replacement.
        """
        return pulumi.get(self, "respect_pdb")

    @property
    @pulumi.getter(name="respectRestrictScaleDown")
    def respect_restrict_scale_down(self) -> Optional[builtins.bool]:
        """
        During the roll, if the parameter is set to true we honor Restrict Scale Down label during the nodes replacement.
        """
        return pulumi.get(self, "respect_restrict_scale_down")

    @property
    @pulumi.getter(name="vngIds")
    def vng_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of virtual node group identifiers to be rolled. Each identifier is a string. vngIds can be null, and cannot be used together with nodeNames and nodePoolNames.
        """
        return pulumi.get(self, "vng_ids")


@pulumi.output_type
class OceanNpVngTemplateScheduling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vngTemplateShutdownHours":
            suggest = "vng_template_shutdown_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVngTemplateScheduling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVngTemplateScheduling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVngTemplateScheduling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vng_template_shutdown_hours: Optional['outputs.OceanNpVngTemplateSchedulingVngTemplateShutdownHours'] = None):
        if vng_template_shutdown_hours is not None:
            pulumi.set(__self__, "vng_template_shutdown_hours", vng_template_shutdown_hours)

    @property
    @pulumi.getter(name="vngTemplateShutdownHours")
    def vng_template_shutdown_hours(self) -> Optional['outputs.OceanNpVngTemplateSchedulingVngTemplateShutdownHours']:
        return pulumi.get(self, "vng_template_shutdown_hours")


@pulumi.output_type
class OceanNpVngTemplateSchedulingVngTemplateShutdownHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "timeWindows":
            suggest = "time_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanNpVngTemplateSchedulingVngTemplateShutdownHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanNpVngTemplateSchedulingVngTemplateShutdownHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanNpVngTemplateSchedulingVngTemplateShutdownHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[builtins.bool] = None,
                 time_windows: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] time_windows: The times that the shutdown hours will apply. Required if `is_enabled` is true.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[Sequence[builtins.str]]:
        """
        The times that the shutdown hours will apply. Required if `is_enabled` is true.
        """
        return pulumi.get(self, "time_windows")


