# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElastigroupArgs', 'Elastigroup']

@pulumi.input_type
class ElastigroupArgs:
    def __init__(__self__, *,
                 cluster_zone_name: pulumi.Input[builtins.str],
                 desired_capacity: pulumi.Input[builtins.int],
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]] = None,
                 instance_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']] = None,
                 integration_gke: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']] = None,
                 ip_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]] = None,
                 node_image: Optional[pulumi.Input[builtins.str]] = None,
                 ondemand_count: Optional[pulumi.Input[builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 provisioning_model: Optional[pulumi.Input[builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']] = None,
                 should_utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Elastigroup resource.
        """
        pulumi.set(__self__, "cluster_zone_name", cluster_zone_name)
        pulumi.set(__self__, "desired_capacity", desired_capacity)
        if backend_services is not None:
            pulumi.set(__self__, "backend_services", backend_services)
        if cluster_id is not None:
            warnings.warn("""Please define cluster_id under integration_gke""", DeprecationWarning)
            pulumi.log.warn("""cluster_id is deprecated: Please define cluster_id under integration_gke""")
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if instance_name_prefix is not None:
            pulumi.set(__self__, "instance_name_prefix", instance_name_prefix)
        if instance_types_customs is not None:
            pulumi.set(__self__, "instance_types_customs", instance_types_customs)
        if instance_types_ondemand is not None:
            pulumi.set(__self__, "instance_types_ondemand", instance_types_ondemand)
        if instance_types_preemptibles is not None:
            pulumi.set(__self__, "instance_types_preemptibles", instance_types_preemptibles)
        if integration_docker_swarm is not None:
            pulumi.set(__self__, "integration_docker_swarm", integration_docker_swarm)
        if integration_gke is not None:
            pulumi.set(__self__, "integration_gke", integration_gke)
        if ip_forwarding is not None:
            pulumi.set(__self__, "ip_forwarding", ip_forwarding)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if node_image is not None:
            pulumi.set(__self__, "node_image", node_image)
        if ondemand_count is not None:
            pulumi.set(__self__, "ondemand_count", ondemand_count)
        if optimization_windows is not None:
            pulumi.set(__self__, "optimization_windows", optimization_windows)
        if preemptible_percentage is not None:
            pulumi.set(__self__, "preemptible_percentage", preemptible_percentage)
        if provisioning_model is not None:
            pulumi.set(__self__, "provisioning_model", provisioning_model)
        if revert_to_preemptibles is not None:
            pulumi.set(__self__, "revert_to_preemptibles", revert_to_preemptibles)
        if scaling_down_policies is not None:
            pulumi.set(__self__, "scaling_down_policies", scaling_down_policies)
        if scaling_up_policies is not None:
            pulumi.set(__self__, "scaling_up_policies", scaling_up_policies)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if should_utilize_commitments is not None:
            pulumi.set(__self__, "should_utilize_commitments", should_utilize_commitments)
        if shutdown_script is not None:
            pulumi.set(__self__, "shutdown_script", shutdown_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterZoneName")
    def cluster_zone_name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "cluster_zone_name")

    @cluster_zone_name.setter
    def cluster_zone_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_zone_name", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]:
        return pulumi.get(self, "backend_services")

    @backend_services.setter
    def backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]):
        pulumi.set(self, "backend_services", value)

    @property
    @pulumi.getter(name="clusterId")
    @_utilities.deprecated("""Please define cluster_id under integration_gke""")
    def cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]:
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="instanceNamePrefix")
    def instance_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_name_prefix")

    @instance_name_prefix.setter
    def instance_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_name_prefix", value)

    @property
    @pulumi.getter(name="instanceTypesCustoms")
    def instance_types_customs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]:
        return pulumi.get(self, "instance_types_customs")

    @instance_types_customs.setter
    def instance_types_customs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]):
        pulumi.set(self, "instance_types_customs", value)

    @property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_types_ondemand")

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_types_ondemand", value)

    @property
    @pulumi.getter(name="instanceTypesPreemptibles")
    def instance_types_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "instance_types_preemptibles")

    @instance_types_preemptibles.setter
    def instance_types_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types_preemptibles", value)

    @property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]:
        return pulumi.get(self, "integration_docker_swarm")

    @integration_docker_swarm.setter
    def integration_docker_swarm(self, value: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]):
        pulumi.set(self, "integration_docker_swarm", value)

    @property
    @pulumi.getter(name="integrationGke")
    def integration_gke(self) -> Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]:
        return pulumi.get(self, "integration_gke")

    @integration_gke.setter
    def integration_gke(self, value: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]):
        pulumi.set(self, "integration_gke", value)

    @property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "ip_forwarding")

    @ip_forwarding.setter
    def ip_forwarding(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ip_forwarding", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]:
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]:
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="nodeImage")
    def node_image(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "node_image")

    @node_image.setter
    def node_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_image", value)

    @property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "ondemand_count")

    @ondemand_count.setter
    def ondemand_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ondemand_count", value)

    @property
    @pulumi.getter(name="optimizationWindows")
    def optimization_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "optimization_windows")

    @optimization_windows.setter
    def optimization_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "optimization_windows", value)

    @property
    @pulumi.getter(name="preemptiblePercentage")
    def preemptible_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "preemptible_percentage")

    @preemptible_percentage.setter
    def preemptible_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "preemptible_percentage", value)

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "provisioning_model")

    @provisioning_model.setter
    def provisioning_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_model", value)

    @property
    @pulumi.getter(name="revertToPreemptibles")
    def revert_to_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]:
        return pulumi.get(self, "revert_to_preemptibles")

    @revert_to_preemptibles.setter
    def revert_to_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]):
        pulumi.set(self, "revert_to_preemptibles", value)

    @property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]:
        return pulumi.get(self, "scaling_down_policies")

    @scaling_down_policies.setter
    def scaling_down_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]):
        pulumi.set(self, "scaling_down_policies", value)

    @property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]:
        return pulumi.get(self, "scaling_up_policies")

    @scaling_up_policies.setter
    def scaling_up_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]):
        pulumi.set(self, "scaling_up_policies", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]:
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter(name="shouldUtilizeCommitments")
    def should_utilize_commitments(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "should_utilize_commitments")

    @should_utilize_commitments.setter
    def should_utilize_commitments(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_utilize_commitments", value)

    @property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "shutdown_script")

    @shutdown_script.setter
    def shutdown_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_script", value)

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "startup_script", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ElastigroupState:
    def __init__(__self__, *,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_zone_name: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]] = None,
                 instance_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']] = None,
                 integration_gke: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']] = None,
                 ip_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]] = None,
                 node_image: Optional[pulumi.Input[builtins.str]] = None,
                 ondemand_count: Optional[pulumi.Input[builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 provisioning_model: Optional[pulumi.Input[builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']] = None,
                 should_utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Elastigroup resources.
        """
        if backend_services is not None:
            pulumi.set(__self__, "backend_services", backend_services)
        if cluster_id is not None:
            warnings.warn("""Please define cluster_id under integration_gke""", DeprecationWarning)
            pulumi.log.warn("""cluster_id is deprecated: Please define cluster_id under integration_gke""")
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_zone_name is not None:
            pulumi.set(__self__, "cluster_zone_name", cluster_zone_name)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if instance_name_prefix is not None:
            pulumi.set(__self__, "instance_name_prefix", instance_name_prefix)
        if instance_types_customs is not None:
            pulumi.set(__self__, "instance_types_customs", instance_types_customs)
        if instance_types_ondemand is not None:
            pulumi.set(__self__, "instance_types_ondemand", instance_types_ondemand)
        if instance_types_preemptibles is not None:
            pulumi.set(__self__, "instance_types_preemptibles", instance_types_preemptibles)
        if integration_docker_swarm is not None:
            pulumi.set(__self__, "integration_docker_swarm", integration_docker_swarm)
        if integration_gke is not None:
            pulumi.set(__self__, "integration_gke", integration_gke)
        if ip_forwarding is not None:
            pulumi.set(__self__, "ip_forwarding", ip_forwarding)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if node_image is not None:
            pulumi.set(__self__, "node_image", node_image)
        if ondemand_count is not None:
            pulumi.set(__self__, "ondemand_count", ondemand_count)
        if optimization_windows is not None:
            pulumi.set(__self__, "optimization_windows", optimization_windows)
        if preemptible_percentage is not None:
            pulumi.set(__self__, "preemptible_percentage", preemptible_percentage)
        if provisioning_model is not None:
            pulumi.set(__self__, "provisioning_model", provisioning_model)
        if revert_to_preemptibles is not None:
            pulumi.set(__self__, "revert_to_preemptibles", revert_to_preemptibles)
        if scaling_down_policies is not None:
            pulumi.set(__self__, "scaling_down_policies", scaling_down_policies)
        if scaling_up_policies is not None:
            pulumi.set(__self__, "scaling_up_policies", scaling_up_policies)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if should_utilize_commitments is not None:
            pulumi.set(__self__, "should_utilize_commitments", should_utilize_commitments)
        if shutdown_script is not None:
            pulumi.set(__self__, "shutdown_script", shutdown_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]:
        return pulumi.get(self, "backend_services")

    @backend_services.setter
    def backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]):
        pulumi.set(self, "backend_services", value)

    @property
    @pulumi.getter(name="clusterId")
    @_utilities.deprecated("""Please define cluster_id under integration_gke""")
    def cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterZoneName")
    def cluster_zone_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "cluster_zone_name")

    @cluster_zone_name.setter
    def cluster_zone_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_zone_name", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]:
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="instanceNamePrefix")
    def instance_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_name_prefix")

    @instance_name_prefix.setter
    def instance_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_name_prefix", value)

    @property
    @pulumi.getter(name="instanceTypesCustoms")
    def instance_types_customs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]:
        return pulumi.get(self, "instance_types_customs")

    @instance_types_customs.setter
    def instance_types_customs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]):
        pulumi.set(self, "instance_types_customs", value)

    @property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "instance_types_ondemand")

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_types_ondemand", value)

    @property
    @pulumi.getter(name="instanceTypesPreemptibles")
    def instance_types_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "instance_types_preemptibles")

    @instance_types_preemptibles.setter
    def instance_types_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types_preemptibles", value)

    @property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]:
        return pulumi.get(self, "integration_docker_swarm")

    @integration_docker_swarm.setter
    def integration_docker_swarm(self, value: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]):
        pulumi.set(self, "integration_docker_swarm", value)

    @property
    @pulumi.getter(name="integrationGke")
    def integration_gke(self) -> Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]:
        return pulumi.get(self, "integration_gke")

    @integration_gke.setter
    def integration_gke(self, value: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]):
        pulumi.set(self, "integration_gke", value)

    @property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "ip_forwarding")

    @ip_forwarding.setter
    def ip_forwarding(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ip_forwarding", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]:
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]:
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="nodeImage")
    def node_image(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "node_image")

    @node_image.setter
    def node_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_image", value)

    @property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "ondemand_count")

    @ondemand_count.setter
    def ondemand_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ondemand_count", value)

    @property
    @pulumi.getter(name="optimizationWindows")
    def optimization_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "optimization_windows")

    @optimization_windows.setter
    def optimization_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "optimization_windows", value)

    @property
    @pulumi.getter(name="preemptiblePercentage")
    def preemptible_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "preemptible_percentage")

    @preemptible_percentage.setter
    def preemptible_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "preemptible_percentage", value)

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "provisioning_model")

    @provisioning_model.setter
    def provisioning_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_model", value)

    @property
    @pulumi.getter(name="revertToPreemptibles")
    def revert_to_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]:
        return pulumi.get(self, "revert_to_preemptibles")

    @revert_to_preemptibles.setter
    def revert_to_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]):
        pulumi.set(self, "revert_to_preemptibles", value)

    @property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]:
        return pulumi.get(self, "scaling_down_policies")

    @scaling_down_policies.setter
    def scaling_down_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]):
        pulumi.set(self, "scaling_down_policies", value)

    @property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]:
        return pulumi.get(self, "scaling_up_policies")

    @scaling_up_policies.setter
    def scaling_up_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]):
        pulumi.set(self, "scaling_up_policies", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]:
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter(name="shouldUtilizeCommitments")
    def should_utilize_commitments(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "should_utilize_commitments")

    @should_utilize_commitments.setter
    def should_utilize_commitments(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_utilize_commitments", value)

    @property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "shutdown_script")

    @shutdown_script.setter
    def shutdown_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_script", value)

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "startup_script", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("spotinst:gke/elastigroup:Elastigroup")
class Elastigroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupBackendServiceArgs', 'ElastigroupBackendServiceArgsDict']]]]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_zone_name: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupDiskArgs', 'ElastigroupDiskArgsDict']]]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupGpuArgs', 'ElastigroupGpuArgsDict']]]]] = None,
                 instance_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
                 integration_gke: Optional[pulumi.Input[Union['ElastigroupIntegrationGkeArgs', 'ElastigroupIntegrationGkeArgsDict']]] = None,
                 ip_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
                 node_image: Optional[pulumi.Input[builtins.str]] = None,
                 ondemand_count: Optional[pulumi.Input[builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 provisioning_model: Optional[pulumi.Input[builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']]] = None,
                 should_utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Spotinst Elastigroup GKE resource. Please see [Importing a GKE cluster](https://api.spotinst.com/elastigroup-for-google-cloud/tutorials/import-a-gke-cluster-as-an-elastigroup/) for detailed information.

        ## Example Usage

        A gke.Elastigroup supports all of the fields defined in spotinst_elastigroup_gcp.

        There are two main differences:

        * you must include `cluster_zone_name` and `cluster_id`
        * a handful of parameters are created remotely and will not appear in the diff. A complete list can be found below.

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example_gke_elastigroup = spotinst.gke.Elastigroup("example-gke-elastigroup",
            name="example-gke",
            cluster_zone_name="us-central1-a",
            node_image="COS",
            max_size=5,
            min_size=1,
            desired_capacity=3,
            instance_types_ondemand="n1-standard-1",
            instance_types_preemptibles=[
                "n1-standard-1",
                "n1-standard-2",
            ],
            preemptible_percentage=100,
            integration_gke={
                "location": "us-central1-a",
                "cluster_id": "example-cluster-id",
                "autoscale_is_enabled": True,
                "autoscale_is_auto_config": False,
                "autoscale_cooldown": 300,
                "autoscale_headroom": {
                    "cpu_per_unit": 1024,
                    "memory_per_unit": 512,
                    "num_of_units": 2,
                },
                "autoscale_down": {
                    "evaluation_periods": 300,
                },
                "autoscale_labels": [{
                    "key": "label_key",
                    "value": "label_value",
                }],
            },
            backend_services=[{
                "service_name": "backend-service",
                "location_type": "global",
                "named_ports": [{
                    "name": "http",
                    "ports": [
                        "80",
                        "8080",
                    ],
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElastigroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Spotinst Elastigroup GKE resource. Please see [Importing a GKE cluster](https://api.spotinst.com/elastigroup-for-google-cloud/tutorials/import-a-gke-cluster-as-an-elastigroup/) for detailed information.

        ## Example Usage

        A gke.Elastigroup supports all of the fields defined in spotinst_elastigroup_gcp.

        There are two main differences:

        * you must include `cluster_zone_name` and `cluster_id`
        * a handful of parameters are created remotely and will not appear in the diff. A complete list can be found below.

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example_gke_elastigroup = spotinst.gke.Elastigroup("example-gke-elastigroup",
            name="example-gke",
            cluster_zone_name="us-central1-a",
            node_image="COS",
            max_size=5,
            min_size=1,
            desired_capacity=3,
            instance_types_ondemand="n1-standard-1",
            instance_types_preemptibles=[
                "n1-standard-1",
                "n1-standard-2",
            ],
            preemptible_percentage=100,
            integration_gke={
                "location": "us-central1-a",
                "cluster_id": "example-cluster-id",
                "autoscale_is_enabled": True,
                "autoscale_is_auto_config": False,
                "autoscale_cooldown": 300,
                "autoscale_headroom": {
                    "cpu_per_unit": 1024,
                    "memory_per_unit": 512,
                    "num_of_units": 2,
                },
                "autoscale_down": {
                    "evaluation_periods": 300,
                },
                "autoscale_labels": [{
                    "key": "label_key",
                    "value": "label_value",
                }],
            },
            backend_services=[{
                "service_name": "backend-service",
                "location_type": "global",
                "named_ports": [{
                    "name": "http",
                    "ports": [
                        "80",
                        "8080",
                    ],
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ElastigroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElastigroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupBackendServiceArgs', 'ElastigroupBackendServiceArgsDict']]]]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_zone_name: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupDiskArgs', 'ElastigroupDiskArgsDict']]]]] = None,
                 draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupGpuArgs', 'ElastigroupGpuArgsDict']]]]] = None,
                 instance_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
                 integration_gke: Optional[pulumi.Input[Union['ElastigroupIntegrationGkeArgs', 'ElastigroupIntegrationGkeArgsDict']]] = None,
                 ip_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
                 node_image: Optional[pulumi.Input[builtins.str]] = None,
                 ondemand_count: Optional[pulumi.Input[builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 provisioning_model: Optional[pulumi.Input[builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']]] = None,
                 should_utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElastigroupArgs.__new__(ElastigroupArgs)

            __props__.__dict__["backend_services"] = backend_services
            __props__.__dict__["cluster_id"] = cluster_id
            if cluster_zone_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_zone_name'")
            __props__.__dict__["cluster_zone_name"] = cluster_zone_name
            if desired_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'desired_capacity'")
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["disks"] = disks
            __props__.__dict__["draining_timeout"] = draining_timeout
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["gpu"] = gpu
            __props__.__dict__["instance_name_prefix"] = instance_name_prefix
            __props__.__dict__["instance_types_customs"] = instance_types_customs
            __props__.__dict__["instance_types_ondemand"] = instance_types_ondemand
            __props__.__dict__["instance_types_preemptibles"] = instance_types_preemptibles
            __props__.__dict__["integration_docker_swarm"] = integration_docker_swarm
            __props__.__dict__["integration_gke"] = integration_gke
            __props__.__dict__["ip_forwarding"] = ip_forwarding
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["min_cpu_platform"] = min_cpu_platform
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["node_image"] = node_image
            __props__.__dict__["ondemand_count"] = ondemand_count
            __props__.__dict__["optimization_windows"] = optimization_windows
            __props__.__dict__["preemptible_percentage"] = preemptible_percentage
            __props__.__dict__["provisioning_model"] = provisioning_model
            __props__.__dict__["revert_to_preemptibles"] = revert_to_preemptibles
            __props__.__dict__["scaling_down_policies"] = scaling_down_policies
            __props__.__dict__["scaling_up_policies"] = scaling_up_policies
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["should_utilize_commitments"] = should_utilize_commitments
            __props__.__dict__["shutdown_script"] = shutdown_script
            __props__.__dict__["startup_script"] = startup_script
            __props__.__dict__["tags"] = tags
        super(Elastigroup, __self__).__init__(
            'spotinst:gke/elastigroup:Elastigroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupBackendServiceArgs', 'ElastigroupBackendServiceArgsDict']]]]] = None,
            cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_zone_name: Optional[pulumi.Input[builtins.str]] = None,
            desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupDiskArgs', 'ElastigroupDiskArgsDict']]]]] = None,
            draining_timeout: Optional[pulumi.Input[builtins.int]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[builtins.bool]] = None,
            gpu: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupGpuArgs', 'ElastigroupGpuArgsDict']]]]] = None,
            instance_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]]] = None,
            instance_types_ondemand: Optional[pulumi.Input[builtins.str]] = None,
            instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
            integration_gke: Optional[pulumi.Input[Union['ElastigroupIntegrationGkeArgs', 'ElastigroupIntegrationGkeArgsDict']]] = None,
            ip_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]]] = None,
            max_size: Optional[pulumi.Input[builtins.int]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]]] = None,
            min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
            min_size: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
            node_image: Optional[pulumi.Input[builtins.str]] = None,
            ondemand_count: Optional[pulumi.Input[builtins.int]] = None,
            optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            preemptible_percentage: Optional[pulumi.Input[builtins.int]] = None,
            provisioning_model: Optional[pulumi.Input[builtins.str]] = None,
            revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]]] = None,
            scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
            scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']]] = None,
            should_utilize_commitments: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_script: Optional[pulumi.Input[builtins.str]] = None,
            startup_script: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Elastigroup':
        """
        Get an existing Elastigroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElastigroupState.__new__(_ElastigroupState)

        __props__.__dict__["backend_services"] = backend_services
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_zone_name"] = cluster_zone_name
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["disks"] = disks
        __props__.__dict__["draining_timeout"] = draining_timeout
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["gpu"] = gpu
        __props__.__dict__["instance_name_prefix"] = instance_name_prefix
        __props__.__dict__["instance_types_customs"] = instance_types_customs
        __props__.__dict__["instance_types_ondemand"] = instance_types_ondemand
        __props__.__dict__["instance_types_preemptibles"] = instance_types_preemptibles
        __props__.__dict__["integration_docker_swarm"] = integration_docker_swarm
        __props__.__dict__["integration_gke"] = integration_gke
        __props__.__dict__["ip_forwarding"] = ip_forwarding
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["min_cpu_platform"] = min_cpu_platform
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["node_image"] = node_image
        __props__.__dict__["ondemand_count"] = ondemand_count
        __props__.__dict__["optimization_windows"] = optimization_windows
        __props__.__dict__["preemptible_percentage"] = preemptible_percentage
        __props__.__dict__["provisioning_model"] = provisioning_model
        __props__.__dict__["revert_to_preemptibles"] = revert_to_preemptibles
        __props__.__dict__["scaling_down_policies"] = scaling_down_policies
        __props__.__dict__["scaling_up_policies"] = scaling_up_policies
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["should_utilize_commitments"] = should_utilize_commitments
        __props__.__dict__["shutdown_script"] = shutdown_script
        __props__.__dict__["startup_script"] = startup_script
        __props__.__dict__["tags"] = tags
        return Elastigroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupBackendService']]]:
        return pulumi.get(self, "backend_services")

    @property
    @pulumi.getter(name="clusterId")
    @_utilities.deprecated("""Please define cluster_id under integration_gke""")
    def cluster_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterZoneName")
    def cluster_zone_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "cluster_zone_name")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupDisk']]]:
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        return pulumi.get(self, "draining_timeout")

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "fallback_to_ondemand")

    @property
    @pulumi.getter
    def gpu(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupGpu']]]:
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter(name="instanceNamePrefix")
    def instance_name_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "instance_name_prefix")

    @property
    @pulumi.getter(name="instanceTypesCustoms")
    def instance_types_customs(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupInstanceTypesCustom']]]:
        return pulumi.get(self, "instance_types_customs")

    @property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "instance_types_ondemand")

    @property
    @pulumi.getter(name="instanceTypesPreemptibles")
    def instance_types_preemptibles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "instance_types_preemptibles")

    @property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationDockerSwarm']]:
        return pulumi.get(self, "integration_docker_swarm")

    @property
    @pulumi.getter(name="integrationGke")
    def integration_gke(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationGke']]:
        return pulumi.get(self, "integration_gke")

    @property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "ip_forwarding")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupLabel']]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupMetadata']]]:
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupNetworkInterface']]]:
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="nodeImage")
    def node_image(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "node_image")

    @property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> pulumi.Output[Optional[builtins.int]]:
        return pulumi.get(self, "ondemand_count")

    @property
    @pulumi.getter(name="optimizationWindows")
    def optimization_windows(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "optimization_windows")

    @property
    @pulumi.getter(name="preemptiblePercentage")
    def preemptible_percentage(self) -> pulumi.Output[Optional[builtins.int]]:
        return pulumi.get(self, "preemptible_percentage")

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "provisioning_model")

    @property
    @pulumi.getter(name="revertToPreemptibles")
    def revert_to_preemptibles(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupRevertToPreemptible']]]:
        return pulumi.get(self, "revert_to_preemptibles")

    @property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingDownPolicy']]]:
        return pulumi.get(self, "scaling_down_policies")

    @property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingUpPolicy']]]:
        return pulumi.get(self, "scaling_up_policies")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output[Optional['outputs.ElastigroupShieldedInstanceConfig']]:
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="shouldUtilizeCommitments")
    def should_utilize_commitments(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "should_utilize_commitments")

    @property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "shutdown_script")

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "startup_script")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "tags")

