# 🧬 BioQL Demo - START HERE

## ⚡ Quick Start (30 Seconds)

### 🔑 Demo API Key (Copy This):
```
bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d
```

### 🚀 Run Demo Now:
```bash
pip install bioql
python examples/quick_test.py
```

---

## 📁 Demo Files

| File | Purpose | When to Use |
|------|---------|-------------|
| **START_HERE.md** | This file - Quick start guide | First time setup |
| **DEMO_CREDENTIALS.md** | Complete API guide with 50+ examples | Full reference |
| **DEMO_EXECUTIVE_SUMMARY.md** | Business overview & metrics | Executive presentation |
| **DEMO_PACKAGE_COMPLETE.md** | Technical documentation | Developer onboarding |
| **DEMO_README.txt** | Plain text quick reference | Copy-paste reference |
| **examples/quick_test.py** | 30-second demo (3 examples) | Quick demo |
| **examples/demo_unlimited_simulator.py** | Full demo (10 examples) | Complete showcase |

---

## 💻 Try It Now (No Installation)

```python
from bioql import quantum

# Your unlimited demo API key
API_KEY = "bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d"

# Example 1: Create quantum entanglement
result = quantum(
    "create a bell state with two qubits and measure both",
    backend='ionq_simulator',
    api_key=API_KEY,
    shots=1000
)

# Example 2: Drug discovery - Aspirin molecule
result = quantum(
    "simulate aspirin molecule using variational quantum eigensolver "
    "with 4 qubits to find ground state energy",
    backend='ionq_simulator',
    api_key=API_KEY,
    shots=2048
)

# Example 3: Protein folding
result = quantum(
    "simulate protein folding using quantum annealing with 6 qubits",
    backend='ionq_simulator',
    api_key=API_KEY,
    shots=3000
)
```

---

## 🎯 What This Demo Shows

✅ **100% Natural Language** - No quantum gates knowledge needed
✅ **164 Billion Patterns** - Understands complex scientific queries
✅ **Drug Discovery Ready** - Molecular simulations, binding energy, toxicity
✅ **All Quantum Algorithms** - VQE, QAOA, Grover, QFT, GHZ
✅ **Unlimited Simulator Access** - Zero cost, no restrictions
✅ **Production Ready** - Enterprise-grade code quality

---

## 📊 Demo Options

### Option 1: Quick Test (Recommended First)
```bash
python examples/quick_test.py
```
- **Duration:** 30 seconds
- **Examples:** 3 (Bell State, Aspirin, Grover)
- **Perfect for:** First-time demos

### Option 2: Full Demo
```bash
python examples/demo_unlimited_simulator.py
```
- **Duration:** 2-3 minutes
- **Examples:** 10 (all algorithms)
- **Perfect for:** Complete product showcase

### Option 3: Custom Code
Use the API key in your own Python code (see examples above)

---

## 🔑 API Key Details

- **Key:** `bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d`
- **Email:** demo@bioql.com
- **Plan:** Enterprise (Unlimited)
- **Backend:** IonQ Simulator ONLY
- **Quota:** UNLIMITED shots
- **Cost:** $0.00 (FREE)
- **Restrictions:** Cannot use real quantum hardware (QPU)

---

## 🎓 Natural Language Examples

All examples use 100% natural English - no quantum gates!

### Drug Discovery
```python
quantum(
    "compute binding energy between semaglutide and glp1 receptor using VQE",
    backend='ionq_simulator',
    api_key='bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d'
)
```

### Quantum Chemistry
```python
quantum(
    "calculate dipole moment and bond angles of water molecule using 4 qubits",
    backend='ionq_simulator',
    api_key='bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d'
)
```

### Quantum Machine Learning
```python
quantum(
    "train quantum classifier on 4 qubits to predict drug toxicity",
    backend='ionq_simulator',
    api_key='bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d'
)
```

### Quantum Search
```python
quantum(
    "apply grover search algorithm on 3 qubits to find state 101",
    backend='ionq_simulator',
    api_key='bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d'
)
```

---

## 📚 Documentation

- **Quick Reference:** See `DEMO_README.txt`
- **Complete Guide:** See `DEMO_CREDENTIALS.md`
- **Business Overview:** See `DEMO_EXECUTIVE_SUMMARY.md`
- **Full Package:** See `DEMO_PACKAGE_COMPLETE.md`

---

## 🔧 Installation

### Basic (Recommended)
```bash
pip install bioql
```

### With Visualization
```bash
pip install bioql[viz]
```

### Complete (All Features)
```bash
pip install bioql[cloud,visualization,vina,viz,openmm]
```

---

## 🐛 Troubleshooting

### "Invalid API Key"
Make sure you're using the EXACT key:
```python
API_KEY = "bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d"
```

### "Backend not available"
Use `ionq_simulator` (NOT `ionq_qpu`):
```python
backend='ionq_simulator'  # ✅ Correct
```

### "Module not found"
Install BioQL:
```bash
pip install bioql
```

---

## 💰 Production Access

This demo key is **FREE** and **UNLIMITED** for simulator only.

For **real quantum hardware** (IBM Quantum, IonQ QPU):

| Plan | Price | QPU Access | Shots/Month |
|------|-------|------------|-------------|
| Academic | $49 | IBM only | 500 |
| Biotech | $499 | IBM + IonQ | 5,000 |
| Pharma | $4,999 | All | 999,999 |
| Enterprise | Custom | All | Unlimited |

**Get production key:** https://bioql.com/signup

---

## 📞 Support

- **Email:** support@bioql.com
- **Discord:** https://discord.gg/bioql
- **GitHub:** https://github.com/bioql/bioql/issues
- **Docs:** https://docs.bioql.com

---

## ✅ Next Steps

1. ✅ Run quick demo: `python examples/quick_test.py`
2. ✅ Try your own natural language queries
3. ✅ Review documentation files
4. ✅ Contact sales for production access

---

## 🎬 Video Tutorials

1. **Installation (2 min):** https://bioql.com/videos/quickstart
2. **Drug Discovery (5 min):** https://bioql.com/videos/drug-discovery
3. **Natural Language Guide (10 min):** https://bioql.com/videos/nl-guide

---

## 🚀 One-Line Demo

```bash
pip install bioql && python -c "from bioql import quantum; print(quantum('create bell state', backend='ionq_simulator', api_key='bioql_test_8a3f9d2c1e5b4f7a9c2d6e1f8b3a5c7d'))"
```

---

**Questions?** Start with `DEMO_README.txt` for quick reference or `DEMO_CREDENTIALS.md` for complete guide.

**Ready to demo?** Run: `python examples/quick_test.py`

🧬 **Welcome to the future of quantum computing!** ⚛️
