# WARNING!
# This is an autogenerated file.
# Do NOT edit this file directly, your changes will be overwritten.

from __future__ import annotations

from pydantic import BaseModel, Field, TypeAdapter
from typing import TYPE_CHECKING, Union, Optional, Literal, List, Any

from . import enums

if TYPE_CHECKING:
	from . import api

class MaybeInaccessibleMessage(BaseModel, frozen=True):
	message_id: int
	date: int
	chat: Chat

class Message(MaybeInaccessibleMessage, frozen=True):
	'''
    This object represents a message.

    Reference: https://core.telegram.org/bots/api#message
	'''

	message_id: int
	date: int
	chat: Chat
	message_thread_id: Optional[int] = Field(default=None)
	direct_messages_topic: Optional[DirectMessagesTopic] = Field(default=None)
	from_user: Optional[User] = Field(default=None, alias='from') # FIX `from` is a python reserved keyword
	sender_chat: Optional[Chat] = Field(default=None)
	sender_boost_count: Optional[int] = Field(default=None)
	sender_business_bot: Optional[User] = Field(default=None)
	business_connection_id: Optional[str] = Field(default=None)
	forward_origin: Optional[MessageOrigin] = Field(default=None)
	is_topic_message: Optional[bool] = Field(default=None)
	is_automatic_forward: Optional[bool] = Field(default=None)
	reply_to_message: Optional[Message] = Field(default=None)
	external_reply: Optional[ExternalReplyInfo] = Field(default=None)
	quote: Optional[TextQuote] = Field(default=None)
	reply_to_story: Optional[Story] = Field(default=None)
	reply_to_checklist_task_id: Optional[int] = Field(default=None)
	via_bot: Optional[User] = Field(default=None)
	edit_date: Optional[int] = Field(default=None)
	has_protected_content: Optional[bool] = Field(default=None)
	is_from_offline: Optional[bool] = Field(default=None)
	is_paid_post: Optional[bool] = Field(default=None)
	media_group_id: Optional[str] = Field(default=None)
	author_signature: Optional[str] = Field(default=None)
	paid_star_count: Optional[int] = Field(default=None)
	text: Optional[str] = Field(default=None)
	entities: Optional[List[MessageEntity]] = Field(default=None)
	link_preview_options: Optional[LinkPreviewOptions] = Field(default=None)
	suggested_post_info: Optional[SuggestedPostInfo] = Field(default=None)
	effect_id: Optional[str] = Field(default=None)
	animation: Optional[Animation] = Field(default=None)
	audio: Optional[Audio] = Field(default=None)
	document: Optional[Document] = Field(default=None)
	paid_media: Optional[PaidMediaInfo] = Field(default=None)
	photo: Optional[List[PhotoSize]] = Field(default=None)
	sticker: Optional[Sticker] = Field(default=None)
	story: Optional[Story] = Field(default=None)
	video: Optional[Video] = Field(default=None)
	video_note: Optional[VideoNote] = Field(default=None)
	voice: Optional[Voice] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	has_media_spoiler: Optional[bool] = Field(default=None)
	checklist: Optional[Checklist] = Field(default=None)
	contact: Optional[Contact] = Field(default=None)
	dice: Optional[Dice] = Field(default=None)
	game: Optional[Game] = Field(default=None)
	poll: Optional[Poll] = Field(default=None)
	venue: Optional[Venue] = Field(default=None)
	location: Optional[Location] = Field(default=None)
	new_chat_members: Optional[List[User]] = Field(default=None)
	left_chat_member: Optional[User] = Field(default=None)
	new_chat_title: Optional[str] = Field(default=None)
	new_chat_photo: Optional[List[PhotoSize]] = Field(default=None)
	delete_chat_photo: Optional[bool] = Field(default=None)
	group_chat_created: Optional[bool] = Field(default=None)
	supergroup_chat_created: Optional[bool] = Field(default=None)
	channel_chat_created: Optional[bool] = Field(default=None)
	message_auto_delete_timer_changed: Optional[MessageAutoDeleteTimerChanged] = Field(default=None)
	migrate_to_chat_id: Optional[int] = Field(default=None)
	migrate_from_chat_id: Optional[int] = Field(default=None)
	pinned_message: Optional[MaybeInaccessibleMessage] = Field(default=None)
	invoice: Optional[Invoice] = Field(default=None)
	successful_payment: Optional[SuccessfulPayment] = Field(default=None)
	refunded_payment: Optional[RefundedPayment] = Field(default=None)
	users_shared: Optional[UsersShared] = Field(default=None)
	chat_shared: Optional[ChatShared] = Field(default=None)
	gift: Optional[GiftInfo] = Field(default=None)
	unique_gift: Optional[UniqueGiftInfo] = Field(default=None)
	connected_website: Optional[str] = Field(default=None)
	write_access_allowed: Optional[WriteAccessAllowed] = Field(default=None)
	passport_data: Optional[PassportData] = Field(default=None)
	proximity_alert_triggered: Optional[ProximityAlertTriggered] = Field(default=None)
	boost_added: Optional[ChatBoostAdded] = Field(default=None)
	chat_background_set: Optional[ChatBackground] = Field(default=None)
	checklist_tasks_done: Optional[ChecklistTasksDone] = Field(default=None)
	checklist_tasks_added: Optional[ChecklistTasksAdded] = Field(default=None)
	direct_message_price_changed: Optional[DirectMessagePriceChanged] = Field(default=None)
	forum_topic_created: Optional[ForumTopicCreated] = Field(default=None)
	forum_topic_edited: Optional[ForumTopicEdited] = Field(default=None)
	forum_topic_closed: Optional[ForumTopicClosed] = Field(default=None)
	forum_topic_reopened: Optional[ForumTopicReopened] = Field(default=None)
	general_forum_topic_hidden: Optional[GeneralForumTopicHidden] = Field(default=None)
	general_forum_topic_unhidden: Optional[GeneralForumTopicUnhidden] = Field(default=None)
	giveaway_created: Optional[GiveawayCreated] = Field(default=None)
	giveaway: Optional[Giveaway] = Field(default=None)
	giveaway_winners: Optional[GiveawayWinners] = Field(default=None)
	giveaway_completed: Optional[GiveawayCompleted] = Field(default=None)
	paid_message_price_changed: Optional[PaidMessagePriceChanged] = Field(default=None)
	suggested_post_approved: Optional[SuggestedPostApproved] = Field(default=None)
	suggested_post_approval_failed: Optional[SuggestedPostApprovalFailed] = Field(default=None)
	suggested_post_declined: Optional[SuggestedPostDeclined] = Field(default=None)
	suggested_post_paid: Optional[SuggestedPostPaid] = Field(default=None)
	suggested_post_refunded: Optional[SuggestedPostRefunded] = Field(default=None)
	video_chat_scheduled: Optional[VideoChatScheduled] = Field(default=None)
	video_chat_started: Optional[VideoChatStarted] = Field(default=None)
	video_chat_ended: Optional[VideoChatEnded] = Field(default=None)
	video_chat_participants_invited: Optional[VideoChatParticipantsInvited] = Field(default=None)
	web_app_data: Optional[WebAppData] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	
	async def delete(self, bot: api.BotAPI) -> bool:
		return await bot.delete_message(
			chat_id=self.chat.id,
			message_id=self.message_id
		)
	
	async def edit_text(
		self,
		bot: api.BotAPI,
		text: str,
		# inline_message_id: Optional[str] = None,
		parse_mode: str | None = 'HTML',
		entities: list[MessageEntity] | None = None,
		link_preview_options: LinkPreviewOptions | None = None,
		reply_markup: InlineKeyboardMarkup | None = None,
	) -> Message | bool:
		return await bot.edit_message_text(
			chat_id=self.chat.id,
			message_id=self.message_id,
			business_connection_id=self.business_connection_id,
			# inline_message_id=self.inline_message_id,
			text=text,
			parse_mode=parse_mode,
			entities=entities,
			link_preview_options=link_preview_options,
			reply_markup=reply_markup
		)
	
	async def edit_reply_markup(
		self,
		bot: api.BotAPI,
		# inline_message_id: Optional[str] = None,
		reply_markup: InlineKeyboardMarkup | None = None,
	) -> Message | bool:
		return await bot.edit_message_reply_markup(
			chat_id=self.chat.id,
			message_id=self.message_id,
			business_connection_id=self.business_connection_id,
			# inline_message_id=self.inline_message_id,
			reply_markup=reply_markup,
		)
	
	async def reply_text(
		self,
		bot: api.BotAPI,
		text: str,
		parse_mode: str | None = 'HTML',
		entities: list[MessageEntity] | None = None,
		reply_to_original_message: bool = True, # CUSTOM
		allow_sending_without_reply: bool = True, # CUSTOM
		link_preview_options: LinkPreviewOptions | None = None,
		disable_notification: bool | None = None,
		protect_content: bool | None = None,
		allow_paid_broadcast: bool | None = None,
		message_effect_id: str | None = None,
		reply_parameters: ReplyParameters | None = None,
		# suggested_post_parameters: SuggestedPostParameters | None = None,
		reply_markup: InlineKeyboardMarkup | ReplyKeyboardMarkup | ReplyKeyboardRemove | ForceReply | None = None,
	) -> Message:
		'''
		Replies to this message with a text message.
		Shortcut for `bot.send_message`.
	
		You can pass **either** `parse_mode` or `entities` to format the message text.
	
		You can pass **either** `reply_to_original_message` or `reply_parameters` to reply
		to this message. If both are passed, `reply_parameters` will be used.
		
		'''
		if not reply_parameters and reply_to_original_message:
			reply_parameters = ReplyParameters(
				message_id=self.message_id,
				chat_id=self.chat.id,
				allow_sending_without_reply=allow_sending_without_reply,
				# quote='',
				# quote_entities=[],
				# quote_parse_mode=None,
				# quote_position=0
			)
	
		return await bot.send_message(
			chat_id=self.chat.id,
			text=text,
			business_connection_id=self.business_connection_id,
			message_thread_id=self.message_thread_id,
			parse_mode=parse_mode,
			entities=entities,
			link_preview_options=link_preview_options,
			disable_notification=disable_notification,
			protect_content=protect_content,
			allow_paid_broadcast=allow_paid_broadcast,
			message_effect_id=message_effect_id,
			# suggested_post_parameters=suggested_post_parameters,
			reply_parameters=reply_parameters,
			reply_markup=reply_markup
		)
	
	@property
	def media(self) -> Union[
		Animation,
		Audio,
		Document,
		list[PhotoSize],
		Sticker,
		Video,
		VideoNote,
		Voice,
		Story,
		PaidMedia,
		None
	]:
		'''
		Actual multimedia content of this message.
	
		See `enums.MediaType` for all available media 
		'''
		for media_type in enums.MediaType:
			content = getattr(self, media_type.value)
			if content is not None:
				return content
	
		return None
	
	@property
	def message_type(self) -> enums.MessageType | None:
		'''
		Type of the actual message content (e.g., `text`, `photo`, `sticker`, `poll`, `new_chat_title`, etc.).
	
		See `enums.MessageType` for all available message 
		'''
		for message_type in enums.MessageType:
			if getattr(self, message_type.value) is not None:
				return message_type
	
		return None
	 

class InaccessibleMessage(MaybeInaccessibleMessage, frozen=True):
	'''
    This object describes a message that was deleted
    or is otherwise inaccessible to the bot.

    Reference: https://core.telegram.org/bots/api#inaccessiblemessage
	'''

	chat: Chat
	message_id: int
	date: int 

_MaybeInaccessibleMessage = Union[
	Message,
	InaccessibleMessage,
]
MaybeInaccessibleMessageAdapter = TypeAdapter[_MaybeInaccessibleMessage](_MaybeInaccessibleMessage) 

class MessageOrigin(BaseModel, frozen=True):
	type: Literal['user', 'hidden_user', 'chat', 'channel']
	date: int

class MessageOriginUser(MessageOrigin, frozen=True):
	'''
    The message was originally sent by a known
    user.

    Reference: https://core.telegram.org/bots/api#messageoriginuser
	'''

	type: Literal['user'] = 'user'
	date: int
	sender_user: User 

class MessageOriginHiddenUser(MessageOrigin, frozen=True):
	'''
    The message was originally sent by an unknown
    user.

    Reference: https://core.telegram.org/bots/api#messageoriginhiddenuser
	'''

	type: Literal['hidden_user'] = 'hidden_user'
	date: int
	sender_user_name: str 

class MessageOriginChat(MessageOrigin, frozen=True):
	'''
    The message was originally sent on behalf of
    a chat to a group chat.

    Reference: https://core.telegram.org/bots/api#messageoriginchat
	'''

	type: Literal['chat'] = 'chat'
	date: int
	sender_chat: Chat
	author_signature: Optional[str] = Field(default=None) 

class MessageOriginChannel(MessageOrigin, frozen=True):
	'''
    The message was originally sent to a channel
    chat.

    Reference: https://core.telegram.org/bots/api#messageoriginchannel
	'''

	type: Literal['channel'] = 'channel'
	date: int
	chat: Chat
	message_id: int
	author_signature: Optional[str] = Field(default=None) 

_MessageOrigin = Union[
	MessageOriginUser,
	MessageOriginHiddenUser,
	MessageOriginChat,
	MessageOriginChannel,
]
MessageOriginAdapter = TypeAdapter[_MessageOrigin](_MessageOrigin) 

class PaidMedia(BaseModel, frozen=True):
	type: Literal['preview', 'photo', 'video']

class PaidMediaPreview(PaidMedia, frozen=True):
	'''
    The paid media isn't available before the payment.

    Reference: https://core.telegram.org/bots/api#paidmediapreview
	'''

	type: Literal['preview'] = 'preview'
	width: Optional[int] = Field(default=None)
	height: Optional[int] = Field(default=None)
	duration: Optional[int] = Field(default=None) 

class PaidMediaPhoto(PaidMedia, frozen=True):
	'''
    The paid media is a photo.

    Reference: https://core.telegram.org/bots/api#paidmediaphoto
	'''

	type: Literal['photo'] = 'photo'
	photo: List[PhotoSize] 

class PaidMediaVideo(PaidMedia, frozen=True):
	'''
    The paid media is a video.

    Reference: https://core.telegram.org/bots/api#paidmediavideo
	'''

	type: Literal['video'] = 'video'
	video: Video 

_PaidMedia = Union[
	PaidMediaPreview,
	PaidMediaPhoto,
	PaidMediaVideo,
]
PaidMediaAdapter = TypeAdapter[_PaidMedia](_PaidMedia) 

class BackgroundFill(BaseModel, frozen=True):
	type: Literal['solid', 'gradient', 'freeform_gradient']

class BackgroundFillSolid(BackgroundFill, frozen=True):
	'''
    The background is filled using the selected color.

    Reference: https://core.telegram.org/bots/api#backgroundfillsolid
	'''

	type: Literal['solid'] = 'solid'
	color: int 

class BackgroundFillGradient(BackgroundFill, frozen=True):
	'''
    The background is a gradient fill.

    Reference: https://core.telegram.org/bots/api#backgroundfillgradient
	'''

	type: Literal['gradient'] = 'gradient'
	top_color: int
	bottom_color: int
	rotation_angle: int 

class BackgroundFillFreeformGradient(BackgroundFill, frozen=True):
	'''
    The background is a freeform gradient that rotates
    after every message in the chat.

    Reference: https://core.telegram.org/bots/api#backgroundfillfreeformgradient
	'''

	type: Literal['freeform_gradient'] = 'freeform_gradient'
	colors: List[int] 

_BackgroundFill = Union[
	BackgroundFillSolid,
	BackgroundFillGradient,
	BackgroundFillFreeformGradient,
]
BackgroundFillAdapter = TypeAdapter[_BackgroundFill](_BackgroundFill) 

class BackgroundType(BaseModel, frozen=True):
	type: Literal['fill', 'wallpaper', 'pattern', 'chat_theme']

class BackgroundTypeFill(BackgroundType, frozen=True):
	'''
    The background is automatically filled based on the
    selected colors.

    Reference: https://core.telegram.org/bots/api#backgroundtypefill
	'''

	type: Literal['fill'] = 'fill'
	fill: BackgroundFill
	dark_theme_dimming: int 

class BackgroundTypeWallpaper(BackgroundType, frozen=True):
	'''
    The background is a wallpaper in the JPEG
    format.

    Reference: https://core.telegram.org/bots/api#backgroundtypewallpaper
	'''

	type: Literal['wallpaper'] = 'wallpaper'
	document: Document
	dark_theme_dimming: int
	is_blurred: Optional[bool] = Field(default=None)
	is_moving: Optional[bool] = Field(default=None) 

class BackgroundTypePattern(BackgroundType, frozen=True):
	'''
    The background is a .PNG or .TGV (gzipped
    subset of SVG with MIME type “application/x-tgwallpattern”) pattern
    to be combined with the background fill chosen
    by the user.

    Reference: https://core.telegram.org/bots/api#backgroundtypepattern
	'''

	type: Literal['pattern'] = 'pattern'
	document: Document
	fill: BackgroundFill
	intensity: int
	is_inverted: Optional[bool] = Field(default=None)
	is_moving: Optional[bool] = Field(default=None) 

class BackgroundTypeChatTheme(BackgroundType, frozen=True):
	'''
    The background is taken directly from a built-in
    chat theme.

    Reference: https://core.telegram.org/bots/api#backgroundtypechattheme
	'''

	type: Literal['chat_theme'] = 'chat_theme'
	theme_name: str 

_BackgroundType = Union[
	BackgroundTypeFill,
	BackgroundTypeWallpaper,
	BackgroundTypePattern,
	BackgroundTypeChatTheme,
]
BackgroundTypeAdapter = TypeAdapter[_BackgroundType](_BackgroundType) 

class ChatMember(BaseModel, frozen=True):
	status: Literal['creator', 'administrator', 'member', 'restricted', 'left', 'kicked']
	user: User

class ChatMemberOwner(ChatMember, frozen=True):
	'''
    Represents a chat member that owns the chat
    and has all administrator privileges.

    Reference: https://core.telegram.org/bots/api#chatmemberowner
	'''

	status: Literal['creator'] = 'creator'
	user: User
	is_anonymous: bool
	custom_title: Optional[str] = Field(default=None) 

class ChatMemberAdministrator(ChatMember, frozen=True):
	'''
    Represents a chat member that has some additional
    privileges.

    Reference: https://core.telegram.org/bots/api#chatmemberadministrator
	'''

	status: Literal['administrator'] = 'administrator'
	user: User
	can_be_edited: bool
	is_anonymous: bool
	can_manage_chat: bool
	can_delete_messages: bool
	can_manage_video_chats: bool
	can_restrict_members: bool
	can_promote_members: bool
	can_change_info: bool
	can_invite_users: bool
	can_post_stories: bool
	can_edit_stories: bool
	can_delete_stories: bool
	can_post_messages: Optional[bool] = Field(default=None)
	can_edit_messages: Optional[bool] = Field(default=None)
	can_pin_messages: Optional[bool] = Field(default=None)
	can_manage_topics: Optional[bool] = Field(default=None)
	can_manage_direct_messages: Optional[bool] = Field(default=None)
	custom_title: Optional[str] = Field(default=None) 

class ChatMemberMember(ChatMember, frozen=True):
	'''
    Represents a chat member that has no additional
    privileges or restrictions.

    Reference: https://core.telegram.org/bots/api#chatmembermember
	'''

	status: Literal['member'] = 'member'
	user: User
	until_date: Optional[int] = Field(default=None) 

class ChatMemberRestricted(ChatMember, frozen=True):
	'''
    Represents a chat member that is under certain
    restrictions in the chat. Supergroups only.

    Reference: https://core.telegram.org/bots/api#chatmemberrestricted
	'''

	status: Literal['restricted'] = 'restricted'
	user: User
	is_member: bool
	can_send_messages: bool
	can_send_audios: bool
	can_send_documents: bool
	can_send_photos: bool
	can_send_videos: bool
	can_send_video_notes: bool
	can_send_voice_notes: bool
	can_send_polls: bool
	can_send_other_messages: bool
	can_add_web_page_previews: bool
	can_change_info: bool
	can_invite_users: bool
	can_pin_messages: bool
	can_manage_topics: bool
	until_date: int 

class ChatMemberLeft(ChatMember, frozen=True):
	'''
    Represents a chat member that isn't currently a
    member of the chat, but may join it
    themselves.

    Reference: https://core.telegram.org/bots/api#chatmemberleft
	'''

	status: Literal['left'] = 'left'
	user: User 

class ChatMemberBanned(ChatMember, frozen=True):
	'''
    Represents a chat member that was banned in
    the chat and can't return to the chat
    or view chat messages.

    Reference: https://core.telegram.org/bots/api#chatmemberbanned
	'''

	status: Literal['kicked'] = 'kicked'
	user: User
	until_date: int 

_ChatMember = Union[
	ChatMemberOwner,
	ChatMemberAdministrator,
	ChatMemberMember,
	ChatMemberRestricted,
	ChatMemberLeft,
	ChatMemberBanned,
]
ChatMemberAdapter = TypeAdapter[_ChatMember](_ChatMember) 

class StoryAreaType(BaseModel, frozen=True):
	type: Literal['location', 'suggested_reaction', 'link', 'weather', 'unique_gift']

class StoryAreaTypeLocation(StoryAreaType, frozen=True):
	'''
    Describes a story area pointing to a location.
    Currently, a story can have up to 10
    location areas.

    Reference: https://core.telegram.org/bots/api#storyareatypelocation
	'''

	type: Literal['location'] = 'location'
	latitude: float
	longitude: float
	address: Optional[LocationAddress] = Field(default=None) 

class StoryAreaTypeSuggestedReaction(StoryAreaType, frozen=True):
	'''
    Describes a story area pointing to a suggested
    reaction. Currently, a story can have up to
    5 suggested reaction areas.

    Reference: https://core.telegram.org/bots/api#storyareatypesuggestedreaction
	'''

	type: Literal['suggested_reaction'] = 'suggested_reaction'
	reaction_type: ReactionType
	is_dark: Optional[bool] = Field(default=None)
	is_flipped: Optional[bool] = Field(default=None) 

class StoryAreaTypeLink(StoryAreaType, frozen=True):
	'''
    Describes a story area pointing to an HTTP
    or tg:// link. Currently, a story can have
    up to 3 link areas.

    Reference: https://core.telegram.org/bots/api#storyareatypelink
	'''

	type: Literal['link'] = 'link'
	url: str 

class StoryAreaTypeWeather(StoryAreaType, frozen=True):
	'''
    Describes a story area containing weather information. Currently,
    a story can have up to 3 weather
    areas.

    Reference: https://core.telegram.org/bots/api#storyareatypeweather
	'''

	type: Literal['weather'] = 'weather'
	temperature: float
	emoji: str
	background_color: int 

class StoryAreaTypeUniqueGift(StoryAreaType, frozen=True):
	'''
    Describes a story area pointing to a unique
    gift. Currently, a story can have at most
    1 unique gift area.

    Reference: https://core.telegram.org/bots/api#storyareatypeuniquegift
	'''

	type: Literal['unique_gift'] = 'unique_gift'
	name: str 

_StoryAreaType = Union[
	StoryAreaTypeLocation,
	StoryAreaTypeSuggestedReaction,
	StoryAreaTypeLink,
	StoryAreaTypeWeather,
	StoryAreaTypeUniqueGift,
]
StoryAreaTypeAdapter = TypeAdapter[_StoryAreaType](_StoryAreaType) 

class ReactionType(BaseModel, frozen=True):
	type: Literal['emoji', 'custom_emoji', 'paid']

class ReactionTypeEmoji(ReactionType, frozen=True):
	'''
    The reaction is based on an emoji.

    Reference: https://core.telegram.org/bots/api#reactiontypeemoji
	'''

	type: Literal['emoji'] = 'emoji'
	emoji: str 

class ReactionTypeCustomEmoji(ReactionType, frozen=True):
	'''
    The reaction is based on a custom emoji.

    Reference: https://core.telegram.org/bots/api#reactiontypecustomemoji
	'''

	type: Literal['custom_emoji'] = 'custom_emoji'
	custom_emoji_id: str 

class ReactionTypePaid(ReactionType, frozen=True):
	'''
    The reaction is paid.

    Reference: https://core.telegram.org/bots/api#reactiontypepaid
	'''

	type: Literal['paid'] = 'paid' 

_ReactionType = Union[
	ReactionTypeEmoji,
	ReactionTypeCustomEmoji,
	ReactionTypePaid,
]
ReactionTypeAdapter = TypeAdapter[_ReactionType](_ReactionType) 

class OwnedGift(BaseModel, frozen=True):
	type: Literal['regular', 'unique']
	owned_gift_id: Optional[str]
	sender_user: Optional[User]
	send_date: int
	is_saved: Optional[bool]

class OwnedGiftRegular(OwnedGift, frozen=True):
	'''
    Describes a regular gift owned by a user
    or a chat.

    Reference: https://core.telegram.org/bots/api#ownedgiftregular
	'''

	type: Literal['regular'] = 'regular'
	gift: Gift
	send_date: int
	owned_gift_id: Optional[str] = Field(default=None)
	sender_user: Optional[User] = Field(default=None)
	text: Optional[str] = Field(default=None)
	entities: Optional[List[MessageEntity]] = Field(default=None)
	is_private: Optional[bool] = Field(default=None)
	is_saved: Optional[bool] = Field(default=None)
	can_be_upgraded: Optional[bool] = Field(default=None)
	was_refunded: Optional[bool] = Field(default=None)
	convert_star_count: Optional[int] = Field(default=None)
	prepaid_upgrade_star_count: Optional[int] = Field(default=None) 

class OwnedGiftUnique(OwnedGift, frozen=True):
	'''
    Describes a unique gift received and owned by
    a user or a chat.

    Reference: https://core.telegram.org/bots/api#ownedgiftunique
	'''

	type: Literal['unique'] = 'unique'
	gift: UniqueGift
	send_date: int
	owned_gift_id: Optional[str] = Field(default=None)
	sender_user: Optional[User] = Field(default=None)
	is_saved: Optional[bool] = Field(default=None)
	can_be_transferred: Optional[bool] = Field(default=None)
	transfer_star_count: Optional[int] = Field(default=None)
	next_transfer_date: Optional[int] = Field(default=None) 

_OwnedGift = Union[
	OwnedGiftRegular,
	OwnedGiftUnique,
]
OwnedGiftAdapter = TypeAdapter[_OwnedGift](_OwnedGift) 

class BotCommandScope(BaseModel, frozen=True):
	type: Literal['default', 'all_private_chats', 'all_group_chats', 'all_chat_administrators', 'chat', 'chat_administrators', 'chat_member']

class BotCommandScopeDefault(BotCommandScope, frozen=True):
	'''
    Represents the default scope of bot commands. Default
    commands are used if no commands with a
    narrower scope are specified for the user.

    Reference: https://core.telegram.org/bots/api#botcommandscopedefault
	'''

	type: Literal['default'] = 'default' 

class BotCommandScopeAllPrivateChats(BotCommandScope, frozen=True):
	'''
    Represents the scope of bot commands, covering all
    private chats.

    Reference: https://core.telegram.org/bots/api#botcommandscopeallprivatechats
	'''

	type: Literal['all_private_chats'] = 'all_private_chats' 

class BotCommandScopeAllGroupChats(BotCommandScope, frozen=True):
	'''
    Represents the scope of bot commands, covering all
    group and supergroup chats.

    Reference: https://core.telegram.org/bots/api#botcommandscopeallgroupchats
	'''

	type: Literal['all_group_chats'] = 'all_group_chats' 

class BotCommandScopeAllChatAdministrators(BotCommandScope, frozen=True):
	'''
    Represents the scope of bot commands, covering all
    group and supergroup chat administrators.

    Reference: https://core.telegram.org/bots/api#botcommandscopeallchatadministrators
	'''

	type: Literal['all_chat_administrators'] = 'all_chat_administrators' 

class BotCommandScopeChat(BotCommandScope, frozen=True):
	'''
    Represents the scope of bot commands, covering a
    specific chat.

    Reference: https://core.telegram.org/bots/api#botcommandscopechat
	'''

	type: Literal['chat'] = 'chat'
	chat_id: Union[int, str] 

class BotCommandScopeChatAdministrators(BotCommandScope, frozen=True):
	'''
    Represents the scope of bot commands, covering all
    administrators of a specific group or supergroup chat.

    Reference: https://core.telegram.org/bots/api#botcommandscopechatadministrators
	'''

	type: Literal['chat_administrators'] = 'chat_administrators'
	chat_id: Union[int, str] 

class BotCommandScopeChatMember(BotCommandScope, frozen=True):
	'''
    Represents the scope of bot commands, covering a
    specific member of a group or supergroup chat.

    Reference: https://core.telegram.org/bots/api#botcommandscopechatmember
	'''

	type: Literal['chat_member'] = 'chat_member'
	chat_id: Union[int, str]
	user_id: int 

_BotCommandScope = Union[
	BotCommandScopeDefault,
	BotCommandScopeAllPrivateChats,
	BotCommandScopeAllGroupChats,
	BotCommandScopeAllChatAdministrators,
	BotCommandScopeChat,
	BotCommandScopeChatAdministrators,
	BotCommandScopeChatMember,
]
BotCommandScopeAdapter = TypeAdapter[_BotCommandScope](_BotCommandScope) 

class MenuButton(BaseModel, frozen=True):
	type: Literal['commands', 'web_app', 'default']

class MenuButtonCommands(MenuButton, frozen=True):
	'''
    Represents a menu button, which opens the bot's
    list of commands.

    Reference: https://core.telegram.org/bots/api#menubuttoncommands
	'''

	type: Literal['commands'] = 'commands' 

class MenuButtonWebApp(MenuButton, frozen=True):
	'''
    Represents a menu button, which launches a Web
    App.

    Reference: https://core.telegram.org/bots/api#menubuttonwebapp
	'''

	type: Literal['web_app'] = 'web_app'
	text: str
	web_app: WebAppInfo 

class MenuButtonDefault(MenuButton, frozen=True):
	'''
    Describes that no specific value for the menu
    button was set.

    Reference: https://core.telegram.org/bots/api#menubuttondefault
	'''

	type: Literal['default'] = 'default' 

_MenuButton = Union[
	MenuButtonCommands,
	MenuButtonWebApp,
	MenuButtonDefault,
]
MenuButtonAdapter = TypeAdapter[_MenuButton](_MenuButton) 

class ChatBoostSource(BaseModel, frozen=True):
	source: Literal['premium', 'gift_code', 'giveaway']

class ChatBoostSourcePremium(ChatBoostSource, frozen=True):
	'''
    The boost was obtained by subscribing to Telegram
    Premium or by gifting a Telegram Premium subscription
    to another user.

    Reference: https://core.telegram.org/bots/api#chatboostsourcepremium
	'''

	source: Literal['premium'] = 'premium'
	user: User 

class ChatBoostSourceGiftCode(ChatBoostSource, frozen=True):
	'''
    The boost was obtained by the creation of
    Telegram Premium gift codes to boost a chat.
    Each such code boosts the chat 4 times
    for the duration of the corresponding Telegram Premium
    subscription.

    Reference: https://core.telegram.org/bots/api#chatboostsourcegiftcode
	'''

	source: Literal['gift_code'] = 'gift_code'
	user: User 

class ChatBoostSourceGiveaway(ChatBoostSource, frozen=True):
	'''
    The boost was obtained by the creation of
    a Telegram Premium or a Telegram Star giveaway.
    This boosts the chat 4 times for the
    duration of the corresponding Telegram Premium subscription for
    Telegram Premium giveaways and prize_star_count / 500 times
    for one year for Telegram Star giveaways.

    Reference: https://core.telegram.org/bots/api#chatboostsourcegiveaway
	'''

	source: Literal['giveaway'] = 'giveaway'
	giveaway_message_id: int
	user: Optional[User] = Field(default=None)
	prize_star_count: Optional[int] = Field(default=None)
	is_unclaimed: Optional[bool] = Field(default=None) 

_ChatBoostSource = Union[
	ChatBoostSourcePremium,
	ChatBoostSourceGiftCode,
	ChatBoostSourceGiveaway,
]
ChatBoostSourceAdapter = TypeAdapter[_ChatBoostSource](_ChatBoostSource) 

class InputMedia(BaseModel, frozen=True):
	type: Literal['animation', 'document', 'audio', 'photo', 'video']
	media: str
	caption: Optional[str]
	parse_mode: Optional[str]
	caption_entities: Optional[List[MessageEntity]]

class InputMediaAnimation(InputMedia, frozen=True):
	'''
    Represents an animation file (GIF or H.264/MPEG-4 AVC
    video without sound) to be sent.

    Reference: https://core.telegram.org/bots/api#inputmediaanimation
	'''

	type: Literal['animation'] = 'animation'
	media: str
	thumbnail: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	width: Optional[int] = Field(default=None)
	height: Optional[int] = Field(default=None)
	duration: Optional[int] = Field(default=None)
	has_spoiler: Optional[bool] = Field(default=None) 

class InputMediaDocument(InputMedia, frozen=True):
	'''
    Represents a general file to be sent.

    Reference: https://core.telegram.org/bots/api#inputmediadocument
	'''

	type: Literal['document'] = 'document'
	media: str
	thumbnail: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	disable_content_type_detection: Optional[bool] = Field(default=None) 

class InputMediaAudio(InputMedia, frozen=True):
	'''
    Represents an audio file to be treated as
    music to be sent.

    Reference: https://core.telegram.org/bots/api#inputmediaaudio
	'''

	type: Literal['audio'] = 'audio'
	media: str
	thumbnail: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	duration: Optional[int] = Field(default=None)
	performer: Optional[str] = Field(default=None)
	title: Optional[str] = Field(default=None) 

class InputMediaPhoto(InputMedia, frozen=True):
	'''
    Represents a photo to be sent.

    Reference: https://core.telegram.org/bots/api#inputmediaphoto
	'''

	type: Literal['photo'] = 'photo'
	media: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	has_spoiler: Optional[bool] = Field(default=None) 

class InputMediaVideo(InputMedia, frozen=True):
	'''
    Represents a video to be sent.

    Reference: https://core.telegram.org/bots/api#inputmediavideo
	'''

	type: Literal['video'] = 'video'
	media: str
	thumbnail: Optional[str] = Field(default=None)
	cover: Optional[str] = Field(default=None)
	start_timestamp: Optional[int] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	width: Optional[int] = Field(default=None)
	height: Optional[int] = Field(default=None)
	duration: Optional[int] = Field(default=None)
	supports_streaming: Optional[bool] = Field(default=None)
	has_spoiler: Optional[bool] = Field(default=None) 

_InputMedia = Union[
	InputMediaAnimation,
	InputMediaDocument,
	InputMediaAudio,
	InputMediaPhoto,
	InputMediaVideo,
]
InputMediaAdapter = TypeAdapter[_InputMedia](_InputMedia) 

class InputPaidMedia(BaseModel, frozen=True):
	type: Literal['photo', 'video']
	media: str

class InputPaidMediaPhoto(InputPaidMedia, frozen=True):
	'''
    The paid media to send is a photo.

    Reference: https://core.telegram.org/bots/api#inputpaidmediaphoto
	'''

	type: Literal['photo'] = 'photo'
	media: str 

class InputPaidMediaVideo(InputPaidMedia, frozen=True):
	'''
    The paid media to send is a video.

    Reference: https://core.telegram.org/bots/api#inputpaidmediavideo
	'''

	type: Literal['video'] = 'video'
	media: str
	thumbnail: Optional[str] = Field(default=None)
	cover: Optional[str] = Field(default=None)
	start_timestamp: Optional[int] = Field(default=None)
	width: Optional[int] = Field(default=None)
	height: Optional[int] = Field(default=None)
	duration: Optional[int] = Field(default=None)
	supports_streaming: Optional[bool] = Field(default=None) 

_InputPaidMedia = Union[
	InputPaidMediaPhoto,
	InputPaidMediaVideo,
]
InputPaidMediaAdapter = TypeAdapter[_InputPaidMedia](_InputPaidMedia) 

class InputProfilePhoto(BaseModel, frozen=True):
	type: Literal['static', 'animated']

class InputProfilePhotoStatic(InputProfilePhoto, frozen=True):
	'''
    A static profile photo in the .JPG format.

    Reference: https://core.telegram.org/bots/api#inputprofilephotostatic
	'''

	type: Literal['static'] = 'static'
	photo: str 

class InputProfilePhotoAnimated(InputProfilePhoto, frozen=True):
	'''
    An animated profile photo in the MPEG4 format.

    Reference: https://core.telegram.org/bots/api#inputprofilephotoanimated
	'''

	type: Literal['animated'] = 'animated'
	animation: str
	main_frame_timestamp: Optional[float] = Field(default=None) 

_InputProfilePhoto = Union[
	InputProfilePhotoStatic,
	InputProfilePhotoAnimated,
]
InputProfilePhotoAdapter = TypeAdapter[_InputProfilePhoto](_InputProfilePhoto) 

class InputStoryContent(BaseModel, frozen=True):
	type: Literal['photo', 'video']

class InputStoryContentPhoto(InputStoryContent, frozen=True):
	'''
    Describes a photo to post as a story.

    Reference: https://core.telegram.org/bots/api#inputstorycontentphoto
	'''

	type: Literal['photo'] = 'photo'
	photo: str 

class InputStoryContentVideo(InputStoryContent, frozen=True):
	'''
    Describes a video to post as a story.

    Reference: https://core.telegram.org/bots/api#inputstorycontentvideo
	'''

	type: Literal['video'] = 'video'
	video: str
	duration: Optional[float] = Field(default=None)
	cover_frame_timestamp: Optional[float] = Field(default=None)
	is_animation: Optional[bool] = Field(default=None) 

_InputStoryContent = Union[
	InputStoryContentPhoto,
	InputStoryContentVideo,
]
InputStoryContentAdapter = TypeAdapter[_InputStoryContent](_InputStoryContent) 

class InlineQueryResult(BaseModel, frozen=True):
	type: Literal['audio', 'document', 'gif', 'mpeg4_gif', 'photo', 'sticker', 'video', 'voice', 'article', 'contact', 'game', 'location', 'venue']
	id: str
	reply_markup: Optional[InlineKeyboardMarkup]

class InlineQueryResultCachedAudio(InlineQueryResult, frozen=True):
	'''
    Represents a link to an MP3 audio file
    stored on the Telegram servers. By default, this
    audio file will be sent by the user.
    Alternatively, you can use input_message_content to send a
    message with the specified content instead of the
    audio.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedaudio
	'''

	type: Literal['audio'] = 'audio'
	id: str
	audio_file_id: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedDocument(InlineQueryResult, frozen=True):
	'''
    Represents a link to a file stored on
    the Telegram servers. By default, this file will
    be sent by the user with an optional
    caption. Alternatively, you can use input_message_content to send
    a message with the specified content instead of
    the file.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcacheddocument
	'''

	type: Literal['document'] = 'document'
	id: str
	title: str
	document_file_id: str
	description: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedGif(InlineQueryResult, frozen=True):
	'''
    Represents a link to an animated GIF file
    stored on the Telegram servers. By default, this
    animated GIF file will be sent by the
    user with an optional caption. Alternatively, you can
    use input_message_content to send a message with specified
    content instead of the animation.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedgif
	'''

	type: Literal['gif'] = 'gif'
	id: str
	gif_file_id: str
	title: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedMpeg4Gif(InlineQueryResult, frozen=True):
	'''
    Represents a link to a video animation (H.264/MPEG-4
    AVC video without sound) stored on the Telegram
    servers. By default, this animated MPEG-4 file will
    be sent by the user with an optional
    caption. Alternatively, you can use input_message_content to send
    a message with the specified content instead of
    the animation.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedmpeg4gif
	'''

	type: Literal['mpeg4_gif'] = 'mpeg4_gif'
	id: str
	mpeg4_file_id: str
	title: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedPhoto(InlineQueryResult, frozen=True):
	'''
    Represents a link to a photo stored on
    the Telegram servers. By default, this photo will
    be sent by the user with an optional
    caption. Alternatively, you can use input_message_content to send
    a message with the specified content instead of
    the photo.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedphoto
	'''

	type: Literal['photo'] = 'photo'
	id: str
	photo_file_id: str
	title: Optional[str] = Field(default=None)
	description: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedSticker(InlineQueryResult, frozen=True):
	'''
    Represents a link to a sticker stored on
    the Telegram servers. By default, this sticker will
    be sent by the user. Alternatively, you can
    use input_message_content to send a message with the
    specified content instead of the sticker.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedsticker
	'''

	type: Literal['sticker'] = 'sticker'
	id: str
	sticker_file_id: str
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedVideo(InlineQueryResult, frozen=True):
	'''
    Represents a link to a video file stored
    on the Telegram servers. By default, this video
    file will be sent by the user with
    an optional caption. Alternatively, you can use input_message_content
    to send a message with the specified content
    instead of the video.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedvideo
	'''

	type: Literal['video'] = 'video'
	id: str
	video_file_id: str
	title: str
	description: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultCachedVoice(InlineQueryResult, frozen=True):
	'''
    Represents a link to a voice message stored
    on the Telegram servers. By default, this voice
    message will be sent by the user. Alternatively,
    you can use input_message_content to send a message
    with the specified content instead of the voice
    message.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcachedvoice
	'''

	type: Literal['voice'] = 'voice'
	id: str
	voice_file_id: str
	title: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultArticle(InlineQueryResult, frozen=True):
	'''
    Represents a link to an article or web
    page.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultarticle
	'''

	type: Literal['article'] = 'article'
	id: str
	title: str
	input_message_content: InputMessageContent
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	url: Optional[str] = Field(default=None)
	description: Optional[str] = Field(default=None)
	thumbnail_url: Optional[str] = Field(default=None)
	thumbnail_width: Optional[int] = Field(default=None)
	thumbnail_height: Optional[int] = Field(default=None) 

class InlineQueryResultAudio(InlineQueryResult, frozen=True):
	'''
    Represents a link to an MP3 audio file.
    By default, this audio file will be sent
    by the user. Alternatively, you can use input_message_content
    to send a message with the specified content
    instead of the audio.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultaudio
	'''

	type: Literal['audio'] = 'audio'
	id: str
	audio_url: str
	title: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	performer: Optional[str] = Field(default=None)
	audio_duration: Optional[int] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultContact(InlineQueryResult, frozen=True):
	'''
    Represents a contact with a phone number. By
    default, this contact will be sent by the
    user. Alternatively, you can use input_message_content to send
    a message with the specified content instead of
    the contact.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultcontact
	'''

	type: Literal['contact'] = 'contact'
	id: str
	phone_number: str
	first_name: str
	last_name: Optional[str] = Field(default=None)
	vcard: Optional[str] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None)
	thumbnail_url: Optional[str] = Field(default=None)
	thumbnail_width: Optional[int] = Field(default=None)
	thumbnail_height: Optional[int] = Field(default=None) 

class InlineQueryResultGame(InlineQueryResult, frozen=True):
	'''
    Represents a Game.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultgame
	'''

	type: Literal['game'] = 'game'
	id: str
	game_short_name: str
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None) 

class InlineQueryResultDocument(InlineQueryResult, frozen=True):
	'''
    Represents a link to a file. By default,
    this file will be sent by the user
    with an optional caption. Alternatively, you can use
    input_message_content to send a message with the specified
    content instead of the file. Currently, only .PDF
    and .ZIP files can be sent using this
    method.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultdocument
	'''

	type: Literal['document'] = 'document'
	id: str
	title: str
	document_url: str
	mime_type: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	description: Optional[str] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None)
	thumbnail_url: Optional[str] = Field(default=None)
	thumbnail_width: Optional[int] = Field(default=None)
	thumbnail_height: Optional[int] = Field(default=None) 

class InlineQueryResultGif(InlineQueryResult, frozen=True):
	'''
    Represents a link to an animated GIF file.
    By default, this animated GIF file will be
    sent by the user with optional caption. Alternatively,
    you can use input_message_content to send a message
    with the specified content instead of the animation.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultgif
	'''

	type: Literal['gif'] = 'gif'
	id: str
	gif_url: str
	thumbnail_url: str
	gif_width: Optional[int] = Field(default=None)
	gif_height: Optional[int] = Field(default=None)
	gif_duration: Optional[int] = Field(default=None)
	thumbnail_mime_type: Optional[str] = Field(default=None)
	title: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultLocation(InlineQueryResult, frozen=True):
	'''
    Represents a location on a map. By default,
    the location will be sent by the user.
    Alternatively, you can use input_message_content to send a
    message with the specified content instead of the
    location.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultlocation
	'''

	type: Literal['location'] = 'location'
	id: str
	latitude: float
	longitude: float
	title: str
	horizontal_accuracy: Optional[float] = Field(default=None)
	live_period: Optional[int] = Field(default=None)
	heading: Optional[int] = Field(default=None)
	proximity_alert_radius: Optional[int] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None)
	thumbnail_url: Optional[str] = Field(default=None)
	thumbnail_width: Optional[int] = Field(default=None)
	thumbnail_height: Optional[int] = Field(default=None) 

class InlineQueryResultMpeg4Gif(InlineQueryResult, frozen=True):
	'''
    Represents a link to a video animation (H.264/MPEG-4
    AVC video without sound). By default, this animated
    MPEG-4 file will be sent by the user
    with optional caption. Alternatively, you can use input_message_content
    to send a message with the specified content
    instead of the animation.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultmpeg4gif
	'''

	type: Literal['mpeg4_gif'] = 'mpeg4_gif'
	id: str
	mpeg4_url: str
	thumbnail_url: str
	mpeg4_width: Optional[int] = Field(default=None)
	mpeg4_height: Optional[int] = Field(default=None)
	mpeg4_duration: Optional[int] = Field(default=None)
	thumbnail_mime_type: Optional[str] = Field(default=None)
	title: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultPhoto(InlineQueryResult, frozen=True):
	'''
    Represents a link to a photo. By default,
    this photo will be sent by the user
    with optional caption. Alternatively, you can use input_message_content
    to send a message with the specified content
    instead of the photo.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultphoto
	'''

	type: Literal['photo'] = 'photo'
	id: str
	photo_url: str
	thumbnail_url: str
	photo_width: Optional[int] = Field(default=None)
	photo_height: Optional[int] = Field(default=None)
	title: Optional[str] = Field(default=None)
	description: Optional[str] = Field(default=None)
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultVenue(InlineQueryResult, frozen=True):
	'''
    Represents a venue. By default, the venue will
    be sent by the user. Alternatively, you can
    use input_message_content to send a message with the
    specified content instead of the venue.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultvenue
	'''

	type: Literal['venue'] = 'venue'
	id: str
	latitude: float
	longitude: float
	title: str
	address: str
	foursquare_id: Optional[str] = Field(default=None)
	foursquare_type: Optional[str] = Field(default=None)
	google_place_id: Optional[str] = Field(default=None)
	google_place_type: Optional[str] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None)
	thumbnail_url: Optional[str] = Field(default=None)
	thumbnail_width: Optional[int] = Field(default=None)
	thumbnail_height: Optional[int] = Field(default=None) 

class InlineQueryResultVideo(InlineQueryResult, frozen=True):
	'''
    Represents a link to a page containing an
    embedded video player or a video file. By
    default, this video file will be sent by
    the user with an optional caption. Alternatively, you
    can use input_message_content to send a message with
    the specified content instead of the video.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultvideo
	'''

	type: Literal['video'] = 'video'
	id: str
	video_url: str
	mime_type: str
	thumbnail_url: str
	title: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	show_caption_above_media: Optional[bool] = Field(default=None)
	video_width: Optional[int] = Field(default=None)
	video_height: Optional[int] = Field(default=None)
	video_duration: Optional[int] = Field(default=None)
	description: Optional[str] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

class InlineQueryResultVoice(InlineQueryResult, frozen=True):
	'''
    Represents a link to a voice recording in
    an .OGG container encoded with OPUS. By default,
    this voice recording will be sent by the
    user. Alternatively, you can use input_message_content to send
    a message with the specified content instead of
    the the voice message.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultvoice
	'''

	type: Literal['voice'] = 'voice'
	id: str
	voice_url: str
	title: str
	caption: Optional[str] = Field(default=None)
	parse_mode: Optional[str] = Field(default='HTML')
	caption_entities: Optional[List[MessageEntity]] = Field(default=None)
	voice_duration: Optional[int] = Field(default=None)
	reply_markup: Optional[InlineKeyboardMarkup] = Field(default=None)
	input_message_content: Optional[InputMessageContent] = Field(default=None) 

_InlineQueryResult = Union[
	InlineQueryResultCachedAudio,
	InlineQueryResultCachedDocument,
	InlineQueryResultCachedGif,
	InlineQueryResultCachedMpeg4Gif,
	InlineQueryResultCachedPhoto,
	InlineQueryResultCachedSticker,
	InlineQueryResultCachedVideo,
	InlineQueryResultCachedVoice,
	InlineQueryResultArticle,
	InlineQueryResultAudio,
	InlineQueryResultContact,
	InlineQueryResultGame,
	InlineQueryResultDocument,
	InlineQueryResultGif,
	InlineQueryResultLocation,
	InlineQueryResultMpeg4Gif,
	InlineQueryResultPhoto,
	InlineQueryResultVenue,
	InlineQueryResultVideo,
	InlineQueryResultVoice,
]
InlineQueryResultAdapter = TypeAdapter[_InlineQueryResult](_InlineQueryResult) 

class InputMessageContent(BaseModel, frozen=True):
	pass

class InputTextMessageContent(InputMessageContent, frozen=True):
	'''
    Represents the content of a text message to
    be sent as the result of an inline
    query.

    Reference: https://core.telegram.org/bots/api#inputtextmessagecontent
	'''

	message_text: str
	parse_mode: Optional[str] = Field(default='HTML')
	entities: Optional[List[MessageEntity]] = Field(default=None)
	link_preview_options: Optional[LinkPreviewOptions] = Field(default=None) 

class InputLocationMessageContent(InputMessageContent, frozen=True):
	'''
    Represents the content of a location message to
    be sent as the result of an inline
    query.

    Reference: https://core.telegram.org/bots/api#inputlocationmessagecontent
	'''

	latitude: float
	longitude: float
	horizontal_accuracy: Optional[float] = Field(default=None)
	live_period: Optional[int] = Field(default=None)
	heading: Optional[int] = Field(default=None)
	proximity_alert_radius: Optional[int] = Field(default=None) 

class InputVenueMessageContent(InputMessageContent, frozen=True):
	'''
    Represents the content of a venue message to
    be sent as the result of an inline
    query.

    Reference: https://core.telegram.org/bots/api#inputvenuemessagecontent
	'''

	latitude: float
	longitude: float
	title: str
	address: str
	foursquare_id: Optional[str] = Field(default=None)
	foursquare_type: Optional[str] = Field(default=None)
	google_place_id: Optional[str] = Field(default=None)
	google_place_type: Optional[str] = Field(default=None) 

class InputContactMessageContent(InputMessageContent, frozen=True):
	'''
    Represents the content of a contact message to
    be sent as the result of an inline
    query.

    Reference: https://core.telegram.org/bots/api#inputcontactmessagecontent
	'''

	phone_number: str
	first_name: str
	last_name: Optional[str] = Field(default=None)
	vcard: Optional[str] = Field(default=None) 

class InputInvoiceMessageContent(InputMessageContent, frozen=True):
	'''
    Represents the content of an invoice message to
    be sent as the result of an inline
    query.

    Reference: https://core.telegram.org/bots/api#inputinvoicemessagecontent
	'''

	title: str
	description: str
	payload: str
	currency: str
	prices: List[LabeledPrice]
	provider_token: Optional[str] = Field(default=None)
	max_tip_amount: Optional[int] = Field(default=None)
	suggested_tip_amounts: Optional[List[int]] = Field(default=None)
	provider_data: Optional[str] = Field(default=None)
	photo_url: Optional[str] = Field(default=None)
	photo_size: Optional[int] = Field(default=None)
	photo_width: Optional[int] = Field(default=None)
	photo_height: Optional[int] = Field(default=None)
	need_name: Optional[bool] = Field(default=None)
	need_phone_number: Optional[bool] = Field(default=None)
	need_email: Optional[bool] = Field(default=None)
	need_shipping_address: Optional[bool] = Field(default=None)
	send_phone_number_to_provider: Optional[bool] = Field(default=None)
	send_email_to_provider: Optional[bool] = Field(default=None)
	is_flexible: Optional[bool] = Field(default=None) 

_InputMessageContent = Union[
	InputTextMessageContent,
	InputLocationMessageContent,
	InputVenueMessageContent,
	InputContactMessageContent,
	InputInvoiceMessageContent,
]
InputMessageContentAdapter = TypeAdapter[_InputMessageContent](_InputMessageContent) 

class RevenueWithdrawalState(BaseModel, frozen=True):
	type: Literal['pending', 'succeeded', 'failed']

class RevenueWithdrawalStatePending(RevenueWithdrawalState, frozen=True):
	'''
    The withdrawal is in progress.

    Reference: https://core.telegram.org/bots/api#revenuewithdrawalstatepending
	'''

	type: Literal['pending'] = 'pending' 

class RevenueWithdrawalStateSucceeded(RevenueWithdrawalState, frozen=True):
	'''
    The withdrawal succeeded.

    Reference: https://core.telegram.org/bots/api#revenuewithdrawalstatesucceeded
	'''

	type: Literal['succeeded'] = 'succeeded'
	date: int
	url: str 

class RevenueWithdrawalStateFailed(RevenueWithdrawalState, frozen=True):
	'''
    The withdrawal failed and the transaction was refunded.

    Reference: https://core.telegram.org/bots/api#revenuewithdrawalstatefailed
	'''

	type: Literal['failed'] = 'failed' 

_RevenueWithdrawalState = Union[
	RevenueWithdrawalStatePending,
	RevenueWithdrawalStateSucceeded,
	RevenueWithdrawalStateFailed,
]
RevenueWithdrawalStateAdapter = TypeAdapter[_RevenueWithdrawalState](_RevenueWithdrawalState) 

class TransactionPartner(BaseModel, frozen=True):
	type: Literal['user', 'chat', 'affiliate_program', 'fragment', 'telegram_ads', 'telegram_api', 'other']

class TransactionPartnerUser(TransactionPartner, frozen=True):
	'''
    Describes a transaction with a user.

    Reference: https://core.telegram.org/bots/api#transactionpartneruser
	'''

	type: Literal['user'] = 'user'
	transaction_type: str
	user: User
	affiliate: Optional[AffiliateInfo] = Field(default=None)
	invoice_payload: Optional[str] = Field(default=None)
	subscription_period: Optional[int] = Field(default=None)
	paid_media: Optional[List[PaidMedia]] = Field(default=None)
	paid_media_payload: Optional[str] = Field(default=None)
	gift: Optional[Gift] = Field(default=None)
	premium_subscription_duration: Optional[int] = Field(default=None) 

class TransactionPartnerChat(TransactionPartner, frozen=True):
	'''
    Describes a transaction with a chat.

    Reference: https://core.telegram.org/bots/api#transactionpartnerchat
	'''

	type: Literal['chat'] = 'chat'
	chat: Chat
	gift: Optional[Gift] = Field(default=None) 

class TransactionPartnerAffiliateProgram(TransactionPartner, frozen=True):
	'''
    Describes the affiliate program that issued the affiliate
    commission received via this transaction.

    Reference: https://core.telegram.org/bots/api#transactionpartneraffiliateprogram
	'''

	type: Literal['affiliate_program'] = 'affiliate_program'
	commission_per_mille: int
	sponsor_user: Optional[User] = Field(default=None) 

class TransactionPartnerFragment(TransactionPartner, frozen=True):
	'''
    Describes a withdrawal transaction with Fragment.

    Reference: https://core.telegram.org/bots/api#transactionpartnerfragment
	'''

	type: Literal['fragment'] = 'fragment'
	withdrawal_state: Optional[RevenueWithdrawalState] = Field(default=None) 

class TransactionPartnerTelegramAds(TransactionPartner, frozen=True):
	'''
    Describes a withdrawal transaction to the Telegram Ads
    platform.

    Reference: https://core.telegram.org/bots/api#transactionpartnertelegramads
	'''

	type: Literal['telegram_ads'] = 'telegram_ads' 

class TransactionPartnerTelegramApi(TransactionPartner, frozen=True):
	'''
    Describes a transaction with payment for paid broadcasting.

    Reference: https://core.telegram.org/bots/api#transactionpartnertelegramapi
	'''

	type: Literal['telegram_api'] = 'telegram_api'
	request_count: int 

class TransactionPartnerOther(TransactionPartner, frozen=True):
	'''
    Describes a transaction with an unknown source or
    recipient.

    Reference: https://core.telegram.org/bots/api#transactionpartnerother
	'''

	type: Literal['other'] = 'other' 

_TransactionPartner = Union[
	TransactionPartnerUser,
	TransactionPartnerChat,
	TransactionPartnerAffiliateProgram,
	TransactionPartnerFragment,
	TransactionPartnerTelegramAds,
	TransactionPartnerTelegramApi,
	TransactionPartnerOther,
]
TransactionPartnerAdapter = TypeAdapter[_TransactionPartner](_TransactionPartner) 

class PassportElementError(BaseModel, frozen=True):
	source: Literal['data', 'front_side', 'reverse_side', 'selfie', 'file', 'files', 'translation_file', 'translation_files', 'unspecified']
	type: str
	message: str

class PassportElementErrorDataField(PassportElementError, frozen=True):
	'''
    Represents an issue in one of the data
    fields that was provided by the user. The
    error is considered resolved when the field's value
    changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrordatafield
	'''

	source: Literal['data'] = 'data'
	type: str
	field_name: str
	data_hash: str
	message: str 

class PassportElementErrorFrontSide(PassportElementError, frozen=True):
	'''
    Represents an issue with the front side of
    a document. The error is considered resolved when
    the file with the front side of the
    document changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrorfrontside
	'''

	source: Literal['front_side'] = 'front_side'
	type: str
	file_hash: str
	message: str 

class PassportElementErrorReverseSide(PassportElementError, frozen=True):
	'''
    Represents an issue with the reverse side of
    a document. The error is considered resolved when
    the file with reverse side of the document
    changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrorreverseside
	'''

	source: Literal['reverse_side'] = 'reverse_side'
	type: str
	file_hash: str
	message: str 

class PassportElementErrorSelfie(PassportElementError, frozen=True):
	'''
    Represents an issue with the selfie with a
    document. The error is considered resolved when the
    file with the selfie changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrorselfie
	'''

	source: Literal['selfie'] = 'selfie'
	type: str
	file_hash: str
	message: str 

class PassportElementErrorFile(PassportElementError, frozen=True):
	'''
    Represents an issue with a document scan. The
    error is considered resolved when the file with
    the document scan changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrorfile
	'''

	source: Literal['file'] = 'file'
	type: str
	file_hash: str
	message: str 

class PassportElementErrorFiles(PassportElementError, frozen=True):
	'''
    Represents an issue with a list of scans.
    The error is considered resolved when the list
    of files containing the scans changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrorfiles
	'''

	source: Literal['files'] = 'files'
	type: str
	file_hashes: List[str]
	message: str 

class PassportElementErrorTranslationFile(PassportElementError, frozen=True):
	'''
    Represents an issue with one of the files
    that constitute the translation of a document. The
    error is considered resolved when the file changes.

    Reference: https://core.telegram.org/bots/api#passportelementerrortranslationfile
	'''

	source: Literal['translation_file'] = 'translation_file'
	type: str
	file_hash: str
	message: str 

class PassportElementErrorTranslationFiles(PassportElementError, frozen=True):
	'''
    Represents an issue with the translated version of
    a document. The error is considered resolved when
    a file with the document translation change.

    Reference: https://core.telegram.org/bots/api#passportelementerrortranslationfiles
	'''

	source: Literal['translation_files'] = 'translation_files'
	type: str
	file_hashes: List[str]
	message: str 

class PassportElementErrorUnspecified(PassportElementError, frozen=True):
	'''
    Represents an issue in an unspecified place. The
    error is considered resolved when new data is
    added.

    Reference: https://core.telegram.org/bots/api#passportelementerrorunspecified
	'''

	source: Literal['unspecified'] = 'unspecified'
	type: str
	element_hash: str
	message: str 

_PassportElementError = Union[
	PassportElementErrorDataField,
	PassportElementErrorFrontSide,
	PassportElementErrorReverseSide,
	PassportElementErrorSelfie,
	PassportElementErrorFile,
	PassportElementErrorFiles,
	PassportElementErrorTranslationFile,
	PassportElementErrorTranslationFiles,
	PassportElementErrorUnspecified,
]
PassportElementErrorAdapter = TypeAdapter[_PassportElementError](_PassportElementError) 

class Update(BaseModel, frozen=True):
	'''
    This object represents an incoming update.At most one
    of the optional parameters can be present in
    any given update.

    Reference: https://core.telegram.org/bots/api#update
	'''

	update_id: int
	message: Optional[Message] = Field(default=None)
	edited_message: Optional[Message] = Field(default=None)
	channel_post: Optional[Message] = Field(default=None)
	edited_channel_post: Optional[Message] = Field(default=None)
	business_connection: Optional[BusinessConnection] = Field(default=None)
	business_message: Optional[Message] = Field(default=None)
	edited_business_message: Optional[Message] = Field(default=None)
	deleted_business_messages: Optional[BusinessMessagesDeleted] = Field(default=None)
	message_reaction: Optional[MessageReactionUpdated] = Field(default=None)
	message_reaction_count: Optional[MessageReactionCountUpdated] = Field(default=None)
	inline_query: Optional[InlineQuery] = Field(default=None)
	chosen_inline_result: Optional[ChosenInlineResult] = Field(default=None)
	callback_query: Optional[CallbackQuery] = Field(default=None)
	shipping_query: Optional[ShippingQuery] = Field(default=None)
	pre_checkout_query: Optional[PreCheckoutQuery] = Field(default=None)
	purchased_paid_media: Optional[PaidMediaPurchased] = Field(default=None)
	poll: Optional[Poll] = Field(default=None)
	poll_answer: Optional[PollAnswer] = Field(default=None)
	my_chat_member: Optional[ChatMemberUpdated] = Field(default=None)
	chat_member: Optional[ChatMemberUpdated] = Field(default=None)
	chat_join_request: Optional[ChatJoinRequest] = Field(default=None)
	chat_boost: Optional[ChatBoostUpdated] = Field(default=None)
	removed_chat_boost: Optional[ChatBoostRemoved] = Field(default=None)
	
	@staticmethod
	def de_json(
		json_data: dict[str, Any]
	) -> Update:
		return Update.model_validate(json_data)
	 

class WebhookInfo(BaseModel, frozen=True):
	'''
    Describes the current status of a webhook.

    Reference: https://core.telegram.org/bots/api#webhookinfo
	'''

	url: str
	has_custom_certificate: bool
	pending_update_count: int
	ip_address: Optional[str] = Field(default=None)
	last_error_date: Optional[int] = Field(default=None)
	last_error_message: Optional[str] = Field(default=None)
	last_synchronization_error_date: Optional[int] = Field(default=None)
	max_connections: Optional[int] = Field(default=None)
	allowed_updates: Optional[List[str]] = Field(default=None) 

class User(BaseModel, frozen=True):
	'''
    This object represents a Telegram user or bot.

    Reference: https://core.telegram.org/bots/api#user
	'''

	id: int
	is_bot: bool
	first_name: str
	last_name: Optional[str] = Field(default=None)
	username: Optional[str] = Field(default=None)
	language_code: Optional[str] = Field(default=None)
	is_premium: Optional[bool] = Field(default=None)
	added_to_attachment_menu: Optional[bool] = Field(default=None)
	can_join_groups: Optional[bool] = Field(default=None)
	can_read_all_group_messages: Optional[bool] = Field(default=None)
	supports_inline_queries: Optional[bool] = Field(default=None)
	can_connect_to_business: Optional[bool] = Field(default=None)
	has_main_web_app: Optional[bool] = Field(default=None) 

class Chat(BaseModel, frozen=True):
	'''
    This object represents a chat.

    Reference: https://core.telegram.org/bots/api#chat
	'''

	id: int
	type: str
	title: Optional[str] = Field(default=None)
	username: Optional[str] = Field(default=None)
	first_name: Optional[str] = Field(default=None)
	last_name: Optional[str] = Field(default=None)
	is_forum: Optional[bool] = Field(default=None)
	is_direct_messages: Optional[bool] = Field(default=None) 

class ChatFullInfo(BaseModel, frozen=True):
	'''
    This object contains full information about a chat.

    Reference: https://core.telegram.org/bots/api#chatfullinfo
	'''

	id: int
	type: str
	accent_color_id: int
	max_reaction_count: int
	accepted_gift_types: AcceptedGiftTypes
	title: Optional[str] = Field(default=None)
	username: Optional[str] = Field(default=None)
	first_name: Optional[str] = Field(default=None)
	last_name: Optional[str] = Field(default=None)
	is_forum: Optional[bool] = Field(default=None)
	is_direct_messages: Optional[bool] = Field(default=None)
	photo: Optional[ChatPhoto] = Field(default=None)
	active_usernames: Optional[List[str]] = Field(default=None)
	birthdate: Optional[Birthdate] = Field(default=None)
	business_intro: Optional[BusinessIntro] = Field(default=None)
	business_location: Optional[BusinessLocation] = Field(default=None)
	business_opening_hours: Optional[BusinessOpeningHours] = Field(default=None)
	personal_chat: Optional[Chat] = Field(default=None)
	parent_chat: Optional[Chat] = Field(default=None)
	available_reactions: Optional[List[ReactionType]] = Field(default=None)
	background_custom_emoji_id: Optional[str] = Field(default=None)
	profile_accent_color_id: Optional[int] = Field(default=None)
	profile_background_custom_emoji_id: Optional[str] = Field(default=None)
	emoji_status_custom_emoji_id: Optional[str] = Field(default=None)
	emoji_status_expiration_date: Optional[int] = Field(default=None)
	bio: Optional[str] = Field(default=None)
	has_private_forwards: Optional[bool] = Field(default=None)
	has_restricted_voice_and_video_messages: Optional[bool] = Field(default=None)
	join_to_send_messages: Optional[bool] = Field(default=None)
	join_by_request: Optional[bool] = Field(default=None)
	description: Optional[str] = Field(default=None)
	invite_link: Optional[str] = Field(default=None)
	pinned_message: Optional[Message] = Field(default=None)
	permissions: Optional[ChatPermissions] = Field(default=None)
	can_send_paid_media: Optional[bool] = Field(default=None)
	slow_mode_delay: Optional[int] = Field(default=None)
	unrestrict_boost_count: Optional[int] = Field(default=None)
	message_auto_delete_time: Optional[int] = Field(default=None)
	has_aggressive_anti_spam_enabled: Optional[bool] = Field(default=None)
	has_hidden_members: Optional[bool] = Field(default=None)
	has_protected_content: Optional[bool] = Field(default=None)
	has_visible_history: Optional[bool] = Field(default=None)
	sticker_set_name: Optional[str] = Field(default=None)
	can_set_sticker_set: Optional[bool] = Field(default=None)
	custom_emoji_sticker_set_name: Optional[str] = Field(default=None)
	linked_chat_id: Optional[int] = Field(default=None)
	location: Optional[ChatLocation] = Field(default=None) 

class MessageId(BaseModel, frozen=True):
	'''
    This object represents a unique message identifier.

    Reference: https://core.telegram.org/bots/api#messageid
	'''

	message_id: int 

class MessageEntity(BaseModel, frozen=True):
	'''
    This object represents one special entity in a
    text message. For example, hashtags, usernames, URLs, etc.

    Reference: https://core.telegram.org/bots/api#messageentity
	'''

	type: str
	offset: int
	length: int
	url: Optional[str] = Field(default=None)
	user: Optional[User] = Field(default=None)
	language: Optional[str] = Field(default=None)
	custom_emoji_id: Optional[str] = Field(default=None)
	
	@staticmethod
	def from_dict(
		json_data: list[dict[str, Any]]
	) -> list[MessageEntity]:
		return [MessageEntity.model_validate(item) for item in json_data]
	 

class TextQuote(BaseModel, frozen=True):
	'''
    This object contains information about the quoted part
    of a message that is replied to by
    the given message.

    Reference: https://core.telegram.org/bots/api#textquote
	'''

	text: str
	position: int
	entities: Optional[List[MessageEntity]] = Field(default=None)
	is_manual: Optional[bool] = Field(default=None) 

class ExternalReplyInfo(BaseModel, frozen=True):
	'''
    This object contains information about a message that
    is being replied to, which may come from
    another chat or forum topic.

    Reference: https://core.telegram.org/bots/api#externalreplyinfo
	'''

	origin: MessageOrigin
	chat: Optional[Chat] = Field(default=None)
	message_id: Optional[int] = Field(default=None)
	link_preview_options: Optional[LinkPreviewOptions] = Field(default=None)
	animation: Optional[Animation] = Field(default=None)
	audio: Optional[Audio] = Field(default=None)
	document: Optional[Document] = Field(default=None)
	paid_media: Optional[PaidMediaInfo] = Field(default=None)
	photo: Optional[List[PhotoSize]] = Field(default=None)
	sticker: Optional[Sticker] = Field(default=None)
	story: Optional[Story] = Field(default=None)
	video: Optional[Video] = Field(default=None)
	video_note: Optional[VideoNote] = Field(default=None)
	voice: Optional[Voice] = Field(default=None)
	has_media_spoiler: Optional[bool] = Field(default=None)
	checklist: Optional[Checklist] = Field(default=None)
	contact: Optional[Contact] = Field(default=None)
	dice: Optional[Dice] = Field(default=None)
	game: Optional[Game] = Field(default=None)
	giveaway: Optional[Giveaway] = Field(default=None)
	giveaway_winners: Optional[GiveawayWinners] = Field(default=None)
	invoice: Optional[Invoice] = Field(default=None)
	location: Optional[Location] = Field(default=None)
	poll: Optional[Poll] = Field(default=None)
	venue: Optional[Venue] = Field(default=None) 

class ReplyParameters(BaseModel, frozen=True):
	'''
    Describes reply parameters for the message that is
    being sent.

    Reference: https://core.telegram.org/bots/api#replyparameters
	'''

	message_id: int
	chat_id: Optional[Union[int, str]] = Field(default=None)
	allow_sending_without_reply: Optional[bool] = Field(default=None)
	quote: Optional[str] = Field(default=None)
	quote_parse_mode: Optional[str] = Field(default=None)
	quote_entities: Optional[List[MessageEntity]] = Field(default=None)
	quote_position: Optional[int] = Field(default=None)
	checklist_task_id: Optional[int] = Field(default=None) 

class PhotoSize(BaseModel, frozen=True):
	'''
    This object represents one size of a photo
    or a file / sticker thumbnail.

    Reference: https://core.telegram.org/bots/api#photosize
	'''

	file_id: str
	file_unique_id: str
	width: int
	height: int
	file_size: Optional[int] = Field(default=None) 

class Animation(BaseModel, frozen=True):
	'''
    This object represents an animation file (GIF or
    H.264/MPEG-4 AVC video without sound).

    Reference: https://core.telegram.org/bots/api#animation
	'''

	file_id: str
	file_unique_id: str
	width: int
	height: int
	duration: int
	thumbnail: Optional[PhotoSize] = Field(default=None)
	file_name: Optional[str] = Field(default=None)
	mime_type: Optional[str] = Field(default=None)
	file_size: Optional[int] = Field(default=None) 

class Audio(BaseModel, frozen=True):
	'''
    This object represents an audio file to be
    treated as music by the Telegram clients.

    Reference: https://core.telegram.org/bots/api#audio
	'''

	file_id: str
	file_unique_id: str
	duration: int
	performer: Optional[str] = Field(default=None)
	title: Optional[str] = Field(default=None)
	file_name: Optional[str] = Field(default=None)
	mime_type: Optional[str] = Field(default=None)
	file_size: Optional[int] = Field(default=None)
	thumbnail: Optional[PhotoSize] = Field(default=None) 

class Document(BaseModel, frozen=True):
	'''
    This object represents a general file (as opposed
    to photos, voice messages and audio files).

    Reference: https://core.telegram.org/bots/api#document
	'''

	file_id: str
	file_unique_id: str
	thumbnail: Optional[PhotoSize] = Field(default=None)
	file_name: Optional[str] = Field(default=None)
	mime_type: Optional[str] = Field(default=None)
	file_size: Optional[int] = Field(default=None) 

class Story(BaseModel, frozen=True):
	'''
    This object represents a story.

    Reference: https://core.telegram.org/bots/api#story
	'''

	chat: Chat
	id: int 

class Video(BaseModel, frozen=True):
	'''
    This object represents a video file.

    Reference: https://core.telegram.org/bots/api#video
	'''

	file_id: str
	file_unique_id: str
	width: int
	height: int
	duration: int
	thumbnail: Optional[PhotoSize] = Field(default=None)
	cover: Optional[List[PhotoSize]] = Field(default=None)
	start_timestamp: Optional[int] = Field(default=None)
	file_name: Optional[str] = Field(default=None)
	mime_type: Optional[str] = Field(default=None)
	file_size: Optional[int] = Field(default=None) 

class VideoNote(BaseModel, frozen=True):
	'''
    This object represents a video message (available in
    Telegram apps as of v.4.0).

    Reference: https://core.telegram.org/bots/api#videonote
	'''

	file_id: str
	file_unique_id: str
	length: int
	duration: int
	thumbnail: Optional[PhotoSize] = Field(default=None)
	file_size: Optional[int] = Field(default=None) 

class Voice(BaseModel, frozen=True):
	'''
    This object represents a voice note.

    Reference: https://core.telegram.org/bots/api#voice
	'''

	file_id: str
	file_unique_id: str
	duration: int
	mime_type: Optional[str] = Field(default=None)
	file_size: Optional[int] = Field(default=None) 

class PaidMediaInfo(BaseModel, frozen=True):
	'''
    Describes the paid media added to a message.

    Reference: https://core.telegram.org/bots/api#paidmediainfo
	'''

	star_count: int
	paid_media: List[PaidMedia] 

class Contact(BaseModel, frozen=True):
	'''
    This object represents a phone contact.

    Reference: https://core.telegram.org/bots/api#contact
	'''

	phone_number: str
	first_name: str
	last_name: Optional[str] = Field(default=None)
	user_id: Optional[int] = Field(default=None)
	vcard: Optional[str] = Field(default=None) 

class Dice(BaseModel, frozen=True):
	'''
    This object represents an animated emoji that displays
    a random value.

    Reference: https://core.telegram.org/bots/api#dice
	'''

	emoji: str
	value: int 

class PollOption(BaseModel, frozen=True):
	'''
    This object contains information about one answer option
    in a poll.

    Reference: https://core.telegram.org/bots/api#polloption
	'''

	text: str
	voter_count: int
	text_entities: Optional[List[MessageEntity]] = Field(default=None) 

class InputPollOption(BaseModel, frozen=True):
	'''
    This object contains information about one answer option
    in a poll to be sent.

    Reference: https://core.telegram.org/bots/api#inputpolloption
	'''

	text: str
	text_parse_mode: Optional[str] = Field(default=None)
	text_entities: Optional[List[MessageEntity]] = Field(default=None) 

class PollAnswer(BaseModel, frozen=True):
	'''
    This object represents an answer of a user
    in a non-anonymous poll.

    Reference: https://core.telegram.org/bots/api#pollanswer
	'''

	poll_id: str
	option_ids: List[int]
	voter_chat: Optional[Chat] = Field(default=None)
	user: Optional[User] = Field(default=None) 

class Poll(BaseModel, frozen=True):
	'''
    This object contains information about a poll.

    Reference: https://core.telegram.org/bots/api#poll
	'''

	id: str
	question: str
	options: List[PollOption]
	total_voter_count: int
	is_closed: bool
	is_anonymous: bool
	type: str
	allows_multiple_answers: bool
	question_entities: Optional[List[MessageEntity]] = Field(default=None)
	correct_option_id: Optional[int] = Field(default=None)
	explanation: Optional[str] = Field(default=None)
	explanation_entities: Optional[List[MessageEntity]] = Field(default=None)
	open_period: Optional[int] = Field(default=None)
	close_date: Optional[int] = Field(default=None) 

class ChecklistTask(BaseModel, frozen=True):
	'''
    Describes a task in a checklist.

    Reference: https://core.telegram.org/bots/api#checklisttask
	'''

	id: int
	text: str
	text_entities: Optional[List[MessageEntity]] = Field(default=None)
	completed_by_user: Optional[User] = Field(default=None)
	completion_date: Optional[int] = Field(default=None) 

class Checklist(BaseModel, frozen=True):
	'''
    Describes a checklist.

    Reference: https://core.telegram.org/bots/api#checklist
	'''

	title: str
	tasks: List[ChecklistTask]
	title_entities: Optional[List[MessageEntity]] = Field(default=None)
	others_can_add_tasks: Optional[bool] = Field(default=None)
	others_can_mark_tasks_as_done: Optional[bool] = Field(default=None) 

class InputChecklistTask(BaseModel, frozen=True):
	'''
    Describes a task to add to a checklist.

    Reference: https://core.telegram.org/bots/api#inputchecklisttask
	'''

	id: int
	text: str
	parse_mode: Optional[str] = Field(default='HTML')
	text_entities: Optional[List[MessageEntity]] = Field(default=None) 

class InputChecklist(BaseModel, frozen=True):
	'''
    Describes a checklist to create.

    Reference: https://core.telegram.org/bots/api#inputchecklist
	'''

	title: str
	tasks: List[InputChecklistTask]
	parse_mode: Optional[str] = Field(default='HTML')
	title_entities: Optional[List[MessageEntity]] = Field(default=None)
	others_can_add_tasks: Optional[bool] = Field(default=None)
	others_can_mark_tasks_as_done: Optional[bool] = Field(default=None) 

class ChecklistTasksDone(BaseModel, frozen=True):
	'''
    Describes a service message about checklist tasks marked
    as done or not done.

    Reference: https://core.telegram.org/bots/api#checklisttasksdone
	'''

	checklist_message: Optional[Message] = Field(default=None)
	marked_as_done_task_ids: Optional[List[int]] = Field(default=None)
	marked_as_not_done_task_ids: Optional[List[int]] = Field(default=None) 

class ChecklistTasksAdded(BaseModel, frozen=True):
	'''
    Describes a service message about tasks added to
    a checklist.

    Reference: https://core.telegram.org/bots/api#checklisttasksadded
	'''

	tasks: List[ChecklistTask]
	checklist_message: Optional[Message] = Field(default=None) 

class Location(BaseModel, frozen=True):
	'''
    This object represents a point on the map.

    Reference: https://core.telegram.org/bots/api#location
	'''

	latitude: float
	longitude: float
	horizontal_accuracy: Optional[float] = Field(default=None)
	live_period: Optional[int] = Field(default=None)
	heading: Optional[int] = Field(default=None)
	proximity_alert_radius: Optional[int] = Field(default=None) 

class Venue(BaseModel, frozen=True):
	'''
    This object represents a venue.

    Reference: https://core.telegram.org/bots/api#venue
	'''

	location: Location
	title: str
	address: str
	foursquare_id: Optional[str] = Field(default=None)
	foursquare_type: Optional[str] = Field(default=None)
	google_place_id: Optional[str] = Field(default=None)
	google_place_type: Optional[str] = Field(default=None) 

class WebAppData(BaseModel, frozen=True):
	'''
    Describes data sent from a Web App to
    the bot.

    Reference: https://core.telegram.org/bots/api#webappdata
	'''

	data: str
	button_text: str 

class ProximityAlertTriggered(BaseModel, frozen=True):
	'''
    This object represents the content of a service
    message, sent whenever a user in the chat
    triggers a proximity alert set by another user.

    Reference: https://core.telegram.org/bots/api#proximityalerttriggered
	'''

	traveler: User
	watcher: User
	distance: int 

class MessageAutoDeleteTimerChanged(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    change in auto-delete timer settings.

    Reference: https://core.telegram.org/bots/api#messageautodeletetimerchanged
	'''

	message_auto_delete_time: int 

class ChatBoostAdded(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    user boosting a chat.

    Reference: https://core.telegram.org/bots/api#chatboostadded
	'''

	boost_count: int 

class ChatBackground(BaseModel, frozen=True):
	'''
    This object represents a chat background.

    Reference: https://core.telegram.org/bots/api#chatbackground
	'''

	type: BackgroundType 

class ForumTopicCreated(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    new forum topic created in the chat.

    Reference: https://core.telegram.org/bots/api#forumtopiccreated
	'''

	name: str
	icon_color: int
	icon_custom_emoji_id: Optional[str] = Field(default=None) 

class ForumTopicClosed(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    forum topic closed in the chat. Currently holds
    no information.

    Reference: https://core.telegram.org/bots/api#forumtopicclosed
	'''

	pass
 

class ForumTopicEdited(BaseModel, frozen=True):
	'''
    This object represents a service message about an
    edited forum topic.

    Reference: https://core.telegram.org/bots/api#forumtopicedited
	'''

	name: Optional[str] = Field(default=None)
	icon_custom_emoji_id: Optional[str] = Field(default=None) 

class ForumTopicReopened(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    forum topic reopened in the chat. Currently holds
    no information.

    Reference: https://core.telegram.org/bots/api#forumtopicreopened
	'''

	pass
 

class GeneralForumTopicHidden(BaseModel, frozen=True):
	'''
    This object represents a service message about General
    forum topic hidden in the chat. Currently holds
    no information.

    Reference: https://core.telegram.org/bots/api#generalforumtopichidden
	'''

	pass
 

class GeneralForumTopicUnhidden(BaseModel, frozen=True):
	'''
    This object represents a service message about General
    forum topic unhidden in the chat. Currently holds
    no information.

    Reference: https://core.telegram.org/bots/api#generalforumtopicunhidden
	'''

	pass
 

class SharedUser(BaseModel, frozen=True):
	'''
    This object contains information about a user that
    was shared with the bot using a KeyboardButtonRequestUsers
    button.

    Reference: https://core.telegram.org/bots/api#shareduser
	'''

	user_id: int
	first_name: Optional[str] = Field(default=None)
	last_name: Optional[str] = Field(default=None)
	username: Optional[str] = Field(default=None)
	photo: Optional[List[PhotoSize]] = Field(default=None) 

class UsersShared(BaseModel, frozen=True):
	'''
    This object contains information about the users whose
    identifiers were shared with the bot using a
    KeyboardButtonRequestUsers button.

    Reference: https://core.telegram.org/bots/api#usersshared
	'''

	request_id: int
	users: List[SharedUser] 

class ChatShared(BaseModel, frozen=True):
	'''
    This object contains information about a chat that
    was shared with the bot using a KeyboardButtonRequestChat
    button.

    Reference: https://core.telegram.org/bots/api#chatshared
	'''

	request_id: int
	chat_id: int
	title: Optional[str] = Field(default=None)
	username: Optional[str] = Field(default=None)
	photo: Optional[List[PhotoSize]] = Field(default=None) 

class WriteAccessAllowed(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    user allowing a bot to write messages after
    adding it to the attachment menu, launching a
    Web App from a link, or accepting an
    explicit request from a Web App sent by
    the method requestWriteAccess.

    Reference: https://core.telegram.org/bots/api#writeaccessallowed
	'''

	from_request: Optional[bool] = Field(default=None)
	web_app_name: Optional[str] = Field(default=None)
	from_attachment_menu: Optional[bool] = Field(default=None) 

class VideoChatScheduled(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    video chat scheduled in the chat.

    Reference: https://core.telegram.org/bots/api#videochatscheduled
	'''

	start_date: int 

class VideoChatStarted(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    video chat started in the chat. Currently holds
    no information.

    Reference: https://core.telegram.org/bots/api#videochatstarted
	'''

	pass
 

class VideoChatEnded(BaseModel, frozen=True):
	'''
    This object represents a service message about a
    video chat ended in the chat.

    Reference: https://core.telegram.org/bots/api#videochatended
	'''

	duration: int 

class VideoChatParticipantsInvited(BaseModel, frozen=True):
	'''
    This object represents a service message about new
    members invited to a video chat.

    Reference: https://core.telegram.org/bots/api#videochatparticipantsinvited
	'''

	users: List[User] 

class PaidMessagePriceChanged(BaseModel, frozen=True):
	'''
    Describes a service message about a change in
    the price of paid messages within a chat.

    Reference: https://core.telegram.org/bots/api#paidmessagepricechanged
	'''

	paid_message_star_count: int 

class DirectMessagePriceChanged(BaseModel, frozen=True):
	'''
    Describes a service message about a change in
    the price of direct messages sent to a
    channel chat.

    Reference: https://core.telegram.org/bots/api#directmessagepricechanged
	'''

	are_direct_messages_enabled: bool
	direct_message_star_count: Optional[int] = Field(default=None) 

class SuggestedPostApproved(BaseModel, frozen=True):
	'''
    Describes a service message about the approval of
    a suggested post.

    Reference: https://core.telegram.org/bots/api#suggestedpostapproved
	'''

	send_date: int
	suggested_post_message: Optional[Message] = Field(default=None)
	price: Optional[SuggestedPostPrice] = Field(default=None) 

class SuggestedPostApprovalFailed(BaseModel, frozen=True):
	'''
    Describes a service message about the failed approval
    of a suggested post. Currently, only caused by
    insufficient user funds at the time of approval.

    Reference: https://core.telegram.org/bots/api#suggestedpostapprovalfailed
	'''

	price: SuggestedPostPrice
	suggested_post_message: Optional[Message] = Field(default=None) 

class SuggestedPostDeclined(BaseModel, frozen=True):
	'''
    Describes a service message about the rejection of
    a suggested post.

    Reference: https://core.telegram.org/bots/api#suggestedpostdeclined
	'''

	suggested_post_message: Optional[Message] = Field(default=None)
	comment: Optional[str] = Field(default=None) 

class SuggestedPostPaid(BaseModel, frozen=True):
	'''
    Describes a service message about a successful payment
    for a suggested post.

    Reference: https://core.telegram.org/bots/api#suggestedpostpaid
	'''

	currency: str
	suggested_post_message: Optional[Message] = Field(default=None)
	amount: Optional[int] = Field(default=None)
	star_amount: Optional[StarAmount] = Field(default=None) 

class SuggestedPostRefunded(BaseModel, frozen=True):
	'''
    Describes a service message about a payment refund
    for a suggested post.

    Reference: https://core.telegram.org/bots/api#suggestedpostrefunded
	'''

	reason: str
	suggested_post_message: Optional[Message] = Field(default=None) 

class GiveawayCreated(BaseModel, frozen=True):
	'''
    This object represents a service message about the
    creation of a scheduled giveaway.

    Reference: https://core.telegram.org/bots/api#giveawaycreated
	'''

	prize_star_count: Optional[int] = Field(default=None) 

class Giveaway(BaseModel, frozen=True):
	'''
    This object represents a message about a scheduled
    giveaway.

    Reference: https://core.telegram.org/bots/api#giveaway
	'''

	chats: List[Chat]
	winners_selection_date: int
	winner_count: int
	only_new_members: Optional[bool] = Field(default=None)
	has_public_winners: Optional[bool] = Field(default=None)
	prize_description: Optional[str] = Field(default=None)
	country_codes: Optional[List[str]] = Field(default=None)
	prize_star_count: Optional[int] = Field(default=None)
	premium_subscription_month_count: Optional[int] = Field(default=None) 

class GiveawayWinners(BaseModel, frozen=True):
	'''
    This object represents a message about the completion
    of a giveaway with public winners.

    Reference: https://core.telegram.org/bots/api#giveawaywinners
	'''

	chat: Chat
	giveaway_message_id: int
	winners_selection_date: int
	winner_count: int
	winners: List[User]
	additional_chat_count: Optional[int] = Field(default=None)
	prize_star_count: Optional[int] = Field(default=None)
	premium_subscription_month_count: Optional[int] = Field(default=None)
	unclaimed_prize_count: Optional[int] = Field(default=None)
	only_new_members: Optional[bool] = Field(default=None)
	was_refunded: Optional[bool] = Field(default=None)
	prize_description: Optional[str] = Field(default=None) 

class GiveawayCompleted(BaseModel, frozen=True):
	'''
    This object represents a service message about the
    completion of a giveaway without public winners.

    Reference: https://core.telegram.org/bots/api#giveawaycompleted
	'''

	winner_count: int
	unclaimed_prize_count: Optional[int] = Field(default=None)
	giveaway_message: Optional[Message] = Field(default=None)
	is_star_giveaway: Optional[bool] = Field(default=None) 

class LinkPreviewOptions(BaseModel, frozen=True):
	'''
    Describes the options used for link preview generation.

    Reference: https://core.telegram.org/bots/api#linkpreviewoptions
	'''

	is_disabled: Optional[bool] = Field(default=None)
	url: Optional[str] = Field(default=None)
	prefer_small_media: Optional[bool] = Field(default=None)
	prefer_large_media: Optional[bool] = Field(default=None)
	show_above_text: Optional[bool] = Field(default=None) 

class SuggestedPostPrice(BaseModel, frozen=True):
	'''
    Describes the price of a suggested post.

    Reference: https://core.telegram.org/bots/api#suggestedpostprice
	'''

	currency: str
	amount: int 

class SuggestedPostInfo(BaseModel, frozen=True):
	'''
    Contains information about a suggested post.

    Reference: https://core.telegram.org/bots/api#suggestedpostinfo
	'''

	state: str
	price: Optional[SuggestedPostPrice] = Field(default=None)
	send_date: Optional[int] = Field(default=None) 

class SuggestedPostParameters(BaseModel, frozen=True):
	'''
    Contains parameters of a post that is being
    suggested by the bot.

    Reference: https://core.telegram.org/bots/api#suggestedpostparameters
	'''

	price: Optional[SuggestedPostPrice] = Field(default=None)
	send_date: Optional[int] = Field(default=None) 

class DirectMessagesTopic(BaseModel, frozen=True):
	'''
    Describes a topic of a direct messages chat.

    Reference: https://core.telegram.org/bots/api#directmessagestopic
	'''

	topic_id: int
	user: Optional[User] = Field(default=None) 

class UserProfilePhotos(BaseModel, frozen=True):
	'''
    This object represent a user's profile pictures.

    Reference: https://core.telegram.org/bots/api#userprofilephotos
	'''

	total_count: int
	photos: List[List[PhotoSize]] 

class File(BaseModel, frozen=True):
	'''
    This object represents a file ready to be
    downloaded. The file can be downloaded via the
    link https://api.telegram.org/file/bot<token>/<file_path>. It is guaranteed that the link
    will be valid for at least 1 hour.
    When the link expires, a new one can
    be requested by calling getFile.

    Reference: https://core.telegram.org/bots/api#file
	'''

	file_id: str
	file_unique_id: str
	file_size: Optional[int] = Field(default=None)
	file_path: Optional[str] = Field(default=None) 

class WebAppInfo(BaseModel, frozen=True):
	'''
    Describes a Web App.

    Reference: https://core.telegram.org/bots/api#webappinfo
	'''

	url: str 

class ReplyKeyboardMarkup(BaseModel, frozen=True):
	'''
    This object represents a custom keyboard with reply
    options (see Introduction to bots for details and
    examples). Not supported in channels and for messages
    sent on behalf of a Telegram Business account.

    Reference: https://core.telegram.org/bots/api#replykeyboardmarkup
	'''

	keyboard: List[List[KeyboardButton]]
	is_persistent: Optional[bool] = Field(default=None)
	resize_keyboard: Optional[bool] = Field(default=None)
	one_time_keyboard: Optional[bool] = Field(default=None)
	input_field_placeholder: Optional[str] = Field(default=None)
	selective: Optional[bool] = Field(default=None) 

class KeyboardButton(BaseModel, frozen=True):
	'''
    This object represents one button of the reply
    keyboard. At most one of the optional fields
    must be used to specify type of the
    button. For simple text buttons, String can be
    used instead of this object to specify the
    button text.

    Reference: https://core.telegram.org/bots/api#keyboardbutton
	'''

	text: str
	request_users: Optional[KeyboardButtonRequestUsers] = Field(default=None)
	request_chat: Optional[KeyboardButtonRequestChat] = Field(default=None)
	request_contact: Optional[bool] = Field(default=None)
	request_location: Optional[bool] = Field(default=None)
	request_poll: Optional[KeyboardButtonPollType] = Field(default=None)
	web_app: Optional[WebAppInfo] = Field(default=None) 

class KeyboardButtonRequestUsers(BaseModel, frozen=True):
	'''
    This object defines the criteria used to request
    suitable users. Information about the selected users will
    be shared with the bot when the corresponding
    button is pressed. More about requesting users »

    Reference: https://core.telegram.org/bots/api#keyboardbuttonrequestusers
	'''

	request_id: int
	user_is_bot: Optional[bool] = Field(default=None)
	user_is_premium: Optional[bool] = Field(default=None)
	max_quantity: Optional[int] = Field(default=None)
	request_name: Optional[bool] = Field(default=None)
	request_username: Optional[bool] = Field(default=None)
	request_photo: Optional[bool] = Field(default=None) 

class KeyboardButtonRequestChat(BaseModel, frozen=True):
	'''
    This object defines the criteria used to request
    a suitable chat. Information about the selected chat
    will be shared with the bot when the
    corresponding button is pressed. The bot will be
    granted requested rights in the chat if appropriate.
    More about requesting chats ».

    Reference: https://core.telegram.org/bots/api#keyboardbuttonrequestchat
	'''

	request_id: int
	chat_is_channel: bool
	chat_is_forum: Optional[bool] = Field(default=None)
	chat_has_username: Optional[bool] = Field(default=None)
	chat_is_created: Optional[bool] = Field(default=None)
	user_administrator_rights: Optional[ChatAdministratorRights] = Field(default=None)
	bot_administrator_rights: Optional[ChatAdministratorRights] = Field(default=None)
	bot_is_member: Optional[bool] = Field(default=None)
	request_title: Optional[bool] = Field(default=None)
	request_username: Optional[bool] = Field(default=None)
	request_photo: Optional[bool] = Field(default=None) 

class KeyboardButtonPollType(BaseModel, frozen=True):
	'''
    This object represents type of a poll, which
    is allowed to be created and sent when
    the corresponding button is pressed.

    Reference: https://core.telegram.org/bots/api#keyboardbuttonpolltype
	'''

	type: Optional[str] = Field(default=None) 

class ReplyKeyboardRemove(BaseModel, frozen=True):
	'''
    Upon receiving a message with this object, Telegram
    clients will remove the current custom keyboard and
    display the default letter-keyboard. By default, custom keyboards
    are displayed until a new keyboard is sent
    by a bot. An exception is made for
    one-time keyboards that are hidden immediately after the
    user presses a button (see ReplyKeyboardMarkup). Not supported
    in channels and for messages sent on behalf
    of a Telegram Business account.

    Reference: https://core.telegram.org/bots/api#replykeyboardremove
	'''

	remove_keyboard: bool
	selective: Optional[bool] = Field(default=None) 

class InlineKeyboardMarkup(BaseModel, frozen=True):
	'''
    This object represents an inline keyboard that appears
    right next to the message it belongs to.

    Reference: https://core.telegram.org/bots/api#inlinekeyboardmarkup
	'''

	inline_keyboard: List[List[InlineKeyboardButton]]
	
	@staticmethod
	def from_dict(
		json_data: list[list[dict[str, Any]]]
	) -> InlineKeyboardMarkup:
		keyboard = [
			[
				InlineKeyboardButton(**button) for button in row
			] for row in json_data
		]
		return InlineKeyboardMarkup(inline_keyboard=keyboard)
	 

class InlineKeyboardButton(BaseModel, frozen=True):
	'''
    This object represents one button of an inline
    keyboard. Exactly one of the optional fields must
    be used to specify type of the button.

    Reference: https://core.telegram.org/bots/api#inlinekeyboardbutton
	'''

	text: str
	url: Optional[str] = Field(default=None)
	callback_data: Optional[str] = Field(default=None)
	web_app: Optional[WebAppInfo] = Field(default=None)
	login_url: Optional[LoginUrl] = Field(default=None)
	switch_inline_query: Optional[str] = Field(default=None)
	switch_inline_query_current_chat: Optional[str] = Field(default=None)
	switch_inline_query_chosen_chat: Optional[SwitchInlineQueryChosenChat] = Field(default=None)
	copy_text: Optional[CopyTextButton] = Field(default=None)
	callback_game: Optional[CallbackGame] = Field(default=None)
	pay: Optional[bool] = Field(default=None) 

class LoginUrl(BaseModel, frozen=True):
	'''
    This object represents a parameter of the inline
    keyboard button used to automatically authorize a user.
    Serves as a great replacement for the Telegram
    Login Widget when the user is coming from
    Telegram. All the user needs to do is
    tap/click a button and confirm that they want
    to log in:

    Reference: https://core.telegram.org/bots/api#loginurl
	'''

	url: str
	forward_text: Optional[str] = Field(default=None)
	bot_username: Optional[str] = Field(default=None)
	request_write_access: Optional[bool] = Field(default=None) 

class SwitchInlineQueryChosenChat(BaseModel, frozen=True):
	'''
    This object represents an inline button that switches
    the current user to inline mode in a
    chosen chat, with an optional default inline query.

    Reference: https://core.telegram.org/bots/api#switchinlinequerychosenchat
	'''

	query: Optional[str] = Field(default=None)
	allow_user_chats: Optional[bool] = Field(default=None)
	allow_bot_chats: Optional[bool] = Field(default=None)
	allow_group_chats: Optional[bool] = Field(default=None)
	allow_channel_chats: Optional[bool] = Field(default=None) 

class CopyTextButton(BaseModel, frozen=True):
	'''
    This object represents an inline keyboard button that
    copies specified text to the clipboard.

    Reference: https://core.telegram.org/bots/api#copytextbutton
	'''

	text: str 

class CallbackQuery(BaseModel, frozen=True):
	'''
    This object represents an incoming callback query from
    a callback button in an inline keyboard. If
    the button that originated the query was attached
    to a message sent by the bot, the
    field message will be present. If the button
    was attached to a message sent via the
    bot (in inline mode), the field inline_message_id will
    be present. Exactly one of the fields data
    or game_short_name will be present.

    Reference: https://core.telegram.org/bots/api#callbackquery
	'''

	id: str
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	chat_instance: str
	message: Optional[MaybeInaccessibleMessage] = Field(default=None)
	inline_message_id: Optional[str] = Field(default=None)
	data: Optional[str] = Field(default=None)
	game_short_name: Optional[str] = Field(default=None) 

class ForceReply(BaseModel, frozen=True):
	'''
    Upon receiving a message with this object, Telegram
    clients will display a reply interface to the
    user (act as if the user has selected
    the bot's message and tapped 'Reply'). This can
    be extremely useful if you want to create
    user-friendly step-by-step interfaces without having to sacrifice privacy
    mode. Not supported in channels and for messages
    sent on behalf of a Telegram Business account.

    Reference: https://core.telegram.org/bots/api#forcereply
	'''

	force_reply: bool
	input_field_placeholder: Optional[str] = Field(default=None)
	selective: Optional[bool] = Field(default=None) 

class ChatPhoto(BaseModel, frozen=True):
	'''
    This object represents a chat photo.

    Reference: https://core.telegram.org/bots/api#chatphoto
	'''

	small_file_id: str
	small_file_unique_id: str
	big_file_id: str
	big_file_unique_id: str 

class ChatInviteLink(BaseModel, frozen=True):
	'''
    Represents an invite link for a chat.

    Reference: https://core.telegram.org/bots/api#chatinvitelink
	'''

	invite_link: str
	creator: User
	creates_join_request: bool
	is_primary: bool
	is_revoked: bool
	name: Optional[str] = Field(default=None)
	expire_date: Optional[int] = Field(default=None)
	member_limit: Optional[int] = Field(default=None)
	pending_join_request_count: Optional[int] = Field(default=None)
	subscription_period: Optional[int] = Field(default=None)
	subscription_price: Optional[int] = Field(default=None) 

class ChatAdministratorRights(BaseModel, frozen=True):
	'''
    Represents the rights of an administrator in a
    chat.

    Reference: https://core.telegram.org/bots/api#chatadministratorrights
	'''

	is_anonymous: bool
	can_manage_chat: bool
	can_delete_messages: bool
	can_manage_video_chats: bool
	can_restrict_members: bool
	can_promote_members: bool
	can_change_info: bool
	can_invite_users: bool
	can_post_stories: bool
	can_edit_stories: bool
	can_delete_stories: bool
	can_post_messages: Optional[bool] = Field(default=None)
	can_edit_messages: Optional[bool] = Field(default=None)
	can_pin_messages: Optional[bool] = Field(default=None)
	can_manage_topics: Optional[bool] = Field(default=None)
	can_manage_direct_messages: Optional[bool] = Field(default=None) 

class ChatMemberUpdated(BaseModel, frozen=True):
	'''
    This object represents changes in the status of
    a chat member.

    Reference: https://core.telegram.org/bots/api#chatmemberupdated
	'''

	chat: Chat
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	date: int
	old_chat_member: ChatMember
	new_chat_member: ChatMember
	invite_link: Optional[ChatInviteLink] = Field(default=None)
	via_join_request: Optional[bool] = Field(default=None)
	via_chat_folder_invite_link: Optional[bool] = Field(default=None) 

class ChatJoinRequest(BaseModel, frozen=True):
	'''
    Represents a join request sent to a chat.

    Reference: https://core.telegram.org/bots/api#chatjoinrequest
	'''

	chat: Chat
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	user_chat_id: int
	date: int
	bio: Optional[str] = Field(default=None)
	invite_link: Optional[ChatInviteLink] = Field(default=None)
	
	async def approve(
		self,
		bot: api.BotAPI
	) -> bool:
		return await bot.approve_chat_join_request(
			chat_id=self.chat.id,
			user_id=self.from_user.id
		)
	
	async def decline(
		self,
		bot: api.BotAPI
	) -> bool:
		return await bot.decline_chat_join_request(
			chat_id=self.chat.id,
			user_id=self.from_user.id
		)
	 

class ChatPermissions(BaseModel, frozen=True):
	'''
    Describes actions that a non-administrator user is allowed
    to take in a chat.

    Reference: https://core.telegram.org/bots/api#chatpermissions
	'''

	can_send_messages: Optional[bool] = Field(default=None)
	can_send_audios: Optional[bool] = Field(default=None)
	can_send_documents: Optional[bool] = Field(default=None)
	can_send_photos: Optional[bool] = Field(default=None)
	can_send_videos: Optional[bool] = Field(default=None)
	can_send_video_notes: Optional[bool] = Field(default=None)
	can_send_voice_notes: Optional[bool] = Field(default=None)
	can_send_polls: Optional[bool] = Field(default=None)
	can_send_other_messages: Optional[bool] = Field(default=None)
	can_add_web_page_previews: Optional[bool] = Field(default=None)
	can_change_info: Optional[bool] = Field(default=None)
	can_invite_users: Optional[bool] = Field(default=None)
	can_pin_messages: Optional[bool] = Field(default=None)
	can_manage_topics: Optional[bool] = Field(default=None) 

class Birthdate(BaseModel, frozen=True):
	'''
    Describes the birthdate of a user.

    Reference: https://core.telegram.org/bots/api#birthdate
	'''

	day: int
	month: int
	year: Optional[int] = Field(default=None) 

class BusinessIntro(BaseModel, frozen=True):
	'''
    Contains information about the start page settings of
    a Telegram Business account.

    Reference: https://core.telegram.org/bots/api#businessintro
	'''

	title: Optional[str] = Field(default=None)
	message: Optional[str] = Field(default=None)
	sticker: Optional[Sticker] = Field(default=None) 

class BusinessLocation(BaseModel, frozen=True):
	'''
    Contains information about the location of a Telegram
    Business account.

    Reference: https://core.telegram.org/bots/api#businesslocation
	'''

	address: str
	location: Optional[Location] = Field(default=None) 

class BusinessOpeningHoursInterval(BaseModel, frozen=True):
	'''
    Describes an interval of time during which a
    business is open.

    Reference: https://core.telegram.org/bots/api#businessopeninghoursinterval
	'''

	opening_minute: int
	closing_minute: int 

class BusinessOpeningHours(BaseModel, frozen=True):
	'''
    Describes the opening hours of a business.

    Reference: https://core.telegram.org/bots/api#businessopeninghours
	'''

	time_zone_name: str
	opening_hours: List[BusinessOpeningHoursInterval] 

class StoryAreaPosition(BaseModel, frozen=True):
	'''
    Describes the position of a clickable area within
    a story.

    Reference: https://core.telegram.org/bots/api#storyareaposition
	'''

	x_percentage: float
	y_percentage: float
	width_percentage: float
	height_percentage: float
	rotation_angle: float
	corner_radius_percentage: float 

class LocationAddress(BaseModel, frozen=True):
	'''
    Describes the physical address of a location.

    Reference: https://core.telegram.org/bots/api#locationaddress
	'''

	country_code: str
	state: Optional[str] = Field(default=None)
	city: Optional[str] = Field(default=None)
	street: Optional[str] = Field(default=None) 

class StoryArea(BaseModel, frozen=True):
	'''
    Describes a clickable area on a story media.

    Reference: https://core.telegram.org/bots/api#storyarea
	'''

	position: StoryAreaPosition
	type: StoryAreaType 

class ChatLocation(BaseModel, frozen=True):
	'''
    Represents a location to which a chat is
    connected.

    Reference: https://core.telegram.org/bots/api#chatlocation
	'''

	location: Location
	address: str 

class ReactionCount(BaseModel, frozen=True):
	'''
    Represents a reaction added to a message along
    with the number of times it was added.

    Reference: https://core.telegram.org/bots/api#reactioncount
	'''

	type: ReactionType
	total_count: int 

class MessageReactionUpdated(BaseModel, frozen=True):
	'''
    This object represents a change of a reaction
    on a message performed by a user.

    Reference: https://core.telegram.org/bots/api#messagereactionupdated
	'''

	chat: Chat
	message_id: int
	date: int
	old_reaction: List[ReactionType]
	new_reaction: List[ReactionType]
	user: Optional[User] = Field(default=None)
	actor_chat: Optional[Chat] = Field(default=None) 

class MessageReactionCountUpdated(BaseModel, frozen=True):
	'''
    This object represents reaction changes on a message
    with anonymous reactions.

    Reference: https://core.telegram.org/bots/api#messagereactioncountupdated
	'''

	chat: Chat
	message_id: int
	date: int
	reactions: List[ReactionCount] 

class ForumTopic(BaseModel, frozen=True):
	'''
    This object represents a forum topic.

    Reference: https://core.telegram.org/bots/api#forumtopic
	'''

	message_thread_id: int
	name: str
	icon_color: int
	icon_custom_emoji_id: Optional[str] = Field(default=None) 

class Gift(BaseModel, frozen=True):
	'''
    This object represents a gift that can be
    sent by the bot.

    Reference: https://core.telegram.org/bots/api#gift
	'''

	id: str
	sticker: Sticker
	star_count: int
	upgrade_star_count: Optional[int] = Field(default=None)
	total_count: Optional[int] = Field(default=None)
	remaining_count: Optional[int] = Field(default=None)
	publisher_chat: Optional[Chat] = Field(default=None) 

class Gifts(BaseModel, frozen=True):
	'''
    This object represent a list of gifts.

    Reference: https://core.telegram.org/bots/api#gifts
	'''

	gifts: List[Gift] 

class UniqueGiftModel(BaseModel, frozen=True):
	'''
    This object describes the model of a unique
    gift.

    Reference: https://core.telegram.org/bots/api#uniquegiftmodel
	'''

	name: str
	sticker: Sticker
	rarity_per_mille: int 

class UniqueGiftSymbol(BaseModel, frozen=True):
	'''
    This object describes the symbol shown on the
    pattern of a unique gift.

    Reference: https://core.telegram.org/bots/api#uniquegiftsymbol
	'''

	name: str
	sticker: Sticker
	rarity_per_mille: int 

class UniqueGiftBackdropColors(BaseModel, frozen=True):
	'''
    This object describes the colors of the backdrop
    of a unique gift.

    Reference: https://core.telegram.org/bots/api#uniquegiftbackdropcolors
	'''

	center_color: int
	edge_color: int
	symbol_color: int
	text_color: int 

class UniqueGiftBackdrop(BaseModel, frozen=True):
	'''
    This object describes the backdrop of a unique
    gift.

    Reference: https://core.telegram.org/bots/api#uniquegiftbackdrop
	'''

	name: str
	colors: UniqueGiftBackdropColors
	rarity_per_mille: int 

class UniqueGift(BaseModel, frozen=True):
	'''
    This object describes a unique gift that was
    upgraded from a regular gift.

    Reference: https://core.telegram.org/bots/api#uniquegift
	'''

	base_name: str
	name: str
	number: int
	model: UniqueGiftModel
	symbol: UniqueGiftSymbol
	backdrop: UniqueGiftBackdrop
	publisher_chat: Optional[Chat] = Field(default=None) 

class GiftInfo(BaseModel, frozen=True):
	'''
    Describes a service message about a regular gift
    that was sent or received.

    Reference: https://core.telegram.org/bots/api#giftinfo
	'''

	gift: Gift
	owned_gift_id: Optional[str] = Field(default=None)
	convert_star_count: Optional[int] = Field(default=None)
	prepaid_upgrade_star_count: Optional[int] = Field(default=None)
	can_be_upgraded: Optional[bool] = Field(default=None)
	text: Optional[str] = Field(default=None)
	entities: Optional[List[MessageEntity]] = Field(default=None)
	is_private: Optional[bool] = Field(default=None) 

class UniqueGiftInfo(BaseModel, frozen=True):
	'''
    Describes a service message about a unique gift
    that was sent or received.

    Reference: https://core.telegram.org/bots/api#uniquegiftinfo
	'''

	gift: UniqueGift
	origin: str
	last_resale_star_count: Optional[int] = Field(default=None)
	owned_gift_id: Optional[str] = Field(default=None)
	transfer_star_count: Optional[int] = Field(default=None)
	next_transfer_date: Optional[int] = Field(default=None) 

class OwnedGifts(BaseModel, frozen=True):
	'''
    Contains the list of gifts received and owned
    by a user or a chat.

    Reference: https://core.telegram.org/bots/api#ownedgifts
	'''

	total_count: int
	gifts: List[OwnedGift]
	next_offset: Optional[str] = Field(default=None) 

class AcceptedGiftTypes(BaseModel, frozen=True):
	'''
    This object describes the types of gifts that
    can be gifted to a user or a
    chat.

    Reference: https://core.telegram.org/bots/api#acceptedgifttypes
	'''

	unlimited_gifts: bool
	limited_gifts: bool
	unique_gifts: bool
	premium_subscription: bool 

class StarAmount(BaseModel, frozen=True):
	'''
    Describes an amount of Telegram Stars.

    Reference: https://core.telegram.org/bots/api#staramount
	'''

	amount: int
	nanostar_amount: Optional[int] = Field(default=None) 

class BotCommand(BaseModel, frozen=True):
	'''
    This object represents a bot command.

    Reference: https://core.telegram.org/bots/api#botcommand
	'''

	command: str
	description: str 

class BotName(BaseModel, frozen=True):
	'''
    This object represents the bot's name.

    Reference: https://core.telegram.org/bots/api#botname
	'''

	name: str 

class BotDescription(BaseModel, frozen=True):
	'''
    This object represents the bot's description.

    Reference: https://core.telegram.org/bots/api#botdescription
	'''

	description: str 

class BotShortDescription(BaseModel, frozen=True):
	'''
    This object represents the bot's short description.

    Reference: https://core.telegram.org/bots/api#botshortdescription
	'''

	short_description: str 

class ChatBoost(BaseModel, frozen=True):
	'''
    This object contains information about a chat boost.

    Reference: https://core.telegram.org/bots/api#chatboost
	'''

	boost_id: str
	add_date: int
	expiration_date: int
	source: ChatBoostSource 

class ChatBoostUpdated(BaseModel, frozen=True):
	'''
    This object represents a boost added to a
    chat or changed.

    Reference: https://core.telegram.org/bots/api#chatboostupdated
	'''

	chat: Chat
	boost: ChatBoost 

class ChatBoostRemoved(BaseModel, frozen=True):
	'''
    This object represents a boost removed from a
    chat.

    Reference: https://core.telegram.org/bots/api#chatboostremoved
	'''

	chat: Chat
	boost_id: str
	remove_date: int
	source: ChatBoostSource 

class UserChatBoosts(BaseModel, frozen=True):
	'''
    This object represents a list of boosts added
    to a chat by a user.

    Reference: https://core.telegram.org/bots/api#userchatboosts
	'''

	boosts: List[ChatBoost] 

class BusinessBotRights(BaseModel, frozen=True):
	'''
    Represents the rights of a business bot.

    Reference: https://core.telegram.org/bots/api#businessbotrights
	'''

	can_reply: Optional[bool] = Field(default=None)
	can_read_messages: Optional[bool] = Field(default=None)
	can_delete_sent_messages: Optional[bool] = Field(default=None)
	can_delete_all_messages: Optional[bool] = Field(default=None)
	can_edit_name: Optional[bool] = Field(default=None)
	can_edit_bio: Optional[bool] = Field(default=None)
	can_edit_profile_photo: Optional[bool] = Field(default=None)
	can_edit_username: Optional[bool] = Field(default=None)
	can_change_gift_settings: Optional[bool] = Field(default=None)
	can_view_gifts_and_stars: Optional[bool] = Field(default=None)
	can_convert_gifts_to_stars: Optional[bool] = Field(default=None)
	can_transfer_and_upgrade_gifts: Optional[bool] = Field(default=None)
	can_transfer_stars: Optional[bool] = Field(default=None)
	can_manage_stories: Optional[bool] = Field(default=None) 

class BusinessConnection(BaseModel, frozen=True):
	'''
    Describes the connection of the bot with a
    business account.

    Reference: https://core.telegram.org/bots/api#businessconnection
	'''

	id: str
	user: User
	user_chat_id: int
	date: int
	is_enabled: bool
	rights: Optional[BusinessBotRights] = Field(default=None) 

class BusinessMessagesDeleted(BaseModel, frozen=True):
	'''
    This object is received when messages are deleted
    from a connected business account.

    Reference: https://core.telegram.org/bots/api#businessmessagesdeleted
	'''

	business_connection_id: str
	chat: Chat
	message_ids: List[int] 

class ResponseParameters(BaseModel, frozen=True):
	'''
    Describes why a request was unsuccessful.

    Reference: https://core.telegram.org/bots/api#responseparameters
	'''

	migrate_to_chat_id: Optional[int] = Field(default=None)
	retry_after: Optional[int] = Field(default=None) 

class InputFile(BaseModel, frozen=True):
	'''
    This object represents the contents of a file
    to be uploaded. Must be posted using multipart/form-data
    in the usual way that files are uploaded
    via the browser.

    Reference: https://core.telegram.org/bots/api#inputfile
	'''

	file_content: bytes # Raw file content as bytes.
	file_name: str # File name, including its extension.
	mime_type: str | None = Field(default=None) # File MIME type.
	 

class Sticker(BaseModel, frozen=True):
	'''
    This object represents a sticker.

    Reference: https://core.telegram.org/bots/api#sticker
	'''

	file_id: str
	file_unique_id: str
	type: str
	width: int
	height: int
	is_animated: bool
	is_video: bool
	thumbnail: Optional[PhotoSize] = Field(default=None)
	emoji: Optional[str] = Field(default=None)
	set_name: Optional[str] = Field(default=None)
	premium_animation: Optional[File] = Field(default=None)
	mask_position: Optional[MaskPosition] = Field(default=None)
	custom_emoji_id: Optional[str] = Field(default=None)
	needs_repainting: Optional[bool] = Field(default=None)
	file_size: Optional[int] = Field(default=None) 

class StickerSet(BaseModel, frozen=True):
	'''
    This object represents a sticker set.

    Reference: https://core.telegram.org/bots/api#stickerset
	'''

	name: str
	title: str
	sticker_type: str
	stickers: List[Sticker]
	thumbnail: Optional[PhotoSize] = Field(default=None) 

class MaskPosition(BaseModel, frozen=True):
	'''
    This object describes the position on faces where
    a mask should be placed by default.

    Reference: https://core.telegram.org/bots/api#maskposition
	'''

	point: str
	x_shift: float
	y_shift: float
	scale: float 

class InputSticker(BaseModel, frozen=True):
	'''
    This object describes a sticker to be added
    to a sticker set.

    Reference: https://core.telegram.org/bots/api#inputsticker
	'''

	sticker: str
	format: str
	emoji_list: List[str]
	mask_position: Optional[MaskPosition] = Field(default=None)
	keywords: Optional[List[str]] = Field(default=None) 

class InlineQuery(BaseModel, frozen=True):
	'''
    This object represents an incoming inline query. When
    the user sends an empty query, your bot
    could return some default or trending results.

    Reference: https://core.telegram.org/bots/api#inlinequery
	'''

	id: str
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	query: str
	offset: str
	chat_type: Optional[str] = Field(default=None)
	location: Optional[Location] = Field(default=None) 

class InlineQueryResultsButton(BaseModel, frozen=True):
	'''
    This object represents a button to be shown
    above inline query results. You must use exactly
    one of the optional fields.

    Reference: https://core.telegram.org/bots/api#inlinequeryresultsbutton
	'''

	text: str
	web_app: Optional[WebAppInfo] = Field(default=None)
	start_parameter: Optional[str] = Field(default=None) 

class ChosenInlineResult(BaseModel, frozen=True):
	'''
    Represents a result of an inline query that
    was chosen by the user and sent to
    their chat partner.

    Reference: https://core.telegram.org/bots/api#choseninlineresult
	'''

	result_id: str
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	query: str
	location: Optional[Location] = Field(default=None)
	inline_message_id: Optional[str] = Field(default=None) 

class SentWebAppMessage(BaseModel, frozen=True):
	'''
    Describes an inline message sent by a Web
    App on behalf of a user.

    Reference: https://core.telegram.org/bots/api#sentwebappmessage
	'''

	inline_message_id: Optional[str] = Field(default=None) 

class PreparedInlineMessage(BaseModel, frozen=True):
	'''
    Describes an inline message to be sent by
    a user of a Mini App.

    Reference: https://core.telegram.org/bots/api#preparedinlinemessage
	'''

	id: str
	expiration_date: int 

class LabeledPrice(BaseModel, frozen=True):
	'''
    This object represents a portion of the price
    for goods or services.

    Reference: https://core.telegram.org/bots/api#labeledprice
	'''

	label: str
	amount: int 

class Invoice(BaseModel, frozen=True):
	'''
    This object contains basic information about an invoice.

    Reference: https://core.telegram.org/bots/api#invoice
	'''

	title: str
	description: str
	start_parameter: str
	currency: str
	total_amount: int 

class ShippingAddress(BaseModel, frozen=True):
	'''
    This object represents a shipping address.

    Reference: https://core.telegram.org/bots/api#shippingaddress
	'''

	country_code: str
	state: str
	city: str
	street_line1: str
	street_line2: str
	post_code: str 

class OrderInfo(BaseModel, frozen=True):
	'''
    This object represents information about an order.

    Reference: https://core.telegram.org/bots/api#orderinfo
	'''

	name: Optional[str] = Field(default=None)
	phone_number: Optional[str] = Field(default=None)
	email: Optional[str] = Field(default=None)
	shipping_address: Optional[ShippingAddress] = Field(default=None) 

class ShippingOption(BaseModel, frozen=True):
	'''
    This object represents one shipping option.

    Reference: https://core.telegram.org/bots/api#shippingoption
	'''

	id: str
	title: str
	prices: List[LabeledPrice] 

class SuccessfulPayment(BaseModel, frozen=True):
	'''
    This object contains basic information about a successful
    payment. Note that if the buyer initiates a
    chargeback with the relevant payment provider following this
    transaction, the funds may be debited from your
    balance. This is outside of Telegram's control.

    Reference: https://core.telegram.org/bots/api#successfulpayment
	'''

	currency: str
	total_amount: int
	invoice_payload: str
	telegram_payment_charge_id: str
	provider_payment_charge_id: str
	subscription_expiration_date: Optional[int] = Field(default=None)
	is_recurring: Optional[bool] = Field(default=None)
	is_first_recurring: Optional[bool] = Field(default=None)
	shipping_option_id: Optional[str] = Field(default=None)
	order_info: Optional[OrderInfo] = Field(default=None) 

class RefundedPayment(BaseModel, frozen=True):
	'''
    This object contains basic information about a refunded
    payment.

    Reference: https://core.telegram.org/bots/api#refundedpayment
	'''

	currency: Literal['XTR'] = 'XTR'
	total_amount: int
	invoice_payload: str
	telegram_payment_charge_id: str
	provider_payment_charge_id: Optional[str] = Field(default=None) 

class ShippingQuery(BaseModel, frozen=True):
	'''
    This object contains information about an incoming shipping
    query.

    Reference: https://core.telegram.org/bots/api#shippingquery
	'''

	id: str
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	invoice_payload: str
	shipping_address: ShippingAddress 

class PreCheckoutQuery(BaseModel, frozen=True):
	'''
    This object contains information about an incoming pre-checkout
    query.

    Reference: https://core.telegram.org/bots/api#precheckoutquery
	'''

	id: str
	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	currency: str
	total_amount: int
	invoice_payload: str
	shipping_option_id: Optional[str] = Field(default=None)
	order_info: Optional[OrderInfo] = Field(default=None) 

class PaidMediaPurchased(BaseModel, frozen=True):
	'''
    This object contains information about a paid media
    purchase.

    Reference: https://core.telegram.org/bots/api#paidmediapurchased
	'''

	from_user: User = Field(alias='from') # FIX `from` is a python reserved keyword
	paid_media_payload: str 

class AffiliateInfo(BaseModel, frozen=True):
	'''
    Contains information about the affiliate that received a
    commission via this transaction.

    Reference: https://core.telegram.org/bots/api#affiliateinfo
	'''

	commission_per_mille: int
	amount: int
	affiliate_user: Optional[User] = Field(default=None)
	affiliate_chat: Optional[Chat] = Field(default=None)
	nanostar_amount: Optional[int] = Field(default=None) 

class StarTransaction(BaseModel, frozen=True):
	'''
    Describes a Telegram Star transaction. Note that if
    the buyer initiates a chargeback with the payment
    provider from whom they acquired Stars (e.g., Apple,
    Google) following this transaction, the refunded Stars will
    be deducted from the bot's balance. This is
    outside of Telegram's control.

    Reference: https://core.telegram.org/bots/api#startransaction
	'''

	id: str
	amount: int
	date: int
	nanostar_amount: Optional[int] = Field(default=None)
	source: Optional[TransactionPartner] = Field(default=None)
	receiver: Optional[TransactionPartner] = Field(default=None) 

class StarTransactions(BaseModel, frozen=True):
	'''
    Contains a list of Telegram Star transactions.

    Reference: https://core.telegram.org/bots/api#startransactions
	'''

	transactions: List[StarTransaction] 

class PassportData(BaseModel, frozen=True):
	'''
    Describes Telegram Passport data shared with the bot
    by the user.

    Reference: https://core.telegram.org/bots/api#passportdata
	'''

	data: List[EncryptedPassportElement]
	credentials: EncryptedCredentials 

class PassportFile(BaseModel, frozen=True):
	'''
    This object represents a file uploaded to Telegram
    Passport. Currently all Telegram Passport files are in
    JPEG format when decrypted and don't exceed 10MB.

    Reference: https://core.telegram.org/bots/api#passportfile
	'''

	file_id: str
	file_unique_id: str
	file_size: int
	file_date: int 

class EncryptedPassportElement(BaseModel, frozen=True):
	'''
    Describes documents or other Telegram Passport elements shared
    with the bot by the user.

    Reference: https://core.telegram.org/bots/api#encryptedpassportelement
	'''

	type: str
	hash: str
	data: Optional[str] = Field(default=None)
	phone_number: Optional[str] = Field(default=None)
	email: Optional[str] = Field(default=None)
	files: Optional[List[PassportFile]] = Field(default=None)
	front_side: Optional[PassportFile] = Field(default=None)
	reverse_side: Optional[PassportFile] = Field(default=None)
	selfie: Optional[PassportFile] = Field(default=None)
	translation: Optional[List[PassportFile]] = Field(default=None) 

class EncryptedCredentials(BaseModel, frozen=True):
	'''
    Describes data required for decrypting and authenticating EncryptedPassportElement.
    See the Telegram Passport Documentation for a complete
    description of the data decryption and authentication processes.

    Reference: https://core.telegram.org/bots/api#encryptedcredentials
	'''

	data: str
	hash: str
	secret: str 

class Game(BaseModel, frozen=True):
	'''
    This object represents a game. Use BotFather to
    create and edit games, their short names will
    act as unique identifiers.

    Reference: https://core.telegram.org/bots/api#game
	'''

	title: str
	description: str
	photo: List[PhotoSize]
	text: Optional[str] = Field(default=None)
	text_entities: Optional[List[MessageEntity]] = Field(default=None)
	animation: Optional[Animation] = Field(default=None) 

class CallbackGame(BaseModel, frozen=True):
	'''
    A placeholder, currently holds no information. Use BotFather
    to set up your game.

    Reference: https://core.telegram.org/bots/api#callbackgame
	'''

	pass
 

class GameHighScore(BaseModel, frozen=True):
	'''
    This object represents one row of the high
    scores table for a game.

    Reference: https://core.telegram.org/bots/api#gamehighscore
	'''

	position: int
	user: User
	score: int 

# Raw Python type adapters
IntAdapter = TypeAdapter[int](int)
StrAdapter = TypeAdapter[str](str)
FloatAdapter = TypeAdapter[float](float)
BoolAdapter = TypeAdapter[bool](bool)
