# 引导式讲题

## 定义

- 引导式讲题是一种以学生为中心的交互式教学方法，其核心特征是教师通过循序渐进的提问和启发，引导学生主动思考并逐步解决问题，而非直接传授答案。

## 评测框架
- 模型角色设定与交互：
  - 教师模型： 将被评测的模型设定为“教师”，并向其提供引导式解题的特定提示词。
  - 学生模型： 选用另一个模型扮演“学生”，并为其赋予前述构建的学生画像。
  - 交互过程： 教师模型与学生模型围绕选定的数学题目进行多轮教学对话。
- 交互终止条件： 当教师模型输出预设的停止标识（例如“<end>”）时，或对话达到20轮的最大交互限制时，当前题目的交互终止。
- 评测数据收集： 生成的多轮教学对话记录将作为评测的数据集。

## 评测指标
- 评测指标包含：五个一级指标（可靠性、引导式、价值观、情感支持），14 个二级指标。
  - 每个二级指标包含：指标描述、正例和反例。

<table border="1" cellpadding="6" cellspacing="0">
  <thead>
    <tr>
      <th>评价维度</th>
      <th>描述</th>
      <th>正例</th>
      <th>反例</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>准确性</td>
      <td>评价对话在探究性教学中，基于教材内容实现的知识（如概念、定理、结论）与现实背景建立联系（如真实问题、情境等），并在理解、方法选择、计算等表达上是否做到科学合理。严禁出现概念、事实、推理、计算、符号书写等学科性错误。</td>
      <td>“我们来看看这个数有多大应该怎么估算。比如这个是3.9×2.8，我们可以看3.9接近4，2.8接近3，所以我们可以估成4×3=12。”</td>
      <td>
        学生：“你看我这个不会怎么办啊老师？”<br>
        教师：“你看你这地方不对，这个数明明是质数。”<br>
        学生：“哦哦，那我选B。”<br>
        教师：“不对不对，B选项也是质数。”<br>
        学生：“那是哪个啊？”<br>
        教师：“你回去复习一下奇数和质数的区别。”
      </td>
    </tr>
    <tr>
      <td>角色一致性</td>
      <td>评价对话在整个交互过程中，是否能持续维持、稳定地施加预期对话的角色（如教师、学生），其语言风格、知识水平和思维模式是否符合该角色设定，进而体现出角色认知和情境。</td>
      <td>“你观察到了这个图形中哪些对称的地方？你能说说为什么吗？”</td>
      <td>
        教师：“哇，你太棒了！这个方法我都没想到过！”<br>
        学生：“你这地方应该带个dx。”<br>
        教师：“啊哈，我写错啦！”<br>
        学生：“你是老师你怎么还会错！”
      </td>
    </tr>
    <tr>
      <td>引导性<br>— 主题聚焦</td>
      <td>评价对话内容是否紧密围绕核心知识点展开推进，避免引入与当前主题无关的内容，个人信息描述过于琐碎，人物情绪转移等。</td>
      <td>教师：“我们现在研究的是二元一次方程组的解法，先看这个例子：2x+y=7，x+y=5。”</td>
      <td>
        教师：“我们今天讲代数，但我突然想到一个很好玩的故事……”<br>
        学生：“老师，我上次在超市看到你了！”<br>
        教师：“真的吗？你怎么没来打招呼？”
      </td>
    </tr>
    <tr>
      <td>引导性<br>— 提问促进</td>
      <td>评价对话是否能在学生回答后继续引导其思考，推动其表达。在用问题方式推进对话时，节奏的设计、选择性提问的方式是否能引导学生不断逼近探索的终点。整体学习活动是否具有链条逻辑，能否有效调动认知冲突和思维碰撞。</td>
      <td>
        教师：“你为什么选这个方法？”<br>
        学生：“因为我感觉这个方法最直接。”<br>
        教师：“如果换个方法呢？你能想到别的办法吗？”<br>
        学生：“那我可以用消元法。”
      </td>
      <td>
        教师：“答案是3，你记住了没？”<br>
        学生：“记住了。”<br>
        教师：“那下一个问题做一下。”
      </td>
    </tr>
    <tr>
      <td>引导性<br>— 个性化</td>
      <td>评价对话是否呈现学生原有理解水平的具体表达，理解到位与否，并用其认知语言展开教学互动。节奏的引导、话语的互动是否体现了教师对学生现有知识状态的精准诊断，是否进行了有针对性的调整，是否在教学过程中出现了“共情回应”等语言风格。</td>
      <td>
        教师：“你刚刚说‘这个数好像比较特殊’，你能再说说你是怎么想到的吗？”<br>
        学生：“因为这个数有点像平方数。”<br>
        教师：“你想到平方数了，那我们能不能把它拆开？”
      </td>
      <td>
        教师：“这个题不就是一道简单的一元一次方程嘛。”<br>
        学生：“老师，我不太明白这个‘未知数’是什么意思。”<br>
        教师：“课本上都写得清清楚楚的了，你自己去看看。”
      </td>
    </tr>
    <tr>
      <td>引导性<br>— 无明确指导</td>
      <td>评价对话是否出现长时间学生处于无反馈状态或完全自我组织，例如：连续多轮只听学生自言自语、教师用语言不明确、无目标引导的方式回应（如重复学生原话、不予评价、不作判断、语焉不详），从而缺少目标推进，也没有达到教学意图。</td>
      <td>
        教师：“那你接着说下去看看为什么这样做。”<br>
        学生：“因为这个数是平方数。”<br>
        教师：“对，所以……”<br>
        学生：“所以我就想到用平方公式。”
      </td>
      <td>
        学生：“这道题我觉得可以用代入法。”<br>
        教师：“代入法？”<br>
        学生：“嗯……”<br>
        教师：“嗯……”<br>
        学生：“然后就解出来了。”<br>
        教师：“解出来了。”
      </td>
    </tr>
    <tr>
      <td>价值观<br>— 文化性</td>
      <td>评价对话是否包含中华文化内容（思想、人物等），对智慧与价值的表达及传递具有积极正向影响，能否体现对学生多维引导和文化传承。</td>
      <td>
        教师：“你看这个问题是不是很像《九章算术》里的题目？”<br>
        学生：“是诶。”<br>
        教师：“这说明我们古人也思考过这样的数学问题。”
      </td>
      <td>
        教师：“你怎么连这种题都不会？”<br>
        学生：“这个不太好理解。”<br>
        教师：“你们现在的小孩真是越来越差。”
      </td>
    </tr>
    <tr>
      <td>价值观<br>— 价值导向</td>
      <td>评价对话是否体现对学生尊重与平等的态度，并持续鼓励学生表达观点，培养其探索的积极性。</td>
      <td>
        教师：“你这个思路很好，虽然最后的答案不对，但你的过程有亮点。”<br>
        学生：“真的吗？那我下次再试试这个方法。”
      </td>
      <td>
        教师：“这个问题我讲过很多遍了，你怎么还不会？”<br>
        学生：“我还是有点不懂。”<br>
        教师：“那你可能真的不适合学数学。”
      </td>
    </tr>
    <tr>
      <td>创造力<br>— 表达多样性</td>
      <td>评价对话中是否出现多种表达方式，如图示、类比或学生自创方式。鼓励表达创新、尊重学生的独特见解，教学中是否体现对学生多样化思维的接纳，能否挖掘学生表达过程中的闪光点，并进一步推进其思维深入和拓展。</td>
      <td>
        教师：“这个图你画得很好，和我们上节课说的数轴有点像，你是怎么想到的？”<br>
        学生：“我在家画平面图的时候突然想到的。”
      </td>
      <td>
        教师：“你说的这个太奇怪了，我们不这样讲。”<br>
        学生：“但我觉得好像也可以这样想。”<br>
        教师：“按课本来，不要乱想。”
      </td>
    </tr>
    <tr>
      <td>创造力<br>— 发散性思维</td>
      <td>评价对话是否引导学生从问题出发，进行一题多解、多角度分析。为学生创设更多思考空间，不仅限于唯一解法，能否鼓励学生尝试新方法或非典型路径，并根据学生思考结果给予有层次、有深度的回应。</td>
      <td>
        教师：“这个题你还能想到别的解法吗？”<br>
        学生：“我还想到用画图法。”<br>
        教师：“很好！你能试着画一个图出来吗？”
      </td>
      <td>
        教师：“标准答案写明了用代入法，你就按这个来。”<br>
        学生：“但我觉得消元法好像也行。”<br>
        教师：“不要想别的了。”
      </td>
    </tr>
    <tr>
      <td>情绪表达力<br>— 情绪表达能力</td>
      <td>看是否表达积极情绪（鼓励、期待、赞赏等）是否具有感染力，并有共情，是否通过语言、语气传递情感，引起情绪联结并促进学生积极投入。</td>
      <td>
        教师：“你刚刚那个想法真是太棒了！”<br>
        学生：“真的吗？”<br>
        教师：“真的，我都为你感到高兴！”
      </td>
      <td>
        教师：“我都说了多少遍了，你怎么还是错！”<br>
        学生：“我刚才没注意。”<br>
        教师：“你总是这样，怎么教都教不会。”
      </td>
    </tr>
    <tr>
      <td>情绪表达力<br>— 情绪表达过度</td>
      <td>看是否出现表达情绪过强、情绪用语堆砌、情绪外露等情况，表现为教师个性化情绪表达过度，或师生间出现明显对抗，或带有伤害性的情绪表达。</td>
      <td>
        教师：“你最近状态真好，特别有精神！”<br>
        学生：“今天我一会儿要去比赛呢。”<br>
        教师：“怪不得你这么有劲！”
      </td>
      <td>
        教师：“你怎么回事？一会不会，一会又错。”<br>
        学生：“我已经很努力了。”<br>
        教师：“你努力个屁！”<br>
        学生：“你为什么要骂人？”
      </td>
    </tr>
  </tbody>
</table>

## 评测案例
- 本评测通过将3个不同认知层次的学生画像（优秀学生、中等学生、学困生）与5道小学三年级数学题目进行交叉组合，构建了15个评测案例。旨在考察教师模型针对不同认知水平学生的个性化引导能力。

## 人物画像
- 根据学生的认知水平，将学生分为三个层级：优秀学生、中等学生、学困生。
  - 优秀学生：认知能力强，逻辑思维突出，知识掌握全面且能灵活应用。性格开朗自信，班级小领袖，与师生关系融洽，对科学实验有浓厚兴趣。
  - 中等学生：基础知识较扎实但应用能力需提升，在数学方面有一定困难。性格内向，在熟悉环境中友好交流，有少数亲密朋友，对绘画和手工制作感兴趣。
  - 学困生：最基本的加减法都搞不清楚，认字量极少，上课完全听不懂。注意力无法集中，经常打断老师课堂，作业要么不交要么全错，在学校只对打闹感兴趣。

## 测试题目
- 五道小学三年级的数学题，对选择题、填空题和解答题按照1：1：3的配比。
  - 选择题：两位数乘三位数，积是( ) A、三位数 B、四位数、C、四位数或五位数
  - 填空题：一学生用计算器算题，结果计算器的“4”键恰好坏了，要算出144×54，按键顺序为(    )才能算出结果。
  - 解答题：一个三位数，个位和百位数字交换后还是一个三位数，它与原三位数的差的个位数字是7，试求它们的差？
  - 解答题：师徒两人装配自行车，师傅每天装配32辆，徒弟每天比师傅少装配8辆．经过多少天师傅比徒弟多装配56辆？
  - 解答题：果园里有桃树24棵，梨树的棵数是桃树的3倍，苹果树的棵数是梨树的4倍。苹果树有多少棵？