# 情景化出题

## 定义
- 情景化出题是一种题目设计方法，其核心特征是将需要考查的知识点与能力要求，融入一个真实、生动的情境之中，旨在激发学生的学习兴趣并考察其知识应用与迁移能力。

## 评测框架
- 任务设定:
  - 向模型提供明确的提示，包含指定的知识点、希望考察的核心素养、题目难度以及具体的格式要求。
  - 模型需在单轮对话内，根据输入的设定，创设合适情境并生成一组符合要求的题目。
- 评测数据收集:
  - 模型生成的题目将作为评测的完整数据。
## 评测指标
- 评测指标包含：五个一级指标（题目内容质量、答案解析质量、题目情境质量、教学辅助和价值观体现）。
  - 每个一级指标包含：指标描述、正例和反例。

<table border="1">
  <tr>
    <td>评估指标</td>
    <td rowspan="2" colspan="1">描述</td>
    <td rowspan="2" colspan="1">正例</td>
    <td rowspan="2" colspan="1">负例</td>
  </tr>
  <tr>
    <td>一级指标</td>
  </tr>
  <tr>
    <td>题目内容质量</td>
    <td>①题目表述清晰易懂，未出现含糊、容易引起误解的表述
②题目可解，正确解可以枚举，对于单选题应导向唯一的答案
③题目切实考察到了所指定考察的知识点，与课标要求相一致
④题目切实考察到了教师所提及的核心素养
⑤题目难度与所教师指定难度基本符合</td>
    <td>把65/9化为带分数().

A、7又5/9
B、7又2/9
C、6又5/9
D、6又2/9
【参考答案】B
【解析】因为7×9=63,
所以65/9=7又2/9, 故答案选:B.</td>
    <td>如解为无穷多个的题目：已知集合 A={2,3}，集合 B满足 A∩B={2}，则这样的集合B有()个。
如考察知识点与要求不一致的题目，如用此题考察四舍五入：小明有17.45元钱，他想要买一个价格为17.5元的笔记本，他够买吗？</td>
  </tr>
  <tr>
    <td>答案解析质量</td>
    <td>①题目答案准确无误，涵盖了所有可能的正确答案
②解析涵盖主流解题思路，并且与当前知识点密切相关，未涉及到超纲知识
③解析无明显步骤、思维跳跃，逻辑连贯清晰</td>
    <td>
连词成句，加上标点。(填序号)
①这是②一只③呀
④可爱的⑤小鸟⑥多么
答案：①②⑥④⑤③！
解析：先观察这些词语，“这是”是句子的起始部分，“一只”用来限定数量，“可爱的”修饰“小鸟”，“多么”加强语气，“呀”是感叹词，整句话表达对小鸟的喜爱，是感叹句，句末用感叹号，所以连成“这是多么可爱的一只小鸟呀!"故排序为:①⑥④②⑤③!</td>
    <td>连词成句，加上标点。
草地上 小兔子 在 吃草 快乐地
答案:
小兔子在草地上快乐地吃草。
解析：
本题主要考查二年级学生正确排列词语顺序的能力，需掌握”主语+地点状语+修饰语+谓语”的基本句式结
构
1.主语"小兔子"需放在句首
2.地点状语"在草地上"应紧跟主语
3.修饰语"快乐地"需紧贴动词"吃草
4.注意动词短语"吃草"不可拆分
5.句末要添加句号</td>
  </tr>
  <tr>
    <td>题目情境质量</td>
    <td>①情境来源于真实的现实生活，符合学生现有的认知水平
②情境背景与题目考察知识形成相融合的整体，而不是相互独立的
③题目情境表述清晰规范，结构简单
④题目情境故事符合中国社会主义价值观，立足“立德树人”</td>
    <td>小明在超市购买了一瓶牛奶，价格为5元，他付给售货员一张10元的纸币。请问小明会收到多少找零?
解答:
首先，我们需要计算小明付给售货员的钱与物品价格之间的差额。
物品价格:5 元
付款金额:10 元
差额=付款金额-物品价格
差额=10元-5 元
差额=5 元
因此，小明会收到5元的找零</td>
    <td>如情境与知识相互独立，未融合：
在学校的科学展览会上，小华和她的朋友们决定展示一个由小型立方体糖块组成的大立方体模型。如果这个大立方体模型的体积是 729 立方厘米，每个小立方体糖块的体积是 1 立方厘米，那么大立方体的边长是多少厘米？
如题目情境不符合立德树人对儿童价值观会产生错误引导的内容：如小明今天吃了40颗糖，如以饮酒为情境。
或题目情境不符合现实：小明的爷爷速度为100m/s</td>
  </tr>
  <tr>
    <td>教学辅助</td>
    <td>对话应具有良好的教学适用性，能够辅助教师实现教学目标。例如，所提供的内容能够引发学生的思考与讨论，所提供内容是否便于在课堂中开展引导性讲解或拓展，是否可以引出多种解法或多角度分析等。题目与解析应支持教师用于概念澄清、知识迁移、错因分析等常见教学环节，具有较强的教辅潜力。</td>
    <td>"题目设计能引导学生提出不同解法，如‘你还能用别的方法解吗？’",
"可作为复习或拓展题，例如‘请用两种方法解这道方程’。",
"适合教师课堂互动使用，如“预测结果”、“小组辩论”等。"</td>
    <td>"题目机械重复，无法用于教学讨论。",
"仅能直接套用公式，无法引发思考。",
"设计无法引出知识迁移或概念澄清机会。</td>
  </tr>
  <tr>
    <td>价值观体现</td>
    <td>对话应体现社会主义核心价值观，倡导诚信、环保、勤劳、友善、守法等正向观念。情境设计应避免涉及暴力、赌博、酗酒、成瘾行为、性别刻板印象、拜金主义等负面导向内容。若题目未体现价值导向但无明显问题，可中性评分；若有明显正向引导，则应给予高分。题目作为教育内容，应具备基本的育人导向和社会责任感。注意在评估该维度时你无需评估题干、情境、解析和对话其他部分的质量，只需要关注价值观即可</td>
    <td>以志愿服务、节约用水、劳动实践为题目背景，鼓励学生独立思考、助人为乐等行为, 以诚信、环保、爱国为价值引导主题。"</td>
    <td>设定中鼓励暴力、打架、攀比、成瘾行为（如抽盲盒、沉迷网游）,隐含性别歧视或偏见，如‘女生不擅长计算’, 情境引导消费主义，如“买50个限量款玩具”。</td>
  </tr>
</table>

## 评测案例
- 通过将10个不同的知识点、素养、年级、难度组合在一起，要求模型出题，而后结合用户要求和所生成的题目，构建了10个案例，旨在评估模型的出题能力。

<table border="1">
  <tr>
    <td>知识点</td>
    <td>素养</td>
    <td>年级</td>
    <td>难度</td>
  </tr>
  <tr>
    <td>四舍五入</td>
    <td>数感素养</td>
    <td>五年级上</td>
    <td>简单</td>
  </tr>
  <tr>
    <td>分数比较大小</td>
    <td>运算能力
数据意识</td>
    <td>五年级下</td>
    <td>困难</td>
  </tr>
  <tr>
    <td>一元一次方程-复习小结</td>
    <td>运算能力
推理能力
应用意识</td>
    <td>七年级上</td>
    <td>困难</td>
  </tr>
  <tr>
    <td>有序数对确定点的位置</td>
    <td>空间观念</td>
    <td>五年级上</td>
    <td>简单</td>
  </tr>
  <tr>
    <td>约分与最简分式</td>
    <td>运算能力</td>
    <td>八年级上</td>
    <td>中等</td>
  </tr>
  <tr>
    <td>公顷和平方千米</td>
    <td>量感
应用意识</td>
    <td>四年级上</td>
    <td>中等</td>
  </tr>
</table>

