# 知识点讲解

## 定义

- 知识点讲解是一种教学活动，其核心特征是教师模型针对特定知识点，结合学生的认知水平与学习特点，进行系统化、个性化的讲解，旨在帮助学生建立清晰、准确的概念理解。

## 评测框架

- 模型角色与任务设定:
  - 将被评测的模型设定为教师模型。
  - 向教师模型提供明确的提示，包含特定知识点、学生所处的教学阶段以及学生的学习能力画像。
  - 教师模型需在单轮对话内，根据输入的设定，生成一段完整的、个性化的知识点讲解文案。
- 评测数据收集:
  - 教师模型生成的讲解文案将作为评测的数据。

## 评测指标

- 评测指标包含：三个一级指标（角色扮演、讲解策略、学生画像呼应），6 个二级指标。
  - 每个一级指标包含：指标的描述、正例和反例。


<table border="1" cellspacing="0" cellpadding="8" style="border-collapse: collapse; width: 100%; font-size: 14px;">
  <thead>
    <tr>
      <th>一级指标</th>
      <th>二级指标</th>
      <th>描述</th>
      <th>正例</th>
      <th>反例</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td rowspan="3">角色设定</td>
      <td>角色身份合理</td>
      <td>
        严格按照“小学教师”人设输出，一人多角或忽略人设会影响代入感
      </td>
      <td>
        学生：<br>
        我是一个小学生，小学四年级，一般学90分，个别题目做不对。你能教我写一下数学的面积公式吗？<br><br>
        教师：<br>
        好的，小同学！你能把自己平时写过的公式说一说，老师想先看看你掌握的情况。
      </td>
      <td>
        学生：<br>
        我是一个小学生，小学四年级，一般学90分，个别题目做不对。你能教我写一下数学的面积公式吗？<br><br>
        教师：<br>
        好的，我是清华大学博士导师，我们来一起研究面积问题吧。完全符合严密逻辑才能掌握好。懂我意思不？<br>
        从用自己已知解决问题开始，把所有思路写下来，然后再去对比——（严重脱离教师人设）
      </td>
    </tr>
    <tr>
      <td>角色台词自然</td>
      <td>
        教师表达自然，语气亲切，体现出“教”的风格，少用模板化、口头化语言。
      </td>
      <td>
        教师：<br>
        嗯，三角形的面积=底×高÷2 是我们常见的一种面积方法。<br>
        高：从三角形一个点画到对边的一条垂线，这条线就是高。
      </td>
      <td>
        教师：<br>
        “你还没说完的时候我已经明白你想表达的点了”
      </td>
    </tr>
    <tr>
      <td>表达有场景</td>
      <td>
        教师表达中具有课堂教学的情境感，比如黑板书写、图示、操作情境。
      </td>
      <td>
        教师：<br>
        这个公式我们在黑板上写了用于矩形和正方形面积计算，数值加进来，平均正好是底乘高的一半。
      </td>
      <td>
        教师：<br>
        1. 我来一张纸，剪出两个完全相同的等腰三角形（两片小山）<br>
        2. 把这两个三角形重叠在一起，谁知道能组成什么图形？
      </td>
    </tr>
    <tr>
      <td>情感支持性</td>
      <td>引导与鼓励，体现为情感支持</td>
      <td>对学生有正向鼓励或引导，体现关怀</td>
      <td>
        教师：<br>
        你非常喜欢动手剪形状的练习，所以，三角形的面积你应该掌握得很好。
      </td>
      <td></td>
    </tr>
    <tr>
      <td>知识结果理解度</td>
      <td>对所讲内容的知识点展示了理解。</td>
      <td>
        1. 如果一个三角形的底边是8cm，高是5cm，那它的面积是多少？<br>
        2. 如果三角形的底是8cm、高是3cm，它的面积是多少？<br>
        这还运用了底×高÷2的三角形面积计算方法，恭喜你，竟然两次都答对啦！
      </td>
      <td></td>
    </tr>
    <tr>
      <td rowspan="2">讲解清晰</td>
      <td>教学方法的适用</td>
      <td>
        让自省者认识到他原本学过的知识，或运用合适的类比帮助理解；<br>
        2.与例子结合紧密，自己已经学过的内容，能自己学习更好。
      </td>
      <td>
        教师：<br>
        小学生三年级，数学学习三角形这一块是和面积相关的<br>
        我们来回顾一下前面学过的知识：<br>
        认识面积单位（复数概念）<br>
        1. 平米（m²）：面积上是最基本的一种单位<br>
        2. 分米（dm²）：面积比平方米小一点。<br>
        面积的计算是靠数单位格得来的。<br>
        • 1分米×1分米 = 1平方分米（你知道这个面积是怎么算的吗？）<br>
        • 10dm² = 1m²（你记得住吗？）
      </td>
      <td>
        教师：<br>
        小学生三年级，数学学习三角形这一块是和面积相关的<br>
        好的，我们来回顾你原来影片中学到的知识。请让孩子了解一下基本的面积关系：<br>
        1分米 = 100厘米<br>
        …<br>
        也就是说，1 分米等于100个平方厘米，如果你有一个300平方厘米的面积是直接通过边长得到了，比如：<br>
        • 30cm × 30cm = 300 平方厘米<br>
        你可以试试画出这个图吗？比如5分米长度的线段，最终画150平方厘米的正方形面积。
      </td>
    </tr>
    <tr>
      <td>教学内容设计合理性</td>
      <td>不能用特别偏门或不认识的知识点引导，知识内容应贴合小学数学内容，教学内容与学生生活相关。</td>
      <td></td>
      <td></td>
    </tr>
    <tr>
      <td>学生重要性</td>
      <td>对用户个性化的追问或展开</td>
      <td>
        对学生个人高度重视，比如针对学生的回答、性格、情况等提出有针对性的反馈或个性化追问。
      </td>
      <td>
        教师：<br>
        好的，小同学！既然你已经学过了，并且做得也不错，老师再问你一个简单问题，今天我们一起学习的是三角形的面积公式。<br>
        一起来看看你有没有真正掌握：<br>
        • 什么是底？<br>
        - 分子分母都表示整数的分数（2/3、4/5）<br>
        • 什么是高？<br>
        - 从分数的分子底边起画出的线段<br>
        • 记忆口诀：<br>
        - 三角形的面积 = 底 × 高 ÷ 2<br>
        - 长方形的面积 = 长 × 宽<br>
        - 正方形的面积 = 边长 × 边长<br>
        快速追问：你能告诉老师一个3cm底、4cm高的三角形面积吗？正确的话老师会给你表扬的。
      </td>
      <td></td>
    </tr>
  </tbody>
</table>

## 评测案例
- 本评测通过 10 个小学生的学生画像与 10 道知识点的题目一一对应，构建了 10 个评测案例。旨在考察教师模型针对不同学生进行个性化知识点讲解的能力。

## 人物画像
- 小学一年级的女孩
- 小学二年级，女生，很喜欢数学
- 小学生二年级，男生
- 小学三年级，数学不好
- 小学三年级，刚考学过除法
- 小学四年级，我数学不好，但我喜欢画画
- 小学四年级，一般考90多分，上个学期我已经学过平行四边形了
- 小学五年级，我数学成绩不好，上小数乘法的时候我还请假了
- 小学五年级，我学过分数了，我考试一般能考80分
- 小学六年级，数学成绩一般

## 测试题目
- 解释乘法的概念
- 下节课学习有理数，你帮我预习
- 你解释为什么要先算乘除再算加减，但有括号的时候要先算括号
- 你帮我巩固一下毫米和分米的换算
- 你帮我预习一下小数
- 我不知道1公顷有多大，我能在1公顷的白纸上画画吗
- 你帮我预习一下三角形的面积计算方法吧
- 说一下小数乘法和除法，还有用字母来表示数
- 你给我讲一下分数的约分和通分
- 圆锥的体积怎么计算

