"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserSourceLogConfig = exports.UserSourceLogConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudsiem_generated_1 = require("./cloudsiem.generated");
Object.defineProperty(exports, "UserSourceLogConfigProperty", { enumerable: true, get: function () { return cloudsiem_generated_1.RosUserSourceLogConfig; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::CloudSiem::UserSourceLogConfig`, which is used to add logs of a cloud service within an account.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosUserSourceLogConfig`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-cloudsiem-usersourcelogconfig
 */
class UserSourceLogConfig extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosUserSourceLogConfig = new cloudsiem_generated_1.RosUserSourceLogConfig(this, id, {
            sourceProdCode: props.sourceProdCode,
            subUserId: props.subUserId,
            sourceLogInfo: props.sourceLogInfo,
            sourceLogCode: props.sourceLogCode,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUserSourceLogConfig;
    }
}
exports.UserSourceLogConfig = UserSourceLogConfig;
//# sourceMappingURL=data:application/json;base64,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