from plexflow.core.storage.object.plexflow_storage import PlexflowObjectStore
from plexflow.core.context.plexflow_context import PlexflowContext
from plexflow.core.context.plexflow_property import PlexflowObjectProperty
from plexflow.core.metadata.providers.tmdb.datatypes import TmdbMovie
from typing import Union

class TMDbMetadataContext(PlexflowContext):
    """A class used to represent a Select Context in Plexflow.

    This class extends PlexflowContext and adds a selected item property.

    Attributes:
        selected_item (PlexflowObjectProperty): The selected item in the context.
    """

    def __init__(self, store: PlexflowObjectStore, **kwargs):
        """Initializes the SelectContext with the given object store and keyword arguments.

        Args:
            store (PlexflowObjectStore): The object store to be used.
            **kwargs: Arbitrary keyword arguments.
        """

        super().__init__(store=store, **kwargs)
        self.movie_details = PlexflowObjectProperty(self.object_store, "movie_details", local=True)

    @property
    def movie_data(self) -> Union[TmdbMovie, None]:
        """Gets the value of the selected item.

        Returns:
            Any: The value of the selected item.
        """

        return self.movie_details.value
    
    @movie_data.setter
    def movie_data(self, val: TmdbMovie):
        """Sets the value of the selected item.

        Args:
            val (Any): The value to be set.
        """

        self.movie_details.value = val
