import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AssociateRoleAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * The auth method to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method#am_name AssociateRoleAuthMethod#am_name}
    */
    readonly amName: string;
    /**
    * Treat sub claims as case-sensitive
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method#case_sensitive AssociateRoleAuthMethod#case_sensitive}
    */
    readonly caseSensitive?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method#id AssociateRoleAuthMethod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The role to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method#role_name AssociateRoleAuthMethod#role_name}
    */
    readonly roleName: string;
    /**
    * key/val of sub claims, e.g group=admins,developers
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method#sub_claims AssociateRoleAuthMethod#sub_claims}
    */
    readonly subClaims?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method akeyless_associate_role_auth_method}
*/
export declare class AssociateRoleAuthMethod extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_associate_role_auth_method";
    /**
    * Generates CDKTF code for importing a AssociateRoleAuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AssociateRoleAuthMethod to import
    * @param importFromId The id of the existing AssociateRoleAuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AssociateRoleAuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/associate_role_auth_method akeyless_associate_role_auth_method} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AssociateRoleAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: AssociateRoleAuthMethodConfig);
    private _amName?;
    get amName(): string;
    set amName(value: string);
    get amNameInput(): string | undefined;
    private _caseSensitive?;
    get caseSensitive(): string;
    set caseSensitive(value: string);
    resetCaseSensitive(): void;
    get caseSensitiveInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _subClaims?;
    get subClaims(): {
        [key: string]: string;
    };
    set subClaims(value: {
        [key: string]: string;
    });
    resetSubClaims(): void;
    get subClaimsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
