import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodApiKeyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#access_expires AuthMethodApiKeyA#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#audit_logs_claims AuthMethodApiKeyA#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#bound_ips AuthMethodApiKeyA#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#delete_protection AuthMethodApiKeyA#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#force_sub_claims AuthMethodApiKeyA#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#id AuthMethodApiKeyA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#jwt_ttl AuthMethodApiKeyA#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#name AuthMethodApiKeyA#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key akeyless_auth_method_api_key}
*/
export declare class AuthMethodApiKeyA extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_api_key";
    /**
    * Generates CDKTF code for importing a AuthMethodApiKeyA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodApiKeyA to import
    * @param importFromId The id of the existing AuthMethodApiKeyA that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodApiKeyA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_api_key akeyless_auth_method_api_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodApiKeyAConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodApiKeyAConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    get accessKey(): string;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
