import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodAwsIamAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#access_expires AuthMethodAwsIamA#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#audit_logs_claims AuthMethodAwsIamA#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A list of full arns that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_arn AuthMethodAwsIamA#bound_arn}
    */
    readonly boundArn?: string[];
    /**
    * A list of AWS account-IDs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_aws_account_id AuthMethodAwsIamA#bound_aws_account_id}
    */
    readonly boundAwsAccountId: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_ips AuthMethodAwsIamA#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * A list of full resource ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_resource_id AuthMethodAwsIamA#bound_resource_id}
    */
    readonly boundResourceId?: string[];
    /**
    * A list of full role ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_role_id AuthMethodAwsIamA#bound_role_id}
    */
    readonly boundRoleId?: string[];
    /**
    * A list of full role-name that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_role_name AuthMethodAwsIamA#bound_role_name}
    */
    readonly boundRoleName?: string[];
    /**
    * A list of full user ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_user_id AuthMethodAwsIamA#bound_user_id}
    */
    readonly boundUserId?: string[];
    /**
    * A list of full user-name that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#bound_user_name AuthMethodAwsIamA#bound_user_name}
    */
    readonly boundUserName?: string[];
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#delete_protection AuthMethodAwsIamA#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#force_sub_claims AuthMethodAwsIamA#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#id AuthMethodAwsIamA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#jwt_ttl AuthMethodAwsIamA#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#name AuthMethodAwsIamA#name}
    */
    readonly name: string;
    /**
    *  sts URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#sts_url AuthMethodAwsIamA#sts_url}
    */
    readonly stsUrl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam akeyless_auth_method_aws_iam}
*/
export declare class AuthMethodAwsIamA extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_aws_iam";
    /**
    * Generates CDKTF code for importing a AuthMethodAwsIamA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodAwsIamA to import
    * @param importFromId The id of the existing AuthMethodAwsIamA that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodAwsIamA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_aws_iam akeyless_auth_method_aws_iam} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodAwsIamAConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodAwsIamAConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundArn?;
    get boundArn(): string[];
    set boundArn(value: string[]);
    resetBoundArn(): void;
    get boundArnInput(): string[] | undefined;
    private _boundAwsAccountId?;
    get boundAwsAccountId(): string[];
    set boundAwsAccountId(value: string[]);
    get boundAwsAccountIdInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _boundResourceId?;
    get boundResourceId(): string[];
    set boundResourceId(value: string[]);
    resetBoundResourceId(): void;
    get boundResourceIdInput(): string[] | undefined;
    private _boundRoleId?;
    get boundRoleId(): string[];
    set boundRoleId(value: string[]);
    resetBoundRoleId(): void;
    get boundRoleIdInput(): string[] | undefined;
    private _boundRoleName?;
    get boundRoleName(): string[];
    set boundRoleName(value: string[]);
    resetBoundRoleName(): void;
    get boundRoleNameInput(): string[] | undefined;
    private _boundUserId?;
    get boundUserId(): string[];
    set boundUserId(value: string[]);
    resetBoundUserId(): void;
    get boundUserIdInput(): string[] | undefined;
    private _boundUserName?;
    get boundUserName(): string[];
    set boundUserName(value: string[]);
    resetBoundUserName(): void;
    get boundUserNameInput(): string[] | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stsUrl?;
    get stsUrl(): string;
    set stsUrl(value: string);
    resetStsUrl(): void;
    get stsUrlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
