import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodGcpAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#access_expires AuthMethodGcpA#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * The audience to verify in the JWT received by the client
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#audience AuthMethodGcpA#audience}
    */
    readonly audience?: string;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#audit_logs_claims AuthMethodGcpA#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#bound_ips AuthMethodGcpA#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * GCE only. A list of GCP labels formatted as key:value pairs that must be set on instances in order to authenticate. For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#bound_labels AuthMethodGcpA#bound_labels}
    */
    readonly boundLabels?: string[];
    /**
    * A list of GCP project IDs. Clients must belong to any of the provided projects in order to authenticate. For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#bound_projects AuthMethodGcpA#bound_projects}
    */
    readonly boundProjects?: string[];
    /**
    * GCE only. A list of regions. GCE instances must belong to any of the provided regions in order to authenticate. For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#bound_regions AuthMethodGcpA#bound_regions}
    */
    readonly boundRegions?: string[];
    /**
    * A list of Service Accounts. Clients must belong to any of the provided service accounts in order to authenticate. For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#bound_service_accounts AuthMethodGcpA#bound_service_accounts}
    */
    readonly boundServiceAccounts?: string[];
    /**
    * GCE only. A list of zones. GCE instances must belong to any of the provided zones in order to authenticate. For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#bound_zones AuthMethodGcpA#bound_zones}
    */
    readonly boundZones?: string[];
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#delete_protection AuthMethodGcpA#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#force_sub_claims AuthMethodGcpA#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#id AuthMethodGcpA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#jwt_ttl AuthMethodGcpA#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#name AuthMethodGcpA#name}
    */
    readonly name: string;
    /**
    * Service Account creds data, base64 encoded
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#service_account_creds_data AuthMethodGcpA#service_account_creds_data}
    */
    readonly serviceAccountCredsData?: string;
    /**
    * The type of the GCP Auth Method (iam/gce)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#type AuthMethodGcpA#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp akeyless_auth_method_gcp}
*/
export declare class AuthMethodGcpA extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_gcp";
    /**
    * Generates CDKTF code for importing a AuthMethodGcpA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodGcpA to import
    * @param importFromId The id of the existing AuthMethodGcpA that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodGcpA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_gcp akeyless_auth_method_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodGcpAConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodGcpAConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _boundLabels?;
    get boundLabels(): string[];
    set boundLabels(value: string[]);
    resetBoundLabels(): void;
    get boundLabelsInput(): string[] | undefined;
    private _boundProjects?;
    get boundProjects(): string[];
    set boundProjects(value: string[]);
    resetBoundProjects(): void;
    get boundProjectsInput(): string[] | undefined;
    private _boundRegions?;
    get boundRegions(): string[];
    set boundRegions(value: string[]);
    resetBoundRegions(): void;
    get boundRegionsInput(): string[] | undefined;
    private _boundServiceAccounts?;
    get boundServiceAccounts(): string[];
    set boundServiceAccounts(value: string[]);
    resetBoundServiceAccounts(): void;
    get boundServiceAccountsInput(): string[] | undefined;
    private _boundZones?;
    get boundZones(): string[];
    set boundZones(value: string[]);
    resetBoundZones(): void;
    get boundZonesInput(): string[] | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serviceAccountCredsData?;
    get serviceAccountCredsData(): string;
    set serviceAccountCredsData(value: string);
    resetServiceAccountCredsData(): void;
    get serviceAccountCredsDataInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
