import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodK8SConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#access_expires AuthMethodK8S#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * The audience in the Kubernetes JWT that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#audience AuthMethodK8S#audience}
    */
    readonly audience?: string;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#audit_logs_claims AuthMethodK8S#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#bound_ips AuthMethodK8S#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * A list of namespaces that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#bound_namespaces AuthMethodK8S#bound_namespaces}
    */
    readonly boundNamespaces?: string[];
    /**
    * A list of pod names that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#bound_pod_names AuthMethodK8S#bound_pod_names}
    */
    readonly boundPodNames?: string[];
    /**
    * A list of service account names that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#bound_sa_names AuthMethodK8S#bound_sa_names}
    */
    readonly boundSaNames?: string[];
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#delete_protection AuthMethodK8S#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#force_sub_claims AuthMethodK8S#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * If this flag is set to true, there is no need to manually provide a public key for the Kubernetes Auth Method, and instead, a key pair, will be generated as part of the command and the private part of the key will be returned (the private key is required for the K8S Auth Config in the Akeyless Gateway)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#gen_key AuthMethodK8S#gen_key}
    */
    readonly genKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#id AuthMethodK8S#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#jwt_ttl AuthMethodK8S#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#name AuthMethodK8S#name}
    */
    readonly name: string;
    /**
    * The generated public key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#public_key AuthMethodK8S#public_key}
    */
    readonly publicKey?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s akeyless_auth_method_k8s}
*/
export declare class AuthMethodK8S extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_k8s";
    /**
    * Generates CDKTF code for importing a AuthMethodK8S resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodK8S to import
    * @param importFromId The id of the existing AuthMethodK8S that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodK8S to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_k8s akeyless_auth_method_k8s} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodK8SConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodK8SConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _boundNamespaces?;
    get boundNamespaces(): string[];
    set boundNamespaces(value: string[]);
    resetBoundNamespaces(): void;
    get boundNamespacesInput(): string[] | undefined;
    private _boundPodNames?;
    get boundPodNames(): string[];
    set boundPodNames(value: string[]);
    resetBoundPodNames(): void;
    get boundPodNamesInput(): string[] | undefined;
    private _boundSaNames?;
    get boundSaNames(): string[];
    set boundSaNames(value: string[]);
    resetBoundSaNames(): void;
    get boundSaNamesInput(): string[] | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _genKey?;
    get genKey(): string;
    set genKey(value: string);
    resetGenKey(): void;
    get genKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateKey(): string;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    resetPublicKey(): void;
    get publicKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
