import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodOauth2Config extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#access_expires AuthMethodOauth2#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * The audience in the JWT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#audience AuthMethodOauth2#audience}
    */
    readonly audience?: string;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#audit_logs_claims AuthMethodOauth2#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * The clients ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#bound_client_ids AuthMethodOauth2#bound_client_ids}
    */
    readonly boundClientIds?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#bound_ips AuthMethodOauth2#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#delete_protection AuthMethodOauth2#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#force_sub_claims AuthMethodOauth2#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Akeyless Gateway URL (Configuration Management port). Relevant only when the jwks-uri is accessible only from the gateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#gateway_url AuthMethodOauth2#gateway_url}
    */
    readonly gatewayUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#id AuthMethodOauth2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Issuer URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#issuer AuthMethodOauth2#issuer}
    */
    readonly issuer?: string;
    /**
    * The JSON Web Key Set (JWKS) containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization serve, in base64 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#jwks_json_data AuthMethodOauth2#jwks_json_data}
    */
    readonly jwksJsonData?: string;
    /**
    * The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#jwks_uri AuthMethodOauth2#jwks_uri}
    */
    readonly jwksUri?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#jwt_ttl AuthMethodOauth2#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#name AuthMethodOauth2#name}
    */
    readonly name: string;
    /**
    * A unique identifier (ID) value should be configured for OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a sub claim that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#unique_identifier AuthMethodOauth2#unique_identifier}
    */
    readonly uniqueIdentifier: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2 akeyless_auth_method_oauth2}
*/
export declare class AuthMethodOauth2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_oauth2";
    /**
    * Generates CDKTF code for importing a AuthMethodOauth2 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodOauth2 to import
    * @param importFromId The id of the existing AuthMethodOauth2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodOauth2 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oauth2 akeyless_auth_method_oauth2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodOauth2Config
    */
    constructor(scope: Construct, id: string, config: AuthMethodOauth2Config);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundClientIds?;
    get boundClientIds(): string[];
    set boundClientIds(value: string[]);
    resetBoundClientIds(): void;
    get boundClientIdsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _gatewayUrl?;
    get gatewayUrl(): string;
    set gatewayUrl(value: string);
    resetGatewayUrl(): void;
    get gatewayUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _jwksJsonData?;
    get jwksJsonData(): string;
    set jwksJsonData(value: string);
    resetJwksJsonData(): void;
    get jwksJsonDataInput(): string | undefined;
    private _jwksUri?;
    get jwksUri(): string;
    set jwksUri(value: string);
    resetJwksUri(): void;
    get jwksUriInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _uniqueIdentifier?;
    get uniqueIdentifier(): string;
    set uniqueIdentifier(value: string);
    get uniqueIdentifierInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
