import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodOidcConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#access_expires AuthMethodOidc#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * Allowed redirect URIs after the authentication (default is https://console.akeyless.io/login-oidc to enable OIDC via Akeyless Console and  http://127.0.0.1:* to enable OIDC via akeyless CLI)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#allowed_redirect_uri AuthMethodOidc#allowed_redirect_uri}
    */
    readonly allowedRedirectUri?: string[];
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#audit_logs_claims AuthMethodOidc#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#bound_ips AuthMethodOidc#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * Client ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#client_id AuthMethodOidc#client_id}
    */
    readonly clientId?: string;
    /**
    * Client Secret
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#client_secret AuthMethodOidc#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#delete_protection AuthMethodOidc#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#force_sub_claims AuthMethodOidc#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#id AuthMethodOidc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Issuer URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#issuer AuthMethodOidc#issuer}
    */
    readonly issuer?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#jwt_ttl AuthMethodOidc#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#name AuthMethodOidc#name}
    */
    readonly name: string;
    /**
    * Required scopes that the oidc method will request from the oidc provider and the user must approve
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#required_scopes AuthMethodOidc#required_scopes}
    */
    readonly requiredScopes?: string[];
    /**
    * A prefix to add to all required-scopes when requesting them from the oidc server (for example, azure's Application ID URI)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#required_scopes_prefix AuthMethodOidc#required_scopes_prefix}
    */
    readonly requiredScopesPrefix?: string;
    /**
    * A unique identifier (ID) value should be configured for OIDC, OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a sub claim that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#unique_identifier AuthMethodOidc#unique_identifier}
    */
    readonly uniqueIdentifier: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc akeyless_auth_method_oidc}
*/
export declare class AuthMethodOidc extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_oidc";
    /**
    * Generates CDKTF code for importing a AuthMethodOidc resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodOidc to import
    * @param importFromId The id of the existing AuthMethodOidc that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodOidc to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_oidc akeyless_auth_method_oidc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodOidcConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodOidcConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _allowedRedirectUri?;
    get allowedRedirectUri(): string[];
    set allowedRedirectUri(value: string[]);
    resetAllowedRedirectUri(): void;
    get allowedRedirectUriInput(): string[] | undefined;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requiredScopes?;
    get requiredScopes(): string[];
    set requiredScopes(value: string[]);
    resetRequiredScopes(): void;
    get requiredScopesInput(): string[] | undefined;
    private _requiredScopesPrefix?;
    get requiredScopesPrefix(): string;
    set requiredScopesPrefix(value: string);
    resetRequiredScopesPrefix(): void;
    get requiredScopesPrefixInput(): string | undefined;
    private _uniqueIdentifier?;
    get uniqueIdentifier(): string;
    set uniqueIdentifier(value: string);
    get uniqueIdentifierInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
