import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessAuthConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#id DataAkeylessAuth#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * api_key_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#api_key_login DataAkeylessAuth#api_key_login}
    */
    readonly apiKeyLogin?: DataAkeylessAuthApiKeyLogin[] | cdktf.IResolvable;
    /**
    * aws_iam_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#aws_iam_login DataAkeylessAuth#aws_iam_login}
    */
    readonly awsIamLogin?: DataAkeylessAuthAwsIamLogin[] | cdktf.IResolvable;
    /**
    * azure_ad_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#azure_ad_login DataAkeylessAuth#azure_ad_login}
    */
    readonly azureAdLogin?: DataAkeylessAuthAzureAdLogin[] | cdktf.IResolvable;
    /**
    * cert_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#cert_login DataAkeylessAuth#cert_login}
    */
    readonly certLogin?: DataAkeylessAuthCertLogin[] | cdktf.IResolvable;
    /**
    * email_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#email_login DataAkeylessAuth#email_login}
    */
    readonly emailLogin?: DataAkeylessAuthEmailLogin[] | cdktf.IResolvable;
    /**
    * gcp_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#gcp_login DataAkeylessAuth#gcp_login}
    */
    readonly gcpLogin?: DataAkeylessAuthGcpLogin[] | cdktf.IResolvable;
    /**
    * jwt_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#jwt_login DataAkeylessAuth#jwt_login}
    */
    readonly jwtLogin?: DataAkeylessAuthJwtLogin[] | cdktf.IResolvable;
    /**
    * uid_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#uid_login DataAkeylessAuth#uid_login}
    */
    readonly uidLogin?: DataAkeylessAuthUidLogin[] | cdktf.IResolvable;
}
export interface DataAkeylessAuthApiKeyLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_key DataAkeylessAuth#access_key}
    */
    readonly accessKey: string;
}
export declare function dataAkeylessAuthApiKeyLoginToTerraform(struct?: DataAkeylessAuthApiKeyLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthApiKeyLoginToHclTerraform(struct?: DataAkeylessAuthApiKeyLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthApiKeyLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthApiKeyLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthApiKeyLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
}
export declare class DataAkeylessAuthApiKeyLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthApiKeyLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthApiKeyLoginOutputReference;
}
export interface DataAkeylessAuthAwsIamLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId: string;
}
export declare function dataAkeylessAuthAwsIamLoginToTerraform(struct?: DataAkeylessAuthAwsIamLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthAwsIamLoginToHclTerraform(struct?: DataAkeylessAuthAwsIamLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthAwsIamLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthAwsIamLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthAwsIamLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
}
export declare class DataAkeylessAuthAwsIamLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthAwsIamLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthAwsIamLoginOutputReference;
}
export interface DataAkeylessAuthAzureAdLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId: string;
}
export declare function dataAkeylessAuthAzureAdLoginToTerraform(struct?: DataAkeylessAuthAzureAdLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthAzureAdLoginToHclTerraform(struct?: DataAkeylessAuthAzureAdLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthAzureAdLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthAzureAdLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthAzureAdLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
}
export declare class DataAkeylessAuthAzureAdLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthAzureAdLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthAzureAdLoginOutputReference;
}
export interface DataAkeylessAuthCertLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#cert_data DataAkeylessAuth#cert_data}
    */
    readonly certData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#cert_file_name DataAkeylessAuth#cert_file_name}
    */
    readonly certFileName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#key_data DataAkeylessAuth#key_data}
    */
    readonly keyData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#key_file_name DataAkeylessAuth#key_file_name}
    */
    readonly keyFileName?: string;
}
export declare function dataAkeylessAuthCertLoginToTerraform(struct?: DataAkeylessAuthCertLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthCertLoginToHclTerraform(struct?: DataAkeylessAuthCertLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthCertLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthCertLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthCertLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
    private _certData?;
    get certData(): string;
    set certData(value: string);
    resetCertData(): void;
    get certDataInput(): string | undefined;
    private _certFileName?;
    get certFileName(): string;
    set certFileName(value: string);
    resetCertFileName(): void;
    get certFileNameInput(): string | undefined;
    private _keyData?;
    get keyData(): string;
    set keyData(value: string);
    resetKeyData(): void;
    get keyDataInput(): string | undefined;
    private _keyFileName?;
    get keyFileName(): string;
    set keyFileName(value: string);
    resetKeyFileName(): void;
    get keyFileNameInput(): string | undefined;
}
export declare class DataAkeylessAuthCertLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthCertLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthCertLoginOutputReference;
}
export interface DataAkeylessAuthEmailLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#admin_email DataAkeylessAuth#admin_email}
    */
    readonly adminEmail: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#admin_password DataAkeylessAuth#admin_password}
    */
    readonly adminPassword: string;
}
export declare function dataAkeylessAuthEmailLoginToTerraform(struct?: DataAkeylessAuthEmailLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthEmailLoginToHclTerraform(struct?: DataAkeylessAuthEmailLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthEmailLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthEmailLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthEmailLogin | cdktf.IResolvable | undefined);
    private _adminEmail?;
    get adminEmail(): string;
    set adminEmail(value: string);
    get adminEmailInput(): string | undefined;
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
}
export declare class DataAkeylessAuthEmailLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthEmailLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthEmailLoginOutputReference;
}
export interface DataAkeylessAuthGcpLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#audience DataAkeylessAuth#audience}
    */
    readonly audience?: string;
}
export declare function dataAkeylessAuthGcpLoginToTerraform(struct?: DataAkeylessAuthGcpLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthGcpLoginToHclTerraform(struct?: DataAkeylessAuthGcpLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthGcpLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthGcpLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthGcpLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
}
export declare class DataAkeylessAuthGcpLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthGcpLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthGcpLoginOutputReference;
}
export interface DataAkeylessAuthJwtLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#jwt DataAkeylessAuth#jwt}
    */
    readonly jwt: string;
}
export declare function dataAkeylessAuthJwtLoginToTerraform(struct?: DataAkeylessAuthJwtLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthJwtLoginToHclTerraform(struct?: DataAkeylessAuthJwtLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthJwtLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthJwtLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthJwtLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
    private _jwt?;
    get jwt(): string;
    set jwt(value: string);
    get jwtInput(): string | undefined;
}
export declare class DataAkeylessAuthJwtLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthJwtLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthJwtLoginOutputReference;
}
export interface DataAkeylessAuthUidLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#access_id DataAkeylessAuth#access_id}
    */
    readonly accessId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#uid_token DataAkeylessAuth#uid_token}
    */
    readonly uidToken: string;
}
export declare function dataAkeylessAuthUidLoginToTerraform(struct?: DataAkeylessAuthUidLogin | cdktf.IResolvable): any;
export declare function dataAkeylessAuthUidLoginToHclTerraform(struct?: DataAkeylessAuthUidLogin | cdktf.IResolvable): any;
export declare class DataAkeylessAuthUidLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAkeylessAuthUidLogin | cdktf.IResolvable | undefined;
    set internalValue(value: DataAkeylessAuthUidLogin | cdktf.IResolvable | undefined);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    resetAccessId(): void;
    get accessIdInput(): string | undefined;
    private _uidToken?;
    get uidToken(): string;
    set uidToken(value: string);
    get uidTokenInput(): string | undefined;
}
export declare class DataAkeylessAuthUidLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAkeylessAuthUidLogin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAkeylessAuthUidLoginOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth akeyless_auth}
*/
export declare class DataAkeylessAuth extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_auth";
    /**
    * Generates CDKTF code for importing a DataAkeylessAuth resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessAuth to import
    * @param importFromId The id of the existing DataAkeylessAuth that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessAuth to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth akeyless_auth} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessAuthConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAkeylessAuthConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get token(): string;
    private _apiKeyLogin;
    get apiKeyLogin(): DataAkeylessAuthApiKeyLoginList;
    putApiKeyLogin(value: DataAkeylessAuthApiKeyLogin[] | cdktf.IResolvable): void;
    resetApiKeyLogin(): void;
    get apiKeyLoginInput(): cdktf.IResolvable | DataAkeylessAuthApiKeyLogin[] | undefined;
    private _awsIamLogin;
    get awsIamLogin(): DataAkeylessAuthAwsIamLoginList;
    putAwsIamLogin(value: DataAkeylessAuthAwsIamLogin[] | cdktf.IResolvable): void;
    resetAwsIamLogin(): void;
    get awsIamLoginInput(): cdktf.IResolvable | DataAkeylessAuthAwsIamLogin[] | undefined;
    private _azureAdLogin;
    get azureAdLogin(): DataAkeylessAuthAzureAdLoginList;
    putAzureAdLogin(value: DataAkeylessAuthAzureAdLogin[] | cdktf.IResolvable): void;
    resetAzureAdLogin(): void;
    get azureAdLoginInput(): cdktf.IResolvable | DataAkeylessAuthAzureAdLogin[] | undefined;
    private _certLogin;
    get certLogin(): DataAkeylessAuthCertLoginList;
    putCertLogin(value: DataAkeylessAuthCertLogin[] | cdktf.IResolvable): void;
    resetCertLogin(): void;
    get certLoginInput(): cdktf.IResolvable | DataAkeylessAuthCertLogin[] | undefined;
    private _emailLogin;
    get emailLogin(): DataAkeylessAuthEmailLoginList;
    putEmailLogin(value: DataAkeylessAuthEmailLogin[] | cdktf.IResolvable): void;
    resetEmailLogin(): void;
    get emailLoginInput(): cdktf.IResolvable | DataAkeylessAuthEmailLogin[] | undefined;
    private _gcpLogin;
    get gcpLogin(): DataAkeylessAuthGcpLoginList;
    putGcpLogin(value: DataAkeylessAuthGcpLogin[] | cdktf.IResolvable): void;
    resetGcpLogin(): void;
    get gcpLoginInput(): cdktf.IResolvable | DataAkeylessAuthGcpLogin[] | undefined;
    private _jwtLogin;
    get jwtLogin(): DataAkeylessAuthJwtLoginList;
    putJwtLogin(value: DataAkeylessAuthJwtLogin[] | cdktf.IResolvable): void;
    resetJwtLogin(): void;
    get jwtLoginInput(): cdktf.IResolvable | DataAkeylessAuthJwtLogin[] | undefined;
    private _uidLogin;
    get uidLogin(): DataAkeylessAuthUidLoginList;
    putUidLogin(value: DataAkeylessAuthUidLogin[] | cdktf.IResolvable): void;
    resetUidLogin(): void;
    get uidLoginInput(): cdktf.IResolvable | DataAkeylessAuthUidLogin[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
