import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessDetokenizeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Data to be decrypted
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize#ciphertext DataAkeylessDetokenize#ciphertext}
    */
    readonly ciphertext: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize#id DataAkeylessDetokenize#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the tokenizer to use in the decryption process
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize#tokenizer_name DataAkeylessDetokenize#tokenizer_name}
    */
    readonly tokenizerName: string;
    /**
    * Base64 encoded tweak for vaultless encryption
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize#tweak DataAkeylessDetokenize#tweak}
    */
    readonly tweak?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize akeyless_detokenize}
*/
export declare class DataAkeylessDetokenize extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_detokenize";
    /**
    * Generates CDKTF code for importing a DataAkeylessDetokenize resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessDetokenize to import
    * @param importFromId The id of the existing DataAkeylessDetokenize that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessDetokenize to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/detokenize akeyless_detokenize} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessDetokenizeConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessDetokenizeConfig);
    private _ciphertext?;
    get ciphertext(): string;
    set ciphertext(value: string);
    get ciphertextInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get result(): string;
    private _tokenizerName?;
    get tokenizerName(): string;
    set tokenizerName(value: string);
    get tokenizerNameInput(): string | undefined;
    private _tweak?;
    get tweak(): string;
    set tweak(value: string);
    resetTweak(): void;
    get tweakInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
