import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessK8SAuthConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * K8S Auth config name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/k8s_auth_config#name DataAkeylessK8SAuthConfig#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/k8s_auth_config akeyless_k8s_auth_config}
*/
export declare class DataAkeylessK8SAuthConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_k8s_auth_config";
    /**
    * Generates CDKTF code for importing a DataAkeylessK8SAuthConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessK8SAuthConfig to import
    * @param importFromId The id of the existing DataAkeylessK8SAuthConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/k8s_auth_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessK8SAuthConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/k8s_auth_config akeyless_k8s_auth_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessK8SAuthConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessK8SAuthConfigConfig);
    get amTokenExpiration(): number;
    get authMethodAccessId(): string;
    get authMethodPrvKeyPem(): string;
    get disableIssValidation(): cdktf.IResolvable;
    get id(): string;
    get k8SCaCert(): string;
    get k8SHost(): string;
    get k8SIssuer(): string;
    get k8SPubKeysPem(): string[];
    get k8STokenReviewerJwt(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get protectionKey(): string;
    get useLocalCaJwt(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
