import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessKubeExecCredsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Subject Alternative Names to be included in the PKI certificate (in a comma-delimited list)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#alt_names DataAkeylessKubeExecCreds#alt_names}
    */
    readonly altNames?: string;
    /**
    * The name of the PKI certificate issuer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#cert_issuer_name DataAkeylessKubeExecCreds#cert_issuer_name}
    */
    readonly certIssuerName: string;
    /**
    * The common name to be included in the PKI certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#common_name DataAkeylessKubeExecCreds#common_name}
    */
    readonly commonName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#id DataAkeylessKubeExecCreds#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * pki key file contents encoded using Base64. If this option is used, the certificate will be printed to stdout
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#key_data_base64 DataAkeylessKubeExecCreds#key_data_base64}
    */
    readonly keyDataBase64?: string;
    /**
    * The URI Subject Alternative Names to be included in the PKI certificate (in a comma-delimited list)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#uri_sans DataAkeylessKubeExecCreds#uri_sans}
    */
    readonly uriSans?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds akeyless_kube_exec_creds}
*/
export declare class DataAkeylessKubeExecCreds extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_kube_exec_creds";
    /**
    * Generates CDKTF code for importing a DataAkeylessKubeExecCreds resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessKubeExecCreds to import
    * @param importFromId The id of the existing DataAkeylessKubeExecCreds that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessKubeExecCreds to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/kube_exec_creds akeyless_kube_exec_creds} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessKubeExecCredsConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessKubeExecCredsConfig);
    private _altNames?;
    get altNames(): string;
    set altNames(value: string);
    resetAltNames(): void;
    get altNamesInput(): string | undefined;
    get apiVersion(): string;
    private _certIssuerName?;
    get certIssuerName(): string;
    set certIssuerName(value: string);
    get certIssuerNameInput(): string | undefined;
    get clientCertificateData(): string;
    get clientKeyData(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    resetCommonName(): void;
    get commonNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyDataBase64?;
    get keyDataBase64(): string;
    set keyDataBase64(value: string);
    resetKeyDataBase64(): void;
    get keyDataBase64Input(): string | undefined;
    get kind(): string;
    get parentCertificateData(): string;
    private _uriSans?;
    get uriSans(): string;
    set uriSans(value: string);
    resetUriSans(): void;
    get uriSansInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
