import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessRotatedSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret#id DataAkeylessRotatedSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Retrieve the Secret value without checking the Gateway's cache [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret#ignore_cache DataAkeylessRotatedSecret#ignore_cache}
    */
    readonly ignoreCache?: string;
    /**
    * Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret#name DataAkeylessRotatedSecret#name}
    */
    readonly name: string;
    /**
    * Secret version
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret#version DataAkeylessRotatedSecret#version}
    */
    readonly version?: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret akeyless_rotated_secret}
*/
export declare class DataAkeylessRotatedSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_rotated_secret";
    /**
    * Generates CDKTF code for importing a DataAkeylessRotatedSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessRotatedSecret to import
    * @param importFromId The id of the existing DataAkeylessRotatedSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessRotatedSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/rotated_secret akeyless_rotated_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessRotatedSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessRotatedSecretConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreCache?;
    get ignoreCache(): string;
    set ignoreCache(value: string);
    resetIgnoreCache(): void;
    get ignoreCacheInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get value(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
