import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessSshCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the SSH certificate issuer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#cert_issuer_name DataAkeylessSshCertificate#cert_issuer_name}
    */
    readonly certIssuerName: string;
    /**
    * The username to sign in the SSH certificate (use a comma-separated list for more than one username)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#cert_username DataAkeylessSshCertificate#cert_username}
    */
    readonly certUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#id DataAkeylessSshCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set this option to output legacy ('ssh-rsa-cert-v01@openssh.com') signing algorithm name in the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#legacy_signing_alg_name DataAkeylessSshCertificate#legacy_signing_alg_name}
    */
    readonly legacySigningAlgName?: boolean | cdktf.IResolvable;
    /**
    * SSH public key file contents
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#public_key_data DataAkeylessSshCertificate#public_key_data}
    */
    readonly publicKeyData: string;
    /**
    * Updated certificate lifetime in seconds (must be less than the Certificate Issuer default TTL)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#ttl DataAkeylessSshCertificate#ttl}
    */
    readonly ttl?: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate akeyless_ssh_certificate}
*/
export declare class DataAkeylessSshCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_ssh_certificate";
    /**
    * Generates CDKTF code for importing a DataAkeylessSshCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessSshCertificate to import
    * @param importFromId The id of the existing DataAkeylessSshCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessSshCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/ssh_certificate akeyless_ssh_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessSshCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessSshCertificateConfig);
    private _certIssuerName?;
    get certIssuerName(): string;
    set certIssuerName(value: string);
    get certIssuerNameInput(): string | undefined;
    private _certUsername?;
    get certUsername(): string;
    set certUsername(value: string);
    get certUsernameInput(): string | undefined;
    get data(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _legacySigningAlgName?;
    get legacySigningAlgName(): boolean | cdktf.IResolvable;
    set legacySigningAlgName(value: boolean | cdktf.IResolvable);
    resetLegacySigningAlgName(): void;
    get legacySigningAlgNameInput(): boolean | cdktf.IResolvable | undefined;
    private _publicKeyData?;
    get publicKeyData(): string;
    set publicKeyData(value: string);
    get publicKeyDataInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
