import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessStaticSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret#id DataAkeylessStaticSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Retrieve the Secret value without checking the Gateway's cache [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret#ignore_cache DataAkeylessStaticSecret#ignore_cache}
    */
    readonly ignoreCache?: string;
    /**
    * The path where the secret is stored. Defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret#path DataAkeylessStaticSecret#path}
    */
    readonly path: string;
    /**
    * The version of the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret#version DataAkeylessStaticSecret#version}
    */
    readonly version?: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret akeyless_static_secret}
*/
export declare class DataAkeylessStaticSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_static_secret";
    /**
    * Generates CDKTF code for importing a DataAkeylessStaticSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessStaticSecret to import
    * @param importFromId The id of the existing DataAkeylessStaticSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessStaticSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/static_secret akeyless_static_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessStaticSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessStaticSecretConfig);
    private _customField;
    get customField(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreCache?;
    get ignoreCache(): string;
    set ignoreCache(value: string);
    resetIgnoreCache(): void;
    get ignoreCacheInput(): string | undefined;
    get injectUrl(): string[];
    private _keyValuePairs;
    get keyValuePairs(): cdktf.StringMap;
    get password(): string;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    get username(): string;
    get value(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
